from shapely.geometry import Polygon
import json
import os


def constructGeometry(facet):
    # Create a Polygon with the vertices (longitude, latitude)
    poly = Polygon([(v[0], v[1]) for v in facet])  # (lon, lat)
    return poly


def main():
    outFileDir = os.getcwd()  # Use current directory
    outFileName = "fuller_icosahedron.geojson"
    outFile = os.path.join(outFileDir, outFileName)

    # Define facets with coordinates and zoneIDs
    facets = [
        {
            "zoneID": "0",
            "coordinates": [
                [
                    [-57.699999999700196, -39.1],
                    [-58.069403689628473, -39.673636575367539],
                    [-58.444987663649727, -40.246083257736075],
                    [-58.826971571280865, -40.817295146653635],
                    [-59.2155835876124, -41.387225395535552],
                    [-59.611060814404937, -41.955825113638014],
                    [-60.013649678489799, -42.523043248247234],
                    [-60.423606364342163, -43.088826472263804],
                    [-60.841197256548128, -43.653119056499236],
                    [-61.26669939576044, -44.215862740173293],
                    [-61.700400962534331, -44.776996588821419],
                    [-62.142601773752801, -45.336456848604655],
                    [-62.59361379703904, -45.894176786229593],
                    [-63.053761682255811, -46.450086525272866],
                    [-63.523383315487536, -47.004112869913001],
                    [-64.002830380217858, -47.556179115173904],
                    [-64.492468945485427, -48.106204851772475],
                    [-64.992680056739118, -48.654105756575348],
                    [-65.503860350075058, -49.199793366870324],
                    [-66.026422666472797, -49.743174851937795],
                    [-66.560796681321676, -50.284152756744277],
                    [-67.107429530348497, -50.822624746534757],
                    [-67.666786447236689, -51.358483321747826],
                    [-68.239351379662367, -51.891615531131777],
                    [-68.825627607128354, -52.421902657881276],
                    [-69.426138334516509, -52.94921989408283],
                    [-70.041427257761711, -53.47343599717351],
                    [-70.672059096250223, -53.994412929313171],
                    [-71.318620069460565, -54.512005476071806],
                    [-71.981718318745379, -55.026060850727561],
                    [-72.661984242778487, -55.536418277881182],
                    [-73.36007074037235, -56.042908555485326],
                    [-74.076653335483002, -56.545353609681229],
                    [-74.812430156526432, -57.04356601905647],
                    [-75.568121748419912, -57.537348534407272],
                    [-76.344470681376777, -58.026493577816325],
                    [-77.142240929475236, -58.510782730038841],
                    [-77.962216963242213, -58.989986212493648],
                    [-78.805202534669206, -59.463862356662332],
                    [-79.672019087211083, -59.932157077087425],
                    [-80.563503749398478, -60.394603344368761],
                    [-81.48050684191719, -60.850920668953677],
                    [-82.423888857684574, -61.300814602012224],
                    [-83.394516819595538, -61.74397626149522],
                    [-84.39325996917222, -62.180081895962701],
                    [-85.420984706079253, -62.608792498774733],
                    [-86.478548702960211, -63.029753478040561],
                    [-87.566794128146455, -63.442594416499105],
                    [-88.686539904293113, -63.846928915936701],
                    [-89.838572952579682, -64.242354569307849],
                    [-91.023638359522636, -64.628453064157497],
                    [-92.242428443917504, -65.004790449719451],
                    [-93.49557071041994, -65.370917598268477],
                    [-94.783614703255864, -65.726370872417704],
                    [-96.1070178176181, -66.070673039728888],
                    [-97.466130160478428, -66.403334459817415],
                    [-98.861178606507451, -66.723854561938424],
                    [-100.29225025234723, -67.031723646329169],
                    [-101.759275534538176, -67.326425025494473],
                    [-103.262011341150412, -67.607437522523583],
                    [-104.8000245227135, -67.874238339028068],
                    [-106.372676268295095, -68.126306280110725],
                    [-107.979107877326669, -68.363125339962437],
                    [-109.618228501843817, -68.584188622007275],
                    [-111.288705467982879, -68.789002544132074],
                    [-112.988957790069946, -68.977091300223265],
                    [-114.717153466359321, -69.148001489876833],
                    [-116.471211089719986, -69.301306845234706],
                    [-118.248806216633568, -69.436612965915629],
                    [-120.047382787685422, -69.553561938832388],
                    [-121.864169755129979, -69.651836749366453],
                    [-123.696202854577962, -69.731165349900891],
                    [-125.5403512609019, -69.791324286786391],
                    [-127.393348631933748, -69.832141761632954],
                    [-129.25182786726225, -69.853500042393023],
                    [-131.112358688202789, -69.855337145093131],
                    [-132.971487020009931, -69.837647725961745],
                    [-134.825775063868093, -69.800483159670023],
                    [-136.671840895840603, -69.743950796491958],
                    [-138.506396470420725, -69.668212427161734],
                    [-140.326282977377446, -69.573482006689176],
                    [-142.128502647179346, -69.460022700986769],
                    [-143.91024627384644, -69.328143366922802],
                    [-145.668915931824699, -69.178194552136802],
                    [-147.402142581115186, -69.010564142321186],
                    [-149.107798466226228, -68.825672770182166],
                    [-150.784004409675674, -68.623969095797065],
                    [-152.429132293220675, -68.405925068087356],
                    [-154.04180312611328, -68.1720312717257],
                    [-155.620881222890034, -67.922792429626838],
                    [-157.165465083346902, -67.658723141959342],
                    [-158.674875571850066, -67.380343911142518],
                    [-160.148642011119819, -67.088177493296655],
                    [-161.58648678493708, -66.782745599529676],
                    [-162.988308968683924, -66.464565962349241],
                    [-164.35416748504133, -66.134149770795261],
                    [-165.684264195835908, -65.791999460806437],
                    [-166.97892726548082, -65.438606851824716],
                    [-168.238595091889891, -65.074451607155879],
                    [-169.463801000003997, -64.69999999980007],
                    [-168.262723781938433, -64.321277367928019],
                    [-167.094626283138098, -63.932990727070091],
                    [-165.958819998771958, -63.535562726019407],
                    [-164.854568104067283, -63.129400702790065],
                    [-163.781095672113651, -62.714896464200024],
                    [-162.737598849103676, -62.292426217847776],
                    [-161.72325302695279, -61.862350630088656],
                    [-160.73722005083232, -61.425014990124737],
                    [-159.778654537038506, -60.98074946695715],
                    [-158.846709344780152, -60.52986943516305],
                    [-157.940540285902699, -60.072675859001777],
                    [-157.059310137926246, -59.609455722201744],
                    [-156.202192022821833, -59.140482491186901],
                    [-155.368372217201909, -58.666016595094788],
                    [-154.557052461200925, -58.186305932936136],
                    [-153.767451825820586, -57.701586377854539],
                    [-152.998808176028206, -57.212082290882392],
                    [-152.250379303031082, -56.718007028050863],
                    [-151.521443753213134, -56.219563443249001],
                    [-150.811301400219605, -55.716944383038367],
                    [-150.119273798123459, -55.210333161972926],
                    [-149.444704343865141, -54.699904036171063],
                    [-148.786958284798544, -54.18582265079732],
                    [-148.14542259088995, -53.668246474097657],
                    [-147.519505717007576, -53.147325222840323],
                    [-146.90863727004691, -52.623201252217882],
                    [-146.312267610230919, -52.096009950049506],
                    [-145.729867384785962, -51.565880094995123],
                    [-145.160927022082092, -51.032934207073879],
                    [-144.604956184989902, -50.497288882887801],
                    [-144.061483204842972, -49.959055103804985],
                    [-143.5300544891615, -49.418338540945342],
                    [-143.010233927976628, -48.875239837874005],
                    [-142.50160228900711, -48.329854873801651],
                    [-142.003756612188852, -47.782275025935803],
                    [-141.516309612099292, -47.232587402943125],
                    [-141.038889083182255, -46.680875075961865],
                    [-140.571137316966713, -46.127217294071272],
                    [-140.112710527134482, -45.571689685065337],
                    [-139.663278297077795, -45.014364447180583],
                    [-139.222523030056834, -44.455310535226317],
                    [-138.790139421798415, -43.894593823922833],
                    [-138.365833950937997, -43.332277275937656],
                    [-137.949324382906866, -42.768421091130165],
                    [-137.540339290162933, -42.203082852845625],
                    [-137.138617594913001, -41.636317658966391],
                    [-136.743908119132072, -41.068178257010345],
                    [-136.355969165222234, -40.498715160987786],
                    [-135.97456810016871, -39.927976766007419],
                    [-135.599480965886926, -39.356009457185166],
                    [-135.23049209706619, -38.782857712906491],
                    [-134.867393764755263, -38.208564197989517],
                    [-134.509985824842943, -37.633169859950442],
                    [-134.158075391033151, -37.056714008922199],
                    [-133.811476511865692, -36.479234404821909],
                    [-133.470009869030036, -35.900767329774226],
                    [-133.133502490073795, -35.321347663881681],
                    [-132.801787464209895, -34.74100895389995],
                    [-132.474703681014944, -34.15978347711274],
                    [-132.152095573225893, -33.57770230485869],
                    [-131.833812877780986, -32.994795358759404],
                    [-131.519710398857967, -32.411091469997587],
                    [-131.209647790756492, -31.826618425249819],
                    [-130.903489342779494, -31.241403026814055],
                    [-130.60110377615905, -30.65547112609562],
                    [-130.302364055178316, -30.068847683986576],
                    [-130.0071471938939, -29.481556798103725],
                    [-129.715334086149483, -28.893621757868857],
                    [-129.426809334791471, -28.305065068049146],
                    [-129.141461083830904, -27.715908500038495],
                    [-128.859180873249159, -27.126173114948585],
                    [-128.579863484156078, -26.535879301993987],
                    [-128.303406797092862, -25.945046809781161],
                    [-128.029711659082807, -25.353694773197446],
                    [-127.758681751030906, -24.761841748148981],
                    [-127.490223465070301, -24.169505729852801],
                    [-127.224245782908213, -23.576704186974268],
                    [-126.960660164967237, -22.983454082070011],
                    [-126.699380435879164, -22.389771894228659],
                    [-126.44032268212294, -21.795673645161116],
                    [-126.183405150813542, -21.201174919043581],
                    [-125.928548151038058, -20.606290881009613],
                    [-125.675673964090947, -20.01103630084225],
                    [-125.424706748158826, -19.415425569017259],
                    [-125.175572456951613, -18.819472714796973],
                    [-124.928198755833932, -18.223191424072411],
                    [-124.68251493805684, -17.626595058007695],
                    [-124.438451855184383, -17.02969666613393],
                    [-124.195941835123733, -16.432509001144581],
                    [-123.954918613951349, -15.835044536837927],
                    [-123.715317269138211, -15.237315480862321],
                    [-123.477074147176893, -14.639333785212841],
                    [-123.240126804804163, -14.041111168022894],
                    [-123.004413941225039, -13.442659113913464],
                    [-122.769875342936302, -12.843988896835015],
                    [-122.536451818098385, -12.24511158711482],
                    [-122.304085148005527, -11.646038062903074],
                    [-122.072718024908397, -11.04677902421605],
                    [-121.842293999980882, -10.447344999743109],
                    [-121.332907570827672, -10.847287533892484],
                    [-120.822158098617251, -11.246390799295853],
                    [-120.309993333625414, -11.644620750147396],
                    [-119.796360928114325, -12.041943059324694],
                    [-119.281208445313382, -12.438323106526127],
                    [-118.764483354922788, -12.833725965680742],
                    [-118.246133039408221, -13.228116397753467],
                    [-117.726104801195561, -13.621458839953448],
                    [-117.204345862671346, -14.01371739584107],
                    [-116.680803373376875, -14.404855823637263],
                    [-116.155424418102314, -14.794837529928031],
                    [-115.628156023181873, -15.183625556174377],
                    [-115.098945165486953, -15.571182570619101],
                    [-114.567738778721605, -15.957470859292698],
                    [-114.034483768710913, -16.34245231432277],
                    [-113.499127019696175, -16.726088427638729],
                    [-112.961615409623448, -17.108340279280412],
                    [-112.421895823633236, -17.489168529304095],
                    [-111.879915167550905, -17.868533406991048],
                    [-111.335620383174103, -18.24639470724992],
                    [-110.788958468058809, -18.622711773529431],
                    [-110.239876490807319, -18.997443498718383],
                    [-109.688321614450899, -19.370548310755908],
                    [-109.134241113536518, -19.741984166336181],
                    [-108.577582402006215, -20.111708544613577],
                    [-108.018293050283944, -20.479678437309929],
                    [-107.456320819450241, -20.845850344217922],
                    [-106.891613682825096, -21.210180266905752],
                    [-106.324119855646813, -21.572623698824543],
                    [-105.753787829244914, -21.933135622610791],
                    [-105.18056639981944, -22.29167050289135],
                    [-104.604404706212108, -22.64818228358547],
                    [-104.025252261382718, -23.002624379811209],
                    [-103.443058997374806, -23.354949676985939],
                    [-102.857775298591093, -23.705110525430371],
                    [-102.269352049457439, -24.053058738569803],
                    [-101.67774067489222, -24.398745590236729],
                    [-101.082893187970171, -24.742121811972027],
                    [-100.484762239385759, -25.083137593924789],
                    [-99.883301166015883, -25.421742583053685],
                    [-99.278464043081044, -25.75788588402628],
                    [-98.670205743500219, -26.091516061916707],
                    [-98.058481989152426, -26.422581142205843],
                    [-97.443249412929958, -26.751028614378981],
                    [-96.824465622590367, -27.076805438220333],
                    [-96.202089258312583, -27.399858044712971],
                    [-95.576080066441818, -27.720132346830269],
                    [-94.946398959744158, -28.037573743133692],
                    [-94.313008094747659, -28.352127125866048],
                    [-93.675870938293087, -28.663736893542705],
                    [-93.034952346673379, -28.972346958145522],
                    [-92.390218639378588, -29.27790076041174],
                    [-91.741637679135522, -29.580341278826893],
                    [-91.089178951047643, -29.879611048511038],
                    [-90.432813646232773, -30.175652173808714],
                    [-89.772514745459034, -30.468406348973758],
                    [-89.108257104581639, -30.757814873457562],
                    [-88.440017540876738, -31.043818676190881],
                    [-87.767774922074921, -31.32635833357017],
                    [-87.091510257192567, -31.605374097336664],
                    [-86.411206784665353, -31.880805917958639],
                    [-85.726850063179825, -32.15259347071202],
                    [-85.038428068800215, -32.420676186256912],
                    [-84.345931280404216, -32.684993280315609],
                    [-83.64935277590979, -32.945483787846513],
                    [-82.948688324906186, -33.202086592722026],
                    [-82.243936477686248, -33.454740469097317],
                    [-81.535098658776064, -33.703384116483676],
                    [-80.822179256867116, -33.947956199319094],
                    [-80.105185711151591, -34.18839538833646],
                    [-79.384128601253906, -34.42464040553017],
                    [-78.659021730868119, -34.656630066424327],
                    [-77.929882210495578, -34.884303332232889],
                    [-77.19673053568556, -35.107599352128318],
                    [-76.459590667075588, -35.326457518099858],
                    [-75.718490100537679, -35.54081751531595],
                    [-74.973459935527501, -35.75061937608325],
                    [-74.224534943432843, -35.955803537403256],
                    [-73.471753622431663, -36.156310893133195],
                    [-72.715158254150083, -36.352082858736821],
                    [-71.954794953124576, -36.543061424345183],
                    [-71.190713707271698, -36.72918922040617],
                    [-70.422968413861156, -36.910409578838937],
                    [-69.651616910092287, -37.086666592389292],
                    [-68.876720992879427, -37.257905185675725],
                    [-68.098346431442565, -37.424071172746324],
                    [-67.316562975400927, -37.585111328125208],
                    [-66.531444350276502, -37.740973449764795],
                    [-65.743068244004235, -37.891606424696647],
                    [-64.95151628984479, -38.036960298279098],
                    [-64.156874030412098, -38.176986336250366],
                    [-63.359230880800453, -38.311637095775325],
                    [-62.558680079122325, -38.44086648749834],
                    [-61.755318621756885, -38.564629841194119],
                    [-60.949247198599323, -38.682883972317427],
                    [-60.140570108523605, -38.795587241358078],
                    [-59.329395170350779, -38.902699620391104],
                    [-58.515833619425905, -39.004182749734014],
                    [-57.699999999700196, -39.1],
                ]
            ],
        },
        {
            "zoneID": "1",
            "coordinates": [
                [
                    [36.521509999989973, -50.103200999794694],
                    [35.651289362414275, -50.421156470994276],
                    [34.769428859854031, -50.732534218978969],
                    [33.875894601354958, -51.037172470033397],
                    [32.970668583388601, -51.334907953139407],
                    [32.053749751050248, -51.62557613283218],
                    [31.125155049366072, -51.90901145741276],
                    [30.184920471902331, -52.185047635040291],
                    [29.233102099482494, -52.453517926910763],
                    [28.269777101132377, -52.714255462919255],
                    [27.295044715241488, -52.967093582502798],
                    [26.309027173165646, -53.211866195268669],
                    [25.311870570670351, -53.448408159608846],
                    [24.303745669227339, -53.676555686495703],
                    [23.284848613672693, -53.896146760364616],
                    [22.255401559034794, -54.107021574386067],
                    [21.215653181349353, -54.309022987320986],
                    [20.165879083253117, -54.501996989369445],
                    [19.106382050291415, -54.685793179711368],
                    [18.037492175923205, -54.860265258434879],
                    [16.959566829145956, -55.02527151576777],
                    [15.872990453047009, -55.180675333899501],
                    [14.778174198780334, -55.326345677111249],
                    [13.675555371583187, -55.462157587302784],
                    [12.565596702326047, -55.587992669625976],
                    [11.448785424807625, -55.703739556535254],
                    [10.325632167790445, -55.809294371837723],
                    [9.196669667171591, -55.904561160569017],
                    [8.062451288396346, -55.98945230358089],
                    [6.923549381598662, -56.063888897954257],
                    [5.780553472165082, -56.12780111133219],
                    [4.634068297514091, -56.181128494884035],
                    [3.484711706280393, -56.223820264793346],
                    [2.333112442385357, -56.255835532483786],
                    [1.179907820289714, -56.277143501571231],
                    [0.02574132740034, -56.287723609956572],
                    [-1.12873983737353, -56.287565629650032],
                    [-2.282887260138921, -56.276669712637101],
                    [-3.436053814831666, -56.255046393576094],
                    [-4.58759616333225, -56.222716535839425],
                    [-5.736877207017358, -56.179711236184573],
                    [-6.883268490648277, -56.126071676366735],
                    [-8.026152519922789, -56.061848927985579],
                    [-9.16492497560705, -55.987103721359631],
                    [-10.298996809854827, -55.901906159541568],
                    [-11.427796207628774, -55.806335406253936],
                    [-12.550770385344947, -55.700479332455131],
                    [-13.667387239329571, -55.584434132329307],
                    [-14.77713681081508, -55.458303908698383],
                    [-15.879532571970515, -55.322200241348014],
                    [-16.9741125284703, -55.176241726574403],
                    [-18.060440133205475, -55.0205535077381],
                    [-19.138105014734606, -54.855266790529924],
                    [-20.206723522272625, -54.680518352839613],
                    [-21.26593908811833, -54.49645004293501],
                    [-22.315422421907215, -54.303208291129692],
                    [-23.354871538490613, -54.100943608860348],
                    [-24.384011634729063, -53.889810106651055],
                    [-25.402594817896443, -53.669965010276883],
                    [-26.410399709079286, -53.441568197614174],
                    [-27.407230917972413, -53.204781743582544],
                    [-28.39291842054854, -52.959769483075149],
                    [-29.367316834204473, -52.706696588276827],
                    [-30.330304616464787, -52.445729175660858],
                    [-31.281783192640205, -52.177033914783294],
                    [-32.221676026827083, -51.900777675749111],
                    [-33.149927645244532, -51.617127191066913],
                    [-34.066502628993021, -51.326248734591331],
                    [-34.971384577136462, -51.028307830142182],
                    [-35.864575058991761, -50.723468979909399],
                    [-36.746092560123429, -50.411895414441801],
                    [-37.615971423842097, -50.09374886152068],
                    [-38.474260807989879, -49.76918933841722],
                    [-39.321023655217459, -49.438374966631329],
                    [-40.156335679447977, -49.101461800121911],
                    [-40.980284381119191, -48.758603679616044],
                    [-41.792968090305067, -48.409952097711027],
                    [-42.594495038615094, -48.055656084660484],
                    [-43.384982473362413, -47.695862113046019],
                    [-44.164555796912396, -47.330714009643714],
                    [-44.933347755494481, -46.960352889773958],
                    [-45.69149766218726, -46.584917099744246],
                    [-46.439150657676691, -46.204542171883702],
                    [-47.176457013280469, -45.819360794864679],
                    [-47.903571476242519, -45.429502790321465],
                    [-48.62065265189824, -45.035095099359296],
                    [-49.32786242001464, -44.636261781655776],
                    [-50.025365402391344, -44.23312401636025],
                    [-50.713328450247673, -43.825800118280711],
                    [-51.391920182870024, -43.414405550475749],
                    [-52.06131055054135, -42.999052953930629],
                    [-52.721670434343025, -42.579852170940853],
                    [-53.37317128102967, -42.156910283782452],
                    [-54.015984757690319, -41.730331651584436],
                    [-54.650282446877384, -41.300217948099714],
                    [-55.276235564219803, -40.866668210269665],
                    [-55.89401469941879, -40.429778883188874],
                    [-56.503789583322487, -39.989643870468171],
                    [-57.105728881082939, -39.546354584596372],
                    [-57.699999999700196, -39.1],
                    [-56.971752116666835, -38.800304658533094],
                    [-56.249649350636957, -38.496127198511374],
                    [-55.533662410691647, -38.187553620303277],
                    [-54.823757890614047, -37.874669193128739],
                    [-54.119898499116402, -37.55755840919312],
                    [-53.422043273877875, -37.236304939621164],
                    [-52.730147804577427, -36.910991597584143],
                    [-52.044164434341099, -36.581700299629063],
                    [-51.364042474680389, -36.248512035102237],
                    [-50.689728394349856, -35.911506840068569],
                    [-50.021166021694455, -35.57076376763365],
                    [-49.358296722715465, -35.226360870857434],
                    [-48.701059587230077, -34.878375182968227],
                    [-48.049391600641798, -34.526882696679024],
                    [-47.403227809415796, -34.17195835789181],
                    [-46.762501480259061, -33.813676050409356],
                    [-46.12714425840079, -33.452108588740316],
                    [-45.497086308786038, -33.087327713603031],
                    [-44.872256459967559, -32.719404085629947],
                    [-44.252582333607791, -32.348407285367841],
                    [-43.637990476679136, -31.974405812378279],
                    [-43.028406476577572, -31.597467086136987],
                    [-42.423755078933709, -31.21765745232949],
                    [-41.823960295531151, -30.835042185548389],
                    [-41.228945504131616, -30.449685495589051],
                    [-40.638633547400218, -30.0616505346444],
                    [-40.052946824636194, -29.670999409894819],
                    [-39.471807370913325, -29.277793186206509],
                    [-38.895136945213835, -28.882091904118056],
                    [-38.322857101473971, -28.483954587933852],
                    [-37.754889256933609, -28.083439258315082],
                    [-37.191154759584435, -27.680602947567877],
                    [-36.631574950223751, -27.275501712234131],
                    [-36.076071216413425, -26.868190647480276],
                    [-35.524565044641008, -26.458723901486735],
                    [-34.976978070681355, -26.047154696132282],
                    [-34.433232120965556, -25.633535334188252],
                    [-33.893249256647834, -25.21791722629888],
                    [-33.356951809578334, -24.800350897276019],
                    [-32.824262413779309, -24.380886012179701],
                    [-32.295104039619673, -23.959571386210428],
                    [-31.769400020794308, -23.536455008092105],
                    [-31.247074077706429, -23.111584053561103],
                    [-30.728050341749849, -22.685004904252821],
                    [-30.212253373294516, -22.256763167486099],
                    [-29.699608180572966, -21.826903690652728],
                    [-29.19004023317018, -21.395470581002428],
                    [-28.683475474613431, -20.962507224528736],
                    [-28.179840336762084, -20.528056300357946],
                    [-27.679061743404645, -20.092159803232278],
                    [-27.181067121950093, -19.65485905699984],
                    [-26.685784405226002, -19.2161947352987],
                    [-26.193142036875429, -18.776206877745096],
                    [-25.703068974953169, -18.334934906120907],
                    [-25.215494690127741, -17.892417645058174],
                    [-24.730349166580652, -17.44869333822686],
                    [-24.247562901106903, -17.003799661824871],
                    [-23.767066895920436, -16.557773747060651],
                    [-23.288792662251467, -16.110652194543036],
                    [-22.812672208655385, -15.662471088669747],
                    [-22.338638036516045, -15.213266019211346],
                    [-21.866623136448482, -14.7630720921033],
                    [-21.396560975708439, -14.311923951928804],
                    [-20.928385494594806, -13.859855790911922],
                    [-20.462031092061181, -13.406901372300467],
                    [-19.997432622117742, -12.953094039358348],
                    [-19.534525375845305, -12.49846673515168],
                    [-19.073245076898729, -12.043052016936997],
                    [-18.613527868016661, -11.586882072349738],
                    [-18.155310295733443, -11.129988731994274],
                    [-17.698529301386088, -10.672403486531607],
                    [-17.243122208523005, -10.214157500168426],
                    [-16.789026704918456, -9.755281629543447],
                    [-16.336180835377206, -9.295806430022708],
                    [-15.88452298015136, -8.8357621790812],
                    [-15.43399184774546, -8.37517888439794],
                    [-14.984526456031006, -7.914086301841337],
                    [-14.53606611875631, -7.452513946261547],
                    [-14.088550427560108, -6.990491107678451],
                    [-13.641919241179949, -6.528046863871623],
                    [-13.19611266656625, -6.065210096568592],
                    [-12.751071044493074, -5.602009500437987],
                    [-12.306734932471045, -5.138473601975079],
                    [-11.863045089459263, -4.674630767595829],
                    [-11.41994245967669, -4.210509222522546],
                    [-10.977368155515876, -3.746137058878105],
                    [-10.535263441354687, -3.281542251873361],
                    [-10.093569717368496, -2.816752672397854],
                    [-9.652228503342656, -2.351796101408922],
                    [-9.211181420685989, -1.886700238025469],
                    [-8.770370175343203, -1.421492720212768],
                    [-8.329736543406625, -0.956201130177988],
                    [-7.889222351330375, -0.490853013255901],
                    [-7.44876946064204, -0.025475886902541],
                    [-7.008319751755039, 0.439902745815118],
                    [-6.567815105083014, 0.905255380031861],
                    [-6.127197384851399, 1.370554500090179],
                    [-5.686408422011027, 1.835772566950538],
                    [-5.245389999848555, 2.300882000204297],
                    [-4.939182858102356, 1.737921992705878],
                    [-4.633158249053906, 1.174912407381839],
                    [-4.327256968534186, 0.611869326808062],
                    [-4.021419890615391, 0.048808810178514],
                    [-3.715587934335588, -0.514253096802918],
                    [-3.409702018733128, -1.077300350230928],
                    [-3.103703031369719, -1.640316894508942],
                    [-2.79753178246574, -2.203286651557619],
                    [-2.491128968926716, -2.766193507324431],
                    [-2.184435136572233, -3.329021303690126],
                    [-1.8773906369683, -3.891753820482393],
                    [-1.569935593252978, -4.45437476738158],
                    [-1.262009853371922, -5.016867771330453],
                    [-0.953552955904172, -5.579216363044679],
                    [-0.644504088692713, -6.141403964421386],
                    [-0.334802045677804, -6.703413876848913],
                    [-0.024385185527819, -7.26522926681713],
                    [0.286808605232977, -7.826833155125939],
                    [0.598841959888659, -8.38820840159633],
                    [0.911778072000459, -8.949337692480469],
                    [1.22568073857525, -9.510203527870431],
                    [1.540614404131532, -10.070788203712596],
                    [1.856644204766269, -10.631073803712979],
                    [2.173836016718838, -11.191042178653561],
                    [2.492256497739163, -11.750674935599761],
                    [2.811973137450479, -12.309953421712919],
                    [3.133054304112989, -12.868858707163554],
                    [3.455569294087809, -13.427371569842023],
                    [3.779588380399503, -13.985472481869465],
                    [4.105182864897358, -14.543141587114519],
                    [4.432425128616899, -15.100358688602569],
                    [4.761388686638725, -15.657103228730932],
                    [5.09214824024906, -16.213354270383206],
                    [5.424779734497292, -16.769090479841736],
                    [5.759360411254079, -17.32429010610349],
                    [6.095968873065203, -17.878930959296213],
                    [6.434685136210192, -18.432990394491014],
                    [6.775590693655658, -18.986445283822661],
                    [7.118768578906895, -19.539272001201823],
                    [7.464303428960136, -20.091446392636783],
                    [7.812281547255623, -20.642943759147101],
                    [8.162790972025789, -21.193738827085099],
                    [8.515921547341634, -21.743805723854962],
                    [8.871764986065386, -22.293117956328558],
                    [9.230414951688715, -22.841648374872534],
                    [9.591967121285677, -23.389369153563564],
                    [9.956519268249622, -23.936251756013633],
                    [10.324171337837072, -24.482266905693109],
                    [10.695025522709841, -25.027384558050812],
                    [11.069186347472112, -25.571573861844172],
                    [11.446760751407624, -26.114803130360144],
                    [11.827858167620491, -26.657039802744578],
                    [12.212590615664396, -27.198250409828461],
                    [12.601072786979614, -27.738400535456321],
                    [12.993422132125772, -28.277454776017066],
                    [13.389758957010258, -28.815376703571985],
                    [13.790206514619001, -29.352128814593073],
                    [14.194891095847481, -29.88767249758763],
                    [14.60394213292318, -30.42196797644084],
                    [15.017492291136364, -30.954974269946547],
                    [15.435677571362874, -31.486649137847394],
                    [15.858637409888729, -32.016949033171215],
                    [16.286514778234505, -32.545829044674633],
                    [16.71945628657852, -33.073242845580808],
                    [17.157612287177358, -33.599142633325812],
                    [17.601136973292853, -34.123479069303585],
                    [18.050188488008416, -34.646201217711905],
                    [18.504929022256761, -35.167256481701202],
                    [18.965524914643254, -35.686590536823758],
                    [19.432146757566841, -36.204147259088643],
                    [19.904969490749465, -36.71986865661313],
                    [20.384172500160844, -37.233694789582842],
                    [20.869939707052026, -37.745563701003903],
                    [21.362459661484309, -38.255411331267851],
                    [21.861925623268917, -38.763171435413312],
                    [22.368535641106973, -39.268775500388927],
                    [22.882492628132354, -39.772152656919559],
                    [23.404004421267189, -40.273229585976594],
                    [23.933283839677586, -40.771930426148231],
                    [24.470548728840924, -41.268176679210285],
                    [25.016021992920741, -41.761887107603911],
                    [25.569931615451821, -42.252977633710771],
                    [26.132510662936852, -42.741361235532565],
                    [26.703997269558386, -43.226947840570347],
                    [27.28463460480333, -43.709644212510341],
                    [27.87467082040223, -44.189353846003087],
                    [28.474358964894407, -44.665976845255102],
                    [29.083956882903976, -45.139409815210684],
                    [29.703727069448746, -45.609545741043007],
                    [30.333936503566918, -46.076273871242108],
                    [30.974856436075697, -46.539479599803656],
                    [31.626762139561265, -46.9990443466192],
                    [32.289932612500081, -47.454845439665235],
                    [32.964650233021928, -47.906755997191397],
                    [33.651200361407746, -48.354644814406583],
                    [34.349870879637535, -48.798376248365059],
                    [35.060951671582472, -49.237810110048429],
                    [35.784734032149913, -49.672801557345963],
                    [36.521509999989973, -50.103200999794694],
                ]
            ],
        },
        {
            "zoneID": "2",
            "coordinates": [
                [
                    [36.521509999989973, -50.103200999794694],
                    [35.784734032149913, -49.672801557345963],
                    [35.060951671582472, -49.237810110048429],
                    [34.349870879637535, -48.798376248365059],
                    [33.651200361407746, -48.354644814406583],
                    [32.964650233021928, -47.906755997191397],
                    [32.289932612500081, -47.454845439665235],
                    [31.626762139561265, -46.9990443466192],
                    [30.974856436075697, -46.539479599803656],
                    [30.333936503566918, -46.076273871242108],
                    [29.703727069448746, -45.609545741043007],
                    [29.083956882903976, -45.139409815210684],
                    [28.474358964894407, -44.665976845255102],
                    [27.87467082040223, -44.189353846003087],
                    [27.28463460480333, -43.709644212510341],
                    [26.703997269558386, -43.226947840570347],
                    [26.132510662936852, -42.741361235532565],
                    [25.569931615451821, -42.252977633710771],
                    [25.016021992920741, -41.761887107603911],
                    [24.470548728840924, -41.268176679210285],
                    [23.933283839677586, -40.771930426148231],
                    [23.404004421267189, -40.273229585976594],
                    [22.882492628132354, -39.772152656919559],
                    [22.368535641106973, -39.268775500388927],
                    [21.861925623268917, -38.763171435413312],
                    [21.362459661484309, -38.255411331267851],
                    [20.869939707052026, -37.745563701003903],
                    [20.384172500160844, -37.233694789582842],
                    [19.904969490749465, -36.71986865661313],
                    [19.432146757566841, -36.204147259088643],
                    [18.965524914643254, -35.686590536823758],
                    [18.504929022256761, -35.167256481701202],
                    [18.050188488008416, -34.646201217711905],
                    [17.601136973292853, -34.123479069303585],
                    [17.157612287177358, -33.599142633325812],
                    [16.71945628657852, -33.073242845580808],
                    [16.286514778234505, -32.545829044674633],
                    [15.858637409888729, -32.016949033171215],
                    [15.435677571362874, -31.486649137847394],
                    [15.017492291136364, -30.954974269946547],
                    [14.60394213292318, -30.42196797644084],
                    [14.194891095847481, -29.88767249758763],
                    [13.790206514619001, -29.352128814593073],
                    [13.389758957010258, -28.815376703571985],
                    [12.993422132125772, -28.277454776017066],
                    [12.601072786979614, -27.738400535456321],
                    [12.212590615664396, -27.198250409828461],
                    [11.827858167620491, -26.657039802744578],
                    [11.446760751407624, -26.114803130360144],
                    [11.069186347472112, -25.571573861844172],
                    [10.695025522709841, -25.027384558050812],
                    [10.324171337837072, -24.482266905693109],
                    [9.956519268249622, -23.936251756013633],
                    [9.591967121285677, -23.389369153563564],
                    [9.230414951688715, -22.841648374872534],
                    [8.871764986065386, -22.293117956328558],
                    [8.515921547341634, -21.743805723854962],
                    [8.162790972025789, -21.193738827085099],
                    [7.812281547255623, -20.642943759147101],
                    [7.464303428960136, -20.091446392636783],
                    [7.118768578906895, -19.539272001201823],
                    [6.775590693655658, -18.986445283822661],
                    [6.434685136210192, -18.432990394491014],
                    [6.095968873065203, -17.878930959296213],
                    [5.759360411254079, -17.32429010610349],
                    [5.424779734497292, -16.769090479841736],
                    [5.09214824024906, -16.213354270383206],
                    [4.761388686638725, -15.657103228730932],
                    [4.432425128616899, -15.100358688602569],
                    [4.105182864897358, -14.543141587114519],
                    [3.779588380399503, -13.985472481869465],
                    [3.455569294087809, -13.427371569842023],
                    [3.133054304112989, -12.868858707163554],
                    [2.811973137450479, -12.309953421712919],
                    [2.492256497739163, -11.750674935599761],
                    [2.173836016718838, -11.191042178653561],
                    [1.856644204766269, -10.631073803712979],
                    [1.540614404131532, -10.070788203712596],
                    [1.22568073857525, -9.510203527870431],
                    [0.911778072000459, -8.949337692480469],
                    [0.598841959888659, -8.38820840159633],
                    [0.286808605232977, -7.826833155125939],
                    [-0.024385185527819, -7.26522926681713],
                    [-0.334802045677804, -6.703413876848913],
                    [-0.644504088692713, -6.141403964421386],
                    [-0.953552955904172, -5.579216363044679],
                    [-1.262009853371922, -5.016867771330453],
                    [-1.569935593252978, -4.45437476738158],
                    [-1.8773906369683, -3.891753820482393],
                    [-2.184435136572233, -3.329021303690126],
                    [-2.491128968926716, -2.766193507324431],
                    [-2.79753178246574, -2.203286651557619],
                    [-3.103703031369719, -1.640316894508942],
                    [-3.409702018733128, -1.077300350230928],
                    [-3.715587934335588, -0.514253096802918],
                    [-4.021419890615391, 0.048808810178514],
                    [-4.327256968534186, 0.611869326808062],
                    [-4.633158249053906, 1.174912407381839],
                    [-4.939182858102356, 1.737921992705878],
                    [-5.245389999848555, 2.300882000204297],
                    [-4.614869761829993, 2.417876607419601],
                    [-3.984240924379037, 2.534578704743581],
                    [-3.353498511547002, 2.65097410087418],
                    [-2.722637597746882, 2.767048631489331],
                    [-2.091653311351138, 2.882788163742816],
                    [-1.460540837389601, 2.998178591768635],
                    [-0.829295420247377, 3.113205841176807],
                    [-0.197912361865917, 3.227855870851783],
                    [0.433612970162471, 3.342114673853189],
                    [1.065285143494634, 3.455968276514795],
                    [1.697108661035998, 3.569402745640332],
                    [2.329087953746125, 3.682404181308073],
                    [2.961227382437926, 3.794958726763866],
                    [3.593531234179238, 3.907052565723461],
                    [4.226003719596122, 4.018671921472048],
                    [4.85864897287189, 4.129803064060297],
                    [5.491471046351819, 4.240432307604976],
                    [6.124473913240593, 4.350546012988275],
                    [6.757661460408258, 4.46013058875576],
                    [7.391037490188069, 4.569172494714962],
                    [8.024605718579153, 4.677658239236393],
                    [8.658369768949683, 4.7855743864489],
                    [9.29233317563552, 4.892907552641532],
                    [9.926499378543667, 4.999644408962467],
                    [10.560871724050969, 5.10577168681408],
                    [11.195453458710119, 5.211276174256227],
                    [11.830247733746091, 5.316144718703924],
                    [12.465257598759365, 5.420364233222813],
                    [13.100486000828312, 5.523921691133239],
                    [13.735935784508911, 5.626804132304983],
                    [14.37160968823656, 5.728998662258618],
                    [15.007510346125741, 5.830492456661716],
                    [15.643640281673811, 5.931272760429579],
                    [16.280001910459816, 6.031326888625131],
                    [16.916597535647838, 6.130642232753019],
                    [17.553429348885402, 6.229206256263751],
                    [18.190499429405179, 6.32700650084945],
                    [18.827809739527879, 6.424030586442598],
                    [19.465362127360436, 6.520266213015304],
                    [20.103158321399576, 6.615701162378912],
                    [20.741199935029101, 6.71032329818172],
                    [21.379488458425726, 6.804120572206671],
                    [22.018025265753579, 6.897081021671966],
                    [22.656811605271514, 6.989192771029707],
                    [23.295848606528125, 7.08044403646312],
                    [23.935137274965314, 7.170823127685367],
                    [24.574678490120277, 7.260318446139536],
                    [25.214473009222161, 7.348918489496782],
                    [25.854521463594665, 7.436611853454394],
                    [26.494824358657411, 7.523387232634775],
                    [27.135382073024289, 7.609233421485271],
                    [27.776194858506017, 7.694139319673923],
                    [28.417262840108094, 7.778093929391503],
                    [29.058586013333979, 7.861086359847604],
                    [29.70016424868129, 7.94310582907093],
                    [30.341997285346565, 8.024141662108036],
                    [30.984084734822716, 8.104183300019315],
                    [31.626426080898966, 8.183220294481032],
                    [32.269020678761478, 8.261242312282889],
                    [32.911867753194372, 8.338239138925246],
                    [33.554966403077117, 8.414200678618442],
                    [34.198315596887312, 8.489116954284157],
                    [34.841914176298246, 8.562978113849056],
                    [35.485760854379976, 8.635774426648481],
                    [36.129854215599664, 8.707496289722144],
                    [36.774192720317956, 8.778134227812416],
                    [37.418774701191694, 8.847678895164961],
                    [38.063598363174037, 8.916121076426577],
                    [38.708661788011227, 8.983451689344065],
                    [39.353962931544174, 9.049661787461616],
                    [39.999499628205456, 9.114742559221725],
                    [40.645269585622998, 9.178685331562917],
                    [41.2912703936139, 9.241481570817882],
                    [41.937499518787888, 9.303122887211657],
                    [42.583954307245676, 9.36360103126259],
                    [43.230631987276581, 9.422907898280869],
                    [43.877529671157504, 9.481035531964324],
                    [44.524644351555651, 9.537976123499334],
                    [45.171972910521504, 9.593722011561624],
                    [45.819512112294319, 9.648265688610707],
                    [46.467258611395835, 9.701599798192262],
                    [47.115208953530441, 9.753717139434571],
                    [47.763359571986769, 9.804610666149472],
                    [48.411706795732186, 9.854273490429307],
                    [49.060246848513316, 9.902698881748051],
                    [49.708975849755802, 9.949880271457516],
                    [50.357889817261366, 9.995811250988538],
                    [51.006984669007295, 10.040485575449111],
                    [51.656256227642928, 10.083897164522682],
                    [52.305700217790957, 10.126040102468778],
                    [52.955312273242953, 10.16690864351915],
                    [53.605087933361574, 10.206497206481004],
                    [54.255022653872459, 10.244800381932123],
                    [54.905111799669953, 10.281812931321781],
                    [55.555350652910363, 10.317529786070736],
                    [56.205734415710822, 10.35194605206874],
                    [56.85625821014844, 10.385057010572609],
                    [57.506917080958658, 10.416858116409117],
                    [58.157706000031965, 10.447345000671362],
                    [57.985763559540658, 9.829346821198897],
                    [57.814462630646005, 9.211262171012436],
                    [57.643760061178, 8.593096878618212],
                    [57.473613251150596, 7.974856694281186],
                    [57.303980119487051, 7.356547296320741],
                    [57.134819055455125, 6.738174299204616],
                    [56.966088884494582, 6.119743255347089],
                    [56.797748826846885, 5.501259662303539],
                    [56.629758457986497, 4.882728970865344],
                    [56.462077671747295, 4.264156584159082],
                    [56.294666642551647, 3.645547868439394],
                    [56.127485791236325, 3.02690815668609],
                    [55.960495745482376, 2.408242751302112],
                    [55.793657303841542, 1.789556931307459],
                    [55.626931404260972, 1.170855957736308],
                    [55.460279084512251, 0.552145077233547],
                    [55.293661448017474, -0.066570472549188],
                    [55.127039629675323, -0.685285460255727],
                    [54.960374762585275, -1.303994650932282],
                    [54.793627938478608, -1.922692806927387],
                    [54.626760176241135, -2.541374677998874],
                    [54.459732385940868, -3.160035001314156],
                    [54.292505334653526, -3.778668492456859],
                    [54.125039606892415, -4.397269840930392],
                    [53.957295574031548, -5.015833710157494],
                    [53.789233352037741, -5.634354724890613],
                    [53.620812771792089, -6.252827471210708],
                    [53.451993334125177, -6.871246490233261],
                    [53.282734177440432, -7.489606272711228],
                    [53.112994036345867, -8.107901251841213],
                    [52.942731203882033, -8.726125802363811],
                    [52.771903489254782, -9.344274229771827],
                    [52.600468178264009, -9.962340766712884],
                    [52.428381991036133, -10.580319569392543],
                    [52.255601038857037, -11.198204706781667],
                    [52.08208077740602, -11.81599015791943],
                    [51.907775965388623, -12.433669806516264],
                    [51.732640614173135, -13.051237429263836],
                    [51.556627940127385, -13.668686694934991],
                    [51.37969031515604, -14.286011152692481],
                    [51.201779214539215, -14.903204228492257],
                    [51.022845162974022, -15.520259214291286],
                    [50.842837679715274, -16.137169262651298],
                    [50.661705221918623, -16.753927376846946],
                    [50.479395122586993, -17.37052640456983],
                    [50.295853530316208, -17.986959028036608],
                    [50.111025344544203, -18.603217751398063],
                    [49.924854148100621, -19.219294898940404],
                    [49.737282137960335, -19.835182597998426],
                    [49.548250052398089, -20.450872771760885],
                    [49.357697090948079, -21.066357126679975],
                    [49.165560843358321, -21.681627145276423],
                    [48.971777196960261, -22.296674068153663],
                    [48.776280257527958, -22.911488885004019],
                    [48.579002252152293, -23.526062322917824],
                    [48.379873439307858, -24.140384828397032],
                    [48.1788220054313, -24.754446558361849],
                    [47.975773962398534, -25.368237357667795],
                    [47.770653036008866, -25.981746751011713],
                    [47.563380551771218, -26.594963921347869],
                    [47.353875312595676, -27.207877692801162],
                    [47.142053473788849, -27.820476512680898],
                    [46.927828405456637, -28.432748433493373],
                    [46.711110554908203, -29.044681088661264],
                    [46.491807293771785, -29.656261671838649],
                    [46.269822767806488, -30.267476917125919],
                    [46.045057726033406, -30.878313069392618],
                    [45.817409348962371, -31.488755861793493],
                    [45.586771066032043, -32.098790486991334],
                    [45.353032358656492, -32.708401570176306],
                    [45.116078559677931, -33.317573133992823],
                    [44.875790632132123, -33.926288571560235],
                    [44.632044943519361, -34.534530607801287],
                    [44.384713022987739, -35.142281264368819],
                    [44.133661305025271, -35.749521820075813],
                    [43.878750858765216, -36.356232769526571],
                    [43.619837097504103, -36.962393779049592],
                    [43.356769478328943, -37.567983640832324],
                    [43.089391176561605, -38.172980220760564],
                    [42.817538745816535, -38.777360408955644],
                    [42.541041750176817, -39.381100058620746],
                    [42.259722383781082, -39.984173927584663],
                    [41.973395057136372, -40.586555615349312],
                    [41.681865965442, -41.188217490244881],
                    [41.384932624541079, -41.789130620181879],
                    [41.08238337719115, -42.389264690812752],
                    [40.773996876854483, -42.988587922794295],
                    [40.459541526520297, -43.587066979157669],
                    [40.13877488964954, -44.184666873577271],
                    [39.811443059749593, -44.781350861552937],
                    [39.477279993976651, -45.377080332491232],
                    [39.136006796376591, -45.971814689196435],
                    [38.787330960655368, -46.565511220166627],
                    [38.430945559889778, -47.158124963796013],
                    [38.06652838947366, -47.749608558188356],
                    [37.693741043514422, -48.33991208377563],
                    [37.312227946262851, -48.928982891547093],
                    [36.921615303503586, -49.516765421387049],
                    [36.521509999989973, -50.103200999794694],
                ]
            ],
        },
        {
            "zoneID": "3",
            "coordinates": [
                [
                    [112.867673999793283, -23.717924999663467],
                    [112.37823701816194, -24.176715867021699],
                    [111.885274567383647, -24.633933371813782],
                    [111.388697546877381, -25.089532109559627],
                    [110.888415897088123, -25.543465755720035],
                    [110.384338600723197, -25.995687043061139],
                    [109.876373692396101, -26.446147734665203],
                    [109.672902895398124, -26.624462344224071],
                    [109.3644282679752, -26.89479859678886],
                    [108.84840849602773, -27.341589375874435],
                    [108.328219637063455, -27.786468767159818],
                    [107.803766059978045, -28.22938439393721],
                    [107.274951269043129, -28.67028277616447],
                    [106.741677929046716, -29.109109304125411],
                    [106.20384789508222, -29.545808216987666],
                    [105.661362254232301, -29.980322567816074],
                    [105.114121363955064, -30.412594204129391],
                    [104.562024896965738, -30.842563737213197],
                    [104.004971893919162, -31.270170516927863],
                    [103.442860822984414, -31.69535260801814],
                    [102.875589640974738, -32.118046759924937],
                    [102.303055864818305, -32.538188385842602],
                    [101.725156649180008, -32.955711536228989],
                    [101.141788870879964, -33.370548876164662],
                    [100.552849216759284, -33.782631661061089],
                    [99.958234290840153, -34.19188971306977],
                    [99.357840717037959, -34.598251405938754],
                    [98.751565258015262, -35.001643637022028],
                    [98.139304943934292, -35.401991813135737],
                    [97.520957203156172, -35.799219835863255],
                    [96.896420015235719, -36.193250078764038],
                    [96.265592062861913, -36.584003380825663],
                    [95.628372897045892, -36.971399029870668],
                    [94.984663121952963, -37.355354756858219],
                    [94.334364580830595, -37.735786724988657],
                    [93.677380555884042, -38.112609528803318],
                    [93.013615988943513, -38.485736191235958],
                    [92.342977699230801, -38.855078164762745],
                    [91.665374629168014, -39.220545334899555],
                    [90.98071809288308, -39.582046035148039],
                    [90.288922039960312, -39.939487051143146],
                    [89.589903336784971, -40.292773644793954],
                    [88.883582053834573, -40.641809567028815],
                    [88.169881771163602, -40.9864970929832],
                    [87.448729892835331, -41.326737048837856],
                    [86.720057976797364, -41.662428845007469],
                    [85.983802077851919, -41.993470524022598],
                    [85.23990309512601, -42.319758804012736],
                    [84.488307142880444, -42.641189136034825],
                    [83.728965916872028, -42.957655762801608],
                    [82.961837080858459, -43.269051786805278],
                    [82.186884659999635, -43.575269246139271],
                    [81.404079437208225, -43.876199195967956],
                    [80.613399358946822, -44.171731796942424],
                    [79.814829941874393, -44.461756414763386],
                    [79.008364688189886, -44.746161723792227],
                    [78.194005494779162, -45.024835823107196],
                    [77.371763062107902, -45.297666357758146],
                    [76.541657309768766, -45.564540647866238],
                    [75.703717765881322, -45.825345828973354],
                    [74.857983966943436, -46.079968999184871],
                    [74.004505838886985, -46.328297374062117],
                    [73.143344056941544, -46.570218451810035],
                    [72.274570403150904, -46.805620185161558],
                    [71.398268088850841, -47.034391161911287],
                    [70.514532058054044, -47.256420788894047],
                    [69.623469268895974, -47.471599491961456],
                    [68.725198938240226, -47.679818914805537],
                    [67.819852750202131, -47.880972125831477],
                    [66.907575035929824, -48.07495383222664],
                    [65.988522902905004, -48.26166059782912],
                    [65.06286632591025, -48.440991064992659],
                    [64.130788189111854, -48.612846180203348],
                    [63.192484280912595, -48.777129422192388],
                    [62.248163225176484, -48.933747027801473],
                    [61.298046375819922, -49.08260822584441],
                    [60.342367637128461, -49.22362545977353],
                    [59.381373235793376, -49.356714620041714],
                    [58.415321427071262, -49.481795262970365],
                    [57.444482145117604, -49.598790827967093],
                    [56.469136589940888, -49.707628853044412],
                    [55.489576754881796, -49.808241179843321],
                    [54.506104892063775, -49.900564150057619],
                    [53.519032925764748, -49.984538790216277],
                    [52.52868179981283, -50.060110993913611],
                    [51.535380784997699, -50.127231680848638],
                    [50.539466723805447, -50.185856950818788],
                    [49.541283231068348, -50.235948220017121],
                    [48.541179864079936, -50.277472342787235],
                    [47.539511237027114, -50.310401716133015],
                    [46.536636116182081, -50.334714368936432],
                    [45.532916482904966, -50.350394034178521],
                    [44.528716578953606, -50.35743019887218],
                    [43.524401933101501, -50.355818139847599],
                    [42.520338381905503, -50.345558939996465],
                    [41.516891087127021, -50.32665948207466],
                    [40.514423562848776, -50.299132431158228],
                    [39.513296701790864, -50.26299618686221],
                    [38.513867830818128, -50.218274828810138],
                    [37.516489782838789, -50.164998037164708],
                    [36.521509999989973, -50.103200999794694],
                    [36.921615303503586, -49.516765421387049],
                    [37.312227946262851, -48.928982891547093],
                    [37.693741043514422, -48.33991208377563],
                    [38.06652838947366, -47.749608558188356],
                    [38.430945559889778, -47.158124963796013],
                    [38.787330960655368, -46.565511220166627],
                    [39.136006796376591, -45.971814689196435],
                    [39.477279993976651, -45.377080332491232],
                    [39.811443059749593, -44.781350861552937],
                    [40.13877488964954, -44.184666873577271],
                    [40.459541526520297, -43.587066979157669],
                    [40.773996876854483, -42.988587922794295],
                    [41.08238337719115, -42.389264690812752],
                    [41.384932624541079, -41.789130620181879],
                    [41.681865965442, -41.188217490244881],
                    [41.973395057136372, -40.586555615349312],
                    [42.259722383781082, -39.984173927584663],
                    [42.541041750176817, -39.381100058620746],
                    [42.817538745816535, -38.777360408955644],
                    [43.089391176561605, -38.172980220760564],
                    [43.356769478328943, -37.567983640832324],
                    [43.619837097504103, -36.962393779049592],
                    [43.878750858765216, -36.356232769526571],
                    [44.133661305025271, -35.749521820075813],
                    [44.384713022987739, -35.142281264368819],
                    [44.632044943519361, -34.534530607801287],
                    [44.875790632132123, -33.926288571560235],
                    [45.116078559677931, -33.317573133992823],
                    [45.353032358656492, -32.708401570176306],
                    [45.586771066032043, -32.098790486991334],
                    [45.817409348962371, -31.488755861793493],
                    [46.045057726033406, -30.878313069392618],
                    [46.269822767806488, -30.267476917125919],
                    [46.491807293771785, -29.656261671838649],
                    [46.711110554908203, -29.044681088661264],
                    [46.927828405456637, -28.432748433493373],
                    [47.142053473788849, -27.820476512680898],
                    [47.353875312595676, -27.207877692801162],
                    [47.563380551771218, -26.594963921347869],
                    [47.770653036008866, -25.981746751011713],
                    [47.975773962398534, -25.368237357667795],
                    [48.1788220054313, -24.754446558361849],
                    [48.379873439307858, -24.140384828397032],
                    [48.579002252152293, -23.526062322917824],
                    [48.776280257527958, -22.911488885004019],
                    [48.971777196960261, -22.296674068153663],
                    [49.165560843358321, -21.681627145276423],
                    [49.357697090948079, -21.066357126679975],
                    [49.548250052398089, -20.450872771760885],
                    [49.737282137960335, -19.835182597998426],
                    [49.924854148100621, -19.219294898940404],
                    [50.111025344544203, -18.603217751398063],
                    [50.295853530316208, -17.986959028036608],
                    [50.479395122586993, -17.37052640456983],
                    [50.661705221918623, -16.753927376846946],
                    [50.842837679715274, -16.137169262651298],
                    [51.022845162974022, -15.520259214291286],
                    [51.201779214539215, -14.903204228492257],
                    [51.37969031515604, -14.286011152692481],
                    [51.556627940127385, -13.668686694934991],
                    [51.732640614173135, -13.051237429263836],
                    [51.907775965388623, -12.433669806516264],
                    [52.08208077740602, -11.81599015791943],
                    [52.255601038857037, -11.198204706781667],
                    [52.428381991036133, -10.580319569392543],
                    [52.600468178264009, -9.962340766712884],
                    [52.771903489254782, -9.344274229771827],
                    [52.942731203882033, -8.726125802363811],
                    [53.112994036345867, -8.107901251841213],
                    [53.282734177440432, -7.489606272711228],
                    [53.451993334125177, -6.871246490233261],
                    [53.620812771792089, -6.252827471210708],
                    [53.789233352037741, -5.634354724890613],
                    [53.957295574031548, -5.015833710157494],
                    [54.125039606892415, -4.397269840930392],
                    [54.292505334653526, -3.778668492456859],
                    [54.459732385940868, -3.160035001314156],
                    [54.626760176241135, -2.541374677998874],
                    [54.793627938478608, -1.922692806927387],
                    [54.960374762585275, -1.303994650932282],
                    [55.127039629675323, -0.685285460255727],
                    [55.293661448017474, -0.066570472549188],
                    [55.460279084512251, 0.552145077233547],
                    [55.626931404260972, 1.170855957736308],
                    [55.793657303841542, 1.789556931307459],
                    [55.960495745482376, 2.408242751302112],
                    [56.127485791236325, 3.02690815668609],
                    [56.294666642551647, 3.645547868439394],
                    [56.462077671747295, 4.264156584159082],
                    [56.629758457986497, 4.882728970865344],
                    [56.797748826846885, 5.501259662303539],
                    [56.966088884494582, 6.119743255347089],
                    [57.134819055455125, 6.738174299204616],
                    [57.303980119487051, 7.356547296320741],
                    [57.473613251150596, 7.974856694281186],
                    [57.643760061178, 8.593096878618212],
                    [57.814462630646005, 9.211262171012436],
                    [57.985763559540658, 9.829346821198897],
                    [58.157706000031965, 10.447345000671362],
                    [58.701474950808461, 10.094801880502473],
                    [59.244052370020881, 9.74137017169619],
                    [59.785480447564737, 9.387083449541649],
                    [60.325801444381227, 9.031975098671978],
                    [60.865057681666713, 8.676078317560496],
                    [61.403291538174074, 8.319426127513964],
                    [61.940545442118434, 7.962051376270097],
                    [62.476861870279208, 7.603986747890133],
                    [63.012283337206384, 7.245264766355888],
                    [63.546852394322684, 6.885917804563178],
                    [64.080611628124245, 6.52597809151581],
                    [64.613603651187702, 6.165477716823318],
                    [65.145871102169735, 5.804448638793758],
                    [65.677456643109679, 5.44292269432691],
                    [66.20840295583173, 5.080931600712972],
                    [66.738752738348296, 4.718506968222016],
                    [67.268548703060276, 4.355680301904442],
                    [67.797833576758308, 3.992483013280491],
                    [68.326650097024526, 3.62894642573707],
                    [68.85504101043432, 3.265101781721967],
                    [69.383049072556787, 2.900980249938698],
                    [69.910717044356204, 2.536612933440153],
                    [70.438087692193335, 2.172030875924293],
                    [70.965203790522651, 1.807265068927904],
                    [71.492108113798452, 1.442346462619298],
                    [72.018843440072772, 1.077305968495637],
                    [72.545452552793222, 0.7121744683771],
                    [73.071978232709341, 0.346982822499399],
                    [73.598463265067778, -0.018238122391381],
                    [74.124950433315917, -0.383457526743427],
                    [74.651482523599725, -0.748644552803796],
                    [75.178102317568005, -1.113768351128385],
                    [75.704852599567914, -1.478798060581994],
                    [76.231776150349162, -1.84370279664671],
                    [76.758915748862819, -2.208451643328601],
                    [77.286314169563468, -2.57301364776157],
                    [77.814014184207338, -2.937357813911945],
                    [78.342058560954001, -3.301453090887321],
                    [78.87049005986853, -3.665268370239005],
                    [79.399351434720927, -4.028772476068809],
                    [79.928685432087093, -4.39193415873433],
                    [80.458534787750295, -4.754722086754839],
                    [80.98894222760174, -5.117104837817919],
                    [81.519950463143402, -5.479050897880597],
                    [82.05160219058871, -5.840528646779603],
                    [82.583940089963278, -6.201506353735112],
                    [83.117006820608367, -6.561952172854433],
                    [83.650845019382302, -6.92183413054056],
                    [84.185497296163362, -7.281120123694734],
                    [84.721006232951368, -7.639777910721932],
                    [85.257414379370175, -7.997775103438187],
                    [85.794764246373006, -8.355079161673928],
                    [86.33309830534256, -8.71165738607948],
                    [86.872458979098667, -9.067476910930623],
                    [87.412888641897325, -9.42250469873278],
                    [87.954429610438353, -9.776707531227487],
                    [88.497124135770434, -10.130052006694712],
                    [89.041014403292252, -10.482504528261245],
                    [89.586142519261955, -10.83403130390144],
                    [90.132550508099655, -11.18459833384594],
                    [90.680280300695472, -11.534171409682699],
                    [91.229373727215886, -11.882716104464578],
                    [91.7798725099085, -12.230197770010989],
                    [92.331818249612581, -12.576581529713792],
                    [92.885252421262351, -12.921832271342225],
                    [93.440216355000871, -13.265914645244607],
                    [93.996751231684129, -13.608793056254456],
                    [94.554898066692488, -13.950431658294292],
                    [95.11469769913964, -14.290794353476542],
                    [95.676190778381908, -14.629844781311533],
                    [96.239417745132869, -14.967546319606868],
                    [96.804418822470836, -15.303862076373605],
                    [97.371233997850709, -15.63875488802762],
                    [97.939903005119675, -15.972187313993231],
                    [98.510465306528772, -16.304121634905414],
                    [99.082960078345025, -16.634519848112404],
                    [99.657426187468673, -16.963343664078707],
                    [100.233902172547289, -17.29055450368736],
                    [100.812426225090292, -17.616113497339938],
                    [101.393036166086233, -17.939981482259554],
                    [101.975769421721623, -18.262118998892618],
                    [102.560663002695549, -18.582486290909571],
                    [103.147753477241281, -18.901043305204325],
                    [103.737076948642311, -19.217749688297431],
                    [104.328669024655937, -19.532564789933019],
                    [104.922564793230777, -19.845447658582543],
                    [105.518798791031429, -20.156357046840185],
                    [106.117404977357921, -20.465251406926768],
                    [106.718416702668776, -20.772088897884203],
                    [107.321866676206184, -21.076827384675937],
                    [107.927786932720949, -21.379424439985883],
                    [108.536208801894759, -21.679837348714614],
                    [109.147162871469391, -21.978023112476592],
                    [109.760678954870002, -22.273938450498974],
                    [110.376786049836426, -22.567539808615152],
                    [110.995512307846866, -22.858783359264578],
                    [111.61688498915106, -23.147625014982339],
                    [112.240930431294487, -23.434020427500627],
                    [112.867673999793283, -23.717924999663467],
                ]
            ],
        },
        {
            "zoneID": "4",
            "coordinates": [
                [
                    [-57.699999999700196, -39.1],
                    [-58.515833619425905, -39.004182749734014],
                    [-59.329395170350779, -38.902699620391104],
                    [-60.140570108523605, -38.795587241358078],
                    [-60.949247198599323, -38.682883972317427],
                    [-61.755318621756885, -38.564629841194119],
                    [-62.558680079122325, -38.44086648749834],
                    [-63.359230880800453, -38.311637095775325],
                    [-64.156874030412098, -38.176986336250366],
                    [-64.95151628984479, -38.036960298279098],
                    [-65.743068244004235, -37.891606424696647],
                    [-66.531444350276502, -37.740973449764795],
                    [-67.316562975400927, -37.585111328125208],
                    [-68.098346431442565, -37.424071172746324],
                    [-68.876720992879427, -37.257905185675725],
                    [-69.651616910092287, -37.086666592389292],
                    [-70.422968413861156, -36.910409578838937],
                    [-71.190713707271698, -36.72918922040617],
                    [-71.954794953124576, -36.543061424345183],
                    [-72.715158254150083, -36.352082858736821],
                    [-73.471753622431663, -36.156310893133195],
                    [-74.224534943432843, -35.955803537403256],
                    [-74.973459935527501, -35.75061937608325],
                    [-75.718490100537679, -35.54081751531595],
                    [-76.459590667075588, -35.326457518099858],
                    [-77.19673053568556, -35.107599352128318],
                    [-77.929882210495578, -34.884303332232889],
                    [-78.659021730868119, -34.656630066424327],
                    [-79.384128601253906, -34.42464040553017],
                    [-80.105185711151591, -34.18839538833646],
                    [-80.822179256867116, -33.947956199319094],
                    [-81.535098658776064, -33.703384116483676],
                    [-82.243936477686248, -33.454740469097317],
                    [-82.948688324906186, -33.202086592722026],
                    [-83.64935277590979, -32.945483787846513],
                    [-84.345931280404216, -32.684993280315609],
                    [-85.038428068800215, -32.420676186256912],
                    [-85.726850063179825, -32.15259347071202],
                    [-86.411206784665353, -31.880805917958639],
                    [-87.091510257192567, -31.605374097336664],
                    [-87.767774922074921, -31.32635833357017],
                    [-88.440017540876738, -31.043818676190881],
                    [-89.108257104581639, -30.757814873457562],
                    [-89.772514745459034, -30.468406348973758],
                    [-90.432813646232773, -30.175652173808714],
                    [-91.089178951047643, -29.879611048511038],
                    [-91.741637679135522, -29.580341278826893],
                    [-92.390218639378588, -29.27790076041174],
                    [-93.034952346673379, -28.972346958145522],
                    [-93.675870938293087, -28.663736893542705],
                    [-94.313008094747659, -28.352127125866048],
                    [-94.946398959744158, -28.037573743133692],
                    [-95.576080066441818, -27.720132346830269],
                    [-96.202089258312583, -27.399858044712971],
                    [-96.824465622590367, -27.076805438220333],
                    [-97.443249412929958, -26.751028614378981],
                    [-98.058481989152426, -26.422581142205843],
                    [-98.670205743500219, -26.091516061916707],
                    [-99.278464043081044, -25.75788588402628],
                    [-99.883301166015883, -25.421742583053685],
                    [-100.484762239385759, -25.083137593924789],
                    [-101.082893187970171, -24.742121811972027],
                    [-101.67774067489222, -24.398745590236729],
                    [-102.269352049457439, -24.053058738569803],
                    [-102.857775298591093, -23.705110525430371],
                    [-103.443058997374806, -23.354949676985939],
                    [-104.025252261382718, -23.002624379811209],
                    [-104.604404706212108, -22.64818228358547],
                    [-105.18056639981944, -22.29167050289135],
                    [-105.753787829244914, -21.933135622610791],
                    [-106.324119855646813, -21.572623698824543],
                    [-106.891613682825096, -21.210180266905752],
                    [-107.456320819450241, -20.845850344217922],
                    [-108.018293050283944, -20.479678437309929],
                    [-108.577582402006215, -20.111708544613577],
                    [-109.134241113536518, -19.741984166336181],
                    [-109.688321614450899, -19.370548310755908],
                    [-110.239876490807319, -18.997443498718383],
                    [-110.788958468058809, -18.622711773529431],
                    [-111.335620383174103, -18.24639470724992],
                    [-111.879915167550905, -17.868533406991048],
                    [-112.421895823633236, -17.489168529304095],
                    [-112.961615409623448, -17.108340279280412],
                    [-113.499127019696175, -16.726088427638729],
                    [-114.034483768710913, -16.34245231432277],
                    [-114.567738778721605, -15.957470859292698],
                    [-115.098945165486953, -15.571182570619101],
                    [-115.628156023181873, -15.183625556174377],
                    [-116.155424418102314, -14.794837529928031],
                    [-116.680803373376875, -14.404855823637263],
                    [-117.204345862671346, -14.01371739584107],
                    [-117.726104801195561, -13.621458839953448],
                    [-118.246133039408221, -13.228116397753467],
                    [-118.764483354922788, -12.833725965680742],
                    [-119.281208445313382, -12.438323106526127],
                    [-119.796360928114325, -12.041943059324694],
                    [-120.309993333625414, -11.644620750147396],
                    [-120.822158098617251, -11.246390799295853],
                    [-121.332907570827672, -10.847287533892484],
                    [-121.842293999980882, -10.447344999743109],
                    [-121.298525049191653, -10.094801879403121],
                    [-120.755947629979119, -9.741370170596781],
                    [-120.21451955243532, -9.387083448442297],
                    [-119.67419855561883, -9.031975097572627],
                    [-119.134942318333287, -8.676078316461087],
                    [-118.59670846182604, -8.319426126414555],
                    [-118.059454557881452, -7.962051375170745],
                    [-117.523138129720849, -7.603986746790895],
                    [-116.98771666279373, -7.24526476525665],
                    [-116.45314760567743, -6.885917804363146],
                    [-115.919388371875812, -6.525978091315778],
                    [-115.386396348812355, -6.16547771572391],
                    [-114.854128897830265, -5.804448638593669],
                    [-114.322543356890321, -5.442922694126935],
                    [-113.791597044168157, -5.080931600512827],
                    [-113.261247261651704, -4.718506967122778],
                    [-112.731451296939724, -4.355680300805204],
                    [-112.202166423241806, -3.99248301218114],
                    [-111.673349902975588, -3.628946425537038],
                    [-111.14495898956568, -3.265101780622558],
                    [-110.616950927443327, -2.900980248839346],
                    [-110.089282955643796, -2.536612932340915],
                    [-109.561912307806722, -2.172030874824884],
                    [-109.034796209477463, -1.807265068727872],
                    [-108.507891886201548, -1.442346462419266],
                    [-107.981156559927285, -1.077305967396399],
                    [-107.454547447206892, -0.712174467277748],
                    [-106.928021767290659, -0.34698282139999],
                    [-106.401536734932336, 0.018238122591413],
                    [-105.87504956668414, 0.383457527842779],
                    [-105.348517476400389, 0.748644553003828],
                    [-104.821897682431995, 1.113768352227737],
                    [-104.295147400432086, 1.478798061681346],
                    [-103.768223849650838, 1.843702797745948],
                    [-103.241084251137181, 2.208451643528576],
                    [-102.713685830436702, 2.573013648860865],
                    [-102.185985815792662, 2.93735781411192],
                    [-101.657941439046112, 3.301453091087467],
                    [-101.129509940131584, 3.665268371338357],
                    [-100.600648565278959, 4.028772477168275],
                    [-100.071314567912964, 4.391934159833681],
                    [-99.541465212249705, 4.754722086954871],
                    [-99.01105777239826, 5.117104838917271],
                    [-98.480049536856598, 5.479050898979892],
                    [-97.94839780941129, 5.840528647878841],
                    [-97.416059910036722, 6.201506354834464],
                    [-96.882993179391633, 6.561952173054351],
                    [-96.349154980617811, 6.921834130740706],
                    [-95.814502703836638, 7.281120124793972],
                    [-95.278993767048689, 7.639777911821227],
                    [-94.742585620629825, 7.997775104537538],
                    [-94.205235753627051, 8.355079162773166],
                    [-93.66690169465744, 8.711657387178775],
                    [-93.127541020901333, 9.067476912030031],
                    [-92.587111358102675, 9.422504699832018],
                    [-92.045570389561817, 9.776707532326725],
                    [-91.502875864229736, 10.130052007794063],
                    [-90.958985596707862, 10.482504529360597],
                    [-90.413857480738045, 10.834031305000792],
                    [-89.867449491900459, 11.184598334945292],
                    [-89.319719699304585, 11.534171409882788],
                    [-88.770626272784227, 11.882716104664667],
                    [-88.2201274900915, 12.230197771110397],
                    [-87.668181750387419, 12.576581529913653],
                    [-87.114747578737649, 12.921832271542087],
                    [-86.559783644999186, 13.265914645444582],
                    [-86.003248768315927, 13.608793056454488],
                    [-85.445101933307512, 13.950431659393644],
                    [-84.885302300860417, 14.290794354575894],
                    [-84.323809221618205, 14.629844782410885],
                    [-83.760582254867131, 14.9675463198069],
                    [-83.195581177529277, 15.303862076573694],
                    [-82.628766002149177, 15.638754888227595],
                    [-82.060096994880325, 15.972187315092583],
                    [-81.489534693471228, 16.304121636004822],
                    [-80.917039921654975, 16.634519849211756],
                    [-80.342573812531384, 16.963343664278739],
                    [-79.766097827452711, 17.290554503887336],
                    [-79.187573774909765, 17.61611349843929],
                    [-78.606963833913767, 17.939981482459416],
                    [-78.024230578278548, 18.262118999092593],
                    [-77.439336997304565, 18.582486291109433],
                    [-76.852246522758719, 18.901043305404244],
                    [-76.262923051357689, 19.217749689396783],
                    [-75.671330975344176, 19.532564791032371],
                    [-75.077435206769337, 19.845447659681781],
                    [-74.481201208968571, 20.156357047040217],
                    [-73.882595022642079, 20.465251407126914],
                    [-73.281583297331224, 20.772088898983554],
                    [-72.678133323793816, 21.076827384875912],
                    [-72.072213067279165, 21.379424440185744],
                    [-71.463791198105241, 21.679837349813852],
                    [-70.852837128530609, 21.978023113576],
                    [-70.239321045130112, 22.273938451598326],
                    [-69.623213950163574, 22.567539808815241],
                    [-69.004487692153248, 22.85878336036393],
                    [-68.383115010848996, 23.147625015182427],
                    [-67.759069568705513, 23.434020427700602],
                    [-67.132326000344619, 23.717925000538514],
                    [-67.033287606937392, 23.083647216945621],
                    [-66.935179457865615, 22.449308267762433],
                    [-66.837964873380088, 21.814910569467372],
                    [-66.741608261012402, 21.180456467492149],
                    [-66.646075060715361, 20.545948238920232],
                    [-66.551331690005384, 19.911388095184577],
                    [-66.457345495398215, 19.276778186564115],
                    [-66.36408470294657, 18.642120604882052],
                    [-66.271518369676983, 18.007417388002125],
                    [-66.179616344918315, 17.37267051982866],
                    [-66.088349225336458, 16.737881933904305],
                    [-65.997688312665446, 16.10305352060368],
                    [-65.907605581332461, 15.46818712173831],
                    [-65.818073635289977, 14.833284541348576],
                    [-65.729065676539676, 14.19834753940745],
                    [-65.64055547185751, 13.563377841714157],
                    [-65.552517316820627, 12.928377138993824],
                    [-65.464926007029533, 12.293347087798054],
                    [-65.377756807530602, 11.658289314100614],
                    [-65.290985424937389, 11.023205414198571],
                    [-65.204587975954212, 10.388096956509401],
                    [-65.118540963094915, 9.752965486967696],
                    [-65.032821247702373, 9.11781252542778],
                    [-64.947406022969517, 8.482639568361435],
                    [-64.862272792355441, 7.847448096052858],
                    [-64.77739934080688, 7.212239566303026],
                    [-64.69276371497341, 6.577015420725274],
                    [-64.608344199824899, 5.941777086543425],
                    [-64.524119293470562, 5.306525974793942],
                    [-64.440067687373812, 4.67126348482202],
                    [-64.356168243869263, 4.035991005180904],
                    [-64.272399977277075, 3.400709913631658],
                    [-64.188742027822286, 2.765421578942778],
                    [-64.10517364544728, 2.130127364486327],
                    [-64.021674167328911, 1.494828626439983],
                    [-63.938222998992103, 0.859526716484879],
                    [-63.854799590928337, 0.224222984503172],
                    [-63.771383423306304, -0.411081222320433],
                    [-63.687953981690839, -1.04638455860038],
                    [-63.604490739056303, -1.681685675353549],
                    [-63.520973135102054, -2.316983223596765],
                    [-63.437380557366794, -2.952275849850537],
                    [-63.353692319644779, -3.587562195239002],
                    [-63.26988764130158, -4.22284089639021],
                    [-63.185945628387969, -4.858110581837764],
                    [-63.101845252056705, -5.493369869323885],
                    [-63.017565326078852, -6.128617368496691],
                    [-62.933084488858015, -6.763851677313028],
                    [-62.848381177349438, -7.399071378441249],
                    [-62.763433609073729, -8.034275041959518],
                    [-62.678219755137491, -8.66946122085858],
                    [-62.592717321347209, -9.304628450142729],
                    [-62.506903721229662, -9.939775247729472],
                    [-62.420756054448248, -10.574900107254109],
                    [-62.334251078024806, -11.210001502567252],
                    [-62.247365185654701, -11.845077883237593],
                    [-62.160074374432781, -12.480127670055822],
                    [-62.072354225067386, -13.115149259530597],
                    [-61.984179866807324, -13.75014101579518],
                    [-61.895525952260869, -14.385101273304997],
                    [-61.806366624120301, -15.020028332341553],
                    [-61.716675486384474, -15.654920456313903],
                    [-61.626425569284493, -16.289775870859671],
                    [-61.535589295109844, -16.924592763844885],
                    [-61.444138444933174, -17.559369277270264],
                    [-61.352044116342825, -18.194103509968897],
                    [-61.259276690167098, -18.82879351221078],
                    [-61.165805787307136, -19.463437285702071],
                    [-61.071600226469172, -20.098032777290712],
                    [-60.976627978298438, -20.732577877167216],
                    [-60.880856121312831, -21.367070418864671],
                    [-60.784250791540671, -22.001508170265822],
                    [-60.686777130360213, -22.635888835401317],
                    [-60.588399232338588, -23.270210049054469],
                    [-60.489080085877163, -23.904469370465051],
                    [-60.388781517453026, -24.538664284229242],
                    [-60.287464123270638, -25.172792191306485],
                    [-60.185087206309504, -25.806850409019091],
                    [-60.081608705277404, -26.440836161159837],
                    [-59.976985120866573, -27.074746577992073],
                    [-59.871171435713165, -27.708578689055173],
                    [-59.764121032559501, -28.342329415969687],
                    [-59.65578560702005, -28.975995568840347],
                    [-59.546115074051386, -29.609573839061397],
                    [-59.435057468127582, -30.243060793920449],
                    [-59.322558839818498, -30.876452867605735],
                    [-59.208563146072208, -31.509746354910305],
                    [-59.093012128806663, -32.142937403138603],
                    [-58.975845189903566, -32.776022004012191],
                    [-58.856999260807129, -33.408995982878253],
                    [-58.736408655934667, -34.041854992413903],
                    [-58.61400492338845, -34.674594499136731],
                    [-58.489716682179107, -35.307209774411433],
                    [-58.363469449555396, -35.939695882758656],
                    [-58.235185455744102, -36.572047668365144],
                    [-58.104783446998397, -37.204259742493093],
                    [-57.972178476055774, -37.836326468191885],
                    [-57.837281671911569, -38.468241946808348],
                    [-57.699999999700196, -39.1],
                ]
            ],
        },
        {
            "zoneID": "5",
            "coordinates": [
                [
                    [-66.443303087067761, 23.60705864444094],
                    [-65.755460442245578, 23.493156963123397],
                    [-65.068821182051863, 23.376241613159948],
                    [-64.383407560210685, 23.25633469538991],
                    [-63.69924096080166, 23.133458745924429],
                    [-63.016341889266755, 23.007636718160086],
                    [-62.334729968812951, 22.878891975584281],
                    [-61.654423933217913, 22.747248273788841],
                    [-60.975441625030953, 22.612729752376197],
                    [-60.297799989278019, 22.475360917872138],
                    [-59.621515075260447, 22.335166632933806],
                    [-58.94660203385672, 22.192172102860297],
                    [-58.273075113925302, 22.046402864800427],
                    [-57.600947667700666, 21.897884773363671],
                    [-56.930232149893754, 21.74664398533173],
                    [-56.260940120390217, 21.592706954262553],
                    [-55.593082244250127, 21.436100412504061],
                    [-54.926668301600785, 21.27685136040202],
                    [-54.261707185837906, 21.114987053709626],
                    [-53.598206912618878, 20.950534994594364],
                    [-52.93617462435941, 20.783522917248888],
                    [-52.275616595629344, 20.613978776199588],
                    [-51.616538243045454, 20.441930735515086],
                    [-50.958944130667078, 20.267407159812649],
                    [-50.302837978989487, 20.090436598070596],
                    [-49.648222673037878, 19.911047780930403],
                    [-48.9951002713604, 19.72926960001206],
                    [-48.343472018618741, 19.545131108813678],
                    [-47.693338351883369, 19.358661501127415],
                    [-47.044698912324918, 19.169890111939139],
                    [-46.397552557804261, 18.978846399441807],
                    [-45.751897371866164, 18.78555994143818],
                    [-45.107730677228915, 18.590060422750355],
                    [-44.465049046576212, 18.392377628025145],
                    [-43.823848314248266, 18.192541432740995],
                    [-43.184123588832506, 17.990581794214506],
                    [-42.545869267552632, 17.786528745305418],
                    [-41.909079046161025, 17.580412383624662],
                    [-41.273745934227463, 17.372262868836401],
                    [-40.639862265930788, 17.162110409168122],
                    [-40.007419717146206, 16.949985258712786],
                    [-39.376409312639623, 16.735917710234162],
                    [-38.746821445853016, 16.519938087972434],
                    [-38.118645887897344, 16.302076738650612],
                    [-37.491871803740707, 16.082364032374244],
                    [-36.866487762999839, 15.860830348242018],
                    [-36.242481756128086, 15.637506077943215],
                    [-35.619841207006061, 15.412421610468982],
                    [-34.998552983733191, 15.185607337508657],
                    [-34.378603417513659, 14.957093639959567],
                    [-33.759978310750398, 14.726910889725843],
                    [-33.142662953232673, 14.495089440725167],
                    [-32.526642133827352, 14.261659628888822],
                    [-31.911900154868192, 14.026651764967028],
                    [-31.298420842947507, 13.790096133629731],
                    [-30.686187566902674, 13.552022987171142],
                    [-30.075183243212052, 13.312462547308769],
                    [-29.465390353981604, 13.071444996189655],
                    [-28.85679095773645, 12.829000477290265],
                    [-28.249366701112308, 12.585159093617335],
                    [-27.643098832345174, 12.339950902312353],
                    [-27.037968212962596, 12.09340591644991],
                    [-26.433955328575507, 11.845554098742696],
                    [-25.831040300569384, 11.596425363339904],
                    [-25.2292028995941, 11.346049574028655],
                    [-24.628422554557176, 11.094456541536204],
                    [-24.028678364314999, 10.841676020831756],
                    [-23.429949110263181, 10.58773771562312],
                    [-22.83221326443055, 10.332671272061589],
                    [-22.235449002969062, 10.076506281439777],
                    [-21.639634213348245, 9.819272275695027],
                    [-21.044746506046351, 9.56099873370465],
                    [-20.450763227141181, 9.301715074990739],
                    [-19.85766146280622, 9.041450662418185],
                    [-19.26541805280084, 8.78023480129508],
                    [-18.674009600362695, 8.518096742071066],
                    [-18.083412477603702, 8.255065675840342],
                    [-17.493602838100458, 7.991170739737925],
                    [-16.904556626786871, 7.726441016040098],
                    [-16.316249583551382, 7.460905531265325],
                    [-15.72865725672699, 7.194593257972542],
                    [-15.141755009386145, 6.927533117459461],
                    [-14.555518027434971, 6.65975397886308],
                    [-13.969921330405043, 6.391284660059057],
                    [-13.384939774151235, 6.122153930359673],
                    [-12.800548063442307, 5.852390509614395],
                    [-12.216720758256315, 5.582023074505344],
                    [-11.633432280974944, 5.311080253151204],
                    [-11.050656920880158, 5.039590632301895],
                    [-10.468368848543491, 4.767582757338403],
                    [-9.886542115825932, 4.495085132273061],
                    [-9.305150666669874, 4.222126223346606],
                    [-8.724168342494977, 3.948734461726076],
                    [-8.143568889392668, 3.674938242605833],
                    [-7.563325967119624, 3.400765929703937],
                    [-6.983413149996807, 3.126245857060724],
                    [-6.403803938600845, 2.851406329938243],
                    [-5.824471766059105, 2.576275625719575],
                    [-5.245389999848555, 2.300882000204183],
                    [-5.686408422011027, 1.835772566950425],
                    [-6.127197384851399, 1.370554500090179],
                    [-6.567815105083014, 0.905255380031804],
                    [-7.008319751755096, 0.439902745815118],
                    [-7.44876946064204, -0.025475886902598],
                    [-7.889222351330375, -0.490853013255901],
                    [-8.329736543406682, -0.956201130177988],
                    [-8.77037017534326, -1.421492720212825],
                    [-9.211181420685989, -1.886700238025526],
                    [-9.652228503342712, -2.351796101408922],
                    [-10.093569717368496, -2.816752672397854],
                    [-10.535263441354687, -3.281542251873361],
                    [-10.977368155515933, -3.746137058878105],
                    [-11.419942459676747, -4.210509222522546],
                    [-11.863045089459263, -4.674630767595829],
                    [-12.306734932471102, -5.138473601975079],
                    [-12.751071044493074, -5.602009500438044],
                    [-13.19611266656625, -6.065210096568649],
                    [-13.641919241180005, -6.528046863871623],
                    [-14.088550427560165, -6.990491107678451],
                    [-14.53606611875631, -7.452513946261547],
                    [-14.984526456031062, -7.914086301841337],
                    [-15.433991847745517, -8.37517888439794],
                    [-15.88452298015136, -8.835762179081257],
                    [-16.336180835377206, -9.295806430022708],
                    [-16.789026704918456, -9.755281629543504],
                    [-17.243122208523062, -10.214157500168426],
                    [-17.698529301386088, -10.672403486531607],
                    [-18.1553102957335, -11.129988731994331],
                    [-18.613527868016661, -11.586882072349738],
                    [-19.073245076898729, -12.043052016936997],
                    [-19.534525375845362, -12.49846673515168],
                    [-19.997432622117799, -12.953094039358405],
                    [-20.462031092061181, -13.406901372300467],
                    [-20.928385494594863, -13.859855790911979],
                    [-21.396560975708439, -14.311923951928804],
                    [-21.866623136448538, -14.7630720921033],
                    [-22.338638036516102, -15.213266019211346],
                    [-22.812672208655442, -15.662471088669747],
                    [-23.288792662251524, -16.110652194543093],
                    [-23.767066895920493, -16.557773747060708],
                    [-24.24756290110696, -17.003799661824871],
                    [-24.730349166580709, -17.448693338226917],
                    [-25.215494690127798, -17.892417645058231],
                    [-25.703068974953169, -18.334934906120964],
                    [-26.193142036875429, -18.776206877745153],
                    [-26.685784405226059, -19.216194735298757],
                    [-27.181067121950093, -19.65485905699984],
                    [-27.679061743404702, -20.092159803232278],
                    [-28.179840336762084, -20.528056300357946],
                    [-28.683475474613431, -20.962507224528736],
                    [-29.19004023317018, -21.395470581002485],
                    [-29.699608180573023, -21.826903690652784],
                    [-30.212253373294516, -22.256763167486156],
                    [-30.728050341749849, -22.685004904252878],
                    [-31.247074077706486, -23.11158405356116],
                    [-31.769400020794308, -23.536455008092105],
                    [-32.295104039619673, -23.959571386210484],
                    [-32.824262413779309, -24.380886012179701],
                    [-33.356951809578334, -24.800350897276019],
                    [-33.893249256647834, -25.217917226298937],
                    [-34.433232120965556, -25.633535334188252],
                    [-34.976978070681355, -26.047154696132282],
                    [-35.524565044641065, -26.458723901486792],
                    [-36.076071216413482, -26.868190647480333],
                    [-36.631574950223751, -27.275501712234188],
                    [-37.191154759584435, -27.680602947567934],
                    [-37.754889256933609, -28.083439258315082],
                    [-38.322857101474028, -28.483954587933852],
                    [-38.895136945213835, -28.882091904118056],
                    [-39.471807370913382, -29.277793186206509],
                    [-40.052946824636194, -29.670999409894819],
                    [-40.638633547400275, -30.0616505346444],
                    [-41.228945504131673, -30.449685495589108],
                    [-41.823960295531151, -30.835042185548389],
                    [-42.423755078933709, -31.21765745232949],
                    [-43.028406476577572, -31.597467086137044],
                    [-43.637990476679136, -31.974405812378279],
                    [-44.252582333607791, -32.348407285367898],
                    [-44.872256459967616, -32.719404085630003],
                    [-45.497086308786095, -33.087327713603031],
                    [-46.12714425840079, -33.452108588740316],
                    [-46.762501480259061, -33.813676050409356],
                    [-47.403227809415853, -34.171958357891867],
                    [-48.049391600641798, -34.526882696679081],
                    [-48.701059587230134, -34.878375182968284],
                    [-49.358296722715522, -35.226360870857434],
                    [-50.021166021694512, -35.570763767633707],
                    [-50.689728394349856, -35.911506840068569],
                    [-51.364042474680446, -36.248512035102294],
                    [-52.044164434341155, -36.581700299629063],
                    [-52.730147804577484, -36.910991597584143],
                    [-53.422043273877932, -37.23630493962122],
                    [-54.119898499116402, -37.557558409193177],
                    [-54.823757890614104, -37.874669193128739],
                    [-55.533662410691647, -38.187553620303277],
                    [-56.249649350636957, -38.496127198511374],
                    [-56.971752116666835, -38.800304658533094],
                    [-57.699999999700196, -39.1],
                    [-57.837281671911569, -38.468241946808348],
                    [-57.972178476055774, -37.836326468191885],
                    [-58.104783446998454, -37.204259742493093],
                    [-58.235185455744158, -36.572047668365144],
                    [-58.363469449555396, -35.939695882758713],
                    [-58.489716682179107, -35.30720977441149],
                    [-58.61400492338845, -34.674594499136788],
                    [-58.736408655934667, -34.041854992413903],
                    [-58.856999260807186, -33.408995982878253],
                    [-58.975845189903566, -32.776022004012248],
                    [-59.093012128806663, -32.142937403138603],
                    [-59.208563146072265, -31.509746354910305],
                    [-59.322558839818555, -30.876452867605735],
                    [-59.435057468127638, -30.243060793920449],
                    [-59.546115074051386, -29.609573839061397],
                    [-59.655785607020107, -28.975995568840403],
                    [-59.764121032559558, -28.342329415969743],
                    [-59.871171435713165, -27.70857868905523],
                    [-59.976985120866573, -27.07474657799213],
                    [-60.081608705277461, -26.440836161159893],
                    [-60.185087206309504, -25.806850409019091],
                    [-60.287464123270638, -25.172792191306542],
                    [-60.388781517453026, -24.538664284229299],
                    [-60.48908008587722, -23.904469370465051],
                    [-60.588399232338645, -23.270210049054469],
                    [-60.686777130360213, -22.635888835401374],
                    [-60.784250791540728, -22.001508170265822],
                    [-60.880856121312888, -21.367070418864671],
                    [-60.976627978298495, -20.732577877167273],
                    [-61.071600226469229, -20.098032777290769],
                    [-61.165805787307193, -19.463437285702128],
                    [-61.259276690167098, -18.82879351221078],
                    [-61.352044116342881, -18.194103509968954],
                    [-61.44413844493323, -17.559369277270264],
                    [-61.535589295109844, -16.924592763844942],
                    [-61.62642556928455, -16.289775870859728],
                    [-61.716675486384531, -15.65492045631396],
                    [-61.806366624120358, -15.02002833234161],
                    [-61.895525952260869, -14.385101273305054],
                    [-61.984179866807381, -13.75014101579518],
                    [-62.072354225067386, -13.115149259530654],
                    [-62.160074374432781, -12.480127670055879],
                    [-62.247365185654758, -11.84507788323765],
                    [-62.334251078024806, -11.210001502567252],
                    [-62.420756054448304, -10.574900107254109],
                    [-62.506903721229719, -9.939775247729472],
                    [-62.592717321347266, -9.304628450142786],
                    [-62.678219755137548, -8.669461220858636],
                    [-62.763433609073786, -8.034275041959575],
                    [-62.848381177349438, -7.399071378441306],
                    [-62.933084488858015, -6.763851677313028],
                    [-63.017565326078909, -6.128617368496691],
                    [-63.101845252056705, -5.493369869323942],
                    [-63.185945628388026, -4.858110581837821],
                    [-63.26988764130158, -4.22284089639021],
                    [-63.353692319644779, -3.587562195239059],
                    [-63.437380557366794, -2.952275849850537],
                    [-63.520973135102054, -2.316983223596822],
                    [-63.604490739056303, -1.681685675353606],
                    [-63.687953981690839, -1.046384558600437],
                    [-63.771383423306304, -0.41108122232049],
                    [-63.854799590928337, 0.224222984503172],
                    [-63.93822299899216, 0.859526716484822],
                    [-64.021674167328911, 1.494828626439983],
                    [-64.105173645447337, 2.130127364486327],
                    [-64.188742027822286, 2.765421578942778],
                    [-64.272399977277075, 3.400709913631658],
                    [-64.35616824386932, 4.03599100518079],
                    [-64.440067687373812, 4.67126348482202],
                    [-64.524119293470562, 5.306525974793942],
                    [-64.608344199824899, 5.941777086543368],
                    [-64.69276371497341, 6.577015420725161],
                    [-64.77739934080688, 7.212239566302969],
                    [-64.862272792355441, 7.847448096052858],
                    [-64.947406022969517, 8.482639568361435],
                    [-65.032821247702373, 9.11781252542778],
                    [-65.118540963094915, 9.752965486967696],
                    [-65.204587975954269, 10.388096956509401],
                    [-65.290985424937389, 11.023205414198571],
                    [-65.377756807530602, 11.658289314100614],
                    [-65.464926007029533, 12.29334708779794],
                    [-65.552517316820683, 12.928377138993824],
                    [-65.64055547185751, 13.5633778417141],
                    [-65.729065676539676, 14.19834753940745],
                    [-65.818073635289977, 14.833284541348576],
                    [-65.907605581332461, 15.46818712173831],
                    [-65.997688312665446, 16.103053520603567],
                    [-66.088349225336458, 16.737881933904191],
                    [-66.179616344918315, 17.37267051982866],
                    [-66.271518369676983, 18.007417388002125],
                    [-66.364084702946627, 18.642120604882052],
                    [-66.457345495398272, 19.276778186564115],
                    [-66.551331690005441, 19.91138809518452],
                    [-66.646075060715418, 20.545948238920118],
                    [-66.741608261012402, 21.180456467492036],
                    [-66.837964873380145, 21.814910569467258],
                    [-66.935179457865672, 22.449308267762376],
                    [-67.033287606937449, 23.083647216945565],
                    [-67.132326000344619, 23.717925000538401],
                    [-66.443303087067761, 23.60705864444094],
                ]
            ],
        },
        {
            "zoneID": "6",
            "coordinates": [
                [
                    [112.867673999793283, -23.717924999663467],
                    [112.240930431294487, -23.434020427500627],
                    [111.61688498915106, -23.147625014982339],
                    [110.995512307846866, -22.858783359264578],
                    [110.376786049836426, -22.567539808615152],
                    [109.760678954870002, -22.273938450498974],
                    [109.147162871469391, -21.978023112476592],
                    [108.536208801894759, -21.679837348714614],
                    [107.927786932720949, -21.379424439985883],
                    [107.321866676206184, -21.076827384675937],
                    [106.718416702668776, -20.772088897884203],
                    [106.117404977357921, -20.465251406926768],
                    [105.518798791031429, -20.156357046840185],
                    [104.922564793230777, -19.845447658582543],
                    [104.328669024655937, -19.532564789933019],
                    [103.737076948642311, -19.217749688297431],
                    [103.147753477241281, -18.901043305204325],
                    [102.560663002695549, -18.582486290909571],
                    [101.975769421721623, -18.262118998892618],
                    [101.393036166086233, -17.939981482259554],
                    [100.812426225090292, -17.616113497339938],
                    [100.233902172547289, -17.29055450368736],
                    [99.657426187468673, -16.963343664078707],
                    [99.082960078345025, -16.634519848112404],
                    [98.510465306528772, -16.304121634905414],
                    [97.939903005119675, -15.972187313993231],
                    [97.371233997850709, -15.63875488802762],
                    [96.804418822470836, -15.303862076373605],
                    [96.239417745132869, -14.967546319606868],
                    [95.676190778381908, -14.629844781311533],
                    [95.11469769913964, -14.290794353476542],
                    [94.554898066692488, -13.950431658294292],
                    [93.996751231684129, -13.608793056254456],
                    [93.440216355000871, -13.265914645244607],
                    [92.885252421262351, -12.921832271342225],
                    [92.331818249612581, -12.576581529713792],
                    [91.7798725099085, -12.230197770010989],
                    [91.229373727215886, -11.882716104464578],
                    [90.680280300695472, -11.534171409682699],
                    [90.132550508099655, -11.18459833384594],
                    [89.586142519261955, -10.83403130390144],
                    [89.041014403292252, -10.482504528261245],
                    [88.497124135770434, -10.130052006694712],
                    [87.954429610438353, -9.776707531227487],
                    [87.412888641897325, -9.42250469873278],
                    [86.872458979098667, -9.067476910930623],
                    [86.33309830534256, -8.71165738607948],
                    [85.794764246373006, -8.355079161673928],
                    [85.257414379370175, -7.997775103438187],
                    [84.721006232951368, -7.639777910721932],
                    [84.185497296163362, -7.281120123694734],
                    [83.650845019382302, -6.92183413054056],
                    [83.117006820608367, -6.561952172854433],
                    [82.583940089963278, -6.201506353735112],
                    [82.05160219058871, -5.840528646779603],
                    [81.519950463143402, -5.479050897880597],
                    [80.98894222760174, -5.117104837817919],
                    [80.458534787750295, -4.754722086754839],
                    [79.928685432087093, -4.39193415873433],
                    [79.399351434720927, -4.028772476068809],
                    [78.87049005986853, -3.665268370239005],
                    [78.342058560954001, -3.301453090887321],
                    [77.814014184207338, -2.937357813911945],
                    [77.286314169563468, -2.57301364776157],
                    [76.758915748862819, -2.208451643328601],
                    [76.231776150349162, -1.84370279664671],
                    [75.704852599567914, -1.478798060581994],
                    [75.178102317568005, -1.113768351128385],
                    [74.651482523599725, -0.748644552803796],
                    [74.124950433315917, -0.383457526743427],
                    [73.598463265067778, -0.018238122391381],
                    [73.071978232709341, 0.346982822499399],
                    [72.545452552793222, 0.7121744683771],
                    [72.018843440072772, 1.077305968495637],
                    [71.492108113798452, 1.442346462619298],
                    [70.965203790522651, 1.807265068927904],
                    [70.438087692193335, 2.172030875924293],
                    [69.910717044356204, 2.536612933440153],
                    [69.383049072556787, 2.900980249938698],
                    [68.85504101043432, 3.265101781721967],
                    [68.326650097024526, 3.62894642573707],
                    [67.797833576758308, 3.992483013280491],
                    [67.268548703060276, 4.355680301904442],
                    [66.738752738348296, 4.718506968222016],
                    [66.20840295583173, 5.080931600712972],
                    [65.677456643109679, 5.44292269432691],
                    [65.145871102169735, 5.804448638793758],
                    [64.613603651187702, 6.165477716823318],
                    [64.080611628124245, 6.52597809151581],
                    [63.546852394322684, 6.885917804563178],
                    [63.012283337206384, 7.245264766355888],
                    [62.476861870279208, 7.603986747890133],
                    [61.940545442118434, 7.962051376270097],
                    [61.403291538174074, 8.319426127513964],
                    [60.865057681666713, 8.676078317560496],
                    [60.325801444381227, 9.031975098671978],
                    [59.785480447564737, 9.387083449541649],
                    [59.244052370020881, 9.74137017169619],
                    [58.701474950808461, 10.094801880502473],
                    [58.157706000031965, 10.447345000671362],
                    [58.667092429172442, 10.847287534991835],
                    [59.177841901382692, 11.246390799495828],
                    [59.6900066663747, 11.644620751246805],
                    [60.203639071885732, 12.041943060423932],
                    [60.718791554686561, 12.438323107625365],
                    [61.235516645077098, 12.833725965880717],
                    [61.753866960591949, 13.228116397953556],
                    [62.273895198804439, 13.62145884015348],
                    [62.795654137328768, 14.013717396041045],
                    [63.319196626623068, 14.404855824736501],
                    [63.844575581897686, 14.794837531027383],
                    [64.371843976818127, 15.183625557273615],
                    [64.901054834513047, 15.571182571718452],
                    [65.432261221278452, 15.957470859492673],
                    [65.9655162312892, 16.342452315422179],
                    [66.500872980303882, 16.72608842873808],
                    [67.038384590376666, 17.108340280379764],
                    [67.578104176366764, 17.489168529504127],
                    [68.120084832449095, 17.8685334080904],
                    [68.664379616825954, 18.246394707449781],
                    [69.211041531941305, 18.622711774628669],
                    [69.760123509192567, 18.997443499817791],
                    [70.311678385549101, 19.370548311855146],
                    [70.865758886463482, 19.741984167435419],
                    [71.422417597993842, 20.111708544813609],
                    [71.981706949715999, 20.479678437510074],
                    [72.543679180549873, 20.845850345317331],
                    [73.108386317174791, 21.21018026800499],
                    [73.6758801443533, 21.572623699923895],
                    [74.246212170755143, 21.933135622810767],
                    [74.819433600180673, 22.291670503091382],
                    [75.395595293787835, 22.648182283785502],
                    [75.974747738617282, 23.002624380011184],
                    [76.556941002625308, 23.354949677185971],
                    [77.142224701408907, 23.705110525630289],
                    [77.730647950542561, 24.053058739669154],
                    [78.32225932510795, 24.398745591335967],
                    [78.917106812029886, 24.742121813071321],
                    [79.515237760614241, 25.083137595024027],
                    [80.116698833984117, 25.421742583253661],
                    [80.72153595691907, 25.757885885125631],
                    [81.329794256499781, 26.091516063015945],
                    [81.941518010847574, 26.422581142405875],
                    [82.556750587070042, 26.75102861547839],
                    [83.175534377409747, 27.076805438420308],
                    [83.797910741687531, 27.399858045812209],
                    [84.423919933558182, 27.720132347929564],
                    [85.053601040255955, 28.03757374333378],
                    [85.686991905252341, 28.352127126066136],
                    [86.324129061706913, 28.663736893742794],
                    [86.965047653326678, 28.97234695924476],
                    [87.609781360621412, 29.277900760611658],
                    [88.258362320864478, 29.580341279026982],
                    [88.910821048952357, 29.879611048710956],
                    [89.567186353767227, 30.175652174908123],
                    [90.227485254540966, 30.468406350073053],
                    [90.891742895418361, 30.757814874556914],
                    [91.559982459123376, 31.04381867639097],
                    [92.232225077925193, 31.326358334669521],
                    [92.908489742807546, 31.605374098436073],
                    [93.588793215334817, 31.880805918158728],
                    [94.273149936820289, 32.152593470912109],
                    [94.961571931199728, 32.420676186456888],
                    [95.654068719595841, 32.684993281414961],
                    [96.35064722409021, 32.945483788046431],
                    [97.051311675093871, 33.202086593821434],
                    [97.756063522313752, 33.454740470196725],
                    [98.464901341223992, 33.703384117583028],
                    [99.177820743132827, 33.947956200418503],
                    [99.894814288848465, 34.188395389435698],
                    [100.615871398746094, 34.424640405730202],
                    [101.340978269131995, 34.656630067523736],
                    [102.070117789504422, 34.884303333332298],
                    [102.803269464314326, 35.107599353227727],
                    [103.540409332924526, 35.326457518300003],
                    [104.281509899462378, 35.540817515516096],
                    [105.026540064472499, 35.750619377182659],
                    [105.775465056567214, 35.955803537603344],
                    [106.528246377568337, 36.156310894232433],
                    [107.284841745850088, 36.352082859836173],
                    [108.045205046875481, 36.543061425444535],
                    [108.809286292728359, 36.729189221505408],
                    [109.577031586138901, 36.910409579038969],
                    [110.348383089907713, 37.086666593488587],
                    [111.123279007120516, 37.257905185875813],
                    [111.901653568557322, 37.424071173845789],
                    [112.683437024599016, 37.585111329224446],
                    [113.468555649723612, 37.740973450864146],
                    [114.256931755995765, 37.891606425795999],
                    [115.04848371015521, 38.036960298478959],
                    [115.843125969587845, 38.176986336450454],
                    [116.640769119199604, 38.311637095975357],
                    [117.441319920877731, 38.440866487698315],
                    [118.244681378243172, 38.564629841394094],
                    [119.050752801400677, 38.682883972517288],
                    [119.859429891476339, 38.795587242457373],
                    [120.670604829649392, 38.902699620591079],
                    [121.484166380574152, 39.004182749934103],
                    [122.300000000224827, 39.100000000149976],
                    [122.162718328088431, 38.46824194700838],
                    [122.02782152394434, 37.83632646839186],
                    [121.895216553001546, 37.204259742693012],
                    [121.764814544255842, 36.572047669464496],
                    [121.636530550444718, 35.939695883858121],
                    [121.510283317820949, 35.307209775510898],
                    [121.385995076611721, 34.674594500236026],
                    [121.263591344065389, 34.041854993513255],
                    [121.143000739192985, 33.408995983977491],
                    [121.024154810096434, 32.776022005111543],
                    [120.906987871193337, 32.142937404237841],
                    [120.791436853927735, 31.509746356009543],
                    [120.677441160181615, 30.87645286870503],
                    [120.564942531872475, 30.243060795019858],
                    [120.453884925948614, 29.609573840160635],
                    [120.344214392979893, 28.975995569040379],
                    [120.235878967440499, 28.342329416169719],
                    [120.128828564287005, 27.708578690154525],
                    [120.023014879133484, 27.074746579091425],
                    [119.918391294722596, 26.440836162259188],
                    [119.814912793690496, 25.806850410118443],
                    [119.712535876729362, 25.172792192405836],
                    [119.611218482547088, 24.538664284429217],
                    [119.510919914122951, 23.904469371564346],
                    [119.411600767661525, 23.270210049254445],
                    [119.313222869639844, 22.635888836500669],
                    [119.215749208459215, 22.001508170465797],
                    [119.119143878687282, 21.367070419064646],
                    [119.023372021701448, 20.732577878266454],
                    [118.928399773530828, 20.098032777490801],
                    [118.834194212692978, 19.463437286801536],
                    [118.740723309832902, 18.828793513310131],
                    [118.647955883657119, 18.194103510168929],
                    [118.55586155506694, 17.559369277470296],
                    [118.46441070489027, 16.92459276404486],
                    [118.373574430715621, 16.289775871959023],
                    [118.283324513615639, 15.654920456514049],
                    [118.193633375879813, 15.020028332541699],
                    [118.104474047739245, 14.385101274404462],
                    [118.015820133192619, 13.750141016894531],
                    [117.927645774932671, 13.115149260630062],
                    [117.839925625567275, 12.480127671155174],
                    [117.752634814345242, 11.845077883437625],
                    [117.665748921975251, 11.210001503666547],
                    [117.579243945551752, 10.574900108353347],
                    [117.493096278770281, 9.939775247929333],
                    [117.407282678652905, 9.304628451242081],
                    [117.321780244862452, 8.669461221058668],
                    [117.236566390926214, 8.03427504215955],
                    [117.151618822650562, 7.399071378641395],
                    [117.066915511142156, 6.76385167751306],
                    [116.982434673921261, 6.128617369596043],
                    [116.898154747943408, 5.493369870423294],
                    [116.814054371611974, 4.858110582037909],
                    [116.730112358698534, 4.222840897489505],
                    [116.646307680355335, 3.587562196338354],
                    [116.562619442633377, 2.952275850050569],
                    [116.479026864897946, 2.316983224696116],
                    [116.395509260943868, 1.681685676452901],
                    [116.312046018309161, 1.046384559699732],
                    [116.228616576693867, 0.411081223419785],
                    [116.145200409071663, -0.224222984303253],
                    [116.06177700100784, -0.859526716284904],
                    [115.978325832671089, -1.494828626240007],
                    [115.894826354552833, -2.130127364286352],
                    [115.811257972177827, -2.765421578742746],
                    [115.727600022722982, -3.400709912532307],
                    [115.643831756130794, -4.035991004081495],
                    [115.559932312626302, -4.671263484622045],
                    [115.475880706529438, -5.306525973694704],
                    [115.391655800175158, -5.941777085444073],
                    [115.307236285026647, -6.577015420525186],
                    [115.222600659193176, -7.212239565203674],
                    [115.137727207644616, -7.847448094953563],
                    [115.052593977030483, -8.482639568161517],
                    [114.967178752297741, -9.117812524328485],
                    [114.881459036905198, -9.752965486767721],
                    [114.795412024045731, -10.388096956309425],
                    [114.709014575062724, -11.02320541309922],
                    [114.622243192469568, -11.658289313001319],
                    [114.53507399297041, -12.293347087597908],
                    [114.447482683179373, -12.928377138793792],
                    [114.35944452814249, -13.563377841514125],
                    [114.270934323460438, -14.198347538308212],
                    [114.18192636471008, -14.833284540249224],
                    [114.092394418667709, -15.468187121538392],
                    [114.002311687334668, -16.103053519504272],
                    [113.911650774663599, -16.737881933704216],
                    [113.820383655081628, -17.372670518729421],
                    [113.728481630323131, -18.007417387802093],
                    [113.635915297053543, -18.642120604682077],
                    [113.542654504601728, -19.276778185464764],
                    [113.448668309994673, -19.911388094085169],
                    [113.353924939284525, -20.545948237820824],
                    [113.258391738987712, -21.180456467292004],
                    [113.162035126619912, -21.814910568367964],
                    [113.064820542134385, -22.449308266663081],
                    [112.966712393062608, -23.08364721674559],
                    [112.867673999793283, -23.717924999663467],
                ]
            ],
        },
        {
            "zoneID": "7",
            "coordinates": [
                [
                    [113.556696912966117, -23.607058643670712],
                    [112.867673999793283, -23.717924999663467],
                    [112.966712393062608, -23.08364721674559],
                    [113.064820542134385, -22.449308266663081],
                    [113.162035126619912, -21.814910568367964],
                    [113.258391738987712, -21.180456467292004],
                    [113.353924939284525, -20.545948237820824],
                    [113.448668309994673, -19.911388094085169],
                    [113.542654504601728, -19.276778185464764],
                    [113.635915297053543, -18.642120604682077],
                    [113.728481630323131, -18.007417387802093],
                    [113.820383655081628, -17.372670518729421],
                    [113.911650774663599, -16.737881933704216],
                    [114.002311687334668, -16.103053519504272],
                    [114.092394418667709, -15.468187121538392],
                    [114.18192636471008, -14.833284540249224],
                    [114.270934323460438, -14.198347538308212],
                    [114.35944452814249, -13.563377841514125],
                    [114.447482683179373, -12.928377138793792],
                    [114.53507399297041, -12.293347087597908],
                    [114.622243192469568, -11.658289313001319],
                    [114.709014575062724, -11.02320541309922],
                    [114.795412024045731, -10.388096956309425],
                    [114.881459036905198, -9.752965486767721],
                    [114.967178752297741, -9.117812524328485],
                    [115.052593977030483, -8.482639568161517],
                    [115.137727207644616, -7.847448094953563],
                    [115.222600659193176, -7.212239565203674],
                    [115.307236285026647, -6.577015420525186],
                    [115.391655800175158, -5.941777085444073],
                    [115.475880706529438, -5.306525973694704],
                    [115.559932312626302, -4.671263484622045],
                    [115.643831756130794, -4.035991004081495],
                    [115.727600022722982, -3.400709912532307],
                    [115.811257972177827, -2.765421578742746],
                    [115.894826354552833, -2.130127364286352],
                    [115.978325832671089, -1.494828626240007],
                    [116.06177700100784, -0.859526716284904],
                    [116.145200409071663, -0.224222984303253],
                    [116.228616576693867, 0.411081223419785],
                    [116.312046018309161, 1.046384559699732],
                    [116.395509260943868, 1.681685676452901],
                    [116.479026864897946, 2.316983224696116],
                    [116.562619442633377, 2.952275850050569],
                    [116.646307680355335, 3.587562196338354],
                    [116.730112358698534, 4.222840897489505],
                    [116.814054371611974, 4.858110582037909],
                    [116.898154747943408, 5.493369870423294],
                    [116.982434673921261, 6.128617369596043],
                    [117.066915511142156, 6.76385167751306],
                    [117.151618822650562, 7.399071378641395],
                    [117.236566390926214, 8.03427504215955],
                    [117.321780244862452, 8.669461221058668],
                    [117.407282678652905, 9.304628451242081],
                    [117.493096278770281, 9.939775247929333],
                    [117.579243945551752, 10.574900108353347],
                    [117.665748921975251, 11.210001503666547],
                    [117.752634814345242, 11.845077883437625],
                    [117.839925625567275, 12.480127671155174],
                    [117.927645774932671, 13.115149260630062],
                    [118.015820133192619, 13.750141016894531],
                    [118.104474047739245, 14.385101274404462],
                    [118.193633375879813, 15.020028332541699],
                    [118.283324513615639, 15.654920456514049],
                    [118.373574430715621, 16.289775871959023],
                    [118.46441070489027, 16.92459276404486],
                    [118.55586155506694, 17.559369277470296],
                    [118.647955883657119, 18.194103510168929],
                    [118.740723309832902, 18.828793513310131],
                    [118.834194212692978, 19.463437286801536],
                    [118.928399773530828, 20.098032777490801],
                    [119.023372021701448, 20.732577878266454],
                    [119.119143878687282, 21.367070419064646],
                    [119.215749208459215, 22.001508170465797],
                    [119.313222869639844, 22.635888836500669],
                    [119.411600767661525, 23.270210049254445],
                    [119.510919914122951, 23.904469371564346],
                    [119.611218482547088, 24.538664284429217],
                    [119.712535876729362, 25.172792192405836],
                    [119.814912793690496, 25.806850410118443],
                    [119.918391294722596, 26.440836162259188],
                    [120.023014879133484, 27.074746579091425],
                    [120.128828564287005, 27.708578690154525],
                    [120.235878967440499, 28.342329416169719],
                    [120.344214392979893, 28.975995569040379],
                    [120.453884925948614, 29.609573840160635],
                    [120.564942531872475, 30.243060795019858],
                    [120.677441160181615, 30.87645286870503],
                    [120.791436853927735, 31.509746356009543],
                    [120.906987871193337, 32.142937404237841],
                    [121.024154810096434, 32.776022005111543],
                    [121.143000739192985, 33.408995983977491],
                    [121.263591344065389, 34.041854993513255],
                    [121.385995076611721, 34.674594500236026],
                    [121.510283317820949, 35.307209775510898],
                    [121.636530550444718, 35.939695883858121],
                    [121.764814544255842, 36.572047669464496],
                    [121.895216553001546, 37.204259742693012],
                    [122.02782152394434, 37.83632646839186],
                    [122.162718328088431, 38.46824194700838],
                    [122.300000000224827, 39.100000000149976],
                    [123.028247883166728, 38.800304659816391],
                    [123.750350649181655, 38.496127199305533],
                    [124.466337589154364, 38.187553621201346],
                    [125.17624210919314, 37.874669194114119],
                    [125.880101500941805, 37.557558410146271],
                    [126.577956726061075, 37.236304940360355],
                    [127.269852195711451, 36.910991598341752],
                    [127.955835565329608, 36.581700300364218],
                    [128.635957525659933, 36.248512036100863],
                    [129.310271605325283, 35.911506840134507],
                    [129.978833978652801, 35.570763767916958],
                    [130.641703277142369, 35.2263608719785],
                    [131.29894041238515, 34.878375183084302],
                    [131.950608399179259, 34.526882696939595],
                    [132.59677219079208, 34.171958358046027],
                    [133.237498519370661, 33.813676050804702],
                    [133.872855741299759, 33.452108589419936],
                    [134.502913691106983, 33.087327714351261],
                    [135.12774354001624, 32.719404086364761],
                    [135.747417666196384, 32.348407286233623],
                    [136.362009523660618, 31.974405812289206],
                    [136.971593523711249, 31.597467086168763],
                    [137.576244921033208, 31.217657453214599],
                    [138.176039704734535, 30.835042185874329],
                    [138.771054495934322, 30.449685495894528],
                    [139.36136645229999, 30.061650535371996],
                    [139.947053175681958, 29.670999410047557],
                    [140.52819262904336, 29.277793186203269],
                    [141.104863054393149, 28.882091904159154],
                    [141.677142898263014, 28.483954588067093],
                    [142.245110743033251, 28.083439259207182],
                    [142.808845240208029, 27.680602948333785],
                    [143.368425049388179, 27.275501713166932],
                    [143.923928783293604, 26.868190647840152],
                    [144.475434955179594, 26.458723902293229],
                    [145.023021929659535, 26.04715469616616],
                    [145.566767879017334, 25.633535335143961],
                    [146.106750743176349, 25.217917226249483],
                    [146.643048190210948, 24.800350898187844],
                    [147.175737586110472, 24.380886012189933],
                    [147.704895960190242, 23.959571387155052],
                    [148.230599979102976, 23.536455008595851],
                    [148.752925922146801, 23.11158405388079],
                    [149.271949658125095, 22.685004905176129],
                    [149.787746626352941, 22.256763168292878],
                    [150.300391819213587, 21.826903691376117],
                    [150.809959766914972, 21.395470582050962],
                    [151.316524525193358, 20.962507224864396],
                    [151.820159663119057, 20.528056301228673],
                    [152.32093825629795, 20.092159804165874],
                    [152.818932878025066, 19.654859058049738],
                    [153.31421559488706, 19.2161947361991],
                    [153.806857963062384, 18.776206877972697],
                    [154.296931025023468, 18.33493490616047],
                    [154.784505309936321, 17.892417646078798],
                    [155.269650833209653, 17.448693338213673],
                    [155.752437098946643, 17.003799662462256],
                    [156.232933104039944, 16.557773748080137],
                    [156.711207337374276, 16.110652195321222],
                    [157.187327791172265, 15.662471089384667],
                    [157.661361963242143, 15.213266019205776],
                    [158.133376863275771, 14.763072093101471],
                    [158.603439024145928, 14.311923952064433],
                    [159.07161450520266, 13.85985579200576],
                    [159.537968907969457, 13.406901372750326],
                    [160.002567377941205, 12.953094039279279],
                    [160.465474624077501, 12.498466735175953],
                    [160.926754923050794, 12.043052018018102],
                    [161.386472131991809, 11.586882073224615],
                    [161.844689704133316, 11.129988732546963],
                    [162.301470698307185, 10.67240348686596],
                    [162.756877791238594, 10.214157501134025],
                    [163.210973295040844, 9.75528162937178],
                    [163.663819164811684, 9.295806430111384],
                    [164.115477019924469, 8.835762179140659],
                    [164.566008152127552, 8.375178885248715],
                    [165.015473543484518, 7.914086302470366],
                    [165.463933881121989, 7.452513946230852],
                    [165.911449572220135, 6.990491107939306],
                    [166.358080758910205, 6.528046864485646],
                    [166.803887333216949, 6.065210096884357],
                    [167.248928955253632, 5.60200950126881],
                    [167.693265067264633, 5.138473602537317],
                    [168.136954910270561, 4.67463076834764],
                    [168.580057540161761, 4.210509223311021],
                    [169.022631844742136, 3.746137059039143],
                    [169.464736558822665, 3.281542252486474],
                    [169.90643028231591, 2.816752673248743],
                    [170.347771496328733, 2.351796101804439],
                    [170.788818579157237, 1.88670023906252],
                    [171.229629824828635, 1.421492721156255],
                    [171.670263456796647, 0.956201131138698],
                    [172.110777648834869, 0.490853014177674],
                    [172.551230539179073, 0.025475887051357],
                    [172.991680248122634, -0.439902744857818],
                    [173.432184894958709, -0.905255378966217],
                    [173.87280261507442, -1.370554499945001],
                    [174.313591577994544, -1.835772566425533],
                    [174.754610000030539, -2.30088200000074],
                    [174.506848879120525, -2.418709631918887],
                    [174.506848567318457, -2.418709780137021],
                    [174.175528233940895, -2.576275624620337],
                    [173.596196061199748, -2.851406328919381],
                    [173.016586850001772, -3.126245856930268],
                    [172.436674032940346, -3.400765929751969],
                    [171.856431110303788, -3.674938241753182],
                    [171.275831657752633, -3.948734460813341],
                    [170.694849333165052, -4.222126222623615],
                    [170.113457884087097, -4.495085131586791],
                    [169.531631151228339, -4.767582756619561],
                    [168.9493430790601, -5.039590632050874],
                    [168.366567719012664, -5.311080252525926],
                    [167.783279241372043, -5.582023073702942],
                    [167.199451936278933, -5.852390509707163],
                    [166.615060225924481, -6.122153929630088],
                    [166.030078669797831, -6.391284659929511],
                    [165.444481972282688, -6.659753978831532],
                    [164.858244990807066, -6.92753311762965],
                    [164.271342743136643, -7.194593257886197],
                    [163.683750416224484, -7.46090553058292],
                    [163.095443373106718, -7.726441015470357],
                    [162.506397161449854, -7.991170738819278],
                    [161.916587522698364, -8.25506567487048],
                    [161.325990399818693, -8.518096740985868],
                    [160.734581947099741, -8.780234801047584],
                    [160.142338537096975, -9.041450661659326],
                    [159.549236772929476, -9.301715074895355],
                    [158.955253493977125, -9.560998733752285],
                    [158.360365786826037, -9.819272275747494],
                    [157.764550997015476, -10.07650628067023],
                    [157.167786735284949, -10.332671271930792],
                    [156.570050889868526, -10.587737715711512],
                    [155.971321635842742, -10.841676020815839],
                    [155.371577445721641, -11.094456540718454],
                    [154.770797100203026, -11.346049573914343],
                    [154.168959699215407, -11.596425363069898],
                    [153.566044671212467, -11.845554097821719],
                    [152.962031787018759, -12.093405915675191],
                    [152.356901167327692, -12.339950902056103],
                    [151.750633298943853, -12.585159092759],
                    [151.143209042632066, -12.829000477045099],
                    [150.534609646009358, -13.071444995545107],
                    [149.924816756894074, -13.312462547054395],
                    [149.313812433048838, -13.552022986985548],
                    [148.701579157026345, -13.790096132765143],
                    [148.08809984506604, -14.026651763933728],
                    [147.473357866086417, -14.261659627894687],
                    [146.857337046883799, -14.495089439812887],
                    [146.240021689125001, -14.726910888813109],
                    [145.621396582243278, -14.95709363943007],
                    [145.001447016133625, -15.185607336704663],
                    [144.380158792997122, -15.412421610134459],
                    [143.757518243936147, -15.637506076921909],
                    [143.133512237000218, -15.860830348021011],
                    [142.50812819612986, -16.082364031637439],
                    [141.88135411205144, -16.302076738725304],
                    [141.253178554073656, -16.519938086936406],
                    [140.623590687180354, -16.735917710017077],
                    [139.992580282927065, -16.94998525825639],
                    [139.360137734034879, -17.16211040803438],
                    [138.726254065886451, -17.372262867868528],
                    [138.090920953919635, -17.580412383712257],
                    [137.454130732223803, -17.786528744602947],
                    [136.815876411083877, -17.990581794007198],
                    [136.17615168587588, -18.192541432270389],
                    [135.534950953211933, -18.392377627912595],
                    [134.8922693223858, -18.590060422775082],
                    [134.248102628067045, -18.785559941119004],
                    [133.602447442097969, -18.978846399120926],
                    [132.955301087837711, -19.16989011091988],
                    [132.306661648058594, -19.358661500963706],
                    [131.65652798119072, -19.545131107857173],
                    [131.00489972831997, -19.729269599905933],
                    [130.351777326981278, -19.911047779915464],
                    [129.697162021005397, -20.090436597935252],
                    [129.041055869166598, -20.267407158856543],
                    [128.383461756977454, -20.441930735157541],
                    [127.724383404185346, -20.613978775550152],
                    [127.063825375820443, -20.783522917024413],
                    [126.401793087190754, -20.950534994697136],
                    [125.738292814081319, -21.114987053254765],
                    [125.073331698199695, -21.276851359651289],
                    [124.406917755375162, -21.436100411702398],
                    [123.739059879804927, -21.5927069540312],
                    [123.069767850053267, -21.746643985065816],
                    [122.399052332149722, -21.897884772632153],
                    [121.726924886037523, -22.046402864800143],
                    [121.05339796607177, -22.192172102830114],
                    [120.3784849243699, -22.335166631917275],
                    [119.702200010861134, -22.475360916886302],
                    [119.024558374984622, -22.612729752088001],
                    [118.345576066391118, -22.747248273794355],
                    [117.665270031093769, -22.87889197474243],
                    [116.983658110366719, -23.007636717530318],
                    [116.300759039099262, -23.133458744912446],
                    [115.616592439394822, -23.256334695094893],
                    [114.931178817974228, -23.376241612530293],
                    [114.24453955787726, -23.493156962511932],
                    [113.556696912966117, -23.607058643670712],
                ]
            ],
        },
        {
            "zoneID": "8",
            "coordinates": [
                [
                    [-67.132326000344619, 23.717925000538514],
                    [-67.759069568705513, 23.434020427700602],
                    [-68.383115010848996, 23.147625015182427],
                    [-69.004487692153248, 22.85878336036393],
                    [-69.623213950163574, 22.567539808815241],
                    [-70.239321045130112, 22.273938451598326],
                    [-70.852837128530609, 21.978023113576],
                    [-71.463791198105241, 21.679837349813852],
                    [-72.072213067279165, 21.379424440185744],
                    [-72.678133323793816, 21.076827384875912],
                    [-73.281583297331224, 20.772088898983554],
                    [-73.882595022642079, 20.465251407126914],
                    [-74.481201208968571, 20.156357047040217],
                    [-75.077435206769337, 19.845447659681781],
                    [-75.671330975344176, 19.532564791032371],
                    [-76.262923051357689, 19.217749689396783],
                    [-76.852246522758719, 18.901043305404244],
                    [-77.439336997304565, 18.582486291109433],
                    [-78.024230578278548, 18.262118999092593],
                    [-78.606963833913767, 17.939981482459416],
                    [-79.187573774909765, 17.61611349843929],
                    [-79.766097827452711, 17.290554503887336],
                    [-80.342573812531384, 16.963343664278739],
                    [-80.917039921654975, 16.634519849211756],
                    [-81.489534693471228, 16.304121636004822],
                    [-82.060096994880325, 15.972187315092583],
                    [-82.628766002149177, 15.638754888227595],
                    [-83.195581177529277, 15.303862076573694],
                    [-83.760582254867131, 14.9675463198069],
                    [-84.323809221618205, 14.629844782410885],
                    [-84.885302300860417, 14.290794354575894],
                    [-85.445101933307512, 13.950431659393644],
                    [-86.003248768315927, 13.608793056454488],
                    [-86.559783644999186, 13.265914645444582],
                    [-87.114747578737649, 12.921832271542087],
                    [-87.668181750387419, 12.576581529913653],
                    [-88.2201274900915, 12.230197771110397],
                    [-88.770626272784227, 11.882716104664667],
                    [-89.319719699304585, 11.534171409882788],
                    [-89.867449491900459, 11.184598334945292],
                    [-90.413857480738045, 10.834031305000792],
                    [-90.958985596707862, 10.482504529360597],
                    [-91.502875864229736, 10.130052007794063],
                    [-92.045570389561817, 9.776707532326725],
                    [-92.587111358102675, 9.422504699832018],
                    [-93.127541020901333, 9.067476912030031],
                    [-93.66690169465744, 8.711657387178775],
                    [-94.205235753627051, 8.355079162773166],
                    [-94.742585620629825, 7.997775104537538],
                    [-95.278993767048689, 7.639777911821227],
                    [-95.814502703836638, 7.281120124793972],
                    [-96.349154980617811, 6.921834130740706],
                    [-96.882993179391633, 6.561952173054351],
                    [-97.416059910036722, 6.201506354834464],
                    [-97.94839780941129, 5.840528647878841],
                    [-98.480049536856598, 5.479050898979892],
                    [-99.01105777239826, 5.117104838917271],
                    [-99.541465212249705, 4.754722086954871],
                    [-100.071314567912964, 4.391934159833681],
                    [-100.600648565278959, 4.028772477168275],
                    [-101.129509940131584, 3.665268371338357],
                    [-101.657941439046112, 3.301453091087467],
                    [-102.185985815792662, 2.93735781411192],
                    [-102.713685830436702, 2.573013648860865],
                    [-103.241084251137181, 2.208451643528576],
                    [-103.768223849650838, 1.843702797745948],
                    [-104.295147400432086, 1.478798061681346],
                    [-104.821897682431995, 1.113768352227737],
                    [-105.348517476400389, 0.748644553003828],
                    [-105.87504956668414, 0.383457527842779],
                    [-106.401536734932336, 0.018238122591413],
                    [-106.928021767290659, -0.34698282139999],
                    [-107.454547447206892, -0.712174467277748],
                    [-107.981156559927285, -1.077305967396399],
                    [-108.507891886201548, -1.442346462419266],
                    [-109.034796209477463, -1.807265068727872],
                    [-109.561912307806722, -2.172030874824884],
                    [-110.089282955643796, -2.536612932340915],
                    [-110.616950927443327, -2.900980248839346],
                    [-111.14495898956568, -3.265101780622558],
                    [-111.673349902975588, -3.628946425537038],
                    [-112.202166423241806, -3.99248301218114],
                    [-112.731451296939724, -4.355680300805204],
                    [-113.261247261651704, -4.718506967122778],
                    [-113.791597044168157, -5.080931600512827],
                    [-114.322543356890321, -5.442922694126935],
                    [-114.854128897830265, -5.804448638593669],
                    [-115.386396348812355, -6.16547771572391],
                    [-115.919388371875812, -6.525978091315778],
                    [-116.45314760567743, -6.885917804363146],
                    [-116.98771666279373, -7.24526476525665],
                    [-117.523138129720849, -7.603986746790895],
                    [-118.059454557881452, -7.962051375170745],
                    [-118.59670846182604, -8.319426126414555],
                    [-119.134942318333287, -8.676078316461087],
                    [-119.67419855561883, -9.031975097572627],
                    [-120.21451955243532, -9.387083448442297],
                    [-120.755947629979119, -9.741370170596781],
                    [-121.298525049191653, -10.094801879403121],
                    [-121.842293999980882, -10.447344999743109],
                    [-122.014236440729576, -9.829346820549688],
                    [-122.185537369176927, -9.21126217045645],
                    [-122.356239938911017, -8.593096877759365],
                    [-122.526386748924608, -7.974856693590766],
                    [-122.696019880756467, -7.356547296060398],
                    [-122.865180944772362, -6.73817429900231],
                    [-123.033911115252749, -6.119743254623813],
                    [-123.20225117307649, -5.501259662051837],
                    [-123.370241542006681, -4.882728969882976],
                    [-123.537922328626394, -4.264156583529882],
                    [-123.705333357224163, -3.645547867670018],
                    [-123.872514208881739, -3.026908155793365],
                    [-124.039504254758754, -2.408242750601289],
                    [-124.206342696079162, -1.789556930603908],
                    [-124.373068595369432, -1.170855957768083],
                    [-124.539720915743828, -0.552145077016689],
                    [-124.706338551991223, 0.066570473324248],
                    [-124.872960370162332, 0.685285460227988],
                    [-125.039625237707298, 1.30399465151595],
                    [-125.206372061760646, 1.922692807063925],
                    [-125.373239823879373, 2.54137467904917],
                    [-125.540267614029574, 3.160035002206826],
                    [-125.707494665673153, 3.778668492328563],
                    [-125.874960393053811, 4.397269842014907],
                    [-126.042704426484192, 5.015833710178867],
                    [-126.210766647981075, 5.634354725045341],
                    [-126.379187228603882, 6.252827471205478],
                    [-126.548006665937351, 6.871246491166346],
                    [-126.71726582277978, 7.489606272955598],
                    [-126.88700596382705, 8.107901252970294],
                    [-127.057268796058906, 8.726125803231753],
                    [-127.228096510872604, 9.344274230435701],
                    [-127.399531821868038, 9.962340767406147],
                    [-127.571618008981943, 10.580319569796302],
                    [-127.744398961071568, 11.198204706991078],
                    [-127.917919222296973, 11.815990158509351],
                    [-128.092224034305673, 12.43366980685829],
                    [-128.26735938591338, 13.051237429732055],
                    [-128.44337205993628, 13.668686695067663],
                    [-128.620309684922006, 14.286011153396032],
                    [-128.798220785230342, 14.903204228846334],
                    [-128.977154837012961, 15.520259214245755],
                    [-129.15716232014239, 16.137169262925681],
                    [-129.338294778040677, 16.753927377473133],
                    [-129.520604877706489, 17.370526405334715],
                    [-129.704146469841817, 17.986959028118463],
                    [-129.88897465572785, 18.603217752248725],
                    [-130.075145851949685, 19.219294900020031],
                    [-130.26271786201977, 19.835182598548954],
                    [-130.45174994780092, 20.450872771980585],
                    [-130.642302909025943, 21.066357127389836],
                    [-130.834439156820736, 21.681627145738332],
                    [-131.028222803019844, 22.296674068176856],
                    [-131.223719742735966, 22.911488885551705],
                    [-131.420997747923764, 23.526062323058966],
                    [-131.620126560845961, 24.140384829248205],
                    [-131.82117799478425, 24.754446558281188],
                    [-132.024226037800702, 25.368237358383624],
                    [-132.229346963995511, 25.98174675155559],
                    [-132.436619448614351, 26.594963921773967],
                    [-132.646124687202132, 27.207877693000796],
                    [-132.857946526105536, 27.820476513390247],
                    [-133.072171594271595, 28.4327484342964],
                    [-133.288889445545806, 29.044681088930759],
                    [-133.508192706114187, 29.656261672968981],
                    [-133.730177232096707, 30.267476918112777],
                    [-133.954942273983363, 30.878313070246122],
                    [-134.182590651018756, 31.488755861996935],
                    [-134.413228933983987, 32.098790487545386],
                    [-134.646967641171727, 32.708401570188244],
                    [-134.883921440661027, 33.317573134546194],
                    [-135.124209367933929, 33.926288572329952],
                    [-135.367955056740243, 34.534530608950263],
                    [-135.615286977006178, 35.142281265234203],
                    [-135.866338694987348, 35.749521820138114],
                    [-136.121249141617341, 36.356232769363487],
                    [-136.380162902747884, 36.962393779124852],
                    [-136.643230521835562, 37.567983641016326],
                    [-136.910608823219036, 38.172980221429896],
                    [-137.182461254591658, 38.777360410027541],
                    [-137.458958249911632, 39.381100059360165],
                    [-137.740277616109438, 39.984173928342102],
                    [-138.02660494293184, 40.58655561527479],
                    [-138.318134034278955, 41.188217491172168],
                    [-138.615067375729382, 41.7891306211406],
                    [-138.917616622904347, 42.389264691456049],
                    [-139.226003123072701, 42.98858792299734],
                    [-139.540458473739875, 43.587066980128668],
                    [-139.861225110675207, 44.184666874338291],
                    [-140.188556940125181, 44.781350862326349],
                    [-140.522720006011639, 45.377080333295339],
                    [-140.863993203311622, 45.971814689198254],
                    [-141.212669039344576, 46.565511221265922],
                    [-141.540991629950724, 47.111460856080782],
                    [-141.569054440055083, 47.158124964447666],
                    [-141.933471610763149, 47.749608558644013],
                    [-142.306258956242687, 48.33991208398777],
                    [-142.687772053868628, 48.928982892323404],
                    [-143.07838469674823, 49.516765421793593],
                    [-143.478490000006673, 50.103200999963235],
                    [-142.483510217322646, 50.164998038428848],
                    [-141.486132169364112, 50.218274829719689],
                    [-140.486703298418433, 50.262996186924681],
                    [-139.485576437302711, 50.299132431516512],
                    [-138.483108912746047, 50.326659483248591],
                    [-137.479661618189084, 50.345558940192973],
                    [-136.475598066797261, 50.355818140794725],
                    [-135.471283421092949, 50.357430198944598],
                    [-134.467083517190531, 50.350394034557098],
                    [-133.463363883636305, 50.334714369972289],
                    [-132.460488762945999, 50.310401716466174],
                    [-131.458820135840483, 50.277472343673764],
                    [-130.458716768863724, 50.235948221133469],
                    [-129.460533276389583, 50.185856951736923],
                    [-128.464619215004689, 50.127231681796843],
                    [-127.471318200374583, 50.060110994926617],
                    [-126.480967074470868, 49.984538790632712],
                    [-125.493895107872902, 49.900564150315404],
                    [-124.510423245236495, 49.808241180785956],
                    [-123.530863410118172, 49.707628854188442],
                    [-122.555517854765071, 49.598790828134383],
                    [-121.584678572857797, 49.481795263141009],
                    [-120.618626764413534, 49.356714621182959],
                    [-119.6576323627433, 49.223625460646645],
                    [-118.701953624360215, 49.082608225889032],
                    [-117.751836774647359, 48.933747028702498],
                    [-116.807515719175058, 48.777129422584835],
                    [-115.869211810776335, 48.612846181506256],
                    [-114.93713367417962, 48.440991066085019],
                    [-114.011477097190266, 48.261660598757715],
                    [-113.092424964140776, 48.074953832653364],
                    [-112.180147249595791, 47.880972126762401],
                    [-111.274801061519724, 47.679818915710541],
                    [-110.37653073120822, 47.471599493022211],
                    [-109.485467941891955, 47.256420788988407],
                    [-108.6017319112986, 47.0343911620227],
                    [-107.725429596698461, 46.80562018642263],
                    [-106.856655943117175, 46.570218452719473],
                    [-105.995494161226532, 46.328297375223826],
                    [-105.142016033113407, 46.079968999569815],
                    [-104.296282234237708, 45.825345830046047],
                    [-103.4583426904627, 45.564540648831951],
                    [-102.628236937784436, 45.297666358615686],
                    [-101.805994505442015, 45.024835824313925],
                    [-100.991635311620314, 44.74616172378461],
                    [-100.185170058251515, 44.461756414726892],
                    [-99.386600641106668, 44.17173179798408],
                    [-98.595920562583785, 43.876199197035476],
                    [-97.813115340000877, 43.575269247377946],
                    [-97.038162919283195, 43.269051787709941],
                    [-96.271034083256325, 42.957655763702633],
                    [-95.511692857239552, 42.641189136269816],
                    [-94.760096904748309, 42.319758804225557],
                    [-94.016197922296158, 41.993470524245481],
                    [-93.279942023405624, 41.662428845215061],
                    [-92.551270107329515, 41.326737049775147],
                    [-91.830118228673257, 40.986497094065726],
                    [-91.116417946331069, 40.641809567257837],
                    [-90.410096663430238, 40.292773644787928],
                    [-89.711077960079706, 39.939487052385743],
                    [-89.019281907234188, 39.582046036395639],
                    [-88.334625370664298, 39.220545335898521],
                    [-87.657022300538699, 38.855078164725626],
                    [-86.986384011113159, 38.485736191671947],
                    [-86.322619444231862, 38.112609529706162],
                    [-85.665635419339083, 37.735786726076697],
                    [-85.015336878094388, 37.35535475781586],
                    [-84.371627102908462, 36.971399030840757],
                    [-83.734407937276444, 36.58400338175079],
                    [-83.103579984528551, 36.193250079627546],
                    [-82.479042796687679, 35.799219836826069],
                    [-81.860695056131874, 35.401991814370831],
                    [-81.248434741969731, 35.001643637244115],
                    [-80.642159282924524, 34.598251406976999],
                    [-80.041765709319918, 34.191889714239096],
                    [-79.447150783481788, 33.782631661322114],
                    [-78.858211129240203, 33.370548876529597],
                    [-78.274843350640083, 32.955711536658214],
                    [-77.696944135363537, 32.538188385885348],
                    [-77.124410359050728, 32.118046760050106],
                    [-76.557139177031331, 31.695352608236419],
                    [-75.995028106162124, 31.270170517955137],
                    [-75.437975103068538, 30.842563737626392],
                    [-74.885878636090126, 30.412594205358346],
                    [-74.338637745535436, 29.980322568731538],
                    [-73.796152104835699, 29.545808218074797],
                    [-73.258322070906729, 29.10910930535033],
                    [-72.725048730914182, 28.670282776529007],
                    [-72.196233940044181, 28.229384394974034],
                    [-71.671780362873392, 27.786468768419013],
                    [-71.151591503944644, 27.34158937684839],
                    [-70.635571732049698, 26.894798597677209],
                    [-70.123626307208269, 26.446147735429804],
                    [-69.615661399553858, 25.995687043322562],
                    [-69.111584102823997, 25.543465756539604],
                    [-68.611302453245514, 25.089532110218897],
                    [-68.114725432232888, 24.633933372727142],
                    [-67.621762981676227, 24.176715867243502],
                    [-67.132326000344619, 23.717925000538514],
                ]
            ],
        },
        {
            "zoneID": "9",
            "coordinates": [
                [
                    [10.090688749286414, 64.088850322784197],
                    [9.664342000982629, 63.476397622052673],
                    [9.255892625644208, 62.862730486722626],
                    [8.864179902480544, 62.24792985038232],
                    [8.488138087203026, 61.632069782994165],
                    [8.12678715710166, 61.015218193265071],
                    [7.779224581349411, 60.397437442883756],
                    [7.444617989728499, 59.778784896006187],
                    [7.122198639056023, 59.15931339949384],
                    [6.81125557298634, 58.539071718185312],
                    [6.511130392453708, 57.918104911712362],
                    [6.221212583693841, 57.296454679839655],
                    [5.940935304920458, 56.674159663737555],
                    [5.669771619064988, 56.051255720275321],
                    [5.407231087145021, 55.427776165737498],
                    [5.152856706971477, 54.803751996157757],
                    [4.906222143237358, 54.179212083370999],
                    [4.666929223804686, 53.554183352180019],
                    [4.434605677010438, 52.928690943132551],
                    [4.208903074917032, 52.302758355513731],
                    [3.989494969916962, 51.676407579546208],
                    [3.776075194114981, 51.049659214201426],
                    [3.568356321487101, 50.422532578715561],
                    [3.366068255945322, 49.795045805219786],
                    [3.16895694980343, 49.167215934967487],
                    [2.976783229262651, 48.539058992078878],
                    [2.789321718822293, 47.910590065379267],
                    [2.606359861018802, 47.281823373150189],
                    [2.427697012607098, 46.652772323384056],
                    [2.253143616284888, 46.023449574938013],
                    [2.08252044256443, 45.393867086996522],
                    [1.915657884703649, 44.764036170333043],
                    [1.752395320187929, 44.133967525980609],
                    [1.592580509083291, 43.503671291097248],
                    [1.436069052644712, 42.873157075838435],
                    [1.282723880702576, 42.24243399573237],
                    [1.132414785813751, 41.611510704055775],
                    [0.985017987989806, 40.980395423310199],
                    [0.840415733599286, 40.349095972201383],
                    [0.698495922149164, 39.717619788122761],
                    [0.559151760045722, 39.085973953235396],
                    [0.422281440436166, 38.454165216951253],
                    [0.287787840136787, 37.822200013919542],
                    [0.155578246239145, 37.190084485610555],
                    [0.025564095306777, 36.557824492006773],
                    [-0.10233927034102, 35.925425637683077],
                    [-0.228212824762011, 35.292893276303687],
                    [-0.352134073328784, 34.660232533104988],
                    [-0.474177242485723, 34.027448313888613],
                    [-0.594413472203939, 33.394545318511689],
                    [-0.71291098145656, 32.761528051678283],
                    [-0.829735233694009, 32.128400836429535],
                    [-0.944949085232054, 31.49516781953929],
                    [-1.058612929143294, 30.861832985903618],
                    [-1.170784828357114, 30.228400165735138],
                    [-1.281520638866368, 29.594873041757523],
                    [-1.390874130236853, 28.961255157299718],
                    [-1.498897094425331, 28.327549925288849],
                    [-1.605639450999831, 27.693760634545697],
                    [-1.711149344266801, 27.059890456079756],
                    [-1.815473237699734, 26.425942449384593],
                    [-1.918656001173474, 25.791919566934496],
                    [-2.02074099190321, 25.157824662278415],
                    [-2.121770134484052, 24.523660493636896],
                    [-2.221783991937627, 23.889429730197946],
                    [-2.32082184215426, 23.255134953015727],
                    [-2.418921734550338, 22.620778665802845],
                    [-2.516120562913613, 21.986363291332907],
                    [-2.612454116664082, 21.35189118403099],
                    [-2.707957144706427, 20.71736462457784],
                    [-2.802663402194185, 20.082785832500235],
                    [-2.896605708086895, 19.448156962573819],
                    [-2.989815989216481, 18.813480111118281],
                    [-3.08232532975012, 18.178757319594695],
                    [-3.174164016156396, 17.543990575504722],
                    [-3.26536157497668, 16.909181816887383],
                    [-3.355946816892015, 16.274332934117638],
                    [-3.445947878092056, 15.639445774403043],
                    [-3.535392249053018, 15.004522139984829],
                    [-3.624306819504056, 14.369563795332965],
                    [-3.712717906306295, 13.734572465347071],
                    [-3.800651288526069, 13.099549841651935],
                    [-3.888132237112984, 12.464497580798763],
                    [-3.975185549973105, 11.829417307862514],
                    [-4.061835575351495, 11.194310620039118],
                    [-4.148106244207781, 10.55917908394764],
                    [-4.234021095397168, 9.92402424462324],
                    [-4.31960330444889, 9.288847619222281],
                    [-4.404875706948246, 8.653650704216659],
                    [-4.489860824617324, 8.018434975393859],
                    [-4.574580889596348, 7.383201888756219],
                    [-4.659057866926958, 6.747952884118376],
                    [-4.743313480632594, 6.112689383308464],
                    [-4.827369233503305, 5.477412794664815],
                    [-4.911246428679704, 4.842124514834552],
                    [-4.994966195733298, 4.20682592607568],
                    [-5.078549505954868, 3.571518401652952],
                    [-5.16201719933423, 2.936203307636561],
                    [-5.245389999848555, 2.300882000204183],
                    [-5.824471766059105, 2.576275625719575],
                    [-6.403803938600845, 2.851406329938243],
                    [-6.983413149996807, 3.126245857060724],
                    [-7.563325967119624, 3.400765929703937],
                    [-8.143568889392668, 3.674938242605833],
                    [-8.724168342494977, 3.948734461726076],
                    [-9.305150666669874, 4.222126223346606],
                    [-9.886542115825932, 4.495085132273061],
                    [-10.468368848543491, 4.767582757338403],
                    [-11.050656920880158, 5.039590632301895],
                    [-11.633432280974944, 5.311080253151204],
                    [-12.216720758256315, 5.582023074505344],
                    [-12.800548063442307, 5.852390509614395],
                    [-13.384939774151235, 6.122153930359673],
                    [-13.969921330405043, 6.391284660059057],
                    [-14.555518027434971, 6.65975397886308],
                    [-15.141755009386145, 6.927533117459461],
                    [-15.72865725672699, 7.194593257972542],
                    [-16.316249583551382, 7.460905531265325],
                    [-16.904556626786871, 7.726441016040098],
                    [-17.493602838100458, 7.991170739737925],
                    [-18.083412477603702, 8.255065675840342],
                    [-18.674009600362695, 8.518096742071066],
                    [-19.26541805280084, 8.78023480129508],
                    [-19.85766146280622, 9.041450662418185],
                    [-20.450763227141181, 9.301715074990739],
                    [-21.044746506046351, 9.56099873370465],
                    [-21.639634213348245, 9.819272275695027],
                    [-22.235449002969062, 10.076506281439777],
                    [-22.83221326443055, 10.332671272061589],
                    [-23.429949110263181, 10.58773771562312],
                    [-24.028678364314999, 10.841676020831756],
                    [-24.628422554557176, 11.094456541536204],
                    [-25.2292028995941, 11.346049574028655],
                    [-25.831040300569384, 11.596425363339904],
                    [-26.433955328575507, 11.845554098742696],
                    [-27.037968212962596, 12.09340591644991],
                    [-27.643098832345174, 12.339950902312353],
                    [-28.249366701112308, 12.585159093617335],
                    [-28.85679095773645, 12.829000477290265],
                    [-29.465390353981604, 13.071444996189655],
                    [-30.075183243212052, 13.312462547308769],
                    [-30.686187566902674, 13.552022987171142],
                    [-31.298420842947507, 13.790096133629731],
                    [-31.911900154868192, 14.026651764967028],
                    [-32.526642133827352, 14.261659628888822],
                    [-33.142662953232673, 14.495089440725167],
                    [-33.759978310750398, 14.726910889725843],
                    [-34.378603417513659, 14.957093639959567],
                    [-34.998552983733191, 15.185607337508657],
                    [-35.619841207006061, 15.412421610468982],
                    [-36.242481756128086, 15.637506077943215],
                    [-36.866487762999839, 15.860830348242018],
                    [-37.491871803740707, 16.082364032374244],
                    [-38.118645887897344, 16.302076738650612],
                    [-38.746821445853016, 16.519938087972434],
                    [-39.376409312639623, 16.735917710234162],
                    [-40.007419717146206, 16.949985258712786],
                    [-40.639862265930788, 17.162110409168122],
                    [-41.273745934227463, 17.372262868836401],
                    [-41.909079046161025, 17.580412383624662],
                    [-42.545869267552632, 17.786528745305418],
                    [-43.184123588832506, 17.990581794214506],
                    [-43.823848314248266, 18.192541432740995],
                    [-44.465049046576212, 18.392377628025145],
                    [-45.107730677228915, 18.590060422750355],
                    [-45.751897371866164, 18.78555994143818],
                    [-46.397552557804261, 18.978846399441807],
                    [-47.044698912324918, 19.169890111939139],
                    [-47.693338351883369, 19.358661501127415],
                    [-48.343472018618741, 19.545131108813678],
                    [-48.9951002713604, 19.72926960001206],
                    [-49.648222673037878, 19.911047780930403],
                    [-50.302837978989487, 20.090436598070596],
                    [-50.958944130667078, 20.267407159812649],
                    [-51.616538243045454, 20.441930735515086],
                    [-52.275616595629344, 20.613978776199588],
                    [-52.93617462435941, 20.783522917248888],
                    [-53.598206912618878, 20.950534994594364],
                    [-54.261707185837906, 21.114987053709626],
                    [-54.926668301600785, 21.27685136040202],
                    [-55.593082244250127, 21.436100412504061],
                    [-56.260940120390217, 21.592706954262553],
                    [-56.930232149893754, 21.74664398533173],
                    [-57.600947667700666, 21.897884773363671],
                    [-58.273075113925302, 22.046402864800427],
                    [-58.94660203385672, 22.192172102860297],
                    [-59.621515075260447, 22.335166632933806],
                    [-60.297799989278019, 22.475360917872138],
                    [-60.975441625030953, 22.612729752376197],
                    [-61.654423933217913, 22.747248273788841],
                    [-62.334729968812951, 22.878891975584281],
                    [-63.016341889266755, 23.007636718160086],
                    [-63.69924096080166, 23.133458745924429],
                    [-64.383407560210685, 23.25633469538991],
                    [-65.068821182051863, 23.376241613159948],
                    [-65.755460442245578, 23.493156963123397],
                    [-66.443303087067761, 23.60705864444094],
                    [-67.132326000344619, 23.717925000538401],
                    [-66.804206769926452, 24.284247498523314],
                    [-66.473149633348839, 24.849859280281635],
                    [-66.139053423176904, 25.414734928274356],
                    [-65.801814397216617, 25.978848306404245],
                    [-65.461326135992351, 26.542172516848211],
                    [-65.117479438425278, 27.104679873077714],
                    [-64.770162205821123, 27.666341863885975],
                    [-64.4192593357497, 28.227129111119609],
                    [-64.064652596140377, 28.787011337303397],
                    [-63.70622051196699, 29.345957321573167],
                    [-63.343838233947281, 29.903934860105778],
                    [-62.977377413536772, 30.460910717555635],
                    [-62.606706066231936, 31.016850587484669],
                    [-62.231688438470599, 31.571719036604293],
                    [-61.852184863740433, 32.125479462507258],
                    [-61.468051615989225, 32.678094034312267],
                    [-61.079140763035753, 33.229523643201617],
                    [-60.68530001098668, 33.779727839468251],
                    [-60.286372546855489, 34.328664777657423],
                    [-59.882196873986516, 34.876291149117264],
                    [-59.472606651076035, 35.422562121744591],
                    [-59.057430516804857, 35.967431263542039],
                    [-58.63649191896684, 36.510850478766656],
                    [-58.209608933705283, 37.052769926990607],
                    [-57.776594091044444, 37.593137947558262],
                    [-57.337254185132508, 38.13190097505003],
                    [-56.891390087182742, 38.669003455644997],
                    [-56.438796564709662, 39.204387756289975],
                    [-55.97926208098022, 39.73799407116951],
                    [-55.512568610652806, 40.269760320982073],
                    [-55.038491444624412, 40.799622055813302],
                    [-54.556799001172919, 41.327512342720468],
                    [-54.067252634401541, 41.853361658713652],
                    [-53.569606447179751, 42.377097771145259],
                    [-53.063607108581152, 42.898645618100829],
                    [-52.548993677616068, 43.417927181594223],
                    [-52.025497430561927, 43.934861357165971],
                    [-51.492841699085091, 44.449363815387812],
                    [-50.95074172455088, 44.961346860669153],
                    [-50.39890451593061, 45.470719284667325],
                    [-49.837028733788998, 45.977386211604426],
                    [-49.26480458596285, 46.481248941785282],
                    [-48.681913755615312, 46.982204786122054],
                    [-48.088029347276517, 47.480146899759688],
                    [-47.482815865259909, 47.974964104010269],
                    [-46.865929237943931, 48.46654071278374],
                    [-46.237016866335296, 48.95475634373031],
                    [-45.595717736484289, 49.439485732980245],
                    [-44.941662575067767, 49.920598542688651],
                    [-44.274474067923848, 50.397959165882867],
                    [-43.593767148734912, 50.871426529510757],
                    [-42.899149361453851, 51.340853895690771],
                    [-42.19022130816677, 51.806088658464887],
                    [-41.466577194981539, 52.266972147746458],
                    [-40.727805482237159, 52.723339429671],
                    [-39.973489648028817, 53.175019113241547],
                    [-39.203209083032732, 53.621833157873994],
                    [-38.416540125626227, 54.063596695331285],
                    [-37.613057251690748, 54.500117855254871],
                    [-36.792334426292712, 54.931197603286819],
                    [-35.953946639725586, 55.356629598077518],
                    [-35.097471636007128, 55.77620006088415],
                    [-34.222491847320839, 56.189687675745688],
                    [-33.328596551489625, 56.596863507644798],
                    [-32.415384256078539, 56.997490953944407],
                    [-31.482465330710397, 57.391325732696487],
                    [-30.529464888493749, 57.77811590962159],
                    [-29.556025926455277, 58.157601970954261],
                    [-28.561812732171802, 58.529516952045753],
                    [-27.546514552104838, 58.893586615430024],
                    [-26.509849515342808, 59.249529699935749],
                    [-25.451568815448411, 59.597058240845172],
                    [-24.371461123432084, 59.935877961099095],
                    [-23.269357214763602, 60.265688750635377],
                    [-22.14513477804752, 60.586185233861499],
                    [-20.998723374783879, 60.897057431555254],
                    [-19.830109489061613, 61.197991525288728],
                    [-18.639341625815348, 61.488670721676499],
                    [-17.426535376706227, 61.768776226341799],
                    [-16.191878378983972, 62.037988327599294],
                    [-14.935635095383304, 62.295987589855429],
                    [-13.658151290049943, 62.542456148632425],
                    [-12.35985812135516, 62.777079114409673],
                    [-11.041275736486, 62.999546071793816],
                    [-9.703016237409372, 63.209552661426244],
                    [-8.345785930076545, 63.406802245527274],
                    [-6.97038672107027, 63.591007626500812],
                    [-5.577716571762323, 63.761892816800128],
                    [-4.168768908358402, 63.919194824081899],
                    [-2.744630903293512, 64.062665444454751],
                    [-1.306480576717206, 64.192073033243958],
                    [0.144417325998859, 64.307204219099503],
                    [1.606716691522138, 64.407865547057384],
                    [3.078996614402286, 64.493885019977768],
                    [4.559769130341124, 64.565113504184922],
                    [6.04748804573677, 64.621425983122663],
                    [7.540558724105892, 64.662722623950003],
                    [9.037348707976548, 64.688929651682145],
                    [10.536198999983924, 64.700000000299838],
                    [10.090688749286414, 64.088850322784197],
                ]
            ],
        },
        {
            "zoneID": "10",
            "coordinates": [
                [
                    [11.737276218123043, 64.321277368955464],
                    [12.905373716723716, 63.932990728239588],
                    [14.041180001455928, 63.535562727138199],
                    [15.145431895865329, 63.129400702780288],
                    [16.218904327772577, 62.714896464600201],
                    [17.262401150792527, 62.292426218795015],
                    [18.276746973094362, 61.862350631276684],
                    [19.262779949335254, 61.425014991348803],
                    [20.221345462922841, 60.980749468013585],
                    [21.153290655439434, 60.529869435526109],
                    [22.059459714194531, 60.072675860102891],
                    [22.940689862147451, 59.60945572350289],
                    [23.797807977356342, 59.140482491573778],
                    [24.631627782596127, 58.666016596288955],
                    [25.442947538598105, 58.18630593307239],
                    [26.232548174358783, 57.701586378808372],
                    [27.001191823943543, 57.212082291864306],
                    [27.749620696937654, 56.71800702830177],
                    [28.478556246573589, 56.219563444597327],
                    [29.18869859956078, 55.716944383276712],
                    [29.88072620175285, 55.210333163045107],
                    [30.55529565626955, 54.69990403654208],
                    [31.213041715402881, 54.185822650794762],
                    [31.854577409220099, 53.668246475294666],
                    [32.480494282984807, 53.147325222880795],
                    [33.091362729906109, 52.623201253535058],
                    [33.687732389538212, 52.096009951198369],
                    [34.270132615427883, 51.565880095190266],
                    [34.839072977835713, 51.032934208247184],
                    [35.395043815020074, 50.497288882975624],
                    [35.938516795313888, 49.959055103810044],
                    [36.469945510676837, 49.418338541990181],
                    [36.989766072046621, 48.875239837948243],
                    [37.498397710985614, 48.329854874702733],
                    [37.996243387622314, 47.782275026071659],
                    [38.483690387801232, 47.232587403086256],
                    [38.961110916635562, 46.680875077023245],
                    [39.428862683066427, 46.127217295242019],
                    [39.887289472731027, 45.571689685330739],
                    [40.336721702844386, 45.014364448460583],
                    [40.777476969886322, 44.455310535652757],
                    [41.209860578403038, 43.894593824945105],
                    [41.634166049123905, 43.332277276974821],
                    [42.050675617186016, 42.768421092359574],
                    [42.45966070967404, 42.203082852891384],
                    [42.861382405173913, 41.636317660032034],
                    [43.256091880735767, 41.068178258120156],
                    [43.644030834555451, 40.498715162075143],
                    [44.025431899662465, 39.92797676621484],
                    [44.400519034226079, 39.356009457570451],
                    [44.769507902867474, 38.782857713013072],
                    [45.132606235489447, 38.20856419907858],
                    [45.490014175314002, 37.63316986100034],
                    [45.841924608933596, 37.056714009943676],
                    [46.188523488268402, 36.479234404843965],
                    [46.529990130939836, 35.900767329748533],
                    [46.866497509852252, 35.321347663963593],
                    [47.198212535580126, 34.741008954000051],
                    [47.525296318969993, 34.159783477425606],
                    [47.847904426548098, 33.577702304917466],
                    [48.166187122437805, 32.994795359618195],
                    [48.480289601284142, 32.411091470195231],
                    [48.790352209486912, 31.826618426599168],
                    [49.096510657440945, 31.241403026828266],
                    [49.398896223681845, 30.655471127290753],
                    [49.697635944643196, 30.068847684173363],
                    [49.992852806212113, 29.481556799306873],
                    [50.284665913701019, 28.893621757937808],
                    [50.573190665416917, 28.30506506919761],
                    [50.858538916337977, 27.715908501176443],
                    [51.140819126501526, 27.126173115996551],
                    [51.420136515687716, 26.535879303087427],
                    [51.696593202814086, 25.945046809762516],
                    [51.970288340834315, 25.353694774494272],
                    [52.241318248938114, 24.761841748497943],
                    [52.50977653485927, 24.169505730804872],
                    [52.775754217183419, 23.57670418804787],
                    [53.039339835065391, 22.983454082340074],
                    [53.300619564241572, 22.389771894657258],
                    [53.559677317754051, 21.795673646421676],
                    [53.816594849372848, 21.201174919287155],
                    [54.071451848923743, 20.606290882118572],
                    [54.324326035817933, 20.011036301783975],
                    [54.575293251682297, 19.415425569234685],
                    [54.824427543096704, 18.819472714794017],
                    [55.071801244331994, 18.223191425244124],
                    [55.317485061886146, 17.62659505911472],
                    [55.561548144631217, 17.029696666468055],
                    [55.804058164752576, 16.432509001489279],
                    [56.045081386097138, 15.835044537775275],
                    [56.284682730723489, 15.237315480924735],
                    [56.52292585264604, 14.639333786525071],
                    [56.759873195391719, 14.041111168245891],
                    [56.995586058549804, 13.442659114026924],
                    [57.230124657127305, 12.843988897769464],
                    [57.463548181803219, 12.245111587429847],
                    [57.695914851988903, 11.646038063905564],
                    [57.927281975183064, 11.046779024632315],
                    [58.157706000031908, 10.447345000671305],
                    [57.506917080958601, 10.416858116409003],
                    [56.856258210148326, 10.385057010572609],
                    [56.205734415710765, 10.351946052068683],
                    [55.555350652910363, 10.317529786070793],
                    [54.905111799669896, 10.281812931321781],
                    [54.255022653872459, 10.244800381932123],
                    [53.605087933361517, 10.206497206480947],
                    [52.955312273242896, 10.16690864351915],
                    [52.3057002177909, 10.126040102468778],
                    [51.656256227642871, 10.083897164522568],
                    [51.006984669007295, 10.040485575448997],
                    [50.357889817261309, 9.995811250988481],
                    [49.708975849755689, 9.949880271457403],
                    [49.060246848513316, 9.902698881748051],
                    [48.411706795732073, 9.854273490429307],
                    [47.763359571986712, 9.804610666149358],
                    [47.115208953530441, 9.753717139434514],
                    [46.467258611395835, 9.701599798192206],
                    [45.819512112294206, 9.648265688610707],
                    [45.171972910521447, 9.593722011561624],
                    [44.524644351555651, 9.537976123499334],
                    [43.877529671157447, 9.481035531964267],
                    [43.230631987276467, 9.422907898280926],
                    [42.583954307245563, 9.363601031262647],
                    [41.937499518787831, 9.303122887211543],
                    [41.291270393613843, 9.241481570817882],
                    [40.645269585622941, 9.17868533156286],
                    [39.999499628205342, 9.114742559221781],
                    [39.353962931544118, 9.049661787461559],
                    [38.70866178801117, 8.983451689344065],
                    [38.06359836317398, 8.916121076426577],
                    [37.41877470119158, 8.847678895164904],
                    [36.774192720317842, 8.778134227812416],
                    [36.129854215599607, 8.70749628972203],
                    [35.485760854379976, 8.635774426648538],
                    [34.841914176298246, 8.562978113848942],
                    [34.198315596887312, 8.489116954284043],
                    [33.554966403077117, 8.414200678618499],
                    [32.911867753194315, 8.338239138925189],
                    [32.269020678761365, 8.261242312282945],
                    [31.626426080898966, 8.183220294481032],
                    [30.984084734822716, 8.104183300019315],
                    [30.341997285346508, 8.024141662108093],
                    [29.700164248681176, 7.943105829070817],
                    [29.058586013333922, 7.861086359847661],
                    [28.417262840108037, 7.778093929391389],
                    [27.77619485850596, 7.694139319673923],
                    [27.135382073024289, 7.609233421485271],
                    [26.494824358657297, 7.523387232634718],
                    [25.854521463594722, 7.436611853454338],
                    [25.214473009222047, 7.348918489496725],
                    [24.574678490120277, 7.260318446139422],
                    [23.935137274965314, 7.170823127685253],
                    [23.295848606528011, 7.080444036463177],
                    [22.6568116052714, 6.989192771029593],
                    [22.018025265753465, 6.897081021671852],
                    [21.379488458425669, 6.804120572206671],
                    [20.741199935029044, 6.71032329818172],
                    [20.103158321399462, 6.615701162378798],
                    [19.465362127360322, 6.520266213015361],
                    [18.827809739527879, 6.424030586442484],
                    [18.190499429405179, 6.327006500849393],
                    [17.553429348885402, 6.229206256263751],
                    [16.916597535647782, 6.130642232752905],
                    [16.280001910459873, 6.031326888625074],
                    [15.643640281673697, 5.931272760429579],
                    [15.007510346125628, 5.830492456661602],
                    [14.37160968823656, 5.728998662258505],
                    [13.735935784508911, 5.626804132304926],
                    [13.100486000828312, 5.523921691133182],
                    [12.465257598759251, 5.420364233222813],
                    [11.830247733745978, 5.316144718703868],
                    [11.195453458710176, 5.211276174256113],
                    [10.560871724050855, 5.105771686813966],
                    [9.926499378543554, 4.999644408962354],
                    [9.292333175635576, 4.892907552641475],
                    [8.65836976894974, 4.785574386448843],
                    [8.024605718579096, 4.677658239236393],
                    [7.391037490188069, 4.569172494714905],
                    [6.757661460408144, 4.460130588755703],
                    [6.124473913240536, 4.350546012988161],
                    [5.491471046351762, 4.240432307604976],
                    [4.858648972871833, 4.129803064060184],
                    [4.226003719596008, 4.018671921472048],
                    [3.593531234179181, 3.907052565723404],
                    [2.961227382437812, 3.794958726763866],
                    [2.329087953746125, 3.682404181307959],
                    [1.697108661035941, 3.569402745640275],
                    [1.065285143494634, 3.455968276514795],
                    [0.433612970162471, 3.342114673853189],
                    [-0.197912361865974, 3.227855870851783],
                    [-0.829295420247377, 3.113205841176693],
                    [-1.460540837389658, 2.998178591768635],
                    [-2.091653311351195, 2.882788163742816],
                    [-2.722637597746882, 2.767048631489217],
                    [-3.353498511547002, 2.650974100874123],
                    [-3.984240924379094, 2.534578704743467],
                    [-4.614869761829993, 2.417876607419544],
                    [-5.245389999848555, 2.300882000204183],
                    [-5.16201719933423, 2.936203307636561],
                    [-5.078549505954868, 3.571518401652952],
                    [-4.994966195733298, 4.20682592607568],
                    [-4.911246428679704, 4.842124514834552],
                    [-4.827369233503305, 5.477412794664815],
                    [-4.743313480632594, 6.112689383308464],
                    [-4.659057866926958, 6.747952884118376],
                    [-4.574580889596348, 7.383201888756219],
                    [-4.489860824617324, 8.018434975393859],
                    [-4.404875706948246, 8.653650704216659],
                    [-4.31960330444889, 9.288847619222281],
                    [-4.234021095397168, 9.92402424462324],
                    [-4.148106244207781, 10.55917908394764],
                    [-4.061835575351495, 11.194310620039118],
                    [-3.975185549973105, 11.829417307862514],
                    [-3.888132237112984, 12.464497580798763],
                    [-3.800651288526069, 13.099549841651935],
                    [-3.712717906306295, 13.734572465347071],
                    [-3.624306819504056, 14.369563795332965],
                    [-3.535392249053018, 15.004522139984829],
                    [-3.445947878092056, 15.639445774403043],
                    [-3.355946816892015, 16.274332934117638],
                    [-3.26536157497668, 16.909181816887383],
                    [-3.174164016156396, 17.543990575504722],
                    [-3.08232532975012, 18.178757319594695],
                    [-2.989815989216481, 18.813480111118281],
                    [-2.896605708086895, 19.448156962573819],
                    [-2.802663402194185, 20.082785832500235],
                    [-2.707957144706427, 20.71736462457784],
                    [-2.612454116664082, 21.35189118403099],
                    [-2.516120562913613, 21.986363291332907],
                    [-2.418921734550338, 22.620778665802845],
                    [-2.32082184215426, 23.255134953015727],
                    [-2.221783991937627, 23.889429730197946],
                    [-2.121770134484052, 24.523660493636896],
                    [-2.02074099190321, 25.157824662278415],
                    [-1.918656001173474, 25.791919566934496],
                    [-1.815473237699734, 26.425942449384593],
                    [-1.711149344266801, 27.059890456079756],
                    [-1.605639450999831, 27.693760634545697],
                    [-1.498897094425331, 28.327549925288849],
                    [-1.390874130236853, 28.961255157299718],
                    [-1.281520638866368, 29.594873041757523],
                    [-1.170784828357114, 30.228400165735138],
                    [-1.058612929143294, 30.861832985903618],
                    [-0.944949085232054, 31.49516781953929],
                    [-0.829735233694009, 32.128400836429535],
                    [-0.71291098145656, 32.761528051678283],
                    [-0.594413472203939, 33.394545318511689],
                    [-0.474177242485723, 34.027448313888613],
                    [-0.352134073328784, 34.660232533104988],
                    [-0.228212824762011, 35.292893276303687],
                    [-0.10233927034102, 35.925425637683077],
                    [0.025564095306777, 36.557824492006773],
                    [0.155578246239145, 37.190084485610555],
                    [0.287787840136787, 37.822200013919542],
                    [0.422281440436166, 38.454165216951253],
                    [0.559151760045722, 39.085973953235396],
                    [0.698495922149164, 39.717619788122761],
                    [0.840415733599286, 40.349095972201383],
                    [0.985017987989806, 40.980395423310199],
                    [1.132414785813751, 41.611510704055775],
                    [1.282723880702576, 42.24243399573237],
                    [1.436069052644712, 42.873157075838435],
                    [1.592580509083291, 43.503671291097248],
                    [1.752395320187929, 44.133967525980609],
                    [1.915657884703649, 44.764036170333043],
                    [2.08252044256443, 45.393867086996522],
                    [2.253143616284888, 46.023449574938013],
                    [2.427697012607098, 46.652772323384056],
                    [2.606359861018802, 47.281823373150189],
                    [2.789321718822293, 47.910590065379267],
                    [2.976783229262651, 48.539058992078878],
                    [3.16895694980343, 49.167215934967487],
                    [3.366068255945322, 49.795045805219786],
                    [3.568356321487101, 50.422532578715561],
                    [3.776075194114981, 51.049659214201426],
                    [3.989494969916962, 51.676407579546208],
                    [4.208903074917032, 52.302758355513731],
                    [4.434605677010438, 52.928690943132551],
                    [4.666929223804686, 53.554183352180019],
                    [4.906222143237358, 54.179212083370999],
                    [5.152856706971477, 54.803751996157757],
                    [5.407231087145021, 55.427776165737498],
                    [5.669771619064988, 56.051255720275321],
                    [5.940935304920458, 56.674159663737555],
                    [6.221212583693841, 57.296454679839655],
                    [6.511130392453708, 57.918104911712362],
                    [6.81125557298634, 58.539071718185312],
                    [7.122198639056023, 59.15931339949384],
                    [7.444617989728499, 59.778784896006187],
                    [7.779224581349411, 60.397437442883756],
                    [8.12678715710166, 61.015218193265071],
                    [8.488138087203026, 61.632069782994165],
                    [8.864179902480544, 62.24792985038232],
                    [9.255892625644208, 62.862730486722626],
                    [9.664342000982629, 63.476397622052673],
                    [10.090688749286414, 64.088850322784197],
                    [10.536198999983924, 64.700000000299838],
                    [11.737276218123043, 64.321277368955464],
                ]
            ],
        },
        {
            "zoneID": "11",
            "coordinates": [
                [
                    [57.035189051276177, 69.699495455506849],
                    [58.135830244864451, 69.651836749610482],
                    [59.952617212227551, 69.553561940012457],
                    [61.751193783183112, 69.436612967245026],
                    [63.528788910390915, 69.30130684634338],
                    [65.282846534334283, 69.148001490029912],
                    [67.011042209264872, 68.977091301147084],
                    [68.711294531436181, 68.789002545219887],
                    [70.38177149788936, 68.584188622274553],
                    [72.020892122541284, 68.363125341172463],
                    [73.627323731679496, 68.126306281328709],
                    [75.199975477369435, 67.874238340166812],
                    [76.737988658951167, 67.607437523417161],
                    [78.240724465698463, 67.326425025865149],
                    [79.707749748146966, 67.031723647563012],
                    [81.138821393072533, 66.723854562965528],
                    [82.533869839294994, 66.403334460956444],
                    [83.89298218218579, 66.070673039979738],
                    [85.216385296752208, 65.726370872769792],
                    [86.504429289800782, 65.370917599598386],
                    [87.757571556328969, 65.004790450865585],
                    [88.976361640993389, 64.628453065300107],
                    [90.161427047833058, 64.242354570357293],
                    [91.313460095224968, 63.846928917141497],
                    [92.433205871401015, 63.442594416824136],
                    [93.521451296576174, 63.029753479203919],
                    [94.579015293583268, 62.608792499041726],
                    [95.60674003086217, 62.180081897119578],
                    [96.605483180376041, 61.743976261731689],
                    [97.576111142258981, 61.300814603000163],
                    [98.519493158215937, 60.850920670278867],
                    [99.436496250977825, 60.394603345395353],
                    [100.327980913092063, 59.932157078250611],
                    [101.194797464952387, 59.463862357555229],
                    [102.037783036363805, 58.989986212566635],
                    [102.85775907029597, 58.51078273034949],
                    [103.655529318301262, 58.026493578216332],
                    [104.431878251691273, 57.537348535647993],
                    [105.187569843295194, 57.043566020033381],
                    [105.923346664553264, 56.545353610841119],
                    [106.639929259606049, 56.042908556522434],
                    [107.338015757193318, 55.536418277927567],
                    [108.018281681316978, 55.026060851660134],
                    [108.681379930426715, 54.512005476045715],
                    [109.327940903343631, 53.994412929470911],
                    [109.95857274201029, 53.473435997620641],
                    [110.573861665339621, 52.949219894262228],
                    [111.174372392868179, 52.421902658835052],
                    [111.760648620529594, 51.891615532362039],
                    [112.333213552715279, 51.358483322614802],
                    [112.892570469655539, 50.822624746919473],
                    [113.439203318285877, 50.284152757704931],
                    [113.973577333621392, 49.743174852285733],
                    [114.496139650239456, 49.199793368117355],
                    [115.007319943441757, 48.65410575686218],
                    [115.507531054222227, 48.106204852686972],
                    [115.997169619529132, 47.556179116190378],
                    [116.476616684562487, 47.004112871141899],
                    [116.946238317396364, 46.450086526354767],
                    [117.406386203002171, 45.894176787310357],
                    [117.85739822640528, 45.336456849870331],
                    [118.299599037606981, 44.776996590017575],
                    [118.73330060436524, 44.215862741017872],
                    [119.158802743644856, 43.653119057584604],
                    [119.576393635794261, 43.088826473398967],
                    [119.986350321301074, 42.523043249402235],
                    [120.388939185633717, 41.955825114919151],
                    [120.784416412466499, 41.38722539648461],
                    [121.173028428474481, 40.817295146798301],
                    [121.555012335956576, 40.246083258747831],
                    [121.930596310092142, 39.673636575442515],
                    [122.299999484011892, 39.100000803522846],
                    [122.300000000224827, 39.100000000149976],
                    [121.484166380574152, 39.004182749934103],
                    [120.670604829649392, 38.902699620591079],
                    [119.859429891476339, 38.795587242457373],
                    [119.050752801400677, 38.682883972517288],
                    [118.244681378243172, 38.564629841394094],
                    [117.441319920877731, 38.440866487698315],
                    [116.640769119199604, 38.311637095975357],
                    [115.843125969587845, 38.176986336450454],
                    [115.04848371015521, 38.036960298478959],
                    [114.256931755995765, 37.891606425795999],
                    [113.468555649723612, 37.740973450864146],
                    [112.683437024599016, 37.585111329224446],
                    [111.901653568557322, 37.424071173845789],
                    [111.123279007120516, 37.257905185875813],
                    [110.348383089907713, 37.086666593488587],
                    [109.577031586138901, 36.910409579038969],
                    [108.809286292728359, 36.729189221505408],
                    [108.045205046875481, 36.543061425444535],
                    [107.284841745850088, 36.352082859836173],
                    [106.528246377568337, 36.156310894232433],
                    [105.775465056567214, 35.955803537603344],
                    [105.026540064472499, 35.750619377182659],
                    [104.281509899462378, 35.540817515516096],
                    [103.540409332924526, 35.326457518300003],
                    [102.803269464314326, 35.107599353227727],
                    [102.070117789504422, 34.884303333332298],
                    [101.340978269131995, 34.656630067523736],
                    [100.615871398746094, 34.424640405730202],
                    [99.894814288848465, 34.188395389435698],
                    [99.177820743132827, 33.947956200418503],
                    [98.464901341223992, 33.703384117583028],
                    [97.756063522313752, 33.454740470196725],
                    [97.051311675093871, 33.202086593821434],
                    [96.35064722409021, 32.945483788046431],
                    [95.654068719595841, 32.684993281414961],
                    [94.961571931199728, 32.420676186456888],
                    [94.273149936820289, 32.152593470912109],
                    [93.588793215334817, 31.880805918158728],
                    [92.908489742807546, 31.605374098436073],
                    [92.232225077925193, 31.326358334669521],
                    [91.559982459123376, 31.04381867639097],
                    [90.891742895418361, 30.757814874556914],
                    [90.227485254540966, 30.468406350073053],
                    [89.567186353767227, 30.175652174908123],
                    [88.910821048952357, 29.879611048710956],
                    [88.258362320864478, 29.580341279026982],
                    [87.609781360621412, 29.277900760611658],
                    [86.965047653326678, 28.97234695924476],
                    [86.324129061706913, 28.663736893742794],
                    [85.686991905252341, 28.352127126066136],
                    [85.053601040255955, 28.03757374333378],
                    [84.423919933558182, 27.720132347929564],
                    [83.797910741687531, 27.399858045812209],
                    [83.175534377409747, 27.076805438420308],
                    [82.556750587070042, 26.75102861547839],
                    [81.941518010847574, 26.422581142405875],
                    [81.329794256499781, 26.091516063015945],
                    [80.72153595691907, 25.757885885125631],
                    [80.116698833984117, 25.421742583253661],
                    [79.515237760614241, 25.083137595024027],
                    [78.917106812029886, 24.742121813071321],
                    [78.32225932510795, 24.398745591335967],
                    [77.730647950542561, 24.053058739669154],
                    [77.142224701408907, 23.705110525630289],
                    [76.556941002625308, 23.354949677185971],
                    [75.974747738617282, 23.002624380011184],
                    [75.395595293787835, 22.648182283785502],
                    [74.819433600180673, 22.291670503091382],
                    [74.246212170755143, 21.933135622810767],
                    [73.6758801443533, 21.572623699923895],
                    [73.108386317174791, 21.21018026800499],
                    [72.543679180549873, 20.845850345317331],
                    [71.981706949715999, 20.479678437510074],
                    [71.422417597993842, 20.111708544813609],
                    [70.865758886463482, 19.741984167435419],
                    [70.311678385549101, 19.370548311855146],
                    [69.760123509192567, 18.997443499817791],
                    [69.211041531941305, 18.622711774628669],
                    [68.664379616825954, 18.246394707449781],
                    [68.120084832449095, 17.8685334080904],
                    [67.578104176366764, 17.489168529504127],
                    [67.038384590376666, 17.108340280379764],
                    [66.500872980303882, 16.72608842873808],
                    [65.9655162312892, 16.342452315422179],
                    [65.432261221278452, 15.957470859492673],
                    [64.901054834513047, 15.571182571718452],
                    [64.371843976818127, 15.183625557273615],
                    [63.844575581897686, 14.794837531027383],
                    [63.319196626623068, 14.404855824736501],
                    [62.795654137328768, 14.013717396041045],
                    [62.273895198804439, 13.62145884015348],
                    [61.753866960591949, 13.228116397953556],
                    [61.235516645077098, 12.833725965880717],
                    [60.718791554686561, 12.438323107625365],
                    [60.203639071885732, 12.041943060423932],
                    [59.6900066663747, 11.644620751246805],
                    [59.177841901382692, 11.246390799495828],
                    [58.667092429172442, 10.847287534991835],
                    [58.157706000031965, 10.447345000671362],
                    [57.927281975183121, 11.046779024632372],
                    [57.695914851988903, 11.646038063905678],
                    [57.463548181803219, 12.245111587429903],
                    [57.230124657127362, 12.843988897769577],
                    [56.995586058549861, 13.442659114026924],
                    [56.759873195391719, 14.041111168245948],
                    [56.522925852645983, 14.639333786525071],
                    [56.284682730723546, 15.237315480924792],
                    [56.045081386097138, 15.835044537775332],
                    [55.804058164752576, 16.432509001489393],
                    [55.561548144631217, 17.029696666468169],
                    [55.317485061886146, 17.626595059114663],
                    [55.071801244331994, 18.223191425244124],
                    [54.824427543096817, 18.819472714794017],
                    [54.575293251682353, 19.415425569234742],
                    [54.324326035818046, 20.011036301784088],
                    [54.071451848923743, 20.606290882118515],
                    [53.816594849372962, 21.201174919287212],
                    [53.559677317754051, 21.795673646421733],
                    [53.300619564241686, 22.389771894657315],
                    [53.039339835065448, 22.983454082340131],
                    [52.775754217183476, 23.576704188047927],
                    [52.50977653485927, 24.169505730804872],
                    [52.241318248938114, 24.761841748498],
                    [51.970288340834315, 25.353694774494329],
                    [51.696593202814142, 25.94504680976263],
                    [51.420136515687773, 26.535879303087427],
                    [51.14081912650164, 27.126173115996608],
                    [50.858538916337977, 27.715908501176443],
                    [50.57319066541703, 28.305065069197667],
                    [50.284665913701019, 28.893621757937865],
                    [49.99285280621217, 29.481556799306986],
                    [49.697635944643253, 30.06884768417342],
                    [49.398896223681902, 30.655471127290809],
                    [49.096510657440945, 31.241403026828323],
                    [48.790352209487025, 31.826618426599282],
                    [48.480289601284142, 32.411091470195345],
                    [48.166187122437748, 32.994795359618308],
                    [47.847904426548098, 33.57770230491758],
                    [47.525296318970049, 34.159783477425606],
                    [47.198212535580183, 34.741008954000108],
                    [46.866497509852195, 35.321347663963707],
                    [46.52999013093995, 35.900767329748589],
                    [46.188523488268515, 36.479234404843965],
                    [45.841924608933709, 37.056714009943789],
                    [45.490014175314002, 37.633169861000454],
                    [45.132606235489504, 38.208564199078637],
                    [44.769507902867531, 38.782857713013186],
                    [44.400519034226079, 39.356009457570508],
                    [44.025431899662465, 39.927976766214954],
                    [43.644030834555508, 40.498715162075257],
                    [43.256091880735823, 41.06817825812027],
                    [42.86138240517397, 41.636317660032148],
                    [42.459660709674097, 42.203082852891498],
                    [42.05067561718613, 42.768421092359688],
                    [41.634166049124019, 43.332277276974821],
                    [41.209860578403038, 43.894593824945048],
                    [40.777476969886322, 44.45531053565287],
                    [40.3367217028445, 45.014364448460583],
                    [39.887289472731084, 45.571689685330739],
                    [39.428862683066427, 46.127217295242019],
                    [38.961110916635505, 46.680875077023302],
                    [38.483690387801289, 47.2325874030862],
                    [37.996243387622371, 47.782275026071602],
                    [37.498397710985728, 48.329854874702846],
                    [36.989766072046734, 48.8752398379483],
                    [36.469945510676894, 49.418338541990238],
                    [35.938516795313944, 49.959055103810044],
                    [35.395043815020074, 50.497288882975738],
                    [34.83907297783577, 51.032934208247184],
                    [34.27013261542794, 51.565880095190323],
                    [33.687732389538155, 52.096009951198369],
                    [33.091362729906223, 52.623201253535171],
                    [32.480494282984921, 53.147325222880909],
                    [31.854577409220099, 53.668246475294666],
                    [31.213041715402937, 54.185822650794876],
                    [30.555295656269493, 54.699904036542137],
                    [29.88072620175285, 55.21033316304505],
                    [29.188698599560723, 55.716944383276655],
                    [28.478556246573646, 56.21956344459727],
                    [27.749620696937654, 56.71800702830177],
                    [27.001191823943543, 57.212082291864419],
                    [26.23254817435884, 57.701586378808486],
                    [25.442947538598219, 58.186305933072447],
                    [24.63162778259624, 58.666016596289069],
                    [23.797807977356456, 59.140482491573891],
                    [22.940689862147565, 59.609455723502947],
                    [22.059459714194588, 60.072675860102947],
                    [21.153290655439491, 60.529869435526166],
                    [20.221345462922955, 60.980749468013585],
                    [19.262779949335368, 61.42501499134886],
                    [18.276746973094475, 61.862350631276797],
                    [17.262401150792471, 62.292426218795129],
                    [16.218904327772634, 62.714896464600315],
                    [15.145431895865329, 63.129400702780345],
                    [14.041180001456041, 63.535562727138256],
                    [12.905373716723716, 63.932990728239588],
                    [11.737276218123043, 64.321277368955577],
                    [10.536198999983924, 64.700000000299951],
                    [11.761404908196369, 65.074451607037929],
                    [13.021072734842392, 65.438606852169471],
                    [14.315735804231849, 65.791999462022659],
                    [15.645832515258178, 66.134149771985392],
                    [17.011691031395458, 66.464565963651353],
                    [18.413513214928514, 66.782745599741361],
                    [19.851357988544009, 67.08817749429636],
                    [21.325124427869696, 67.38034391232128],
                    [22.834534916716052, 67.658723142394365],
                    [24.379118777836936, 67.922792429877063],
                    [25.958196873575105, 68.172031271802837],
                    [27.570867706792058, 68.405925068019712],
                    [29.215995590337627, 68.623969095848622],
                    [30.892201533638456, 68.825672771149641],
                    [32.597857418990429, 69.010564142593466],
                    [34.331084068259713, 69.178194552524531],
                    [36.089753726062384, 69.328143368136068],
                    [37.87149735313119, 69.460022702049173],
                    [39.673717022394726, 69.573482006644383],
                    [41.493603529322741, 69.668212428000857],
                    [43.328159104479539, 69.743950796503555],
                    [45.17422493566437, 69.800483160905173],
                    [47.02851297977935, 69.837647727059505],
                    [48.887641311479911, 69.855337146275872],
                    [50.748172132888044, 69.853500042816449],
                    [52.60665136764942, 69.832141761540242],
                    [54.4596487394723, 69.791324288214525],
                    [56.303797145996668, 69.731165351120239],
                    [57.035189051276177, 69.699495455506849],
                ]
            ],
        },
        {
            "zoneID": "12",
            "coordinates": [
                [
                    [-44.274474067923848, 50.397959165882867],
                    [-44.941662575067767, 49.920598542688708],
                    [-45.595717736484289, 49.439485732980245],
                    [-46.237016866335296, 48.954756343730253],
                    [-46.865929237943874, 48.46654071278374],
                    [-47.482815865259852, 47.974964104010326],
                    [-48.088029347276461, 47.480146899759802],
                    [-48.681913755615312, 46.982204786122054],
                    [-49.26480458596285, 46.481248941785282],
                    [-49.837028733788941, 45.977386211604539],
                    [-50.398904515930553, 45.470719284667325],
                    [-50.95074172455088, 44.961346860669153],
                    [-51.492841699085034, 44.449363815387869],
                    [-52.025497430561927, 43.934861357166085],
                    [-52.548993677616068, 43.417927181594337],
                    [-53.063607108581152, 42.898645618100829],
                    [-53.569606447179694, 42.377097771145316],
                    [-54.067252634401484, 41.853361658713766],
                    [-54.556799001172919, 41.327512342720581],
                    [-55.038491444624356, 40.799622055813302],
                    [-55.512568610652806, 40.269760320982016],
                    [-55.97926208098022, 39.73799407116951],
                    [-56.438796564709662, 39.204387756290032],
                    [-56.891390087182742, 38.669003455645054],
                    [-57.337254185132508, 38.131900975050087],
                    [-57.776594091044444, 37.593137947558375],
                    [-58.209608933705283, 37.052769926990607],
                    [-58.63649191896684, 36.51085047876677],
                    [-59.057430516804857, 35.967431263542039],
                    [-59.472606651076035, 35.422562121744591],
                    [-59.882196873986459, 34.876291149117378],
                    [-60.286372546855489, 34.328664777657536],
                    [-60.685300010986623, 33.779727839468251],
                    [-61.079140763035753, 33.229523643201617],
                    [-61.468051615989225, 32.678094034312267],
                    [-61.852184863740376, 32.125479462507371],
                    [-62.231688438470599, 31.571719036604293],
                    [-62.60670606623188, 31.016850587484782],
                    [-62.977377413536772, 30.460910717555748],
                    [-63.343838233947224, 29.903934860105835],
                    [-63.706220511966933, 29.345957321573167],
                    [-64.064652596140377, 28.787011337303397],
                    [-64.4192593357497, 28.227129111119609],
                    [-64.770162205821123, 27.666341863886032],
                    [-65.117479438425221, 27.104679873077828],
                    [-65.461326135992294, 26.542172516848211],
                    [-65.801814397216617, 25.978848306404302],
                    [-66.139053423176847, 25.414734928274356],
                    [-66.473149633348839, 24.849859280281692],
                    [-66.804206769926395, 24.284247498523371],
                    [-67.132326000344619, 23.717925000538514],
                    [-67.621762981676227, 24.176715867243502],
                    [-68.114725432232888, 24.633933372727142],
                    [-68.611302453245514, 25.089532110218897],
                    [-69.111584102823997, 25.543465756539604],
                    [-69.615661399553858, 25.995687043322562],
                    [-70.123626307208269, 26.446147735429804],
                    [-70.635571732049698, 26.894798597677209],
                    [-71.151591503944644, 27.34158937684839],
                    [-71.671780362873392, 27.786468768419013],
                    [-72.196233940044181, 28.229384394974034],
                    [-72.725048730914182, 28.670282776529007],
                    [-73.258322070906729, 29.10910930535033],
                    [-73.796152104835699, 29.545808218074797],
                    [-74.338637745535436, 29.980322568731538],
                    [-74.885878636090126, 30.412594205358346],
                    [-75.437975103068538, 30.842563737626392],
                    [-75.995028106162124, 31.270170517955137],
                    [-76.557139177031331, 31.695352608236419],
                    [-77.124410359050728, 32.118046760050106],
                    [-77.696944135363537, 32.538188385885348],
                    [-78.274843350640083, 32.955711536658214],
                    [-78.858211129240203, 33.370548876529597],
                    [-79.447150783481788, 33.782631661322114],
                    [-80.041765709319918, 34.191889714239096],
                    [-80.642159282924524, 34.598251406976999],
                    [-81.248434741969731, 35.001643637244115],
                    [-81.860695056131874, 35.401991814370831],
                    [-82.479042796687679, 35.799219836826069],
                    [-83.103579984528551, 36.193250079627546],
                    [-83.734407937276444, 36.58400338175079],
                    [-84.371627102908462, 36.971399030840757],
                    [-85.015336878094388, 37.35535475781586],
                    [-85.665635419339083, 37.735786726076697],
                    [-86.322619444231862, 38.112609529706162],
                    [-86.986384011113159, 38.485736191671947],
                    [-87.657022300538699, 38.855078164725626],
                    [-88.334625370664298, 39.220545335898521],
                    [-89.019281907234188, 39.582046036395639],
                    [-89.711077960079706, 39.939487052385743],
                    [-90.410096663430238, 40.292773644787928],
                    [-91.116417946331069, 40.641809567257837],
                    [-91.830118228673257, 40.986497094065726],
                    [-92.551270107329515, 41.326737049775147],
                    [-93.279942023405624, 41.662428845215061],
                    [-94.016197922296158, 41.993470524245481],
                    [-94.760096904748309, 42.319758804225557],
                    [-95.511692857239552, 42.641189136269816],
                    [-96.271034083256325, 42.957655763702633],
                    [-97.038162919283195, 43.269051787709941],
                    [-97.813115340000877, 43.575269247377946],
                    [-98.595920562583785, 43.876199197035476],
                    [-99.386600641106668, 44.17173179798408],
                    [-100.185170058251515, 44.461756414726892],
                    [-100.991635311620314, 44.74616172378461],
                    [-101.805994505442015, 45.024835824313925],
                    [-102.628236937784436, 45.297666358615686],
                    [-103.4583426904627, 45.564540648831951],
                    [-104.296282234237708, 45.825345830046047],
                    [-105.142016033113407, 46.079968999569815],
                    [-105.995494161226532, 46.328297375223826],
                    [-106.856655943117175, 46.570218452719473],
                    [-107.725429596698461, 46.80562018642263],
                    [-108.6017319112986, 47.0343911620227],
                    [-109.485467941891955, 47.256420788988407],
                    [-110.37653073120822, 47.471599493022211],
                    [-111.274801061519724, 47.679818915710541],
                    [-112.180147249595791, 47.880972126762401],
                    [-113.092424964140776, 48.074953832653364],
                    [-114.011477097190266, 48.261660598757715],
                    [-114.93713367417962, 48.440991066085019],
                    [-115.869211810776335, 48.612846181506256],
                    [-116.807515719175058, 48.777129422584835],
                    [-117.751836774647359, 48.933747028702498],
                    [-118.701953624360215, 49.082608225889032],
                    [-119.6576323627433, 49.223625460646645],
                    [-120.618626764413534, 49.356714621182959],
                    [-121.584678572857797, 49.481795263141009],
                    [-122.555517854765071, 49.598790828134383],
                    [-123.530863410118172, 49.707628854188442],
                    [-124.510423245236495, 49.808241180785956],
                    [-125.493895107872902, 49.900564150315404],
                    [-126.480967074470868, 49.984538790632712],
                    [-127.471318200374583, 50.060110994926617],
                    [-128.464619215004689, 50.127231681796843],
                    [-129.460533276389583, 50.185856951736923],
                    [-130.458716768863724, 50.235948221133469],
                    [-131.458820135840483, 50.277472343673764],
                    [-132.460488762945999, 50.310401716466174],
                    [-133.463363883636305, 50.334714369972289],
                    [-134.467083517190531, 50.350394034557098],
                    [-135.471283421092949, 50.357430198944598],
                    [-136.475598066797261, 50.355818140794725],
                    [-137.479661618189084, 50.345558940192973],
                    [-138.483108912746047, 50.326659483248591],
                    [-139.485576437302711, 50.299132431516512],
                    [-140.486703298418433, 50.262996186924681],
                    [-141.486132169364112, 50.218274829719689],
                    [-142.483510217322646, 50.164998038428848],
                    [-143.478490000006673, 50.103200999963235],
                    [-143.478489553674592, 50.103202319214802],
                    [-143.266578422409395, 50.729569328791911],
                    [-143.048924895845914, 51.355543178468338],
                    [-142.825242669059492, 51.981102580338018],
                    [-142.595226518110849, 52.60622625466516],
                    [-142.358551237240476, 53.230891503300882],
                    [-142.114869996959783, 53.855074086177694],
                    [-141.863812525970957, 54.478748089154919],
                    [-141.604983121265946, 55.101885781684473],
                    [-141.337958453612544, 55.724457449370391],
                    [-141.06228514616447, 56.346431219401836],
                    [-140.777477101599459, 56.967772863312291],
                    [-140.483012549900138, 57.588445573309116],
                    [-140.178330769363754, 58.208409722062868],
                    [-139.862828462461096, 58.827622584265441],
                    [-139.535855722097097, 59.446038041258191],
                    [-139.196711550176985, 60.063606233019811],
                    [-138.844638868481013, 60.680273183110842],
                    [-138.47881894119223, 61.295980370301947],
                    [-138.098365166527287, 61.910664249718877],
                    [-137.702316109765263, 62.524255710464956],
                    [-137.289627714692358, 63.13667946906213],
                    [-136.859164548246042, 63.747853378270406],
                    [-136.409689985939735, 64.357687646936824],
                    [-135.939855146192087, 64.966083952820327],
                    [-135.448186446109162, 65.572934434725482],
                    [-134.933071549241788, 66.17812054120327],
                    [-134.392743496595529, 66.781511714730527],
                    [-133.825262785746418, 67.382963887340793],
                    [-133.228497075596465, 67.982317748290995],
                    [-132.600098223684654, 68.579396761733676],
                    [-131.93747627529109, 69.174004865444942],
                    [-131.237770013867987, 69.765923825888876],
                    [-130.49781361176349, 70.354910169468269],
                    [-129.714098940312056, 70.940691623223699],
                    [-128.882733004354179, 71.522962978952876],
                    [-127.999390043167296, 72.101381278565214],
                    [-127.059257816183504, 72.675560205224599],
                    [-126.056977746091604, 73.245063532372342],
                    [-124.986578730888482, 73.809397484687508],
                    [-123.841404816062663, 74.368001819328185],
                    [-122.614037439101367, 74.920239421327267],
                    [-121.296213849454773, 75.465384204627469],
                    [-119.878744588478071, 76.00260707275504],
                    [-118.351434895675084, 76.530959725316904],
                    [-116.70301776360526, 77.049356125709323],
                    [-114.921110329462863, 77.556551532260698],
                    [-112.992210916794704, 78.051119181005731],
                    [-110.901761303187413, 78.531424962507856],
                    [-108.634308121032973, 78.995600956098031],
                    [-106.173808039646531, 79.44151933085584],
                    [-103.504132394602948, 79.866769201779846],
                    [-100.609834958794352, 80.268640341547041],
                    [-97.477246027850185, 80.64411938412934],
                    [-94.999999999671502, 80.897452817513226],
                    [-94.095937833197809, 80.989905957498365],
                    [-90.460558761675827, 81.302457684132946],
                    [-86.572945935201119, 81.578073348353769],
                    [-82.444294907259007, 81.813021554078091],
                    [-78.097010698712552, 82.003716653113543],
                    [-73.565737759252613, 82.146934086691999],
                    [-68.897049763280165, 82.240044579810501],
                    [-64.14745132914112, 82.281234562964187],
                    [-59.37971767814355, 82.269674012866915],
                    [-54.65807340944508, 82.205597649041351],
                    [-50.043091236127907, 82.090281692444933],
                    [-45.587288008522137, 81.925921363712007],
                    [-41.332158418046788, 81.715435268069484],
                    [-37.306938431940978, 81.462234336073095],
                    [-33.528939507290147, 81.169992500141404],
                    [-30.005004405856766, 80.84244686439763],
                    [-26.733553539895468, 80.483242152095158],
                    [-23.706766705354312, 80.09582260697448],
                    [-20.912592437313947, 79.683366606312291],
                    [-18.336425742898882, 79.248755465012152],
                    [-15.962407688406927, 78.794567047184444],
                    [-13.774369511180169, 78.323085838929273],
                    [-11.756477147452586, 77.836322825128605],
                    [-9.893641078920552, 77.336040319610333],
                    [-8.171752376477173, 76.823778468358398],
                    [-6.577795864447751, 76.300881363299936],
                    [-5.099880281253547, 75.768521551712183],
                    [-3.727214958276591, 75.227722353736112],
                    [-2.450054259483636, 74.679377760275656],
                    [-1.25962434205627, 74.124269925487852],
                    [-0.1480421087428, 73.563084387097263],
                    [0.891767383888407, 72.996423232546192],
                    [1.866151087095147, 72.424816428661472],
                    [2.780803480284249, 71.848731545297255],
                    [3.640836265215398, 71.268582094280987],
                    [4.450841772286537, 70.684734670202772],
                    [5.214950104193917, 70.097515068270752],
                    [5.936880247701083, 69.507213531752825],
                    [6.619985585430641, 68.914089258356171],
                    [7.267294257636877, 68.318374267453578],
                    [7.881544898993241, 67.720276738021482],
                    [8.465218222716942, 67.119983881048483],
                    [9.020564911578504, 66.517664432471236],
                    [9.549630251477538, 65.913470803567691],
                    [10.054275878055421, 65.307540949353609],
                    [10.536198223419717, 64.700000979283232],
                    [10.536198999983924, 64.700000000299951],
                    [9.037348707976491, 64.688929651682201],
                    [7.540558724106006, 64.662722623950117],
                    [6.047488045736714, 64.621425983122606],
                    [4.559769130341238, 64.565113504184922],
                    [3.078996614402286, 64.493885019977768],
                    [1.606716691522138, 64.407865547057497],
                    [0.144417325998916, 64.307204219099447],
                    [-1.306480576717149, 64.192073033243958],
                    [-2.744630903293512, 64.062665444454808],
                    [-4.168768908358402, 63.919194824082012],
                    [-5.577716571762323, 63.761892816800184],
                    [-6.970386721070213, 63.591007626500812],
                    [-8.345785930076545, 63.406802245527331],
                    [-9.703016237409315, 63.209552661426358],
                    [-11.041275736486, 62.999546071793816],
                    [-12.35985812135516, 62.777079114409673],
                    [-13.658151290049886, 62.542456148632539],
                    [-14.935635095383248, 62.295987589855429],
                    [-16.191878378983972, 62.037988327599351],
                    [-17.426535376706227, 61.768776226341743],
                    [-18.639341625815348, 61.488670721676613],
                    [-19.830109489061556, 61.197991525288728],
                    [-20.998723374783822, 60.897057431555311],
                    [-22.14513477804752, 60.586185233861556],
                    [-23.269357214763545, 60.265688750635491],
                    [-24.371461123432084, 59.935877961099209],
                    [-25.451568815448354, 59.597058240845229],
                    [-26.509849515342808, 59.249529699935863],
                    [-27.546514552104838, 58.893586615430024],
                    [-28.561812732171745, 58.529516952045753],
                    [-29.55602592645522, 58.157601970954317],
                    [-30.529464888493692, 57.77811590962159],
                    [-31.48246533071034, 57.391325732696487],
                    [-32.415384256078482, 56.99749095394435],
                    [-33.328596551489625, 56.596863507644855],
                    [-34.222491847320782, 56.189687675745745],
                    [-35.097471636007128, 55.776200060884207],
                    [-35.95394663972553, 55.356629598077461],
                    [-36.792334426292712, 54.931197603286876],
                    [-37.613057251690691, 54.500117855254871],
                    [-38.41654012562617, 54.063596695331285],
                    [-39.203209083032732, 53.621833157873994],
                    [-39.973489648028817, 53.175019113241603],
                    [-40.727805482237159, 52.723339429671057],
                    [-41.466577194981483, 52.266972147746571],
                    [-42.19022130816677, 51.806088658465001],
                    [-42.899149361453794, 51.340853895690827],
                    [-43.593767148734855, 50.87142652951087],
                    [-44.274474067923848, 50.397959165882867],
                ]
            ],
        },
        {
            "zoneID": "13",
            "coordinates": [
                [
                    [-143.47849000000667, 50.103200999963235],
                    [-144.21526596799993, 49.67280155800012],
                    [-144.9390483279999, 49.237810110000055],
                    [-145.65012911999992, 48.79837624900006],
                    [-146.34879963899994, 48.35464481500003],
                    [-147.03534976699993, 47.90675599700006],
                    [-147.71006738699995, 47.454845440000156],
                    [-148.37323785999996, 46.999044346999995],
                    [-149.0251435639999, 46.53947960000005],
                    [-149.6660634959999, 46.07627387200006],
                    [-150.1818549637228, 45.694282784862196],
                    [-151.79622737084554, 44.45091894928328],
                    [-152.12532917999997, 44.18935384600013],
                    [-152.71536539499996, 43.709644213000104],
                    [-153.29600273099993, 43.226947841000026],
                    [-153.86748933699994, 42.7413612360001],
                    [-154.43006838399992, 42.25297763400016],
                    [-154.98397800699996, 41.76188710800011],
                    [-155.52945127099994, 41.268176680000124],
                    [-156.0667161599999, 40.77193042700003],
                    [-156.5959955779999, 40.27322958600007],
                    [-157.11750737199998, 39.77215265800004],
                    [-157.63146435899995, 39.26877550100005],
                    [-158.13807437699992, 38.76317143599999],
                    [-158.63754033899997, 38.255411331999994],
                    [-159.13006029299993, 37.74556370200014],
                    [-159.61582749999994, 37.233694790000186],
                    [-160.0950305089999, 36.71986865700018],
                    [-160.56785324299994, 36.20414726000001],
                    [-161.0344750859999, 35.686590537000086],
                    [-161.49507097799992, 35.16725648200003],
                    [-161.94981151199994, 34.646201218000044],
                    [-162.39886302699992, 34.123479069000155],
                    [-162.8423877129999, 33.59914263400003],
                    [-163.28054371299996, 33.07324284599997],
                    [-163.71348522199997, 32.545829045000175],
                    [-164.14136259, 32.01694903300012],
                    [-164.56432242799994, 31.486649138000075],
                    [-164.98250770899998, 30.954974270000037],
                    [-165.3960578669999, 30.421967977000065],
                    [-165.80510890399995, 29.88767249800003],
                    [-166.209793486, 29.35212881500007],
                    [-166.61024104299995, 28.815376703000027],
                    [-167.00657786799994, 28.27745477700006],
                    [-167.39892721399997, 27.738400535000153],
                    [-167.78740938399994, 27.198250410000128],
                    [-168.17214183299993, 26.657039803000032],
                    [-168.55323924899994, 26.114803129999984],
                    [-168.93081365199998, 25.57157386199998],
                    [-169.30497447799993, 25.02738455900004],
                    [-169.67582866299995, 24.482266906000177],
                    [-170.04348073199995, 23.936251756000047],
                    [-170.40803287899996, 23.38936915400012],
                    [-170.76958504899991, 22.841648374999977],
                    [-171.12823501399998, 22.29311795600006],
                    [-171.48407845299994, 21.743805725000072],
                    [-171.83720902799996, 21.19373882700006],
                    [-172.187718453, 20.64294376000015],
                    [-172.53569657099993, 20.091446393000183],
                    [-172.88123142099994, 19.539272001000086],
                    [-173.224409307, 18.98644528400007],
                    [-173.56531486399996, 18.43299039500016],
                    [-173.90403112699997, 17.87893096000016],
                    [-174.24063958799994, 17.324290106000092],
                    [-174.57522026599992, 16.769090480000102],
                    [-174.90785175999997, 16.21335427100007],
                    [-175.23861131399997, 15.657103229000029],
                    [-175.56757487099995, 15.100358689000132],
                    [-175.89481713499998, 14.543141587999969],
                    [-176.2204116199999, 13.985472481999977],
                    [-176.54443070599999, 13.427371571000037],
                    [-176.86694569599993, 12.868858707000072],
                    [-177.18802686299992, 12.309953422000035],
                    [-177.50774350199998, 11.75067493600011],
                    [-177.826163983, 11.191042179000078],
                    [-178.14335579499993, 10.631073803999982],
                    [-178.45938559599995, 10.070788204000053],
                    [-178.77431926199995, 9.51020352800009],
                    [-179.0882219279999, 8.949337693000189],
                    [-179.40115803999998, 8.388208402000146],
                    [-179.7131913949999, 7.826833155000031],
                    [-179.99999999999994, 7.309236621000082],
                    [-180.024385186, 7.265229267000052],
                    [-180.33480204600002, 6.703413877000173],
                    [-180.64450408899995, 6.141403965000052],
                    [-180.95355295600004, 5.579216364000047],
                    [-181.26200985299997, 5.016867772000069],
                    [-181.56993559300003, 4.454374768000093],
                    [-181.87739063700002, 3.8917538210001226],
                    [-182.1844351369999, 3.3290213040001504],
                    [-182.49112896900007, 2.7661935080001854],
                    [-183.04265938707834, 1.7525603729023942],
                    [-183.10370303199997, 1.6403168950001827],
                    [-183.40970201899995, 1.0773003510000194],
                    [-183.71558793399979, 0.5142530970000507],
                    [-184.02141989099988, -0.04880880999985493],
                    [-184.32725696899976, -0.6118693259999759],
                    [-184.63315825, -1.1749124069999084],
                    [-184.93918285800004, -1.7379219919998832],
                    [-185.24538999996955, -2.3008820000006835],
                    [-184.6148697619999, -2.4178766069998687],
                    [-183.98424092499988, -2.534578703999955],
                    [-183.35349851200004, -2.650974099999928],
                    [-182.72263759700002, -2.767048630999909],
                    [-182.091653311, -2.8827881629999297],
                    [-181.4605408379999, -2.998178590999885],
                    [-180.82929541999994, -3.1132058409999104],
                    [-180.19791236199976, -3.227855869999928],
                    [-179.99999999999994, -3.2636631899999315],
                    [-179.56638703, -3.342114672999969],
                    [-178.93471485599997, -3.455968276999954],
                    [-178.30289133899996, -3.569402744999934],
                    [-177.67091204599993, -3.6824041809998675],
                    [-177.03877261699998, -3.794958726999937],
                    [-176.4064687659999, -3.9070525649999013],
                    [-175.77399627999992, -4.018671920999964],
                    [-175.14135102699996, -4.129803063999873],
                    [-174.50852895399993, -4.240432306999878],
                    [-173.87552608699994, -4.350546011999882],
                    [-173.24233853999993, -4.460130587999913],
                    [-172.60896251, -4.569172493999872],
                    [-171.97539428199994, -4.677658238999925],
                    [-171.34163023099995, -4.785574385999894],
                    [-170.70766682399997, -4.892907551999883],
                    [-170.0735006209999, -4.999644408999927],
                    [-169.43912827599996, -5.105771685999912],
                    [-168.80454654099998, -5.211276172999931],
                    [-168.1697522659999, -5.316144718999851],
                    [-167.53474240199995, -5.42036423299993],
                    [-166.89951399999995, -5.5239216909998845],
                    [-166.26406421599992, -5.626804131999961],
                    [-165.6283903119999, -5.728998661999924],
                    [-164.99248965399997, -5.830492455999945],
                    [-164.35635971799996, -5.931272759999956],
                    [-163.71999809, -6.03132688799991],
                    [-163.08340246499992, -6.130642231999957],
                    [-162.44657065099992, -6.229206255999941],
                    [-161.80950057099994, -6.327006499999868],
                    [-161.17219025999998, -6.424030585999958],
                    [-160.53463787299998, -6.520266212999957],
                    [-159.89684167799996, -6.615701161999823],
                    [-159.25880006499997, -6.710323297999935],
                    [-158.62051154099998, -6.804120571999874],
                    [-157.98197473399998, -6.897081020999906],
                    [-157.34318839399992, -6.989192769999931],
                    [-156.70415139299993, -7.080444035999847],
                    [-156.06486272599997, -7.170823127999938],
                    [-155.42532150999997, -7.2603184459998715],
                    [-154.78552699099998, -7.348918488999914],
                    [-154.14547853699997, -7.436611852999874],
                    [-153.50517564199993, -7.523387231999948],
                    [-152.86461792699995, -7.609233421999875],
                    [-152.22380514199992, -7.694139319999977],
                    [-151.5827371599999, -7.778093928999965],
                    [-150.94141398599993, -7.861086359999945],
                    [-150.29983575099996, -7.943105827999943],
                    [-149.65800271499998, -8.02414166199992],
                    [-149.0159152649999, -8.104183299999875],
                    [-148.37357391899997, -8.183220293999966],
                    [-147.73097932099995, -8.261242311999979],
                    [-147.088132247, -8.338239138999938],
                    [-146.44503359699993, -8.41420067799993],
                    [-145.8016844029999, -8.489116953999883],
                    [-145.15808582399995, -8.562978112999929],
                    [-144.51423914599997, -8.635774425999955],
                    [-143.87014578399993, -8.707496288999948],
                    [-143.22580727899992, -8.778134227999885],
                    [-142.58122529899998, -8.847678894999888],
                    [-141.9364016369999, -8.916121075999968],
                    [-141.29133821199997, -8.983451688999935],
                    [-140.64603706799994, -9.049661786999877],
                    [-140.00050037199992, -9.114742557999932],
                    [-139.35473041399996, -9.178685330999883],
                    [-138.70872960599996, -9.241481570999895],
                    [-138.06250048199985, -9.303122886999972],
                    [-137.4160456929999, -9.36360103099986],
                    [-136.7693680129999, -9.422907897999835],
                    [-136.1224703289999, -9.48103553199985],
                    [-135.4753556479999, -9.537976122999964],
                    [-134.82802708999998, -9.593722010999898],
                    [-134.18048788799985, -9.64826568799998],
                    [-133.53274138799998, -9.701599797999904],
                    [-132.8847910469999, -9.753717138999946],
                    [-132.236640428, -9.80461066599986],
                    [-131.58829320399997, -9.854273489999912],
                    [-130.939753151, -9.902698881999981],
                    [-130.29102414999988, -9.94988027099987],
                    [-129.64211018299994, -9.995811249999974],
                    [-128.99301533099998, -10.040485574999934],
                    [-128.34374377199998, -10.08389716399995],
                    [-127.69429978199997, -10.126040101999877],
                    [-127.04468772699983, -10.166908642999886],
                    [-126.3949120659999, -10.206497205999938],
                    [-125.74497734599998, -10.24480038199988],
                    [-125.09488820099989, -10.281812930999934],
                    [-124.44464934699994, -10.317529784999863],
                    [-123.7942655839999, -10.35194605199996],
                    [-123.14374178999992, -10.385057009999912],
                    [-122.49308291899996, -10.4168581159999],
                    [-121.84229399998088, -10.447344999743109],
                    [-122.01423644072958, -9.829346820549688],
                    [-122.18553736917693, -9.211262170456394],
                    [-122.35623993891102, -8.593096877759365],
                    [-122.52638674892461, -7.974856693590766],
                    [-122.69601988075647, -7.356547296060398],
                    [-122.86518094477236, -6.73817429900231],
                    [-123.03391111525275, -6.119743254623813],
                    [-123.20225117307649, -5.501259662051837],
                    [-123.37024154200668, -4.882728969882976],
                    [-123.5379223286264, -4.264156583529882],
                    [-123.70533335722416, -3.6455478676699613],
                    [-123.87251420888174, -3.0269081557933646],
                    [-124.03950425475875, -2.408242750601289],
                    [-124.20634269607916, -1.7895569306039079],
                    [-124.37306859536943, -1.170855957768083],
                    [-124.53972091574383, -0.552145077016689],
                    [-124.70633855199122, 0.06657047332424781],
                    [-124.87296037016233, 0.6852854602279876],
                    [-125.0396252377073, 1.30399465151595],
                    [-125.20637206176065, 1.9226928070639246],
                    [-125.37323982387937, 2.54137467904917],
                    [-125.54026761402957, 3.160035002206826],
                    [-125.70749466567315, 3.778668492328563],
                    [-125.87496039305381, 4.397269842014907],
                    [-126.04270442648419, 5.015833710178867],
                    [-126.21076664798107, 5.634354725045341],
                    [-126.37918722860388, 6.252827471205478],
                    [-126.54800666593735, 6.871246491166346],
                    [-126.71726582277978, 7.489606272955598],
                    [-126.88700596382705, 8.107901252970294],
                    [-127.0572687960589, 8.726125803231753],
                    [-127.2280965108726, 9.344274230435701],
                    [-127.39953182186804, 9.962340767406147],
                    [-127.57161800898194, 10.580319569796302],
                    [-127.74439896107157, 11.198204706991078],
                    [-127.91791922229697, 11.81599015850935],
                    [-128.09222403430567, 12.43366980685829],
                    [-128.26735938591338, 13.051237429732055],
                    [-128.44337205993628, 13.668686695067663],
                    [-128.620309684922, 14.286011153396032],
                    [-128.79822078523034, 14.903204228846334],
                    [-128.97715483701296, 15.520259214245755],
                    [-129.1571623201424, 16.13716926292568],
                    [-129.33829477804068, 16.753927377473133],
                    [-129.5206048777065, 17.370526405334715],
                    [-129.70414646984182, 17.986959028118463],
                    [-129.88897465572785, 18.603217752248725],
                    [-130.07514585194969, 19.21929490002003],
                    [-130.26271786201977, 19.835182598548954],
                    [-130.45174994780092, 20.450872771980585],
                    [-130.64230290902594, 21.066357127389836],
                    [-130.83443915682074, 21.681627145738332],
                    [-131.02822280301984, 22.296674068176856],
                    [-131.22371974273597, 22.911488885551705],
                    [-131.42099774792376, 23.526062323058966],
                    [-131.62012656084596, 24.140384829248205],
                    [-131.82117799478425, 24.754446558281188],
                    [-132.0242260378007, 25.368237358383624],
                    [-132.2293469639955, 25.98174675155559],
                    [-132.43661944861435, 26.594963921773967],
                    [-132.64612468720213, 27.207877693000796],
                    [-132.85794652610554, 27.820476513390247],
                    [-133.0721715942716, 28.4327484342964],
                    [-133.2888894455458, 29.04468108893076],
                    [-133.5081927061142, 29.65626167296898],
                    [-133.7301772320967, 30.267476918112777],
                    [-133.95494227398336, 30.878313070246122],
                    [-134.18259065101876, 31.488755861996935],
                    [-134.413228933984, 32.098790487545386],
                    [-134.64696764117173, 32.708401570188244],
                    [-134.88392144066103, 33.317573134546194],
                    [-135.12420936793393, 33.92628857232995],
                    [-135.36795505674024, 34.53453060895026],
                    [-135.61528697700618, 35.1422812652342],
                    [-135.86633869498735, 35.74952182013811],
                    [-136.12124914161734, 36.35623276936349],
                    [-136.38016290274788, 36.96239377912485],
                    [-136.64323052183556, 37.567983641016326],
                    [-136.91060882321904, 38.172980221429896],
                    [-137.18246125459166, 38.77736041002754],
                    [-137.45895824991163, 39.381100059360165],
                    [-137.74027761610944, 39.9841739283421],
                    [-138.02660494293184, 40.58655561527479],
                    [-138.31813403427896, 41.18821749117217],
                    [-138.61506737572938, 41.7891306211406],
                    [-138.91761662290435, 42.38926469145605],
                    [-139.2260031230727, 42.98858792299734],
                    [-139.54045847373987, 43.58706698012867],
                    [-139.8612251106752, 44.18466687433829],
                    [-140.18855694012518, 44.78135086232635],
                    [-140.52272000601164, 45.37708033329534],
                    [-140.86399320331162, 45.971814689198254],
                    [-141.54099162995072, 47.11146085608078],
                    [-141.56905444005508, 47.158124964447666],
                    [-141.93347161076315, 47.74960855864401],
                    [-142.3062589562427, 48.33991208398777],
                    [-142.68777205386863, 48.928982892323404],
                    [-143.07838469674823, 49.51676542179359],
                    [-143.47849000000667, 50.103200999963235],
                ]
            ],
        },
        {
            "zoneID": "14",
            "coordinates": [
                [
                    [-180.00459362069702, -64.29537994948276],
                    [-181.30648057699986, -64.19207303299993],
                    [-182.74463090299986, -64.06266544399995],
                    [-184.16876890899994, -63.91919482299994],
                    [-185.57771657199982, -63.761892816999875],
                    [-186.9703867209998, -63.591007626999954],
                    [-188.34578592999986, -63.40680224499988],
                    [-189.7030162379999, -63.20955266099992],
                    [-191.04127573699992, -62.99954607099994],
                    [-192.35985812199974, -62.77707911399983],
                    [-193.6581512899999, -62.54245614799987],
                    [-194.93563509599974, -62.29598758899988],
                    [-196.19187837899977, -62.03798832699994],
                    [-197.42653537599986, -61.76877622599994],
                    [-198.63934162599975, -61.48867072099995],
                    [-199.8301094889999, -61.19799152499996],
                    [-200.9987233749999, -60.89705743099995],
                    [-202.1451347779999, -60.58618523299998],
                    [-203.26935721499973, -60.26568874999998],
                    [-204.37146112399975, -59.93587796099996],
                    [-205.45156881599993, -59.59705823999991],
                    [-206.50984951499987, -59.24952969999998],
                    [-207.5465145519998, -58.89358661499995],
                    [-208.5618127329999, -58.52951695199988],
                    [-209.5560259259998, -58.15760197099996],
                    [-210.5294648879998, -57.77811590899984],
                    [-211.48246533099993, -57.391325731999984],
                    [-212.4153842559999, -56.99749095399994],
                    [-213.3285965519996, -56.596863507999956],
                    [-214.2224918469999, -56.18968767599989],
                    [-215.09747163599974, -55.776200059999894],
                    [-215.9539466399998, -55.35662959699994],
                    [-216.7923344269999, -54.93119760299999],
                    [-217.61305725199998, -54.50011785499993],
                    [-218.41654012599966, -54.063596694999944],
                    [-219.20320908299976, -53.62183315699991],
                    [-219.97348964799977, -53.17501911199997],
                    [-220.72780548299986, -52.72333942899991],
                    [-221.4665771949999, -52.26697214699993],
                    [-222.19022130799996, -51.80608865799991],
                    [-222.89914936099984, -51.34085389499995],
                    [-223.59376714899983, -50.87142652999995],
                    [-224.2744740679999, -50.397959165999964],
                    [-224.94166257499984, -49.92059854199994],
                    [-225.59571773699997, -49.43948573299991],
                    [-226.23701686599992, -48.954756343999975],
                    [-226.86592923799978, -48.466540712999915],
                    [-227.48281586599973, -47.97496410399992],
                    [-228.0880293469999, -47.48014689899986],
                    [-228.68191375599991, -46.982204785999954],
                    [-229.26480458599988, -46.48124894099993],
                    [-229.8370287329997, -45.977386210999896],
                    [-230.39890451599987, -45.47071928399993],
                    [-230.95074172499986, -44.961346859999935],
                    [-231.4928416989997, -44.44936381499997],
                    [-232.0254974299998, -43.93486135699993],
                    [-232.54899367799993, -43.417927180999925],
                    [-233.06360710899986, -42.89864561699983],
                    [-233.56960644699993, -42.37709776999998],
                    [-234.06725263499985, -41.85336165799998],
                    [-234.5567990019999, -41.32751234199998],
                    [-235.0384914449999, -40.79962205499987],
                    [-235.51256861099972, -40.269760320999865],
                    [-235.97926208099983, -39.73799407099989],
                    [-236.43879656499996, -39.20438775599996],
                    [-236.89139008799978, -38.66900345499994],
                    [-237.33725418499984, -38.131900974999894],
                    [-237.77659409199995, -37.593137946999946],
                    [-238.2096089339999, -37.05276992699987],
                    [-238.6364919189999, -36.510850478999885],
                    [-239.05743051699983, -35.96743126299998],
                    [-239.47260665199994, -35.422562120999885],
                    [-239.882196874, -34.87629114899994],
                    [-240.28637254699976, -34.32866477699997],
                    [-240.68530001099978, -33.779727838999975],
                    [-241.07914076299977, -33.22952364199995],
                    [-241.46805161599968, -32.678094033999855],
                    [-241.8521848629999, -32.12547946199993],
                    [-242.23168843899995, -31.571719035999934],
                    [-242.60670606599984, -31.016850586999965],
                    [-242.97737741299972, -30.46091071799998],
                    [-243.34383823399975, -29.903934859999936],
                    [-243.7062205119999, -29.345957321999947],
                    [-244.0646525959999, -28.787011336999967],
                    [-244.41925933599993, -28.227129109999908],
                    [-244.77016220599975, -27.666341862999957],
                    [-245.1174794379999, -27.104679872999895],
                    [-245.46132613599977, -26.54217251599988],
                    [-245.80181439699993, -25.978848305999975],
                    [-246.13905342299975, -25.414734927999973],
                    [-246.47314963399978, -24.84985927899993],
                    [-246.80420676999978, -24.2842474979999],
                    [-247.13232600020666, -23.717924999663467],
                    [-247.62176298183803, -24.1767158670217],
                    [-248.11472543261635, -24.633933371813782],
                    [-248.61130245312262, -25.08953210955957],
                    [-249.11158410291188, -25.543465755720035],
                    [-249.61566139927675, -25.99568704306114],
                    [-250.12362630760384, -26.446147734665203],
                    [-250.32709710460182, -26.62446234422407],
                    [-250.63557173202474, -26.89479859678886],
                    [-251.1515915039722, -27.341589375874378],
                    [-251.67178036293654, -27.786468767159818],
                    [-252.1962339400219, -28.22938439393721],
                    [-252.72504873095681, -28.67028277616447],
                    [-253.2583220709532, -29.10910930412541],
                    [-253.7961521049177, -29.545808216987666],
                    [-254.33863774576764, -29.980322567816074],
                    [-254.88587863604485, -30.412594204129334],
                    [-255.43797510303426, -30.842563737213197],
                    [-255.99502810608078, -31.270170516927863],
                    [-256.55713917701553, -31.69535260801814],
                    [-257.1244103590252, -32.11804675992494],
                    [-257.69694413518164, -32.5381883858426],
                    [-258.27484335081994, -32.95571153622893],
                    [-258.85821112912004, -33.37054887616466],
                    [-259.44715078324066, -33.78263166106109],
                    [-260.0417657091598, -34.19188971306977],
                    [-260.642159282962, -34.598251405938754],
                    [-261.24843474198474, -35.00164363702203],
                    [-261.86069505606565, -35.40199181313574],
                    [-262.4790427968438, -35.799219835863255],
                    [-263.1035799847642, -36.19325007876404],
                    [-263.73440793713803, -36.58400338082566],
                    [-264.3716271029541, -36.97139902987067],
                    [-265.01533687804704, -37.35535475685822],
                    [-265.66563541916935, -37.73578672498866],
                    [-266.32261944411596, -38.11260952880332],
                    [-266.98638401105643, -38.48573619123596],
                    [-267.6570223007692, -38.855078164762745],
                    [-268.334625370832, -39.220545334899555],
                    [-269.0192819071169, -39.58204603514804],
                    [-269.7110779600397, -39.939487051143146],
                    [-270.410096663215, -40.292773644793954],
                    [-271.11641794616537, -40.64180956702876],
                    [-271.83011822883634, -40.9864970929832],
                    [-272.55127010716467, -41.326737048837856],
                    [-273.2799420232026, -41.66242884500747],
                    [-274.0161979221481, -41.9934705240226],
                    [-274.760096904874, -42.319758804012736],
                    [-275.51169285711956, -42.641189136034825],
                    [-276.27103408312786, -42.95765576280161],
                    [-277.03816291914154, -43.26905178680528],
                    [-277.8131153400003, -43.57526924613927],
                    [-278.5959205627917, -43.876199195967956],
                    [-279.3866006410532, -44.171731796942424],
                    [-280.1851700581255, -44.461756414763386],
                    [-280.9916353118101, -44.74616172379223],
                    [-281.80599450522084, -45.024835823107196],
                    [-282.6282369378921, -45.297666357758146],
                    [-283.4583426902312, -45.56454064786624],
                    [-284.2962822341186, -45.825345828973354],
                    [-285.1420160330565, -46.07996899918487],
                    [-285.995494161113, -46.32829737406212],
                    [-286.8566559430584, -46.570218451810035],
                    [-287.72542959684904, -46.80562018516156],
                    [-288.60173191114916, -47.03439116191129],
                    [-289.4854679419459, -47.25642078889405],
                    [-290.376530731104, -47.471599491961456],
                    [-291.2748010617597, -47.67981891480554],
                    [-292.18014724979787, -47.88097212583148],
                    [-293.0924249640701, -48.07495383222664],
                    [-294.01147709709494, -48.26166059782912],
                    [-294.93713367408975, -48.44099106499266],
                    [-295.86921181088815, -48.61284618020335],
                    [-296.8075157190874, -48.77712942219239],
                    [-297.75183677482346, -48.93374702780142],
                    [-298.70195362418, -49.08260822584441],
                    [-299.6576323628715, -49.22362545977353],
                    [-300.6186267642066, -49.356714620041714],
                    [-301.58467857292874, -49.481795262970365],
                    [-302.5555178548824, -49.59879082796709],
                    [-303.53086341005906, -49.70762885304441],
                    [-304.5104232451182, -49.80824117984332],
                    [-305.49389510793617, -49.90056415005762],
                    [-306.4809670742352, -49.98453879021628],
                    [-307.4713182001871, -50.06011099391361],
                    [-308.46461921500224, -50.12723168084858],
                    [-309.46053327619444, -50.18585695081879],
                    [-310.4587167689316, -50.23594822001712],
                    [-311.45882013592006, -50.277472342787235],
                    [-312.46048876297283, -50.310401716133015],
                    [-313.463363883818, -50.33471436893643],
                    [-314.46708351709503, -50.350394034178464],
                    [-315.47128342104634, -50.35743019887218],
                    [-316.47559806689844, -50.3558181398476],
                    [-317.4796616180945, -50.345558939996465],
                    [-318.4831089128729, -50.32665948207466],
                    [-319.4855764371511, -50.29913243115823],
                    [-320.4867032982092, -50.26299618686221],
                    [-321.4861321691818, -50.21827482881014],
                    [-322.4835102171612, -50.16499803716471],
                    [-323.47849000000997, -50.10320099979464],
                    [-323.26657842199995, -50.7295693289999],
                    [-323.04892489599985, -51.35554317799989],
                    [-322.82524266899975, -51.98110257999997],
                    [-322.595226518, -52.60622625499997],
                    [-322.35855123799985, -53.23089150299995],
                    [-322.11486999699997, -53.855074085999945],
                    [-321.8638125259999, -54.478748088999964],
                    [-321.6049831209999, -55.101885780999964],
                    [-321.3379584529998, -55.724457447999896],
                    [-321.0622851459999, -56.34643121899995],
                    [-320.77747710199975, -56.96777286299988],
                    [-320.4830125499999, -57.588445572999944],
                    [-320.17833076999983, -58.20840972199994],
                    [-319.86282846199987, -58.82762258399998],
                    [-319.53585572199984, -59.44603804099995],
                    [-319.1967115509999, -60.06360623299997],
                    [-318.84463886799983, -60.68027318299988],
                    [-318.4788189409999, -61.29598036999994],
                    [-318.0983651669999, -61.91066424899998],
                    [-317.7023161109999, -62.52425570999986],
                    [-317.2896277149998, -63.136679468999944],
                    [-316.85916454799985, -63.74785337799989],
                    [-316.4096899849999, -64.35768764599987],
                    [-315.9398551459998, -64.96608395199996],
                    [-315.4481864469999, -65.57293443499998],
                    [-314.9330715489998, -66.17812054099983],
                    [-314.39274349699986, -66.78151171499997],
                    [-313.8252627859999, -67.38296388699996],
                    [-313.22849707599977, -67.98231774899989],
                    [-312.6000982239998, -68.57939676199999],
                    [-311.93747627599987, -69.17400486499992],
                    [-311.23777001299976, -69.76592382599995],
                    [-310.49781361199996, -70.35491016899988],
                    [-309.7140989399999, -70.94069162299985],
                    [-308.88273300499975, -71.5229629779999],
                    [-307.9993900429998, -72.10138127899995],
                    [-307.0592578159999, -72.67556020499995],
                    [-306.0569777459999, -73.24506353199996],
                    [-304.9865787309999, -73.80939748499986],
                    [-303.8414048159999, -74.36800181899997],
                    [-302.61403743899996, -74.92023942099996],
                    [-301.29621384999984, -75.46538420399992],
                    [-299.87874458799985, -76.00260707299998],
                    [-298.3514348959999, -76.53095972499995],
                    [-296.7030177629998, -77.04935612499997],
                    [-294.92111032899976, -77.55655153199996],
                    [-292.99221091599986, -78.05111917999983],
                    [-290.90176130299983, -78.53142496199996],
                    [-288.6343081199999, -78.99560095499993],
                    [-286.1738080389998, -79.44151932999995],
                    [-283.50413239399984, -79.8667692009999],
                    [-280.6098349579998, -80.26864034099998],
                    [-277.47724602699975, -80.64411938399991],
                    [-274.09593783199983, -80.98990595699996],
                    [-270.4605587609998, -81.30245768399999],
                    [-266.5729459329998, -81.57807334799992],
                    [-262.44429490799985, -81.81302155399999],
                    [-258.09701069899995, -82.00371665299991],
                    [-253.56573775999988, -82.14693408599999],
                    [-248.89704976199977, -82.24004457899991],
                    [-244.14745132999983, -82.28123456299994],
                    [-239.37971767899958, -82.26967401299999],
                    [-234.65807340899977, -82.20559764899991],
                    [-230.04309123599984, -82.0902816929999],
                    [-225.5872880099999, -81.92592136299999],
                    [-221.3321584179998, -81.71543526699998],
                    [-217.30693843199987, -81.46223433499995],
                    [-213.5289395079999, -81.16999249999998],
                    [-210.00500440499977, -80.84244686399995],
                    [-206.73355353999986, -80.48324215199989],
                    [-203.70676670399993, -80.0958226059999],
                    [-200.9125924359998, -79.68336660599988],
                    [-198.33642574399988, -79.24875546499999],
                    [-195.9624076879998, -78.79456704599994],
                    [-193.7743695109996, -78.32308583899999],
                    [-191.75647714599992, -77.83632282499997],
                    [-189.8936410789999, -77.33604031899995],
                    [-188.17175237599977, -76.82377846799994],
                    [-186.57779586499996, -76.30088136299997],
                    [-185.0998802809999, -75.76852155199998],
                    [-183.72721495899984, -75.22772235399998],
                    [-182.4500542589997, -74.67937775999991],
                    [-181.25962434299976, -74.12426992499985],
                    [-180.1480421079996, -73.56308438599996],
                    [-179.99999999999986, -73.48240642299999],
                    [-179.10823261599995, -72.99642323199998],
                    [-178.1338489139999, -72.42481642799999],
                    [-177.21919651899998, -71.84873154499996],
                    [-176.35916373499998, -71.26858209399995],
                    [-175.549158228, -70.68473466999995],
                    [-174.78504989699996, -70.09751506799984],
                    [-174.06311975199995, -69.50721353199998],
                    [-173.38001441399996, -68.91408925799988],
                    [-172.73270574199998, -68.31837426699991],
                    [-172.1184551009999, -67.72027673699995],
                    [-171.53478177799994, -67.11998388099994],
                    [-170.97943508799997, -66.51766443299994],
                    [-170.45036974899995, -65.91347080299994],
                    [-169.94572412199997, -65.30754094899999],
                    [-169.463801000004, -64.69999999980007],
                    [-170.96265129199995, -64.6889296519999],
                    [-172.45944127599998, -64.66272262299992],
                    [-173.95251195399993, -64.62142598199995],
                    [-175.44023086899992, -64.5651135039999],
                    [-176.9210033859999, -64.49388501899995],
                    [-178.39328330799995, -64.40786554599998],
                    [-179.85558267399992, -64.30720421799987],
                    [-179.99999999999994, -64.29574446099997],
                    [-180.00459362069702, -64.29537994948276],
                ]
            ],
        },
        {
            "zoneID": "15",
            "coordinates": [
                [
                    [-179.99999999999986, -36.43142668794542],
                    [-180.00003736747794, -36.4312419300806],
                    [-180.10233927, -35.92542563699993],
                    [-180.22821282499996, -35.29289327599997],
                    [-180.35213407299975, -34.66023253299994],
                    [-180.47417724300004, -34.02744831399997],
                    [-180.59441347199996, -33.394545317999984],
                    [-180.71291098200004, -32.76152805199996],
                    [-180.829735234, -32.12840083599997],
                    [-180.94494908500002, -31.49516781899996],
                    [-181.05861292899985, -30.86183298599991],
                    [-181.170784828, -30.22840016599997],
                    [-181.28152063899995, -29.59487304099997],
                    [-181.39087412999993, -28.961255156999982],
                    [-181.49889709400006, -28.32754992499997],
                    [-181.605639451, -27.693760634999933],
                    [-181.71114934400012, -27.05989045599995],
                    [-181.81547323800007, -26.42594244899982],
                    [-181.91865600199992, -25.79191956699998],
                    [-182.02074099199987, -25.157824661999882],
                    [-182.1217701339999, -24.5236604939999],
                    [-182.22178399199993, -23.889429729999847],
                    [-182.32082184199993, -23.25513495299998],
                    [-182.41892173500003, -22.620778664999932],
                    [-182.51612056300002, -21.986363290999975],
                    [-182.61245411699983, -21.351891182999907],
                    [-182.70795714500002, -20.71736462399997],
                    [-182.80266340199984, -20.082785831999956],
                    [-182.89660570799992, -19.448156961999928],
                    [-182.98981598899996, -18.813480110999876],
                    [-183.0823253299999, -18.178757318999885],
                    [-183.17416401599993, -17.543990574999953],
                    [-183.26536157499987, -16.909181816999933],
                    [-183.35594681700005, -16.274332933999972],
                    [-183.4459478779999, -15.639445773999967],
                    [-183.5353922490001, -15.004522139999949],
                    [-183.62430681999996, -14.369563794999976],
                    [-183.7127179070001, -13.734572464999871],
                    [-183.80065128800004, -13.099549840999941],
                    [-183.88813223700004, -12.464497579999943],
                    [-183.97518555, -11.829417306999915],
                    [-184.06183557499998, -11.194310618999964],
                    [-184.14810624400002, -10.559179083999936],
                    [-184.23402109599985, -9.924024243999895],
                    [-184.31960330500004, -9.28884761899991],
                    [-184.4048757070001, -8.653650703999915],
                    [-184.489860825, -8.018434974999934],
                    [-184.574580889, -7.383201888999963],
                    [-184.65905786699986, -6.747952883999915],
                    [-184.74331348100006, -6.112689382999861],
                    [-184.8273692329999, -5.477412793999861],
                    [-184.91124642899987, -4.842124513999977],
                    [-184.99496619600006, -4.2068259249999755],
                    [-185.0785495060001, -3.571518401999924],
                    [-185.16201719900002, -2.9362033069999143],
                    [-185.24538999996955, -2.3008820000006835],
                    [-185.49315112087947, -2.4187096319188868],
                    [-185.49315143268151, -2.4187097801370214],
                    [-186.40380393880017, -2.8514063289193246],
                    [-186.9834131499982, -3.126245856930268],
                    [-187.56332596705963, -3.4007659297519695],
                    [-188.1435688896962, -3.674938241753125],
                    [-188.72416834224734, -3.9487344608132844],
                    [-189.30515066683486, -4.222126222623615],
                    [-189.88654211591285, -4.495085131586791],
                    [-190.46836884877158, -4.767582756619561],
                    [-191.05065692093982, -5.039590632050874],
                    [-191.63343228098728, -5.311080252525926],
                    [-192.21672075862793, -5.582023073702942],
                    [-192.80054806372104, -5.852390509707163],
                    [-193.38493977407552, -6.1221539296300875],
                    [-193.9699213302021, -6.391284659929511],
                    [-194.5555180277173, -6.659753978831532],
                    [-195.14175500919293, -6.92753311762965],
                    [-195.7286572568633, -7.194593257886197],
                    [-196.31624958377552, -7.46090553058292],
                    [-196.90455662689322, -7.7264410154703],
                    [-197.49360283855012, -7.991170738819278],
                    [-198.08341247730164, -8.25506567487048],
                    [-198.67400960018125, -8.518096740985868],
                    [-199.2654180529002, -8.780234801047584],
                    [-199.857661462903, -9.041450661659326],
                    [-200.4507632270705, -9.301715074895355],
                    [-201.04474650602285, -9.560998733752285],
                    [-201.6396342131739, -9.819272275747494],
                    [-202.2354490029845, -10.07650628067023],
                    [-202.832213264715, -10.332671271930792],
                    [-203.42994911013147, -10.587737715711512],
                    [-204.02867836415717, -10.84167602081584],
                    [-204.62842255427833, -11.094456540718454],
                    [-205.22920289979695, -11.346049573914343],
                    [-205.8310403007845, -11.596425363069898],
                    [-206.4339553287875, -11.845554097821719],
                    [-207.03796821298118, -12.093405915675191],
                    [-207.64309883267225, -12.339950902056103],
                    [-208.24936670105606, -12.585159092759],
                    [-208.85679095736785, -12.8290004770451],
                    [-209.46539035399059, -13.071444995545107],
                    [-210.07518324310587, -13.312462547054395],
                    [-210.6861875669511, -13.552022986985548],
                    [-211.29842084297363, -13.790096132765086],
                    [-211.91190015493393, -14.026651763933728],
                    [-212.52664213391355, -14.261659627894687],
                    [-213.14266295311614, -14.495089439812887],
                    [-213.75997831087497, -14.726910888813052],
                    [-214.37860341775666, -14.95709363943007],
                    [-214.99855298386635, -15.185607336704663],
                    [-215.61984120700282, -15.412421610134459],
                    [-216.24248175606382, -15.637506076921909],
                    [-216.86648776299975, -15.860830348021011],
                    [-217.4918718038701, -16.08236403163744],
                    [-218.11864588794856, -16.302076738725304],
                    [-218.74682144592634, -16.519938086936406],
                    [-219.37640931281962, -16.735917710017077],
                    [-220.0074197170729, -16.94998525825639],
                    [-220.63986226596506, -17.16211040803438],
                    [-221.27374593411352, -17.37226286786853],
                    [-221.90907904608036, -17.580412383712257],
                    [-222.54586926777617, -17.786528744602947],
                    [-223.18412358891607, -17.9905817940072],
                    [-223.82384831412404, -18.192541432270332],
                    [-224.46504904678804, -18.392377627912595],
                    [-225.10773067761414, -18.590060422775082],
                    [-225.7518973719329, -18.785559941119004],
                    [-226.39755255790203, -18.978846399120926],
                    [-227.04469891216223, -19.16989011091988],
                    [-227.69333835194138, -19.358661500963706],
                    [-228.34347201880925, -19.545131107857173],
                    [-228.99510027168, -19.729269599905876],
                    [-229.64822267301864, -19.911047779915464],
                    [-230.30283797899452, -20.090436597935252],
                    [-230.95894413083334, -20.267407158856543],
                    [-231.6165382430225, -20.44193073515754],
                    [-232.27561659581465, -20.61397877555015],
                    [-232.93617462417947, -20.783522917024413],
                    [-233.5982069128092, -20.950534994697136],
                    [-234.26170718591865, -21.114987053254765],
                    [-234.92666830180028, -21.27685135965129],
                    [-235.59308224462475, -21.436100411702398],
                    [-236.26094012019504, -21.592706954031144],
                    [-236.9302321499467, -21.746643985065816],
                    [-237.60094766785025, -21.897884772632153],
                    [-238.27307511396245, -22.046402864800143],
                    [-238.94660203392817, -22.192172102830057],
                    [-239.62151507563004, -22.335166631917275],
                    [-240.2977999891388, -22.475360916886302],
                    [-240.97544162501535, -22.612729752088],
                    [-241.65442393360885, -22.7472482737943],
                    [-242.33472996890623, -22.87889197474243],
                    [-243.01634188963328, -23.007636717530318],
                    [-243.6992409609007, -23.13345874491239],
                    [-244.38340756060518, -23.256334695094893],
                    [-245.06882118202574, -23.376241612530293],
                    [-245.75546044212265, -23.493156962511932],
                    [-246.44330308703385, -23.60705864367071],
                    [-247.13232600020666, -23.717924999663467],
                    [-246.80420676999978, -24.2842474979999],
                    [-246.47314963399978, -24.84985927899993],
                    [-246.13905342299975, -25.414734927999973],
                    [-245.80181439699993, -25.978848305999975],
                    [-245.46132613599977, -26.54217251599988],
                    [-245.1174794379999, -27.104679872999895],
                    [-244.77016220599975, -27.666341862999957],
                    [-244.41925933599993, -28.227129109999908],
                    [-244.0646525959999, -28.787011336999967],
                    [-243.7062205119999, -29.345957321999947],
                    [-243.34383823399975, -29.903934859999936],
                    [-242.97737741299972, -30.46091071799998],
                    [-242.60670606599984, -31.016850586999965],
                    [-242.23168843899995, -31.571719035999934],
                    [-241.8521848629999, -32.12547946199993],
                    [-241.46805161599968, -32.678094033999855],
                    [-241.07914076299977, -33.22952364199995],
                    [-240.68530001099978, -33.779727838999975],
                    [-240.28637254699976, -34.32866477699997],
                    [-239.882196874, -34.87629114899994],
                    [-239.47260665199994, -35.422562120999885],
                    [-239.05743051699983, -35.96743126299998],
                    [-238.6364919189999, -36.510850478999885],
                    [-238.2096089339999, -37.05276992699987],
                    [-237.77659409199995, -37.593137946999946],
                    [-237.33725418499984, -38.131900974999894],
                    [-236.89139008799978, -38.66900345499994],
                    [-236.43879656499996, -39.20438775599996],
                    [-235.97926208099983, -39.73799407099989],
                    [-235.51256861099972, -40.269760320999865],
                    [-235.0384914449999, -40.79962205499987],
                    [-234.5567990019999, -41.32751234199998],
                    [-234.06725263499985, -41.85336165799998],
                    [-233.56960644699993, -42.37709776999998],
                    [-233.06360710899986, -42.89864561699983],
                    [-232.54899367799993, -43.417927180999925],
                    [-232.0254974299998, -43.93486135699993],
                    [-231.4928416989997, -44.44936381499997],
                    [-230.95074172499986, -44.961346859999935],
                    [-230.39890451599987, -45.47071928399993],
                    [-229.8370287329997, -45.977386210999896],
                    [-229.26480458599988, -46.48124894099993],
                    [-228.68191375599991, -46.982204785999954],
                    [-228.0880293469999, -47.48014689899986],
                    [-227.48281586599973, -47.97496410399992],
                    [-226.86592923799978, -48.466540712999915],
                    [-226.23701686599992, -48.954756343999975],
                    [-225.59571773699997, -49.43948573299991],
                    [-224.94166257499984, -49.92059854199994],
                    [-224.2744740679999, -50.397959165999964],
                    [-223.59376714899983, -50.87142652999995],
                    [-222.89914936099984, -51.34085389499995],
                    [-222.19022130799996, -51.80608865799991],
                    [-221.4665771949999, -52.26697214699993],
                    [-220.72780548299986, -52.72333942899991],
                    [-219.97348964799977, -53.17501911199997],
                    [-219.20320908299976, -53.62183315699991],
                    [-218.41654012599966, -54.063596694999944],
                    [-217.61305725199998, -54.50011785499993],
                    [-216.7923344269999, -54.93119760299999],
                    [-215.9539466399998, -55.35662959699994],
                    [-215.09747163599974, -55.776200059999894],
                    [-214.2224918469999, -56.18968767599989],
                    [-213.3285965519996, -56.596863507999956],
                    [-212.4153842559999, -56.99749095399994],
                    [-211.48246533099993, -57.391325731999984],
                    [-210.5294648879998, -57.77811590899984],
                    [-209.5560259259998, -58.15760197099996],
                    [-208.5618127329999, -58.52951695199988],
                    [-207.5465145519998, -58.89358661499995],
                    [-206.50984951499987, -59.24952969999998],
                    [-205.45156881599993, -59.59705823999991],
                    [-204.37146112399975, -59.93587796099996],
                    [-203.26935721499973, -60.26568874999998],
                    [-202.1451347779999, -60.58618523299998],
                    [-200.9987233749999, -60.89705743099995],
                    [-199.8301094889999, -61.19799152499996],
                    [-198.63934162599975, -61.48867072099995],
                    [-197.42653537599986, -61.76877622599994],
                    [-196.19187837899977, -62.03798832699994],
                    [-194.93563509599974, -62.29598758899988],
                    [-193.6581512899999, -62.54245614799987],
                    [-192.35985812199974, -62.77707911399983],
                    [-191.04127573699992, -62.99954607099994],
                    [-189.7030162379999, -63.20955266099992],
                    [-188.34578592999986, -63.40680224499988],
                    [-186.9703867209998, -63.591007626999954],
                    [-185.57771657199982, -63.761892816999875],
                    [-184.16876890899994, -63.91919482299994],
                    [-182.74463090299986, -64.06266544399995],
                    [-181.30648057699986, -64.19207303299993],
                    [-180.00459362069702, -64.29537994948276],
                    [-179.99999999999994, -64.29574446099997],
                    [-179.85558267399992, -64.30720421799987],
                    [-178.39328330799995, -64.40786554599998],
                    [-176.9210033859999, -64.49388501899995],
                    [-175.44023086899992, -64.5651135039999],
                    [-173.95251195399993, -64.62142598199995],
                    [-172.45944127599998, -64.66272262299992],
                    [-170.96265129199995, -64.6889296519999],
                    [-169.463801000004, -64.69999999980007],
                    [-169.90931124999997, -64.08885032299997],
                    [-170.335657999, -63.476397620999876],
                    [-170.74410737399998, -62.862730485999975],
                    [-171.135820098, -62.247929849999935],
                    [-171.51186191299996, -61.63206978299996],
                    [-171.87321284299998, -61.01521819299995],
                    [-172.220775419, -60.397437442999944],
                    [-172.55538200999996, -59.77878489499989],
                    [-172.8778013609999, -59.15931339899987],
                    [-173.18874442699996, -58.539071717999946],
                    [-173.48886960699994, -57.91810491099994],
                    [-173.7787874169999, -57.29645467899991],
                    [-174.0590646949999, -56.674159662999955],
                    [-174.33022838099998, -56.05125571999997],
                    [-174.592768913, -55.427776165999944],
                    [-174.84714329299993, -54.80375199599996],
                    [-175.09377785699996, -54.17921208299998],
                    [-175.33307077699996, -53.55418335199994],
                    [-175.56539432299994, -52.928690942999935],
                    [-175.79109692499998, -52.30275835499998],
                    [-176.01050502999996, -51.676407578999886],
                    [-176.22392480599999, -51.04965921399997],
                    [-176.43164367899993, -50.42253257799996],
                    [-176.63393174399997, -49.79504580499997],
                    [-176.83104304999995, -49.167215933999955],
                    [-177.02321677099994, -48.53905899199992],
                    [-177.21067828099996, -47.910590064999894],
                    [-177.39364013899998, -47.28182337299995],
                    [-177.57230298799996, -46.65277232299991],
                    [-177.74685638399998, -46.023449573999926],
                    [-177.9174795579999, -45.393867086999876],
                    [-178.08434211499997, -44.76403616999988],
                    [-178.2476046799999, -44.133967524999946],
                    [-178.40741949099993, -43.50367129099993],
                    [-178.56393094699993, -42.873157075999984],
                    [-178.71727611899996, -42.24243399499994],
                    [-178.86758521399994, -41.6115107039999],
                    [-179.01498201199996, -40.98039542299995],
                    [-179.15958426699993, -40.34909597199993],
                    [-179.3015040779999, -39.717619786999876],
                    [-179.44084823999995, -39.08597395299984],
                    [-179.5777185599999, -38.45416521699997],
                    [-179.71221215999998, -37.822200013999975],
                    [-179.844421754, -37.19008448499994],
                    [-179.97443590499995, -36.55782449199995],
                    [-179.99999999999986, -36.43142668794542],
                ]
            ],
        },
        {
            "zoneID": "16",
            "coordinates": [
                [
                    [-121.84229399998088, -10.447344999743109],
                    [-122.49308291899996, -10.4168581159999],
                    [-123.14374178999992, -10.385057009999912],
                    [-123.7942655839999, -10.35194605199996],
                    [-124.44464934699994, -10.317529784999863],
                    [-125.09488820099989, -10.281812930999934],
                    [-125.74497734599998, -10.24480038199988],
                    [-126.3949120659999, -10.206497205999938],
                    [-127.04468772699983, -10.166908642999886],
                    [-127.69429978199997, -10.126040101999877],
                    [-128.34374377199998, -10.08389716399995],
                    [-128.99301533099998, -10.040485574999934],
                    [-129.64211018299994, -9.995811249999974],
                    [-130.29102414999988, -9.94988027099987],
                    [-130.939753151, -9.902698881999981],
                    [-131.58829320399997, -9.854273489999912],
                    [-132.236640428, -9.80461066599986],
                    [-132.8847910469999, -9.753717138999946],
                    [-133.53274138799998, -9.701599797999904],
                    [-134.18048788799985, -9.64826568799998],
                    [-134.82802708999998, -9.593722010999898],
                    [-135.4753556479999, -9.537976122999964],
                    [-136.1224703289999, -9.48103553199985],
                    [-136.7693680129999, -9.422907897999835],
                    [-137.4160456929999, -9.36360103099986],
                    [-138.06250048199985, -9.303122886999972],
                    [-138.70872960599996, -9.241481570999895],
                    [-139.35473041399996, -9.178685330999883],
                    [-140.00050037199992, -9.114742557999932],
                    [-140.64603706799994, -9.049661786999877],
                    [-141.29133821199997, -8.983451688999935],
                    [-141.9364016369999, -8.916121075999968],
                    [-142.58122529899998, -8.847678894999888],
                    [-143.22580727899992, -8.778134227999885],
                    [-143.87014578399993, -8.707496288999948],
                    [-144.51423914599997, -8.635774425999955],
                    [-145.15808582399995, -8.562978112999929],
                    [-145.8016844029999, -8.489116953999883],
                    [-146.44503359699993, -8.41420067799993],
                    [-147.088132247, -8.338239138999938],
                    [-147.73097932099995, -8.261242311999979],
                    [-148.37357391899997, -8.183220293999966],
                    [-149.0159152649999, -8.104183299999875],
                    [-149.65800271499998, -8.02414166199992],
                    [-150.29983575099996, -7.943105827999943],
                    [-150.94141398599993, -7.861086359999945],
                    [-151.5827371599999, -7.778093928999965],
                    [-152.22380514199992, -7.694139319999977],
                    [-152.86461792699995, -7.609233421999875],
                    [-153.50517564199993, -7.523387231999948],
                    [-154.14547853699997, -7.436611852999874],
                    [-154.78552699099998, -7.348918488999914],
                    [-155.42532150999997, -7.2603184459998715],
                    [-156.06486272599997, -7.170823127999938],
                    [-156.70415139299993, -7.080444035999847],
                    [-157.34318839399992, -6.989192769999931],
                    [-157.98197473399998, -6.897081020999906],
                    [-158.62051154099998, -6.804120571999874],
                    [-159.25880006499997, -6.710323297999935],
                    [-159.89684167799996, -6.615701161999823],
                    [-160.53463787299998, -6.520266212999957],
                    [-161.17219025999998, -6.424030585999958],
                    [-161.80950057099994, -6.327006499999868],
                    [-162.44657065099992, -6.229206255999941],
                    [-163.08340246499992, -6.130642231999957],
                    [-163.71999809, -6.03132688799991],
                    [-164.35635971799996, -5.931272759999956],
                    [-164.99248965399997, -5.830492455999945],
                    [-165.6283903119999, -5.728998661999924],
                    [-166.26406421599992, -5.626804131999961],
                    [-166.89951399999995, -5.5239216909998845],
                    [-167.53474240199995, -5.42036423299993],
                    [-168.1697522659999, -5.316144718999851],
                    [-168.80454654099998, -5.211276172999931],
                    [-169.43912827599996, -5.105771685999912],
                    [-170.0735006209999, -4.999644408999927],
                    [-170.70766682399997, -4.892907551999883],
                    [-171.34163023099995, -4.785574385999894],
                    [-171.97539428199994, -4.677658238999925],
                    [-172.60896251, -4.569172493999872],
                    [-173.24233853999993, -4.460130587999913],
                    [-173.87552608699994, -4.350546011999882],
                    [-174.50852895399993, -4.240432306999878],
                    [-175.14135102699996, -4.129803063999873],
                    [-175.77399627999992, -4.018671920999964],
                    [-176.4064687659999, -3.9070525649999013],
                    [-177.03877261699998, -3.794958726999937],
                    [-177.67091204599993, -3.6824041809998675],
                    [-178.30289133899996, -3.569402744999934],
                    [-178.93471485599997, -3.455968276999954],
                    [-179.56638703, -3.342114672999969],
                    [-179.99999999999994, -3.2636631899999315],
                    [-180.19791236199976, -3.227855869999928],
                    [-180.82929541999994, -3.1132058409999104],
                    [-181.4605408379999, -2.998178590999885],
                    [-182.091653311, -2.8827881629999297],
                    [-182.72263759700002, -2.767048630999909],
                    [-183.35349851200004, -2.650974099999928],
                    [-183.98424092499988, -2.534578703999955],
                    [-184.6148697619999, -2.4178766069998687],
                    [-185.24538999996955, -2.3008820000006835],
                    [-185.16201719900002, -2.9362033069999143],
                    [-185.0785495060001, -3.571518401999924],
                    [-184.99496619600006, -4.2068259249999755],
                    [-184.91124642899987, -4.842124513999977],
                    [-184.8273692329999, -5.477412793999861],
                    [-184.74331348100006, -6.112689382999861],
                    [-184.65905786699986, -6.747952883999915],
                    [-184.574580889, -7.383201888999963],
                    [-184.489860825, -8.018434974999934],
                    [-184.4048757070001, -8.653650703999915],
                    [-184.31960330500004, -9.28884761899991],
                    [-184.23402109599985, -9.924024243999895],
                    [-184.14810624400002, -10.559179083999936],
                    [-184.06183557499998, -11.194310618999964],
                    [-183.97518555, -11.829417306999915],
                    [-183.88813223700004, -12.464497579999943],
                    [-183.80065128800004, -13.099549840999941],
                    [-183.7127179070001, -13.734572464999871],
                    [-183.62430681999996, -14.369563794999976],
                    [-183.5353922490001, -15.004522139999949],
                    [-183.4459478779999, -15.639445773999967],
                    [-183.35594681700005, -16.274332933999972],
                    [-183.26536157499987, -16.909181816999933],
                    [-183.17416401599993, -17.543990574999953],
                    [-183.0823253299999, -18.178757318999885],
                    [-182.98981598899996, -18.813480110999876],
                    [-182.89660570799992, -19.448156961999928],
                    [-182.80266340199984, -20.082785831999956],
                    [-182.70795714500002, -20.71736462399997],
                    [-182.61245411699983, -21.351891182999907],
                    [-182.51612056300002, -21.986363290999975],
                    [-182.41892173500003, -22.620778664999932],
                    [-182.32082184199993, -23.25513495299998],
                    [-182.22178399199993, -23.889429729999847],
                    [-182.1217701339999, -24.5236604939999],
                    [-182.02074099199987, -25.157824661999882],
                    [-181.91865600199992, -25.79191956699998],
                    [-181.81547323800007, -26.42594244899982],
                    [-181.71114934400012, -27.05989045599995],
                    [-181.605639451, -27.693760634999933],
                    [-181.49889709400006, -28.32754992499997],
                    [-181.39087412999993, -28.961255156999982],
                    [-181.28152063899995, -29.59487304099997],
                    [-181.170784828, -30.22840016599997],
                    [-181.05861292899985, -30.86183298599991],
                    [-180.94494908500002, -31.49516781899996],
                    [-180.829735234, -32.12840083599997],
                    [-180.71291098200004, -32.76152805199996],
                    [-180.59441347199996, -33.394545317999984],
                    [-180.47417724300004, -34.02744831399997],
                    [-180.35213407299975, -34.66023253299994],
                    [-180.22821282499996, -35.29289327599997],
                    [-180.10233927, -35.92542563699993],
                    [-180.00003736747794, -36.4312419300806],
                    [-179.99999999999986, -36.43142668794542],
                    [-179.97443590499995, -36.55782449199995],
                    [-179.844421754, -37.19008448499994],
                    [-179.71221215999998, -37.822200013999975],
                    [-179.5777185599999, -38.45416521699997],
                    [-179.44084823999995, -39.08597395299984],
                    [-179.3015040779999, -39.717619786999876],
                    [-179.15958426699993, -40.34909597199993],
                    [-179.01498201199996, -40.98039542299995],
                    [-178.86758521399994, -41.6115107039999],
                    [-178.71727611899996, -42.24243399499994],
                    [-178.56393094699993, -42.873157075999984],
                    [-178.40741949099993, -43.50367129099993],
                    [-178.2476046799999, -44.133967524999946],
                    [-178.08434211499997, -44.76403616999988],
                    [-177.9174795579999, -45.393867086999876],
                    [-177.74685638399998, -46.023449573999926],
                    [-177.57230298799996, -46.65277232299991],
                    [-177.39364013899998, -47.28182337299995],
                    [-177.21067828099996, -47.910590064999894],
                    [-177.02321677099994, -48.53905899199992],
                    [-176.83104304999995, -49.167215933999955],
                    [-176.63393174399997, -49.79504580499997],
                    [-176.43164367899993, -50.42253257799996],
                    [-176.22392480599999, -51.04965921399997],
                    [-176.01050502999996, -51.676407578999886],
                    [-175.79109692499998, -52.30275835499998],
                    [-175.56539432299994, -52.928690942999935],
                    [-175.33307077699996, -53.55418335199994],
                    [-175.09377785699996, -54.17921208299998],
                    [-174.84714329299993, -54.80375199599996],
                    [-174.592768913, -55.427776165999944],
                    [-174.33022838099998, -56.05125571999997],
                    [-174.0590646949999, -56.674159662999955],
                    [-173.7787874169999, -57.29645467899991],
                    [-173.48886960699994, -57.91810491099994],
                    [-173.18874442699996, -58.539071717999946],
                    [-172.8778013609999, -59.15931339899987],
                    [-172.55538200999996, -59.77878489499989],
                    [-172.220775419, -60.397437442999944],
                    [-171.87321284299998, -61.01521819299995],
                    [-171.51186191299996, -61.63206978299996],
                    [-171.135820098, -62.247929849999935],
                    [-170.74410737399998, -62.862730485999975],
                    [-170.335657999, -63.476397620999876],
                    [-169.90931124999997, -64.08885032299997],
                    [-169.463801000004, -64.69999999980007],
                    [-168.26272378193843, -64.32127736792802],
                    [-167.0946262831381, -63.93299072707009],
                    [-165.95881999877196, -63.53556272601941],
                    [-164.85456810406728, -63.12940070279001],
                    [-163.78109567211365, -62.714896464200024],
                    [-162.73759884910368, -62.292426217847776],
                    [-161.7232530269528, -61.862350630088656],
                    [-160.73722005083232, -61.42501499012474],
                    [-159.7786545370385, -60.98074946695715],
                    [-158.84670934478015, -60.52986943516305],
                    [-157.9405402859027, -60.07267585900178],
                    [-157.05931013792625, -59.609455722201744],
                    [-156.20219202282183, -59.1404824911869],
                    [-155.3683722172019, -58.66601659509479],
                    [-154.55705246120093, -58.18630593293608],
                    [-153.7674518258206, -57.70158637785454],
                    [-152.9988081760282, -57.21208229088239],
                    [-152.25037930303108, -56.71800702805086],
                    [-151.52144375321313, -56.219563443249],
                    [-150.8113014002196, -55.71694438303837],
                    [-150.11927379812346, -55.210333161972926],
                    [-149.44470434386514, -54.69990403617106],
                    [-148.78695828479854, -54.18582265079732],
                    [-148.14542259088995, -53.66824647409766],
                    [-147.51950571700758, -53.14732522284032],
                    [-146.9086372700469, -52.62320125221788],
                    [-146.31226761023092, -52.096009950049506],
                    [-145.72986738478596, -51.56588009499512],
                    [-145.1609270220821, -51.03293420707388],
                    [-144.6049561849899, -50.4972888828878],
                    [-144.06148320484297, -49.959055103804985],
                    [-143.5300544891615, -49.41833854094534],
                    [-143.01023392797663, -48.875239837874005],
                    [-142.5016022890071, -48.32985487380165],
                    [-142.00375661218885, -47.7822750259358],
                    [-141.5163096120993, -47.232587402943125],
                    [-141.03888908318226, -46.680875075961865],
                    [-140.5711373169667, -46.12721729407127],
                    [-140.11271052713448, -45.57168968506534],
                    [-139.6632782970778, -45.01436444718058],
                    [-139.22252303005683, -44.45531053522632],
                    [-138.79013942179841, -43.89459382392283],
                    [-138.365833950938, -43.332277275937656],
                    [-137.94932438290687, -42.768421091130165],
                    [-137.54033929016293, -42.203082852845625],
                    [-137.138617594913, -41.63631765896639],
                    [-136.74390811913207, -41.068178257010345],
                    [-136.35596916522223, -40.498715160987786],
                    [-135.9745681001687, -39.92797676600742],
                    [-135.59948096588693, -39.356009457185166],
                    [-135.2304920970662, -38.78285771290649],
                    [-134.86739376475526, -38.20856419798952],
                    [-134.50998582484294, -37.63316985995044],
                    [-134.15807539103315, -37.0567140089222],
                    [-133.8114765118657, -36.47923440482191],
                    [-133.47000986903004, -35.900767329774226],
                    [-133.1335024900738, -35.32134766388168],
                    [-132.8017874642099, -34.74100895389995],
                    [-132.47470368101494, -34.15978347711274],
                    [-132.1520955732259, -33.57770230485869],
                    [-131.83381287778099, -32.994795358759404],
                    [-131.51971039885797, -32.41109146999759],
                    [-131.2096477907565, -31.82661842524982],
                    [-130.9034893427795, -31.241403026814055],
                    [-130.60110377615905, -30.65547112609562],
                    [-130.30236405517832, -30.068847683986576],
                    [-130.0071471938939, -29.481556798103725],
                    [-129.71533408614948, -28.893621757868857],
                    [-129.42680933479147, -28.305065068049146],
                    [-129.1414610838309, -27.715908500038495],
                    [-128.85918087324916, -27.126173114948585],
                    [-128.57986348415608, -26.535879301993987],
                    [-128.30340679709286, -25.94504680978116],
                    [-128.0297116590828, -25.353694773197446],
                    [-127.7586817510309, -24.76184174814898],
                    [-127.4902234650703, -24.1695057298528],
                    [-127.22424578290821, -23.57670418697427],
                    [-126.96066016496724, -22.98345408207001],
                    [-126.69938043587916, -22.38977189422866],
                    [-126.44032268212294, -21.795673645161116],
                    [-126.18340515081354, -21.20117491904358],
                    [-125.92854815103806, -20.606290881009613],
                    [-125.67567396409095, -20.01103630084225],
                    [-125.42470674815883, -19.41542556901726],
                    [-125.17557245695161, -18.819472714796973],
                    [-124.92819875583393, -18.22319142407241],
                    [-124.68251493805684, -17.626595058007695],
                    [-124.43845185518438, -17.02969666613393],
                    [-124.19594183512373, -16.43250900114458],
                    [-123.95491861395135, -15.835044536837927],
                    [-123.71531726913821, -15.237315480862321],
                    [-123.47707414717689, -14.639333785212841],
                    [-123.24012680480416, -14.041111168022837],
                    [-123.00441394122504, -13.442659113913464],
                    [-122.7698753429363, -12.843988896835015],
                    [-122.53645181809839, -12.24511158711482],
                    [-122.30408514800553, -11.646038062903074],
                    [-122.0727180249084, -11.046779024215994],
                    [-121.84229399998088, -10.447344999743109],
                ]
            ],
        },
        {
            "zoneID": "17",
            "coordinates": [
                [
                    [-143.47849000000667, 50.103200999963235],
                    [-143.47849227566348, 50.10320183475096],
                    [-144.34871063827157, 50.421156470979554],
                    [-145.23057114002734, 50.73253421988778],
                    [-146.1241053988014, 51.03717247102844],
                    [-147.02933141721277, 51.33490795394442],
                    [-147.9462502490606, 51.62557613319433],
                    [-148.87484495096987, 51.90901145772108],
                    [-149.81507952818922, 52.185047635994636],
                    [-150.76689790105823, 52.453517926976986],
                    [-151.73022289877537, 52.714255463156576],
                    [-152.70495528526573, 52.96709358293856],
                    [-153.69097282700542, 53.211866195779976],
                    [-154.68812942888044, 53.44840815997611],
                    [-155.69625433114493, 53.67655568680112],
                    [-156.71515138586298, 53.89614676075786],
                    [-157.7445984406667, 54.10702157501271],
                    [-158.78434681805797, 54.3090229882572],
                    [-159.83412091720044, 54.50199699022107],
                    [-160.89361795013608, 54.68579317999564],
                    [-161.9625078239032, 54.86026525773519],
                    [-163.04043317119263, 55.02527151578573],
                    [-164.12700954728527, 55.180675334280124],
                    [-165.2218258012605, 55.326345676878645],
                    [-166.32444462776692, 55.462157587902425],
                    [-167.4344032976778, 55.587992669831635],
                    [-168.55121457464423, 55.70373955693054],
                    [-169.6743678316715, 55.809294372127624],
                    [-170.80333033276085, 55.90456116116451],
                    [-171.9375487120011, 55.98945230409407],
                    [-173.07645061778945, 56.06388889776986],
                    [-174.2194465276891, 56.127801111826216],
                    [-175.36593170296138, 56.18112849574368],
                    [-176.51528829422128, 56.22382026487969],
                    [-177.6668875577008, 56.25583553321957],
                    [-178.82009217971893, 56.277143502231695],
                    [-179.97425867339476, 56.28772361102841],
                    [-180, 56.287720087958064],
                    [-180.00000000011622, 56.287720087958064],
                    [-181.12873983711677, 56.287565630189704],
                    [-182.28288725987807, 56.276669713141644],
                    [-183.43605381502985, 56.25504639375612],
                    [-184.58759616310556, 56.222716536301846],
                    [-185.7368772068018, 56.17971123688034],
                    [-186.88326849073167, 56.12607167710689],
                    [-188.0261525196206, 56.06184892904116],
                    [-189.16492497481357, 55.98710372225963],
                    [-190.29899681034183, 55.90190615944681],
                    [-191.42779620715095, 55.806335406145195],
                    [-192.55077038494642, 55.700479333160274],
                    [-193.6673872400322, 55.58443413211927],
                    [-194.77713681102216, 55.45830390923453],
                    [-195.8795325717374, 55.3222002422209],
                    [-196.97411252808814, 55.176241726973444],
                    [-198.06044013318072, 55.02055350777249],
                    [-199.13810501489067, 54.855266791130816],
                    [-200.20672352309361, 54.68051835296802],
                    [-201.26593908779273, 54.496450042906815],
                    [-202.31542242175357, 54.303208290972464],
                    [-203.35487153828714, 54.10094360915002],
                    [-204.3840116338028, 53.889810107171286],
                    [-205.40259481783454, 53.66996501118342],
                    [-206.41039970866717, 53.44156819806051],
                    [-207.40723091779506, 53.20478174411005],
                    [-208.3929184204822, 52.95976948307191],
                    [-209.36731683367734, 52.70669658913852],
                    [-210.33030461573748, 52.4457291760325],
                    [-211.2817831918284, 52.17703391513015],
                    [-212.221676026897, 51.900777676877794],
                    [-213.149927645047, 51.617127191969644],
                    [-214.06650262926917, 51.326248734842636],
                    [-214.97138457711944, 51.028307830171],
                    [-215.86457505909323, 50.72346898036568],
                    [-216.74609256032215, 50.41189541497732],
                    [-217.6159714236436, 50.09374886189187],
                    [-218.47426080803743, 49.76918933875618],
                    [-219.32102365472468, 49.43837496686399],
                    [-220.15633567902105, 49.10146180070842],
                    [-220.98028438109478, 48.75860367984228],
                    [-221.79296808992663, 48.40995209835154],
                    [-222.5944950394331, 48.05565608520942],
                    [-223.3849824729433, 47.695862113963415],
                    [-224.16455579659106, 47.330714010201234],
                    [-224.93334775551267, 46.960352890113086],
                    [-225.6914976620911, 46.58491710015551],
                    [-226.43915065696862, 46.20454217210835],
                    [-227.17645701268503, 45.81936079505948],
                    [-227.903571477072, 45.42950279029196],
                    [-228.62065265183477, 45.03509509987293],
                    [-229.3278624198822, 44.636261781893666],
                    [-230.02536540229764, 44.2331240171323],
                    [-230.7133284499011, 43.82580011891059],
                    [-231.39192018278158, 43.414405550819424],
                    [-232.06131055006787, 42.999052954156696],
                    [-232.72167043492354, 42.57985217090061],
                    [-233.37317128092621, 42.156910284973094],
                    [-234.01598475711694, 41.73033165182085],
                    [-234.65028244724598, 41.30021794812683],
                    [-235.27623556450237, 40.86666821018264],
                    [-235.89401469973168, 40.42977888392056],
                    [-236.50378958364342, 39.98964387092491],
                    [-237.10572888102692, 39.54635458517265],
                    [-237.69999917090317, 39.1000006259564],
                    [-237.69999999977526, 39.100000000149976],
                    [-236.97175211683336, 38.80030465981639],
                    [-236.24964935081843, 38.49612719930553],
                    [-235.53366241084575, 38.187553621201346],
                    [-234.82375789080697, 37.87466919411412],
                    [-234.11989849905834, 37.55755841014627],
                    [-233.422043273939, 37.236304940360355],
                    [-232.7301478042886, 36.91099159834175],
                    [-232.04416443467053, 36.58170030036422],
                    [-231.36404247434015, 36.24851203610086],
                    [-230.68972839467477, 35.91150684013451],
                    [-230.02116602134728, 35.57076376791696],
                    [-229.35829672285777, 35.2263608719785],
                    [-228.70105958761494, 34.8783751830843],
                    [-228.04939160082085, 34.526882696939595],
                    [-227.40322780920798, 34.17195835804603],
                    [-226.76250148062942, 33.8136760508047],
                    [-226.1271442587003, 33.452108589419936],
                    [-225.49708630889307, 33.08732771435126],
                    [-224.87225645998384, 32.71940408636476],
                    [-224.2525823338037, 32.34840728623362],
                    [-223.6379904763395, 31.974405812289206],
                    [-223.02840647628884, 31.597467086168763],
                    [-222.4237550789669, 31.2176574532146],
                    [-221.8239602952656, 30.83504218587433],
                    [-221.22894550406576, 30.449685495894528],
                    [-220.63863354770007, 30.061650535371996],
                    [-220.05294682431813, 29.670999410047557],
                    [-219.4718073709567, 29.27779318620327],
                    [-218.89513694560694, 28.882091904159154],
                    [-218.32285710173707, 28.483954588067093],
                    [-217.75488925696683, 28.083439259207182],
                    [-217.1911547597921, 27.680602948333785],
                    [-216.6315749506119, 27.275501713166932],
                    [-216.07607121670654, 26.86819064784015],
                    [-215.52456504482052, 26.45872390229323],
                    [-214.97697807034058, 26.04715469616616],
                    [-214.43323212098278, 25.63353533514396],
                    [-213.8932492568238, 25.217917226249483],
                    [-213.3569518097892, 24.800350898187844],
                    [-212.8242624138896, 24.380886012189933],
                    [-212.29510403980984, 23.95957138715505],
                    [-211.76940002089714, 23.53645500859585],
                    [-211.24707407785334, 23.11158405388079],
                    [-210.72805034187502, 22.68500490517613],
                    [-210.21225337364712, 22.256763168292878],
                    [-209.6996081807865, 21.826903691376117],
                    [-209.19004023308509, 21.39547058205096],
                    [-208.68347547480678, 20.962507224864396],
                    [-208.179840336881, 20.528056301228673],
                    [-207.6790617437021, 20.092159804165874],
                    [-207.18106712197508, 19.654859058049738],
                    [-206.68578440511305, 19.2161947361991],
                    [-206.19314203693767, 18.776206877972697],
                    [-205.70306897497665, 18.33493490616047],
                    [-205.21549469006374, 17.892417646078798],
                    [-204.73034916679046, 17.448693338213673],
                    [-204.24756290105344, 17.003799662462256],
                    [-203.76706689596014, 16.557773748080137],
                    [-203.28879266262587, 16.110652195321222],
                    [-202.81267220882782, 15.662471089384667],
                    [-202.3386380367579, 15.213266019205776],
                    [-201.8666231367243, 14.76307209310147],
                    [-201.3965609758542, 14.311923952064433],
                    [-200.92838549479742, 13.85985579200576],
                    [-200.46203109203063, 13.406901372750326],
                    [-199.99743262205888, 12.953094039279279],
                    [-199.5345253759226, 12.498466735175953],
                    [-199.0732450769493, 12.043052018018102],
                    [-198.6135278680083, 11.586882073224615],
                    [-198.1553102958668, 11.129988732546963],
                    [-197.69852930169287, 10.67240348686596],
                    [-197.2431222087615, 10.214157501134025],
                    [-196.78902670495924, 9.75528162937178],
                    [-196.33618083518837, 9.295806430111384],
                    [-195.88452298007562, 8.835762179140659],
                    [-195.43399184787256, 8.375178885248715],
                    [-194.9845264565156, 7.914086302470366],
                    [-194.53606611887807, 7.452513946230852],
                    [-194.08855042777995, 6.990491107939306],
                    [-193.64191924108994, 6.5280468644856455],
                    [-193.19611266678316, 6.065210096884357],
                    [-192.75107104474648, 5.60200950126881],
                    [-192.30673493273548, 5.138473602537317],
                    [-191.86304508972955, 4.67463076834764],
                    [-191.41994245983838, 4.210509223311021],
                    [-190.97736815525798, 3.7461370590391425],
                    [-190.5352634411774, 3.2815422524864744],
                    [-190.09356971768418, 2.816752673248743],
                    [-189.65222850367138, 2.351796101804439],
                    [-189.21118142084282, 1.8867002390625203],
                    [-188.77037017517142, 1.4214927211562554],
                    [-188.32973654320344, 0.9562011311386982],
                    [-187.8892223511652, 0.4908530141776737],
                    [-187.44876946082098, 0.02547588705135695],
                    [-187.00831975187745, -0.4399027448578181],
                    [-186.56781510504135, -0.905255378966217],
                    [-186.12719738492564, -1.3705544999450012],
                    [-185.68640842200554, -1.8357725664255327],
                    [-185.24538999996955, -2.3008820000006835],
                    [-184.93918285800004, -1.7379219919998832],
                    [-184.63315825, -1.1749124069999084],
                    [-184.32725696899976, -0.6118693259999759],
                    [-184.02141989099988, -0.04880880999985493],
                    [-183.71558793399979, 0.5142530970000507],
                    [-183.40970201899995, 1.0773003510000194],
                    [-183.10370303199997, 1.6403168950001827],
                    [-183.04265938707834, 1.7525603729023942],
                    [-182.49112896900007, 2.7661935080001854],
                    [-182.1844351369999, 3.3290213040001504],
                    [-181.87739063700002, 3.8917538210001226],
                    [-181.56993559300003, 4.454374768000093],
                    [-181.26200985299997, 5.016867772000069],
                    [-180.95355295600004, 5.579216364000047],
                    [-180.64450408899995, 6.141403965000052],
                    [-180.33480204600002, 6.703413877000173],
                    [-180.024385186, 7.265229267000052],
                    [-179.99999999999994, 7.309236621000082],
                    [-179.7131913949999, 7.826833155000031],
                    [-179.40115803999998, 8.388208402000146],
                    [-179.0882219279999, 8.949337693000189],
                    [-178.77431926199995, 9.51020352800009],
                    [-178.45938559599995, 10.070788204000053],
                    [-178.14335579499993, 10.631073803999982],
                    [-177.826163983, 11.191042179000078],
                    [-177.50774350199998, 11.75067493600011],
                    [-177.18802686299992, 12.309953422000035],
                    [-176.86694569599993, 12.868858707000072],
                    [-176.54443070599999, 13.427371571000037],
                    [-176.2204116199999, 13.985472481999977],
                    [-175.89481713499998, 14.543141587999969],
                    [-175.56757487099995, 15.100358689000132],
                    [-175.23861131399997, 15.657103229000029],
                    [-174.90785175999997, 16.21335427100007],
                    [-174.57522026599992, 16.769090480000102],
                    [-174.24063958799994, 17.324290106000092],
                    [-173.90403112699997, 17.87893096000016],
                    [-173.56531486399996, 18.43299039500016],
                    [-173.224409307, 18.98644528400007],
                    [-172.88123142099994, 19.539272001000086],
                    [-172.53569657099993, 20.091446393000183],
                    [-172.187718453, 20.64294376000015],
                    [-171.83720902799996, 21.19373882700006],
                    [-171.48407845299994, 21.743805725000072],
                    [-171.12823501399998, 22.29311795600006],
                    [-170.76958504899991, 22.841648374999977],
                    [-170.40803287899996, 23.38936915400012],
                    [-170.04348073199995, 23.936251756000047],
                    [-169.67582866299995, 24.482266906000177],
                    [-169.30497447799993, 25.02738455900004],
                    [-168.93081365199998, 25.57157386199998],
                    [-168.55323924899994, 26.114803129999984],
                    [-168.17214183299993, 26.657039803000032],
                    [-167.78740938399994, 27.198250410000128],
                    [-167.39892721399997, 27.738400535000153],
                    [-167.00657786799994, 28.27745477700006],
                    [-166.61024104299995, 28.815376703000027],
                    [-166.209793486, 29.35212881500007],
                    [-165.80510890399995, 29.88767249800003],
                    [-165.3960578669999, 30.421967977000065],
                    [-164.98250770899998, 30.954974270000037],
                    [-164.56432242799994, 31.486649138000075],
                    [-164.14136259, 32.01694903300012],
                    [-163.71348522199997, 32.545829045000175],
                    [-163.28054371299996, 33.07324284599997],
                    [-162.8423877129999, 33.59914263400003],
                    [-162.39886302699992, 34.123479069000155],
                    [-161.94981151199994, 34.646201218000044],
                    [-161.49507097799992, 35.16725648200003],
                    [-161.0344750859999, 35.686590537000086],
                    [-160.56785324299994, 36.20414726000001],
                    [-160.0950305089999, 36.71986865700018],
                    [-159.61582749999994, 37.233694790000186],
                    [-159.13006029299993, 37.74556370200014],
                    [-158.63754033899997, 38.255411331999994],
                    [-158.13807437699992, 38.76317143599999],
                    [-157.63146435899995, 39.26877550100005],
                    [-157.11750737199998, 39.77215265800004],
                    [-156.5959955779999, 40.27322958600007],
                    [-156.0667161599999, 40.77193042700003],
                    [-155.52945127099994, 41.268176680000124],
                    [-154.98397800699996, 41.76188710800011],
                    [-154.43006838399992, 42.25297763400016],
                    [-153.86748933699994, 42.7413612360001],
                    [-153.29600273099993, 43.226947841000026],
                    [-152.71536539499996, 43.709644213000104],
                    [-152.12532917999997, 44.18935384600013],
                    [-151.79622737084554, 44.45091894928328],
                    [-150.1818549637228, 45.694282784862196],
                    [-149.6660634959999, 46.07627387200006],
                    [-149.0251435639999, 46.53947960000005],
                    [-148.37323785999996, 46.999044346999995],
                    [-147.71006738699995, 47.454845440000156],
                    [-147.03534976699993, 47.90675599700006],
                    [-146.34879963899994, 48.35464481500003],
                    [-145.65012911999992, 48.79837624900006],
                    [-144.9390483279999, 49.237810110000055],
                    [-144.21526596799993, 49.67280155800012],
                    [-143.47849000000667, 50.103200999963235],
                ]
            ],
        },
        {
            "zoneID": "18",
            "coordinates": [
                [
                    [180.0, 82.777323184097611],
                    [179.999999997194777, 81.999999999533429],
                    [179.999999999512511, 80.000000000404611],
                    [180.0, 78.000000000137504],
                    [180.0, 76.0],
                    [180.0, 74.515482380788228],
                    [179.999999999533657, 73.999999999785359],
                    [179.999999998660769, 71.999999999731358],
                    [180.0, 69.999999999496026],
                    [179.99999999952729, 67.999999999963279],
                    [180.0, 67.400349681905141],
                    [180.0, 66.000000000000114],
                    [180.0, 63.999999999769557],
                    [179.999999999142346, 62.000000000487944],
                    [179.999999999738293, 59.999999999926843],
                    [179.999999999632792, 58.000000000070941],
                    [179.999999999767624, 56.287720087958064],
                    [178.871260162883345, 56.287565630189704],
                    [177.717112740122047, 56.276669713141644],
                    [176.563946184970291, 56.255046393756118],
                    [175.412403836894555, 56.222716536301846],
                    [174.263122793198249, 56.179711236880337],
                    [173.116731509268448, 56.126071677106893],
                    [171.973847480379504, 56.061848929041162],
                    [170.835075025186484, 55.987103722259633],
                    [169.701003189658309, 55.90190615944681],
                    [168.572203792849109, 55.806335406145195],
                    [167.449229615053696, 55.700479333160274],
                    [166.332612759967901, 55.58443413211927],
                    [165.222863188977954, 55.45830390923453],
                    [164.120467428262714, 55.322200242220902],
                    [163.025887471911915, 55.176241726973444],
                    [161.939559866819422, 55.02055350777249],
                    [160.861894985109416, 54.855266791130816],
                    [159.793276476906499, 54.680518352968022],
                    [158.734060912207383, 54.496450042906815],
                    [157.68457757824649, 54.303208290972464],
                    [156.645128461712943, 54.100943609150022],
                    [155.615988366197257, 53.889810107171286],
                    [154.597405182165517, 53.669965011183422],
                    [153.589600291332886, 53.441568198060509],
                    [152.592769082204995, 53.204781744110051],
                    [151.607081579517853, 52.959769483071909],
                    [150.632683166322749, 52.706696589138517],
                    [149.669695384262582, 52.445729176032501],
                    [148.718216808171746, 52.177033915130153],
                    [147.778323973103056, 51.900777676877794],
                    [146.850072354953113, 51.617127191969644],
                    [145.933497370730947, 51.326248734842636],
                    [145.028615422880648, 51.028307830171002],
                    [144.135424940906887, 50.723468980365681],
                    [143.25390743967796, 50.411895414977323],
                    [142.384028576356513, 50.093748861891868],
                    [141.525739191962657, 49.769189338756178],
                    [140.678976345275373, 49.438374966863989],
                    [139.843664320979087, 49.101461800708421],
                    [139.019715618905366, 48.758603679842281],
                    [138.207031910073511, 48.409952098351539],
                    [137.405504960566986, 48.055656085209421],
                    [136.615017527056807, 47.695862113963415],
                    [135.835444203408997, 47.330714010201234],
                    [135.066652244487386, 46.960352890113086],
                    [134.308502337908976, 46.584917100155508],
                    [133.560849343031464, 46.204542172108347],
                    [132.823542987315022, 45.819360795059481],
                    [132.096428522928136, 45.429502790291963],
                    [131.379347348165311, 45.035095099872933],
                    [130.672137580117919, 44.636261781893666],
                    [129.974634597702448, 44.233124017132297],
                    [129.286671550098959, 43.825800118910593],
                    [128.608079817218481, 43.414405550819424],
                    [127.938689449932212, 42.999052954156696],
                    [127.278329565076547, 42.579852170900608],
                    [126.626828719073842, 42.156910284973094],
                    [125.984015242883174, 41.730331651820848],
                    [125.3497175527541, 41.300217948126829],
                    [124.723764435497742, 40.866668210182638],
                    [124.105985300268458, 40.429778883920562],
                    [123.496210416356689, 39.989643870924908],
                    [122.894271118973165, 39.546354585172651],
                    [122.300000829096916, 39.100000625956397],
                    [122.300000680960466, 39.100000696523807],
                    [122.300000522423147, 39.100000753250697],
                    [122.300000354946974, 39.100000797089422],
                    [122.30000018139765, 39.100000827289762],
                    [122.300000004744788, 39.100000843334897],
                    [122.2999998280103, 39.10000084495033],
                    [122.299999654218823, 39.100000832108492],
                    [122.299999484011892, 39.100000803522846],
                    [121.930596310092142, 39.673636575442515],
                    [121.555012335956576, 40.246083258747831],
                    [121.173028428474481, 40.817295146798301],
                    [120.784416412466499, 41.38722539648461],
                    [120.388939185633717, 41.955825114919151],
                    [119.986350321301074, 42.523043249402235],
                    [119.576393635794261, 43.088826473398967],
                    [119.158802743644856, 43.653119057584604],
                    [118.73330060436524, 44.215862741017872],
                    [118.299599037606981, 44.776996590017575],
                    [117.85739822640528, 45.336456849870331],
                    [117.406386203002171, 45.894176787310357],
                    [116.946238317396364, 46.450086526354767],
                    [116.476616684562487, 47.004112871141899],
                    [115.997169619529132, 47.556179116190378],
                    [115.507531054222227, 48.106204852686972],
                    [115.007319943441757, 48.65410575686218],
                    [114.496139650239456, 49.199793368117355],
                    [113.973577333621392, 49.743174852285733],
                    [113.439203318285877, 50.284152757704931],
                    [112.892570469655539, 50.822624746919473],
                    [112.333213552715279, 51.358483322614802],
                    [111.760648620529594, 51.891615532362039],
                    [111.174372392868179, 52.421902658835052],
                    [110.573861665339621, 52.949219894262228],
                    [109.95857274201029, 53.473435997620641],
                    [109.327940903343631, 53.994412929470911],
                    [108.681379930426715, 54.512005476045715],
                    [108.018281681316978, 55.026060851660134],
                    [107.338015757193318, 55.536418277927567],
                    [106.639929259606049, 56.042908556522434],
                    [105.923346664553264, 56.545353610841119],
                    [105.187569843295194, 57.043566020033381],
                    [104.431878251691273, 57.537348535647993],
                    [103.655529318301262, 58.026493578216332],
                    [102.85775907029597, 58.51078273034949],
                    [102.037783036363805, 58.989986212566635],
                    [101.194797464952387, 59.463862357555229],
                    [100.327980913092063, 59.932157078250611],
                    [99.436496250977825, 60.394603345395353],
                    [98.519493158215937, 60.850920670278867],
                    [97.576111142258981, 61.300814603000163],
                    [96.605483180376041, 61.743976261731689],
                    [95.60674003086217, 62.180081897119578],
                    [94.579015293583268, 62.608792499041726],
                    [93.521451296576174, 63.029753479203919],
                    [92.433205871401015, 63.442594416824136],
                    [91.313460095224968, 63.846928917141497],
                    [90.161427047833058, 64.242354570357293],
                    [88.976361640993389, 64.628453065300107],
                    [87.757571556328969, 65.004790450865585],
                    [86.504429289800782, 65.370917599598386],
                    [85.216385296752208, 65.726370872769792],
                    [83.89298218218579, 66.070673039979738],
                    [82.533869839294994, 66.403334460956444],
                    [81.138821393072533, 66.723854562965528],
                    [79.707749748146966, 67.031723647563012],
                    [78.240724465698463, 67.326425025865149],
                    [76.737988658951167, 67.607437523417161],
                    [75.199975477369435, 67.874238340166812],
                    [73.627323731679496, 68.126306281328709],
                    [72.020892122541284, 68.363125341172463],
                    [70.38177149788936, 68.584188622274553],
                    [68.711294531436181, 68.789002545219887],
                    [67.011042209264872, 68.977091301147084],
                    [65.282846534334283, 69.148001490029912],
                    [63.528788910390915, 69.30130684634338],
                    [61.751193783183112, 69.436612967245026],
                    [59.952617212227551, 69.553561940012457],
                    [58.135830244864451, 69.651836749610482],
                    [57.03657577749874, 69.701793278833179],
                    [57.03657577749874, 69.707249403619812],
                    [57.035189051276177, 69.699495455506849],
                    [56.303797145996668, 69.731165351120239],
                    [54.4596487394723, 69.791324288214525],
                    [52.60665136764942, 69.832141761540242],
                    [50.748172132888044, 69.853500042816449],
                    [48.887641311479911, 69.855337146275872],
                    [47.02851297977935, 69.837647727059505],
                    [45.17422493566437, 69.800483160905173],
                    [43.328159104479539, 69.743950796503555],
                    [41.493603529322741, 69.668212428000857],
                    [39.673717022394726, 69.573482006644383],
                    [37.87149735313119, 69.460022702049173],
                    [36.089753726062384, 69.328143368136068],
                    [34.331084068259713, 69.178194552524531],
                    [32.597857418990429, 69.010564142593466],
                    [30.892201533638456, 68.825672771149641],
                    [29.215995590337627, 68.623969095848622],
                    [27.570867706792058, 68.405925068019712],
                    [25.958196873575105, 68.172031271802837],
                    [24.379118777836936, 67.922792429877063],
                    [22.834534916716052, 67.658723142394365],
                    [21.325124427869696, 67.38034391232128],
                    [19.851357988544009, 67.08817749429636],
                    [18.413513214928514, 66.782745599741361],
                    [17.011691031395458, 66.464565963651353],
                    [15.645832515258178, 66.134149771985392],
                    [14.315735804231849, 65.791999462022659],
                    [13.021072734842392, 65.438606852169471],
                    [11.761404908196369, 65.074451607037929],
                    [10.536200672583618, 64.700000529101317],
                    [10.536200428233258, 64.700000615866713],
                    [10.536200161709758, 64.700000689225476],
                    [10.536199874899921, 64.700000750791162],
                    [10.53619957271161, 64.700000799510747],
                    [10.536198223419717, 64.700000979283232],
                    [10.536198182886608, 64.700000984683527],
                    [10.054275878055421, 65.307540949353609],
                    [9.549630251477538, 65.913470803567691],
                    [9.020564911578504, 66.517664432471236],
                    [8.465218222716942, 67.119983881048483],
                    [7.881544898993241, 67.720276738021482],
                    [7.267294257636877, 68.318374267453578],
                    [6.619985585430641, 68.914089258356171],
                    [5.936880247701083, 69.507213531752825],
                    [5.214950104193917, 70.097515068270752],
                    [4.450841772286537, 70.684734670202772],
                    [3.640836265215398, 71.268582094280987],
                    [2.780803480284249, 71.848731545297255],
                    [1.866151087095147, 72.424816428661472],
                    [0.891767383888407, 72.996423232546192],
                    [-0.1480421087428, 73.563084387097263],
                    [-1.25962434205627, 74.124269925487852],
                    [-2.450054259483636, 74.679377760275656],
                    [-3.727214958276591, 75.227722353736112],
                    [-5.099880281253547, 75.768521551712183],
                    [-6.577795864447751, 76.300881363299936],
                    [-8.171752376477173, 76.823778468358398],
                    [-9.893641078920552, 77.336040319610333],
                    [-11.756477147452586, 77.836322825128605],
                    [-13.774369511180169, 78.323085838929273],
                    [-15.962407688406927, 78.794567047184444],
                    [-18.336425742898882, 79.248755465012152],
                    [-20.912592437313947, 79.683366606312291],
                    [-23.706766705354312, 80.09582260697448],
                    [-26.733553539895468, 80.483242152095158],
                    [-30.005004405856766, 80.84244686439763],
                    [-33.528939507290147, 81.169992500141404],
                    [-37.306938431940978, 81.462234336073095],
                    [-41.332158418046788, 81.715435268069484],
                    [-45.587288008522137, 81.925921363712007],
                    [-50.043091236127907, 82.090281692444933],
                    [-54.65807340944508, 82.205597649041351],
                    [-59.37971767814355, 82.269674012866915],
                    [-64.14745132914112, 82.281234562964187],
                    [-68.897049763280165, 82.240044579810501],
                    [-73.565737759252613, 82.146934086691999],
                    [-78.097010698712552, 82.003716653113543],
                    [-82.444294907259007, 81.813021554078091],
                    [-86.572945935201119, 81.578073348353769],
                    [-90.460558761675827, 81.302457684132946],
                    [-94.095937833197809, 80.989905957498365],
                    [-94.999999999671502, 80.897452817513226],
                    [-97.477246027850185, 80.64411938412934],
                    [-100.609834958794352, 80.268640341547041],
                    [-103.504132394602948, 79.866769201779846],
                    [-106.173808039646531, 79.44151933085584],
                    [-108.634308121032973, 78.995600956098031],
                    [-110.901761303187413, 78.531424962507856],
                    [-112.992210916794704, 78.051119181005731],
                    [-114.921110329462863, 77.556551532260698],
                    [-116.70301776360526, 77.049356125709323],
                    [-118.351434895675084, 76.530959725316904],
                    [-119.878744588478071, 76.00260707275504],
                    [-121.296213849454773, 75.465384204627469],
                    [-122.614037439101367, 74.920239421327267],
                    [-123.841404816062663, 74.368001819328185],
                    [-124.986578730888482, 73.809397484687508],
                    [-126.056977746091604, 73.245063532372342],
                    [-127.059257816183504, 72.675560205224599],
                    [-127.999390043167296, 72.101381278565214],
                    [-128.882733004354179, 71.522962978952876],
                    [-129.714098940312056, 70.940691623223699],
                    [-130.49781361176349, 70.354910169468269],
                    [-131.237770013867987, 69.765923825888876],
                    [-131.93747627529109, 69.174004865444942],
                    [-132.600098223684654, 68.579396761733676],
                    [-133.228497075596465, 67.982317748290995],
                    [-133.825262785746418, 67.382963887340793],
                    [-134.392743496595529, 66.781511714730527],
                    [-134.933071549241788, 66.17812054120327],
                    [-135.448186446109162, 65.572934434725482],
                    [-135.939855146192087, 64.966083952820327],
                    [-136.409689985939735, 64.357687646936824],
                    [-136.859164548246042, 63.747853378270406],
                    [-137.289627714692358, 63.13667946906213],
                    [-137.702316109765263, 62.524255710464956],
                    [-138.098365166527287, 61.910664249718877],
                    [-138.47881894119223, 61.295980370301947],
                    [-138.844638868481013, 60.680273183110842],
                    [-139.196711550176985, 60.063606233019811],
                    [-139.535855722097097, 59.446038041258191],
                    [-139.862828462461096, 58.827622584265441],
                    [-140.178330769363754, 58.208409722062868],
                    [-140.483012549900138, 57.588445573309116],
                    [-140.777477101599459, 56.967772863312291],
                    [-141.06228514616447, 56.346431219401836],
                    [-141.337958453612544, 55.724457449370391],
                    [-141.604983121265946, 55.101885781684473],
                    [-141.863812525970957, 54.478748089154919],
                    [-142.114869996959783, 53.855074086177694],
                    [-142.358551237240476, 53.230891503300882],
                    [-142.595226518110849, 52.60622625466516],
                    [-142.825242669059492, 51.981102580338018],
                    [-143.048924895845914, 51.355543178468338],
                    [-143.266578422409395, 50.729569328791911],
                    [-143.478489206028257, 50.103202076801608],
                    [-143.478489353473719, 50.103202196258394],
                    [-143.478489505366611, 50.103202294032258],
                    [-143.478489553674592, 50.103202319214802],
                    [-143.478489671318584, 50.103202380541177],
                    [-143.478489848490426, 50.103202454304778],
                    [-143.478490033850164, 50.103202514060911],
                    [-143.478490241105874, 50.103202508217578],
                    [-143.478490449831725, 50.103202487444491],
                    [-143.478490656456756, 50.103202452096923],
                    [-143.478490857445479, 50.103202402779573],
                    [-143.478492275663484, 50.103201834750962],
                    [-144.348710638271569, 50.421156470979554],
                    [-145.230571140027337, 50.732534219887782],
                    [-146.12410539880139, 51.037172471028441],
                    [-147.029331417212774, 51.334907953944423],
                    [-147.946250249060597, 51.625576133194329],
                    [-148.874844950969873, 51.909011457721078],
                    [-149.815079528189216, 52.185047635994636],
                    [-150.766897901058229, 52.453517926976986],
                    [-151.730222898775367, 52.714255463156576],
                    [-152.704955285265726, 52.96709358293856],
                    [-153.690972827005425, 53.211866195779976],
                    [-154.688129428880444, 53.448408159976111],
                    [-155.696254331144928, 53.676555686801123],
                    [-156.715151385862981, 53.896146760757858],
                    [-157.744598440666692, 54.107021575012709],
                    [-158.784346818057969, 54.309022988257198],
                    [-159.834120917200437, 54.501996990221073],
                    [-160.893617950136075, 54.685793179995642],
                    [-161.962507823903195, 54.860265257735193],
                    [-163.040433171192632, 55.025271515785732],
                    [-164.127009547285269, 55.180675334280124],
                    [-165.221825801260508, 55.326345676878645],
                    [-166.324444627766923, 55.462157587902425],
                    [-167.43440329767779, 55.587992669831635],
                    [-168.551214574644234, 55.703739556930543],
                    [-169.674367831671503, 55.809294372127624],
                    [-170.803330332760851, 55.904561161164509],
                    [-171.937548712001103, 55.989452304094073],
                    [-173.076450617789448, 56.063888897769857],
                    [-174.219446527689087, 56.127801111826216],
                    [-175.365931702961376, 56.181128495743678],
                    [-176.515288294221278, 56.223820264879691],
                    [-177.66688755770079, 56.255835533219567],
                    [-178.820092179718927, 56.277143502231695],
                    [-179.974258673394758, 56.287723611028412],
                    [-180.0, 56.287720087958064],
                    [-180.0, 58.0],
                    [-180.0, 60.0],
                    [-180.0, 62.0],
                    [-180.0, 64.000000000000114],
                    [-180.0, 66.000000000000114],
                    [-180.0, 68.0],
                    [-180.0, 70.0],
                    [-180.0, 72.0],
                    [-180.0, 74.000000000000114],
                    [-180.0, 76.0],
                    [-180.0, 78.0],
                    [-180.0, 80.0],
                    [-180.0, 82.000000000000114],
                    [-180.0, 84.0],
                    [-180.0, 86.0],
                    [-180.0, 88.0],
                    [-180.0, 90.000000000000114],
                    [-178.0, 90.000000000000114],
                    [-176.0, 90.000000000000114],
                    [-174.0, 90.000000000000114],
                    [-172.0, 90.000000000000114],
                    [-170.0, 90.000000000000114],
                    [-168.0, 90.000000000000114],
                    [-166.0, 90.000000000000114],
                    [-164.0, 90.000000000000114],
                    [-162.0, 90.000000000000114],
                    [-160.0, 90.000000000000114],
                    [-158.0, 90.000000000000114],
                    [-156.0, 90.000000000000114],
                    [-154.0, 90.000000000000114],
                    [-152.0, 90.000000000000114],
                    [-150.0, 90.000000000000114],
                    [-148.0, 90.000000000000114],
                    [-146.0, 90.000000000000114],
                    [-144.0, 90.000000000000114],
                    [-142.0, 90.000000000000114],
                    [-140.0, 90.000000000000114],
                    [-138.0, 90.000000000000114],
                    [-136.0, 90.000000000000114],
                    [-134.0, 90.000000000000114],
                    [-132.0, 90.000000000000114],
                    [-130.0, 90.000000000000114],
                    [-128.0, 90.000000000000114],
                    [-126.0, 90.000000000000114],
                    [-124.0, 90.000000000000114],
                    [-122.0, 90.000000000000114],
                    [-120.0, 90.000000000000114],
                    [-118.0, 90.000000000000114],
                    [-115.999999999999886, 90.000000000000114],
                    [-114.0, 90.000000000000114],
                    [-111.999999999999886, 90.000000000000114],
                    [-110.0, 90.000000000000114],
                    [-108.0, 90.000000000000114],
                    [-106.0, 90.000000000000114],
                    [-104.0, 90.000000000000114],
                    [-102.0, 90.000000000000114],
                    [-100.0, 90.000000000000114],
                    [-98.0, 90.000000000000114],
                    [-96.0, 90.000000000000114],
                    [-94.0, 90.000000000000114],
                    [-92.0, 90.000000000000114],
                    [-90.0, 90.000000000000114],
                    [-88.0, 90.000000000000114],
                    [-86.0, 90.000000000000114],
                    [-84.0, 90.000000000000114],
                    [-82.0, 90.000000000000114],
                    [-80.0, 90.000000000000114],
                    [-78.0, 90.000000000000114],
                    [-76.0, 90.000000000000114],
                    [-73.999999999999886, 90.000000000000114],
                    [-72.0, 90.000000000000114],
                    [-69.999999999999886, 90.000000000000114],
                    [-68.0, 90.000000000000114],
                    [-66.0, 90.000000000000114],
                    [-64.0, 90.000000000000114],
                    [-62.0, 90.000000000000114],
                    [-60.0, 90.000000000000114],
                    [-58.0, 90.000000000000114],
                    [-56.0, 90.000000000000114],
                    [-54.0, 90.000000000000114],
                    [-52.0, 90.000000000000114],
                    [-50.0, 90.000000000000114],
                    [-48.0, 90.000000000000114],
                    [-46.0, 90.000000000000114],
                    [-44.0, 90.000000000000114],
                    [-42.0, 90.000000000000114],
                    [-40.0, 90.000000000000114],
                    [-38.0, 90.000000000000114],
                    [-36.0, 90.000000000000114],
                    [-34.0, 90.000000000000114],
                    [-32.0, 90.000000000000114],
                    [-30.0, 90.000000000000114],
                    [-27.999999999999886, 90.000000000000114],
                    [-26.0, 90.000000000000114],
                    [-24.0, 90.000000000000114],
                    [-22.0, 90.000000000000114],
                    [-20.0, 90.000000000000114],
                    [-18.0, 90.000000000000114],
                    [-16.0, 90.000000000000114],
                    [-14.0, 90.000000000000114],
                    [-12.0, 90.000000000000114],
                    [-10.0, 90.000000000000114],
                    [-8.0, 90.000000000000114],
                    [-6.0, 90.000000000000114],
                    [-4.0, 90.000000000000114],
                    [-2.0, 90.000000000000114],
                    [0.0, 90.000000000000114],
                    [2.0, 90.000000000000114],
                    [4.0, 90.000000000000114],
                    [6.000000000000114, 90.000000000000114],
                    [8.0, 90.000000000000114],
                    [10.0, 90.000000000000114],
                    [12.0, 90.000000000000114],
                    [14.000000000000114, 90.000000000000114],
                    [16.0, 90.000000000000114],
                    [18.0, 90.000000000000114],
                    [20.0, 90.000000000000114],
                    [22.000000000000114, 90.000000000000114],
                    [24.000000000000114, 90.000000000000114],
                    [26.0, 90.000000000000114],
                    [28.0, 90.000000000000114],
                    [30.0, 90.000000000000114],
                    [32.000000000000114, 90.000000000000114],
                    [34.0, 90.000000000000114],
                    [36.0, 90.000000000000114],
                    [38.0, 90.000000000000114],
                    [40.000000000000114, 90.000000000000114],
                    [42.0, 90.000000000000114],
                    [44.0, 90.000000000000114],
                    [46.0, 90.000000000000114],
                    [48.000000000000114, 90.000000000000114],
                    [50.0, 90.000000000000114],
                    [52.0, 90.000000000000114],
                    [54.0, 90.000000000000114],
                    [56.000000000000114, 90.000000000000114],
                    [57.03657577749874, 90.000000000000114],
                    [58.0, 90.000000000000114],
                    [60.0, 90.000000000000114],
                    [60.66575787400717, 90.000000000000114],
                    [62.0, 90.000000000000114],
                    [64.000000000000114, 90.000000000000114],
                    [66.000000000000114, 90.000000000000114],
                    [68.0, 90.000000000000114],
                    [70.0, 90.000000000000114],
                    [72.0, 90.000000000000114],
                    [74.000000000000114, 90.000000000000114],
                    [76.0, 90.000000000000114],
                    [78.0, 90.000000000000114],
                    [80.0, 90.000000000000114],
                    [82.000000000000114, 90.000000000000114],
                    [84.0, 90.000000000000114],
                    [86.0, 90.000000000000114],
                    [88.0, 90.000000000000114],
                    [90.000000000000114, 90.000000000000114],
                    [92.0, 90.000000000000114],
                    [94.0, 90.000000000000114],
                    [96.0, 90.000000000000114],
                    [98.000000000000114, 90.000000000000114],
                    [100.0, 90.000000000000114],
                    [102.0, 90.000000000000114],
                    [104.0, 90.000000000000114],
                    [106.000000000000114, 90.000000000000114],
                    [108.0, 90.000000000000114],
                    [110.0, 90.000000000000114],
                    [112.0, 90.000000000000114],
                    [114.0, 90.000000000000114],
                    [116.000000000000114, 90.000000000000114],
                    [118.0, 90.000000000000114],
                    [120.0, 90.000000000000114],
                    [122.0, 90.000000000000114],
                    [124.000000000000114, 90.000000000000114],
                    [126.000000000000227, 90.000000000000114],
                    [128.0, 90.000000000000114],
                    [130.0, 90.000000000000114],
                    [132.000000000000114, 90.000000000000114],
                    [134.000000000000227, 90.000000000000114],
                    [136.0, 90.000000000000114],
                    [138.0, 90.000000000000114],
                    [140.000000000000114, 90.000000000000114],
                    [142.000000000000114, 90.000000000000114],
                    [144.0, 90.000000000000114],
                    [146.0, 90.000000000000114],
                    [148.000000000000114, 90.000000000000114],
                    [150.000000000000114, 90.000000000000114],
                    [152.0, 90.000000000000114],
                    [154.0, 90.000000000000114],
                    [156.0, 90.000000000000114],
                    [158.000000000000114, 90.000000000000114],
                    [160.0, 90.000000000000114],
                    [162.0, 90.000000000000114],
                    [164.0, 90.000000000000114],
                    [166.000000000000114, 90.000000000000114],
                    [168.000000000000227, 90.000000000000114],
                    [170.0, 90.000000000000114],
                    [172.0, 90.000000000000114],
                    [174.000000000000114, 90.000000000000114],
                    [176.000000000000227, 90.000000000000114],
                    [178.0, 90.000000000000114],
                    [180.0, 90.000000000000114],
                    [180.0, 88.0],
                    [180.0, 86.7725609102867],
                    [179.999999998461135, 86.000000000127386],
                    [180.0, 85.482857593225333],
                    [180.0, 84.0],
                    [180.0, 82.777323184097611],
                ]
            ],
        },
        {
            "zoneID": "19",
            "coordinates": [
                [
                    [36.521509999989973, -50.103200999794637],
                    [36.733421578000048, -50.729569328999901],
                    [36.95107510400004, -51.355543177999891],
                    [37.174757331000194, -51.98110257999997],
                    [37.404773482, -52.606226254999967],
                    [37.641448762000039, -53.230891502999953],
                    [37.885130003000086, -53.855074085999945],
                    [38.136187474000053, -54.478748088999964],
                    [38.395016879000025, -55.101885780999964],
                    [38.662041547000115, -55.724457447999896],
                    [38.937714854000035, -56.346431218999953],
                    [39.222522898000193, -56.96777286299988],
                    [39.516987450000101, -57.588445572999944],
                    [39.821669230000055, -58.208409721999942],
                    [40.137171538000075, -58.827622583999982],
                    [40.464144278000163, -59.446038040999952],
                    [40.803288449000036, -60.063606232999973],
                    [41.15536113200011, -60.680273182999883],
                    [41.521181059000071, -61.295980369999938],
                    [41.901634833000116, -61.910664248999979],
                    [42.297683889000041, -62.524255709999863],
                    [42.710372285000176, -63.136679468999944],
                    [43.14083545200009, -63.747853377999888],
                    [43.590310015000057, -64.357687645999874],
                    [44.060144854000157, -64.966083951999963],
                    [44.551813553000045, -65.572934434999979],
                    [45.066928451000138, -66.178120540999828],
                    [45.607256503000087, -66.781511714999965],
                    [46.174737214, -67.38296388699996],
                    [46.771502924000117, -67.98231774899989],
                    [47.399901776000149, -68.579396761999988],
                    [48.062523724000073, -69.174004864999915],
                    [48.762229987000126, -69.765923825999948],
                    [49.502186388000041, -70.354910168999879],
                    [50.285901060000072, -70.94069162299985],
                    [51.117266995000193, -71.522962977999896],
                    [52.000609957000108, -72.101381278999952],
                    [52.940742184000101, -72.675560204999954],
                    [53.943022254000084, -73.245063531999961],
                    [55.013421269000105, -73.809397484999863],
                    [56.158595184000035, -74.368001818999971],
                    [57.385962561000042, -74.920239420999962],
                    [58.703786150000155, -75.465384203999918],
                    [60.121255412000039, -76.002607072999979],
                    [61.648565104000056, -76.530959724999946],
                    [63.296982237000122, -77.049356124999974],
                    [65.078889671000127, -77.556551531999958],
                    [67.00778908400008, -78.05111917999983],
                    [69.09823869700017, -78.53142496199996],
                    [71.365691880000043, -78.995600954999929],
                    [73.82619196100012, -79.441519329999949],
                    [76.495867606000161, -79.866769200999897],
                    [79.390165042000149, -80.26864034099998],
                    [82.522753973000192, -80.644119383999907],
                    [85.90406216800011, -80.989905956999962],
                    [89.539441239000155, -81.302457684],
                    [93.427054067000142, -81.578073347999918],
                    [97.555705092000153, -81.813021553999988],
                    [101.902989301000048, -82.003716652999913],
                    [106.434262240000066, -82.146934085999987],
                    [111.102950238000176, -82.240044578999914],
                    [115.852548670000147, -82.281234562999941],
                    [120.620282321000332, -82.269674012999985],
                    [125.341926591000174, -82.205597648999913],
                    [129.956908764000104, -82.090281692999895],
                    [134.412711990000048, -81.925921362999986],
                    [138.667841582000165, -81.715435266999975],
                    [142.693061568000076, -81.462234334999948],
                    [146.471060492000106, -81.169992499999978],
                    [149.994995595000205, -80.842446863999953],
                    [153.266446460000111, -80.483242151999889],
                    [156.293233296000039, -80.095822605999899],
                    [159.087407564000159, -79.683366605999879],
                    [161.663574256000061, -79.248755464999988],
                    [164.037592312000129, -78.794567045999941],
                    [166.225630489000309, -78.323085838999987],
                    [168.243522854000048, -77.836322824999968],
                    [170.106358921000037, -77.336040318999949],
                    [171.828247624000142, -76.823778467999944],
                    [173.422204135000015, -76.300881362999974],
                    [174.900119719000031, -75.768521551999982],
                    [176.272785041000134, -75.22772235399998],
                    [177.549945741000215, -74.679377759999909],
                    [178.740375657000186, -74.124269924999851],
                    [179.851957892000314, -73.563084385999957],
                    [180.000000000000114, -73.482406422999986],
                    [180.008142277087018, -84.382299048031427],
                    [-179.809429834033864, -84.458118035323594],
                    [-179.999999999999858, -73.482406422999986],
                    [-179.108232615999952, -72.996423231999984],
                    [-178.133848913999913, -72.424816427999986],
                    [-177.219196518999979, -71.848731544999964],
                    [-176.359163734999981, -71.268582093999953],
                    [-175.54915822800001, -70.684734669999955],
                    [-174.785049896999965, -70.097515067999836],
                    [-174.063119751999949, -69.50721353199998],
                    [-173.380014413999959, -68.914089257999876],
                    [-172.732705741999979, -68.318374266999911],
                    [-172.11845510099991, -67.720276736999949],
                    [-171.534781777999939, -67.119983880999939],
                    [-170.979435087999974, -66.517664432999936],
                    [-170.450369748999947, -65.913470802999939],
                    [-169.945724121999973, -65.307540948999986],
                    [-169.463801000003997, -64.69999999980007],
                    [-168.238595091889891, -65.074451607155879],
                    [-166.97892726548082, -65.438606851824716],
                    [-165.684264195835908, -65.791999460806437],
                    [-164.35416748504133, -66.134149770795261],
                    [-162.988308968683924, -66.464565962349241],
                    [-161.58648678493708, -66.782745599529676],
                    [-160.148642011119819, -67.088177493296655],
                    [-158.674875571850066, -67.380343911142518],
                    [-157.165465083346902, -67.658723141959285],
                    [-155.620881222890034, -67.922792429626838],
                    [-154.04180312611328, -68.172031271725643],
                    [-152.429132293220675, -68.405925068087356],
                    [-150.784004409675674, -68.623969095797065],
                    [-149.107798466226228, -68.825672770182166],
                    [-147.402142581115186, -69.010564142321186],
                    [-145.668915931824699, -69.178194552136802],
                    [-143.91024627384644, -69.328143366922802],
                    [-142.128502647179346, -69.460022700986769],
                    [-140.326282977377446, -69.573482006689176],
                    [-138.506396470420725, -69.668212427161734],
                    [-136.671840895840603, -69.743950796491958],
                    [-134.825775063868093, -69.800483159670023],
                    [-132.971487020009931, -69.837647725961745],
                    [-131.112358688202733, -69.855337145093131],
                    [-129.25182786726225, -69.853500042393023],
                    [-127.393348631933691, -69.832141761632954],
                    [-125.5403512609019, -69.791324286786391],
                    [-123.696202854577962, -69.731165349900891],
                    [-121.864169755129979, -69.651836749366453],
                    [-120.047382787685422, -69.553561938832388],
                    [-118.248806216633568, -69.436612965915629],
                    [-116.471211089719986, -69.301306845234706],
                    [-114.717153466359321, -69.148001489876833],
                    [-112.988957790069946, -68.977091300223265],
                    [-111.288705467982879, -68.789002544132074],
                    [-109.61822850184376, -68.584188622007275],
                    [-107.979107877326669, -68.363125339962437],
                    [-106.372676268295095, -68.126306280110725],
                    [-104.8000245227135, -67.874238339028068],
                    [-103.262011341150412, -67.607437522523583],
                    [-101.759275534538176, -67.326425025494473],
                    [-100.29225025234723, -67.031723646329169],
                    [-98.861178606507451, -66.723854561938424],
                    [-97.466130160478428, -66.403334459817415],
                    [-96.1070178176181, -66.070673039728888],
                    [-94.783614703255864, -65.726370872417704],
                    [-93.49557071041994, -65.370917598268477],
                    [-92.242428443917504, -65.004790449719451],
                    [-91.023638359522636, -64.628453064157497],
                    [-89.838572952579682, -64.242354569307849],
                    [-88.686539904293113, -63.846928915936701],
                    [-87.566794128146455, -63.442594416499105],
                    [-86.478548702960211, -63.029753478040561],
                    [-85.420984706079253, -62.608792498774733],
                    [-84.39325996917222, -62.180081895962701],
                    [-83.394516819595538, -61.74397626149522],
                    [-82.423888857684574, -61.300814602012224],
                    [-81.48050684191719, -60.850920668953677],
                    [-80.563503749398478, -60.394603344368704],
                    [-79.672019087211083, -59.932157077087425],
                    [-78.805202534669206, -59.463862356662332],
                    [-77.962216963242213, -58.989986212493648],
                    [-77.142240929475236, -58.510782730038841],
                    [-76.344470681376777, -58.026493577816325],
                    [-75.568121748419912, -57.537348534407272],
                    [-74.812430156526432, -57.04356601905647],
                    [-74.076653335483002, -56.545353609681229],
                    [-73.36007074037235, -56.042908555485326],
                    [-72.661984242778431, -55.536418277881182],
                    [-71.981718318745379, -55.026060850727561],
                    [-71.318620069460565, -54.512005476071806],
                    [-70.672059096250223, -53.994412929313171],
                    [-70.041427257761711, -53.47343599717351],
                    [-69.426138334516509, -52.94921989408283],
                    [-68.825627607128354, -52.421902657881276],
                    [-68.239351379662367, -51.891615531131777],
                    [-67.666786447236689, -51.358483321747826],
                    [-67.107429530348497, -50.822624746534757],
                    [-66.560796681321619, -50.284152756744277],
                    [-66.026422666472797, -49.743174851937795],
                    [-65.503860350075058, -49.199793366870324],
                    [-64.992680056739118, -48.654105756575348],
                    [-64.492468945485427, -48.106204851772475],
                    [-64.002830380217858, -47.556179115173904],
                    [-63.523383315487479, -47.004112869913001],
                    [-63.053761682255811, -46.450086525272866],
                    [-62.59361379703904, -45.894176786229593],
                    [-62.142601773752801, -45.336456848604655],
                    [-61.700400962534331, -44.776996588821419],
                    [-61.26669939576044, -44.215862740173293],
                    [-60.841197256548128, -43.653119056499236],
                    [-60.423606364342163, -43.088826472263747],
                    [-60.013649678489799, -42.523043248247234],
                    [-59.61106081440488, -41.955825113638014],
                    [-59.215583587612343, -41.387225395535552],
                    [-58.826971571280808, -40.817295146653635],
                    [-58.444987663649727, -40.246083257736075],
                    [-58.069403689628473, -39.673636575367539],
                    [-57.699999999700196, -39.1],
                    [-57.105728881082939, -39.546354584596372],
                    [-56.503789583322487, -39.989643870468171],
                    [-55.89401469941879, -40.429778883188874],
                    [-55.276235564219803, -40.866668210269665],
                    [-54.650282446877384, -41.300217948099714],
                    [-54.015984757690319, -41.730331651584436],
                    [-53.37317128102967, -42.156910283782452],
                    [-52.721670434343025, -42.579852170940796],
                    [-52.06131055054135, -42.999052953930629],
                    [-51.391920182870024, -43.414405550475749],
                    [-50.713328450247673, -43.825800118280654],
                    [-50.025365402391344, -44.23312401636025],
                    [-49.32786242001464, -44.636261781655776],
                    [-48.620652651898183, -45.035095099359296],
                    [-47.903571476242519, -45.429502790321465],
                    [-47.176457013280469, -45.819360794864679],
                    [-46.439150657676691, -46.204542171883702],
                    [-45.691497662187203, -46.584917099744189],
                    [-44.933347755494481, -46.960352889773958],
                    [-44.164555796912396, -47.330714009643714],
                    [-43.384982473362413, -47.695862113046019],
                    [-42.594495038615094, -48.055656084660484],
                    [-41.792968090305067, -48.409952097711027],
                    [-40.980284381119191, -48.758603679616044],
                    [-40.156335679447977, -49.101461800121911],
                    [-39.321023655217459, -49.438374966631329],
                    [-38.474260807989879, -49.76918933841722],
                    [-37.615971423842097, -50.09374886152068],
                    [-36.746092560123373, -50.411895414441801],
                    [-35.864575058991761, -50.723468979909399],
                    [-34.971384577136462, -51.028307830142182],
                    [-34.066502628993021, -51.326248734591331],
                    [-33.149927645244532, -51.617127191066857],
                    [-32.221676026827083, -51.900777675749111],
                    [-31.281783192640205, -52.177033914783294],
                    [-30.330304616464787, -52.445729175660858],
                    [-29.367316834204473, -52.706696588276827],
                    [-28.39291842054854, -52.959769483075149],
                    [-27.407230917972413, -53.204781743582544],
                    [-26.410399709079286, -53.441568197614174],
                    [-25.402594817896443, -53.669965010276883],
                    [-24.384011634729063, -53.889810106651055],
                    [-23.354871538490613, -54.100943608860348],
                    [-22.315422421907215, -54.303208291129692],
                    [-21.26593908811833, -54.49645004293501],
                    [-20.206723522272569, -54.680518352839556],
                    [-19.138105014734606, -54.855266790529924],
                    [-18.060440133205475, -55.0205535077381],
                    [-16.9741125284703, -55.176241726574403],
                    [-15.879532571970515, -55.322200241348014],
                    [-14.777136810815023, -55.458303908698383],
                    [-13.667387239329571, -55.584434132329307],
                    [-12.550770385344947, -55.700479332455131],
                    [-11.427796207628774, -55.806335406253936],
                    [-10.298996809854827, -55.901906159541568],
                    [-9.16492497560705, -55.987103721359631],
                    [-8.026152519922789, -56.061848927985579],
                    [-6.883268490648277, -56.126071676366735],
                    [-5.736877207017358, -56.179711236184573],
                    [-4.58759616333225, -56.222716535839425],
                    [-3.436053814831666, -56.255046393576094],
                    [-2.282887260138921, -56.276669712637101],
                    [-1.12873983737353, -56.287565629650032],
                    [0.02574132740034, -56.287723609956572],
                    [1.179907820289714, -56.277143501571231],
                    [2.333112442385357, -56.255835532483786],
                    [3.484711706280393, -56.223820264793346],
                    [4.634068297514091, -56.181128494884035],
                    [5.780553472165082, -56.12780111133219],
                    [6.923549381598662, -56.063888897954257],
                    [8.062451288396346, -55.98945230358089],
                    [9.196669667171591, -55.904561160569017],
                    [10.325632167790445, -55.809294371837723],
                    [11.448785424807625, -55.703739556535254],
                    [12.565596702326047, -55.587992669625976],
                    [13.675555371583187, -55.462157587302784],
                    [14.778174198780334, -55.326345677111249],
                    [15.872990453047009, -55.180675333899501],
                    [16.959566829145956, -55.02527151576777],
                    [18.037492175923205, -54.860265258434879],
                    [19.106382050291415, -54.685793179711368],
                    [20.165879083253117, -54.501996989369445],
                    [21.215653181349353, -54.309022987320986],
                    [22.255401559034794, -54.107021574386067],
                    [23.284848613672693, -53.896146760364559],
                    [24.303745669227339, -53.676555686495703],
                    [25.311870570670351, -53.448408159608846],
                    [26.309027173165646, -53.211866195268669],
                    [27.295044715241488, -52.967093582502798],
                    [28.269777101132377, -52.714255462919255],
                    [29.233102099482494, -52.453517926910763],
                    [30.184920471902331, -52.185047635040291],
                    [31.125155049366072, -51.90901145741276],
                    [32.053749751050248, -51.62557613283218],
                    [32.970668583388601, -51.334907953139407],
                    [33.875894601354958, -51.037172470033397],
                    [34.769428859854031, -50.732534218978969],
                    [35.651289362414275, -50.421156470994276],
                    [36.521509999989973, -50.103200999794637],
                ]
            ],
        },
    ]

    geojson_features = []  # Store GeoJSON features

    for facet in facets:
        geojson_features.append(
            {
                "type": "Feature",
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [facet["coordinates"]],
                },
                "properties": {"zoneID": facet["zoneID"]},
            }
        )

    # Save as GeoJSON with CRS
    geojson_output = {
        "type": "FeatureCollection",
        "name": "fuller_icosahedron",
        "features": geojson_features,
    }

    with open(outFile, "w") as f:
        json.dump(geojson_output, f)

    print(f"fuller_icosahedron saved as {outFile}")


if __name__ == "__main__":
    main()
