from shapely.geometry import Polygon
import json
import os


def constructGeometry(facet):
    # Create a Polygon with the vertices (longitude, latitude)
    poly = Polygon([(v[0], v[1]) for v in facet])  # (lon, lat)
    return poly


def main():
    outFileDir = os.getcwd()  # Use current directory
    outFileName = "rhombic_icosahedron.geojson"
    outFile = os.path.join(outFileDir, outFileName)

    # Define facets with coordinates and zoneIDs
    facets = [
        {
            "zoneID": "0",
            "coordinates": [
                [-168.8, 58.397145907431202],
                [-166.64000771923611, 56.746047662048703],
                [-164.64602573232429, 55.0448923073914],
                [-162.800520140889091, 53.298513271829002],
                [-161.087705806294792, 51.511276220548901],
                [-159.493466512597905, 49.687152255540099],
                [-158.005232283902501, 47.8297817830368],
                [-156.611837952358513, 45.942529107418402],
                [-155.303377891200711, 44.028528364041101],
                [-154.071065655322911, 42.090721655436198],
                [-152.907103247695886, 40.131890331023001],
                [-151.8045621842179, 38.154680329945499],
                [-150.757276974097408, 36.161622438558503],
                [-149.759750725422805, 34.155148226924297],
                [-148.807072092955309, 32.1376023382686],
                [-147.894842551828589, 30.111251719788601],
                [-147.019112904781906, 28.078292306110399],
                [-146.17632794606709, 26.040853599098199],
                [-145.3632782706228, 24.001001529277499],
                [-144.577058306628686, 21.960739933920902],
                [-143.815029747526012, 19.9220109436095],
                [-143.074789656905097, 17.886694531655699],
                [-142.3541426113554, 15.856607448029299],
                [-141.65107633, 13.833501730439499],
                [-140.963740314122703, 11.8190629592542],
                [-140.290427086035095, 9.814908399363601],
                [-139.629555673616011, 7.8225851505308],
                [-138.979657036546314, 5.8435684078962],
                [-138.339361172955194, 3.8792599159225],
                [-137.707385681859904, 1.9309866821013],
                [-137.082525588179607, 0.0000000011108],
                [-135.447000136892711, 1.1932794940726],
                [-133.79517141705071, 2.3964120447222],
                [-132.126353726759703, 3.6077527052526],
                [-130.439841330232611, 4.8255667667013],
                [-128.734913399357396, 6.0480327336798],
                [-127.010839720884604, 7.2732460380363],
                [-125.266887227307095, 8.4992235192965],
                [-123.502327407070197, 9.723908695308999],
                [-121.716444644676201, 10.945177841743901],
                [-119.908545532950598, 12.1608468939523],
                [-118.077969187516402, 13.3686791791808],
                [-116.224098576711796, 14.5663939811571],
                [-114.346372858107799, 15.7516759325206],
                [-112.444300684860707, 16.9221852232724],
                [-110.517474410938803, 18.075568605128598],
                [-108.565585083595494, 19.209471162108699],
                [-106.588438064493801, 20.3215488065469],
                [-104.585969068234107, 21.4094814466755],
                [-102.5582603498937, 22.4709867567061],
                [-100.505556713469403, 23.503834462723599],
                [-98.428280953439199, 24.505861037661798],
                [-96.327048285512106, 25.474984676270999],
                [-94.202679274185996, 26.409220396743901],
                [-92.056210728762807, 27.306695090245402],
                [-89.888904021144995, 28.1656623140688],
                [-87.702250283067997, 28.984516599951601],
                [-85.497971972001494, 29.761807027953001],
                [-83.278020357103003, 30.496249800235098],
                [-81.044568571017805, 31.186739540149201],
                [-78.8, 31.832359041336101],
                [-77.377906555375304, 33.462839678391902],
                [-75.888235538057003, 35.090676617834298],
                [-74.325137600037294, 36.712789042093398],
                [-72.682259551035301, 38.3257989414695],
                [-70.952726595336998, 39.926004940269699],
                [-69.129136571137394, 41.509354174752602],
                [-67.203572202992405, 43.071412622341001],
                [-65.167639283535095, 44.607334639138401],
                [-63.012540942416898, 46.111832971334302],
                [-60.729200627239102, 47.579151204357899],
                [-58.3084488493352, 49.003041535798303],
                [-55.741290633100903, 50.376751920834799],
                [-53.0192711085216, 51.693028018961598],
                [-50.134954538612, 52.944136871105599],
                [-47.082525590518301, 54.121920641867902],
                [-43.858508925945401, 55.217889693371902],
                [-40.4625825946828, 56.2233641447624],
                [-36.898431966396501, 57.129671184907998],
                [-33.174556473932299, 57.928400998307801],
                [-29.304907877912701, 58.611716767954299],
                [-25.309217317585201, 59.172704079054398],
                [-21.212873011222801, 59.605733553336599],
                [-17.046252611425, 59.906800373642099],
                [-12.843495610643499, 60.073799010792001],
                [-8.6408078304302, 60.106694054835401],
                [-4.4744928861719, 60.007559744303997],
                [-0.3789704394503, 59.780479702951901],
                [3.6149557236609, 59.431319855533403],
                [7.4813764363348, 58.9674057360278],
                [11.2, 58.397145907431202],
                [11.1999999986331, 60.414133748082001],
                [11.199999998553899, 62.448909837861102],
                [11.1999999984591, 64.500480210066399],
                [11.199999998344699, 66.567794949960998],
                [11.199999998204699, 68.649750497593303],
                [11.199999998030799, 70.745192363965998],
                [11.199999997810201, 72.852918252509696],
                [11.199999997522999, 74.971681571383698],
                [11.199999997136, 77.100195316654407],
                [11.1999999965893, 79.2371363010311],
                [11.1999999957632, 81.381149697724197],
                [11.1999999943784, 83.530853864209305],
                [11.199999991596901, 85.684845406359898],
                [11.199999983229, 87.841704439646705],
                [11.1999994413579, 89.9352439523893],
                [-135.777378144719592, 90.0],
                [-168.799999441355794, 89.935243950436998],
                [-168.799999983228901, 87.841704437704493],
                [-168.799999991596991, 85.684845404419704],
                [-168.799999994378396, 83.530853862272394],
                [-168.799999995763187, 81.381149695791805],
                [-168.799999996589207, 79.237136299104407],
                [-168.799999997136013, 77.100195314734705],
                [-168.799999997523003, 74.971681569472096],
                [-168.799999997810204, 72.852918250607601],
                [-168.799999998030898, 70.745192362074505],
                [-168.799999998204811, 68.649750495713107],
                [-168.799999998344703, 66.567794948093606],
                [-168.7999999984591, 64.500480208212593],
                [-168.799999998553886, 62.448909836021997],
                [-168.799999998633098, 60.414133746258301],
                [-168.8, 58.397145907431202],
            ],
        },
        {
            "zoneID": "1",
            "coordinates": [
                [-137.082525588179607, 0.0000000011108],
                [-137.707385681294511, -1.9309866803557],
                [-138.339361172382894, -3.8792599141618],
                [-138.979657035966, -5.8435684061216],
                [-139.629555673026488, -7.8225851487436],
                [-140.290427085434999, -9.8149083975651],
                [-140.963740313510812, -11.8190629574458],
                [-141.651076329374604, -13.8335017286223],
                [-142.354142610715087, -15.8566074462051],
                [-143.0747896562481, -17.886694529826201],
                [-143.815029746850314, -19.922010941775898],
                [-144.577058305932411, -21.9607399320853],
                [-145.363278269903503, -24.001001527441201],
                [-146.176327945322413, -26.040853597263101],
                [-147.019112904009091, -28.078292304278499],
                [-147.894842551024595, -30.111251717961601],
                [-148.807072092116698, -32.137602336448701],
                [-149.759750724545995, -34.155148225113102],
                [-150.757276973178108, -36.1616224367584],
                [-151.804562183251306, -38.154680328158598],
                [-152.907103246676911, -40.131890329251398],
                [-154.0710656542457, -42.090721653682401],
                [-155.303377890058613, -44.028528362307298],
                [-156.611837951144196, -45.9425291057075],
                [-158.005232282607494, -47.8297817813514],
                [-159.493466511212489, -49.6871522538828],
                [-161.087705804808706, -51.511276218923399],
                [-162.800520139290086, -53.298513270238303],
                [-164.646025730599092, -55.044892305839397],
                [-166.640007717369599, -56.746047660539404],
                [-168.8, -58.397145907431202],
                [-165.081376435664708, -58.967405734721297],
                [-161.214955723135603, -59.431319854220803],
                [-157.221029560179289, -59.780479701636501],
                [-153.125507113619989, -60.007559742989599],
                [-148.959192169527512, -60.106694053526198],
                [-144.756504389480199, -60.073799009492497],
                [-140.553747388860103, -59.9068003723565],
                [-136.387126989216313, -59.605733552068898],
                [-132.290782682996394, -59.172704077808099],
                [-128.295092122798394, -58.611716766732599],
                [-124.425443526893503, -57.928400997113002],
                [-120.701568034528094, -57.1296711837416],
                [-117.137417406326094, -56.223364143625602],
                [-113.7414910751326, -55.217889692264798],
                [-110.517474410616103, -54.1219206407904],
                [-107.465045462567105, -52.944136870057001],
                [-104.580728892692093, -51.693028017940897],
                [-101.8587093681395, -50.3767519198408],
                [-99.291551151924494, -49.0030415348293],
                [-96.870799374034505, -47.579151203412202],
                [-94.587459058866301, -46.111832970410298],
                [-92.432360717754406, -44.607334638234299],
                [-90.396427798301005, -43.071412621455202],
                [-88.470863430158204, -41.509354173883203],
                [-86.647273405959893, -39.926004939415201],
                [-84.917740450261903, -38.325798940627799],
                [-83.274862401260293, -36.7127890412632],
                [-81.711764463240897, -35.090676617013898],
                [-80.222093445923306, -33.462839677579801],
                [-78.799999999196501, -31.832359040393499],
                [-78.799999999220404, -29.806710312033001],
                [-78.799999999242104, -27.762080686735999],
                [-78.7999999992618, -25.699490161659199],
                [-78.799999999279294, -23.620025158154501],
                [-78.799999999295096, -21.5248363225109],
                [-78.799999999308994, -19.415135755413701],
                [-78.799999999321301, -17.2921936703708],
                [-78.799999999332002, -15.157334490528999],
                [-78.799999999341097, -13.011932402883399],
                [-78.799999999348699, -10.857406398669999],
                [-78.799999999354895, -8.695214838404899],
                [-78.799999999359699, -6.5268495893573],
                [-78.799999999363095, -4.3538297919048],
                [-78.799999999365099, -2.1776953189386],
                [-78.799999999365795, 0.0000000009801],
                [-78.799999999365099, 2.1776953208979],
                [-78.799999999363095, 4.3538297938621],
                [-78.799999999359699, 6.5268495913109],
                [-78.799999999354895, 8.6952148403537],
                [-78.799999999348699, 10.857406400612801],
                [-78.799999999341097, 13.011932404818401],
                [-78.799999999332002, 15.157334492455201],
                [-78.799999999321301, 17.292193672287102],
                [-78.799999999308994, 19.415135757318399],
                [-78.799999999295096, 21.5248363244032],
                [-78.799999999279393, 23.620025160033101],
                [-78.7999999992618, 25.699490163523102],
                [-78.799999999242203, 27.762080688584401],
                [-78.799999999220404, 29.806710313864698],
                [-78.8, 31.832359041336101],
                [-81.044568571017805, 31.186739540149201],
                [-83.278020357103003, 30.496249800235098],
                [-85.497971972001494, 29.761807027953001],
                [-87.702250283067997, 28.984516599951601],
                [-89.888904021144995, 28.1656623140688],
                [-92.056210728762807, 27.306695090245402],
                [-94.202679274185996, 26.409220396743901],
                [-96.327048285512106, 25.474984676270999],
                [-98.428280953439199, 24.505861037661798],
                [-100.505556713469403, 23.503834462723599],
                [-102.5582603498937, 22.4709867567061],
                [-104.585969068234107, 21.4094814466755],
                [-106.588438064493801, 20.3215488065469],
                [-108.565585083595494, 19.209471162108699],
                [-110.517474410938803, 18.075568605128598],
                [-112.444300684860707, 16.9221852232724],
                [-114.346372858107799, 15.7516759325206],
                [-116.224098576711796, 14.5663939811571],
                [-118.077969187516402, 13.3686791791808],
                [-119.908545532950598, 12.1608468939523],
                [-121.716444644676201, 10.945177841743901],
                [-123.502327407070197, 9.723908695308999],
                [-125.266887227307095, 8.4992235192965],
                [-127.010839720884604, 7.2732460380363],
                [-128.734913399357396, 6.0480327336798],
                [-130.439841330232611, 4.8255667667013],
                [-132.126353726759703, 3.6077527052526],
                [-133.79517141705071, 2.3964120447222],
                [-135.447000136892711, 1.1932794940726],
                [-137.082525588179607, 0.0000000011108],
            ],
        },
        {
            "zoneID": "2",
            "coordinates": [
                [-78.8, 31.832359041336101],
                [-78.799999999220503, 29.806710313864698],
                [-78.799999999242203, 27.762080688584401],
                [-78.7999999992618, 25.699490163523102],
                [-78.799999999279393, 23.620025160033101],
                [-78.799999999295096, 21.524836324403299],
                [-78.799999999308994, 19.415135757318399],
                [-78.799999999321301, 17.292193672287102],
                [-78.799999999332002, 15.157334492455201],
                [-78.799999999341097, 13.011932404818401],
                [-78.799999999348699, 10.857406400612801],
                [-78.799999999354895, 8.6952148403537],
                [-78.799999999359699, 6.5268495913109],
                [-78.799999999363095, 4.3538297938621],
                [-78.799999999365099, 2.1776953208979],
                [-78.799999999365795, 0.0000000009801],
                [-78.799999999365099, -2.1776953189386],
                [-78.799999999363095, -4.3538297919048],
                [-78.799999999359699, -6.5268495893573],
                [-78.799999999354895, -8.695214838404899],
                [-78.799999999348699, -10.857406398670101],
                [-78.799999999341097, -13.011932402883399],
                [-78.799999999332002, -15.157334490528999],
                [-78.799999999321301, -17.2921936703708],
                [-78.799999999308994, -19.415135755413701],
                [-78.799999999295096, -21.5248363225109],
                [-78.799999999279294, -23.620025158154501],
                [-78.7999999992618, -25.699490161659199],
                [-78.799999999242104, -27.762080686735999],
                [-78.799999999220404, -29.806710312033001],
                [-78.799999999196501, -31.832359040393499],
                [-76.5554314274858, -31.186739538266],
                [-74.321979641432705, -30.496249798331998],
                [-72.1020280265667, -29.761807026030102],
                [-69.897749715533294, -28.9845165980093],
                [-67.711095977489506, -28.1656623121076],
                [-65.543789269904906, -27.306695088265599],
                [-63.397320724514898, -26.4092203947462],
                [-61.272951713221701, -25.474984674256],
                [-59.171719045327698, -24.5058610356302],
                [-57.094443285329902, -23.503834460676199],
                [-55.041739648937899, -22.470986754643899],
                [-53.014030930629303, -21.409481444599301],
                [-51.011561934400703, -20.3215488044575],
                [-49.034414915329997, -19.2094711600073],
                [-47.0825255880168, -18.075568603015999],
                [-45.155699314124597, -16.9221852211497],
                [-43.253627140906502, -15.7516759303887],
                [-41.375901422330898, -14.566393979017001],
                [-39.522030811554004, -13.3686791770334],
                [-37.691454466146901, -12.160846891798499],
                [-35.8835553544478, -10.945177839584501],
                [-34.097672592079697, -9.723908693144899],
                [-32.333112771868301, -8.499223517128399],
                [-30.5891602783156, -7.2732460358649],
                [-28.865086599866999, -6.0480327315059],
                [-27.160158669015502, -4.8255667645253],
                [-25.473646272511601, -3.607752703075],
                [-23.804828582243498, -2.3964120425435],
                [-22.152999862423801, -1.1932794918931],
                [-20.517474411460999, 0.0],
                [-19.892614318705501, 1.9309866803555],
                [-19.2606388276171, 3.8792599141618],
                [-18.620342964033998, 5.8435684061215],
                [-17.970444326973499, 7.8225851487436],
                [-17.309572914564999, 9.814908397564899],
                [-16.636259686489201, 11.8190629574458],
                [-15.948923670625399, 13.833501728622499],
                [-15.2458573892849, 15.8566074462051],
                [-14.525210343752001, 17.886694529826102],
                [-13.7849702531497, 19.922010941775898],
                [-13.0229416940675, 21.9607399320852],
                [-12.2367217300964, 24.001001527441201],
                [-11.4236720546775, 26.040853597263101],
                [-10.580887095990899, 28.078292304278499],
                [-9.705157448975401, 30.111251717961601],
                [-8.7929279078832, 32.137602336448701],
                [-7.840249275454, 34.155148225113102],
                [-6.8427230268219, 36.1616224367583],
                [-5.7954378167487, 38.154680328158499],
                [-4.692896753323, 40.131890329251497],
                [-3.5289343457543, 42.090721653682301],
                [-2.2966221099413, 44.028528362307497],
                [-0.9881620488558, 45.9425291057075],
                [0.4052322826075, 47.829781781351301],
                [1.8934665112126, 49.6871522538829],
                [3.4877058048087, 51.5112762189232],
                [5.2005201392901, 53.298513270238303],
                [7.0460257305991, 55.044892305839397],
                [9.0400077173698, 56.746047660539503],
                [11.2, 58.3971450553734],
                [7.4813764356647, 58.967405734721297],
                [3.6149557231354, 59.431319854220803],
                [-0.3789704398204, 59.780479701636501],
                [-4.4744928863802, 60.007559742989599],
                [-8.6408078304725, 60.106694053526198],
                [-12.8434956105199, 60.073799009492397],
                [-17.046252611140002, 59.9068003723564],
                [-21.212873010783699, 59.605733552068799],
                [-25.3092173170037, 59.172704077808099],
                [-29.304907877201199, 58.611716766732599],
                [-33.174556473106399, 57.928400997112902],
                [-36.898431965471801, 57.1296711837416],
                [-40.462582593673901, 56.223364143625503],
                [-43.858508924867301, 55.217889692264798],
                [-47.082525589383799, 54.1219206407904],
                [-50.134954537432897, 52.944136870057001],
                [-53.019271107307702, 51.693028017940897],
                [-55.741290631860402, 50.3767519198407],
                [-58.3084488480754, 49.003041534829201],
                [-60.729200625965198, 47.579151203412302],
                [-63.0125409411337, 46.111832970410298],
                [-65.167639282245403, 44.607334638234398],
                [-67.203572201698904, 43.071412621455202],
                [-69.129136569841705, 41.509354173883203],
                [-70.9527265940403, 39.926004939415002],
                [-72.682259549738006, 38.325798940627799],
                [-74.325137598739701, 36.7127890412632],
                [-75.888235536758998, 35.090676617013898],
                [-77.377906554076603, 33.462839677579801],
                [-78.8, 31.832359041336101],
            ],
        },
        {
            "zoneID": "3",
            "coordinates": [
                [-78.799999999196501, -31.832359040393499],
                [-80.222093444624605, -33.462839678391902],
                [-81.711764461943005, -35.090676617834397],
                [-83.2748623999627, -36.712789042093497],
                [-84.917740448964594, -38.3257989414696],
                [-86.647273404662997, -39.926004940269799],
                [-88.4708634288626, -41.509354174752602],
                [-90.396427797007405, -43.071412622340901],
                [-92.432360716464899, -44.6073346391385],
                [-94.587459057583104, -46.111832971334401],
                [-96.870799372760899, -47.579151204357899],
                [-99.291551150664802, -49.003041535798403],
                [-101.858709366899404, -50.376751920834899],
                [-104.580728891478302, -51.693028018961698],
                [-107.465045461388002, -52.944136871105599],
                [-110.517474409481693, -54.121920641867902],
                [-113.741491074054494, -55.217889693371902],
                [-117.137417405317194, -56.2233641447624],
                [-120.701568033603394, -57.129671184907998],
                [-124.425443526067895, -57.9284009983079],
                [-128.295092122087397, -58.611716767954398],
                [-132.290782682414687, -59.172704079054398],
                [-136.387126988777396, -59.605733553336599],
                [-140.553747388575005, -59.906800373642099],
                [-144.756504389356792, -60.073799010792101],
                [-148.95919216956969, -60.106694054835401],
                [-153.125507113828007, -60.007559744304103],
                [-157.221029560549994, -59.780479702951901],
                [-161.214955723660609, -59.431319855533502],
                [-165.081376436335489, -58.9674057360278],
                [-168.8, -58.397145907431202],
                [-168.799999998633211, -60.414133748082001],
                [-168.799999998553886, -62.448909837861102],
                [-168.799999998459214, -64.500480210066598],
                [-168.799999998344788, -66.567794949960998],
                [-168.799999998204896, -68.649750497593203],
                [-168.799999998031012, -70.745192363966098],
                [-168.799999997810403, -72.852918252509696],
                [-168.799999997523202, -74.971681571383797],
                [-168.799999997136098, -77.100195316654407],
                [-168.799999996589406, -79.2371363010311],
                [-168.799999995763613, -81.381149697724197],
                [-168.799999994378908, -83.530853864209305],
                [-168.799999991597701, -85.684845406359997],
                [-168.79999998322981, -87.841704439646705],
                [-168.799999441408204, -89.9352439523893],
                [-21.819650922591499, -90.0],
                [11.1999994413708, -89.935243950442498],
                [11.1999999832298, -87.841704437704493],
                [11.1999999915973, -85.684845404419704],
                [11.1999999943788, -83.530853862272394],
                [11.199999995763299, -81.381149695791805],
                [11.199999996589399, -79.237136299104193],
                [11.199999997136199, -77.100195314734705],
                [11.1999999975232, -74.971681569472096],
                [11.1999999978103, -72.852918250607601],
                [11.199999998030901, -70.745192362074405],
                [11.1999999982049, -68.649750495713306],
                [11.199999998344801, -66.567794948093606],
                [11.1999999984592, -64.500480208212693],
                [11.199999998554, -62.448909836021997],
                [11.199999998633199, -60.414133746258202],
                [11.200000000000101, -58.397145906270701],
                [9.040007719406599, -56.746047659779997],
                [7.0460257325688, -55.044892305118502],
                [5.2005201411938, -53.298513269552799],
                [3.4877058066485, -51.5112762182696],
                [1.8934665129914, -49.687152253258297],
                [0.4052322843288, -47.829781780753002],
                [-0.9881620471885, -45.942529105132799],
                [-2.2966221083241, -44.028528361754198],
                [-3.5289343441834, -42.0907216531484],
                [-4.6928967517947, -40.131890328734897],
                [-5.7954378152592, -38.154680327657701],
                [-6.8427230253679, -36.161622436271401],
                [-7.8402492740318, -34.155148224638701],
                [-8.7929279064896, -32.137602335985299],
                [-9.705157447607199, -30.111251717508001],
                [-10.580887094645, -28.0782923038334],
                [-11.423672053351099, -26.0408535968254],
                [-12.2367217287866, -24.001001527009901],
                [-13.0229416927716, -21.960739931659202],
                [-13.784970251864999, -19.922010941354198],
                [-14.5252103424761, -17.886694529407901],
                [-15.2458573880154, -15.856607445789299],
                [-15.9489236693599, -13.833501728208301],
                [-16.636259685225301, -11.8190629570326],
                [-17.309572913300499, -9.8149083971518],
                [-17.9704443257063, -7.8225851483297],
                [-18.6203429627618, -5.8435684057062],
                [-19.260638826337701, -3.8792599137442],
                [-19.8926143174168, -1.9309866799351],
                [-20.517474411460999, 0.0],
                [-22.152999862423801, -1.1932794918931],
                [-23.804828582243498, -2.3964120425435],
                [-25.473646272511601, -3.607752703075],
                [-27.160158669015502, -4.8255667645253],
                [-28.865086599866999, -6.0480327315059],
                [-30.5891602783156, -7.2732460358649],
                [-32.333112771868301, -8.499223517128399],
                [-34.097672592079697, -9.723908693144899],
                [-35.8835553544478, -10.945177839584501],
                [-37.691454466146801, -12.1608468917984],
                [-39.522030811554004, -13.3686791770334],
                [-41.375901422330898, -14.566393979017001],
                [-43.253627140906502, -15.7516759303887],
                [-45.155699314124597, -16.9221852211497],
                [-47.0825255880168, -18.075568603015999],
                [-49.034414915329997, -19.2094711600073],
                [-51.011561934400703, -20.3215488044575],
                [-53.014030930629303, -21.409481444599301],
                [-55.041739648937899, -22.470986754643899],
                [-57.094443285329902, -23.503834460676199],
                [-59.171719045327698, -24.5058610356302],
                [-61.272951713221701, -25.474984674256],
                [-63.397320724514898, -26.4092203947462],
                [-65.543789269904906, -27.306695088265599],
                [-67.711095977489506, -28.1656623121076],
                [-69.897749715533294, -28.9845165980093],
                [-72.1020280265667, -29.761807026030102],
                [-74.321979641432705, -30.496249798331998],
                [-76.5554314274858, -31.186739538266],
                [-78.799999999196501, -31.832359040393499],
            ],
        },
        {
            "zoneID": "4",
            "coordinates": [
                [-20.517474411460999, 0.0],
                [-19.8926143174168, -1.9309866799351],
                [-19.260638826337701, -3.8792599137442],
                [-18.6203429627618, -5.8435684057062],
                [-17.9704443257063, -7.8225851483297],
                [-17.309572913300499, -9.8149083971518],
                [-16.636259685225301, -11.8190629570326],
                [-15.9489236693599, -13.833501728208301],
                [-15.2458573880154, -15.856607445789299],
                [-14.5252103424761, -17.886694529407901],
                [-13.784970251864999, -19.922010941354198],
                [-13.0229416927716, -21.960739931659202],
                [-12.2367217287866, -24.001001527009901],
                [-11.423672053351099, -26.0408535968254],
                [-10.580887094645, -28.0782923038334],
                [-9.705157447607199, -30.111251717508001],
                [-8.7929279064896, -32.137602335985299],
                [-7.8402492740318, -34.155148224638701],
                [-6.8427230253679, -36.161622436271401],
                [-5.7954378152592, -38.154680327657701],
                [-4.6928967517947, -40.131890328734897],
                [-3.5289343441834, -42.0907216531484],
                [-2.2966221083241, -44.028528361754198],
                [-0.9881620471885, -45.942529105132799],
                [0.4052322843288, -47.829781780753002],
                [1.8934665129914, -49.687152253258297],
                [3.4877058066485, -51.5112762182696],
                [5.2005201411938, -53.298513269552799],
                [7.0460257325688, -55.044892305118502],
                [9.040007719406599, -56.746047659779997],
                [11.200000000000101, -58.397145906270701],
                [13.3599922805936, -56.746047659779897],
                [15.353974267431299, -55.044892305118502],
                [17.199479858806601, -53.298513269552501],
                [18.912294193351698, -51.5112762182696],
                [20.506533487008799, -49.687152253258098],
                [21.994767715671401, -47.829781780752903],
                [23.388162047188601, -45.942529105132799],
                [24.696622108324298, -44.028528361754098],
                [25.928934344183499, -42.0907216531484],
                [27.0928967517948, -40.131890328734897],
                [28.1954378152594, -38.154680327657601],
                [29.242723025368001, -36.161622436271401],
                [30.2402492740319, -34.155148224638602],
                [31.1929279064897, -32.137602335985299],
                [32.105157447607297, -30.111251717507901],
                [32.980887094645098, -28.078292303833301],
                [33.823672053351203, -26.040853596825301],
                [34.636721728786597, -24.001001527009901],
                [35.422941692771701, -21.960739931659099],
                [36.184970251865103, -19.922010941354198],
                [36.925210342476298, -17.886694529407698],
                [37.6458573880155, -15.8566074457891],
                [38.348923669359998, -13.833501728208301],
                [39.036259685225403, -11.8190629570325],
                [39.709572913300597, -9.8149083971518],
                [40.370444325706401, -7.8225851483296],
                [41.020342962761902, -5.8435684057062],
                [41.660638826337802, -3.8792599137441],
                [42.292614317416898, -1.9309866799349],
                [42.917474411461001, 0.0],
                [42.292614317416799, 1.930986679935],
                [41.660638826337802, 3.8792599137441],
                [41.020342962761902, 5.8435684057061],
                [40.370444325706401, 7.8225851483297],
                [39.709572913300597, 9.8149083971518],
                [39.036259685225403, 11.8190629570326],
                [38.348923669359998, 13.833501728208301],
                [37.6458573880155, 15.856607445789299],
                [36.925210342476198, 17.886694529407901],
                [36.184970251865103, 19.922010941354198],
                [35.422941692771701, 21.960739931659202],
                [34.636721728786597, 24.001001527009802],
                [33.823672053351203, 26.0408535968254],
                [32.980887094645098, 28.0782923038334],
                [32.105157447607198, 30.111251717508001],
                [31.1929279064897, 32.137602335985399],
                [30.2402492740319, 34.155148224638701],
                [29.242723025368001, 36.1616224362715],
                [28.1954378152594, 38.154680327657601],
                [27.0928967517948, 40.131890328734997],
                [25.928934344183499, 42.090721653148499],
                [24.696622108324298, 44.028528361754098],
                [23.388162047188501, 45.942529105132898],
                [21.994767715671401, 47.829781780752903],
                [20.506533487008699, 49.687152253258198],
                [18.912294193351698, 51.5112762182696],
                [17.199479858806399, 53.2985132695527],
                [15.353974267431401, 55.044892305118502],
                [13.359992280593801, 56.746047659779798],
                [11.2, 58.3971450553734],
                [9.0400077194064, 56.746047659779798],
                [7.0460257325687, 55.044892305118502],
                [5.2005201411937, 53.298513269552799],
                [3.4877058066484, 51.511276218269501],
                [1.8934665129913, 49.687152253258198],
                [0.4052322843287, 47.829781780752803],
                [-0.9881620471885, 45.942529105132699],
                [-2.2966221083241, 44.028528361754098],
                [-3.5289343441835, 42.0907216531483],
                [-4.6928967517948, 40.131890328734798],
                [-5.7954378152593, 38.154680327657601],
                [-6.8427230253679, 36.161622436271401],
                [-7.8402492740318, 34.155148224638801],
                [-8.7929279064896, 32.137602335985299],
                [-9.705157447607199, 30.111251717507798],
                [-10.580887094645, 28.078292303833301],
                [-11.423672053351099, 26.040853596825301],
                [-12.2367217287866, 24.001001527009901],
                [-13.0229416927716, 21.960739931659099],
                [-13.784970251864999, 19.922010941354198],
                [-14.5252103424762, 17.886694529407698],
                [-15.2458573880154, 15.856607445789299],
                [-15.9489236693599, 13.833501728208301],
                [-16.636259685225401, 11.8190629570325],
                [-17.309572913300599, 9.8149083971516],
                [-17.9704443257063, 7.8225851483296],
                [-18.6203429627618, 5.843568405706],
                [-19.260638826337701, 3.879259913744],
                [-19.8926143174168, 1.930986679935],
                [-20.517474411460999, 0.0],
            ],
        },
        {
            "zoneID": "5",
            "coordinates": [
                [11.200000000000101, -58.397145906270701],
                [11.200000001367, -60.4141337462584],
                [11.200000001446201, -62.448909836022104],
                [11.200000001541, -64.500480208212807],
                [11.200000001655299, -66.567794948093706],
                [11.200000001795299, -68.649750495713207],
                [11.2000000019693, -70.745192362074604],
                [11.200000002189901, -72.852918250607601],
                [11.2000000024772, -74.971681569472295],
                [11.200000002864201, -77.100195314734805],
                [11.2000000034112, -79.237136299104407],
                [11.2000000042373, -81.381149695791905],
                [11.200000005622201, -83.530853862272494],
                [11.2000000084037, -85.684845404419903],
                [11.200000016772099, -87.841704437704806],
                [11.2000005586941, -89.935243950448097],
                [44.226101611079201, -90.0],
                [191.199999441340509, -89.9352439523893],
                [191.199999983228196, -87.841704439646506],
                [191.199999991596201, -85.684845406359699],
                [191.199999994378203, -83.530853864209206],
                [191.199999995762909, -81.381149697723998],
                [191.199999996589099, -79.237136301031001],
                [191.199999997135791, -77.100195316654293],
                [191.199999997522809, -74.971681571383598],
                [191.199999997810011, -72.852918252509696],
                [191.199999998030705, -70.745192363965899],
                [191.199999998204504, -68.649750497593104],
                [191.199999998344509, -66.567794949960998],
                [191.199999998458992, -64.5004802100663],
                [191.199999998553693, -62.448909837861102],
                [191.19999999863299, -60.414133748081603],
                [191.2, -58.397145907431202],
                [187.481376436334699, -58.9674057360278],
                [183.614955723660501, -59.431319855533403],
                [179.621029560549289, -59.780479702952],
                [175.525507113828013, -60.007559744303997],
                [171.359192169569809, -60.106694054835302],
                [167.156504389356286, -60.073799010792001],
                [162.953747388575096, -59.906800373642099],
                [158.787126988777004, -59.605733553336499],
                [154.690782682414692, -59.172704079054299],
                [150.695092122087402, -58.611716767954299],
                [146.825443526067602, -57.928400998307701],
                [143.101568033603399, -57.129671184907899],
                [139.5374174053172, -56.2233641447623],
                [136.1414910740545, -55.217889693371802],
                [132.917474409481599, -54.121920641867803],
                [129.865045461387808, -52.9441368711054],
                [126.980728891478194, -51.693028018961499],
                [124.258709366899296, -50.376751920834799],
                [121.691551150664694, -49.003041535798303],
                [119.270799372760806, -47.5791512043578],
                [116.987459057582996, -46.111832971334202],
                [114.832360716464805, -44.607334639138301],
                [112.796427797007496, -43.071412622340901],
                [110.870863428862606, -41.509354174752502],
                [109.047273404663102, -39.926004940269799],
                [107.317740448964599, -38.325798941469401],
                [105.674862399962706, -36.712789042093299],
                [104.111764461942997, -35.090676617834198],
                [102.622093444624596, -33.462839678391703],
                [101.199999999196606, -31.832359040393399],
                [98.955431427485905, -31.186739538265901],
                [96.721979641432796, -30.496249798331899],
                [94.502028026567004, -29.761807026030201],
                [92.2977497155333, -28.9845165980093],
                [90.111095977489697, -28.1656623121076],
                [87.943789269904997, -27.306695088265599],
                [85.797320724515004, -26.4092203947461],
                [83.672951713221906, -25.4749846742559],
                [81.571719045327796, -24.5058610356302],
                [79.494443285329993, -23.503834460676199],
                [77.441739648938096, -22.470986754643899],
                [75.414030930629394, -21.409481444599301],
                [73.411561934400893, -20.3215488044575],
                [71.434414915330194, -19.2094711600073],
                [69.482525588016898, -18.075568603015999],
                [67.555699314124794, -16.9221852211497],
                [65.653627140906593, -15.7516759303887],
                [63.775901422331003, -14.566393979017001],
                [61.922030811554201, -13.3686791770334],
                [60.091454466146999, -12.1608468917984],
                [58.283555354447998, -10.945177839584501],
                [56.497672592079901, -9.723908693144899],
                [54.733112771868399, -8.4992235171283],
                [52.989160278315701, -7.273246035865],
                [51.265086599866997, -6.0480327315058],
                [49.560158669015699, -4.8255667645253],
                [47.873646272511699, -3.607752703075],
                [46.204828582243699, -2.3964120425435],
                [44.552999862424002, -1.1932794918931],
                [42.917474411461001, 0.0],
                [42.292614317416898, -1.9309866799349],
                [41.660638826337802, -3.8792599137441],
                [41.020342962761902, -5.8435684057062],
                [40.370444325706401, -7.8225851483296],
                [39.709572913300597, -9.8149083971518],
                [39.036259685225403, -11.8190629570325],
                [38.348923669359998, -13.833501728208301],
                [37.6458573880155, -15.8566074457891],
                [36.925210342476298, -17.886694529407698],
                [36.184970251865103, -19.922010941354198],
                [35.422941692771701, -21.960739931659099],
                [34.636721728786597, -24.001001527009901],
                [33.823672053351203, -26.040853596825301],
                [32.980887094645098, -28.078292303833301],
                [32.105157447607297, -30.111251717507901],
                [31.1929279064897, -32.137602335985299],
                [30.2402492740319, -34.155148224638602],
                [29.242723025368001, -36.161622436271401],
                [28.1954378152594, -38.154680327657601],
                [27.0928967517948, -40.131890328734897],
                [25.928934344183499, -42.0907216531484],
                [24.696622108324298, -44.028528361754098],
                [23.388162047188601, -45.942529105132799],
                [21.994767715671401, -47.829781780752903],
                [20.506533487008799, -49.687152253258098],
                [18.912294193351698, -51.5112762182696],
                [17.199479858806601, -53.298513269552501],
                [15.353974267431299, -55.044892305118502],
                [13.3599922805936, -56.746047659779897],
                [11.200000000000101, -58.397145906270701],
            ],
        },
        {
            "zoneID": "6",
            "coordinates": [
                [42.917474411461001, 0.0],
                [44.552999862424002, -1.1932794918931],
                [46.2048285822436, -2.3964120425435],
                [47.873646272511699, -3.607752703075],
                [49.560158669015699, -4.8255667645253],
                [51.265086599866997, -6.0480327315058],
                [52.989160278315701, -7.273246035865],
                [54.733112771868399, -8.4992235171283],
                [56.497672592079901, -9.723908693144899],
                [58.283555354447998, -10.945177839584501],
                [60.091454466146999, -12.1608468917984],
                [61.922030811554201, -13.3686791770334],
                [63.775901422331003, -14.566393979017001],
                [65.653627140906593, -15.7516759303887],
                [67.555699314124794, -16.9221852211497],
                [69.482525588016898, -18.075568603015999],
                [71.434414915330194, -19.2094711600073],
                [73.411561934400893, -20.3215488044575],
                [75.414030930629394, -21.409481444599301],
                [77.441739648938096, -22.470986754643899],
                [79.494443285329993, -23.503834460676199],
                [81.571719045327796, -24.5058610356302],
                [83.672951713221906, -25.4749846742559],
                [85.797320724515004, -26.4092203947461],
                [87.943789269904997, -27.306695088265599],
                [90.111095977489697, -28.1656623121076],
                [92.2977497155333, -28.9845165980093],
                [94.502028026567004, -29.761807026030201],
                [96.721979641432796, -30.496249798331899],
                [98.955431427485905, -31.186739538265901],
                [101.199999999196606, -31.832359040393399],
                [101.199999999220495, -29.806710312032902],
                [101.199999999242195, -27.762080686735899],
                [101.199999999261806, -25.6994901616589],
                [101.199999999279399, -23.620025158154402],
                [101.199999999295102, -21.5248363225109],
                [101.1999999993091, -19.415135755413399],
                [101.199999999321406, -17.2921936703708],
                [101.199999999332107, -15.1573344905289],
                [101.199999999341202, -13.011932402883399],
                [101.199999999348805, -10.857406398669999],
                [101.199999999355001, -8.6952148384047],
                [101.199999999359804, -6.5268495893572],
                [101.1999999993632, -4.3538297919047],
                [101.199999999365204, -2.1776953189385],
                [101.1999999993659, 0.0000000009802],
                [101.199999999365204, 2.177695320898],
                [101.1999999993632, 4.3538297938623],
                [101.199999999359704, 6.526849591311],
                [101.199999999355001, 8.695214840353801],
                [101.199999999348805, 10.857406400612801],
                [101.199999999341202, 13.0119324048186],
                [101.199999999332107, 15.1573344924554],
                [101.199999999321406, 17.292193672286999],
                [101.1999999993091, 19.415135757318499],
                [101.199999999295201, 21.5248363244032],
                [101.199999999279399, 23.6200251600333],
                [101.199999999261806, 25.699490163523201],
                [101.199999999242195, 27.762080688584501],
                [101.199999999220495, 29.806710313864802],
                [101.200000000000102, 31.832359041336101],
                [99.777906554076594, 33.4628396775799],
                [98.288235536759103, 35.090676617013997],
                [96.725137598739806, 36.7127890412632],
                [95.082259549738097, 38.325798940627898],
                [93.352726594040206, 39.926004939415201],
                [91.529136569841796, 41.509354173883203],
                [89.603572201698995, 43.071412621455202],
                [87.567639282245494, 44.607334638234498],
                [85.412540941133599, 46.111832970410397],
                [83.129200625965396, 47.579151203412302],
                [80.708448848075406, 49.0030415348293],
                [78.1412906318605, 50.3767519198407],
                [75.419271107307694, 51.693028017941003],
                [72.534954537432796, 52.944136870057001],
                [69.482525589383798, 54.121920640790499],
                [66.2585089248673, 55.217889692264798],
                [62.862582593673999, 56.223364143625602],
                [59.2984319654717, 57.129671183741699],
                [55.574556473106497, 57.928400997113002],
                [51.7049078772013, 58.611716766732698],
                [47.7092173170035, 59.172704077808099],
                [43.612873010783801, 59.605733552068898],
                [39.446252611139698, 59.9068003723565],
                [35.243495610519901, 60.073799009492497],
                [31.0408078304723, 60.106694053526297],
                [26.8744928863802, 60.007559742989699],
                [22.778970439820199, 59.780479701636501],
                [18.785044276864198, 59.431319854220803],
                [14.9186235643353, 58.967405734721403],
                [11.2, 58.3971450553734],
                [13.3599922826306, 56.746047660539297],
                [15.3539742694011, 55.044892305839298],
                [17.199479860710198, 53.298513270238203],
                [18.9122941951914, 51.5112762189233],
                [20.5065334887876, 49.6871522538829],
                [21.994767717392602, 47.829781781351301],
                [23.3881620488559, 45.9425291057075],
                [24.696622109941401, 44.028528362307398],
                [25.928934345754399, 42.090721653682301],
                [27.0928967533231, 40.131890329251299],
                [28.195437816748701, 38.154680328158499],
                [29.242723026821999, 36.1616224367583],
                [30.240249275454101, 34.155148225113201],
                [31.192927907883401, 32.137602336448602],
                [32.105157448975497, 30.111251717961501],
                [32.980887095991001, 28.078292304278399],
                [33.823672054677601, 26.040853597262998],
                [34.636721730096497, 24.0010015274413],
                [35.422941694067603, 21.9607399320852],
                [36.1849702531497, 19.922010941776001],
                [36.925210343752099, 17.886694529826102],
                [37.645857389284998, 15.8566074462051],
                [38.348923670625503, 13.833501728622499],
                [39.036259686489203, 11.8190629574458],
                [39.709572914565101, 9.814908397564899],
                [40.370444326973598, 7.8225851487436],
                [41.0203429640341, 5.8435684061214],
                [41.660638827617198, 3.8792599141617],
                [42.292614318705503, 1.9309866803556],
                [42.917474411461001, 0.0],
            ],
        },
        {
            "zoneID": "7",
            "coordinates": [
                [101.199999999196606, -31.832359040393399],
                [102.622093445923497, -33.4628396775799],
                [104.111764463241101, -35.090676617013898],
                [105.674862401260398, -36.7127890412632],
                [107.317740450261994, -38.325798940627799],
                [109.047273405959899, -39.926004939415101],
                [110.870863430158494, -41.509354173883203],
                [112.796427798301096, -43.071412621455103],
                [114.832360717754696, -44.607334638234398],
                [116.987459058866605, -46.111832970410397],
                [119.270799374034794, -47.579151203412302],
                [121.691551151924699, -49.003041534829201],
                [124.258709368139804, -50.3767519198408],
                [126.980728892692497, -51.693028017941003],
                [129.865045462567196, -52.944136870057001],
                [132.917474410616506, -54.121920640790499],
                [136.141491075132791, -55.217889692264798],
                [139.537417406326313, -56.223364143625503],
                [143.101568034528412, -57.1296711837416],
                [146.825443526893707, -57.928400997112902],
                [150.695092122798798, -58.611716766732599],
                [154.690782682996513, -59.172704077808099],
                [158.78712698921629, -59.605733552068799],
                [162.953747388860108, -59.9068003723564],
                [167.15650438948029, -60.073799009492397],
                [171.359192169527887, -60.106694053526198],
                [175.525507113620108, -60.007559742989599],
                [179.621029560179807, -59.780479701636402],
                [183.614955723135608, -59.431319854220703],
                [187.481376435665311, -58.967405734721197],
                [191.2, -58.397145907431202],
                [189.040007717369491, -56.746047660539197],
                [187.046025730599098, -55.044892305839298],
                [185.200520139290006, -53.298513270238203],
                [183.487705804808712, -51.5112762189233],
                [181.893466511212608, -49.6871522538828],
                [180.4052322826075, -47.8297817813514],
                [179.011837951144201, -45.942529105707301],
                [177.70337789005859, -44.028528362307298],
                [176.471065654245706, -42.090721653682202],
                [175.307103246677002, -40.131890329251398],
                [174.204562183251312, -38.154680328158399],
                [173.157276973178114, -36.1616224367583],
                [172.159750724546001, -34.155148225113003],
                [171.207072092116789, -32.137602336448602],
                [170.294842551024601, -30.111251717961402],
                [169.419112904009097, -28.0782923042783],
                [168.57632794532239, -26.040853597262899],
                [167.763278269903594, -24.001001527441201],
                [166.977058305932502, -21.960739932085101],
                [166.215029746850291, -19.922010941775799],
                [165.474789656247992, -17.886694529825999],
                [164.754142610715093, -15.856607446204899],
                [164.051076329374609, -13.8335017286224],
                [163.363740313510903, -11.8190629574457],
                [162.69042708543509, -9.814908397565],
                [162.029555673026493, -7.8225851487434],
                [161.379657035966005, -5.8435684061215],
                [160.7393611723829, -3.8792599141617],
                [160.107385681294488, -1.9309866803555],
                [159.482525588179698, 0.0000000011109],
                [157.847000136892802, 1.1932794940725],
                [156.195171417050801, 2.3964120447222],
                [154.526353726759993, 3.6077527052524],
                [152.839841330232701, 4.8255667667013],
                [151.134913399357487, 6.0480327336798],
                [149.410839720884695, 7.2732460380363],
                [147.666887227307086, 8.4992235192964],
                [145.902327407070288, 9.723908695308999],
                [144.116444644676307, 10.945177841743901],
                [142.308545532950802, 12.1608468939523],
                [140.477969187516493, 13.3686791791808],
                [138.624098576711901, 14.5663939811571],
                [136.746372858107691, 15.751675932520699],
                [134.844300684860798, 16.9221852232724],
                [132.917474410938894, 18.075568605128598],
                [130.965585083595613, 19.209471162108699],
                [128.988438064494005, 20.3215488065469],
                [126.985969068234297, 21.4094814466755],
                [124.958260349893905, 22.4709867567061],
                [122.905556713469494, 23.503834462723599],
                [120.828280953439304, 24.505861037661798],
                [118.727048285512296, 25.474984676270999],
                [116.602679274186002, 26.409220396744001],
                [114.456210728762898, 27.306695090245402],
                [112.2889040211451, 28.1656623140689],
                [110.102250283068003, 28.984516599951601],
                [107.897971972001599, 29.761807027953001],
                [105.678020357103094, 30.496249800235098],
                [103.444568571017996, 31.186739540149201],
                [101.200000000000102, 31.832359041336101],
                [101.199999999220495, 29.806710313864802],
                [101.199999999242294, 27.762080688584401],
                [101.199999999261806, 25.699490163523201],
                [101.199999999279399, 23.6200251600333],
                [101.199999999295201, 21.5248363244032],
                [101.1999999993091, 19.415135757318499],
                [101.199999999321406, 17.292193672286999],
                [101.199999999332107, 15.1573344924554],
                [101.199999999341202, 13.0119324048186],
                [101.199999999348805, 10.857406400612801],
                [101.199999999355001, 8.695214840353801],
                [101.199999999359704, 6.526849591311],
                [101.1999999993632, 4.3538297938623],
                [101.199999999365204, 2.177695320898],
                [101.1999999993659, 0.0000000009802],
                [101.199999999365204, -2.1776953189385],
                [101.1999999993632, -4.3538297919047],
                [101.199999999359804, -6.5268495893572],
                [101.199999999355001, -8.6952148384047],
                [101.199999999348805, -10.857406398669999],
                [101.199999999341202, -13.011932402883399],
                [101.199999999332107, -15.1573344905289],
                [101.199999999321406, -17.2921936703708],
                [101.1999999993091, -19.415135755413399],
                [101.199999999295102, -21.5248363225109],
                [101.199999999279399, -23.620025158154402],
                [101.199999999261806, -25.6994901616589],
                [101.199999999242195, -27.762080686735899],
                [101.199999999220495, -29.806710312032902],
                [101.199999999196606, -31.832359040393399],
            ],
        },
        {
            "zoneID": "8",
            "coordinates": [
                [101.200000000000102, 31.832359041336101],
                [103.444568571017996, 31.186739540149201],
                [105.678020357103094, 30.496249800235098],
                [107.897971972001599, 29.761807027953001],
                [110.102250283068102, 28.984516599951501],
                [112.2889040211451, 28.1656623140689],
                [114.456210728762898, 27.306695090245402],
                [116.602679274186002, 26.409220396744001],
                [118.727048285512296, 25.474984676270999],
                [120.828280953439304, 24.505861037661798],
                [122.905556713469494, 23.503834462723599],
                [124.958260349893905, 22.4709867567061],
                [126.985969068234297, 21.4094814466755],
                [128.988438064494005, 20.3215488065469],
                [130.965585083595613, 19.209471162108699],
                [132.917474410938894, 18.075568605128598],
                [134.844300684860798, 16.9221852232724],
                [136.746372858107691, 15.751675932520699],
                [138.624098576711901, 14.5663939811571],
                [140.477969187516493, 13.3686791791809],
                [142.308545532950802, 12.1608468939523],
                [144.116444644676307, 10.945177841743901],
                [145.902327407070288, 9.723908695308999],
                [147.666887227307086, 8.4992235192964],
                [149.410839720884695, 7.2732460380363],
                [151.134913399357487, 6.0480327336798],
                [152.839841330232701, 4.8255667667013],
                [154.526353726759993, 3.6077527052524],
                [156.195171417050801, 2.3964120447222],
                [157.847000136892802, 1.1932794940725],
                [159.482525588179698, 0.0000000011109],
                [160.10738568185991, 1.9309866821015],
                [160.739361172955199, 3.8792599159227],
                [161.379657036546405, 5.8435684078964],
                [162.029555673616102, 7.8225851505309],
                [162.690427086035299, 9.8149083993637],
                [163.363740314122907, 11.8190629592545],
                [164.05107633, 13.833501730439499],
                [164.754142611355405, 15.8566074480292],
                [165.474789656905187, 17.886694531655898],
                [166.215029747526103, 19.9220109436095],
                [166.977058306628805, 21.960739933921001],
                [167.763278270622806, 24.001001529277602],
                [168.576327946067209, 26.040853599098199],
                [169.419112904781912, 28.078292306110399],
                [170.294842551828708, 30.111251719788601],
                [171.207072092955286, 32.137602338268699],
                [172.159750725423009, 34.155148226924403],
                [173.157276974097414, 36.161622438558503],
                [174.204562184217991, 38.154680329945599],
                [175.307103247696091, 40.131890331023101],
                [176.471065655323002, 42.090721655436298],
                [177.703377891201001, 44.0285283640413],
                [179.011837952358604, 45.942529107418501],
                [180.405232283902706, 47.8297817830369],
                [181.893466512597712, 49.687152255539999],
                [183.487705806294997, 51.511276220549],
                [185.200520140889211, 53.298513271829101],
                [187.046025732324495, 55.0448923073914],
                [189.040007719236314, 56.746047662048802],
                [191.200000000000102, 58.397145907431202],
                [191.199999998633189, 60.4141337462584],
                [191.199999998554006, 62.448909836022104],
                [191.199999998459305, 64.500480208212693],
                [191.199999998344907, 66.567794948093706],
                [191.199999998204788, 68.649750495713405],
                [191.199999998030989, 70.745192362074505],
                [191.199999997810409, 72.852918250607601],
                [191.199999997523406, 74.971681569472196],
                [191.199999997136104, 77.100195314734805],
                [191.199999996589611, 79.237136299104407],
                [191.199999995763505, 81.381149695791805],
                [191.199999994378913, 83.530853862272394],
                [191.199999991597508, 85.684845404419804],
                [191.1999999832301, 87.841704437704806],
                [191.199999441414803, 89.935243950448097],
                [158.175239553600306, 90.0],
                [11.2000005585951, 89.9352439523893],
                [11.200000016769, 87.841704439646705],
                [11.2000000084023, 85.684845406359898],
                [11.2000000056213, 83.530853864209305],
                [11.2000000042366, 81.381149697724197],
                [11.2000000034104, 79.237136301031001],
                [11.2000000028636, 77.100195316654407],
                [11.2000000024769, 74.971681571383698],
                [11.200000002189499, 72.852918252509596],
                [11.200000001969, 70.745192363965998],
                [11.200000001795001, 68.649750497593303],
                [11.2000000016552, 66.567794949960998],
                [11.200000001540801, 64.500480210066499],
                [11.200000001446, 62.448909837861102],
                [11.2000000013667, 60.414133748082001],
                [11.2, 58.397145907431202],
                [14.9186235636652, 58.967405736027899],
                [18.7850442763392, 59.431319855533502],
                [22.778970439450099, 59.780479702951901],
                [26.874492886172, 60.007559744304103],
                [31.0408078304303, 60.106694054835401],
                [35.243495610643599, 60.073799010792101],
                [39.446252611425102, 59.906800373642099],
                [43.612873011222803, 59.605733553336698],
                [47.709217317585598, 59.172704079054299],
                [51.704907877912703, 58.611716767954398],
                [55.574556473932397, 57.928400998307801],
                [59.298431966396699, 57.129671184907998],
                [62.8625825946826, 56.2233641447624],
                [66.258508925945705, 55.217889693371902],
                [69.482525590518506, 54.121920641867902],
                [72.534954538612197, 52.944136871105599],
                [75.419271108521897, 51.693028018961598],
                [78.141290633100894, 50.376751920834899],
                [80.708448849335397, 49.003041535798303],
                [83.129200627239101, 47.579151204357899],
                [85.412540942416996, 46.111832971334302],
                [87.5676392835352, 44.6073346391385],
                [89.603572202992694, 43.071412622341001],
                [91.529136571137499, 41.509354174752602],
                [93.352726595337103, 39.926004940269898],
                [95.082259551035605, 38.325798941469401],
                [96.7251376000373, 36.712789042093497],
                [98.288235538057094, 35.090676617834298],
                [99.777906555375395, 33.462839678391902],
                [101.200000000000102, 31.832359041336101],
            ],
        },
        {
            "zoneID": "9",
            "coordinates": [
                [-200.517474411820302, 0.0000000011109],
                [-199.892614317416786, -1.930986679935],
                [-199.260638826337697, -3.8792599137441],
                [-198.620342962761697, -5.8435684057062],
                [-197.970444325706296, -7.8225851483297],
                [-197.309572913300514, -9.8149083971518],
                [-196.636259685225298, -11.8190629570326],
                [-195.9489236693598, -13.833501728208301],
                [-195.245857388015395, -15.856607445789299],
                [-194.525210342475987, -17.886694529407901],
                [-193.784970251864991, -19.922010941354198],
                [-193.02294169277161, -21.960739931659099],
                [-192.236721728786506, -24.001001527010001],
                [-191.423672053350998, -26.0408535968254],
                [-190.580887094644993, -28.0782923038334],
                [-189.705157447607206, -30.111251717508001],
                [-188.792927906489609, -32.137602335985299],
                [-187.840249274031692, -34.155148224638801],
                [-186.842723025367803, -36.161622436271401],
                [-185.795437815259191, -38.154680327657601],
                [-184.692896751794592, -40.131890328734897],
                [-183.528934344183398, -42.0907216531484],
                [-182.296622108323987, -44.028528361754098],
                [-180.98816204718841, -45.942529105132699],
                [-179.594767715671196, -47.829781780752903],
                [-178.10653348700879, -49.687152253258098],
                [-176.512294193351494, -51.5112762182696],
                [-174.799479858806308, -53.2985132695526],
                [-172.953974267431192, -55.044892305118402],
                [-170.959992280593298, -56.746047659780103],
                [-168.8, -58.397145907431202],
                [-166.640007719406213, -56.746047659779798],
                [-164.646025732568404, -55.044892305118402],
                [-162.800520141193488, -53.2985132695526],
                [-161.087705806648302, -51.511276218269501],
                [-159.493466512991006, -49.687152253257999],
                [-158.005232284328514, -47.829781780752803],
                [-156.6118379528113, -45.942529105132799],
                [-155.303377891675694, -44.028528361753999],
                [-154.071065655816312, -42.0907216531483],
                [-152.907103248205203, -40.131890328734798],
                [-151.80456218474049, -38.154680327657601],
                [-150.757276974632106, -36.161622436271401],
                [-149.759750725968104, -34.155148224638701],
                [-148.807072093510186, -32.137602335985299],
                [-147.894842552392703, -30.111251717507901],
                [-147.019112905354802, -28.0782923038334],
                [-146.176327946648797, -26.040853596825301],
                [-145.363278271213289, -24.001001527009901],
                [-144.577058307228299, -21.960739931658999],
                [-143.815029748134805, -19.922010941353999],
                [-143.074789657523809, -17.886694529407698],
                [-142.3541426119844, -15.8566074457891],
                [-141.651076330640109, -13.833501728208301],
                [-140.963740314774498, -11.8190629570325],
                [-140.29042708669931, -9.814908397151701],
                [-139.629555674293613, -7.8225851483295],
                [-138.979657037238098, -5.8435684057061],
                [-138.339361173662212, -3.879259913744],
                [-137.707385682583094, -1.9309866799349],
                [-137.082525588725503, 0.0000000005766],
                [-137.707385682401991, 1.9309866815759],
                [-138.339361173494297, 3.8792599154043],
                [-138.979657037082688, 5.8435684073836],
                [-139.629555674150112, 7.8225851500225],
                [-140.290427086567604, 9.814908398858201],
                [-140.963740314654103, 11.8190629587505],
                [-141.651076330530714, 13.833501729936],
                [-142.35414261188609, 15.856607447525001],
                [-143.074789657436412, 17.886694531149899],
                [-143.815029748058492, 19.922010943100901],
                [-144.577058307163213, 21.960739933408998],
                [-145.363278271160112, 24.001001528761599],
                [-146.176327946607813, 26.040853598577598],
                [-147.019112905326807, 28.078292305584601],
                [-147.894842552378691, 30.1112517192573],
                [-148.807072093511294, 32.1376023377317],
                [-149.759750725985811, 34.1551482263813],
                [-150.757276974668201, 36.161622438009402],
                [-151.804562184797703, 38.154680329390402],
                [-152.907103248285807, 40.1318903304619],
                [-154.071065655923888, 42.0907216548691],
                [-155.303377891814108, 44.028528363468297],
                [-156.611837952985496, 45.942529106839899],
                [-158.005232284544292, 47.829781782452997],
                [-159.493466513255697, 49.687152254950803],
                [-161.087705806969893, 51.511276219954397],
                [-162.800520141582297, 53.298513271229297],
                [-164.646025733037305, 55.044892306786501],
                [-166.64000771996939, 56.746047661438503],
                [-168.799999999999898, 58.397145907431202],
                [-170.959992280763686, 56.746047662048802],
                [-172.953974267675505, 55.0448923073914],
                [-174.799479859110789, 53.298513271829101],
                [-176.512294193705003, 51.511276220549],
                [-178.106533487402288, 49.687152255539999],
                [-179.594767716097294, 47.8297817830369],
                [-180.988162047641396, 45.942529107418501],
                [-182.296622108798999, 44.0285283640413],
                [-183.528934344677111, 42.090721655436298],
                [-184.692896752303909, 40.131890331023101],
                [-185.795437815782009, 38.154680329945599],
                [-186.842723025902586, 36.161622438558503],
                [-187.840249274577104, 34.155148226924403],
                [-188.792927907044714, 32.137602338268699],
                [-189.705157448171406, 30.111251719788601],
                [-190.580887095218003, 28.078292306110399],
                [-191.423672053932904, 26.040853599098199],
                [-192.236721729377194, 24.001001529277602],
                [-193.022941693371195, 21.960739933921101],
                [-193.784970252474011, 19.9220109436095],
                [-194.525210343094813, 17.886694531655898],
                [-195.245857388644595, 15.8566074480292],
                [-195.94892367, 13.833501730439499],
                [-196.636259685877093, 11.8190629592545],
                [-197.309572913964701, 9.8149083993637],
                [-197.970444326383898, 7.8225851505308],
                [-198.620342963453595, 5.8435684078964],
                [-199.260638827044801, 3.8792599159227],
                [-199.89261431814009, 1.9309866821015],
                [-200.517474411820302, 0.0000000011109],
            ],
        },
    ]

    geojson_features = []  # Store GeoJSON features

    for facet in facets:
        geojson_features.append(
            {
                "type": "Feature",
                "geometry": {"type": "Polygon", "coordinates": [facet["coordinates"]]},
                "properties": {"zoneID": facet["zoneID"]},
            }
        )

    # Save as GeoJSON with CRS
    geojson_output = {
        "type": "FeatureCollection",
        "name": "rhombic_icosahedron",
        "features": geojson_features,
    }

    with open(outFile, "w") as f:
        json.dump(geojson_output, f)

    print(f"rhombic_icosahedron saved as {outFile}")


if __name__ == "__main__":
    main()
