<a id="mypy-boto3-sqs"></a>

# mypy-boto3-sqs

[![PyPI - mypy-boto3-sqs](https://img.shields.io/pypi/v/mypy-boto3-sqs.svg?color=blue)](https://pypi.org/project/mypy-boto3-sqs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sqs.svg?color=blue)](https://pypi.org/project/mypy-boto3-sqs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-sqs?color=blue)](https://pypistats.org/packages/mypy-boto3-sqs)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SQS 1.19.0](https://boto3.amazonaws.com/v1/documentation/api/1.19.0/reference/services/sqs.html#SQS)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sqs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sqs/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sqs](#mypy-boto3-sqs)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `SQS` service.

```bash
python -m pip install boto3-stubs[sqs]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sqs]` in your environment:
  `python -m pip install 'boto3-stubs[sqs]'`

Both type checking and auto-complete should work for `SQS` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[sqs]` in your environment:
  `python -m pip install 'boto3-stubs[sqs]'`

Both type checking and auto-complete should work for `SQS` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sqs]` in your environment:
  `python -m pip install 'boto3-stubs[sqs]'`
- Run `mypy` as usual

Type checking should work for `SQS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sqs]` in your environment:
  `python -m pip install 'boto3-stubs[sqs]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SQS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SQSClient` provides annotations for `boto3.client("sqs")`.

```python
import boto3

from mypy_boto3_sqs import SQSClient

client: SQSClient = boto3.client("sqs")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SQSClient = session.client("sqs")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_sqs.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_sqs import SQSClient
from mypy_boto3_sqs.paginator import (
    ListDeadLetterSourceQueuesPaginator,
    ListQueuesPaginator,
)

client: SQSClient = boto3.client("sqs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_dead_letter_source_queues_paginator: ListDeadLetterSourceQueuesPaginator = client.get_paginator("list_dead_letter_source_queues")
list_queues_paginator: ListQueuesPaginator = client.get_paginator("list_queues")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`SQSServiceResource` provides annotations for `boto3.resource("sqs")`.

```python
from mypy_boto3_sqs import SQSServiceResource

resource: SQSServiceResource = boto3.resource("sqs")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: SQSServiceResource = session.resource("sqs")
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_sqs.service_resource` module contains type annotations for all
resources.

```python
from mypy_boto3_sqs import SQSServiceResource
from mypy_boto3_sqs.service_resource import (
    Message,
    Queue,
)

resource: SQSServiceResource = boto3.resource("sqs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_message: Message = resource.Message(...)
my_queue: Queue = resource.Queue(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_sqs.service_resource` module contains type annotations for all
`SQSServiceResource` collections.

```python
from mypy_boto3_sqs import SQSServiceResource
from mypy_boto3_sqs.service_resource import (
    ServiceResourceQueuesCollection,
)

resource: SQSServiceResource = boto3.resource("sqs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
queues: sqs_resources.ServiceResourceQueuesCollection = resource.queues
```

<a id="literals"></a>

### Literals

`mypy_boto3_sqs.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_sqs.literals import (
    ListDeadLetterSourceQueuesPaginatorName,
    ListQueuesPaginatorName,
    MessageSystemAttributeNameForSendsType,
    MessageSystemAttributeNameType,
    QueueAttributeNameType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ListDeadLetterSourceQueuesPaginatorName) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_sqs.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_sqs.type_defs import (
    AddPermissionRequestQueueTypeDef,
    AddPermissionRequestRequestTypeDef,
    BatchResultErrorEntryTypeDef,
    ChangeMessageVisibilityBatchRequestEntryTypeDef,
    ChangeMessageVisibilityBatchRequestQueueTypeDef,
    ChangeMessageVisibilityBatchRequestRequestTypeDef,
    ChangeMessageVisibilityBatchResultEntryTypeDef,
    ChangeMessageVisibilityBatchResultTypeDef,
    ChangeMessageVisibilityRequestMessageTypeDef,
    ChangeMessageVisibilityRequestRequestTypeDef,
    CreateQueueRequestRequestTypeDef,
    CreateQueueRequestServiceResourceTypeDef,
    CreateQueueResultTypeDef,
    DeleteMessageBatchRequestEntryTypeDef,
    DeleteMessageBatchRequestQueueTypeDef,
    DeleteMessageBatchRequestRequestTypeDef,
    DeleteMessageBatchResultEntryTypeDef,
    DeleteMessageBatchResultTypeDef,
    DeleteMessageRequestRequestTypeDef,
    DeleteQueueRequestRequestTypeDef,
    GetQueueAttributesRequestRequestTypeDef,
    GetQueueAttributesResultTypeDef,
    GetQueueUrlRequestRequestTypeDef,
    GetQueueUrlRequestServiceResourceTypeDef,
    GetQueueUrlResultTypeDef,
    ListDeadLetterSourceQueuesRequestRequestTypeDef,
    ListDeadLetterSourceQueuesResultTypeDef,
    ListQueueTagsRequestRequestTypeDef,
    ListQueueTagsResultTypeDef,
    ListQueuesRequestRequestTypeDef,
    ListQueuesResultTypeDef,
    MessageAttributeValueTypeDef,
    MessageSystemAttributeValueTypeDef,
    MessageTypeDef,
    PaginatorConfigTypeDef,
    PurgeQueueRequestRequestTypeDef,
    QueueMessageRequestTypeDef,
    ReceiveMessageRequestQueueTypeDef,
    ReceiveMessageRequestRequestTypeDef,
    ReceiveMessageResultTypeDef,
    RemovePermissionRequestQueueTypeDef,
    RemovePermissionRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    SendMessageBatchRequestEntryTypeDef,
    SendMessageBatchRequestQueueTypeDef,
    SendMessageBatchRequestRequestTypeDef,
    SendMessageBatchResultEntryTypeDef,
    SendMessageBatchResultTypeDef,
    SendMessageRequestQueueTypeDef,
    SendMessageRequestRequestTypeDef,
    SendMessageResultTypeDef,
    ServiceResourceMessageRequestTypeDef,
    ServiceResourceQueueRequestTypeDef,
    SetQueueAttributesRequestQueueTypeDef,
    SetQueueAttributesRequestRequestTypeDef,
    TagQueueRequestRequestTypeDef,
    UntagQueueRequestRequestTypeDef,
)

def get_structure() -> AddPermissionRequestQueueTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-sqs` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-sqs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sqs/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
