"""Top level imports, for easier usage."""

try:
    from . import _version  # type: ignore[attr-defined]

    __version__ = _version.__version__
    __commit_hash__ = _version.__commit_hash__

except ImportError:
    __version__ = "unknown"
    __commit_hash__ = "unknown"

from .column_identifier import (
    ACC_COL,
    A_X_COL,
    A_Y_COL,
    COUNT_COL,
    CROSSING_FRAME_COL,
    CUMULATED_COL,
    DENSITY_COL,
    DISTANCE_COL,
    END_POSITION_COL,
    FIRST_FRAME_COL,
    FLOW_COL,
    FRAME_COL,
    ID_COL,
    INTERSECTION_COL,
    LAST_FRAME_COL,
    MEAN_SPEED_COL,
    MID_FRAME_COL,
    MID_POSITION_COL,
    NEIGHBORS_COL,
    NEIGHBOR_ID_COL,
    POINT_COL,
    POLYGON_COL,
    SPEED_COL,
    START_POSITION_COL,
    TIME_COL,
    V_X_COL,
    V_Y_COL,
    WINDOW_SIZE_COL,
    X_COL,
    Y_COL,
)
from .data.geometry import (
    AxisAlignedMeasurementArea,
    MeasurementArea,
    MeasurementLine,
    WalkableArea,
)
from .data.trajectory_data import TrajectoryData
from .errors import (
    AccelerationError,
    GeometryError,
    InputError,
    PedPyAttributeError,
    PedPyError,
    PedPyRuntimeError,
    PedPyTypeError,
    PedPyValueError,
    SpeedError,
)
from .io.trajectory_loader import (
    TrajectoryUnit,
    load_trajectory,
    load_trajectory_from_crowdit,
    load_trajectory_from_jupedsim_sqlite,
    load_trajectory_from_pathfinder_csv,
    load_trajectory_from_pathfinder_json,
    load_trajectory_from_ped_data_archive_hdf5,
    load_trajectory_from_txt,
    load_trajectory_from_vadere,
    load_trajectory_from_viswalk,
    load_walkable_area_from_crowdit,
    load_walkable_area_from_jupedsim_sqlite,
    load_walkable_area_from_ped_data_archive_hdf5,
    load_walkable_area_from_vadere_scenario,
)
from .methods.acceleration_calculator import (
    compute_individual_acceleration,
    compute_mean_acceleration_per_frame,
    compute_voronoi_acceleration,
)
from .methods.density_calculator import (
    compute_classic_density,
    compute_line_density,
    compute_passing_density,
    compute_voronoi_density,
)
from .methods.flow_calculator import (
    compute_flow,
    compute_line_flow,
    compute_n_t,
)
from .methods.method_utils import (
    AccelerationCalculation,
    Cutoff,
    SpeedCalculation,
    compute_frame_range_in_area,
    compute_individual_voronoi_polygons,
    compute_intersecting_polygons,
    compute_neighbor_distance,
    compute_neighbors,
    compute_time_distance_line,
    get_invalid_trajectory,
    is_individual_speed_valid,
    is_species_valid,
    is_trajectory_valid,
)
from .methods.profile_calculator import (
    DensityMethod,
    SpeedMethod,
    compute_density_profile,
    compute_grid_cell_polygon_intersection_area,
    compute_profiles,
    compute_speed_profile,
    get_grid_cells,
)
from .methods.spatial_analysis import compute_pair_distribution_function
from .methods.speed_calculator import (
    compute_individual_speed,
    compute_line_speed,
    compute_mean_speed_per_frame,
    compute_passing_speed,
    compute_species,
    compute_voronoi_speed,
)
from .plotting.plotting import (
    PEDPY_BLUE,
    PEDPY_GREEN,
    PEDPY_GREY,
    PEDPY_ORANGE,
    PEDPY_PETROL,
    PEDPY_RED,
    plot_acceleration,
    plot_density,
    plot_density_at_line,
    plot_density_distribution,
    plot_flow,
    plot_flow_at_line,
    plot_measurement_setup,
    plot_neighborhood,
    plot_nt,
    plot_profiles,
    plot_speed,
    plot_speed_at_line,
    plot_speed_distribution,
    plot_time_distance,
    plot_trajectories,
    plot_voronoi_cells,
    plot_walkable_area,
)

__all__ = [  # noqa: RUF022 disable sorting of __all__ for better maintenance
    "AxisAlignedMeasurementArea",
    "MeasurementArea",
    "MeasurementLine",
    "WalkableArea",
    "TrajectoryData",
    "LoadTrajectoryError",
    "TrajectoryUnit",
    "load_trajectory",
    "load_trajectory_from_jupedsim_sqlite",
    "load_trajectory_from_ped_data_archive_hdf5",
    "load_trajectory_from_txt",
    "load_trajectory_from_viswalk",
    "load_trajectory_from_vadere",
    "load_walkable_area_from_jupedsim_sqlite",
    "load_walkable_area_from_ped_data_archive_hdf5",
    "load_walkable_area_from_vadere_scenario",
    "load_trajectory_from_pathfinder_csv",
    "load_trajectory_from_pathfinder_json",
    "load_walkable_area_from_crowdit",
    "load_trajectory_from_crowdit",
    "load_trajectory_from_pathfinder_csv",
    "load_trajectory_from_pathfinder_json",
    "compute_classic_density",
    "compute_line_density",
    "compute_passing_density",
    "compute_voronoi_density",
    "compute_flow",
    "compute_line_flow",
    "compute_n_t",
    "Cutoff",
    "compute_frame_range_in_area",
    "compute_individual_voronoi_polygons",
    "compute_intersecting_polygons",
    "compute_neighbors",
    "compute_neighbor_distance",
    "compute_time_distance_line",
    "get_invalid_trajectory",
    "is_individual_speed_valid",
    "is_species_valid",
    "is_trajectory_valid",
    "compute_pair_distribution_function",
    "DensityMethod",
    "SpeedMethod",
    "compute_density_profile",
    "compute_grid_cell_polygon_intersection_area",
    "compute_profiles",
    "compute_speed_profile",
    "get_grid_cells",
    "SpeedCalculation",
    "compute_individual_speed",
    "compute_line_speed",
    "compute_mean_speed_per_frame",
    "compute_passing_speed",
    "compute_species",
    "compute_voronoi_speed",
    "AccelerationCalculation",
    "compute_individual_acceleration",
    "compute_mean_acceleration_per_frame",
    "compute_voronoi_acceleration",
    "PEDPY_BLUE",
    "PEDPY_GREEN",
    "PEDPY_GREY",
    "PEDPY_ORANGE",
    "PEDPY_PETROL",
    "PEDPY_RED",
    "plot_density",
    "plot_density_at_line",
    "plot_density_distribution",
    "plot_flow",
    "plot_flow_at_line",
    "plot_measurement_setup",
    "plot_neighborhood",
    "plot_nt",
    "plot_profiles",
    "plot_speed",
    "plot_speed_at_line",
    "plot_speed_distribution",
    "plot_time_distance",
    "plot_trajectories",
    "plot_voronoi_cells",
    "plot_walkable_area",
    "plot_acceleration",
    "ID_COL",
    "FRAME_COL",
    "X_COL",
    "Y_COL",
    "POINT_COL",
    "DENSITY_COL",
    "POLYGON_COL",
    "INTERSECTION_COL",
    "COUNT_COL",
    "CUMULATED_COL",
    "TIME_COL",
    "SPEED_COL",
    "V_X_COL",
    "V_Y_COL",
    "FLOW_COL",
    "MEAN_SPEED_COL",
    "ACC_COL",
    "A_X_COL",
    "A_Y_COL",
    "FIRST_FRAME_COL",
    "MID_FRAME_COL",
    "LAST_FRAME_COL",
    "NEIGHBORS_COL",
    "NEIGHBOR_ID_COL",
    "DISTANCE_COL",
    "CROSSING_FRAME_COL",
    "START_POSITION_COL",
    "MID_POSITION_COL",
    "END_POSITION_COL",
    "WINDOW_SIZE_COL",
    "__version__",
    "AccelerationError",
    "GeometryError",
    "InputError",
    "PedPyAttributeError",
    "PedPyError",
    "PedPyRuntimeError",
    "PedPyTypeError",
    "PedPyValueError",
    "SpeedError",
]
