# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DatabaseFaultInjectionSchedule(BaseModel):
    """
    DatabaseFaultInjectionSchedule
    """ # noqa: E501
    benchmark: Optional[StrictStr] = Field(default=None, description="基准数据库")
    created_at: Optional[StrictStr] = Field(default=None, description="创建时间")
    description: Optional[StrictStr] = Field(default=None, description="描述（可选字段）")
    display_config: Optional[StrictStr] = Field(default=None, description="面向用户的展示配置")
    end_time: Optional[StrictStr] = Field(default=None, description="预计故障结束时间")
    engine_config: Optional[StrictStr] = Field(default=None, description="面向系统的运行配置")
    fault_type: Optional[StrictInt] = Field(default=None, description="故障类型")
    id: Optional[StrictInt] = Field(default=None, description="唯一标识")
    injection_name: Optional[StrictStr] = Field(default=None, description="在k8s资源里注入的名字")
    labels: Optional[Dict[str, StrictStr]] = Field(default=None, description="用户自定义标签，JSONB格式存储 key-value pairs")
    pre_duration: Optional[StrictInt] = Field(default=None, description="正常数据时间")
    start_time: Optional[StrictStr] = Field(default=None, description="预计故障开始时间")
    status: Optional[StrictInt] = Field(default=None, description="-1: 已删除 0: 初始状态 1: 注入结束且失败 2: 注入结束且成功 3: 收集数据失败 4:收集数据成功")
    task_id: Optional[StrictStr] = Field(default=None, description="从属什么 taskid")
    updated_at: Optional[StrictStr] = Field(default=None, description="更新时间")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["benchmark", "created_at", "description", "display_config", "end_time", "engine_config", "fault_type", "id", "injection_name", "labels", "pre_duration", "start_time", "status", "task_id", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatabaseFaultInjectionSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatabaseFaultInjectionSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "benchmark": obj.get("benchmark"),
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "display_config": obj.get("display_config"),
            "end_time": obj.get("end_time"),
            "engine_config": obj.get("engine_config"),
            "fault_type": obj.get("fault_type"),
            "id": obj.get("id"),
            "injection_name": obj.get("injection_name"),
            "labels": obj.get("labels"),
            "pre_duration": obj.get("pre_duration"),
            "start_time": obj.get("start_time"),
            "status": obj.get("status"),
            "task_id": obj.get("task_id"),
            "updated_at": obj.get("updated_at")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


