# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DtoDetectorRecord(BaseModel):
    """
    DtoDetectorRecord
    """ # noqa: E501
    abnormal_avg_duration: Optional[Union[StrictFloat, StrictInt]] = None
    abnormal_p90: Optional[Union[StrictFloat, StrictInt]] = None
    abnormal_p95: Optional[Union[StrictFloat, StrictInt]] = None
    abnormal_p99: Optional[Union[StrictFloat, StrictInt]] = None
    abnormal_succ_rate: Optional[Union[StrictFloat, StrictInt]] = None
    issue: Optional[StrictStr] = None
    normal_avg_duration: Optional[Union[StrictFloat, StrictInt]] = None
    normal_p90: Optional[Union[StrictFloat, StrictInt]] = None
    normal_p95: Optional[Union[StrictFloat, StrictInt]] = None
    normal_p99: Optional[Union[StrictFloat, StrictInt]] = None
    normal_succ_rate: Optional[Union[StrictFloat, StrictInt]] = None
    span_name: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["abnormal_avg_duration", "abnormal_p90", "abnormal_p95", "abnormal_p99", "abnormal_succ_rate", "issue", "normal_avg_duration", "normal_p90", "normal_p95", "normal_p99", "normal_succ_rate", "span_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoDetectorRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoDetectorRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "abnormal_avg_duration": obj.get("abnormal_avg_duration"),
            "abnormal_p90": obj.get("abnormal_p90"),
            "abnormal_p95": obj.get("abnormal_p95"),
            "abnormal_p99": obj.get("abnormal_p99"),
            "abnormal_succ_rate": obj.get("abnormal_succ_rate"),
            "issue": obj.get("issue"),
            "normal_avg_duration": obj.get("normal_avg_duration"),
            "normal_p90": obj.get("normal_p90"),
            "normal_p95": obj.get("normal_p95"),
            "normal_p99": obj.get("normal_p99"),
            "normal_succ_rate": obj.get("normal_succ_rate"),
            "span_name": obj.get("span_name")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


