# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rcabench.openapi.models.dto_detector_record import DtoDetectorRecord
from rcabench.openapi.models.dto_execution_record import DtoExecutionRecord
from typing import Optional, Set
from typing_extensions import Self

class DtoQueryDatasetResp(BaseModel):
    """
    DtoQueryDatasetResp
    """ # noqa: E501
    detector_result: Optional[DtoDetectorRecord] = None
    end_time: Optional[StrictStr] = None
    execution_results: Optional[List[DtoExecutionRecord]] = None
    name: Optional[StrictStr] = None
    param: Optional[List[Dict[str, Any]]] = None
    start_time: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["detector_result", "end_time", "execution_results", "name", "param", "start_time"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DtoQueryDatasetResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of detector_result
        if self.detector_result:
            _dict['detector_result'] = self.detector_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in execution_results (list)
        _items = []
        if self.execution_results:
            for _item_execution_results in self.execution_results:
                if _item_execution_results:
                    _items.append(_item_execution_results.to_dict())
            _dict['execution_results'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DtoQueryDatasetResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "detector_result": DtoDetectorRecord.from_dict(obj["detector_result"]) if obj.get("detector_result") is not None else None,
            "end_time": obj.get("end_time"),
            "execution_results": [DtoExecutionRecord.from_dict(_item) for _item in obj["execution_results"]] if obj.get("execution_results") is not None else None,
            "name": obj.get("name"),
            "param": obj.get("param"),
            "start_time": obj.get("start_time")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


