# Ragbits Guardrails

Ragbits Guardrails is a Python package that contains utilities for ensuring the safety and relevance of responses generated by Ragbits components.

## Installation

You can install the latest version of Ragbits Guardrails using pip:

```bash
pip install ragbits-guardrails
```

## Quickstart
Example of using the OpenAI Moderation Guardrail to verify a message:

```python
import asyncio
from ragbits.guardrails.base import GuardrailManager, GuardrailVerificationResult
from ragbits.guardrails.openai_moderation import OpenAIModerationGuardrail


async def verify_message(message: str) -> list[GuardrailVerificationResult]:
    manager = GuardrailManager([OpenAIModerationGuardrail()])
    return await manager.verify(message)


if __name__ == '__main__':
    print(asyncio.run(verify_message("Test message")))
```

## Documentation
* [How-To Guides - Guardrails](https://ragbits.deepsense.ai/how-to/use_guardrails/)
<!--
TODO:
* Add link to API Reference once classes from the Guardrails package are added to the API Reference.
-->
