"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDeployment = exports.ServiceType = void 0;
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
var ServiceType;
(function (ServiceType) {
    ServiceType["EXTERNAL_NAME"] = "ExternalName";
    ServiceType["CLUSTER_IP"] = "ClusterIP";
    ServiceType["NODE_PORT"] = "NodePort";
    ServiceType["LOAD_BALANCER"] = "LoadBalancer";
})(ServiceType || (exports.ServiceType = ServiceType = {}));
class ServiceDeployment extends constructs_1.Construct {
    constructor(scope, id, options) {
        super(scope, id);
        const replicas = options.replicas ?? 1;
        const resources = options.resources ?? { requests: { cpu: '100m', memory: '100Mi' } };
        const externalPort = options.externalPort ?? 80;
        const containerPort = options.containerPort ?? 8080;
        const containerName = options.containerName ?? 'app';
        const serviceType = options.serviceType ?? ServiceType.CLUSTER_IP;
        const label = {
            ...options.labels,
            app: this.node.addr,
        };
        const service = new k8s.Service(this, 'service', {
            metadata: { labels: label },
            spec: {
                type: serviceType,
                ports: [{ port: externalPort, targetPort: containerPort }],
                selector: label,
            },
        });
        new k8s.Deployment(this, 'deployment', {
            spec: {
                selector: { matchLabels: label },
                replicas: replicas,
                template: {
                    metadata: { labels: label },
                    spec: {
                        containers: [
                            {
                                name: containerName,
                                image: options.image,
                                ports: [{ containerPort }],
                                resources: resources,
                                env: renderEnv(options.env),
                            },
                        ],
                    },
                },
            },
        });
        this.host = service.name;
    }
}
exports.ServiceDeployment = ServiceDeployment;
function renderEnv(env = {}) {
    const result = new Array();
    for (const [key, value] of Object.entries(env)) {
        result.push({
            name: key,
            value: value,
        });
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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