import abc
from abc import ABC, abstractmethod
from typing import Any

class AsyncBaseContextStore(ABC, metaclass=abc.ABCMeta):
    @abstractmethod
    async def get_system_message(self, thread_id: str) -> str: ...
    @abstractmethod
    async def update_system_message(self, thread_id: str, system_message: str) -> None: ...
    @abstractmethod
    def init_context(self, thread_id: str, system_message: str) -> list[dict[str, Any]]: ...
    @abstractmethod
    async def get_context(self, thread_id: str) -> list[dict[str, Any]]: ...
    @abstractmethod
    async def add_context(self, thread_id: str, content: dict[str, Any]) -> list[dict[str, Any]]: ...
    @abstractmethod
    async def extend_context(self, thread_id: str, content: list[dict[str, Any]]) -> list[dict[str, Any]]: ...
    @abstractmethod
    async def clear_context(self, thread_id: str) -> list[dict[str, Any]]: ...
