import abc
from abc import ABC, abstractmethod
from openagentkit.core.models.responses import OpenAgentResponse as OpenAgentResponse, OpenAgentStreamingResponse as OpenAgentStreamingResponse
from pydantic import BaseModel as BaseModel
from typing import Any, AsyncGenerator

class AsyncBaseLLMModel(ABC, metaclass=abc.ABCMeta):
    def __init__(self, model: str, temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None) -> None: ...
    @property
    def model(self) -> str: ...
    @property
    def temperature(self) -> float: ...
    @property
    def max_tokens(self) -> int | None: ...
    @property
    def top_p(self) -> float | None: ...
    @temperature.setter
    def temperature(self, value: float) -> None: ...
    @top_p.setter
    def top_p(self, value: float) -> None: ...
    @max_tokens.setter
    def max_tokens(self, value: int) -> None: ...
    @abstractmethod
    def clone(self) -> AsyncBaseLLMModel: ...
    @abstractmethod
    async def model_generate(self, messages: list[dict[str, str]], response_schema: type[BaseModel] | None = None, temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, **kwargs: Any) -> OpenAgentResponse: ...
    @abstractmethod
    async def model_stream(self, messages: list[dict[str, str]], response_schema: type[BaseModel] | None = None, temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, **kwargs: Any) -> AsyncGenerator[OpenAgentStreamingResponse, None]: ...
