import abc
from abc import ABC, abstractmethod
from openagentkit.core.models.io.context_unit import ContextUnit as ContextUnit
from typing import Any

class BaseContextStore(ABC, metaclass=abc.ABCMeta):
    @abstractmethod
    def get_system_message(self, thread_id: str) -> str: ...
    @abstractmethod
    def update_system_message(self, thread_id: str, agent_id: str, system_message: str) -> None: ...
    @abstractmethod
    def init_context(self, thread_id: str, agent_id: str, system_message: str) -> ContextUnit: ...
    @abstractmethod
    def get_context(self, thread_id: str) -> ContextUnit | None: ...
    @abstractmethod
    def get_agent_context(self, agent_id: str) -> dict[str, ContextUnit]: ...
    @abstractmethod
    def add_context(self, thread_id: str, agent_id: str, content: dict[str, Any], system_message: str | None = None) -> ContextUnit: ...
    @abstractmethod
    def extend_context(self, thread_id: str, agent_id: str, content: list[dict[str, Any]], system_message: str | None = None) -> ContextUnit: ...
    @abstractmethod
    def clear_context(self, thread_id: str) -> ContextUnit | None: ...
