from _typeshed import Incomplete
from mcp import ClientSession as ClientSession
from openagentkit.core.context import InMemoryContextStore as InMemoryContextStore
from openagentkit.core.interfaces import AsyncBaseAgent as AsyncBaseAgent, BaseContextStore as BaseContextStore
from openagentkit.core.models.responses import OpenAgentResponse as OpenAgentResponse, OpenAgentStreamingResponse as OpenAgentStreamingResponse
from openagentkit.core.tools.base_tool import Tool as Tool
from openagentkit.core.tools.tool_handler import ToolHandler as ToolHandler
from openagentkit.modules.openai import OpenAIAudioFormats as OpenAIAudioFormats, OpenAIAudioVoices as OpenAIAudioVoices
from openagentkit.modules.openai.async_openai_llm_service import AsyncOpenAILLMService as AsyncOpenAILLMService
from openai import AsyncOpenAI as AsyncOpenAI
from pydantic import BaseModel
from typing import Any, AsyncGenerator, Literal

logger: Incomplete

class AsyncOpenAIAgent(AsyncBaseAgent):
    context_store: BaseContextStore
    def __init__(self, client: AsyncOpenAI | None = None, model: str = 'gpt-4o-mini', system_message: str | None = None, tools: list[Tool] | None = None, context_store: BaseContextStore | None = None, api_key: str | None = ..., temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, thread_id: str | None = None, agent_id: str | None = None) -> None: ...
    @property
    def system_message(self) -> str: ...
    @system_message.setter
    def system_message(self, value: str) -> None: ...
    @property
    def model(self) -> str: ...
    @property
    def temperature(self) -> float: ...
    @property
    def max_tokens(self) -> int | None: ...
    @property
    def top_p(self) -> float | None: ...
    @property
    def tools(self) -> list[dict[str, Any]] | None: ...
    async def connect_to_mcp(self, mcp_sessions: list[ClientSession]) -> None: ...
    @property
    def thread_id(self) -> str: ...
    @property
    def agent_id(self) -> str: ...
    def clone(self) -> AsyncOpenAIAgent: ...
    async def execute(self, messages: list[dict[str, str]], tools: list[dict[str, Any]] | None = None, temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, response_schema: type[BaseModel] | None = None, audio: bool | None = False, audio_format: OpenAIAudioFormats | None = 'pcm16', audio_voice: OpenAIAudioVoices | None = 'alloy', reasoning_effort: Literal['low', 'medium', 'high'] | None = None, **kwargs: Any) -> AsyncGenerator[OpenAgentResponse, None]: ...
    async def stream_execute(self, messages: list[dict[str, str]], tools: list[dict[str, Any]] | None = None, temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, response_schema: type[BaseModel] | None = None, audio: bool | None = False, audio_format: OpenAIAudioFormats | None = 'pcm16', audio_voice: OpenAIAudioVoices | None = 'alloy', reasoning_effort: Literal['low', 'medium', 'high'] | None = None, **kwargs: Any) -> AsyncGenerator[OpenAgentStreamingResponse, None]: ...
