from openagentkit.core.interfaces.async_base_embedding_model import AsyncBaseEmbeddingModel as AsyncBaseEmbeddingModel
from openagentkit.core.models.io.embeddings import EmbeddingUnit as EmbeddingUnit
from openagentkit.core.models.responses import EmbeddingResponse as EmbeddingResponse
from openagentkit.modules.openai import OpenAIEmbeddingEncodings as OpenAIEmbeddingEncodings, OpenAIEmbeddingModels as OpenAIEmbeddingModels, OpenAIEncodingFormats as OpenAIEncodingFormats
from openai import AsyncOpenAI

class AsyncOpenAIEmbeddingModel(AsyncBaseEmbeddingModel[int]):
    def __init__(self, client: AsyncOpenAI | None = None, api_key: str | None = ..., embedding_model: OpenAIEmbeddingModels = 'text-embedding-3-small', embedding_encoding: OpenAIEmbeddingEncodings = 'cl100k_base', encoding_format: OpenAIEncodingFormats = 'float') -> None: ...
    @property
    def embedding_model(self) -> str: ...
    @embedding_model.setter
    def embedding_model(self, value: OpenAIEmbeddingModels) -> None: ...
    @property
    def embedding_encoding(self) -> str: ...
    @embedding_encoding.setter
    def embedding_encoding(self, value: OpenAIEmbeddingEncodings) -> None: ...
    @property
    def encoding_format(self) -> str: ...
    @encoding_format.setter
    def encoding_format(self, value: OpenAIEncodingFormats) -> None: ...
    async def encode_query(self, query: str, include_metadata: bool = False) -> EmbeddingUnit | EmbeddingResponse: ...
    async def encode_texts(self, texts: list[str], include_metadata: bool = False) -> list[EmbeddingUnit] | EmbeddingResponse: ...
    def tokenize_texts(self, texts: list[str]) -> list[list[int]]: ...
