from _typeshed import Incomplete
from openagentkit.core.context import InMemoryContextStore as InMemoryContextStore
from openagentkit.core.interfaces import BaseAgent as BaseAgent, BaseContextStore as BaseContextStore
from openagentkit.core.models.responses import OpenAgentResponse as OpenAgentResponse, OpenAgentStreamingResponse as OpenAgentStreamingResponse
from openagentkit.core.tools.base_tool import Tool as Tool
from openagentkit.core.tools.tool_handler import ToolHandler as ToolHandler
from openagentkit.modules.openai import OpenAIAudioFormats as OpenAIAudioFormats, OpenAIAudioVoices as OpenAIAudioVoices, OpenAILLMService as OpenAILLMService
from openai import OpenAI as OpenAI
from pydantic import BaseModel
from typing import Any, Generator, Literal

logger: Incomplete

class OpenAIAgent(BaseAgent):
    context_store: BaseContextStore
    def __init__(self, client: OpenAI | None = None, model: str = 'gpt-4o-mini', system_message: str | None = None, tools: list[Tool] | None = None, context_store: BaseContextStore | None = None, api_key: str | None = ..., temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, thread_id: str | None = None, agent_id: str | None = None) -> None: ...
    @property
    def system_message(self) -> str: ...
    def update_system_message(self, system_message: str, thread_id: str) -> None: ...
    @property
    def model(self) -> str: ...
    @property
    def temperature(self) -> float: ...
    @property
    def max_tokens(self) -> int | None: ...
    @property
    def top_p(self) -> float | None: ...
    @property
    def tools(self) -> list[dict[str, Any]] | None: ...
    @property
    def thread_id(self) -> str: ...
    @property
    def agent_id(self) -> str: ...
    def clone(self) -> OpenAIAgent: ...
    def execute(self, messages: list[dict[str, str]], tools: list[dict[str, Any]] | None = None, temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, response_schema: type[BaseModel] | None = None, audio: bool | None = False, audio_format: OpenAIAudioFormats | None = 'pcm16', audio_voice: OpenAIAudioVoices | None = 'alloy', reasoning_effort: Literal['low', 'medium', 'high'] | None = None, **kwargs: Any) -> Generator[OpenAgentResponse, None, None]: ...
    def stream_execute(self, messages: list[dict[str, str]], tools: list[dict[str, Any]] | None = None, temperature: float | None = None, max_tokens: int | None = None, top_p: float | None = None, response_schema: type[BaseModel] | None = None, audio: bool | None = False, audio_format: OpenAIAudioFormats | None = 'pcm16', audio_voice: OpenAIAudioVoices | None = 'alloy', reasoning_effort: Literal['low', 'medium', 'high'] | None = None, **kwargs: Any) -> Generator[OpenAgentStreamingResponse, None, None]: ...
