import base64
from openagentkit.core.interfaces import BaseEmbeddingModel as BaseEmbeddingModel
from openagentkit.core.models.io.embeddings import EmbeddingUnit as EmbeddingUnit
from openagentkit.core.models.responses import EmbeddingResponse as EmbeddingResponse
from typing import Literal, overload
from voyageai.client import Client

class VoyageAIEmbeddingModel(BaseEmbeddingModel[str]):
    def __init__(self, client: Client | None = None, api_key: str | None = ..., embedding_model: Literal['voyage-3-large', 'voyage-3', 'voyage-3-lite', 'voyage-code-3', 'voyage-finance-2', 'voyage-law-2', 'voyage-code-2'] = 'voyage-3-large', dimensions: Literal[256, 512, 1024, 1536, 2048] = 1024, encoding_format: Literal['float', 'base64'] = 'float') -> None: ...
    @property
    def encoding_format(self) -> str: ...
    @encoding_format.setter
    def encoding_format(self, value: Literal['float', 'base64']) -> None: ...
    @property
    def embedding_model(self) -> str: ...
    @embedding_model.setter
    def embedding_model(self, value: str) -> None: ...
    @property
    def dimensions(self) -> int: ...
    @dimensions.setter
    def dimensions(self, value: Literal[256, 512, 1024, 1536, 2048]) -> None: ...
    @overload
    def encode_query(self, query: str, include_metadata: Literal[True], truncation: bool = True) -> EmbeddingResponse: ...
    @overload
    def encode_query(self, query: str, include_metadata: Literal[False], truncation: bool = True) -> EmbeddingUnit: ...
    @overload
    def encode_texts(self, texts: list[str], include_metadata: Literal[True], input_type: Literal['query', 'document'] | None = 'document', truncation: bool = True) -> EmbeddingResponse: ...
    @overload
    def encode_texts(self, texts: list[str], include_metadata: Literal[False], input_type: Literal['query', 'document'] | None = 'document', truncation: bool = True) -> list[EmbeddingUnit]: ...
    def tokenize_texts(self, texts: list[str]) -> list[list[str]]: ...
