# 🧪 `lazy_testdata` 测试数据生成与性能测试工具包

> 一个用于快速生成测试数据、数据库操作辅助、性能测试执行与报告生成的 Python 工具包。

## 📦 目录结构

```
lazy_testdata/
├── chinacitycode.py        # 中国城市编码数据
├── chinesecardbin.py       # 银行卡 BIN 数据
├── chinesename.py          # 中文姓名数据
├── core.py                 # 核心测试数据生成类（身份证、银行卡、时间工具等）
├── dbhelper.py             # 数据库连接与 SQL 操作工具
├── pthelper.py             # 性能测试（JMeter）执行与报告生成工具
├── sh_and_os_ext.py        # 系统命令与文件路径处理工具
└── __init__.py             # 包初始化
```

---

## 🔍 主要功能模块说明

### 1. 🧾 `core.py` —— 核心测试数据生成器

#### 🧍‍♂️ 个人信息生成（`PersonalInfo` 类）

- **手机号码**：随机生成国内主流号段
- **中文姓名**：从姓氏 + 名字列表中组合
- **身份证号码**：
  - 支持指定年龄范围（如 18~50 岁）
  - 自动计算校验位
- **银行卡号**：基于预设 BIN 号生成
- **四要素信息**：返回包含姓名、身份证、银行卡、手机号的字典

#### ⏰ 时间工具类（`DateTimeUtil`）

- 获取当前时间格式化字符串（SQL、无分隔符、请求编号等）
- 日期加减（天数、月份）、获取某月第几天
- 获取两个日期之间的所有日期
- UTC 转 GMT+8 时间转换

#### 📘 Swagger 接口自动化用例生成（`Swagger2Case` 类）

- 支持从线上接口文档或本地 JSON 文件读取
- 自动生成“全参数”、“空参数”两类测试用例
- 支持 GET/POST 请求参数解析填充

---

### 2. 💾 `dbhelper.py` —— 数据库辅助工具

- 使用 SQLAlchemy 和 Records 实现数据库连接
- 提供参数化查询与 SQL 执行功能
- 支持 Pandas 导出为 Excel 文件

---

### 3. 🚀 `pthelper.py` —— 性能测试辅助工具

- 自动构建 JMeter CLI 命令并执行
- 支持并发用户数、循环次数等参数配置
- 支持多 JMX 文件批量运行
- 自动收集 CSV 日志并生成 HTML 报告
- 支持导出汇总报表为 CSV/XLSX 文件
- 支持错误率过滤与排序展示

---

### 4. 🖥️ `sh_and_os_ext.py` —— 系统命令与文件工具

- 获取文件路径、文件名、后缀
- 执行 Shell 命令并输出结果

---

### 5. ✨ 其他模块数据支持

- `chinacitycode.py`：提供中国城市编码列表
- `chinesecardbin.py`：常用银行卡 BIN 列表
- `chinesename.py`：中文姓氏与名字列表

---

## 🛠️ 安装与使用

### 安装依赖（建议使用虚拟环境）

```bash
pip install sqlalchemy records pandas json2html requests dateutil
```

> 若需运行 JMeter 性能测试，请确保系统已安装 Apache JMeter 并配置好环境变量。

### 示例导入使用

```python
from lazy_testdata.core import PersonalInfo, DateTimeUtil

pi = PersonalInfo()
print(pi.full_name())         # 生成中文姓名
print(pi.create_idcard())     # 生成身份证号
print(pi.create_phone())      # 生成手机号
print(pi.create_bankcardno()) # 生成银行卡号

dtu = DateTimeUtil()
print(dtu.get_sql_dt())       # 获取当前时间（SQL 格式）
print(dtu.get_aftermonth(3))  # 获取三个月后的日期
```

---

## 📊 性能测试示例（`pthelper.py`）

```python
from lazy_testdata.pthelper import combine_cli_cmd

# 运行指定目录下的所有 JMX 文件，每线程执行 10 次
combine_cli_cmd(jmx_dir='jmx', threads=10, loops=10)
```

---

## 📄 报告生成

- 生成 HTML 报告：`gen_summary_report(data)`
- 导出为 Excel：`export_excel(data, title)`

---

## 🧩 开发维护建议

- **扩展性**：可将更多测试数据模板抽象成插件形式，便于复用。
- **异常处理**：增强对数据库连接失败、JMeter 未安装等情况的提示。
- **日志记录**：引入 logging 替代 print，提高调试效率。
- **单元测试**：为各模块编写 unittest，确保稳定性。

---

## 📝 License

MIT License
