# DOM Operations API

*Auto-generated from dom.py JSDoc comments*

## GET /cdp/dom/snapshot

**Function:** `get_dom_snapshot()`

Get current DOM tree snapshot

**Parameters:**
- `depth` *(number)* *(optional)*: DOM tree depth (-1 for full tree)
- `include_text` *(boolean)* *(optional)*: Include text nodes

**Returns:** {object} DOM tree or HTML content

**Examples:**
```javascript
// Full DOM tree
GET /cdp/dom/snapshot?depth=-1
// Limited depth
GET /cdp/dom/snapshot?depth=3
// Include text nodes
GET /cdp/dom/snapshot?include_text=true
```

---

## POST /cdp/dom/query

**Function:** `query_selector()`

Query DOM with ANY selector - malformed selectors welcome

**Parameters:**
- `selector ` *(string)*: ANY CSS selector
- `all` *(boolean)* *(optional)*: Return all matches (querySelectorAll)
- `details` *(boolean)* *(optional)*: Include element details

**Returns:** {object} Query results or crash data

**Examples:**
```javascript
// Normal query
{"selector": "div.container"}
// Malformed selector - see what happens
{"selector": ">>>invalid<<<"}
// Complex selector - test limits
{"selector": "div > span:nth-child(999999999999)"}
// Injection attempt
{"selector": "div'; alert('xss'); //"}
```

---

## POST /cdp/form/fill

**Function:** `fill_form()`

Fill form fields - ANY selectors, ANY values

**Parameters:**
- `fields ` *(object)*: Object mapping selectors to values
- `trigger_events` *(boolean)* *(optional)*: Trigger input/change events

**Returns:** {object} Fill results for each field

**Examples:**
```javascript
// Normal form fill
{"fields": {"#email": "test@example.com", "#password": "secret"}}
// Malformed selectors and values
{"fields": {">>>bad<<<": "test null
bytes", "#other": ""}}
// Huge values - test limits
{"fields": {"#input": "A".repeat(1000000)}}
// Special characters
{"fields": {"#text": "\n\t\r\0\u0000"}}
```

---

## POST /cdp/form/submit

**Function:** `submit_form()`

Submit form by selector

**Parameters:**
- `selector ` *(string)*: Form selector (no validation)
- `method` *(string)* *(optional)*: Submit method (submit/click/enter)

**Returns:** {object} Submit result

**Examples:**
```javascript
// Normal form submit
{"selector": "#login-form"}
// Submit via button click
{"selector": "#submit-btn", "method": "click"}
// Submit via enter key
{"selector": "#form", "method": "enter"}
// Malformed selector
{"selector": ">>>invalid<<<"}
```

---

## POST /cdp/form/values

**Function:** `get_form_values()`

Get current form field values

**Parameters:**
- `selectors ` *(array)*: Array of field selectors
- `form_selector` *(string)* *(optional)*: Get all inputs from a form

**Returns:** {object} Current field values

**Examples:**
```javascript
// Get specific fields
{"selectors": ["#email", "#password", "#username"]}
// Get all form inputs
{"form_selector": "#login-form"}
// Malformed selectors
{"selectors": [">>>bad<<<", "#normal"]}
```

---

## POST /cdp/dom/modify

**Function:** `modify_dom()`

Modify DOM elements - ANY changes allowed

**Parameters:**
- `selector ` *(string)*: Element selector
- `action` *(string)* *(optional)*: Modification action (html, text, attr, style, remove)
- `content` *(string)* *(optional)*: New content (for html/text)
- `attributes` *(object)* *(optional)*: Attributes to set
- `styles` *(object)* *(optional)*: Styles to apply

**Returns:** {object} Modification result

**Examples:**
```javascript
// Change HTML content
{"selector": "#content", "action": "html", "content": "<h1>Modified</h1>"}
// Inject script - test XSS
{"selector": "body", "action": "html", "content": "<script>alert('injected')</script>"}
// Remove element
{"selector": "#unwanted", "action": "remove"}
// Set dangerous attributes
{"selector": "img", "attributes": {"src": "javascript:alert('xss')"}}
```

---

