# Page Navigation API

*Auto-generated from navigation.py JSDoc comments*

## POST /cdp/page/navigate

**Function:** `navigate()`

Navigate to ANY URL - no restrictions

**Parameters:**
- `url ` *(string)*: ANY URL, valid or invalid
- `timeout` *(number)* *(optional)*: Navigation timeout in ms
- `wait_for_load` *(boolean)* *(optional)*: Wait for page load complete

**Returns:** {object} Navigation result

**Examples:**
```javascript
// Normal navigation
{"url": "https://example.com"}
// Test edge cases
{"url": "ftp://invalid.protocol"}
{"url": "javascript:alert('xss')"}
{"url": "data:text/html,<script>alert('data')</script>"}
// Local files
{"url": "file:///etc/passwd"}
// Malformed URLs
{"url": "not-a-url-at-all"}
{"url": "http://[invalid-ipv6]/test"}
```

---

## POST /cdp/page/reload

**Function:** `reload_page()`

Reload current page with optional parameters

**Parameters:**
- `ignore_cache` *(boolean)* *(optional)*: Bypass cache
- `script_to_evaluate` *(string)* *(optional)*: Script to run after reload

**Returns:** {object} Reload result

**Examples:**
```javascript
// Simple reload
{}
// Hard reload
{"ignore_cache": true}
// Reload with script injection
{"script_to_evaluate": "alert('reloaded')"}
```

---

## POST /cdp/page/back

**Function:** `go_back()`

Go back in browser history

**Returns:** {object} Back navigation result

---

## POST /cdp/page/forward

**Function:** `go_forward()`

Go forward in browser history

**Returns:** {object} Forward navigation result

---

## POST /cdp/page/stop

**Function:** `stop_loading()`

Stop page loading

**Returns:** {object} Stop result

---

## GET /cdp/page/info

**Function:** `get_page_info()`

Get current page information

**Returns:** {object} Page information including URL, title, state

---

## POST /cdp/page/viewport

**Function:** `set_viewport()`

Set viewport/device metrics - ANY values allowed

**Parameters:**
- `width` *(number)* *(optional)*: Viewport width (can be 0, negative, huge)
- `height` *(number)* *(optional)*: Viewport height (can be 0, negative, huge)
- `device_scale` *(number)* *(optional)*: Device scale factor (can be 0, negative)
- `mobile` *(boolean)* *(optional)*: Mobile mode

**Returns:** {object} Viewport change result

**Examples:**
```javascript
// Normal desktop
{"width": 1920, "height": 1080, "device_scale": 1, "mobile": false}
// Mobile device
{"width": 375, "height": 667, "device_scale": 2, "mobile": true}
// Extreme values - test limits
{"width": 999999, "height": -100, "device_scale": 0}
// Tiny viewport
{"width": 1, "height": 1}
```

---

## GET /cdp/page/cookies

**Function:** `get_cookies()`

Get all cookies for current page

**Returns:** {object} All cookies

---

## POST /cdp/page/cookies

**Function:** `set_cookie()`

Set a cookie - ANY values allowed

**Parameters:**
- `name ` *(string)*: Cookie name (no validation)
- `value ` *(string)*: Cookie value (no validation)
- `domain` *(string)* *(optional)*: Cookie domain
- `path` *(string)* *(optional)*: Cookie path
- `secure` *(boolean)* *(optional)*: Secure flag
- `httpOnly` *(boolean)* *(optional)*: HttpOnly flag

**Returns:** {object} Set cookie result

**Examples:**
```javascript
// Normal cookie
{"name": "test", "value": "hello"}
// Malformed cookie - test parsing
{"name": "bad=cookie", "value": "with
newlines null"}
// Huge cookie - test limits
{"name": "huge", "value": "x".repeat(100000)}
```

---

