# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_bmc')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_bmc')
    _bmc = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_bmc', [dirname(__file__)])
        except ImportError:
            import _bmc
            return _bmc
        try:
            _mod = imp.load_module('_bmc', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _bmc = swig_import_helper()
    del swig_import_helper
else:
    import _bmc
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _bmc.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self) -> "PyObject *":
        return _bmc.SwigPyIterator_value(self)

    def incr(self, n: 'size_t'=1) -> "swig::SwigPyIterator *":
        return _bmc.SwigPyIterator_incr(self, n)

    def decr(self, n: 'size_t'=1) -> "swig::SwigPyIterator *":
        return _bmc.SwigPyIterator_decr(self, n)

    def distance(self, x: 'SwigPyIterator') -> "ptrdiff_t":
        return _bmc.SwigPyIterator_distance(self, x)

    def equal(self, x: 'SwigPyIterator') -> "bool":
        return _bmc.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _bmc.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _bmc.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _bmc.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _bmc.SwigPyIterator_previous(self)

    def advance(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator *":
        return _bmc.SwigPyIterator_advance(self, n)

    def __eq__(self, x: 'SwigPyIterator') -> "bool":
        return _bmc.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: 'SwigPyIterator') -> "bool":
        return _bmc.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator &":
        return _bmc.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator &":
        return _bmc.SwigPyIterator___isub__(self, n)

    def __add__(self, n: 'ptrdiff_t') -> "swig::SwigPyIterator *":
        return _bmc.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _bmc.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _bmc.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class IntVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IntVector, name)
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _bmc.IntVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _bmc.IntVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _bmc.IntVector___bool__(self)

    def __len__(self) -> "std::vector< int >::size_type":
        return _bmc.IntVector___len__(self)

    def __getslice__(self, i: 'std::vector< int >::difference_type', j: 'std::vector< int >::difference_type') -> "std::vector< int,std::allocator< int > > *":
        return _bmc.IntVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _bmc.IntVector___setslice__(self, *args)

    def __delslice__(self, i: 'std::vector< int >::difference_type', j: 'std::vector< int >::difference_type') -> "void":
        return _bmc.IntVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _bmc.IntVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< int >::value_type const &":
        return _bmc.IntVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _bmc.IntVector___setitem__(self, *args)

    def pop(self) -> "std::vector< int >::value_type":
        return _bmc.IntVector_pop(self)

    def append(self, x: 'std::vector< int >::value_type const &') -> "void":
        return _bmc.IntVector_append(self, x)

    def empty(self) -> "bool":
        return _bmc.IntVector_empty(self)

    def size(self) -> "std::vector< int >::size_type":
        return _bmc.IntVector_size(self)

    def swap(self, v: 'IntVector') -> "void":
        return _bmc.IntVector_swap(self, v)

    def begin(self) -> "std::vector< int >::iterator":
        return _bmc.IntVector_begin(self)

    def end(self) -> "std::vector< int >::iterator":
        return _bmc.IntVector_end(self)

    def rbegin(self) -> "std::vector< int >::reverse_iterator":
        return _bmc.IntVector_rbegin(self)

    def rend(self) -> "std::vector< int >::reverse_iterator":
        return _bmc.IntVector_rend(self)

    def clear(self) -> "void":
        return _bmc.IntVector_clear(self)

    def get_allocator(self) -> "std::vector< int >::allocator_type":
        return _bmc.IntVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _bmc.IntVector_pop_back(self)

    def erase(self, *args) -> "std::vector< int >::iterator":
        return _bmc.IntVector_erase(self, *args)

    def __init__(self, *args):
        this = _bmc.new_IntVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x: 'std::vector< int >::value_type const &') -> "void":
        return _bmc.IntVector_push_back(self, x)

    def front(self) -> "std::vector< int >::value_type const &":
        return _bmc.IntVector_front(self)

    def back(self) -> "std::vector< int >::value_type const &":
        return _bmc.IntVector_back(self)

    def assign(self, n: 'std::vector< int >::size_type', x: 'std::vector< int >::value_type const &') -> "void":
        return _bmc.IntVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _bmc.IntVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _bmc.IntVector_insert(self, *args)

    def reserve(self, n: 'std::vector< int >::size_type') -> "void":
        return _bmc.IntVector_reserve(self, n)

    def capacity(self) -> "std::vector< int >::size_type":
        return _bmc.IntVector_capacity(self)
    __swig_destroy__ = _bmc.delete_IntVector
    __del__ = lambda self: None
IntVector_swigregister = _bmc.IntVector_swigregister
IntVector_swigregister(IntVector)

class DoubleVector(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DoubleVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DoubleVector, name)
    __repr__ = _swig_repr

    def iterator(self) -> "swig::SwigPyIterator *":
        return _bmc.DoubleVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self) -> "bool":
        return _bmc.DoubleVector___nonzero__(self)

    def __bool__(self) -> "bool":
        return _bmc.DoubleVector___bool__(self)

    def __len__(self) -> "std::vector< double >::size_type":
        return _bmc.DoubleVector___len__(self)

    def __getslice__(self, i: 'std::vector< double >::difference_type', j: 'std::vector< double >::difference_type') -> "std::vector< double,std::allocator< double > > *":
        return _bmc.DoubleVector___getslice__(self, i, j)

    def __setslice__(self, *args) -> "void":
        return _bmc.DoubleVector___setslice__(self, *args)

    def __delslice__(self, i: 'std::vector< double >::difference_type', j: 'std::vector< double >::difference_type') -> "void":
        return _bmc.DoubleVector___delslice__(self, i, j)

    def __delitem__(self, *args) -> "void":
        return _bmc.DoubleVector___delitem__(self, *args)

    def __getitem__(self, *args) -> "std::vector< double >::value_type const &":
        return _bmc.DoubleVector___getitem__(self, *args)

    def __setitem__(self, *args) -> "void":
        return _bmc.DoubleVector___setitem__(self, *args)

    def pop(self) -> "std::vector< double >::value_type":
        return _bmc.DoubleVector_pop(self)

    def append(self, x: 'std::vector< double >::value_type const &') -> "void":
        return _bmc.DoubleVector_append(self, x)

    def empty(self) -> "bool":
        return _bmc.DoubleVector_empty(self)

    def size(self) -> "std::vector< double >::size_type":
        return _bmc.DoubleVector_size(self)

    def swap(self, v: 'DoubleVector') -> "void":
        return _bmc.DoubleVector_swap(self, v)

    def begin(self) -> "std::vector< double >::iterator":
        return _bmc.DoubleVector_begin(self)

    def end(self) -> "std::vector< double >::iterator":
        return _bmc.DoubleVector_end(self)

    def rbegin(self) -> "std::vector< double >::reverse_iterator":
        return _bmc.DoubleVector_rbegin(self)

    def rend(self) -> "std::vector< double >::reverse_iterator":
        return _bmc.DoubleVector_rend(self)

    def clear(self) -> "void":
        return _bmc.DoubleVector_clear(self)

    def get_allocator(self) -> "std::vector< double >::allocator_type":
        return _bmc.DoubleVector_get_allocator(self)

    def pop_back(self) -> "void":
        return _bmc.DoubleVector_pop_back(self)

    def erase(self, *args) -> "std::vector< double >::iterator":
        return _bmc.DoubleVector_erase(self, *args)

    def __init__(self, *args):
        this = _bmc.new_DoubleVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, x: 'std::vector< double >::value_type const &') -> "void":
        return _bmc.DoubleVector_push_back(self, x)

    def front(self) -> "std::vector< double >::value_type const &":
        return _bmc.DoubleVector_front(self)

    def back(self) -> "std::vector< double >::value_type const &":
        return _bmc.DoubleVector_back(self)

    def assign(self, n: 'std::vector< double >::size_type', x: 'std::vector< double >::value_type const &') -> "void":
        return _bmc.DoubleVector_assign(self, n, x)

    def resize(self, *args) -> "void":
        return _bmc.DoubleVector_resize(self, *args)

    def insert(self, *args) -> "void":
        return _bmc.DoubleVector_insert(self, *args)

    def reserve(self, n: 'std::vector< double >::size_type') -> "void":
        return _bmc.DoubleVector_reserve(self, n)

    def capacity(self) -> "std::vector< double >::size_type":
        return _bmc.DoubleVector_capacity(self)
    __swig_destroy__ = _bmc.delete_DoubleVector
    __del__ = lambda self: None
DoubleVector_swigregister = _bmc.DoubleVector_swigregister
DoubleVector_swigregister(DoubleVector)

BMC_MAX_PATH = _bmc.BMC_MAX_PATH
BMC_SERIAL_NUMBER_LEN = _bmc.BMC_SERIAL_NUMBER_LEN
BMC_USB = _bmc.BMC_USB
BMC_PCIE = _bmc.BMC_PCIE
BMC_DUMMY_DRV = _bmc.BMC_DUMMY_DRV
MAX_DM_SIZE = _bmc.MAX_DM_SIZE
BMC_DEV_ID_ANY = _bmc.BMC_DEV_ID_ANY
BMC_DEV_ID_QUERY_PROFILE = _bmc.BMC_DEV_ID_QUERY_PROFILE
DMSquareLayout = _bmc.DMSquareLayout
DMCircularLayout = _bmc.DMCircularLayout
DMLinearLayout = _bmc.DMLinearLayout
DMHexLayout = _bmc.DMHexLayout
DMLayoutCount = _bmc.DMLayoutCount
class DM_DRIVER(_object):
    """


    The DM_DRIVER struct stores information about the drive electronics.  

    C++ includes: BMCDefs.h

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DM_DRIVER, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DM_DRIVER, name)
    __repr__ = _swig_repr
    __swig_setmethods__["channel_count"] = _bmc.DM_DRIVER_channel_count_set
    __swig_getmethods__["channel_count"] = _bmc.DM_DRIVER_channel_count_get
    if _newclass:
        channel_count = _swig_property(_bmc.DM_DRIVER_channel_count_get, _bmc.DM_DRIVER_channel_count_set)
    __swig_setmethods__["serial_number"] = _bmc.DM_DRIVER_serial_number_set
    __swig_getmethods__["serial_number"] = _bmc.DM_DRIVER_serial_number_get
    if _newclass:
        serial_number = _swig_property(_bmc.DM_DRIVER_serial_number_get, _bmc.DM_DRIVER_serial_number_set)
    __swig_setmethods__["reserved"] = _bmc.DM_DRIVER_reserved_set
    __swig_getmethods__["reserved"] = _bmc.DM_DRIVER_reserved_get
    if _newclass:
        reserved = _swig_property(_bmc.DM_DRIVER_reserved_get, _bmc.DM_DRIVER_reserved_set)

    def __init__(self):
        """
        __init__(DM_DRIVER self) -> DM_DRIVER



        The DM_DRIVER struct stores information about the drive electronics.  

        C++ includes: BMCDefs.h

        """
        this = _bmc.new_DM_DRIVER()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bmc.delete_DM_DRIVER
    __del__ = lambda self: None
DM_DRIVER_swigregister = _bmc.DM_DRIVER_swigregister
DM_DRIVER_swigregister(DM_DRIVER)

class DM(_object):
    """


    The DM struct stores the device info necessary to access the driver.  

    When passed to BMCOpen() this struct should have been allocated, but empty. The function will fill it in. For all other functions this struct is used as a means to pass all identifying values together.  

    Driver_type - Driver interface. USB, PCIe, or DPIO2. DevId - The driver's ID as seen by the system. ActCount - Number of actuators on the driver/mirror.  

    C++ includes: BMCDefs.h

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DM, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DM, name)
    __repr__ = _swig_repr
    __swig_setmethods__["Driver_Type"] = _bmc.DM_Driver_Type_set
    __swig_getmethods__["Driver_Type"] = _bmc.DM_Driver_Type_get
    if _newclass:
        Driver_Type = _swig_property(_bmc.DM_Driver_Type_get, _bmc.DM_Driver_Type_set)
    __swig_setmethods__["DevId"] = _bmc.DM_DevId_set
    __swig_getmethods__["DevId"] = _bmc.DM_DevId_get
    if _newclass:
        DevId = _swig_property(_bmc.DM_DevId_get, _bmc.DM_DevId_set)
    __swig_setmethods__["HVA_Type"] = _bmc.DM_HVA_Type_set
    __swig_getmethods__["HVA_Type"] = _bmc.DM_HVA_Type_get
    if _newclass:
        HVA_Type = _swig_property(_bmc.DM_HVA_Type_get, _bmc.DM_HVA_Type_set)
    __swig_setmethods__["use_fiber"] = _bmc.DM_use_fiber_set
    __swig_getmethods__["use_fiber"] = _bmc.DM_use_fiber_get
    if _newclass:
        use_fiber = _swig_property(_bmc.DM_use_fiber_get, _bmc.DM_use_fiber_set)
    __swig_setmethods__["use_CL"] = _bmc.DM_use_CL_set
    __swig_getmethods__["use_CL"] = _bmc.DM_use_CL_get
    if _newclass:
        use_CL = _swig_property(_bmc.DM_use_CL_get, _bmc.DM_use_CL_set)
    __swig_setmethods__["burst_mode"] = _bmc.DM_burst_mode_set
    __swig_getmethods__["burst_mode"] = _bmc.DM_burst_mode_get
    if _newclass:
        burst_mode = _swig_property(_bmc.DM_burst_mode_get, _bmc.DM_burst_mode_set)
    __swig_setmethods__["fiber_mode"] = _bmc.DM_fiber_mode_set
    __swig_getmethods__["fiber_mode"] = _bmc.DM_fiber_mode_get
    if _newclass:
        fiber_mode = _swig_property(_bmc.DM_fiber_mode_get, _bmc.DM_fiber_mode_set)
    __swig_setmethods__["ActCount"] = _bmc.DM_ActCount_set
    __swig_getmethods__["ActCount"] = _bmc.DM_ActCount_get
    if _newclass:
        ActCount = _swig_property(_bmc.DM_ActCount_get, _bmc.DM_ActCount_set)
    __swig_setmethods__["MaxVoltage"] = _bmc.DM_MaxVoltage_set
    __swig_getmethods__["MaxVoltage"] = _bmc.DM_MaxVoltage_get
    if _newclass:
        MaxVoltage = _swig_property(_bmc.DM_MaxVoltage_get, _bmc.DM_MaxVoltage_set)
    __swig_setmethods__["VoltageLimit"] = _bmc.DM_VoltageLimit_set
    __swig_getmethods__["VoltageLimit"] = _bmc.DM_VoltageLimit_get
    if _newclass:
        VoltageLimit = _swig_property(_bmc.DM_VoltageLimit_get, _bmc.DM_VoltageLimit_set)
    __swig_setmethods__["mapping"] = _bmc.DM_mapping_set
    __swig_getmethods__["mapping"] = _bmc.DM_mapping_get
    if _newclass:
        mapping = _swig_property(_bmc.DM_mapping_get, _bmc.DM_mapping_set)
    __swig_setmethods__["inactive"] = _bmc.DM_inactive_set
    __swig_getmethods__["inactive"] = _bmc.DM_inactive_get
    if _newclass:
        inactive = _swig_property(_bmc.DM_inactive_get, _bmc.DM_inactive_set)
    __swig_setmethods__["profiles_path"] = _bmc.DM_profiles_path_set
    __swig_getmethods__["profiles_path"] = _bmc.DM_profiles_path_get
    if _newclass:
        profiles_path = _swig_property(_bmc.DM_profiles_path_get, _bmc.DM_profiles_path_set)
    __swig_setmethods__["maps_path"] = _bmc.DM_maps_path_set
    __swig_getmethods__["maps_path"] = _bmc.DM_maps_path_get
    if _newclass:
        maps_path = _swig_property(_bmc.DM_maps_path_get, _bmc.DM_maps_path_set)
    __swig_setmethods__["cals_path"] = _bmc.DM_cals_path_set
    __swig_getmethods__["cals_path"] = _bmc.DM_cals_path_get
    if _newclass:
        cals_path = _swig_property(_bmc.DM_cals_path_get, _bmc.DM_cals_path_set)
    __swig_setmethods__["cal"] = _bmc.DM_cal_set
    __swig_getmethods__["cal"] = _bmc.DM_cal_get
    if _newclass:
        cal = _swig_property(_bmc.DM_cal_get, _bmc.DM_cal_set)
    __swig_setmethods__["serial_number"] = _bmc.DM_serial_number_set
    __swig_getmethods__["serial_number"] = _bmc.DM_serial_number_get
    if _newclass:
        serial_number = _swig_property(_bmc.DM_serial_number_get, _bmc.DM_serial_number_set)
    __swig_setmethods__["driver"] = _bmc.DM_driver_set
    __swig_getmethods__["driver"] = _bmc.DM_driver_get
    if _newclass:
        driver = _swig_property(_bmc.DM_driver_get, _bmc.DM_driver_set)
    __swig_setmethods__["priv"] = _bmc.DM_priv_set
    __swig_getmethods__["priv"] = _bmc.DM_priv_get
    if _newclass:
        priv = _swig_property(_bmc.DM_priv_get, _bmc.DM_priv_set)
    __swig_setmethods__["ActCountWidth"] = _bmc.DM_ActCountWidth_set
    __swig_getmethods__["ActCountWidth"] = _bmc.DM_ActCountWidth_get
    if _newclass:
        ActCountWidth = _swig_property(_bmc.DM_ActCountWidth_get, _bmc.DM_ActCountWidth_set)
    __swig_setmethods__["ActLayout"] = _bmc.DM_ActLayout_set
    __swig_getmethods__["ActLayout"] = _bmc.DM_ActLayout_get
    if _newclass:
        ActLayout = _swig_property(_bmc.DM_ActLayout_get, _bmc.DM_ActLayout_set)
    __swig_setmethods__["reserved"] = _bmc.DM_reserved_set
    __swig_getmethods__["reserved"] = _bmc.DM_reserved_get
    if _newclass:
        reserved = _swig_property(_bmc.DM_reserved_get, _bmc.DM_reserved_set)

    def __init__(self):
        """
        __init__(DM self) -> DM



        The DM struct stores the device info necessary to access the driver.  

        When passed to BMCOpen() this struct should have been allocated, but empty. The function will fill it in. For all other functions this struct is used as a means to pass all identifying values together.  

        Driver_type - Driver interface. USB, PCIe, or DPIO2. DevId - The driver's ID as seen by the system. ActCount - Number of actuators on the driver/mirror.  

        C++ includes: BMCDefs.h

        """
        this = _bmc.new_DM()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bmc.delete_DM
    __del__ = lambda self: None
DM_swigregister = _bmc.DM_swigregister
DM_swigregister(DM)

NO_ERR = _bmc.NO_ERR
ERR_UNKNOWN = _bmc.ERR_UNKNOWN
ERR_NO_HW = _bmc.ERR_NO_HW
ERR_INIT_DRIVER = _bmc.ERR_INIT_DRIVER
ERR_SERIAL_NUMBER = _bmc.ERR_SERIAL_NUMBER
ERR_MALLOC = _bmc.ERR_MALLOC
ERR_INVALID_DRIVER_TYPE = _bmc.ERR_INVALID_DRIVER_TYPE
ERR_INVALID_ACTUATOR_COUNT = _bmc.ERR_INVALID_ACTUATOR_COUNT
ERR_INVALID_LUT = _bmc.ERR_INVALID_LUT
ERR_ACTUATOR_ID = _bmc.ERR_ACTUATOR_ID
ERR_OPENFILE = _bmc.ERR_OPENFILE
ERR_NOT_IMPLEMENTED = _bmc.ERR_NOT_IMPLEMENTED
ERR_TIMEOUT = _bmc.ERR_TIMEOUT
ERR_POKE = _bmc.ERR_POKE
ERR_REGISTRY = _bmc.ERR_REGISTRY
ERR_PCIE_REGWR = _bmc.ERR_PCIE_REGWR
ERR_PCIE_REGRD = _bmc.ERR_PCIE_REGRD
ERR_PCIE_BURST = _bmc.ERR_PCIE_BURST
ERR_X64_ONLY = _bmc.ERR_X64_ONLY
ERR_PULSE_RANGE = _bmc.ERR_PULSE_RANGE
ERR_INVALID_SEQUENCE = _bmc.ERR_INVALID_SEQUENCE
ERR_INVALID_SEQUENCE_RATE = _bmc.ERR_INVALID_SEQUENCE_RATE
ERR_INVALID_DITHER_WVFRM = _bmc.ERR_INVALID_DITHER_WVFRM
ERR_INVALID_DITHER_GAIN = _bmc.ERR_INVALID_DITHER_GAIN
ERR_INVALID_DITHER_RATE = _bmc.ERR_INVALID_DITHER_RATE
ERR_BADARG = _bmc.ERR_BADARG
ERR_SEGMENT_ID = _bmc.ERR_SEGMENT_ID
ERR_INVALID_CALIBRATION = _bmc.ERR_INVALID_CALIBRATION
ERR_OUT_OF_LUT_RANGE = _bmc.ERR_OUT_OF_LUT_RANGE
ERR_DRIVER_NOT_OPEN = _bmc.ERR_DRIVER_NOT_OPEN
ERR_DRIVER_ALREADY_OPEN = _bmc.ERR_DRIVER_ALREADY_OPEN
ERR_FILE_PERMISSIONS = _bmc.ERR_FILE_PERMISSIONS
ERR_FILE_FORMAT = _bmc.ERR_FILE_FORMAT
ERR_USB_READ = _bmc.ERR_USB_READ
ERR_USB_WRITE = _bmc.ERR_USB_WRITE
ERR_USB_OTHER = _bmc.ERR_USB_OTHER
ERR_INVALID_COEFFICIENTS = _bmc.ERR_INVALID_COEFFICIENTS
BMC_LOG_ALL = _bmc.BMC_LOG_ALL
BMC_LOG_TRACE = _bmc.BMC_LOG_TRACE
BMC_LOG_DEBUG = _bmc.BMC_LOG_DEBUG
BMC_LOG_INFO = _bmc.BMC_LOG_INFO
BMC_LOG_WARN = _bmc.BMC_LOG_WARN
BMC_LOG_ERROR = _bmc.BMC_LOG_ERROR
BMC_LOG_FATAL = _bmc.BMC_LOG_FATAL
BMC_LOG_OFF = _bmc.BMC_LOG_OFF
DM_Piston = _bmc.DM_Piston
DM_XTilt = _bmc.DM_XTilt
DM_YTilt = _bmc.DM_YTilt
DM_SURFACE_DEFAULT_OPTIONS = _bmc.DM_SURFACE_DEFAULT_OPTIONS
DM_SURFACE_ABSOLUTE_DEFLECTION = _bmc.DM_SURFACE_ABSOLUTE_DEFLECTION
DM_SURFACE_BEST_EFFORT = _bmc.DM_SURFACE_BEST_EFFORT
class BmcDm(_object):
    """


    The BmcDm class represents one BMC DM with drive electronics.  

    Create an instance of this class, then initialize it by calling open_dm()  

    After opening the connection to the driver, use send_data(), send_data_custom_mapping(), poke(), or set_segment() to set the shape of the DM.  

    Some settings may be configured on the BmcDm object prior to calling open_dm(): see set_profiles_path(), set_maps_path(), and set_calibrations_path().  

    C++ includes: BmcDm.hpp

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BmcDm, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BmcDm, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
        __init__(BmcDm self) -> BmcDm



        """
        this = _bmc.new_BmcDm()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _bmc.delete_BmcDm
    __del__ = lambda self: None

    def open_dm(self, serial_number: 'char const *') -> "int":
        """
        open_dm(BmcDm self, char const * serial_number) -> int



        Open DM and driver with the specified serial number.  

        Opens the connection to the drive electronics. The necessary information (driver type, actuator count, maximum voltage, and mapping file) are read from a profile identified from the serial number.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_REGISTRY`, :const:`ERR_X64_ONLY`, :const:`ERR_INVALID_DRIVER_TYPE`, :const:`ERR_INIT_DRIVER`, :const:`ERR_NO_HW`, :const:`ERR_OPENFILE`, :const:`ERR_FILE_PERMISSIONS`, :const:`ERR_DRIVER_ALREADY_OPEN`, :const:`ERR_FILE_FORMAT`  

        :param str serial_number: 11 character serial number  

        :return: Error status.  

        """
        return _bmc.BmcDm_open_dm(self, serial_number)


    def send_data(self, data: 'DoubleVector') -> "int":
        """
        send_data(BmcDm self, DoubleVector data) -> int



        Set full array of actuator command values.  

        Sends a full frame of data specified by Value Array. Value array consists of double precision numbers in the range [0,1]. Values are converted to the correct output (DAC value) internally. Values outside the above range will be rounded to the appropriate end of the range.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_MALLOC`, :const:`ERR_X64_ONLY`, :const:`ERR_INVALID_DRIVER_TYPE`, :const:`ERR_NO_HW`, :const:`ERR_TIMEOUT`, :const:`ERR_PCIE_BURST`  

        :param list data: DoubleVector containing command values in the range [0,1]. Should have :meth:`num_actuators()` elements.  

        :return: Error status.  

        """
        return _bmc.BmcDm_send_data(self, data)


    def send_data_custom_mapping(self, data: 'DoubleVector', mapping: 'IntVector') -> "int":
        """
        send_data_custom_mapping(BmcDm self, DoubleVector data, IntVector mapping) -> int



        Set full array of actuator command values with custom driver mapping.  

        Sends a full frame of data specified by Value Array. Value array consists of double precision numbers in the range [0,1]. Values are converted to the correct output (DAC value) internally. Values outside the above range will be rounded to the appropriate end of the range.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_MALLOC`, :const:`ERR_X64_ONLY`, :const:`ERR_INVALID_DRIVER_TYPE`, :const:`ERR_NO_HW`, :const:`ERR_TIMEOUT`, :const:`ERR_PCIE_BURST`  

        :param list data: DoubleVector containing command values in the range [0,1]. Should have :meth:`num_actuators()` elements.  

        :param list mapping: IntVector containing the lookup table, or "mapping", to convert actuator numbers to driver channels. Should be at least the same size as the data.  

        :return: Error status.  

        """
        return _bmc.BmcDm_send_data_custom_mapping(self, data, mapping)


    def poke(self, actuator: 'int', data: 'double') -> "int":
        """
        poke(BmcDm self, int actuator, double data) -> int



        Set the command value of a single actuator, leaving all others unchanged.  

        Sets the value of a single actuator, i.e. "poke". Only PCIe based drivers can set one actuator independently of all others without needing to send an entire frame, but the frame is buffered internally for other drivers.  

        For drivers that require a channel mapping, the last loaded LUT is used.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_NOT_IMPLEMENTED`, :const:`ERR_X64_ONLY`, :const:`ERR_ACTUATOR_ID`, :const:`ERR_PCIE_REGWR`  

        :param int actuator: The actuator number to change.  

        :param double data: The actuator command value to write. This is converted to the correct DAC value internally.  

        :return: Error status.  

        """
        return _bmc.BmcDm_poke(self, actuator, data)


    def close_dm(self) -> "int":
        """
        close_dm(BmcDm self) -> int



        Close driver connection.  

        Sets the driver output to zero before closing.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_INVALID_DRIVER_TYPE`, :const:`ERR_NO_HW`, :const:`ERR_TIMEOUT`  

        :return: Error status.  

        """
        return _bmc.BmcDm_close_dm(self)


    def default_mapping(self) -> "std::vector< int,std::allocator< int > >":
        """
        default_mapping(BmcDm self) -> IntVector



        Get the default driver channel mapping.  

        :return: IntVector containing the lookup table, or "mapping", to convert actuator numbers to driver channels.  

        """
        return _bmc.BmcDm_default_mapping(self)


    def get_actuator_data(self) -> "std::vector< double,std::allocator< double > >":
        """
        get_actuator_data(BmcDm self) -> DoubleVector



        Get a copy of the full array of the last actuator command values.  

        :return: DoubleVector of command values of size :meth:`num_actuators()`  

        """
        return _bmc.BmcDm_get_actuator_data(self)


    def set_segment(self, segment: 'int', piston: 'double', xTilt: 'double', yTilt: 'double', applyOffsets: 'bool', sendNow: 'bool') -> "int":
        """
        set_segment(BmcDm self, int segment, double piston, double xTilt, double yTilt, bool applyOffsets, bool sendNow) -> int



        Set the Piston, X-Tilt, Y-Tilt, of a single segment of an SLM.  

        set_segment sets the tilt and piston value of a single segment of a segmented DM. Unlike the actuator commands, the values passed to this function are in user units.  

        A calibration table must be loaded before using this function.  

        Only PCIe based drivers can set one actuator independently of all others without needing to send an entire frame. Because some devices require an entire frame for all actuator DACs, the frame is buffered internally. Use *sendNow* to control sending the frame. The internally buffered frame may be overwritten by :meth:`poke()` or :meth:`send_data()`  

        Possible errors: :const:`NO_ERR`, :const:`ERR_NOT_IMPLEMENTED`, :const:`ERR_X64_ONLY`, :const:`ERR_ACTUATOR_ID`, :const:`ERR_PCIE_REGWR`, :const:`ERR_SEGMENT_ID`, :const:`ERR_INVALID_CALIBRATION`, :const:`ERR_OUT_OF_LUT_RANGE`  

        :param int segment: The segment number to change. For square segment or continuous face-sheet mirrors, this corresponds to the actuator number.  

        :param double piston: The piston command value in nm. This is converted to the correct DAC value(s) internally.  

        :param double xTilt: The X-Tilt command value in radians. This is converted to the correct DAC value(s) internally. This is ignored for square segment or continous face-sheet mirrors.  

        :param double yTilt: The Y-Tilt command value in radians. This is converted to the correct DAC value(s) internally. This is ignored for square segment or continous face-sheet mirrors.  

        :param bool applyOffsets: Subtract the unpowered DM shape from the commanded values. This should usually be set to True. The unpowered shape is provided in the calibration table.  

        :param bool sendNow: Send the frame of data to the DACs. If 0, the frame is buffered internally until this function is called with with sendNow=1 or :meth:`poke()` is called for a device that requires an entire frame.  

        :return: Error status.  

        """
        return _bmc.BmcDm_set_segment(self, segment, piston, xTilt, yTilt, applyOffsets, sendNow)


    def get_segment_range(self, segment: 'int', axis: 'DMSegmentAxis', piston: 'double', xTilt: 'double', yTilt: 'double', applyOffsets: 'bool') -> "int":
        """
        get_segment_range(BmcDm self, int segment, DMSegmentAxis axis, double piston, double xTilt, double yTilt, bool applyOffsets) -> int



        Get the Piston range for a given X-Tilt, Y-Tilt or tilt range given piston.  

        get_segment_range gets the range of values of a single segment of a segmented DM given values for the other two axes. Unlike the actuator commands, the values passed to this function are in user units.  

        A calibration table must be loaded before using this function.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_NOT_IMPLEMENTED`, :const:`ERR_ACTUATOR_ID`, :const:`ERR_SEGMENT_ID`, :const:`ERR_INVALID_CALIBRATION`, :const:`ERR_OUT_OF_LUT_RANGE`  

        :param segment: The segment number to query. For square segment or continuous face-sheet mirrors, this corresponds to the actuator number.  

        :param int axis: Query Piston, X-Tilt, or Y-Tilt. The given value for this axis is not used.  

        :param double piston: The piston command value in nm.  

        :param double xTilt: The X-Tilt command value in radians. This is converted to the correct DAC value(s) internally. This is ignored for square segment or continous face-sheet mirrors. This is ignored if *axis* == DM_XTilt.  

        :param double yTilt: The Y-Tilt command value in radians. This is converted to the correct DAC value(s) internally. This is ignored for square segment or continous face-sheet mirrors. This is ignored if *axis* == DM_YTilt.  

        :param bool applyOffsets: Subtract the unpowered DM shape from the commanded values. This should usually be set to True. The unpowered shape is provided in the calibration table. Use this consistently with the same parameter to :meth:`set_segment()`.  

        :return: Error status, minValue, maxValue  

        """
        return _bmc.BmcDm_get_segment_range(self, segment, axis, piston, xTilt, yTilt, applyOffsets)


    def load_calibration_file(self, filePath: 'char const *') -> "int":
        """
        load_calibration_file(BmcDm self, char const * filePath) -> int



        Read calibration file for user unit to DAC value conversion.  

        The calibration is only used by functions that accept user units.  

        The following file formats are supported: .MAT (MATLAB) Version 7.0  

        Possible errors: :const:`NO_ERR`, :const:`ERR_INVALID_DRIVER_TYPE`, :const:`ERR_NO_HW`, :const:`ERR_TIMEOUT`, :const:`ERR_ACTUATOR_ID`, :const:`ERR_INVALID_CALIBRATION`  

        :param str filePath: Path and name of calibration file.  

        :return: Error status.  

        """
        return _bmc.BmcDm_load_calibration_file(self, filePath)


    def num_actuators(self) -> "int":
        """
        num_actuators(BmcDm self) -> int



        The size of the mirror. :return: The size of the mirror.  

        """
        return _bmc.BmcDm_num_actuators(self)


    def num_actuators_width(self) -> "int":
        """
        num_actuators_width(BmcDm self) -> int



        The number of actuators across the mirror. :return: The number of actuators across the mirror.  

        """
        return _bmc.BmcDm_num_actuators_width(self)


    def get_status(self) -> "int":
        """
        get_status(BmcDm self) -> int



        The error status of the last command. :return: Error status.  

        """
        return _bmc.BmcDm_get_status(self)


    def error_string(self, error_code: 'int') -> "char const *":
        """
        error_string(BmcDm self, int error_code) -> char const *



        Error message for the given error code.  

        :param int error_code: Error status.  

        :return: Error message.  

        :rtype: str  

        """
        return _bmc.BmcDm_error_string(self, error_code)


    def set_profiles_path(self, profiles_path: 'char const *') -> "int":
        """
        set_profiles_path(BmcDm self, char const * profiles_path) -> int



        Set the path to search for driver profiles.  

        This effects future calls to :meth:`open_dm()` The default path is [Install Folder]/Profiles  

        Possible errors: :const:`NO_ERR`, :const:`ERR_REGISTRY`  

        :param str profiles_path: The path containing driver profiles.  

        :return: Error status.  

        """
        return _bmc.BmcDm_set_profiles_path(self, profiles_path)


    def set_maps_path(self, maps_path: 'char const *') -> "int":
        """
        set_maps_path(BmcDm self, char const * maps_path) -> int



        Set the path to search for driver mappings.  

        This effects future calls to :meth:`open_dm()` The default path is [Profiles Folder]/../Map  

        Possible errors: :const:`NO_ERR`, :const:`ERR_REGISTRY`  

        :param str maps_path: The path containing driver mappings.  

        :return: Error status.  

        """
        return _bmc.BmcDm_set_maps_path(self, maps_path)


    def set_calibrations_path(self, cals_path: 'char const *') -> "int":
        """
        set_calibrations_path(BmcDm self, char const * cals_path) -> int



        Set the path to search for calibration tables.  

        This effects future calls to :meth:`open_dm()` The default path is [Profiles Folder]/../Calibration  

        Possible errors: :const:`NO_ERR`, :const:`ERR_REGISTRY`  

        :param str cals_path: The path containing calibration tables.  

        :return: Error status.  

        """
        return _bmc.BmcDm_set_calibrations_path(self, cals_path)


    def configure_log(self, filePath: 'char const *', level: 'BMC_LOGLEVEL') -> "int":
        """
        configure_log(BmcDm self, char const * filePath, BMC_LOGLEVEL level) -> int



        Set the log file and log level.  

        The default log file is in the user's LOCALAPPDATA directory.  

        Call this before :meth:`open_dm()` to make sure the default file is not used. It may be called at any time to change the setting.  

        The default path is [LOCALAPPDATA]/Boston Micromachines/DM-SDK.log  

        Possible errors: :const:`NO_ERR`, :const:`ERR_REGISTRY`  

        :param str filePath: The full path of the log file.  

        :param int level: Minimum level for log messages. Set to :const:`BMC_LOG_ALL` for maximal debugging output.  

        :return: Error status.  

        """
        return _bmc.BmcDm_configure_log(self, filePath, level)


    def version_string() -> "char const *":
        """
        version_string() -> char const *



        Return string version number.  

        :return: Version number "X.Y.Z"  

        :rtype: str  

        """
        return _bmc.BmcDm_version_string()

    version_string = staticmethod(version_string)

    def configure_sequence(self, sequence: 'DoubleVector', delay: 'double', frame_length: 'int', seq_length: 'int') -> "int":
        """
        configure_sequence(BmcDm self, DoubleVector sequence, double delay, int frame_length, int seq_length) -> int



        Configure the sequencing hardware.  

        PCIe card only.  

        Configure the on board sequence functionality. Store a sequence of several DM patterns and the commands will transmit at a fixed frame rate or on the rising edge of the TTL input.  

        When the end of the sequence is reached the first pattern is repeated.  

        The delay parameter will delay the output up to 0.25 seconds after each TTL trigger.  

        The TTL or internal trigger is enabled based on the value of the framerate parameter to enable_sequence().  

        Possible errors: :const:`NO_ERR`, :const:`ERR_INVALID_DRIVER_TYPE` , :const:`ERR_INVALID_SEQUENCE`, :const:`ERR_INVALID_SEQUENCE_RATE`, :const:`ERR_PCIE_REGWR`  

        :param list sequence: array of length frame_length*seq_length. Max length is 4096 or 65536, depending on version, limited by FPGA memory.  

        :param double delay: Delay between the trigger and output of the next sequence frame. Range is [0,0.25] seconds.  

        :param int frame_length: The number of actuators in each frame, up to ActCount.  

        :param int seq_length: Number of frames.  

        :return: Error status.  

        """
        return _bmc.BmcDm_configure_sequence(self, sequence, delay, frame_length, seq_length)


    def enable_sequence(self, framerate: 'double', enable: 'bool') -> "int":
        """
        enable_sequence(BmcDm self, double framerate, bool enable) -> int



        Turn the sequencing functionality on or off.  

        Call configure_sequence() first.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_INVALID_SEQUENCE_RATE` , :const:`ERR_PCIE_REGWR`  

        :param double framerate: Frame rate of sequence frames. If the frame rate is 0 the TTL trigger input (SMA connector) will be used to advance frames.  

        :param bool enable: True to start sequencing. False to stop.  

        :return: Error status.  

        """
        return _bmc.BmcDm_enable_sequence(self, framerate, enable)


    def configure_dither(self, waveform: 'DoubleVector', gains: 'DoubleVector') -> "int":
        """
        configure_dither(BmcDm self, DoubleVector waveform, DoubleVector gains) -> int



        Configure the dithering functionality. The waveform is the sequence of frame magnitudes and gains is the value for each actuator that will be dither on each frame. So the value actuator j in frame i will be waveform[i]*gains[j].  

        Possible errors: :const:`NO_ERR`, :const:`ERR_INVALID_DRIVER_TYPE` , :const:`ERR_INVALID_DITHER_WVFRM`, :const:`ERR_INVALID_DITHER_GAIN`, :const:`ERR_PCIE_REGWR`  

        :param list waveform: Array of dither waveform in range [0,1]. Maximum length is 2048.  

        :param list gains: Array of actuator values to be dithered. This must match the mirror size in length.  

        :return: Error status.  

        """
        return _bmc.BmcDm_configure_dither(self, waveform, gains)


    def enable_dither(self, frame_rate: 'double', enable: 'bool') -> "int":
        """
        enable_dither(BmcDm self, double frame_rate, bool enable) -> int



        Turn the dithering functionality on or off.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_INVALID_DITHER_RATE` , :const:`ERR_PCIE_REGWR`  

        :param double frame_rate: Frame rate of dither frames.  

        :param bool enable: Turns dithering on or off.  

        :return: Error status.  

        """
        return _bmc.BmcDm_enable_dither(self, frame_rate, enable)


    def enable_high_res(self, enable: 'bool') -> "int":
        """
        enable_high_res(BmcDm self, bool enable) -> int



        Enables high resolution dithering functionality.  

        When this mode is active the firmware logic updates all actuators continuously at the maximum rate supported by the communications link or the DAC hardware, whichever is lower. Successive commands for a given actuator are incremented by one DAC count, or not, in a pattern based on the two bits of the commanded value which are just beyond the LSB of the DAC.  

        note: All other configuration is disabled while this is enabled.  

        note: Dither hardware must be installed.  

        note: Only supported with firmware version 6.0.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_INVALID_DRIVER_TYPE`, :const:`ERR_PCIE_REGRD`, :const:`ERR_PCIE_REGWR`, :const:`ERR_NOT_IMPLEMENTED`, :const:`ERR_INVALID_DITHER_RATE`, :const:`ERR_INVALID_SEQUENCE_RATE`  

        :param bool enable: True to enable high-res mode. False to disable.  

        :return: Error status.  

        """
        return _bmc.BmcDm_enable_high_res(self, enable)


    def set_device_id(self, device_id: 'int') -> "int":
        """
        set_device_id(BmcDm self, int device_id) -> int



        Set Device ID of driver.  

        For PCIe devices, the *device_id* field may be set to an index starting with 1 to select a PCIe interface card when more than one is installed. If set to 0 or a value higher than the number of cards, this field is ignored, except for the following special values.  

        Call this before :meth:`open_dm()`  

        If *device_id* is BMC_DEV_ID_QUERY_PROFILE, the driver is not opened and ERR_NO_HW is returned.  

        Possible errors: :const:`NO_ERR`, :const:`ERR_BADARG`  

        :param int device_id: Device ID starting with 1.  

        :return: Error status.  

        """
        return _bmc.BmcDm_set_device_id(self, device_id)


    def calculate_surface(self, phase_map_nm: 'DoubleVector', width: 'int', height: 'int', dm_diameter: 'int'=0, options: 'uint32_t'=DM_SURFACE_DEFAULT_OPTIONS) -> "int":
        """
        calculate_surface(BmcDm self, DoubleVector phase_map_nm, int width, int height, int dm_diameter=0, uint32_t options=DM_SURFACE_DEFAULT_OPTIONS) -> int
        calculate_surface(BmcDm self, DoubleVector phase_map_nm, int width, int height, int dm_diameter=0) -> int
        calculate_surface(BmcDm self, DoubleVector phase_map_nm, int width, int height) -> int



        Calculate the DM commands for the given high resolution phase map.  

        The output commands from this function can be sent to the DM using :meth:`send_data()`  

        Possible errors: :const:`NO_ERR`, :const:`ERR_NOT_IMPLEMENTED`, :const:`ERR_INVALID_ACTUATOR_COUNT`, :const:`ERR_BADARG`, :const:`ERR_INVALID_CALIBRATION`, :const:`ERR_OUT_OF_LUT_RANGE`  

        :param list phase_map_nm: 2D array of phase values in nanometers. Length is *width*height*.  

        :param int width: Width of 2D phase array  

        :param int height: Height of 2D phase array  

        :param int dm_diameter: Diameter of active aperture of the DM in actuator spans. Set to 0 to use the recommended default aperture, which is *pMirror->ActCountWidth - 3*. Set to *pMirror->ActCountWidth - 1* to use the full DM. Fractional actuator spans are not supported. For translation to *mm*, refer to the DM datasheet.  

        :param int options: Set to 0 for default options. Bit-wise mask of the following:  

        *   :const:`DM_SURFACE_ABSOLUTE_DEFLECTION`  
        *   :const:`DM_SURFACE_BEST_EFFORT`  

        :return: Error status, command map, downsampled phase map.  

        """
        return _bmc.BmcDm_calculate_surface(self, phase_map_nm, width, height, dm_diameter, options)


    def set_surface(self, phase_map_nm: 'DoubleVector', width: 'int', height: 'int', dm_diameter: 'int'=0, options: 'uint32_t'=DM_SURFACE_DEFAULT_OPTIONS) -> "int":
        """
        set_surface(BmcDm self, DoubleVector phase_map_nm, int width, int height, int dm_diameter=0, uint32_t options=DM_SURFACE_DEFAULT_OPTIONS) -> int
        set_surface(BmcDm self, DoubleVector phase_map_nm, int width, int height, int dm_diameter=0) -> int
        set_surface(BmcDm self, DoubleVector phase_map_nm, int width, int height) -> int



        Calculate and send the DM commands for the given phase map.  

        This function is provided for convenience. It is equivalent to :meth:`calculate_surface()` followd by :meth:`send_data()`  

        Possible errors: :const:`NO_ERR`, :const:`ERR_NOT_IMPLEMENTED`, :const:`ERR_INVALID_ACTUATOR_COUNT`, :const:`ERR_BADARG`, :const:`ERR_INVALID_CALIBRATION`, :const:`ERR_OUT_OF_LUT_RANGE`, any error from :meth:`send_data()`  

        :param list phase_map_nm: 2D array of phase values in nanometers. Length is width*height.  

        :param int width: Width of 2D phase array  

        :param int height: Height of 2D phase array  

        :param int dm_diameter: Diameter of active aperture of the DM in actuator spans. Set to 0 to use the recommended default aperture, which is *pMirror->ActCountWidth - 3*. Set to *pMirror->ActCountWidth - 1* to use the full DM.  
         Fractional actuator spans are not supported. For translation to *mm*, refer to the DM datasheet.  

        :param int options: Set to 0 for default options. Bit-wise mask of the following:  

        *   :const:`DM_SURFACE_ABSOLUTE_DEFLECTION`  
        *   :const:`DM_SURFACE_BEST_EFFORT`  

        :return: Error status.  

        """
        return _bmc.BmcDm_set_surface(self, phase_map_nm, width, height, dm_diameter, options)


    def zernike_surface(self, Zernike_coefficients: 'DoubleVector', dm_diameter: 'int'=0, options: 'uint32_t'=0) -> "int":
        """
        zernike_surface(BmcDm self, DoubleVector Zernike_coefficients, int dm_diameter=0, uint32_t options=0) -> int
        zernike_surface(BmcDm self, DoubleVector Zernike_coefficients, int dm_diameter=0) -> int
        zernike_surface(BmcDm self, DoubleVector Zernike_coefficients) -> int



        Calculate the phase map for a given set of Zernike coefficients.  

        This phase map can then be passed to :meth:`calculate_surface()` or :meth:`set_surface()`  

        The OSA convention is used for indexing Zernike coefficients.  

        :param list Zernike_coefficients: Array of Zernike coefficients.  

        :param int dm_diameter: Diameter of active aperture of the DM in actuator spans. Set to 0 to use the recommended default aperture, which is *pMirror->ActCountWidth - 3*. Set to *pMirror->ActCountWidth - 1* to use the full DM.  
         Fractional actuator spans are not supported. For translation to *mm*, refer to the DM datasheet.  

        :param int options: Not used, set to 0.  

        :return: Error status, low resolution phase map.  

        """
        return _bmc.BmcDm_zernike_surface(self, Zernike_coefficients, dm_diameter, options)

BmcDm_swigregister = _bmc.BmcDm_swigregister
BmcDm_swigregister(BmcDm)

def BmcDm_version_string() -> "char const *":
    """
    BmcDm_version_string() -> char const *



    Return string version number.  

    :return: Version number "X.Y.Z"  

    :rtype: str  

    """
    return _bmc.BmcDm_version_string()

# This file is compatible with both classic and new-style classes.


