"""manager

迁移 ID: 9c25f4ea773e
父迁移: 5740c5aae763
创建时间: 2025-08-22 13:19:09.881496

"""

from __future__ import annotations

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

revision: str = "9c25f4ea773e"
down_revision: str | Sequence[str] | None = "5740c5aae763"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "group_blacklist",
        sa.Column("group_id", sa.String(length=50), nullable=False),
        sa.Column("reason", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("group_id", name=op.f("pk_group_blacklist")),
        info={"bind_key": "manager"},
    )
    op.create_table(
        "private_blacklist",
        sa.Column("user_id", sa.String(length=50), nullable=False),
        sa.Column("reason", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("user_id", name=op.f("pk_private_blacklist")),
        info={"bind_key": "manager"},
    )
    # ### end Alembic commands ###


def downgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("private_blacklist")
    op.drop_table("group_blacklist")
    # ### end Alembic commands ###
