# WinToastCreator — модуль для отправки уведомлений в Windows

Лёгкий Python‑модуль (несколько КБ) для создания и управления всплывающими уведомлениями (toast) в Windows через WinRT API.

## Возможности

- Отправка простых уведомлений с заголовком и текстом.  
-Добавление иконок, изображений, прогресса.  
-Воспроизведение звуков и речи (TTS).  
-Обработка кликов, закрытия и ошибок.  
-Поддержка ввода и выбора в уведомлениях.  
-Обновление прогресса и очистка уведомлений.  
-Асинхронный и синхронный интерфейсы.

## Установка

Модуль не требует установки внешних зависимостей — использует встроенные WinRT‑библиотеки Windows.

pip install WinToastCreator

В таблице ниже перечислены все параметры, доступные в функциях `toast` и `toast_async`.

| Параметр | Тип | Описание |
|--------|------|--------|
| `title` | `str` | Заголовок уведомления. Отображается крупным шрифтом в верхней части. |
| `body` | `str` | Основной текст уведомления. Располагается под заголовком. |
| `on_click` | `callable` | Функция‑обработчик, вызываемая при клике по уведомлению. Принимает аргументы события. |
| `icon` | `str` / `dict` | Иконка уведомления: <br>– строка — путь к файлу иконки; <br>– словарь — с ключами `placement`, `hint-crop`, `src`. |
| `image` | `str` / `dict` | Дополнительное изображение: <br>– строка — путь к файлу; <br>– словарь — с ключами `src`, `placement`. |
| `progress` | `dict` | Параметры индикатора прогресса: ключи `value` (доля, напр. `0.5`), `title` (заголовок прогресса), `status` (текст статуса). |
| `audio` | `str` / `dict` | Звук уведомления: <br>– строка — путь к аудиофайлу или системный префикс `ms-` (напр. `ms-wakeup`); <br>– словарь — с ключом `src`. |
| `dialogue` | `str` | Текст для озвучивания через синтез речи (TTS). Будет произнесён при показе уведомления. |
| `duration` | `str` | Длительность отображения: `"short"` (короткий) или `"long"` (длинный). |
| `input` | `str` / `dict` | Поле ввода: <br>– строка — ID поля; <br>– словарь — с ключами `id`, `type` (`"text"` и др.), `placeHolderContent` (подсказка). |
| `inputs` | `list` | Список полей ввода (каждый элемент — строка или словарь, как для `input`). |
| `selection` | `str` / `list` | Элемент выбора: <br>– строка — значение элемента; <br>– список — набор вариантов (каждый — строка или словарь с `id`, `content`). |
| `selections` | `list` | Список элементов выбора (каждый — строка или словарь с `id`, `content`). |
| `button` | `str` / `dict` | Кнопка: <br>– строка — текст кнопки (и аргумент запуска); <br>– словарь — с ключами `content` (текст), `activationType` (тип активации), `arguments` (аргументы запуска). |
| `buttons` | `list` | Список кнопок (каждый элемент — строка или словарь, как для `button`). |
| `xml` | `str` | Шаблон XML для уведомления. По умолчанию — стандартный toast‑шаблон. |
| `app_id` | `str` | ID приложения, под которым показывается уведомление. По умолчанию: `"Python"`. |
| `ocr` | `str` / `dict` | Путь к изображению для распознавания текста (OCR): <br>– строка — путь к файлу; <br>– словарь — с ключом `ocr` (путь) и опционально `lang` (язык). |
| `on_dismissed` | `callable` | Функция‑обработчик, вызываемая при закрытии уведомления. Принимает аргумент события. |
| `on_failed` | `callable` | Функция‑обработчик, вызываемая при ошибке показа уведомления. Принимает аргумент ошибки. |
| `scenario` | `str` | Сценарий уведомления (напр., `"email"`, `"im"`, `"reminder"`). Влияет на поведение и внешний вид. |
| `tag` | `str` | Тег уведомления. Используется для идентификации при обновлении или удалении. |
| `group` | `str` | Группа уведомлений. Позволяет управлять набором уведомлений по группе (очистка, обновление). |
| `timeout` | `float` | Тайм‑аут в секундах для ожидания событий (клик, закрытие и т.п.). По истечении — функция завершается. |


**Примечания:**
- Для обновления прогресса или очистки уведомлений обязательно указывайте `group` (иначе возникнет ошибка).
- Параметры `tag` и `group` работают совместно: чтобы удалить/обновить конкретное уведомление, нужны оба значения.
- Системные звуки (`audio` с префиксом `ms-`) зависят от локализации и версии Windows.

Примеры использования

1. Простое уведомление
python
toast("Готово!", "Файл загружен успешно")

2. Уведомление с кнопкой
python
toast(
    "Открыть сайт",
    "Перейдите на наш ресурс",
    button="https://example.com",
    on_click=lambda e: print("Клик:", e['arguments'])
)

3. Уведомление с прогрессом
python
toast("Загрузка...", "Идет загрузка файла", progress={'value': '0.5', 'title': 'Прогресс', 'status': '50%'})

4. Обновление прогресса
python
toast("Загрузка", "Начата...", tag="download", group="files")
update_progress({'value': '0.8', 'status': '80%'}, tag="download", group="files")

5. Очистка уведомлений
python
clear_toast(group="files")  # Удалить все уведомления группы "files"
clear_toast(tag="download", group="files")  # Удалить по тегу и группе

6. Асинхронное уведомление с TTS
python
async def show_notification():
    await atoast("Внимание", "Это сообщение будет озвучено", dialogue="Привет, это TTS!")

asyncio.run(show_notification())

7. Распознавание текста с изображения (OCR)
python
toast("OCR", ocr="path/to/image.png")  # Результат появится в теле уведомления
Примечания
Требуется Windows 10/11 с поддержкой WinRT.

Для работы OCR может потребоваться установка языковых пакетов (см. available_recognizer_languages()).

Звуки (audio) могут быть локальными файлами или системными (ms‑wakeup, ms‑call, и т.п.).

Поля ввода и выбора работают только в поддерживаемых сценариях Windows.

Для обновления/очистки уведомлений обязательно указывайте group (иначе возникнет ошибка).

Вспомогательные функции
available_recognizer_languages() — выводит список доступных языков OCR.

play_sound(audio) — воспроизводит звук (асинхронно).

speak(text) — озвучивает текст (TTS, асинхронно).

recognize(ocr) — распознаёт текст с изображения (OCR).

Лицензия
MIT — свободно используйте, модифицируйте и распространяйте.

Версия: 0.1.0