from django_spire.knowledge.entry.version.block.blocks.heading_block import HeadingBlock
from django_spire.knowledge.entry.version.block.blocks.sub_heading_block import \
    SubHeadingBlock
from django_spire.knowledge.entry.version.block.blocks.text_block import TextBlock


LADDER_SAFETY_BLOCKS = [
    HeadingBlock(value='Ladder Safety: A Journey Through the Heights'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Great Ladder Adventure Begins'),
    TextBlock(value='Welcome to the thrilling world of ladder safety! Grab your hard hats and let\'s explore the wonderful dangers of working at heights.'),
    TextBlock(value='Whether you\'re a seasoned climber or a first-time ladder user, this guide will help you navigate the exciting landscape of aerial safety.'),
    TextBlock(value=''),
    SubHeadingBlock(value='High vs. Low: The Ladder Tightrope'),
    TextBlock(value='High ladders are like climbing Mount Everest - exciting but dangerous! Always double-check your footing and support.'),
    TextBlock(value='Low ladders might seem harmless, but they\'re like slippery snakes waiting to trip you up! Keep them out of high-traffic areas.'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Ladder Safety Toolkit'),
    TextBlock(value='Inspect your ladder like a detective looking for clues - check for cracks, rust, or missing rungs.'),
    TextBlock(value='Remember: Three points of contact keeps you safe and sound!'),
    TextBlock(value='Never exceed the weight limit - your ladder has a maximum capacity just like you have a maximum capacity for pizza!'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency: The Ladder Rescue Mission'),
    TextBlock(value='If you find yourself in a precarious situation, stay calm and follow the emergency protocols.'),
    TextBlock(value='First aid training is like having a superhero power - it\'s invaluable when you need it most!'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Ladder Safety Certificate'),
    TextBlock(value='Congratulations! You\'ve completed your ladder safety course. Now go out there and climb with confidence!'),
]

KITCHEN_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Kitchen Safety: A Culinary Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Great Kitchen Escape'),
    TextBlock(value='Welcome to the thrilling world of kitchen safety! Every chef needs to know how to navigate the kitchen without getting burned, cut, or startled by hot oil.'),
    TextBlock(value='Whether you\'re a professional chef or a home cook, these safety tips will help you avoid kitchen disasters and keep your cooking adventures safe.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Hot Oil: The Dangerous Dance'),
    TextBlock(value='Hot oil is like a wild animal - it can splash and burn in seconds! Always use proper protective gear when handling hot oil.'),
    TextBlock(value='Never leave hot oil unattended, or you\'ll end up with a kitchen fire that\'s more exciting than your favorite TV show!'),
    TextBlock(value=''),
    SubHeadingBlock(value='Knife Safety: The Sharp Edge of Responsibility'),
    TextBlock(value='Knives are like any other tool - they\'re only as dangerous as the person using them.'),
    TextBlock(value='Always cut away from your body and keep your knives sharp (dull knives are actually more dangerous than sharp ones).'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Kitchen Procedures'),
    TextBlock(value='If you encounter a kitchen emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having a fire extinguisher in the kitchen is like having a superhero sidekick - it\'s always good to have backup!'),
]

GARDEN_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Garden Safety: A Green Thumb Guide'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Garden Adventure Begins'),
    TextBlock(value='Step into the wonderful world of gardening with safety as your companion! Every gardener should know how to protect themselves from thorns, chemicals, and unexpected wildlife.'),
    TextBlock(value='Whether you\'re tending to a small potted plant or a large garden, these tips will keep you safe while you nurture your green thumb.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Chemical Safety: The Poisonous Garden'),
    TextBlock(value='Gardening chemicals can be like hidden traps - they look harmless but can cause serious harm if not handled properly.'),
    TextBlock(value='Always read labels and wear protective gear when working with fertilizers, pesticides, or other garden chemicals.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Tool Safety: The Gardener\'s Arsenal'),
    TextBlock(value='Gardening tools are like weapons - they\'re only as dangerous as the person wielding them.'),
    TextBlock(value='Keep your tools sharp and clean to prevent accidents and ensure maximum efficiency in your garden work.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Garden Procedures'),
    TextBlock(value='If you encounter a garden emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having a first aid kit in the garden is like having a superhero sidekick - it\'s always good to have backup!'),
]

OFFICE_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Office Safety: A Professional Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Office Escape'),
    TextBlock(value='Welcome to the exciting world of office safety! Every professional should know how to navigate their workspace without tripping, falling, or getting distracted by a rogue cable.'),
    TextBlock(value='Whether you\'re working in a bustling office or a quiet cubicle, these safety tips will help you avoid workplace disasters and keep your productivity high.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Cable Safety: The Hidden Danger'),
    TextBlock(value='Office cables are like snakes waiting to strike - they can trip you up if you\'re not careful!'),
    TextBlock(value='Always secure cables properly and keep walkways clear of obstacles.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Ergonomic Safety: The Comfort Zone'),
    TextBlock(value='Proper ergonomics in the office are like having a personal assistant - they make everything easier and more comfortable.'),
    TextBlock(value='Adjust your chair, monitor, and keyboard to prevent strain and injury.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Office Procedures'),
    TextBlock(value='If you encounter an office emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having a fire extinguisher in the office is like having a superhero sidekick - it\'s always good to have backup!'),
]

POOL_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Swimming Pool Safety: A Water Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Pool Party Begins'),
    TextBlock(value='Dive into the exciting world of pool safety! Every swimmer should know how to protect themselves from drowning, sunburn, and unexpected water hazards.'),
    TextBlock(value='Whether you\'re swimming in a backyard pool or a public facility, these tips will keep you safe while you enjoy the water.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Water Safety: The Deep End'),
    TextBlock(value='Pool water can be deceiving - it looks calm but can hide dangerous situations!'),
    TextBlock(value='Always swim with a buddy and never dive into shallow water.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Sun Protection: The Beach Adventure'),
    TextBlock(value='Sun exposure is like a wild animal - it can burn you in seconds!'),
    TextBlock(value='Apply sunscreen regularly and wear protective clothing to avoid sunburn and skin damage.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Pool Procedures'),
    TextBlock(value='If you encounter a pool emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having lifeguards on duty is like having a superhero sidekick - it\'s always good to have backup!'),
]

CONSTRUCTION_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Construction Safety: A Building Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Construction Zone'),
    TextBlock(value='Step into the exciting world of construction safety! Every builder should know how to protect themselves from falling objects, electrical hazards, and unexpected structural issues.'),
    TextBlock(value='Whether you\'re working on a skyscraper or a small home renovation, these safety tips will keep you safe while you build your dreams.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Falling Object Safety: The Sky is Falling'),
    TextBlock(value='Construction sites are like a battlefield - falling objects can strike at any moment!'),
    TextBlock(value='Always wear proper head protection and stay clear of work zones.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Electrical Safety: The Power Adventure'),
    TextBlock(value='Electricity is like a wild animal - it can shock you in seconds!'),
    TextBlock(value='Always check electrical equipment before use and never work on live circuits.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Construction Procedures'),
    TextBlock(value='If you encounter a construction emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having safety officers on site is like having a superhero sidekick - it\'s always good to have backup!'),
]

CYCLING_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Bicycle Safety: A Cycling Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Road Ahead'),
    TextBlock(value='Ride into the exciting world of bicycle safety! Every cyclist should know how to protect themselves from traffic, weather hazards, and mechanical failures.'),
    TextBlock(value='Whether you\'re commuting or going for a weekend ride, these tips will keep you safe while you enjoy the open road.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Traffic Safety: The Highway Adventure'),
    TextBlock(value='Riding in traffic is like navigating a busy city - always stay alert and follow traffic rules!'),
    TextBlock(value='Always wear a helmet and make sure your bike is properly equipped with lights and reflectors.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Weather Safety: The Elements Adventure'),
    TextBlock(value='Weather conditions can change quickly - always check the forecast before heading out!'),
    TextBlock(value='Avoid riding in rain or snow without proper gear and equipment.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Bicycle Procedures'),
    TextBlock(value='If you encounter a bicycle emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having a repair kit on hand is like having a superhero sidekick - it\'s always good to have backup!'),
]

FIRE_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Fire Safety: A Blaze Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Fire Escape'),
    TextBlock(value='Enter the exciting world of fire safety! Every person should know how to protect themselves from flames, smoke, and unexpected fires.'),
    TextBlock(value='Whether you\'re at home or in a public building, these tips will keep you safe while you navigate fire hazards.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Fire Prevention: The Prevention Adventure'),
    TextBlock(value='Prevention is better than cure - always keep fire extinguishers accessible and never leave candles unattended!'),
    TextBlock(value='Keep flammable materials away from heat sources and maintain proper ventilation.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Evacuation Safety: The Escape Route'),
    TextBlock(value='Knowing your escape routes is like having a superhero power - it\'s invaluable when you need it most!'),
    TextBlock(value='Always practice evacuation drills and keep emergency contact information handy.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Fire Procedures'),
    TextBlock(value='If you encounter a fire emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having fire safety training is like having a superhero sidekick - it\'s always good to have backup!'),
]

HIKING_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Hiking Safety: A Mountain Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Trail Ahead'),
    TextBlock(value='Embark on the exciting world of hiking safety! Every hiker should know how to protect themselves from weather hazards, wildlife encounters, and unexpected terrain.'),
    TextBlock(value='Whether you\'re taking a short walk or a multi-day trek, these tips will keep you safe while you explore nature.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Weather Safety: The Elements Adventure'),
    TextBlock(value='Weather conditions can change quickly in the wilderness - always check forecasts before heading out!'),
    TextBlock(value='Pack appropriate gear for all weather conditions and never hike alone in dangerous areas.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Wildlife Safety: The Animal Encounter'),
    TextBlock(value='Wild animals are like wild cards - they can appear at any moment and behave unpredictably!'),
    TextBlock(value='Keep food stored properly and maintain a safe distance from wildlife.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Hiking Procedures'),
    TextBlock(value='If you encounter a hiking emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having a first aid kit and emergency communication device is like having a superhero sidekick - it\'s always good to have backup!'),
]

BOATING_SAFETY_BLOCKS = [
    TextBlock(value=''),
    HeadingBlock(value='Boating Safety: A Water Adventure'),
    TextBlock(value=''),
    SubHeadingBlock(value='The Ocean Escape'),
    TextBlock(value='Set sail into the exciting world of boating safety! Every sailor should know how to protect themselves from water hazards, weather conditions, and unexpected emergencies.'),
    TextBlock(value='Whether you\'re on a small boat or a large vessel, these tips will keep you safe while you enjoy the water.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Water Safety: The Ocean Adventure'),
    TextBlock(value='Boating on water is like navigating a wild ocean - always stay alert and follow safety protocols!'),
    TextBlock(value='Always wear life jackets and check weather conditions before heading out.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Navigation Safety: The Compass Adventure'),
    TextBlock(value='Proper navigation is like having a superhero power - it\'s invaluable when you need it most!'),
    TextBlock(value='Use proper navigation equipment and never navigate without a backup plan.'),
    TextBlock(value=''),
    SubHeadingBlock(value='Emergency Boating Procedures'),
    TextBlock(value='If you encounter a boating emergency, stay calm and follow established protocols.'),
    TextBlock(value='Having safety equipment on board is like having a superhero sidekick - it\'s always good to have backup!'),
]


SAFETY_BLOCKS = [
    LADDER_SAFETY_BLOCKS,
    KITCHEN_SAFETY_BLOCKS,
    GARDEN_SAFETY_BLOCKS,
    OFFICE_SAFETY_BLOCKS,
    POOL_SAFETY_BLOCKS,
    CONSTRUCTION_SAFETY_BLOCKS,
    CYCLING_SAFETY_BLOCKS,
    FIRE_SAFETY_BLOCKS,
    HIKING_SAFETY_BLOCKS,
    BOATING_SAFETY_BLOCKS,
]
