# Generated by Django 5.2.3 on 2025-08-04 15:39

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('django_spire_auth_user', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, editable=False)),
                ('is_deleted', models.BooleanField(default=False, editable=False)),
                ('created_datetime', models.DateTimeField(default=django.utils.timezone.localtime, editable=False)),
                ('order', models.PositiveIntegerField(default=0, editable=False)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField()),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', related_query_name='child', to='django_spire_knowledge.collection')),
            ],
            options={
                'verbose_name': 'Collection',
                'verbose_name_plural': 'Collections',
                'db_table': 'django_spire_knowledge_collection',
            },
        ),
        migrations.CreateModel(
            name='Entry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, editable=False)),
                ('is_deleted', models.BooleanField(default=False, editable=False)),
                ('created_datetime', models.DateTimeField(default=django.utils.timezone.localtime, editable=False)),
                ('order', models.PositiveIntegerField(default=0, editable=False)),
                ('name', models.CharField(max_length=255)),
                ('collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entries', related_query_name='entry', to='django_spire_knowledge.collection')),
            ],
            options={
                'verbose_name': 'Entry',
                'verbose_name_plural': 'Entries',
                'db_table': 'django_spire_knowledge_entry',
            },
        ),
        migrations.CreateModel(
            name='EntryVersion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, editable=False)),
                ('is_deleted', models.BooleanField(default=False, editable=False)),
                ('created_datetime', models.DateTimeField(default=django.utils.timezone.localtime, editable=False)),
                ('published_datetime', models.DateTimeField(blank=True, null=True)),
                ('last_edit_datetime', models.DateTimeField(default=django.utils.timezone.now)),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('published', 'Published'), ('archived', 'Archived')], default='draft', max_length=32)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entry_versions', related_query_name='entry_version', to='django_spire_auth_user.authuser')),
                ('entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='versions', related_query_name='version', to='django_spire_knowledge.entry')),
            ],
            options={
                'verbose_name': 'Entry Version',
                'verbose_name_plural': 'Entry Versions',
                'db_table': 'django_spire_knowledge_entry_version',
            },
        ),
        migrations.AddField(
            model_name='entry',
            name='current_version',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='current_version', related_query_name='current_version', to='django_spire_knowledge.entryversion'),
        ),
        migrations.CreateModel(
            name='EntryVersionBlock',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True, editable=False)),
                ('is_deleted', models.BooleanField(default=False, editable=False)),
                ('created_datetime', models.DateTimeField(default=django.utils.timezone.localtime, editable=False)),
                ('order', models.PositiveIntegerField(default=0, editable=False)),
                ('type', models.CharField(choices=[('text', 'Text'), ('heading', 'Heading'), ('sub_heading', 'Sub Heading')], default='text', max_length=32)),
                ('_block_data', models.JSONField()),
                ('_text_data', models.TextField()),
                ('version', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='blocks', related_query_name='block', to='django_spire_knowledge.entryversion')),
            ],
            options={
                'verbose_name': 'Block',
                'verbose_name_plural': 'Blocks',
                'db_table': 'django_spire_knowledge_entry_version_block',
            },
        ),
    ]
