"""ryo3-fspath types"""

import typing as t
from os import PathLike
from pathlib import Path

from ry._types import Buffer, ToPy
from ry.ryo3._bytes import Bytes
from ry.ryo3._regex import Regex
from ry.ryo3._std import Metadata

# =============================================================================
# FSPATH
# =============================================================================
@t.final
class FsPath(ToPy[Path]):
    def __init__(self, path: PathLike[str] | str | None = None) -> None: ...
    def __fspath__(self) -> str: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __lt__(self, other: PathLike[str] | str) -> bool: ...
    def __le__(self, other: PathLike[str] | str) -> bool: ...
    def __gt__(self, other: PathLike[str] | str) -> bool: ...
    def __ge__(self, other: PathLike[str] | str) -> bool: ...
    def __truediv__(self, other: PathLike[str] | str) -> FsPath: ...
    def __rtruediv__(self, other: PathLike[str] | str) -> FsPath: ...
    def __bytes__(self) -> bytes: ...
    def to_py(self) -> Path: ...
    def to_pathlib(self) -> Path: ...
    # =========================================================================
    # IO
    # =========================================================================
    def read(self) -> Bytes: ...
    def read_bytes(self) -> bytes: ...
    def read_text(self) -> str: ...
    def write(self, data: Buffer | bytes) -> None: ...
    def write_bytes(self, data: Buffer | bytes) -> None: ...
    def write_text(self, data: str) -> None: ...
    def open(
        self,
        mode: str,
        buffering: int = -1,
        encoding: str | None = None,
        errors: str | None = None,
        newline: str | None = None,
    ) -> t.IO[t.Any]: ...

    # =========================================================================
    # METHODS
    # =========================================================================
    def absolute(self) -> FsPath: ...
    def as_posix(self) -> str: ...
    def as_uri(self) -> str: ...
    def clone(self) -> FsPath: ...
    def equiv(self, other: PathLike[str] | str | FsPath) -> bool: ...
    def exists(self) -> bool: ...
    def iterdir(self) -> FsPathReaddir: ...
    def join(self, *paths: str) -> FsPath: ...
    def joinpath(self, *paths: str) -> FsPath: ...
    def metadata(self) -> Metadata: ...
    def mkdir(
        self, mode: int = 0o777, parents: bool = False, exist_ok: bool = False
    ) -> None: ...
    def read_dir(self) -> FsPathReaddir: ...
    def read_link(self) -> FsPath: ...
    def relative_to(self, other: PathLike[str] | str) -> FsPath: ...
    def rename(self, new_path: PathLike[str] | str) -> FsPath: ...
    def replace(self, new_path: PathLike[str] | str) -> FsPath: ...
    def resolve(self) -> FsPath: ...
    def rmdir(self, recursive: bool = False) -> None: ...
    def string(self) -> str: ...
    def unlink(self, missing_ok: bool = False, recursive: bool = False) -> None: ...
    def with_name(self, name: str) -> FsPath: ...
    def with_suffix(self, suffix: str) -> FsPath: ...

    # =========================================================================
    # CLASSMETHODS
    # =========================================================================
    @classmethod
    def cwd(cls) -> FsPath: ...
    @classmethod
    def home(cls) -> FsPath: ...

    # =========================================================================
    # PROPERTIES
    # =========================================================================
    @property
    def anchor(self) -> str: ...
    @property
    def drive(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def parent(self) -> FsPath: ...
    @property
    def parents(self) -> t.Sequence[FsPath]: ...
    @property
    def parts(self) -> tuple[str, ...]: ...
    @property
    def root(self) -> str: ...
    @property
    def stem(self) -> str: ...
    @property
    def suffix(self) -> str: ...
    @property
    def suffixes(self) -> list[str]: ...

    # =========================================================================
    # std::path::PathBuf (deref -> std::path::Path)
    # =========================================================================
    def ancestors(self) -> t.Iterator[FsPath]: ...
    def canonicalize(self) -> FsPath: ...
    def components(self) -> t.Iterator[FsPath]: ...
    def display(self) -> str: ...
    def ends_with(self, path: PathLike[str] | str) -> bool: ...
    def extension(self) -> str: ...
    def file_name(self) -> str: ...
    def file_prefix(self) -> FsPath: ...
    def file_stem(self) -> str: ...
    def has_root(self) -> bool: ...
    def is_absolute(self) -> bool: ...
    def is_dir(self) -> bool: ...
    def is_file(self) -> bool: ...
    def is_relative(self) -> bool: ...
    def is_symlink(self) -> bool: ...
    def starts_with(self, path: PathLike[str] | str) -> bool: ...
    def strip_prefix(self, prefix: PathLike[str] | str) -> FsPath: ...
    def with_extension(self, ext: str) -> FsPath: ...
    def with_file_name(self, name: str) -> FsPath: ...

    # =========================================================================
    # FEATURE: `same-file`
    # =========================================================================
    def samefile(self, other: PathLike[str] | str | FsPath) -> bool: ...
    def symlink_metadata(self) -> Metadata: ...

    # =========================================================================
    # FEATURE: `which` & `which-regex`
    # =========================================================================
    @staticmethod
    def which(cmd: str, path: str) -> FsPath | None: ...
    @staticmethod
    def which_all(cmd: str, path: str) -> list[FsPath]: ...
    @staticmethod
    def which_re(regex: str | Regex, path: str) -> FsPath | None: ...

class FsPathReaddir:
    def __init__(self) -> t.NoReturn: ...
    def __iter__(self) -> t.Iterator[FsPath]: ...
    def __next__(self) -> FsPath: ...
    def collect(self) -> list[FsPath]: ...
    def take(self, n: int) -> list[FsPath]: ...
