"""ryo4-tokio types"""

import pathlib
import typing as t
from collections.abc import Generator
from types import TracebackType

import typing_extensions as te

from ry import Bytes
from ry._types import Buffer, FsPathLike
from ry.ryo3._std import FileType, Metadata

# =============================================================================
# FS
# =============================================================================
async def canonicalize_async(path: FsPathLike) -> FsPathLike: ...
async def copy_async(src: FsPathLike, dst: FsPathLike) -> None: ...
async def create_dir_async(path: FsPathLike) -> None: ...
async def create_dir_all_async(path: FsPathLike) -> None: ...
async def hard_link_async(src: FsPathLike, dst: FsPathLike) -> None: ...
async def metadata_async(path: FsPathLike) -> None: ...
async def read_async(path: FsPathLike) -> Bytes: ...
async def remove_dir_async(path: FsPathLike) -> None: ...
async def remove_dir_all_async(path: FsPathLike) -> None: ...
async def remove_file_async(path: FsPathLike) -> None: ...
async def read_link_async(path: FsPathLike) -> FsPathLike: ...
async def read_to_string_async(path: FsPathLike) -> str: ...
async def rename_async(src: FsPathLike, dst: FsPathLike) -> None: ...
async def write_async(path: FsPathLike, data: Buffer) -> None: ...
async def try_exists_async(path: FsPathLike) -> bool: ...
async def exists_async(path: FsPathLike) -> bool: ...
@t.final
class DirEntryAsync:
    def __fspath__(self) -> str: ...
    @property
    def path(self) -> pathlib.Path: ...
    @property
    def basename(self) -> str: ...
    @property
    async def metadata(self) -> Metadata: ...
    @property
    async def file_type(self) -> FileType: ...

@t.final
class ReadDirAsync:
    """Async iterator for read_dir_async"""

    def __aiter__(self) -> ReadDirAsync: ...
    async def __anext__(self) -> DirEntryAsync: ...
    async def collect(self) -> list[DirEntryAsync]: ...
    async def take(self, n: int) -> list[DirEntryAsync]: ...

async def read_dir_async(path: FsPathLike) -> ReadDirAsync: ...

# =============================================================================
# SLEEP
# =============================================================================
async def sleep_async(seconds: float) -> float: ...
async def asleep(seconds: float) -> float:
    """Alias for sleep_async"""
@t.final
class AsyncFile:
    def __init__(
        self, path: FsPathLike, mode: str = "r", buffering: int = -1
    ) -> None: ...
    def __aiter__(self) -> te.Self: ...
    def __await__(self) -> Generator[t.Any, t.Any, te.Self]: ...
    async def __anext__(self) -> Bytes: ...
    async def __aenter__(self) -> te.Self: ...
    async def __aexit__(
        self,
        exc_type: type[BaseException] | None,
        exc_val: BaseException | None,
        exc_tb: TracebackType | None,
    ) -> None: ...
    async def close(self) -> None: ...
    async def flush(self) -> None: ...
    async def isatty(self) -> te.NoReturn: ...
    async def open(self) -> None: ...
    async def peek(self, size: int = ..., /) -> Bytes: ...
    async def read(self, size: int = ..., /) -> Bytes: ...
    async def readable(self) -> bool: ...
    async def readall(self) -> Bytes: ...
    async def readline(self, size: int | None = ..., /) -> Bytes: ...
    async def readlines(self, hint: int = ..., /) -> list[Bytes]: ...
    async def seek(self, offset: int, whence: int = ..., /) -> int: ...
    async def seekable(self) -> bool: ...
    async def tell(self) -> int: ...
    async def truncate(self, size: int | None = ..., /) -> int: ...
    async def writable(self) -> bool: ...
    async def write(self, b: Buffer, /) -> int: ...
    @property
    def closed(self) -> bool: ...

def aiopen(path: FsPathLike, mode: str = "r", buffering: int = -1) -> AsyncFile: ...
