import builtins
import datetime as pydt
import uuid
from collections.abc import Callable as Callable
from typing import Any

from pydantic import GetCoreSchemaHandler as GetCoreSchemaHandler
from pydantic import ValidatorFunctionWrapHandler as ValidatorFunctionWrapHandler
from pydantic_core import CoreSchema as CoreSchema

class ULID:
    def __init__(self, value: builtins.bytes | str | None = None) -> None: ...

    # ----------------
    # INSTANCE METHODS
    # ----------------
    def to_uuid(self) -> uuid.UUID: ...
    def to_uuid4(self) -> uuid.UUID: ...

    # -------
    # DUNDERS
    # -------
    def __int__(self) -> int: ...
    def __bytes__(self) -> builtins.bytes: ...
    def __lt__(self, other: int | str | ULID | builtins.bytes) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __ge__(self, other: int | str | ULID | builtins.bytes) -> bool: ...
    def __gt__(self, other: int | str | ULID | builtins.bytes) -> bool: ...
    def __le__(self, other: int | str | ULID | builtins.bytes) -> bool: ...

    # ----------
    # PROPERTIES
    # ----------
    @property
    def bytes(self) -> builtins.bytes: ...
    @property
    def milliseconds(self) -> int: ...
    @property
    def timestamp(self) -> float: ...
    @property
    def datetime(self) -> pydt.datetime: ...
    @property
    def hex(self) -> str: ...

    # -------------
    # CLASS METHODS
    # -------------
    @classmethod
    def from_datetime(cls, value: pydt.datetime) -> ULID: ...
    @classmethod
    def from_timestamp(cls, value: float) -> ULID: ...
    @classmethod
    def from_uuid(cls, value: uuid.UUID) -> ULID: ...
    @classmethod
    def from_bytes(cls, bytes_: builtins.bytes) -> ULID: ...
    @classmethod
    def from_hex(cls, value: str) -> ULID: ...
    @classmethod
    def from_str(cls, string: str) -> ULID: ...
    @classmethod
    def from_int(cls, value: int) -> ULID: ...
    @classmethod
    def parse(cls, value: Any) -> ULID: ...

    # --------
    # PYDANTIC
    # --------
    @classmethod
    def __get_pydantic_core_schema__(
        cls, source: Any, handler: GetCoreSchemaHandler
    ) -> CoreSchema: ...
