# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseKafkaConfigArgs', 'DatabaseKafkaConfig']

@pulumi.input_type
class DatabaseKafkaConfigArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 auto_create_topics_enable: Optional[pulumi.Input[bool]] = None,
                 group_initial_rebalance_delay_ms: Optional[pulumi.Input[int]] = None,
                 group_max_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 group_min_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_delete_retention_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_min_compaction_lag_ms: Optional[pulumi.Input[str]] = None,
                 log_flush_interval_ms: Optional[pulumi.Input[str]] = None,
                 log_index_interval_bytes: Optional[pulumi.Input[int]] = None,
                 log_message_downconversion_enable: Optional[pulumi.Input[bool]] = None,
                 log_message_timestamp_difference_max_ms: Optional[pulumi.Input[str]] = None,
                 log_preallocate: Optional[pulumi.Input[bool]] = None,
                 log_retention_bytes: Optional[pulumi.Input[str]] = None,
                 log_retention_hours: Optional[pulumi.Input[int]] = None,
                 log_retention_ms: Optional[pulumi.Input[str]] = None,
                 log_roll_jitter_ms: Optional[pulumi.Input[str]] = None,
                 log_segment_delete_delay_ms: Optional[pulumi.Input[int]] = None,
                 message_max_bytes: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a DatabaseKafkaConfig resource.
        :param pulumi.Input[str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[bool] auto_create_topics_enable: Enable auto creation of topics.
        :param pulumi.Input[int] group_initial_rebalance_delay_ms: The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
        :param pulumi.Input[int] group_max_session_timeout_ms: The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] group_min_session_timeout_ms: The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] log_cleaner_delete_retention_ms: How long are delete records retained?
        :param pulumi.Input[str] log_cleaner_min_compaction_lag_ms: The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
        :param pulumi.Input[str] log_flush_interval_ms: The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used.
        :param pulumi.Input[int] log_index_interval_bytes: The interval with which Kafka adds an entry to the offset index.
        :param pulumi.Input[bool] log_message_downconversion_enable: This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
        :param pulumi.Input[str] log_message_timestamp_difference_max_ms: The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message.
        :param pulumi.Input[bool] log_preallocate: Controls whether to preallocate a file when creating a new segment.
        :param pulumi.Input[str] log_retention_bytes: The maximum size of the log before deleting messages.
        :param pulumi.Input[int] log_retention_hours: The number of hours to keep a log file before deleting it.
        :param pulumi.Input[str] log_retention_ms: The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
        :param pulumi.Input[str] log_roll_jitter_ms: The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used.
        :param pulumi.Input[int] log_segment_delete_delay_ms: The amount of time to wait before deleting a file from the filesystem.
        :param pulumi.Input[int] message_max_bytes: The maximum size of message that the server can receive.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if auto_create_topics_enable is not None:
            pulumi.set(__self__, "auto_create_topics_enable", auto_create_topics_enable)
        if group_initial_rebalance_delay_ms is not None:
            pulumi.set(__self__, "group_initial_rebalance_delay_ms", group_initial_rebalance_delay_ms)
        if group_max_session_timeout_ms is not None:
            pulumi.set(__self__, "group_max_session_timeout_ms", group_max_session_timeout_ms)
        if group_min_session_timeout_ms is not None:
            pulumi.set(__self__, "group_min_session_timeout_ms", group_min_session_timeout_ms)
        if log_cleaner_delete_retention_ms is not None:
            pulumi.set(__self__, "log_cleaner_delete_retention_ms", log_cleaner_delete_retention_ms)
        if log_cleaner_min_compaction_lag_ms is not None:
            pulumi.set(__self__, "log_cleaner_min_compaction_lag_ms", log_cleaner_min_compaction_lag_ms)
        if log_flush_interval_ms is not None:
            pulumi.set(__self__, "log_flush_interval_ms", log_flush_interval_ms)
        if log_index_interval_bytes is not None:
            pulumi.set(__self__, "log_index_interval_bytes", log_index_interval_bytes)
        if log_message_downconversion_enable is not None:
            pulumi.set(__self__, "log_message_downconversion_enable", log_message_downconversion_enable)
        if log_message_timestamp_difference_max_ms is not None:
            pulumi.set(__self__, "log_message_timestamp_difference_max_ms", log_message_timestamp_difference_max_ms)
        if log_preallocate is not None:
            pulumi.set(__self__, "log_preallocate", log_preallocate)
        if log_retention_bytes is not None:
            pulumi.set(__self__, "log_retention_bytes", log_retention_bytes)
        if log_retention_hours is not None:
            pulumi.set(__self__, "log_retention_hours", log_retention_hours)
        if log_retention_ms is not None:
            pulumi.set(__self__, "log_retention_ms", log_retention_ms)
        if log_roll_jitter_ms is not None:
            pulumi.set(__self__, "log_roll_jitter_ms", log_roll_jitter_ms)
        if log_segment_delete_delay_ms is not None:
            pulumi.set(__self__, "log_segment_delete_delay_ms", log_segment_delete_delay_ms)
        if message_max_bytes is not None:
            pulumi.set(__self__, "message_max_bytes", message_max_bytes)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the target Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="autoCreateTopicsEnable")
    def auto_create_topics_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable auto creation of topics.
        """
        return pulumi.get(self, "auto_create_topics_enable")

    @auto_create_topics_enable.setter
    def auto_create_topics_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create_topics_enable", value)

    @property
    @pulumi.getter(name="groupInitialRebalanceDelayMs")
    def group_initial_rebalance_delay_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
        """
        return pulumi.get(self, "group_initial_rebalance_delay_ms")

    @group_initial_rebalance_delay_ms.setter
    def group_initial_rebalance_delay_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_initial_rebalance_delay_ms", value)

    @property
    @pulumi.getter(name="groupMaxSessionTimeoutMs")
    def group_max_session_timeout_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        """
        return pulumi.get(self, "group_max_session_timeout_ms")

    @group_max_session_timeout_ms.setter
    def group_max_session_timeout_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_max_session_timeout_ms", value)

    @property
    @pulumi.getter(name="groupMinSessionTimeoutMs")
    def group_min_session_timeout_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        """
        return pulumi.get(self, "group_min_session_timeout_ms")

    @group_min_session_timeout_ms.setter
    def group_min_session_timeout_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_min_session_timeout_ms", value)

    @property
    @pulumi.getter(name="logCleanerDeleteRetentionMs")
    def log_cleaner_delete_retention_ms(self) -> Optional[pulumi.Input[int]]:
        """
        How long are delete records retained?
        """
        return pulumi.get(self, "log_cleaner_delete_retention_ms")

    @log_cleaner_delete_retention_ms.setter
    def log_cleaner_delete_retention_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_cleaner_delete_retention_ms", value)

    @property
    @pulumi.getter(name="logCleanerMinCompactionLagMs")
    def log_cleaner_min_compaction_lag_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
        """
        return pulumi.get(self, "log_cleaner_min_compaction_lag_ms")

    @log_cleaner_min_compaction_lag_ms.setter
    def log_cleaner_min_compaction_lag_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_cleaner_min_compaction_lag_ms", value)

    @property
    @pulumi.getter(name="logFlushIntervalMs")
    def log_flush_interval_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used.
        """
        return pulumi.get(self, "log_flush_interval_ms")

    @log_flush_interval_ms.setter
    def log_flush_interval_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_flush_interval_ms", value)

    @property
    @pulumi.getter(name="logIndexIntervalBytes")
    def log_index_interval_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The interval with which Kafka adds an entry to the offset index.
        """
        return pulumi.get(self, "log_index_interval_bytes")

    @log_index_interval_bytes.setter
    def log_index_interval_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_index_interval_bytes", value)

    @property
    @pulumi.getter(name="logMessageDownconversionEnable")
    def log_message_downconversion_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
        """
        return pulumi.get(self, "log_message_downconversion_enable")

    @log_message_downconversion_enable.setter
    def log_message_downconversion_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_message_downconversion_enable", value)

    @property
    @pulumi.getter(name="logMessageTimestampDifferenceMaxMs")
    def log_message_timestamp_difference_max_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message.
        """
        return pulumi.get(self, "log_message_timestamp_difference_max_ms")

    @log_message_timestamp_difference_max_ms.setter
    def log_message_timestamp_difference_max_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_message_timestamp_difference_max_ms", value)

    @property
    @pulumi.getter(name="logPreallocate")
    def log_preallocate(self) -> Optional[pulumi.Input[bool]]:
        """
        Controls whether to preallocate a file when creating a new segment.
        """
        return pulumi.get(self, "log_preallocate")

    @log_preallocate.setter
    def log_preallocate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_preallocate", value)

    @property
    @pulumi.getter(name="logRetentionBytes")
    def log_retention_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum size of the log before deleting messages.
        """
        return pulumi.get(self, "log_retention_bytes")

    @log_retention_bytes.setter
    def log_retention_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_retention_bytes", value)

    @property
    @pulumi.getter(name="logRetentionHours")
    def log_retention_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hours to keep a log file before deleting it.
        """
        return pulumi.get(self, "log_retention_hours")

    @log_retention_hours.setter
    def log_retention_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_retention_hours", value)

    @property
    @pulumi.getter(name="logRetentionMs")
    def log_retention_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
        """
        return pulumi.get(self, "log_retention_ms")

    @log_retention_ms.setter
    def log_retention_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_retention_ms", value)

    @property
    @pulumi.getter(name="logRollJitterMs")
    def log_roll_jitter_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used.
        """
        return pulumi.get(self, "log_roll_jitter_ms")

    @log_roll_jitter_ms.setter
    def log_roll_jitter_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_roll_jitter_ms", value)

    @property
    @pulumi.getter(name="logSegmentDeleteDelayMs")
    def log_segment_delete_delay_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time to wait before deleting a file from the filesystem.
        """
        return pulumi.get(self, "log_segment_delete_delay_ms")

    @log_segment_delete_delay_ms.setter
    def log_segment_delete_delay_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_segment_delete_delay_ms", value)

    @property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of message that the server can receive.
        """
        return pulumi.get(self, "message_max_bytes")

    @message_max_bytes.setter
    def message_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "message_max_bytes", value)


@pulumi.input_type
class _DatabaseKafkaConfigState:
    def __init__(__self__, *,
                 auto_create_topics_enable: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 group_initial_rebalance_delay_ms: Optional[pulumi.Input[int]] = None,
                 group_max_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 group_min_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_delete_retention_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_min_compaction_lag_ms: Optional[pulumi.Input[str]] = None,
                 log_flush_interval_ms: Optional[pulumi.Input[str]] = None,
                 log_index_interval_bytes: Optional[pulumi.Input[int]] = None,
                 log_message_downconversion_enable: Optional[pulumi.Input[bool]] = None,
                 log_message_timestamp_difference_max_ms: Optional[pulumi.Input[str]] = None,
                 log_preallocate: Optional[pulumi.Input[bool]] = None,
                 log_retention_bytes: Optional[pulumi.Input[str]] = None,
                 log_retention_hours: Optional[pulumi.Input[int]] = None,
                 log_retention_ms: Optional[pulumi.Input[str]] = None,
                 log_roll_jitter_ms: Optional[pulumi.Input[str]] = None,
                 log_segment_delete_delay_ms: Optional[pulumi.Input[int]] = None,
                 message_max_bytes: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering DatabaseKafkaConfig resources.
        :param pulumi.Input[bool] auto_create_topics_enable: Enable auto creation of topics.
        :param pulumi.Input[str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[int] group_initial_rebalance_delay_ms: The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
        :param pulumi.Input[int] group_max_session_timeout_ms: The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] group_min_session_timeout_ms: The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] log_cleaner_delete_retention_ms: How long are delete records retained?
        :param pulumi.Input[str] log_cleaner_min_compaction_lag_ms: The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
        :param pulumi.Input[str] log_flush_interval_ms: The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used.
        :param pulumi.Input[int] log_index_interval_bytes: The interval with which Kafka adds an entry to the offset index.
        :param pulumi.Input[bool] log_message_downconversion_enable: This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
        :param pulumi.Input[str] log_message_timestamp_difference_max_ms: The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message.
        :param pulumi.Input[bool] log_preallocate: Controls whether to preallocate a file when creating a new segment.
        :param pulumi.Input[str] log_retention_bytes: The maximum size of the log before deleting messages.
        :param pulumi.Input[int] log_retention_hours: The number of hours to keep a log file before deleting it.
        :param pulumi.Input[str] log_retention_ms: The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
        :param pulumi.Input[str] log_roll_jitter_ms: The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used.
        :param pulumi.Input[int] log_segment_delete_delay_ms: The amount of time to wait before deleting a file from the filesystem.
        :param pulumi.Input[int] message_max_bytes: The maximum size of message that the server can receive.
        """
        if auto_create_topics_enable is not None:
            pulumi.set(__self__, "auto_create_topics_enable", auto_create_topics_enable)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if group_initial_rebalance_delay_ms is not None:
            pulumi.set(__self__, "group_initial_rebalance_delay_ms", group_initial_rebalance_delay_ms)
        if group_max_session_timeout_ms is not None:
            pulumi.set(__self__, "group_max_session_timeout_ms", group_max_session_timeout_ms)
        if group_min_session_timeout_ms is not None:
            pulumi.set(__self__, "group_min_session_timeout_ms", group_min_session_timeout_ms)
        if log_cleaner_delete_retention_ms is not None:
            pulumi.set(__self__, "log_cleaner_delete_retention_ms", log_cleaner_delete_retention_ms)
        if log_cleaner_min_compaction_lag_ms is not None:
            pulumi.set(__self__, "log_cleaner_min_compaction_lag_ms", log_cleaner_min_compaction_lag_ms)
        if log_flush_interval_ms is not None:
            pulumi.set(__self__, "log_flush_interval_ms", log_flush_interval_ms)
        if log_index_interval_bytes is not None:
            pulumi.set(__self__, "log_index_interval_bytes", log_index_interval_bytes)
        if log_message_downconversion_enable is not None:
            pulumi.set(__self__, "log_message_downconversion_enable", log_message_downconversion_enable)
        if log_message_timestamp_difference_max_ms is not None:
            pulumi.set(__self__, "log_message_timestamp_difference_max_ms", log_message_timestamp_difference_max_ms)
        if log_preallocate is not None:
            pulumi.set(__self__, "log_preallocate", log_preallocate)
        if log_retention_bytes is not None:
            pulumi.set(__self__, "log_retention_bytes", log_retention_bytes)
        if log_retention_hours is not None:
            pulumi.set(__self__, "log_retention_hours", log_retention_hours)
        if log_retention_ms is not None:
            pulumi.set(__self__, "log_retention_ms", log_retention_ms)
        if log_roll_jitter_ms is not None:
            pulumi.set(__self__, "log_roll_jitter_ms", log_roll_jitter_ms)
        if log_segment_delete_delay_ms is not None:
            pulumi.set(__self__, "log_segment_delete_delay_ms", log_segment_delete_delay_ms)
        if message_max_bytes is not None:
            pulumi.set(__self__, "message_max_bytes", message_max_bytes)

    @property
    @pulumi.getter(name="autoCreateTopicsEnable")
    def auto_create_topics_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable auto creation of topics.
        """
        return pulumi.get(self, "auto_create_topics_enable")

    @auto_create_topics_enable.setter
    def auto_create_topics_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create_topics_enable", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the target Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="groupInitialRebalanceDelayMs")
    def group_initial_rebalance_delay_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
        """
        return pulumi.get(self, "group_initial_rebalance_delay_ms")

    @group_initial_rebalance_delay_ms.setter
    def group_initial_rebalance_delay_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_initial_rebalance_delay_ms", value)

    @property
    @pulumi.getter(name="groupMaxSessionTimeoutMs")
    def group_max_session_timeout_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        """
        return pulumi.get(self, "group_max_session_timeout_ms")

    @group_max_session_timeout_ms.setter
    def group_max_session_timeout_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_max_session_timeout_ms", value)

    @property
    @pulumi.getter(name="groupMinSessionTimeoutMs")
    def group_min_session_timeout_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        """
        return pulumi.get(self, "group_min_session_timeout_ms")

    @group_min_session_timeout_ms.setter
    def group_min_session_timeout_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_min_session_timeout_ms", value)

    @property
    @pulumi.getter(name="logCleanerDeleteRetentionMs")
    def log_cleaner_delete_retention_ms(self) -> Optional[pulumi.Input[int]]:
        """
        How long are delete records retained?
        """
        return pulumi.get(self, "log_cleaner_delete_retention_ms")

    @log_cleaner_delete_retention_ms.setter
    def log_cleaner_delete_retention_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_cleaner_delete_retention_ms", value)

    @property
    @pulumi.getter(name="logCleanerMinCompactionLagMs")
    def log_cleaner_min_compaction_lag_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
        """
        return pulumi.get(self, "log_cleaner_min_compaction_lag_ms")

    @log_cleaner_min_compaction_lag_ms.setter
    def log_cleaner_min_compaction_lag_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_cleaner_min_compaction_lag_ms", value)

    @property
    @pulumi.getter(name="logFlushIntervalMs")
    def log_flush_interval_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used.
        """
        return pulumi.get(self, "log_flush_interval_ms")

    @log_flush_interval_ms.setter
    def log_flush_interval_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_flush_interval_ms", value)

    @property
    @pulumi.getter(name="logIndexIntervalBytes")
    def log_index_interval_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The interval with which Kafka adds an entry to the offset index.
        """
        return pulumi.get(self, "log_index_interval_bytes")

    @log_index_interval_bytes.setter
    def log_index_interval_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_index_interval_bytes", value)

    @property
    @pulumi.getter(name="logMessageDownconversionEnable")
    def log_message_downconversion_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
        """
        return pulumi.get(self, "log_message_downconversion_enable")

    @log_message_downconversion_enable.setter
    def log_message_downconversion_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_message_downconversion_enable", value)

    @property
    @pulumi.getter(name="logMessageTimestampDifferenceMaxMs")
    def log_message_timestamp_difference_max_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message.
        """
        return pulumi.get(self, "log_message_timestamp_difference_max_ms")

    @log_message_timestamp_difference_max_ms.setter
    def log_message_timestamp_difference_max_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_message_timestamp_difference_max_ms", value)

    @property
    @pulumi.getter(name="logPreallocate")
    def log_preallocate(self) -> Optional[pulumi.Input[bool]]:
        """
        Controls whether to preallocate a file when creating a new segment.
        """
        return pulumi.get(self, "log_preallocate")

    @log_preallocate.setter
    def log_preallocate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_preallocate", value)

    @property
    @pulumi.getter(name="logRetentionBytes")
    def log_retention_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum size of the log before deleting messages.
        """
        return pulumi.get(self, "log_retention_bytes")

    @log_retention_bytes.setter
    def log_retention_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_retention_bytes", value)

    @property
    @pulumi.getter(name="logRetentionHours")
    def log_retention_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hours to keep a log file before deleting it.
        """
        return pulumi.get(self, "log_retention_hours")

    @log_retention_hours.setter
    def log_retention_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_retention_hours", value)

    @property
    @pulumi.getter(name="logRetentionMs")
    def log_retention_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
        """
        return pulumi.get(self, "log_retention_ms")

    @log_retention_ms.setter
    def log_retention_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_retention_ms", value)

    @property
    @pulumi.getter(name="logRollJitterMs")
    def log_roll_jitter_ms(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used.
        """
        return pulumi.get(self, "log_roll_jitter_ms")

    @log_roll_jitter_ms.setter
    def log_roll_jitter_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_roll_jitter_ms", value)

    @property
    @pulumi.getter(name="logSegmentDeleteDelayMs")
    def log_segment_delete_delay_ms(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time to wait before deleting a file from the filesystem.
        """
        return pulumi.get(self, "log_segment_delete_delay_ms")

    @log_segment_delete_delay_ms.setter
    def log_segment_delete_delay_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_segment_delete_delay_ms", value)

    @property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of message that the server can receive.
        """
        return pulumi.get(self, "message_max_bytes")

    @message_max_bytes.setter
    def message_max_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "message_max_bytes", value)


class DatabaseKafkaConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_topics_enable: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 group_initial_rebalance_delay_ms: Optional[pulumi.Input[int]] = None,
                 group_max_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 group_min_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_delete_retention_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_min_compaction_lag_ms: Optional[pulumi.Input[str]] = None,
                 log_flush_interval_ms: Optional[pulumi.Input[str]] = None,
                 log_index_interval_bytes: Optional[pulumi.Input[int]] = None,
                 log_message_downconversion_enable: Optional[pulumi.Input[bool]] = None,
                 log_message_timestamp_difference_max_ms: Optional[pulumi.Input[str]] = None,
                 log_preallocate: Optional[pulumi.Input[bool]] = None,
                 log_retention_bytes: Optional[pulumi.Input[str]] = None,
                 log_retention_hours: Optional[pulumi.Input[int]] = None,
                 log_retention_ms: Optional[pulumi.Input[str]] = None,
                 log_roll_jitter_ms: Optional[pulumi.Input[str]] = None,
                 log_segment_delete_delay_ms: Optional[pulumi.Input[int]] = None,
                 message_max_bytes: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a virtual resource that can be used to change advanced configuration
        options for a DigitalOcean managed Kafka database cluster.

        > **Note** Kafka configurations are only removed from state when destroyed. The remote configuration is not unset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example_database_cluster = digitalocean.DatabaseCluster("example",
            name="example-kafka-cluster",
            engine="kafka",
            version="3.7",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC3,
            node_count=3)
        example = digitalocean.DatabaseKafkaConfig("example",
            cluster_id=example_database_cluster.id,
            group_initial_rebalance_delay_ms=3000,
            group_min_session_timeout_ms=6000,
            group_max_session_timeout_ms=1800000,
            message_max_bytes=1048588,
            log_cleaner_delete_retention_ms=86400000,
            log_cleaner_min_compaction_lag_ms="0",
            log_flush_interval_ms="9223372036854775807",
            log_index_interval_bytes=4096,
            log_message_downconversion_enable=True,
            log_message_timestamp_difference_max_ms="9223372036854775807",
            log_preallocate=False,
            log_retention_bytes="-1",
            log_retention_hours=168,
            log_retention_ms="604800000",
            log_roll_jitter_ms="0",
            log_segment_delete_delay_ms=60000,
            auto_create_topics_enable=True)
        ```

        ## Import

        A Kafka database cluster's configuration can be imported using the `id` the parent cluster, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseKafkaConfig:DatabaseKafkaConfig example 4b62829a-9c42-465b-aaa3-84051048e712
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create_topics_enable: Enable auto creation of topics.
        :param pulumi.Input[str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[int] group_initial_rebalance_delay_ms: The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
        :param pulumi.Input[int] group_max_session_timeout_ms: The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] group_min_session_timeout_ms: The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] log_cleaner_delete_retention_ms: How long are delete records retained?
        :param pulumi.Input[str] log_cleaner_min_compaction_lag_ms: The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
        :param pulumi.Input[str] log_flush_interval_ms: The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used.
        :param pulumi.Input[int] log_index_interval_bytes: The interval with which Kafka adds an entry to the offset index.
        :param pulumi.Input[bool] log_message_downconversion_enable: This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
        :param pulumi.Input[str] log_message_timestamp_difference_max_ms: The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message.
        :param pulumi.Input[bool] log_preallocate: Controls whether to preallocate a file when creating a new segment.
        :param pulumi.Input[str] log_retention_bytes: The maximum size of the log before deleting messages.
        :param pulumi.Input[int] log_retention_hours: The number of hours to keep a log file before deleting it.
        :param pulumi.Input[str] log_retention_ms: The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
        :param pulumi.Input[str] log_roll_jitter_ms: The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used.
        :param pulumi.Input[int] log_segment_delete_delay_ms: The amount of time to wait before deleting a file from the filesystem.
        :param pulumi.Input[int] message_max_bytes: The maximum size of message that the server can receive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseKafkaConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a virtual resource that can be used to change advanced configuration
        options for a DigitalOcean managed Kafka database cluster.

        > **Note** Kafka configurations are only removed from state when destroyed. The remote configuration is not unset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example_database_cluster = digitalocean.DatabaseCluster("example",
            name="example-kafka-cluster",
            engine="kafka",
            version="3.7",
            size=digitalocean.DatabaseSlug.D_B_1_VPCU1_GB,
            region=digitalocean.Region.NYC3,
            node_count=3)
        example = digitalocean.DatabaseKafkaConfig("example",
            cluster_id=example_database_cluster.id,
            group_initial_rebalance_delay_ms=3000,
            group_min_session_timeout_ms=6000,
            group_max_session_timeout_ms=1800000,
            message_max_bytes=1048588,
            log_cleaner_delete_retention_ms=86400000,
            log_cleaner_min_compaction_lag_ms="0",
            log_flush_interval_ms="9223372036854775807",
            log_index_interval_bytes=4096,
            log_message_downconversion_enable=True,
            log_message_timestamp_difference_max_ms="9223372036854775807",
            log_preallocate=False,
            log_retention_bytes="-1",
            log_retention_hours=168,
            log_retention_ms="604800000",
            log_roll_jitter_ms="0",
            log_segment_delete_delay_ms=60000,
            auto_create_topics_enable=True)
        ```

        ## Import

        A Kafka database cluster's configuration can be imported using the `id` the parent cluster, e.g.

        ```sh
        $ pulumi import digitalocean:index/databaseKafkaConfig:DatabaseKafkaConfig example 4b62829a-9c42-465b-aaa3-84051048e712
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseKafkaConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseKafkaConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_topics_enable: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 group_initial_rebalance_delay_ms: Optional[pulumi.Input[int]] = None,
                 group_max_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 group_min_session_timeout_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_delete_retention_ms: Optional[pulumi.Input[int]] = None,
                 log_cleaner_min_compaction_lag_ms: Optional[pulumi.Input[str]] = None,
                 log_flush_interval_ms: Optional[pulumi.Input[str]] = None,
                 log_index_interval_bytes: Optional[pulumi.Input[int]] = None,
                 log_message_downconversion_enable: Optional[pulumi.Input[bool]] = None,
                 log_message_timestamp_difference_max_ms: Optional[pulumi.Input[str]] = None,
                 log_preallocate: Optional[pulumi.Input[bool]] = None,
                 log_retention_bytes: Optional[pulumi.Input[str]] = None,
                 log_retention_hours: Optional[pulumi.Input[int]] = None,
                 log_retention_ms: Optional[pulumi.Input[str]] = None,
                 log_roll_jitter_ms: Optional[pulumi.Input[str]] = None,
                 log_segment_delete_delay_ms: Optional[pulumi.Input[int]] = None,
                 message_max_bytes: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseKafkaConfigArgs.__new__(DatabaseKafkaConfigArgs)

            __props__.__dict__["auto_create_topics_enable"] = auto_create_topics_enable
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["group_initial_rebalance_delay_ms"] = group_initial_rebalance_delay_ms
            __props__.__dict__["group_max_session_timeout_ms"] = group_max_session_timeout_ms
            __props__.__dict__["group_min_session_timeout_ms"] = group_min_session_timeout_ms
            __props__.__dict__["log_cleaner_delete_retention_ms"] = log_cleaner_delete_retention_ms
            __props__.__dict__["log_cleaner_min_compaction_lag_ms"] = log_cleaner_min_compaction_lag_ms
            __props__.__dict__["log_flush_interval_ms"] = log_flush_interval_ms
            __props__.__dict__["log_index_interval_bytes"] = log_index_interval_bytes
            __props__.__dict__["log_message_downconversion_enable"] = log_message_downconversion_enable
            __props__.__dict__["log_message_timestamp_difference_max_ms"] = log_message_timestamp_difference_max_ms
            __props__.__dict__["log_preallocate"] = log_preallocate
            __props__.__dict__["log_retention_bytes"] = log_retention_bytes
            __props__.__dict__["log_retention_hours"] = log_retention_hours
            __props__.__dict__["log_retention_ms"] = log_retention_ms
            __props__.__dict__["log_roll_jitter_ms"] = log_roll_jitter_ms
            __props__.__dict__["log_segment_delete_delay_ms"] = log_segment_delete_delay_ms
            __props__.__dict__["message_max_bytes"] = message_max_bytes
        super(DatabaseKafkaConfig, __self__).__init__(
            'digitalocean:index/databaseKafkaConfig:DatabaseKafkaConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create_topics_enable: Optional[pulumi.Input[bool]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            group_initial_rebalance_delay_ms: Optional[pulumi.Input[int]] = None,
            group_max_session_timeout_ms: Optional[pulumi.Input[int]] = None,
            group_min_session_timeout_ms: Optional[pulumi.Input[int]] = None,
            log_cleaner_delete_retention_ms: Optional[pulumi.Input[int]] = None,
            log_cleaner_min_compaction_lag_ms: Optional[pulumi.Input[str]] = None,
            log_flush_interval_ms: Optional[pulumi.Input[str]] = None,
            log_index_interval_bytes: Optional[pulumi.Input[int]] = None,
            log_message_downconversion_enable: Optional[pulumi.Input[bool]] = None,
            log_message_timestamp_difference_max_ms: Optional[pulumi.Input[str]] = None,
            log_preallocate: Optional[pulumi.Input[bool]] = None,
            log_retention_bytes: Optional[pulumi.Input[str]] = None,
            log_retention_hours: Optional[pulumi.Input[int]] = None,
            log_retention_ms: Optional[pulumi.Input[str]] = None,
            log_roll_jitter_ms: Optional[pulumi.Input[str]] = None,
            log_segment_delete_delay_ms: Optional[pulumi.Input[int]] = None,
            message_max_bytes: Optional[pulumi.Input[int]] = None) -> 'DatabaseKafkaConfig':
        """
        Get an existing DatabaseKafkaConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create_topics_enable: Enable auto creation of topics.
        :param pulumi.Input[str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[int] group_initial_rebalance_delay_ms: The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
        :param pulumi.Input[int] group_max_session_timeout_ms: The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] group_min_session_timeout_ms: The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        :param pulumi.Input[int] log_cleaner_delete_retention_ms: How long are delete records retained?
        :param pulumi.Input[str] log_cleaner_min_compaction_lag_ms: The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
        :param pulumi.Input[str] log_flush_interval_ms: The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used.
        :param pulumi.Input[int] log_index_interval_bytes: The interval with which Kafka adds an entry to the offset index.
        :param pulumi.Input[bool] log_message_downconversion_enable: This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
        :param pulumi.Input[str] log_message_timestamp_difference_max_ms: The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message.
        :param pulumi.Input[bool] log_preallocate: Controls whether to preallocate a file when creating a new segment.
        :param pulumi.Input[str] log_retention_bytes: The maximum size of the log before deleting messages.
        :param pulumi.Input[int] log_retention_hours: The number of hours to keep a log file before deleting it.
        :param pulumi.Input[str] log_retention_ms: The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
        :param pulumi.Input[str] log_roll_jitter_ms: The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used.
        :param pulumi.Input[int] log_segment_delete_delay_ms: The amount of time to wait before deleting a file from the filesystem.
        :param pulumi.Input[int] message_max_bytes: The maximum size of message that the server can receive.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseKafkaConfigState.__new__(_DatabaseKafkaConfigState)

        __props__.__dict__["auto_create_topics_enable"] = auto_create_topics_enable
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["group_initial_rebalance_delay_ms"] = group_initial_rebalance_delay_ms
        __props__.__dict__["group_max_session_timeout_ms"] = group_max_session_timeout_ms
        __props__.__dict__["group_min_session_timeout_ms"] = group_min_session_timeout_ms
        __props__.__dict__["log_cleaner_delete_retention_ms"] = log_cleaner_delete_retention_ms
        __props__.__dict__["log_cleaner_min_compaction_lag_ms"] = log_cleaner_min_compaction_lag_ms
        __props__.__dict__["log_flush_interval_ms"] = log_flush_interval_ms
        __props__.__dict__["log_index_interval_bytes"] = log_index_interval_bytes
        __props__.__dict__["log_message_downconversion_enable"] = log_message_downconversion_enable
        __props__.__dict__["log_message_timestamp_difference_max_ms"] = log_message_timestamp_difference_max_ms
        __props__.__dict__["log_preallocate"] = log_preallocate
        __props__.__dict__["log_retention_bytes"] = log_retention_bytes
        __props__.__dict__["log_retention_hours"] = log_retention_hours
        __props__.__dict__["log_retention_ms"] = log_retention_ms
        __props__.__dict__["log_roll_jitter_ms"] = log_roll_jitter_ms
        __props__.__dict__["log_segment_delete_delay_ms"] = log_segment_delete_delay_ms
        __props__.__dict__["message_max_bytes"] = message_max_bytes
        return DatabaseKafkaConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoCreateTopicsEnable")
    def auto_create_topics_enable(self) -> pulumi.Output[bool]:
        """
        Enable auto creation of topics.
        """
        return pulumi.get(self, "auto_create_topics_enable")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the target Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="groupInitialRebalanceDelayMs")
    def group_initial_rebalance_delay_ms(self) -> pulumi.Output[int]:
        """
        The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
        """
        return pulumi.get(self, "group_initial_rebalance_delay_ms")

    @property
    @pulumi.getter(name="groupMaxSessionTimeoutMs")
    def group_max_session_timeout_ms(self) -> pulumi.Output[int]:
        """
        The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        """
        return pulumi.get(self, "group_max_session_timeout_ms")

    @property
    @pulumi.getter(name="groupMinSessionTimeoutMs")
    def group_min_session_timeout_ms(self) -> pulumi.Output[int]:
        """
        The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
        """
        return pulumi.get(self, "group_min_session_timeout_ms")

    @property
    @pulumi.getter(name="logCleanerDeleteRetentionMs")
    def log_cleaner_delete_retention_ms(self) -> pulumi.Output[int]:
        """
        How long are delete records retained?
        """
        return pulumi.get(self, "log_cleaner_delete_retention_ms")

    @property
    @pulumi.getter(name="logCleanerMinCompactionLagMs")
    def log_cleaner_min_compaction_lag_ms(self) -> pulumi.Output[str]:
        """
        The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
        """
        return pulumi.get(self, "log_cleaner_min_compaction_lag_ms")

    @property
    @pulumi.getter(name="logFlushIntervalMs")
    def log_flush_interval_ms(self) -> pulumi.Output[str]:
        """
        The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used.
        """
        return pulumi.get(self, "log_flush_interval_ms")

    @property
    @pulumi.getter(name="logIndexIntervalBytes")
    def log_index_interval_bytes(self) -> pulumi.Output[int]:
        """
        The interval with which Kafka adds an entry to the offset index.
        """
        return pulumi.get(self, "log_index_interval_bytes")

    @property
    @pulumi.getter(name="logMessageDownconversionEnable")
    def log_message_downconversion_enable(self) -> pulumi.Output[bool]:
        """
        This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
        """
        return pulumi.get(self, "log_message_downconversion_enable")

    @property
    @pulumi.getter(name="logMessageTimestampDifferenceMaxMs")
    def log_message_timestamp_difference_max_ms(self) -> pulumi.Output[str]:
        """
        The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message.
        """
        return pulumi.get(self, "log_message_timestamp_difference_max_ms")

    @property
    @pulumi.getter(name="logPreallocate")
    def log_preallocate(self) -> pulumi.Output[bool]:
        """
        Controls whether to preallocate a file when creating a new segment.
        """
        return pulumi.get(self, "log_preallocate")

    @property
    @pulumi.getter(name="logRetentionBytes")
    def log_retention_bytes(self) -> pulumi.Output[str]:
        """
        The maximum size of the log before deleting messages.
        """
        return pulumi.get(self, "log_retention_bytes")

    @property
    @pulumi.getter(name="logRetentionHours")
    def log_retention_hours(self) -> pulumi.Output[int]:
        """
        The number of hours to keep a log file before deleting it.
        """
        return pulumi.get(self, "log_retention_hours")

    @property
    @pulumi.getter(name="logRetentionMs")
    def log_retention_ms(self) -> pulumi.Output[str]:
        """
        The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
        """
        return pulumi.get(self, "log_retention_ms")

    @property
    @pulumi.getter(name="logRollJitterMs")
    def log_roll_jitter_ms(self) -> pulumi.Output[str]:
        """
        The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used.
        """
        return pulumi.get(self, "log_roll_jitter_ms")

    @property
    @pulumi.getter(name="logSegmentDeleteDelayMs")
    def log_segment_delete_delay_ms(self) -> pulumi.Output[int]:
        """
        The amount of time to wait before deleting a file from the filesystem.
        """
        return pulumi.get(self, "log_segment_delete_delay_ms")

    @property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> pulumi.Output[int]:
        """
        The maximum size of message that the server can receive.
        """
        return pulumi.get(self, "message_max_bytes")

