# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[Union[str, 'Algorithm']]] = None,
                 disable_lets_encrypt_dns_records: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]]] = None,
                 droplet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 droplet_tag: Optional[pulumi.Input[str]] = None,
                 enable_backend_keepalive: Optional[pulumi.Input[bool]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 firewall: Optional[pulumi.Input['LoadBalancerFirewallArgs']] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]] = None,
                 glb_settings: Optional[pulumi.Input['LoadBalancerGlbSettingsArgs']] = None,
                 healthcheck: Optional[pulumi.Input['LoadBalancerHealthcheckArgs']] = None,
                 http_idle_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect_http_to_https: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_unit: Optional[pulumi.Input[int]] = None,
                 sticky_sessions: Optional[pulumi.Input['LoadBalancerStickySessionsArgs']] = None,
                 target_load_balancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[Union[str, 'Algorithm']] algorithm: **Deprecated** This field has been deprecated. You can no longer specify an algorithm for load balancers.
               or `least_connections`. The default value is `round_robin`.
        :param pulumi.Input[bool] disable_lets_encrypt_dns_records: A boolean value indicating whether to disable automatic DNS record creation for Let's Encrypt certificates that are added to the load balancer. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]] domains: A list of `domains` required to ingress traffic to a Global Load Balancer. The `domains` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] droplet_ids: A list of the IDs of each droplet to be attached to the Load Balancer.
        :param pulumi.Input[str] droplet_tag: The name of a Droplet tag corresponding to Droplets to be assigned to the Load Balancer.
        :param pulumi.Input[bool] enable_backend_keepalive: A boolean value indicating whether HTTP keepalive connections are maintained to target Droplets. Default value is `false`.
        :param pulumi.Input[bool] enable_proxy_protocol: A boolean value indicating whether PROXY
               Protocol should be used to pass information from connecting client requests to
               the backend service. Default value is `false`.
        :param pulumi.Input['LoadBalancerFirewallArgs'] firewall: A block containing rules for allowing/denying traffic to the Load Balancer. The `firewall` block is documented below. Only 1 firewall is allowed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]] forwarding_rules: A list of `forwarding_rule` to be assigned to the
               Load Balancer. The `forwarding_rule` block is documented below.
        :param pulumi.Input['LoadBalancerGlbSettingsArgs'] glb_settings: A block containing `glb_settings` required to define target rules for a Global Load Balancer. The `glb_settings` block is documented below.
        :param pulumi.Input['LoadBalancerHealthcheckArgs'] healthcheck: A `healthcheck` block to be assigned to the
               Load Balancer. The `healthcheck` block is documented below. Only 1 healthcheck is allowed.
        :param pulumi.Input[int] http_idle_timeout_seconds: Specifies the idle timeout for HTTPS connections on the load balancer in seconds.
        :param pulumi.Input[str] name: The Load Balancer name
        :param pulumi.Input[str] network: The type of network the Load Balancer is accessible from. It must be either of `INTERNAL` or `EXTERNAL`. Defaults to `EXTERNAL`.
               **NOTE**: non-`EXTERNAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] project_id: The ID of the project that the load balancer is associated with. If no ID is provided at creation, the load balancer associates with the user's default project.
        :param pulumi.Input[bool] redirect_http_to_https: A boolean value indicating whether
               HTTP requests to the Load Balancer on port 80 will be redirected to HTTPS on port 443.
               Default value is `false`.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in
        :param pulumi.Input[str] size: The size of the Load Balancer. It must be either `lb-small`, `lb-medium`, or `lb-large`. Defaults to `lb-small`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input[int] size_unit: The size of the Load Balancer. It must be in the range (1, 100). Defaults to `1`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input['LoadBalancerStickySessionsArgs'] sticky_sessions: A `sticky_sessions` block to be assigned to the
               Load Balancer. The `sticky_sessions` block is documented below. Only 1 sticky_sessions block is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_load_balancer_ids: A list of Load Balancer IDs to be attached behind a Global Load Balancer.
        :param pulumi.Input[str] type: The type of the Load Balancer. It must be either of `REGIONAL` or `GLOBAL`. Defaults to `REGIONAL`.
               **NOTE**: non-`REGIONAL/GLOBAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the load balancer will be located.
        """
        if algorithm is not None:
            warnings.warn("""This field has been deprecated. You can no longer specify an algorithm for load balancers.""", DeprecationWarning)
            pulumi.log.warn("""algorithm is deprecated: This field has been deprecated. You can no longer specify an algorithm for load balancers.""")
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if disable_lets_encrypt_dns_records is not None:
            pulumi.set(__self__, "disable_lets_encrypt_dns_records", disable_lets_encrypt_dns_records)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if droplet_ids is not None:
            pulumi.set(__self__, "droplet_ids", droplet_ids)
        if droplet_tag is not None:
            pulumi.set(__self__, "droplet_tag", droplet_tag)
        if enable_backend_keepalive is not None:
            pulumi.set(__self__, "enable_backend_keepalive", enable_backend_keepalive)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if firewall is not None:
            pulumi.set(__self__, "firewall", firewall)
        if forwarding_rules is not None:
            pulumi.set(__self__, "forwarding_rules", forwarding_rules)
        if glb_settings is not None:
            pulumi.set(__self__, "glb_settings", glb_settings)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if http_idle_timeout_seconds is not None:
            pulumi.set(__self__, "http_idle_timeout_seconds", http_idle_timeout_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if redirect_http_to_https is not None:
            pulumi.set(__self__, "redirect_http_to_https", redirect_http_to_https)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_unit is not None:
            pulumi.set(__self__, "size_unit", size_unit)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        if target_load_balancer_ids is not None:
            pulumi.set(__self__, "target_load_balancer_ids", target_load_balancer_ids)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field has been deprecated. You can no longer specify an algorithm for load balancers.""")
    def algorithm(self) -> Optional[pulumi.Input[Union[str, 'Algorithm']]]:
        """
        **Deprecated** This field has been deprecated. You can no longer specify an algorithm for load balancers.
        or `least_connections`. The default value is `round_robin`.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[Union[str, 'Algorithm']]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="disableLetsEncryptDnsRecords")
    def disable_lets_encrypt_dns_records(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether to disable automatic DNS record creation for Let's Encrypt certificates that are added to the load balancer. Default value is `false`.
        """
        return pulumi.get(self, "disable_lets_encrypt_dns_records")

    @disable_lets_encrypt_dns_records.setter
    def disable_lets_encrypt_dns_records(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_lets_encrypt_dns_records", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]]]:
        """
        A list of `domains` required to ingress traffic to a Global Load Balancer. The `domains` block is documented below.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="dropletIds")
    def droplet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of the IDs of each droplet to be attached to the Load Balancer.
        """
        return pulumi.get(self, "droplet_ids")

    @droplet_ids.setter
    def droplet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "droplet_ids", value)

    @property
    @pulumi.getter(name="dropletTag")
    def droplet_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Droplet tag corresponding to Droplets to be assigned to the Load Balancer.
        """
        return pulumi.get(self, "droplet_tag")

    @droplet_tag.setter
    def droplet_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "droplet_tag", value)

    @property
    @pulumi.getter(name="enableBackendKeepalive")
    def enable_backend_keepalive(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether HTTP keepalive connections are maintained to target Droplets. Default value is `false`.
        """
        return pulumi.get(self, "enable_backend_keepalive")

    @enable_backend_keepalive.setter
    def enable_backend_keepalive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_backend_keepalive", value)

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether PROXY
        Protocol should be used to pass information from connecting client requests to
        the backend service. Default value is `false`.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @property
    @pulumi.getter
    def firewall(self) -> Optional[pulumi.Input['LoadBalancerFirewallArgs']]:
        """
        A block containing rules for allowing/denying traffic to the Load Balancer. The `firewall` block is documented below. Only 1 firewall is allowed.
        """
        return pulumi.get(self, "firewall")

    @firewall.setter
    def firewall(self, value: Optional[pulumi.Input['LoadBalancerFirewallArgs']]):
        pulumi.set(self, "firewall", value)

    @property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]]:
        """
        A list of `forwarding_rule` to be assigned to the
        Load Balancer. The `forwarding_rule` block is documented below.
        """
        return pulumi.get(self, "forwarding_rules")

    @forwarding_rules.setter
    def forwarding_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]]):
        pulumi.set(self, "forwarding_rules", value)

    @property
    @pulumi.getter(name="glbSettings")
    def glb_settings(self) -> Optional[pulumi.Input['LoadBalancerGlbSettingsArgs']]:
        """
        A block containing `glb_settings` required to define target rules for a Global Load Balancer. The `glb_settings` block is documented below.
        """
        return pulumi.get(self, "glb_settings")

    @glb_settings.setter
    def glb_settings(self, value: Optional[pulumi.Input['LoadBalancerGlbSettingsArgs']]):
        pulumi.set(self, "glb_settings", value)

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[pulumi.Input['LoadBalancerHealthcheckArgs']]:
        """
        A `healthcheck` block to be assigned to the
        Load Balancer. The `healthcheck` block is documented below. Only 1 healthcheck is allowed.
        """
        return pulumi.get(self, "healthcheck")

    @healthcheck.setter
    def healthcheck(self, value: Optional[pulumi.Input['LoadBalancerHealthcheckArgs']]):
        pulumi.set(self, "healthcheck", value)

    @property
    @pulumi.getter(name="httpIdleTimeoutSeconds")
    def http_idle_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the idle timeout for HTTPS connections on the load balancer in seconds.
        """
        return pulumi.get(self, "http_idle_timeout_seconds")

    @http_idle_timeout_seconds.setter
    def http_idle_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_idle_timeout_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Load Balancer name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The type of network the Load Balancer is accessible from. It must be either of `INTERNAL` or `EXTERNAL`. Defaults to `EXTERNAL`.
        **NOTE**: non-`EXTERNAL` type may be part of closed beta feature and not available for public use.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project that the load balancer is associated with. If no ID is provided at creation, the load balancer associates with the user's default project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="redirectHttpToHttps")
    def redirect_http_to_https(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether
        HTTP requests to the Load Balancer on port 80 will be redirected to HTTPS on port 443.
        Default value is `false`.
        """
        return pulumi.get(self, "redirect_http_to_https")

    @redirect_http_to_https.setter
    def redirect_http_to_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "redirect_http_to_https", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[Union[str, 'Region']]]:
        """
        The region to start in
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Union[str, 'Region']]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the Load Balancer. It must be either `lb-small`, `lb-medium`, or `lb-large`. Defaults to `lb-small`. Only one of `size` or `size_unit` may be provided.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeUnit")
    def size_unit(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the Load Balancer. It must be in the range (1, 100). Defaults to `1`. Only one of `size` or `size_unit` may be provided.
        """
        return pulumi.get(self, "size_unit")

    @size_unit.setter
    def size_unit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_unit", value)

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[pulumi.Input['LoadBalancerStickySessionsArgs']]:
        """
        A `sticky_sessions` block to be assigned to the
        Load Balancer. The `sticky_sessions` block is documented below. Only 1 sticky_sessions block is allowed.
        """
        return pulumi.get(self, "sticky_sessions")

    @sticky_sessions.setter
    def sticky_sessions(self, value: Optional[pulumi.Input['LoadBalancerStickySessionsArgs']]):
        pulumi.set(self, "sticky_sessions", value)

    @property
    @pulumi.getter(name="targetLoadBalancerIds")
    def target_load_balancer_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Load Balancer IDs to be attached behind a Global Load Balancer.
        """
        return pulumi.get(self, "target_load_balancer_ids")

    @target_load_balancer_ids.setter
    def target_load_balancer_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_load_balancer_ids", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Load Balancer. It must be either of `REGIONAL` or `GLOBAL`. Defaults to `REGIONAL`.
        **NOTE**: non-`REGIONAL/GLOBAL` type may be part of closed beta feature and not available for public use.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where the load balancer will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[Union[str, 'Algorithm']]] = None,
                 disable_lets_encrypt_dns_records: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]]] = None,
                 droplet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 droplet_tag: Optional[pulumi.Input[str]] = None,
                 enable_backend_keepalive: Optional[pulumi.Input[bool]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 firewall: Optional[pulumi.Input['LoadBalancerFirewallArgs']] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]] = None,
                 glb_settings: Optional[pulumi.Input['LoadBalancerGlbSettingsArgs']] = None,
                 healthcheck: Optional[pulumi.Input['LoadBalancerHealthcheckArgs']] = None,
                 http_idle_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 load_balancer_urn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect_http_to_https: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_unit: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sticky_sessions: Optional[pulumi.Input['LoadBalancerStickySessionsArgs']] = None,
                 target_load_balancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[Union[str, 'Algorithm']] algorithm: **Deprecated** This field has been deprecated. You can no longer specify an algorithm for load balancers.
               or `least_connections`. The default value is `round_robin`.
        :param pulumi.Input[bool] disable_lets_encrypt_dns_records: A boolean value indicating whether to disable automatic DNS record creation for Let's Encrypt certificates that are added to the load balancer. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]] domains: A list of `domains` required to ingress traffic to a Global Load Balancer. The `domains` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] droplet_ids: A list of the IDs of each droplet to be attached to the Load Balancer.
        :param pulumi.Input[str] droplet_tag: The name of a Droplet tag corresponding to Droplets to be assigned to the Load Balancer.
        :param pulumi.Input[bool] enable_backend_keepalive: A boolean value indicating whether HTTP keepalive connections are maintained to target Droplets. Default value is `false`.
        :param pulumi.Input[bool] enable_proxy_protocol: A boolean value indicating whether PROXY
               Protocol should be used to pass information from connecting client requests to
               the backend service. Default value is `false`.
        :param pulumi.Input['LoadBalancerFirewallArgs'] firewall: A block containing rules for allowing/denying traffic to the Load Balancer. The `firewall` block is documented below. Only 1 firewall is allowed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]] forwarding_rules: A list of `forwarding_rule` to be assigned to the
               Load Balancer. The `forwarding_rule` block is documented below.
        :param pulumi.Input['LoadBalancerGlbSettingsArgs'] glb_settings: A block containing `glb_settings` required to define target rules for a Global Load Balancer. The `glb_settings` block is documented below.
        :param pulumi.Input['LoadBalancerHealthcheckArgs'] healthcheck: A `healthcheck` block to be assigned to the
               Load Balancer. The `healthcheck` block is documented below. Only 1 healthcheck is allowed.
        :param pulumi.Input[int] http_idle_timeout_seconds: Specifies the idle timeout for HTTPS connections on the load balancer in seconds.
        :param pulumi.Input[str] ip: The ip of the Load Balancer
        :param pulumi.Input[str] load_balancer_urn: The uniform resource name for the Load Balancer
        :param pulumi.Input[str] name: The Load Balancer name
        :param pulumi.Input[str] network: The type of network the Load Balancer is accessible from. It must be either of `INTERNAL` or `EXTERNAL`. Defaults to `EXTERNAL`.
               **NOTE**: non-`EXTERNAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] project_id: The ID of the project that the load balancer is associated with. If no ID is provided at creation, the load balancer associates with the user's default project.
        :param pulumi.Input[bool] redirect_http_to_https: A boolean value indicating whether
               HTTP requests to the Load Balancer on port 80 will be redirected to HTTPS on port 443.
               Default value is `false`.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in
        :param pulumi.Input[str] size: The size of the Load Balancer. It must be either `lb-small`, `lb-medium`, or `lb-large`. Defaults to `lb-small`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input[int] size_unit: The size of the Load Balancer. It must be in the range (1, 100). Defaults to `1`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input['LoadBalancerStickySessionsArgs'] sticky_sessions: A `sticky_sessions` block to be assigned to the
               Load Balancer. The `sticky_sessions` block is documented below. Only 1 sticky_sessions block is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_load_balancer_ids: A list of Load Balancer IDs to be attached behind a Global Load Balancer.
        :param pulumi.Input[str] type: The type of the Load Balancer. It must be either of `REGIONAL` or `GLOBAL`. Defaults to `REGIONAL`.
               **NOTE**: non-`REGIONAL/GLOBAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the load balancer will be located.
        """
        if algorithm is not None:
            warnings.warn("""This field has been deprecated. You can no longer specify an algorithm for load balancers.""", DeprecationWarning)
            pulumi.log.warn("""algorithm is deprecated: This field has been deprecated. You can no longer specify an algorithm for load balancers.""")
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if disable_lets_encrypt_dns_records is not None:
            pulumi.set(__self__, "disable_lets_encrypt_dns_records", disable_lets_encrypt_dns_records)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if droplet_ids is not None:
            pulumi.set(__self__, "droplet_ids", droplet_ids)
        if droplet_tag is not None:
            pulumi.set(__self__, "droplet_tag", droplet_tag)
        if enable_backend_keepalive is not None:
            pulumi.set(__self__, "enable_backend_keepalive", enable_backend_keepalive)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if firewall is not None:
            pulumi.set(__self__, "firewall", firewall)
        if forwarding_rules is not None:
            pulumi.set(__self__, "forwarding_rules", forwarding_rules)
        if glb_settings is not None:
            pulumi.set(__self__, "glb_settings", glb_settings)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if http_idle_timeout_seconds is not None:
            pulumi.set(__self__, "http_idle_timeout_seconds", http_idle_timeout_seconds)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if load_balancer_urn is not None:
            pulumi.set(__self__, "load_balancer_urn", load_balancer_urn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if redirect_http_to_https is not None:
            pulumi.set(__self__, "redirect_http_to_https", redirect_http_to_https)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_unit is not None:
            pulumi.set(__self__, "size_unit", size_unit)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        if target_load_balancer_ids is not None:
            pulumi.set(__self__, "target_load_balancer_ids", target_load_balancer_ids)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field has been deprecated. You can no longer specify an algorithm for load balancers.""")
    def algorithm(self) -> Optional[pulumi.Input[Union[str, 'Algorithm']]]:
        """
        **Deprecated** This field has been deprecated. You can no longer specify an algorithm for load balancers.
        or `least_connections`. The default value is `round_robin`.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[Union[str, 'Algorithm']]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="disableLetsEncryptDnsRecords")
    def disable_lets_encrypt_dns_records(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether to disable automatic DNS record creation for Let's Encrypt certificates that are added to the load balancer. Default value is `false`.
        """
        return pulumi.get(self, "disable_lets_encrypt_dns_records")

    @disable_lets_encrypt_dns_records.setter
    def disable_lets_encrypt_dns_records(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_lets_encrypt_dns_records", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]]]:
        """
        A list of `domains` required to ingress traffic to a Global Load Balancer. The `domains` block is documented below.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerDomainArgs']]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="dropletIds")
    def droplet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of the IDs of each droplet to be attached to the Load Balancer.
        """
        return pulumi.get(self, "droplet_ids")

    @droplet_ids.setter
    def droplet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "droplet_ids", value)

    @property
    @pulumi.getter(name="dropletTag")
    def droplet_tag(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Droplet tag corresponding to Droplets to be assigned to the Load Balancer.
        """
        return pulumi.get(self, "droplet_tag")

    @droplet_tag.setter
    def droplet_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "droplet_tag", value)

    @property
    @pulumi.getter(name="enableBackendKeepalive")
    def enable_backend_keepalive(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether HTTP keepalive connections are maintained to target Droplets. Default value is `false`.
        """
        return pulumi.get(self, "enable_backend_keepalive")

    @enable_backend_keepalive.setter
    def enable_backend_keepalive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_backend_keepalive", value)

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether PROXY
        Protocol should be used to pass information from connecting client requests to
        the backend service. Default value is `false`.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @property
    @pulumi.getter
    def firewall(self) -> Optional[pulumi.Input['LoadBalancerFirewallArgs']]:
        """
        A block containing rules for allowing/denying traffic to the Load Balancer. The `firewall` block is documented below. Only 1 firewall is allowed.
        """
        return pulumi.get(self, "firewall")

    @firewall.setter
    def firewall(self, value: Optional[pulumi.Input['LoadBalancerFirewallArgs']]):
        pulumi.set(self, "firewall", value)

    @property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]]:
        """
        A list of `forwarding_rule` to be assigned to the
        Load Balancer. The `forwarding_rule` block is documented below.
        """
        return pulumi.get(self, "forwarding_rules")

    @forwarding_rules.setter
    def forwarding_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]]):
        pulumi.set(self, "forwarding_rules", value)

    @property
    @pulumi.getter(name="glbSettings")
    def glb_settings(self) -> Optional[pulumi.Input['LoadBalancerGlbSettingsArgs']]:
        """
        A block containing `glb_settings` required to define target rules for a Global Load Balancer. The `glb_settings` block is documented below.
        """
        return pulumi.get(self, "glb_settings")

    @glb_settings.setter
    def glb_settings(self, value: Optional[pulumi.Input['LoadBalancerGlbSettingsArgs']]):
        pulumi.set(self, "glb_settings", value)

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[pulumi.Input['LoadBalancerHealthcheckArgs']]:
        """
        A `healthcheck` block to be assigned to the
        Load Balancer. The `healthcheck` block is documented below. Only 1 healthcheck is allowed.
        """
        return pulumi.get(self, "healthcheck")

    @healthcheck.setter
    def healthcheck(self, value: Optional[pulumi.Input['LoadBalancerHealthcheckArgs']]):
        pulumi.set(self, "healthcheck", value)

    @property
    @pulumi.getter(name="httpIdleTimeoutSeconds")
    def http_idle_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the idle timeout for HTTPS connections on the load balancer in seconds.
        """
        return pulumi.get(self, "http_idle_timeout_seconds")

    @http_idle_timeout_seconds.setter
    def http_idle_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_idle_timeout_seconds", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The ip of the Load Balancer
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="loadBalancerUrn")
    def load_balancer_urn(self) -> Optional[pulumi.Input[str]]:
        """
        The uniform resource name for the Load Balancer
        """
        return pulumi.get(self, "load_balancer_urn")

    @load_balancer_urn.setter
    def load_balancer_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_urn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Load Balancer name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The type of network the Load Balancer is accessible from. It must be either of `INTERNAL` or `EXTERNAL`. Defaults to `EXTERNAL`.
        **NOTE**: non-`EXTERNAL` type may be part of closed beta feature and not available for public use.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project that the load balancer is associated with. If no ID is provided at creation, the load balancer associates with the user's default project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="redirectHttpToHttps")
    def redirect_http_to_https(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether
        HTTP requests to the Load Balancer on port 80 will be redirected to HTTPS on port 443.
        Default value is `false`.
        """
        return pulumi.get(self, "redirect_http_to_https")

    @redirect_http_to_https.setter
    def redirect_http_to_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "redirect_http_to_https", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[Union[str, 'Region']]]:
        """
        The region to start in
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Union[str, 'Region']]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the Load Balancer. It must be either `lb-small`, `lb-medium`, or `lb-large`. Defaults to `lb-small`. Only one of `size` or `size_unit` may be provided.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeUnit")
    def size_unit(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the Load Balancer. It must be in the range (1, 100). Defaults to `1`. Only one of `size` or `size_unit` may be provided.
        """
        return pulumi.get(self, "size_unit")

    @size_unit.setter
    def size_unit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_unit", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[pulumi.Input['LoadBalancerStickySessionsArgs']]:
        """
        A `sticky_sessions` block to be assigned to the
        Load Balancer. The `sticky_sessions` block is documented below. Only 1 sticky_sessions block is allowed.
        """
        return pulumi.get(self, "sticky_sessions")

    @sticky_sessions.setter
    def sticky_sessions(self, value: Optional[pulumi.Input['LoadBalancerStickySessionsArgs']]):
        pulumi.set(self, "sticky_sessions", value)

    @property
    @pulumi.getter(name="targetLoadBalancerIds")
    def target_load_balancer_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Load Balancer IDs to be attached behind a Global Load Balancer.
        """
        return pulumi.get(self, "target_load_balancer_ids")

    @target_load_balancer_ids.setter
    def target_load_balancer_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_load_balancer_ids", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Load Balancer. It must be either of `REGIONAL` or `GLOBAL`. Defaults to `REGIONAL`.
        **NOTE**: non-`REGIONAL/GLOBAL` type may be part of closed beta feature and not available for public use.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where the load balancer will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_uuid", value)


class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union[str, 'Algorithm']]] = None,
                 disable_lets_encrypt_dns_records: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerDomainArgs', 'LoadBalancerDomainArgsDict']]]]] = None,
                 droplet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 droplet_tag: Optional[pulumi.Input[str]] = None,
                 enable_backend_keepalive: Optional[pulumi.Input[bool]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 firewall: Optional[pulumi.Input[Union['LoadBalancerFirewallArgs', 'LoadBalancerFirewallArgsDict']]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerForwardingRuleArgs', 'LoadBalancerForwardingRuleArgsDict']]]]] = None,
                 glb_settings: Optional[pulumi.Input[Union['LoadBalancerGlbSettingsArgs', 'LoadBalancerGlbSettingsArgsDict']]] = None,
                 healthcheck: Optional[pulumi.Input[Union['LoadBalancerHealthcheckArgs', 'LoadBalancerHealthcheckArgsDict']]] = None,
                 http_idle_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect_http_to_https: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_unit: Optional[pulumi.Input[int]] = None,
                 sticky_sessions: Optional[pulumi.Input[Union['LoadBalancerStickySessionsArgs', 'LoadBalancerStickySessionsArgsDict']]] = None,
                 target_load_balancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean Load Balancer resource. This can be used to create,
        modify, and delete Load Balancers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        web = digitalocean.Droplet("web",
            name="web-1",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-18-04-x64",
            region=digitalocean.Region.NYC3)
        public = digitalocean.LoadBalancer("public",
            name="loadbalancer-1",
            region=digitalocean.Region.NYC3,
            forwarding_rules=[{
                "entry_port": 80,
                "entry_protocol": "http",
                "target_port": 80,
                "target_protocol": "http",
            }],
            healthcheck={
                "port": 22,
                "protocol": "tcp",
            },
            droplet_ids=[web.id])
        ```

        When managing certificates attached to the load balancer, make sure to add the `create_before_destroy`
        lifecycle property in order to ensure the certificate is correctly updated when changed. The order of
        operations will then be: `Create new certificate` > `Update loadbalancer with new certificate` ->
        `Delete old certificate`. When doing so, you must also change the name of the certificate,
        as there cannot be multiple certificates with the same name in an account.

        ## Import

        Load Balancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/loadBalancer:LoadBalancer myloadbalancer 4de7ac8b-495b-4884-9a69-1050c6793cd6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'Algorithm']] algorithm: **Deprecated** This field has been deprecated. You can no longer specify an algorithm for load balancers.
               or `least_connections`. The default value is `round_robin`.
        :param pulumi.Input[bool] disable_lets_encrypt_dns_records: A boolean value indicating whether to disable automatic DNS record creation for Let's Encrypt certificates that are added to the load balancer. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerDomainArgs', 'LoadBalancerDomainArgsDict']]]] domains: A list of `domains` required to ingress traffic to a Global Load Balancer. The `domains` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] droplet_ids: A list of the IDs of each droplet to be attached to the Load Balancer.
        :param pulumi.Input[str] droplet_tag: The name of a Droplet tag corresponding to Droplets to be assigned to the Load Balancer.
        :param pulumi.Input[bool] enable_backend_keepalive: A boolean value indicating whether HTTP keepalive connections are maintained to target Droplets. Default value is `false`.
        :param pulumi.Input[bool] enable_proxy_protocol: A boolean value indicating whether PROXY
               Protocol should be used to pass information from connecting client requests to
               the backend service. Default value is `false`.
        :param pulumi.Input[Union['LoadBalancerFirewallArgs', 'LoadBalancerFirewallArgsDict']] firewall: A block containing rules for allowing/denying traffic to the Load Balancer. The `firewall` block is documented below. Only 1 firewall is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerForwardingRuleArgs', 'LoadBalancerForwardingRuleArgsDict']]]] forwarding_rules: A list of `forwarding_rule` to be assigned to the
               Load Balancer. The `forwarding_rule` block is documented below.
        :param pulumi.Input[Union['LoadBalancerGlbSettingsArgs', 'LoadBalancerGlbSettingsArgsDict']] glb_settings: A block containing `glb_settings` required to define target rules for a Global Load Balancer. The `glb_settings` block is documented below.
        :param pulumi.Input[Union['LoadBalancerHealthcheckArgs', 'LoadBalancerHealthcheckArgsDict']] healthcheck: A `healthcheck` block to be assigned to the
               Load Balancer. The `healthcheck` block is documented below. Only 1 healthcheck is allowed.
        :param pulumi.Input[int] http_idle_timeout_seconds: Specifies the idle timeout for HTTPS connections on the load balancer in seconds.
        :param pulumi.Input[str] name: The Load Balancer name
        :param pulumi.Input[str] network: The type of network the Load Balancer is accessible from. It must be either of `INTERNAL` or `EXTERNAL`. Defaults to `EXTERNAL`.
               **NOTE**: non-`EXTERNAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] project_id: The ID of the project that the load balancer is associated with. If no ID is provided at creation, the load balancer associates with the user's default project.
        :param pulumi.Input[bool] redirect_http_to_https: A boolean value indicating whether
               HTTP requests to the Load Balancer on port 80 will be redirected to HTTPS on port 443.
               Default value is `false`.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in
        :param pulumi.Input[str] size: The size of the Load Balancer. It must be either `lb-small`, `lb-medium`, or `lb-large`. Defaults to `lb-small`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input[int] size_unit: The size of the Load Balancer. It must be in the range (1, 100). Defaults to `1`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input[Union['LoadBalancerStickySessionsArgs', 'LoadBalancerStickySessionsArgsDict']] sticky_sessions: A `sticky_sessions` block to be assigned to the
               Load Balancer. The `sticky_sessions` block is documented below. Only 1 sticky_sessions block is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_load_balancer_ids: A list of Load Balancer IDs to be attached behind a Global Load Balancer.
        :param pulumi.Input[str] type: The type of the Load Balancer. It must be either of `REGIONAL` or `GLOBAL`. Defaults to `REGIONAL`.
               **NOTE**: non-`REGIONAL/GLOBAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the load balancer will be located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LoadBalancerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean Load Balancer resource. This can be used to create,
        modify, and delete Load Balancers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        web = digitalocean.Droplet("web",
            name="web-1",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-18-04-x64",
            region=digitalocean.Region.NYC3)
        public = digitalocean.LoadBalancer("public",
            name="loadbalancer-1",
            region=digitalocean.Region.NYC3,
            forwarding_rules=[{
                "entry_port": 80,
                "entry_protocol": "http",
                "target_port": 80,
                "target_protocol": "http",
            }],
            healthcheck={
                "port": 22,
                "protocol": "tcp",
            },
            droplet_ids=[web.id])
        ```

        When managing certificates attached to the load balancer, make sure to add the `create_before_destroy`
        lifecycle property in order to ensure the certificate is correctly updated when changed. The order of
        operations will then be: `Create new certificate` > `Update loadbalancer with new certificate` ->
        `Delete old certificate`. When doing so, you must also change the name of the certificate,
        as there cannot be multiple certificates with the same name in an account.

        ## Import

        Load Balancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/loadBalancer:LoadBalancer myloadbalancer 4de7ac8b-495b-4884-9a69-1050c6793cd6
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union[str, 'Algorithm']]] = None,
                 disable_lets_encrypt_dns_records: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerDomainArgs', 'LoadBalancerDomainArgsDict']]]]] = None,
                 droplet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 droplet_tag: Optional[pulumi.Input[str]] = None,
                 enable_backend_keepalive: Optional[pulumi.Input[bool]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 firewall: Optional[pulumi.Input[Union['LoadBalancerFirewallArgs', 'LoadBalancerFirewallArgsDict']]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerForwardingRuleArgs', 'LoadBalancerForwardingRuleArgsDict']]]]] = None,
                 glb_settings: Optional[pulumi.Input[Union['LoadBalancerGlbSettingsArgs', 'LoadBalancerGlbSettingsArgsDict']]] = None,
                 healthcheck: Optional[pulumi.Input[Union['LoadBalancerHealthcheckArgs', 'LoadBalancerHealthcheckArgsDict']]] = None,
                 http_idle_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect_http_to_https: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_unit: Optional[pulumi.Input[int]] = None,
                 sticky_sessions: Optional[pulumi.Input[Union['LoadBalancerStickySessionsArgs', 'LoadBalancerStickySessionsArgsDict']]] = None,
                 target_load_balancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["disable_lets_encrypt_dns_records"] = disable_lets_encrypt_dns_records
            __props__.__dict__["domains"] = domains
            __props__.__dict__["droplet_ids"] = droplet_ids
            __props__.__dict__["droplet_tag"] = droplet_tag
            __props__.__dict__["enable_backend_keepalive"] = enable_backend_keepalive
            __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
            __props__.__dict__["firewall"] = firewall
            __props__.__dict__["forwarding_rules"] = forwarding_rules
            __props__.__dict__["glb_settings"] = glb_settings
            __props__.__dict__["healthcheck"] = healthcheck
            __props__.__dict__["http_idle_timeout_seconds"] = http_idle_timeout_seconds
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["redirect_http_to_https"] = redirect_http_to_https
            __props__.__dict__["region"] = region
            __props__.__dict__["size"] = size
            __props__.__dict__["size_unit"] = size_unit
            __props__.__dict__["sticky_sessions"] = sticky_sessions
            __props__.__dict__["target_load_balancer_ids"] = target_load_balancer_ids
            __props__.__dict__["type"] = type
            __props__.__dict__["vpc_uuid"] = vpc_uuid
            __props__.__dict__["ip"] = None
            __props__.__dict__["load_balancer_urn"] = None
            __props__.__dict__["status"] = None
        super(LoadBalancer, __self__).__init__(
            'digitalocean:index/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[Union[str, 'Algorithm']]] = None,
            disable_lets_encrypt_dns_records: Optional[pulumi.Input[bool]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerDomainArgs', 'LoadBalancerDomainArgsDict']]]]] = None,
            droplet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            droplet_tag: Optional[pulumi.Input[str]] = None,
            enable_backend_keepalive: Optional[pulumi.Input[bool]] = None,
            enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
            firewall: Optional[pulumi.Input[Union['LoadBalancerFirewallArgs', 'LoadBalancerFirewallArgsDict']]] = None,
            forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerForwardingRuleArgs', 'LoadBalancerForwardingRuleArgsDict']]]]] = None,
            glb_settings: Optional[pulumi.Input[Union['LoadBalancerGlbSettingsArgs', 'LoadBalancerGlbSettingsArgsDict']]] = None,
            healthcheck: Optional[pulumi.Input[Union['LoadBalancerHealthcheckArgs', 'LoadBalancerHealthcheckArgsDict']]] = None,
            http_idle_timeout_seconds: Optional[pulumi.Input[int]] = None,
            ip: Optional[pulumi.Input[str]] = None,
            load_balancer_urn: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            redirect_http_to_https: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
            size: Optional[pulumi.Input[str]] = None,
            size_unit: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sticky_sessions: Optional[pulumi.Input[Union['LoadBalancerStickySessionsArgs', 'LoadBalancerStickySessionsArgsDict']]] = None,
            target_load_balancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vpc_uuid: Optional[pulumi.Input[str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'Algorithm']] algorithm: **Deprecated** This field has been deprecated. You can no longer specify an algorithm for load balancers.
               or `least_connections`. The default value is `round_robin`.
        :param pulumi.Input[bool] disable_lets_encrypt_dns_records: A boolean value indicating whether to disable automatic DNS record creation for Let's Encrypt certificates that are added to the load balancer. Default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerDomainArgs', 'LoadBalancerDomainArgsDict']]]] domains: A list of `domains` required to ingress traffic to a Global Load Balancer. The `domains` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] droplet_ids: A list of the IDs of each droplet to be attached to the Load Balancer.
        :param pulumi.Input[str] droplet_tag: The name of a Droplet tag corresponding to Droplets to be assigned to the Load Balancer.
        :param pulumi.Input[bool] enable_backend_keepalive: A boolean value indicating whether HTTP keepalive connections are maintained to target Droplets. Default value is `false`.
        :param pulumi.Input[bool] enable_proxy_protocol: A boolean value indicating whether PROXY
               Protocol should be used to pass information from connecting client requests to
               the backend service. Default value is `false`.
        :param pulumi.Input[Union['LoadBalancerFirewallArgs', 'LoadBalancerFirewallArgsDict']] firewall: A block containing rules for allowing/denying traffic to the Load Balancer. The `firewall` block is documented below. Only 1 firewall is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerForwardingRuleArgs', 'LoadBalancerForwardingRuleArgsDict']]]] forwarding_rules: A list of `forwarding_rule` to be assigned to the
               Load Balancer. The `forwarding_rule` block is documented below.
        :param pulumi.Input[Union['LoadBalancerGlbSettingsArgs', 'LoadBalancerGlbSettingsArgsDict']] glb_settings: A block containing `glb_settings` required to define target rules for a Global Load Balancer. The `glb_settings` block is documented below.
        :param pulumi.Input[Union['LoadBalancerHealthcheckArgs', 'LoadBalancerHealthcheckArgsDict']] healthcheck: A `healthcheck` block to be assigned to the
               Load Balancer. The `healthcheck` block is documented below. Only 1 healthcheck is allowed.
        :param pulumi.Input[int] http_idle_timeout_seconds: Specifies the idle timeout for HTTPS connections on the load balancer in seconds.
        :param pulumi.Input[str] ip: The ip of the Load Balancer
        :param pulumi.Input[str] load_balancer_urn: The uniform resource name for the Load Balancer
        :param pulumi.Input[str] name: The Load Balancer name
        :param pulumi.Input[str] network: The type of network the Load Balancer is accessible from. It must be either of `INTERNAL` or `EXTERNAL`. Defaults to `EXTERNAL`.
               **NOTE**: non-`EXTERNAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] project_id: The ID of the project that the load balancer is associated with. If no ID is provided at creation, the load balancer associates with the user's default project.
        :param pulumi.Input[bool] redirect_http_to_https: A boolean value indicating whether
               HTTP requests to the Load Balancer on port 80 will be redirected to HTTPS on port 443.
               Default value is `false`.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in
        :param pulumi.Input[str] size: The size of the Load Balancer. It must be either `lb-small`, `lb-medium`, or `lb-large`. Defaults to `lb-small`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input[int] size_unit: The size of the Load Balancer. It must be in the range (1, 100). Defaults to `1`. Only one of `size` or `size_unit` may be provided.
        :param pulumi.Input[Union['LoadBalancerStickySessionsArgs', 'LoadBalancerStickySessionsArgsDict']] sticky_sessions: A `sticky_sessions` block to be assigned to the
               Load Balancer. The `sticky_sessions` block is documented below. Only 1 sticky_sessions block is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_load_balancer_ids: A list of Load Balancer IDs to be attached behind a Global Load Balancer.
        :param pulumi.Input[str] type: The type of the Load Balancer. It must be either of `REGIONAL` or `GLOBAL`. Defaults to `REGIONAL`.
               **NOTE**: non-`REGIONAL/GLOBAL` type may be part of closed beta feature and not available for public use.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the load balancer will be located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["disable_lets_encrypt_dns_records"] = disable_lets_encrypt_dns_records
        __props__.__dict__["domains"] = domains
        __props__.__dict__["droplet_ids"] = droplet_ids
        __props__.__dict__["droplet_tag"] = droplet_tag
        __props__.__dict__["enable_backend_keepalive"] = enable_backend_keepalive
        __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
        __props__.__dict__["firewall"] = firewall
        __props__.__dict__["forwarding_rules"] = forwarding_rules
        __props__.__dict__["glb_settings"] = glb_settings
        __props__.__dict__["healthcheck"] = healthcheck
        __props__.__dict__["http_idle_timeout_seconds"] = http_idle_timeout_seconds
        __props__.__dict__["ip"] = ip
        __props__.__dict__["load_balancer_urn"] = load_balancer_urn
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["redirect_http_to_https"] = redirect_http_to_https
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["size_unit"] = size_unit
        __props__.__dict__["status"] = status
        __props__.__dict__["sticky_sessions"] = sticky_sessions
        __props__.__dict__["target_load_balancer_ids"] = target_load_balancer_ids
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_uuid"] = vpc_uuid
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field has been deprecated. You can no longer specify an algorithm for load balancers.""")
    def algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        **Deprecated** This field has been deprecated. You can no longer specify an algorithm for load balancers.
        or `least_connections`. The default value is `round_robin`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="disableLetsEncryptDnsRecords")
    def disable_lets_encrypt_dns_records(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean value indicating whether to disable automatic DNS record creation for Let's Encrypt certificates that are added to the load balancer. Default value is `false`.
        """
        return pulumi.get(self, "disable_lets_encrypt_dns_records")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence['outputs.LoadBalancerDomain']]:
        """
        A list of `domains` required to ingress traffic to a Global Load Balancer. The `domains` block is documented below.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="dropletIds")
    def droplet_ids(self) -> pulumi.Output[Sequence[int]]:
        """
        A list of the IDs of each droplet to be attached to the Load Balancer.
        """
        return pulumi.get(self, "droplet_ids")

    @property
    @pulumi.getter(name="dropletTag")
    def droplet_tag(self) -> pulumi.Output[Optional[str]]:
        """
        The name of a Droplet tag corresponding to Droplets to be assigned to the Load Balancer.
        """
        return pulumi.get(self, "droplet_tag")

    @property
    @pulumi.getter(name="enableBackendKeepalive")
    def enable_backend_keepalive(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean value indicating whether HTTP keepalive connections are maintained to target Droplets. Default value is `false`.
        """
        return pulumi.get(self, "enable_backend_keepalive")

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean value indicating whether PROXY
        Protocol should be used to pass information from connecting client requests to
        the backend service. Default value is `false`.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @property
    @pulumi.getter
    def firewall(self) -> pulumi.Output['outputs.LoadBalancerFirewall']:
        """
        A block containing rules for allowing/denying traffic to the Load Balancer. The `firewall` block is documented below. Only 1 firewall is allowed.
        """
        return pulumi.get(self, "firewall")

    @property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerForwardingRule']]]:
        """
        A list of `forwarding_rule` to be assigned to the
        Load Balancer. The `forwarding_rule` block is documented below.
        """
        return pulumi.get(self, "forwarding_rules")

    @property
    @pulumi.getter(name="glbSettings")
    def glb_settings(self) -> pulumi.Output['outputs.LoadBalancerGlbSettings']:
        """
        A block containing `glb_settings` required to define target rules for a Global Load Balancer. The `glb_settings` block is documented below.
        """
        return pulumi.get(self, "glb_settings")

    @property
    @pulumi.getter
    def healthcheck(self) -> pulumi.Output['outputs.LoadBalancerHealthcheck']:
        """
        A `healthcheck` block to be assigned to the
        Load Balancer. The `healthcheck` block is documented below. Only 1 healthcheck is allowed.
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="httpIdleTimeoutSeconds")
    def http_idle_timeout_seconds(self) -> pulumi.Output[int]:
        """
        Specifies the idle timeout for HTTPS connections on the load balancer in seconds.
        """
        return pulumi.get(self, "http_idle_timeout_seconds")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        """
        The ip of the Load Balancer
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="loadBalancerUrn")
    def load_balancer_urn(self) -> pulumi.Output[str]:
        """
        The uniform resource name for the Load Balancer
        """
        return pulumi.get(self, "load_balancer_urn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The Load Balancer name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[str]]:
        """
        The type of network the Load Balancer is accessible from. It must be either of `INTERNAL` or `EXTERNAL`. Defaults to `EXTERNAL`.
        **NOTE**: non-`EXTERNAL` type may be part of closed beta feature and not available for public use.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project that the load balancer is associated with. If no ID is provided at creation, the load balancer associates with the user's default project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="redirectHttpToHttps")
    def redirect_http_to_https(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean value indicating whether
        HTTP requests to the Load Balancer on port 80 will be redirected to HTTPS on port 443.
        Default value is `false`.
        """
        return pulumi.get(self, "redirect_http_to_https")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to start in
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[Optional[str]]:
        """
        The size of the Load Balancer. It must be either `lb-small`, `lb-medium`, or `lb-large`. Defaults to `lb-small`. Only one of `size` or `size_unit` may be provided.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeUnit")
    def size_unit(self) -> pulumi.Output[int]:
        """
        The size of the Load Balancer. It must be in the range (1, 100). Defaults to `1`. Only one of `size` or `size_unit` may be provided.
        """
        return pulumi.get(self, "size_unit")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> pulumi.Output['outputs.LoadBalancerStickySessions']:
        """
        A `sticky_sessions` block to be assigned to the
        Load Balancer. The `sticky_sessions` block is documented below. Only 1 sticky_sessions block is allowed.
        """
        return pulumi.get(self, "sticky_sessions")

    @property
    @pulumi.getter(name="targetLoadBalancerIds")
    def target_load_balancer_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of Load Balancer IDs to be attached behind a Global Load Balancer.
        """
        return pulumi.get(self, "target_load_balancer_ids")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the Load Balancer. It must be either of `REGIONAL` or `GLOBAL`. Defaults to `REGIONAL`.
        **NOTE**: non-`REGIONAL/GLOBAL` type may be part of closed beta feature and not available for public use.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> pulumi.Output[str]:
        """
        The ID of the VPC where the load balancer will be located.
        """
        return pulumi.get(self, "vpc_uuid")

