# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorAlertArgs', 'MonitorAlert']

@pulumi.input_type
class MonitorAlertArgs:
    def __init__(__self__, *,
                 alerts: pulumi.Input['MonitorAlertAlertsArgs'],
                 compare: pulumi.Input[str],
                 description: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[float],
                 window: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a MonitorAlert resource.
        :param pulumi.Input['MonitorAlertAlertsArgs'] alerts: How to send notifications about the alerts. This is a list with one element, .
               Note that for Slack, the DigitalOcean app needs to have permissions for your workspace. You can
               read more in [Slack's documentation](https://slack.com/intl/en-dk/help/articles/222386767-Manage-app-installation-settings-for-your-workspace)
        :param pulumi.Input[str] compare: The comparison for `value`.
               This may be either `GreaterThan` or `LessThan`.
        :param pulumi.Input[str] description: The description of the alert.
        :param pulumi.Input[str] type: The type of the alert.
               This may be one of `v1/insights/droplet/load_1`, `v1/insights/droplet/load_5`, `v1/insights/droplet/load_15`,
               `v1/insights/droplet/memory_utilization_percent`, `v1/insights/droplet/disk_utilization_percent`,
               `v1/insights/droplet/cpu`, `v1/insights/droplet/disk_read`, `v1/insights/droplet/disk_write`,
               `v1/insights/droplet/public_outbound_bandwidth`, `v1/insights/droplet/public_inbound_bandwidth`,
               `v1/insights/droplet/private_outbound_bandwidth`, `v1/insights/droplet/private_inbound_bandwidth`,
               `v1/insights/lbaas/avg_cpu_utilization_percent`, `v1/insights/lbaas/connection_utilization_percent`,
               `v1/insights/lbaas/droplet_health`, `v1/insights/lbaas/tls_connections_per_second_utilization_percent`,
               `v1/insights/lbaas/increase_in_http_error_rate_percentage_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_percentage_4xx`,
               `v1/insights/lbaas/increase_in_http_error_rate_count_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_count_4xx`,
               `v1/insights/lbaas/high_http_request_response_time`, `v1/insights/lbaas/high_http_request_response_time_50p`,
               `v1/insights/lbaas/high_http_request_response_time_95p`, `v1/insights/lbaas/high_http_request_response_time_99p`,
               `v1/dbaas/alerts/load_15_alerts`, `v1/dbaas/alerts/cpu_alerts`, `v1/dbaas/alerts/memory_utilization_alerts`, or
               `v1/dbaas/alerts/disk_utilization_alerts`.
        :param pulumi.Input[float] value: The value to start alerting at, e.g., 90% or 85Mbps. This is a floating-point number.
               DigitalOcean will show the correct unit in the web panel.
        :param pulumi.Input[str] window: The time frame of the alert. Either `5m`, `10m`, `30m`, or `1h`.
        :param pulumi.Input[bool] enabled: The status of the alert.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: A list of IDs for the resources to which the alert policy applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags. When an included tag is added to a resource, the alert policy will apply to it.
        """
        pulumi.set(__self__, "alerts", alerts)
        pulumi.set(__self__, "compare", compare)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Input['MonitorAlertAlertsArgs']:
        """
        How to send notifications about the alerts. This is a list with one element, .
        Note that for Slack, the DigitalOcean app needs to have permissions for your workspace. You can
        read more in [Slack's documentation](https://slack.com/intl/en-dk/help/articles/222386767-Manage-app-installation-settings-for-your-workspace)
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: pulumi.Input['MonitorAlertAlertsArgs']):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter
    def compare(self) -> pulumi.Input[str]:
        """
        The comparison for `value`.
        This may be either `GreaterThan` or `LessThan`.
        """
        return pulumi.get(self, "compare")

    @compare.setter
    def compare(self, value: pulumi.Input[str]):
        pulumi.set(self, "compare", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the alert.
        This may be one of `v1/insights/droplet/load_1`, `v1/insights/droplet/load_5`, `v1/insights/droplet/load_15`,
        `v1/insights/droplet/memory_utilization_percent`, `v1/insights/droplet/disk_utilization_percent`,
        `v1/insights/droplet/cpu`, `v1/insights/droplet/disk_read`, `v1/insights/droplet/disk_write`,
        `v1/insights/droplet/public_outbound_bandwidth`, `v1/insights/droplet/public_inbound_bandwidth`,
        `v1/insights/droplet/private_outbound_bandwidth`, `v1/insights/droplet/private_inbound_bandwidth`,
        `v1/insights/lbaas/avg_cpu_utilization_percent`, `v1/insights/lbaas/connection_utilization_percent`,
        `v1/insights/lbaas/droplet_health`, `v1/insights/lbaas/tls_connections_per_second_utilization_percent`,
        `v1/insights/lbaas/increase_in_http_error_rate_percentage_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_percentage_4xx`,
        `v1/insights/lbaas/increase_in_http_error_rate_count_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_count_4xx`,
        `v1/insights/lbaas/high_http_request_response_time`, `v1/insights/lbaas/high_http_request_response_time_50p`,
        `v1/insights/lbaas/high_http_request_response_time_95p`, `v1/insights/lbaas/high_http_request_response_time_99p`,
        `v1/dbaas/alerts/load_15_alerts`, `v1/dbaas/alerts/cpu_alerts`, `v1/dbaas/alerts/memory_utilization_alerts`, or
        `v1/dbaas/alerts/disk_utilization_alerts`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        The value to start alerting at, e.g., 90% or 85Mbps. This is a floating-point number.
        DigitalOcean will show the correct unit in the web panel.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def window(self) -> pulumi.Input[str]:
        """
        The time frame of the alert. Either `5m`, `10m`, `30m`, or `1h`.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: pulumi.Input[str]):
        pulumi.set(self, "window", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of the alert.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the resources to which the alert policy applies.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entities", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags. When an included tag is added to a resource, the alert policy will apply to it.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MonitorAlertState:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['MonitorAlertAlertsArgs']] = None,
                 compare: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None,
                 window: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MonitorAlert resources.
        :param pulumi.Input['MonitorAlertAlertsArgs'] alerts: How to send notifications about the alerts. This is a list with one element, .
               Note that for Slack, the DigitalOcean app needs to have permissions for your workspace. You can
               read more in [Slack's documentation](https://slack.com/intl/en-dk/help/articles/222386767-Manage-app-installation-settings-for-your-workspace)
        :param pulumi.Input[str] compare: The comparison for `value`.
               This may be either `GreaterThan` or `LessThan`.
        :param pulumi.Input[str] description: The description of the alert.
        :param pulumi.Input[bool] enabled: The status of the alert.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: A list of IDs for the resources to which the alert policy applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags. When an included tag is added to a resource, the alert policy will apply to it.
        :param pulumi.Input[str] type: The type of the alert.
               This may be one of `v1/insights/droplet/load_1`, `v1/insights/droplet/load_5`, `v1/insights/droplet/load_15`,
               `v1/insights/droplet/memory_utilization_percent`, `v1/insights/droplet/disk_utilization_percent`,
               `v1/insights/droplet/cpu`, `v1/insights/droplet/disk_read`, `v1/insights/droplet/disk_write`,
               `v1/insights/droplet/public_outbound_bandwidth`, `v1/insights/droplet/public_inbound_bandwidth`,
               `v1/insights/droplet/private_outbound_bandwidth`, `v1/insights/droplet/private_inbound_bandwidth`,
               `v1/insights/lbaas/avg_cpu_utilization_percent`, `v1/insights/lbaas/connection_utilization_percent`,
               `v1/insights/lbaas/droplet_health`, `v1/insights/lbaas/tls_connections_per_second_utilization_percent`,
               `v1/insights/lbaas/increase_in_http_error_rate_percentage_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_percentage_4xx`,
               `v1/insights/lbaas/increase_in_http_error_rate_count_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_count_4xx`,
               `v1/insights/lbaas/high_http_request_response_time`, `v1/insights/lbaas/high_http_request_response_time_50p`,
               `v1/insights/lbaas/high_http_request_response_time_95p`, `v1/insights/lbaas/high_http_request_response_time_99p`,
               `v1/dbaas/alerts/load_15_alerts`, `v1/dbaas/alerts/cpu_alerts`, `v1/dbaas/alerts/memory_utilization_alerts`, or
               `v1/dbaas/alerts/disk_utilization_alerts`.
        :param pulumi.Input[str] uuid: The uuid of the alert.
        :param pulumi.Input[float] value: The value to start alerting at, e.g., 90% or 85Mbps. This is a floating-point number.
               DigitalOcean will show the correct unit in the web panel.
        :param pulumi.Input[str] window: The time frame of the alert. Either `5m`, `10m`, `30m`, or `1h`.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if compare is not None:
            pulumi.set(__self__, "compare", compare)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['MonitorAlertAlertsArgs']]:
        """
        How to send notifications about the alerts. This is a list with one element, .
        Note that for Slack, the DigitalOcean app needs to have permissions for your workspace. You can
        read more in [Slack's documentation](https://slack.com/intl/en-dk/help/articles/222386767-Manage-app-installation-settings-for-your-workspace)
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['MonitorAlertAlertsArgs']]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter
    def compare(self) -> Optional[pulumi.Input[str]]:
        """
        The comparison for `value`.
        This may be either `GreaterThan` or `LessThan`.
        """
        return pulumi.get(self, "compare")

    @compare.setter
    def compare(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compare", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of the alert.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the resources to which the alert policy applies.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entities", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags. When an included tag is added to a resource, the alert policy will apply to it.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the alert.
        This may be one of `v1/insights/droplet/load_1`, `v1/insights/droplet/load_5`, `v1/insights/droplet/load_15`,
        `v1/insights/droplet/memory_utilization_percent`, `v1/insights/droplet/disk_utilization_percent`,
        `v1/insights/droplet/cpu`, `v1/insights/droplet/disk_read`, `v1/insights/droplet/disk_write`,
        `v1/insights/droplet/public_outbound_bandwidth`, `v1/insights/droplet/public_inbound_bandwidth`,
        `v1/insights/droplet/private_outbound_bandwidth`, `v1/insights/droplet/private_inbound_bandwidth`,
        `v1/insights/lbaas/avg_cpu_utilization_percent`, `v1/insights/lbaas/connection_utilization_percent`,
        `v1/insights/lbaas/droplet_health`, `v1/insights/lbaas/tls_connections_per_second_utilization_percent`,
        `v1/insights/lbaas/increase_in_http_error_rate_percentage_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_percentage_4xx`,
        `v1/insights/lbaas/increase_in_http_error_rate_count_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_count_4xx`,
        `v1/insights/lbaas/high_http_request_response_time`, `v1/insights/lbaas/high_http_request_response_time_50p`,
        `v1/insights/lbaas/high_http_request_response_time_95p`, `v1/insights/lbaas/high_http_request_response_time_99p`,
        `v1/dbaas/alerts/load_15_alerts`, `v1/dbaas/alerts/cpu_alerts`, `v1/dbaas/alerts/memory_utilization_alerts`, or
        `v1/dbaas/alerts/disk_utilization_alerts`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The uuid of the alert.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        The value to start alerting at, e.g., 90% or 85Mbps. This is a floating-point number.
        DigitalOcean will show the correct unit in the web panel.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input[str]]:
        """
        The time frame of the alert. Either `5m`, `10m`, `30m`, or `1h`.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window", value)


class MonitorAlert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['MonitorAlertAlertsArgs', 'MonitorAlertAlertsArgsDict']]] = None,
                 compare: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None,
                 window: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [DigitalOcean Monitoring](https://docs.digitalocean.com/reference/api/api-reference/#tag/Monitoring)
        resource. Monitor alerts can be configured to alert about, e.g., disk or memory
        usage exceeding a certain threshold or traffic at a certain limit. Notifications
        can be sent to either an email address or a Slack channel.

        > **Note** Currently, the [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#operation/create_alert_policy) only supports creating alerts for Droplets.

        ## Import

        Monitor alerts can be imported using the monitor alert `uuid`, e.g.

        ```sh
        $ pulumi import digitalocean:index/monitorAlert:MonitorAlert cpu_alert b8ecd2ab-2267-4a5e-8692-cbf1d32583e3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MonitorAlertAlertsArgs', 'MonitorAlertAlertsArgsDict']] alerts: How to send notifications about the alerts. This is a list with one element, .
               Note that for Slack, the DigitalOcean app needs to have permissions for your workspace. You can
               read more in [Slack's documentation](https://slack.com/intl/en-dk/help/articles/222386767-Manage-app-installation-settings-for-your-workspace)
        :param pulumi.Input[str] compare: The comparison for `value`.
               This may be either `GreaterThan` or `LessThan`.
        :param pulumi.Input[str] description: The description of the alert.
        :param pulumi.Input[bool] enabled: The status of the alert.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: A list of IDs for the resources to which the alert policy applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags. When an included tag is added to a resource, the alert policy will apply to it.
        :param pulumi.Input[str] type: The type of the alert.
               This may be one of `v1/insights/droplet/load_1`, `v1/insights/droplet/load_5`, `v1/insights/droplet/load_15`,
               `v1/insights/droplet/memory_utilization_percent`, `v1/insights/droplet/disk_utilization_percent`,
               `v1/insights/droplet/cpu`, `v1/insights/droplet/disk_read`, `v1/insights/droplet/disk_write`,
               `v1/insights/droplet/public_outbound_bandwidth`, `v1/insights/droplet/public_inbound_bandwidth`,
               `v1/insights/droplet/private_outbound_bandwidth`, `v1/insights/droplet/private_inbound_bandwidth`,
               `v1/insights/lbaas/avg_cpu_utilization_percent`, `v1/insights/lbaas/connection_utilization_percent`,
               `v1/insights/lbaas/droplet_health`, `v1/insights/lbaas/tls_connections_per_second_utilization_percent`,
               `v1/insights/lbaas/increase_in_http_error_rate_percentage_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_percentage_4xx`,
               `v1/insights/lbaas/increase_in_http_error_rate_count_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_count_4xx`,
               `v1/insights/lbaas/high_http_request_response_time`, `v1/insights/lbaas/high_http_request_response_time_50p`,
               `v1/insights/lbaas/high_http_request_response_time_95p`, `v1/insights/lbaas/high_http_request_response_time_99p`,
               `v1/dbaas/alerts/load_15_alerts`, `v1/dbaas/alerts/cpu_alerts`, `v1/dbaas/alerts/memory_utilization_alerts`, or
               `v1/dbaas/alerts/disk_utilization_alerts`.
        :param pulumi.Input[float] value: The value to start alerting at, e.g., 90% or 85Mbps. This is a floating-point number.
               DigitalOcean will show the correct unit in the web panel.
        :param pulumi.Input[str] window: The time frame of the alert. Either `5m`, `10m`, `30m`, or `1h`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorAlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [DigitalOcean Monitoring](https://docs.digitalocean.com/reference/api/api-reference/#tag/Monitoring)
        resource. Monitor alerts can be configured to alert about, e.g., disk or memory
        usage exceeding a certain threshold or traffic at a certain limit. Notifications
        can be sent to either an email address or a Slack channel.

        > **Note** Currently, the [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#operation/create_alert_policy) only supports creating alerts for Droplets.

        ## Import

        Monitor alerts can be imported using the monitor alert `uuid`, e.g.

        ```sh
        $ pulumi import digitalocean:index/monitorAlert:MonitorAlert cpu_alert b8ecd2ab-2267-4a5e-8692-cbf1d32583e3
        ```

        :param str resource_name: The name of the resource.
        :param MonitorAlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorAlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['MonitorAlertAlertsArgs', 'MonitorAlertAlertsArgsDict']]] = None,
                 compare: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None,
                 window: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorAlertArgs.__new__(MonitorAlertArgs)

            if alerts is None and not opts.urn:
                raise TypeError("Missing required property 'alerts'")
            __props__.__dict__["alerts"] = alerts
            if compare is None and not opts.urn:
                raise TypeError("Missing required property 'compare'")
            __props__.__dict__["compare"] = compare
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["entities"] = entities
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            if window is None and not opts.urn:
                raise TypeError("Missing required property 'window'")
            __props__.__dict__["window"] = window
            __props__.__dict__["uuid"] = None
        super(MonitorAlert, __self__).__init__(
            'digitalocean:index/monitorAlert:MonitorAlert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerts: Optional[pulumi.Input[Union['MonitorAlertAlertsArgs', 'MonitorAlertAlertsArgsDict']]] = None,
            compare: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uuid: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[float]] = None,
            window: Optional[pulumi.Input[str]] = None) -> 'MonitorAlert':
        """
        Get an existing MonitorAlert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MonitorAlertAlertsArgs', 'MonitorAlertAlertsArgsDict']] alerts: How to send notifications about the alerts. This is a list with one element, .
               Note that for Slack, the DigitalOcean app needs to have permissions for your workspace. You can
               read more in [Slack's documentation](https://slack.com/intl/en-dk/help/articles/222386767-Manage-app-installation-settings-for-your-workspace)
        :param pulumi.Input[str] compare: The comparison for `value`.
               This may be either `GreaterThan` or `LessThan`.
        :param pulumi.Input[str] description: The description of the alert.
        :param pulumi.Input[bool] enabled: The status of the alert.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: A list of IDs for the resources to which the alert policy applies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags. When an included tag is added to a resource, the alert policy will apply to it.
        :param pulumi.Input[str] type: The type of the alert.
               This may be one of `v1/insights/droplet/load_1`, `v1/insights/droplet/load_5`, `v1/insights/droplet/load_15`,
               `v1/insights/droplet/memory_utilization_percent`, `v1/insights/droplet/disk_utilization_percent`,
               `v1/insights/droplet/cpu`, `v1/insights/droplet/disk_read`, `v1/insights/droplet/disk_write`,
               `v1/insights/droplet/public_outbound_bandwidth`, `v1/insights/droplet/public_inbound_bandwidth`,
               `v1/insights/droplet/private_outbound_bandwidth`, `v1/insights/droplet/private_inbound_bandwidth`,
               `v1/insights/lbaas/avg_cpu_utilization_percent`, `v1/insights/lbaas/connection_utilization_percent`,
               `v1/insights/lbaas/droplet_health`, `v1/insights/lbaas/tls_connections_per_second_utilization_percent`,
               `v1/insights/lbaas/increase_in_http_error_rate_percentage_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_percentage_4xx`,
               `v1/insights/lbaas/increase_in_http_error_rate_count_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_count_4xx`,
               `v1/insights/lbaas/high_http_request_response_time`, `v1/insights/lbaas/high_http_request_response_time_50p`,
               `v1/insights/lbaas/high_http_request_response_time_95p`, `v1/insights/lbaas/high_http_request_response_time_99p`,
               `v1/dbaas/alerts/load_15_alerts`, `v1/dbaas/alerts/cpu_alerts`, `v1/dbaas/alerts/memory_utilization_alerts`, or
               `v1/dbaas/alerts/disk_utilization_alerts`.
        :param pulumi.Input[str] uuid: The uuid of the alert.
        :param pulumi.Input[float] value: The value to start alerting at, e.g., 90% or 85Mbps. This is a floating-point number.
               DigitalOcean will show the correct unit in the web panel.
        :param pulumi.Input[str] window: The time frame of the alert. Either `5m`, `10m`, `30m`, or `1h`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorAlertState.__new__(_MonitorAlertState)

        __props__.__dict__["alerts"] = alerts
        __props__.__dict__["compare"] = compare
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entities"] = entities
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["value"] = value
        __props__.__dict__["window"] = window
        return MonitorAlert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Output['outputs.MonitorAlertAlerts']:
        """
        How to send notifications about the alerts. This is a list with one element, .
        Note that for Slack, the DigitalOcean app needs to have permissions for your workspace. You can
        read more in [Slack's documentation](https://slack.com/intl/en-dk/help/articles/222386767-Manage-app-installation-settings-for-your-workspace)
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter
    def compare(self) -> pulumi.Output[str]:
        """
        The comparison for `value`.
        This may be either `GreaterThan` or `LessThan`.
        """
        return pulumi.get(self, "compare")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The status of the alert.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def entities(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IDs for the resources to which the alert policy applies.
        """
        return pulumi.get(self, "entities")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags. When an included tag is added to a resource, the alert policy will apply to it.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the alert.
        This may be one of `v1/insights/droplet/load_1`, `v1/insights/droplet/load_5`, `v1/insights/droplet/load_15`,
        `v1/insights/droplet/memory_utilization_percent`, `v1/insights/droplet/disk_utilization_percent`,
        `v1/insights/droplet/cpu`, `v1/insights/droplet/disk_read`, `v1/insights/droplet/disk_write`,
        `v1/insights/droplet/public_outbound_bandwidth`, `v1/insights/droplet/public_inbound_bandwidth`,
        `v1/insights/droplet/private_outbound_bandwidth`, `v1/insights/droplet/private_inbound_bandwidth`,
        `v1/insights/lbaas/avg_cpu_utilization_percent`, `v1/insights/lbaas/connection_utilization_percent`,
        `v1/insights/lbaas/droplet_health`, `v1/insights/lbaas/tls_connections_per_second_utilization_percent`,
        `v1/insights/lbaas/increase_in_http_error_rate_percentage_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_percentage_4xx`,
        `v1/insights/lbaas/increase_in_http_error_rate_count_5xx`, `v1/insights/lbaas/increase_in_http_error_rate_count_4xx`,
        `v1/insights/lbaas/high_http_request_response_time`, `v1/insights/lbaas/high_http_request_response_time_50p`,
        `v1/insights/lbaas/high_http_request_response_time_95p`, `v1/insights/lbaas/high_http_request_response_time_99p`,
        `v1/dbaas/alerts/load_15_alerts`, `v1/dbaas/alerts/cpu_alerts`, `v1/dbaas/alerts/memory_utilization_alerts`, or
        `v1/dbaas/alerts/disk_utilization_alerts`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        The uuid of the alert.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[float]:
        """
        The value to start alerting at, e.g., 90% or 85Mbps. This is a floating-point number.
        DigitalOcean will show the correct unit in the web panel.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> pulumi.Output[str]:
        """
        The time frame of the alert. Either `5m`, `10m`, `30m`, or `1h`.
        """
        return pulumi.get(self, "window")

