# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AppDedicatedIp',
    'AppSpec',
    'AppSpecAlert',
    'AppSpecDatabase',
    'AppSpecDomainName',
    'AppSpecEgress',
    'AppSpecEnv',
    'AppSpecFunction',
    'AppSpecFunctionAlert',
    'AppSpecFunctionCors',
    'AppSpecFunctionCorsAllowOrigins',
    'AppSpecFunctionEnv',
    'AppSpecFunctionGit',
    'AppSpecFunctionGithub',
    'AppSpecFunctionGitlab',
    'AppSpecFunctionLogDestination',
    'AppSpecFunctionLogDestinationDatadog',
    'AppSpecFunctionLogDestinationLogtail',
    'AppSpecFunctionLogDestinationOpenSearch',
    'AppSpecFunctionLogDestinationOpenSearchBasicAuth',
    'AppSpecFunctionLogDestinationPapertrail',
    'AppSpecFunctionRoute',
    'AppSpecIngress',
    'AppSpecIngressRule',
    'AppSpecIngressRuleComponent',
    'AppSpecIngressRuleCors',
    'AppSpecIngressRuleCorsAllowOrigins',
    'AppSpecIngressRuleMatch',
    'AppSpecIngressRuleMatchPath',
    'AppSpecIngressRuleRedirect',
    'AppSpecJob',
    'AppSpecJobAlert',
    'AppSpecJobEnv',
    'AppSpecJobGit',
    'AppSpecJobGithub',
    'AppSpecJobGitlab',
    'AppSpecJobImage',
    'AppSpecJobImageDeployOnPush',
    'AppSpecJobLogDestination',
    'AppSpecJobLogDestinationDatadog',
    'AppSpecJobLogDestinationLogtail',
    'AppSpecJobLogDestinationOpenSearch',
    'AppSpecJobLogDestinationOpenSearchBasicAuth',
    'AppSpecJobLogDestinationPapertrail',
    'AppSpecService',
    'AppSpecServiceAlert',
    'AppSpecServiceAutoscaling',
    'AppSpecServiceAutoscalingMetrics',
    'AppSpecServiceAutoscalingMetricsCpu',
    'AppSpecServiceCors',
    'AppSpecServiceCorsAllowOrigins',
    'AppSpecServiceEnv',
    'AppSpecServiceGit',
    'AppSpecServiceGithub',
    'AppSpecServiceGitlab',
    'AppSpecServiceHealthCheck',
    'AppSpecServiceImage',
    'AppSpecServiceImageDeployOnPush',
    'AppSpecServiceLogDestination',
    'AppSpecServiceLogDestinationDatadog',
    'AppSpecServiceLogDestinationLogtail',
    'AppSpecServiceLogDestinationOpenSearch',
    'AppSpecServiceLogDestinationOpenSearchBasicAuth',
    'AppSpecServiceLogDestinationPapertrail',
    'AppSpecServiceRoute',
    'AppSpecStaticSite',
    'AppSpecStaticSiteCors',
    'AppSpecStaticSiteCorsAllowOrigins',
    'AppSpecStaticSiteEnv',
    'AppSpecStaticSiteGit',
    'AppSpecStaticSiteGithub',
    'AppSpecStaticSiteGitlab',
    'AppSpecStaticSiteRoute',
    'AppSpecWorker',
    'AppSpecWorkerAlert',
    'AppSpecWorkerEnv',
    'AppSpecWorkerGit',
    'AppSpecWorkerGithub',
    'AppSpecWorkerGitlab',
    'AppSpecWorkerImage',
    'AppSpecWorkerImageDeployOnPush',
    'AppSpecWorkerLogDestination',
    'AppSpecWorkerLogDestinationDatadog',
    'AppSpecWorkerLogDestinationLogtail',
    'AppSpecWorkerLogDestinationOpenSearch',
    'AppSpecWorkerLogDestinationOpenSearchBasicAuth',
    'AppSpecWorkerLogDestinationPapertrail',
    'DatabaseClusterBackupRestore',
    'DatabaseClusterMaintenanceWindow',
    'DatabaseFirewallRule',
    'DatabaseKafkaTopicConfig',
    'DatabasePostgresqlConfigPgbouncer',
    'DatabasePostgresqlConfigTimescaledb',
    'DatabaseUserSetting',
    'DatabaseUserSettingAcl',
    'DatabaseUserSettingOpensearchAcl',
    'DropletBackupPolicy',
    'FirewallInboundRule',
    'FirewallOutboundRule',
    'FirewallPendingChange',
    'KubernetesClusterKubeConfig',
    'KubernetesClusterMaintenancePolicy',
    'KubernetesClusterNodePool',
    'KubernetesClusterNodePoolNode',
    'KubernetesClusterNodePoolTaint',
    'KubernetesNodePoolNode',
    'KubernetesNodePoolTaint',
    'LoadBalancerDomain',
    'LoadBalancerFirewall',
    'LoadBalancerForwardingRule',
    'LoadBalancerGlbSettings',
    'LoadBalancerGlbSettingsCdn',
    'LoadBalancerHealthcheck',
    'LoadBalancerStickySessions',
    'MonitorAlertAlerts',
    'MonitorAlertAlertsSlack',
    'SpacesBucketCorsConfigurationCorsRule',
    'SpacesBucketCorsRule',
    'SpacesBucketLifecycleRule',
    'SpacesBucketLifecycleRuleExpiration',
    'SpacesBucketLifecycleRuleNoncurrentVersionExpiration',
    'SpacesBucketVersioning',
    'UptimeAlertNotification',
    'UptimeAlertNotificationSlack',
    'GetAppDedicatedIpResult',
    'GetAppSpecResult',
    'GetAppSpecAlertResult',
    'GetAppSpecDatabaseResult',
    'GetAppSpecDomainResult',
    'GetAppSpecEgressResult',
    'GetAppSpecEnvResult',
    'GetAppSpecFunctionResult',
    'GetAppSpecFunctionAlertResult',
    'GetAppSpecFunctionCorsResult',
    'GetAppSpecFunctionCorsAllowOriginsResult',
    'GetAppSpecFunctionEnvResult',
    'GetAppSpecFunctionGitResult',
    'GetAppSpecFunctionGithubResult',
    'GetAppSpecFunctionGitlabResult',
    'GetAppSpecFunctionLogDestinationResult',
    'GetAppSpecFunctionLogDestinationDatadogResult',
    'GetAppSpecFunctionLogDestinationLogtailResult',
    'GetAppSpecFunctionLogDestinationOpenSearchResult',
    'GetAppSpecFunctionLogDestinationOpenSearchBasicAuthResult',
    'GetAppSpecFunctionLogDestinationPapertrailResult',
    'GetAppSpecFunctionRouteResult',
    'GetAppSpecIngressResult',
    'GetAppSpecIngressRuleResult',
    'GetAppSpecIngressRuleComponentResult',
    'GetAppSpecIngressRuleCorsResult',
    'GetAppSpecIngressRuleCorsAllowOriginsResult',
    'GetAppSpecIngressRuleMatchResult',
    'GetAppSpecIngressRuleMatchPathResult',
    'GetAppSpecIngressRuleRedirectResult',
    'GetAppSpecJobResult',
    'GetAppSpecJobAlertResult',
    'GetAppSpecJobEnvResult',
    'GetAppSpecJobGitResult',
    'GetAppSpecJobGithubResult',
    'GetAppSpecJobGitlabResult',
    'GetAppSpecJobImageResult',
    'GetAppSpecJobImageDeployOnPushResult',
    'GetAppSpecJobLogDestinationResult',
    'GetAppSpecJobLogDestinationDatadogResult',
    'GetAppSpecJobLogDestinationLogtailResult',
    'GetAppSpecJobLogDestinationOpenSearchResult',
    'GetAppSpecJobLogDestinationOpenSearchBasicAuthResult',
    'GetAppSpecJobLogDestinationPapertrailResult',
    'GetAppSpecServiceResult',
    'GetAppSpecServiceAlertResult',
    'GetAppSpecServiceAutoscalingResult',
    'GetAppSpecServiceAutoscalingMetricsResult',
    'GetAppSpecServiceAutoscalingMetricsCpuResult',
    'GetAppSpecServiceCorsResult',
    'GetAppSpecServiceCorsAllowOriginsResult',
    'GetAppSpecServiceEnvResult',
    'GetAppSpecServiceGitResult',
    'GetAppSpecServiceGithubResult',
    'GetAppSpecServiceGitlabResult',
    'GetAppSpecServiceHealthCheckResult',
    'GetAppSpecServiceImageResult',
    'GetAppSpecServiceImageDeployOnPushResult',
    'GetAppSpecServiceLogDestinationResult',
    'GetAppSpecServiceLogDestinationDatadogResult',
    'GetAppSpecServiceLogDestinationLogtailResult',
    'GetAppSpecServiceLogDestinationOpenSearchResult',
    'GetAppSpecServiceLogDestinationOpenSearchBasicAuthResult',
    'GetAppSpecServiceLogDestinationPapertrailResult',
    'GetAppSpecServiceRouteResult',
    'GetAppSpecStaticSiteResult',
    'GetAppSpecStaticSiteCorsResult',
    'GetAppSpecStaticSiteCorsAllowOriginsResult',
    'GetAppSpecStaticSiteEnvResult',
    'GetAppSpecStaticSiteGitResult',
    'GetAppSpecStaticSiteGithubResult',
    'GetAppSpecStaticSiteGitlabResult',
    'GetAppSpecStaticSiteRouteResult',
    'GetAppSpecWorkerResult',
    'GetAppSpecWorkerAlertResult',
    'GetAppSpecWorkerEnvResult',
    'GetAppSpecWorkerGitResult',
    'GetAppSpecWorkerGithubResult',
    'GetAppSpecWorkerGitlabResult',
    'GetAppSpecWorkerImageResult',
    'GetAppSpecWorkerImageDeployOnPushResult',
    'GetAppSpecWorkerLogDestinationResult',
    'GetAppSpecWorkerLogDestinationDatadogResult',
    'GetAppSpecWorkerLogDestinationLogtailResult',
    'GetAppSpecWorkerLogDestinationOpenSearchResult',
    'GetAppSpecWorkerLogDestinationOpenSearchBasicAuthResult',
    'GetAppSpecWorkerLogDestinationPapertrailResult',
    'GetDatabaseClusterMaintenanceWindowResult',
    'GetDatabaseUserSettingResult',
    'GetDatabaseUserSettingAclResult',
    'GetDomainsDomainResult',
    'GetDomainsFilterResult',
    'GetDomainsSortResult',
    'GetDropletsDropletResult',
    'GetDropletsFilterResult',
    'GetDropletsSortResult',
    'GetFirewallInboundRuleResult',
    'GetFirewallOutboundRuleResult',
    'GetFirewallPendingChangeResult',
    'GetImagesFilterResult',
    'GetImagesImageResult',
    'GetImagesSortResult',
    'GetKubernetesClusterKubeConfigResult',
    'GetKubernetesClusterMaintenancePolicyResult',
    'GetKubernetesClusterNodePoolResult',
    'GetKubernetesClusterNodePoolNodeResult',
    'GetKubernetesClusterNodePoolTaintResult',
    'GetLoadBalancerDomainResult',
    'GetLoadBalancerFirewallResult',
    'GetLoadBalancerForwardingRuleResult',
    'GetLoadBalancerGlbSettingResult',
    'GetLoadBalancerGlbSettingCdnResult',
    'GetLoadBalancerHealthcheckResult',
    'GetLoadBalancerStickySessionResult',
    'GetProjectsFilterResult',
    'GetProjectsProjectResult',
    'GetProjectsSortResult',
    'GetRecordsFilterResult',
    'GetRecordsRecordResult',
    'GetRecordsSortResult',
    'GetRegionsFilterResult',
    'GetRegionsRegionResult',
    'GetRegionsSortResult',
    'GetSizesFilterResult',
    'GetSizesSizeResult',
    'GetSizesSortResult',
    'GetSpacesBucketsBucketResult',
    'GetSpacesBucketsFilterResult',
    'GetSpacesBucketsSortResult',
    'GetSshKeysFilterResult',
    'GetSshKeysSortResult',
    'GetSshKeysSshKeyResult',
    'GetTagsFilterResult',
    'GetTagsSortResult',
    'GetTagsTagResult',
]

@pulumi.output_type
class AppDedicatedIp(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 ip: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str id: The ID of the app.
        :param str ip: The IP address of the dedicated egress IP.
        :param str status: The status of the dedicated egress IP: 'UNKNOWN', 'ASSIGNING', 'ASSIGNED', or 'REMOVED'
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the app.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        The IP address of the dedicated egress IP.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the dedicated egress IP: 'UNKNOWN', 'ASSIGNING', 'ASSIGNED', or 'REMOVED'
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AppSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNames":
            suggest = "domain_names"
        elif key == "staticSites":
            suggest = "static_sites"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 alerts: Optional[Sequence['outputs.AppSpecAlert']] = None,
                 databases: Optional[Sequence['outputs.AppSpecDatabase']] = None,
                 domain_names: Optional[Sequence['outputs.AppSpecDomainName']] = None,
                 domains: Optional[Sequence[str]] = None,
                 egresses: Optional[Sequence['outputs.AppSpecEgress']] = None,
                 envs: Optional[Sequence['outputs.AppSpecEnv']] = None,
                 features: Optional[Sequence[str]] = None,
                 functions: Optional[Sequence['outputs.AppSpecFunction']] = None,
                 ingress: Optional['outputs.AppSpecIngress'] = None,
                 jobs: Optional[Sequence['outputs.AppSpecJob']] = None,
                 region: Optional[str] = None,
                 services: Optional[Sequence['outputs.AppSpecService']] = None,
                 static_sites: Optional[Sequence['outputs.AppSpecStaticSite']] = None,
                 workers: Optional[Sequence['outputs.AppSpecWorker']] = None):
        """
        :param str name: The name of the component.
        :param Sequence['AppSpecAlertArgs'] alerts: Describes an alert policy for the component.
        :param Sequence['AppSpecDomainNameArgs'] domain_names: Describes a domain where the application will be made available.
        :param Sequence['AppSpecEgressArgs'] egresses: Specification for app egress configurations.
        :param Sequence['AppSpecEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param Sequence[str] features: A list of the features applied to the app. The default buildpack can be overridden here. List of available buildpacks can be found using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/reference/apps/list-buildpacks/)
        :param 'AppSpecIngressArgs' ingress: Specification for component routing, rewrites, and redirects.
        :param str region: The slug for the DigitalOcean data center region hosting the app.
        """
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if egresses is not None:
            pulumi.set(__self__, "egresses", egresses)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_sites is not None:
            pulumi.set(__self__, "static_sites", static_sites)
        if workers is not None:
            pulumi.set(__self__, "workers", workers)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.AppSpecAlert']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter
    def databases(self) -> Optional[Sequence['outputs.AppSpecDatabase']]:
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[Sequence['outputs.AppSpecDomainName']]:
        """
        Describes a domain where the application will be made available.
        """
        return pulumi.get(self, "domain_names")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute has been replaced by `domain` which supports additional functionality.""")
    def domains(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def egresses(self) -> Optional[Sequence['outputs.AppSpecEgress']]:
        """
        Specification for app egress configurations.
        """
        return pulumi.get(self, "egresses")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def features(self) -> Optional[Sequence[str]]:
        """
        A list of the features applied to the app. The default buildpack can be overridden here. List of available buildpacks can be found using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/reference/apps/list-buildpacks/)
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def functions(self) -> Optional[Sequence['outputs.AppSpecFunction']]:
        return pulumi.get(self, "functions")

    @property
    @pulumi.getter
    def ingress(self) -> Optional['outputs.AppSpecIngress']:
        """
        Specification for component routing, rewrites, and redirects.
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter
    def jobs(self) -> Optional[Sequence['outputs.AppSpecJob']]:
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The slug for the DigitalOcean data center region hosting the app.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.AppSpecService']]:
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="staticSites")
    def static_sites(self) -> Optional[Sequence['outputs.AppSpecStaticSite']]:
        return pulumi.get(self, "static_sites")

    @property
    @pulumi.getter
    def workers(self) -> Optional[Sequence['outputs.AppSpecWorker']]:
        return pulumi.get(self, "workers")


@pulumi.output_type
class AppSpecAlert(dict):
    def __init__(__self__, *,
                 rule: str,
                 disabled: Optional[bool] = None):
        """
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "rule", rule)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class AppSpecDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "dbName":
            suggest = "db_name"
        elif key == "dbUser":
            suggest = "db_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: Optional[str] = None,
                 db_name: Optional[str] = None,
                 db_user: Optional[str] = None,
                 engine: Optional[str] = None,
                 name: Optional[str] = None,
                 production: Optional[bool] = None,
                 version: Optional[str] = None):
        """
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str db_name: The name of the MySQL or PostgreSQL database to configure.
        :param str db_user: The name of the MySQL or PostgreSQL user to configure.
               
               This resource supports customized create timeouts. The default timeout is 30 minutes.
        :param str engine: The database engine to use (`MYSQL`, `PG`, `REDIS`, `MONGODB`, `KAFKA`, or `OPENSEARCH`).
        :param str name: The name of the component.
        :param bool production: Whether this is a production or dev database.
        :param str version: The version of the database engine.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if production is not None:
            pulumi.set(__self__, "production", production)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL database to configure.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL user to configure.

        This resource supports customized create timeouts. The default timeout is 30 minutes.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        """
        The database engine to use (`MYSQL`, `PG`, `REDIS`, `MONGODB`, `KAFKA`, or `OPENSEARCH`).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def production(self) -> Optional[bool]:
        """
        Whether this is a production or dev database.
        """
        return pulumi.get(self, "production")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AppSpecDomainName(dict):
    def __init__(__self__, *,
                 name: str,
                 type: Optional[str] = None,
                 wildcard: Optional[bool] = None,
                 zone: Optional[str] = None):
        """
        :param str name: The hostname for the domain.
        :param str type: The domain type, which can be one of the following:
               - `DEFAULT`: The default .ondigitalocean.app domain assigned to this app.
               - `PRIMARY`: The primary domain for this app that is displayed as the default in the control panel, used in bindable environment variables, and any other places that reference an app's live URL. Only one domain may be set as primary.
               - `ALIAS`: A non-primary domain.
        :param bool wildcard: A boolean indicating whether the domain includes all sub-domains, in addition to the given domain.
        :param str zone: If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The hostname for the domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The domain type, which can be one of the following:
        - `DEFAULT`: The default .ondigitalocean.app domain assigned to this app.
        - `PRIMARY`: The primary domain for this app that is displayed as the default in the control panel, used in bindable environment variables, and any other places that reference an app's live URL. Only one domain may be set as primary.
        - `ALIAS`: A non-primary domain.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        A boolean indicating whether the domain includes all sub-domains, in addition to the given domain.
        """
        return pulumi.get(self, "wildcard")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class AppSpecEgress(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        :param str type: The app egress type: `AUTOASSIGN`, `DEDICATED_IP`
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The app egress type: `AUTOASSIGN`, `DEDICATED_IP`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AppSpecEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecFunction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDestinations":
            suggest = "log_destinations"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 alerts: Optional[Sequence['outputs.AppSpecFunctionAlert']] = None,
                 cors: Optional['outputs.AppSpecFunctionCors'] = None,
                 envs: Optional[Sequence['outputs.AppSpecFunctionEnv']] = None,
                 git: Optional['outputs.AppSpecFunctionGit'] = None,
                 github: Optional['outputs.AppSpecFunctionGithub'] = None,
                 gitlab: Optional['outputs.AppSpecFunctionGitlab'] = None,
                 log_destinations: Optional[Sequence['outputs.AppSpecFunctionLogDestination']] = None,
                 routes: Optional[Sequence['outputs.AppSpecFunctionRoute']] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param Sequence['AppSpecFunctionAlertArgs'] alerts: Describes an alert policy for the component.
        :param 'AppSpecFunctionCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param Sequence['AppSpecFunctionEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'AppSpecFunctionGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        :param 'AppSpecFunctionGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecFunctionGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param Sequence['AppSpecFunctionLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param Sequence['AppSpecFunctionRouteArgs'] routes: An HTTP paths that should be routed to this component.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.AppSpecFunctionAlert']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level CORS rules are deprecated in favor of ingresses""")
    def cors(self) -> Optional['outputs.AppSpecFunctionCors']:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecFunctionEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecFunctionGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecFunctionGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecFunctionGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.AppSpecFunctionLogDestination']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level routes are deprecated in favor of ingresses""")
    def routes(self) -> Optional[Sequence['outputs.AppSpecFunctionRoute']]:
        """
        An HTTP paths that should be routed to this component.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecFunctionAlert(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class AppSpecFunctionCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.AppSpecFunctionCorsAllowOrigins'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
        :param 'AppSpecFunctionCorsAllowOriginsArgs' allow_origins: The set of allowed CORS origins. This configures the Access-Control-Allow-Origin header.
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.AppSpecFunctionCorsAllowOrigins']:
        """
        The set of allowed CORS origins. This configures the Access-Control-Allow-Origin header.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class AppSpecFunctionCorsAllowOrigins(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: Exact string match.
        :param str prefix: Prefix-based match.
        :param str regex: RE2 style regex-based match.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        Exact string match.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        Prefix-based match.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        RE2 style regex-based match.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class AppSpecFunctionEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecFunctionGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecFunctionGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecFunctionGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecFunctionLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openSearch":
            suggest = "open_search"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.AppSpecFunctionLogDestinationDatadog'] = None,
                 logtail: Optional['outputs.AppSpecFunctionLogDestinationLogtail'] = None,
                 open_search: Optional['outputs.AppSpecFunctionLogDestinationOpenSearch'] = None,
                 papertrail: Optional['outputs.AppSpecFunctionLogDestinationPapertrail'] = None):
        """
        :param str name: Name of the log destination. Minimum length: 2. Maximum length: 42.
        :param 'AppSpecFunctionLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'AppSpecFunctionLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'AppSpecFunctionLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'AppSpecFunctionLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the log destination. Minimum length: 2. Maximum length: 42.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.AppSpecFunctionLogDestinationDatadog']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.AppSpecFunctionLogDestinationLogtail']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.AppSpecFunctionLogDestinationOpenSearch']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.AppSpecFunctionLogDestinationPapertrail']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class AppSpecFunctionLogDestinationDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionLogDestinationDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionLogDestinationDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionLogDestinationDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: Datadog HTTP log intake endpoint.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Datadog HTTP log intake endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class AppSpecFunctionLogDestinationLogtail(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class AppSpecFunctionLogDestinationOpenSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "indexName":
            suggest = "index_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionLogDestinationOpenSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionLogDestinationOpenSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionLogDestinationOpenSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: 'outputs.AppSpecFunctionLogDestinationOpenSearchBasicAuth',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'AppSpecFunctionLogDestinationOpenSearchBasicAuthArgs' basic_auth: Basic authentication details.
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch endpoint.
        :param str index_name: OpenSearch index name.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.AppSpecFunctionLogDestinationOpenSearchBasicAuth':
        """
        Basic authentication details.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        OpenSearch index name.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class AppSpecFunctionLogDestinationOpenSearchBasicAuth(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for basic authentication.
        :param str user: user for basic authentication.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        user for basic authentication.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class AppSpecFunctionLogDestinationPapertrail(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: Papertrail syslog endpoint.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Papertrail syslog endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class AppSpecFunctionRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preservePathPrefix":
            suggest = "preserve_path_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecFunctionRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecFunctionRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecFunctionRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: Optional[str] = None,
                 preserve_path_prefix: Optional[bool] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        :param bool preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[bool]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")


@pulumi.output_type
class AppSpecIngress(dict):
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.AppSpecIngressRule']] = None):
        """
        :param Sequence['AppSpecIngressRuleArgs'] rules: Rules for configuring HTTP ingress for component routes, CORS, rewrites, and redirects.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AppSpecIngressRule']]:
        """
        Rules for configuring HTTP ingress for component routes, CORS, rewrites, and redirects.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AppSpecIngressRule(dict):
    def __init__(__self__, *,
                 component: Optional['outputs.AppSpecIngressRuleComponent'] = None,
                 cors: Optional['outputs.AppSpecIngressRuleCors'] = None,
                 match: Optional['outputs.AppSpecIngressRuleMatch'] = None,
                 redirect: Optional['outputs.AppSpecIngressRuleRedirect'] = None):
        """
        :param 'AppSpecIngressRuleComponentArgs' component: The component to route to. Only one of `component` or `redirect` may be set.
        :param 'AppSpecIngressRuleCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param 'AppSpecIngressRuleMatchArgs' match: The match configuration for the rule
        :param 'AppSpecIngressRuleRedirectArgs' redirect: The redirect configuration for the rule. Only one of `component` or `redirect` may be set.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @property
    @pulumi.getter
    def component(self) -> Optional['outputs.AppSpecIngressRuleComponent']:
        """
        The component to route to. Only one of `component` or `redirect` may be set.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def cors(self) -> Optional['outputs.AppSpecIngressRuleCors']:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def match(self) -> Optional['outputs.AppSpecIngressRuleMatch']:
        """
        The match configuration for the rule
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.AppSpecIngressRuleRedirect']:
        """
        The redirect configuration for the rule. Only one of `component` or `redirect` may be set.
        """
        return pulumi.get(self, "redirect")


@pulumi.output_type
class AppSpecIngressRuleComponent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preservePathPrefix":
            suggest = "preserve_path_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecIngressRuleComponent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecIngressRuleComponent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecIngressRuleComponent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 preserve_path_prefix: Optional[bool] = None,
                 rewrite: Optional[str] = None):
        """
        :param str name: The name of the component to route to.
        :param bool preserve_path_prefix: An optional boolean flag to preserve the path that is forwarded to the backend service. By default, the HTTP request path will be trimmed from the left when forwarded to the component.
        :param str rewrite: An optional field that will rewrite the path of the component to be what is specified here. This is mutually exclusive with `preserve_path_prefix`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)
        if rewrite is not None:
            pulumi.set(__self__, "rewrite", rewrite)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the component to route to.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[bool]:
        """
        An optional boolean flag to preserve the path that is forwarded to the backend service. By default, the HTTP request path will be trimmed from the left when forwarded to the component.
        """
        return pulumi.get(self, "preserve_path_prefix")

    @property
    @pulumi.getter
    def rewrite(self) -> Optional[str]:
        """
        An optional field that will rewrite the path of the component to be what is specified here. This is mutually exclusive with `preserve_path_prefix`.
        """
        return pulumi.get(self, "rewrite")


@pulumi.output_type
class AppSpecIngressRuleCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecIngressRuleCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecIngressRuleCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecIngressRuleCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.AppSpecIngressRuleCorsAllowOrigins'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        :param 'AppSpecIngressRuleCorsAllowOriginsArgs' allow_origins: The `Access-Control-Allow-Origin` can be
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.AppSpecIngressRuleCorsAllowOrigins']:
        """
        The `Access-Control-Allow-Origin` can be
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class AppSpecIngressRuleCorsAllowOrigins(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        :param str prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        :param str regex: The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class AppSpecIngressRuleMatch(dict):
    def __init__(__self__, *,
                 path: Optional['outputs.AppSpecIngressRuleMatchPath'] = None):
        """
        :param 'AppSpecIngressRuleMatchPathArgs' path: The path to match on.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional['outputs.AppSpecIngressRuleMatchPath']:
        """
        The path to match on.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class AppSpecIngressRuleMatchPath(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None):
        """
        :param str prefix: Prefix-based match.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix-based match.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class AppSpecIngressRuleRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectCode":
            suggest = "redirect_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecIngressRuleRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecIngressRuleRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecIngressRuleRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority: Optional[str] = None,
                 port: Optional[int] = None,
                 redirect_code: Optional[int] = None,
                 scheme: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str authority: The authority/host to redirect to. This can be a hostname or IP address.
        :param int port: The port to redirect to.
        :param int redirect_code: The redirect code to use. Supported values are `300`, `301`, `302`, `303`, `304`, `307`, `308`.
        :param str scheme: The scheme to redirect to. Supported values are `http` or `https`
        :param str uri: An optional URI path to redirect to.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if redirect_code is not None:
            pulumi.set(__self__, "redirect_code", redirect_code)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def authority(self) -> Optional[str]:
        """
        The authority/host to redirect to. This can be a hostname or IP address.
        """
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port to redirect to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="redirectCode")
    def redirect_code(self) -> Optional[int]:
        """
        The redirect code to use. Supported values are `300`, `301`, `302`, `303`, `304`, `307`, `308`.
        """
        return pulumi.get(self, "redirect_code")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[str]:
        """
        The scheme to redirect to. Supported values are `http` or `https`
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        An optional URI path to redirect to.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class AppSpecJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSizeSlug":
            suggest = "instance_size_slug"
        elif key == "logDestinations":
            suggest = "log_destinations"
        elif key == "runCommand":
            suggest = "run_command"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 alerts: Optional[Sequence['outputs.AppSpecJobAlert']] = None,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecJobEnv']] = None,
                 git: Optional['outputs.AppSpecJobGit'] = None,
                 github: Optional['outputs.AppSpecJobGithub'] = None,
                 gitlab: Optional['outputs.AppSpecJobGitlab'] = None,
                 image: Optional['outputs.AppSpecJobImage'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 kind: Optional[str] = None,
                 log_destinations: Optional[Sequence['outputs.AppSpecJobLogDestination']] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param Sequence['AppSpecJobAlertArgs'] alerts: Describes an alert policy for the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecJobEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'AppSpecJobGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        :param 'AppSpecJobGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecJobGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecJobImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        :param str kind: The type of job and when it will be run during the deployment process. It may be one of:
               - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
               - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
               - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
               - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        :param Sequence['AppSpecJobLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.AppSpecJobAlert']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecJobEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecJobGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecJobGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecJobGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.AppSpecJobImage']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        The type of job and when it will be run during the deployment process. It may be one of:
        - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
        - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
        - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
        - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.AppSpecJobLogDestination']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecJobAlert(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class AppSpecJobEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecJobGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecJobGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecJobGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecJobImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryType":
            suggest = "registry_type"
        elif key == "deployOnPushes":
            suggest = "deploy_on_pushes"
        elif key == "registryCredentials":
            suggest = "registry_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 deploy_on_pushes: Optional[Sequence['outputs.AppSpecJobImageDeployOnPush']] = None,
                 registry: Optional[str] = None,
                 registry_credentials: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param Sequence['AppSpecJobImageDeployOnPushArgs'] deploy_on_pushes: Configures automatically deploying images pushed to DOCR.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str registry_credentials: The credentials required to access a private Docker Hub or GitHub registry, in the following syntax `<username>:<token>`.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if deploy_on_pushes is not None:
            pulumi.set(__self__, "deploy_on_pushes", deploy_on_pushes)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if registry_credentials is not None:
            pulumi.set(__self__, "registry_credentials", registry_credentials)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="deployOnPushes")
    def deploy_on_pushes(self) -> Optional[Sequence['outputs.AppSpecJobImageDeployOnPush']]:
        """
        Configures automatically deploying images pushed to DOCR.
        """
        return pulumi.get(self, "deploy_on_pushes")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="registryCredentials")
    def registry_credentials(self) -> Optional[str]:
        """
        The credentials required to access a private Docker Hub or GitHub registry, in the following syntax `<username>:<token>`.
        """
        return pulumi.get(self, "registry_credentials")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class AppSpecJobImageDeployOnPush(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether to automatically deploy images pushed to DOCR.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether to automatically deploy images pushed to DOCR.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AppSpecJobLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openSearch":
            suggest = "open_search"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.AppSpecJobLogDestinationDatadog'] = None,
                 logtail: Optional['outputs.AppSpecJobLogDestinationLogtail'] = None,
                 open_search: Optional['outputs.AppSpecJobLogDestinationOpenSearch'] = None,
                 papertrail: Optional['outputs.AppSpecJobLogDestinationPapertrail'] = None):
        """
        :param str name: Name of the log destination. Minimum length: 2. Maximum length: 42.
        :param 'AppSpecJobLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'AppSpecJobLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'AppSpecJobLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'AppSpecJobLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the log destination. Minimum length: 2. Maximum length: 42.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.AppSpecJobLogDestinationDatadog']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.AppSpecJobLogDestinationLogtail']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.AppSpecJobLogDestinationOpenSearch']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.AppSpecJobLogDestinationPapertrail']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class AppSpecJobLogDestinationDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobLogDestinationDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobLogDestinationDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobLogDestinationDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: Datadog HTTP log intake endpoint.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Datadog HTTP log intake endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class AppSpecJobLogDestinationLogtail(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class AppSpecJobLogDestinationOpenSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "indexName":
            suggest = "index_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobLogDestinationOpenSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobLogDestinationOpenSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobLogDestinationOpenSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: 'outputs.AppSpecJobLogDestinationOpenSearchBasicAuth',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'AppSpecJobLogDestinationOpenSearchBasicAuthArgs' basic_auth: Basic authentication details.
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch endpoint.
        :param str index_name: OpenSearch index name.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.AppSpecJobLogDestinationOpenSearchBasicAuth':
        """
        Basic authentication details.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        OpenSearch index name.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class AppSpecJobLogDestinationOpenSearchBasicAuth(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for basic authentication.
        :param str user: user for basic authentication.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        user for basic authentication.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class AppSpecJobLogDestinationPapertrail(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: Papertrail syslog endpoint.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Papertrail syslog endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class AppSpecService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "healthCheck":
            suggest = "health_check"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSizeSlug":
            suggest = "instance_size_slug"
        elif key == "internalPorts":
            suggest = "internal_ports"
        elif key == "logDestinations":
            suggest = "log_destinations"
        elif key == "runCommand":
            suggest = "run_command"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 alerts: Optional[Sequence['outputs.AppSpecServiceAlert']] = None,
                 autoscaling: Optional['outputs.AppSpecServiceAutoscaling'] = None,
                 build_command: Optional[str] = None,
                 cors: Optional['outputs.AppSpecServiceCors'] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecServiceEnv']] = None,
                 git: Optional['outputs.AppSpecServiceGit'] = None,
                 github: Optional['outputs.AppSpecServiceGithub'] = None,
                 gitlab: Optional['outputs.AppSpecServiceGitlab'] = None,
                 health_check: Optional['outputs.AppSpecServiceHealthCheck'] = None,
                 http_port: Optional[int] = None,
                 image: Optional['outputs.AppSpecServiceImage'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 internal_ports: Optional[Sequence[int]] = None,
                 log_destinations: Optional[Sequence['outputs.AppSpecServiceLogDestination']] = None,
                 routes: Optional[Sequence['outputs.AppSpecServiceRoute']] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param Sequence['AppSpecServiceAlertArgs'] alerts: Describes an alert policy for the component.
        :param 'AppSpecServiceAutoscalingArgs' autoscaling: Configuration for automatically scaling this component based on metrics.
        :param str build_command: An optional build command to run while building this component from source.
        :param 'AppSpecServiceCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecServiceEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'AppSpecServiceGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        :param 'AppSpecServiceGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecServiceGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecServiceHealthCheckArgs' health_check: A health check to determine the availability of this component.
        :param int http_port: The internal port on which this service's run command will listen.
        :param 'AppSpecServiceImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        :param Sequence[int] internal_ports: A list of ports on which this service will listen for internal traffic.
        :param Sequence['AppSpecServiceLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param Sequence['AppSpecServiceRouteArgs'] routes: An HTTP paths that should be routed to this component.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if internal_ports is not None:
            pulumi.set(__self__, "internal_ports", internal_ports)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.AppSpecServiceAlert']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional['outputs.AppSpecServiceAutoscaling']:
        """
        Configuration for automatically scaling this component based on metrics.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level CORS rules are deprecated in favor of ingresses""")
    def cors(self) -> Optional['outputs.AppSpecServiceCors']:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecServiceEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecServiceGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecServiceGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecServiceGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.AppSpecServiceHealthCheck']:
        """
        A health check to determine the availability of this component.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        """
        The internal port on which this service's run command will listen.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.AppSpecServiceImage']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="internalPorts")
    def internal_ports(self) -> Optional[Sequence[int]]:
        """
        A list of ports on which this service will listen for internal traffic.
        """
        return pulumi.get(self, "internal_ports")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.AppSpecServiceLogDestination']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level routes are deprecated in favor of ingresses""")
    def routes(self) -> Optional[Sequence['outputs.AppSpecServiceRoute']]:
        """
        An HTTP paths that should be routed to this component.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecServiceAlert(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class AppSpecServiceAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: int,
                 metrics: 'outputs.AppSpecServiceAutoscalingMetrics',
                 min_instance_count: int):
        """
        :param int max_instance_count: The maximum amount of instances for this component. Must be more than min_instance_count.
        :param 'AppSpecServiceAutoscalingMetricsArgs' metrics: The metrics that the component is scaled on.
        :param int min_instance_count: The minimum amount of instances for this component. Must be less than max_instance_count.
        """
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> int:
        """
        The maximum amount of instances for this component. Must be more than min_instance_count.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter
    def metrics(self) -> 'outputs.AppSpecServiceAutoscalingMetrics':
        """
        The metrics that the component is scaled on.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> int:
        """
        The minimum amount of instances for this component. Must be less than max_instance_count.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class AppSpecServiceAutoscalingMetrics(dict):
    def __init__(__self__, *,
                 cpu: Optional['outputs.AppSpecServiceAutoscalingMetricsCpu'] = None):
        """
        :param 'AppSpecServiceAutoscalingMetricsCpuArgs' cpu: Settings for scaling the component based on CPU utilization.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)

    @property
    @pulumi.getter
    def cpu(self) -> Optional['outputs.AppSpecServiceAutoscalingMetricsCpu']:
        """
        Settings for scaling the component based on CPU utilization.
        """
        return pulumi.get(self, "cpu")


@pulumi.output_type
class AppSpecServiceAutoscalingMetricsCpu(dict):
    def __init__(__self__, *,
                 percent: int):
        """
        :param int percent: The average target CPU utilization for the component.
               
               A `static_site` can contain:
        """
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        The average target CPU utilization for the component.

        A `static_site` can contain:
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AppSpecServiceCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.AppSpecServiceCorsAllowOrigins'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
        :param 'AppSpecServiceCorsAllowOriginsArgs' allow_origins: The set of allowed CORS origins. This configures the Access-Control-Allow-Origin header.
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.AppSpecServiceCorsAllowOrigins']:
        """
        The set of allowed CORS origins. This configures the Access-Control-Allow-Origin header.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class AppSpecServiceCorsAllowOrigins(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: Exact string match.
        :param str prefix: Prefix-based match.
        :param str regex: RE2 style regex-based match.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        Exact string match.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        Prefix-based match.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        RE2 style regex-based match.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class AppSpecServiceEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecServiceGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecServiceGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecServiceGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecServiceHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpPath":
            suggest = "http_path"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_path: Optional[str] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 port: Optional[int] = None,
                 success_threshold: Optional[int] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: The number of failed health checks before considered unhealthy.
        :param str http_path: The route path used for the HTTP health check ping.
        :param int initial_delay_seconds: The number of seconds to wait before beginning health checks.
        :param int period_seconds: The number of seconds to wait between health checks.
        :param int port: The health check will be performed on this port instead of component's HTTP port.
        :param int success_threshold: The number of successful health checks before considered healthy.
        :param int timeout_seconds: The number of seconds after which the check times out.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failed health checks before considered unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[str]:
        """
        The route path used for the HTTP health check ping.
        """
        return pulumi.get(self, "http_path")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait before beginning health checks.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait between health checks.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The health check will be performed on this port instead of component's HTTP port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful health checks before considered healthy.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        The number of seconds after which the check times out.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class AppSpecServiceImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryType":
            suggest = "registry_type"
        elif key == "deployOnPushes":
            suggest = "deploy_on_pushes"
        elif key == "registryCredentials":
            suggest = "registry_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 deploy_on_pushes: Optional[Sequence['outputs.AppSpecServiceImageDeployOnPush']] = None,
                 registry: Optional[str] = None,
                 registry_credentials: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param Sequence['AppSpecServiceImageDeployOnPushArgs'] deploy_on_pushes: Configures automatically deploying images pushed to DOCR.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str registry_credentials: The credentials required to access a private Docker Hub or GitHub registry, in the following syntax `<username>:<token>`.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if deploy_on_pushes is not None:
            pulumi.set(__self__, "deploy_on_pushes", deploy_on_pushes)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if registry_credentials is not None:
            pulumi.set(__self__, "registry_credentials", registry_credentials)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="deployOnPushes")
    def deploy_on_pushes(self) -> Optional[Sequence['outputs.AppSpecServiceImageDeployOnPush']]:
        """
        Configures automatically deploying images pushed to DOCR.
        """
        return pulumi.get(self, "deploy_on_pushes")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="registryCredentials")
    def registry_credentials(self) -> Optional[str]:
        """
        The credentials required to access a private Docker Hub or GitHub registry, in the following syntax `<username>:<token>`.
        """
        return pulumi.get(self, "registry_credentials")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class AppSpecServiceImageDeployOnPush(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether to automatically deploy images pushed to DOCR.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether to automatically deploy images pushed to DOCR.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AppSpecServiceLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openSearch":
            suggest = "open_search"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.AppSpecServiceLogDestinationDatadog'] = None,
                 logtail: Optional['outputs.AppSpecServiceLogDestinationLogtail'] = None,
                 open_search: Optional['outputs.AppSpecServiceLogDestinationOpenSearch'] = None,
                 papertrail: Optional['outputs.AppSpecServiceLogDestinationPapertrail'] = None):
        """
        :param str name: Name of the log destination. Minimum length: 2. Maximum length: 42.
        :param 'AppSpecServiceLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'AppSpecServiceLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'AppSpecServiceLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'AppSpecServiceLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the log destination. Minimum length: 2. Maximum length: 42.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.AppSpecServiceLogDestinationDatadog']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.AppSpecServiceLogDestinationLogtail']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.AppSpecServiceLogDestinationOpenSearch']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.AppSpecServiceLogDestinationPapertrail']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class AppSpecServiceLogDestinationDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceLogDestinationDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceLogDestinationDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceLogDestinationDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: Datadog HTTP log intake endpoint.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Datadog HTTP log intake endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class AppSpecServiceLogDestinationLogtail(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class AppSpecServiceLogDestinationOpenSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "indexName":
            suggest = "index_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceLogDestinationOpenSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceLogDestinationOpenSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceLogDestinationOpenSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: 'outputs.AppSpecServiceLogDestinationOpenSearchBasicAuth',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'AppSpecServiceLogDestinationOpenSearchBasicAuthArgs' basic_auth: Basic authentication details.
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch endpoint.
        :param str index_name: OpenSearch index name.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.AppSpecServiceLogDestinationOpenSearchBasicAuth':
        """
        Basic authentication details.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        OpenSearch index name.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class AppSpecServiceLogDestinationOpenSearchBasicAuth(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for basic authentication.
        :param str user: user for basic authentication.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        user for basic authentication.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class AppSpecServiceLogDestinationPapertrail(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: Papertrail syslog endpoint.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Papertrail syslog endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class AppSpecServiceRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preservePathPrefix":
            suggest = "preserve_path_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: Optional[str] = None,
                 preserve_path_prefix: Optional[bool] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        :param bool preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[bool]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")


@pulumi.output_type
class AppSpecStaticSite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "catchallDocument":
            suggest = "catchall_document"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "outputDir":
            suggest = "output_dir"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 build_command: Optional[str] = None,
                 catchall_document: Optional[str] = None,
                 cors: Optional['outputs.AppSpecStaticSiteCors'] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecStaticSiteEnv']] = None,
                 error_document: Optional[str] = None,
                 git: Optional['outputs.AppSpecStaticSiteGit'] = None,
                 github: Optional['outputs.AppSpecStaticSiteGithub'] = None,
                 gitlab: Optional['outputs.AppSpecStaticSiteGitlab'] = None,
                 index_document: Optional[str] = None,
                 output_dir: Optional[str] = None,
                 routes: Optional[Sequence['outputs.AppSpecStaticSiteRoute']] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str catchall_document: The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        :param 'AppSpecStaticSiteCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecStaticSiteEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param str error_document: The name of the error document to use when serving this static site.
        :param 'AppSpecStaticSiteGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        :param 'AppSpecStaticSiteGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecStaticSiteGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param str index_document: The name of the index document to use when serving this static site.
        :param str output_dir: An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        :param Sequence['AppSpecStaticSiteRouteArgs'] routes: An HTTP paths that should be routed to this component.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if catchall_document is not None:
            pulumi.set(__self__, "catchall_document", catchall_document)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if output_dir is not None:
            pulumi.set(__self__, "output_dir", output_dir)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="catchallDocument")
    def catchall_document(self) -> Optional[str]:
        """
        The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        """
        return pulumi.get(self, "catchall_document")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level CORS rules are deprecated in favor of ingresses""")
    def cors(self) -> Optional['outputs.AppSpecStaticSiteCors']:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecStaticSiteEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        The name of the error document to use when serving this static site.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecStaticSiteGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecStaticSiteGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecStaticSiteGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        The name of the index document to use when serving this static site.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="outputDir")
    def output_dir(self) -> Optional[str]:
        """
        An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        """
        return pulumi.get(self, "output_dir")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level routes are deprecated in favor of ingresses""")
    def routes(self) -> Optional[Sequence['outputs.AppSpecStaticSiteRoute']]:
        """
        An HTTP paths that should be routed to this component.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecStaticSiteCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.AppSpecStaticSiteCorsAllowOrigins'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
        :param 'AppSpecStaticSiteCorsAllowOriginsArgs' allow_origins: The set of allowed CORS origins. This configures the Access-Control-Allow-Origin header.
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request’s credentials mode is `include`. This configures the Access-Control-Allow-Credentials header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the Access-Control-Allow-Headers header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the Access-Control-Allow-Methods header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.AppSpecStaticSiteCorsAllowOrigins']:
        """
        The set of allowed CORS origins. This configures the Access-Control-Allow-Origin header.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the Access-Control-Expose-Headers header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class AppSpecStaticSiteCorsAllowOrigins(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: Exact string match.
        :param str prefix: Prefix-based match.
        :param str regex: RE2 style regex-based match.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        Exact string match.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        Prefix-based match.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        RE2 style regex-based match.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class AppSpecStaticSiteEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecStaticSiteGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecStaticSiteGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecStaticSiteGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecStaticSiteRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preservePathPrefix":
            suggest = "preserve_path_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: Optional[str] = None,
                 preserve_path_prefix: Optional[bool] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        :param bool preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[bool]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")


@pulumi.output_type
class AppSpecWorker(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSizeSlug":
            suggest = "instance_size_slug"
        elif key == "logDestinations":
            suggest = "log_destinations"
        elif key == "runCommand":
            suggest = "run_command"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 alerts: Optional[Sequence['outputs.AppSpecWorkerAlert']] = None,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecWorkerEnv']] = None,
                 git: Optional['outputs.AppSpecWorkerGit'] = None,
                 github: Optional['outputs.AppSpecWorkerGithub'] = None,
                 gitlab: Optional['outputs.AppSpecWorkerGitlab'] = None,
                 image: Optional['outputs.AppSpecWorkerImage'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 log_destinations: Optional[Sequence['outputs.AppSpecWorkerLogDestination']] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param Sequence['AppSpecWorkerAlertArgs'] alerts: Describes an alert policy for the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecWorkerEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'AppSpecWorkerGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        :param 'AppSpecWorkerGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecWorkerGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecWorkerImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        :param Sequence['AppSpecWorkerLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.AppSpecWorkerAlert']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecWorkerEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecWorkerGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication. Only one of `git`, `github` or `gitlab` may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecWorkerGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecWorkerGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.AppSpecWorkerImage']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.AppSpecWorkerLogDestination']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecWorkerAlert(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class AppSpecWorkerEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecWorkerGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecWorkerGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecWorkerGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecWorkerImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryType":
            suggest = "registry_type"
        elif key == "deployOnPushes":
            suggest = "deploy_on_pushes"
        elif key == "registryCredentials":
            suggest = "registry_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 deploy_on_pushes: Optional[Sequence['outputs.AppSpecWorkerImageDeployOnPush']] = None,
                 registry: Optional[str] = None,
                 registry_credentials: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param Sequence['AppSpecWorkerImageDeployOnPushArgs'] deploy_on_pushes: Configures automatically deploying images pushed to DOCR.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str registry_credentials: The credentials required to access a private Docker Hub or GitHub registry, in the following syntax `<username>:<token>`.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if deploy_on_pushes is not None:
            pulumi.set(__self__, "deploy_on_pushes", deploy_on_pushes)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if registry_credentials is not None:
            pulumi.set(__self__, "registry_credentials", registry_credentials)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="deployOnPushes")
    def deploy_on_pushes(self) -> Optional[Sequence['outputs.AppSpecWorkerImageDeployOnPush']]:
        """
        Configures automatically deploying images pushed to DOCR.
        """
        return pulumi.get(self, "deploy_on_pushes")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="registryCredentials")
    def registry_credentials(self) -> Optional[str]:
        """
        The credentials required to access a private Docker Hub or GitHub registry, in the following syntax `<username>:<token>`.
        """
        return pulumi.get(self, "registry_credentials")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class AppSpecWorkerImageDeployOnPush(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether to automatically deploy images pushed to DOCR.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether to automatically deploy images pushed to DOCR.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AppSpecWorkerLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openSearch":
            suggest = "open_search"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.AppSpecWorkerLogDestinationDatadog'] = None,
                 logtail: Optional['outputs.AppSpecWorkerLogDestinationLogtail'] = None,
                 open_search: Optional['outputs.AppSpecWorkerLogDestinationOpenSearch'] = None,
                 papertrail: Optional['outputs.AppSpecWorkerLogDestinationPapertrail'] = None):
        """
        :param str name: Name of the log destination. Minimum length: 2. Maximum length: 42.
        :param 'AppSpecWorkerLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'AppSpecWorkerLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'AppSpecWorkerLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'AppSpecWorkerLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the log destination. Minimum length: 2. Maximum length: 42.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.AppSpecWorkerLogDestinationDatadog']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.AppSpecWorkerLogDestinationLogtail']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.AppSpecWorkerLogDestinationOpenSearch']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.AppSpecWorkerLogDestinationPapertrail']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class AppSpecWorkerLogDestinationDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerLogDestinationDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerLogDestinationDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerLogDestinationDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: Datadog HTTP log intake endpoint.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Datadog HTTP log intake endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class AppSpecWorkerLogDestinationLogtail(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class AppSpecWorkerLogDestinationOpenSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "indexName":
            suggest = "index_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerLogDestinationOpenSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerLogDestinationOpenSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerLogDestinationOpenSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: 'outputs.AppSpecWorkerLogDestinationOpenSearchBasicAuth',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'AppSpecWorkerLogDestinationOpenSearchBasicAuthArgs' basic_auth: Basic authentication details.
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch endpoint.
        :param str index_name: OpenSearch index name.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.AppSpecWorkerLogDestinationOpenSearchBasicAuth':
        """
        Basic authentication details.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        OpenSearch index name.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class AppSpecWorkerLogDestinationOpenSearchBasicAuth(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for basic authentication.
        :param str user: user for basic authentication.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        user for basic authentication.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class AppSpecWorkerLogDestinationPapertrail(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: Papertrail syslog endpoint.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Papertrail syslog endpoint.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DatabaseClusterBackupRestore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "backupCreatedAt":
            suggest = "backup_created_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseClusterBackupRestore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseClusterBackupRestore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseClusterBackupRestore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 backup_created_at: Optional[str] = None):
        """
        :param str database_name: The name of an existing database cluster from which the backup will be restored.
        :param str backup_created_at: The timestamp of an existing database cluster backup in ISO8601 combined date and time format. The most recent backup will be used if excluded.
               
               This resource supports customized create timeouts. The default timeout is 30 minutes.
        """
        pulumi.set(__self__, "database_name", database_name)
        if backup_created_at is not None:
            pulumi.set(__self__, "backup_created_at", backup_created_at)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of an existing database cluster from which the backup will be restored.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="backupCreatedAt")
    def backup_created_at(self) -> Optional[str]:
        """
        The timestamp of an existing database cluster backup in ISO8601 combined date and time format. The most recent backup will be used if excluded.

        This resource supports customized create timeouts. The default timeout is 30 minutes.
        """
        return pulumi.get(self, "backup_created_at")


@pulumi.output_type
class DatabaseClusterMaintenanceWindow(dict):
    def __init__(__self__, *,
                 day: str,
                 hour: str):
        """
        :param str day: The day of the week on which to apply maintenance updates.
        :param str hour: The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        The day of the week on which to apply maintenance updates.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> str:
        """
        The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        return pulumi.get(self, "hour")


@pulumi.output_type
class DatabaseFirewallRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseFirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseFirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseFirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 value: str,
                 created_at: Optional[str] = None,
                 uuid: Optional[str] = None):
        """
        :param str type: The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, `tag`, or `app`.
        :param str value: The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.
        :param str created_at: The date and time when the firewall rule was created.
        :param str uuid: A unique identifier for the firewall rule.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, `tag`, or `app`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time when the firewall rule was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        A unique identifier for the firewall rule.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class DatabaseKafkaTopicConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cleanupPolicy":
            suggest = "cleanup_policy"
        elif key == "compressionType":
            suggest = "compression_type"
        elif key == "deleteRetentionMs":
            suggest = "delete_retention_ms"
        elif key == "fileDeleteDelayMs":
            suggest = "file_delete_delay_ms"
        elif key == "flushMessages":
            suggest = "flush_messages"
        elif key == "flushMs":
            suggest = "flush_ms"
        elif key == "indexIntervalBytes":
            suggest = "index_interval_bytes"
        elif key == "maxCompactionLagMs":
            suggest = "max_compaction_lag_ms"
        elif key == "maxMessageBytes":
            suggest = "max_message_bytes"
        elif key == "messageDownConversionEnable":
            suggest = "message_down_conversion_enable"
        elif key == "messageFormatVersion":
            suggest = "message_format_version"
        elif key == "messageTimestampDifferenceMaxMs":
            suggest = "message_timestamp_difference_max_ms"
        elif key == "messageTimestampType":
            suggest = "message_timestamp_type"
        elif key == "minCleanableDirtyRatio":
            suggest = "min_cleanable_dirty_ratio"
        elif key == "minCompactionLagMs":
            suggest = "min_compaction_lag_ms"
        elif key == "minInsyncReplicas":
            suggest = "min_insync_replicas"
        elif key == "retentionBytes":
            suggest = "retention_bytes"
        elif key == "retentionMs":
            suggest = "retention_ms"
        elif key == "segmentBytes":
            suggest = "segment_bytes"
        elif key == "segmentIndexBytes":
            suggest = "segment_index_bytes"
        elif key == "segmentJitterMs":
            suggest = "segment_jitter_ms"
        elif key == "segmentMs":
            suggest = "segment_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseKafkaTopicConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseKafkaTopicConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseKafkaTopicConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cleanup_policy: Optional[str] = None,
                 compression_type: Optional[str] = None,
                 delete_retention_ms: Optional[str] = None,
                 file_delete_delay_ms: Optional[str] = None,
                 flush_messages: Optional[str] = None,
                 flush_ms: Optional[str] = None,
                 index_interval_bytes: Optional[str] = None,
                 max_compaction_lag_ms: Optional[str] = None,
                 max_message_bytes: Optional[str] = None,
                 message_down_conversion_enable: Optional[bool] = None,
                 message_format_version: Optional[str] = None,
                 message_timestamp_difference_max_ms: Optional[str] = None,
                 message_timestamp_type: Optional[str] = None,
                 min_cleanable_dirty_ratio: Optional[float] = None,
                 min_compaction_lag_ms: Optional[str] = None,
                 min_insync_replicas: Optional[int] = None,
                 preallocate: Optional[bool] = None,
                 retention_bytes: Optional[str] = None,
                 retention_ms: Optional[str] = None,
                 segment_bytes: Optional[str] = None,
                 segment_index_bytes: Optional[str] = None,
                 segment_jitter_ms: Optional[str] = None,
                 segment_ms: Optional[str] = None):
        """
        :param str cleanup_policy: The topic cleanup policy that describes whether messages should be deleted, compacted, or both when retention policies are violated.
               This may be one of "delete", "compact", or "compact_delete".
        :param str compression_type: The topic compression codecs used for a given topic.
               This may be one of "uncompressed", "gzip", "snappy", "lz4", "producer", "zstd". "uncompressed" indicates that there is no compression and "producer" retains the original compression codec set by the producer.
        :param str delete_retention_ms: The amount of time, in ms, that deleted records are retained.
        :param str file_delete_delay_ms: The amount of time, in ms, to wait before deleting a topic log segment from the filesystem.
        :param str flush_messages: The number of messages accumulated on a topic partition before they are flushed to disk.
        :param str flush_ms: The maximum time, in ms, that a topic is kept in memory before being flushed to disk.
        :param str index_interval_bytes: The interval, in bytes, in which entries are added to the offset index.
        :param str max_compaction_lag_ms: The maximum time, in ms, that a particular message will remain uncompacted. This will not apply if the `compression_type` is set to "uncompressed" or it is set to `producer` and the producer is not using compression.
        :param str max_message_bytes: The maximum size, in bytes, of a message.
        :param bool message_down_conversion_enable: Determines whether down-conversion of message formats for consumers is enabled.
        :param str message_format_version: The version of the inter-broker protocol that will be used. This may be one of "0.8.0", "0.8.1", "0.8.2", "0.9.0", "0.10.0", "0.10.0-IV0", "0.10.0-IV1", "0.10.1", "0.10.1-IV0", "0.10.1-IV1", "0.10.1-IV2", "0.10.2", "0.10.2-IV0", "0.11.0", "0.11.0-IV0", "0.11.0-IV1", "0.11.0-IV2", "1.0", "1.0-IV0", "1.1", "1.1-IV0", "2.0", "2.0-IV0", "2.0-IV1", "2.1", "2.1-IV0", "2.1-IV1", "2.1-IV2", "2.2", "2.2-IV0", "2.2-IV1", "2.3", "2.3-IV0", "2.3-IV1", "2.4", "2.4-IV0", "2.4-IV1", "2.5", "2.5-IV0", "2.6", "2.6-IV0", "2.7", "2.7-IV0", "2.7-IV1", "2.7-IV2", "2.8", "2.8-IV0", "2.8-IV1", "3.0", "3.0-IV0", "3.0-IV1", "3.1", "3.1-IV0", "3.2", "3.2-IV0", "3.3", "3.3-IV0", "3.3-IV1", "3.3-IV2", "3.3-IV3", "3.4", "3.4-IV0", "3.5", "3.5-IV0", "3.5-IV1", "3.5-IV2", "3.6", "3.6-IV0", "3.6-IV1", "3.6-IV2".
        :param str message_timestamp_difference_max_ms: The maximum difference, in ms, between the timestamp specific in a message and when the broker receives the message.
        :param str message_timestamp_type: Specifies which timestamp to use for the message. This may be one of "create_time" or "log_append_time".
        :param float min_cleanable_dirty_ratio: A scale between 0.0 and 1.0 which controls the frequency of the compactor. Larger values mean more frequent compactions. This is often paired with `max_compaction_lag_ms` to control the compactor frequency.
        :param int min_insync_replicas: The number of replicas that must acknowledge a write before it is considered successful. -1 is a special setting to indicate that all nodes must ack a message before a write is considered successful. Default is 1, indicating at least 1 replica must acknowledge a write to be considered successful.
        :param bool preallocate: Determines whether to preallocate a file on disk when creating a new log segment within a topic.
        :param str retention_bytes: The maximum size, in bytes, of a topic before messages are deleted. -1 is a special setting indicating that this setting has no limit.
        :param str retention_ms: The maximum time, in ms, that a topic log file is retained before deleting it. -1 is a special setting indicating that this setting has no limit.
        :param str segment_bytes: The maximum size, in bytes, of a single topic log file.
        :param str segment_index_bytes: The maximum size, in bytes, of the offset index.
        :param str segment_jitter_ms: The maximum time, in ms, subtracted from the scheduled segment disk flush time to avoid the thundering herd problem for segment flushing.
        :param str segment_ms: The maximum time, in ms, before the topic log will flush to disk.
        """
        if cleanup_policy is not None:
            pulumi.set(__self__, "cleanup_policy", cleanup_policy)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if delete_retention_ms is not None:
            pulumi.set(__self__, "delete_retention_ms", delete_retention_ms)
        if file_delete_delay_ms is not None:
            pulumi.set(__self__, "file_delete_delay_ms", file_delete_delay_ms)
        if flush_messages is not None:
            pulumi.set(__self__, "flush_messages", flush_messages)
        if flush_ms is not None:
            pulumi.set(__self__, "flush_ms", flush_ms)
        if index_interval_bytes is not None:
            pulumi.set(__self__, "index_interval_bytes", index_interval_bytes)
        if max_compaction_lag_ms is not None:
            pulumi.set(__self__, "max_compaction_lag_ms", max_compaction_lag_ms)
        if max_message_bytes is not None:
            pulumi.set(__self__, "max_message_bytes", max_message_bytes)
        if message_down_conversion_enable is not None:
            pulumi.set(__self__, "message_down_conversion_enable", message_down_conversion_enable)
        if message_format_version is not None:
            pulumi.set(__self__, "message_format_version", message_format_version)
        if message_timestamp_difference_max_ms is not None:
            pulumi.set(__self__, "message_timestamp_difference_max_ms", message_timestamp_difference_max_ms)
        if message_timestamp_type is not None:
            pulumi.set(__self__, "message_timestamp_type", message_timestamp_type)
        if min_cleanable_dirty_ratio is not None:
            pulumi.set(__self__, "min_cleanable_dirty_ratio", min_cleanable_dirty_ratio)
        if min_compaction_lag_ms is not None:
            pulumi.set(__self__, "min_compaction_lag_ms", min_compaction_lag_ms)
        if min_insync_replicas is not None:
            pulumi.set(__self__, "min_insync_replicas", min_insync_replicas)
        if preallocate is not None:
            pulumi.set(__self__, "preallocate", preallocate)
        if retention_bytes is not None:
            pulumi.set(__self__, "retention_bytes", retention_bytes)
        if retention_ms is not None:
            pulumi.set(__self__, "retention_ms", retention_ms)
        if segment_bytes is not None:
            pulumi.set(__self__, "segment_bytes", segment_bytes)
        if segment_index_bytes is not None:
            pulumi.set(__self__, "segment_index_bytes", segment_index_bytes)
        if segment_jitter_ms is not None:
            pulumi.set(__self__, "segment_jitter_ms", segment_jitter_ms)
        if segment_ms is not None:
            pulumi.set(__self__, "segment_ms", segment_ms)

    @property
    @pulumi.getter(name="cleanupPolicy")
    def cleanup_policy(self) -> Optional[str]:
        """
        The topic cleanup policy that describes whether messages should be deleted, compacted, or both when retention policies are violated.
        This may be one of "delete", "compact", or "compact_delete".
        """
        return pulumi.get(self, "cleanup_policy")

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional[str]:
        """
        The topic compression codecs used for a given topic.
        This may be one of "uncompressed", "gzip", "snappy", "lz4", "producer", "zstd". "uncompressed" indicates that there is no compression and "producer" retains the original compression codec set by the producer.
        """
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="deleteRetentionMs")
    def delete_retention_ms(self) -> Optional[str]:
        """
        The amount of time, in ms, that deleted records are retained.
        """
        return pulumi.get(self, "delete_retention_ms")

    @property
    @pulumi.getter(name="fileDeleteDelayMs")
    def file_delete_delay_ms(self) -> Optional[str]:
        """
        The amount of time, in ms, to wait before deleting a topic log segment from the filesystem.
        """
        return pulumi.get(self, "file_delete_delay_ms")

    @property
    @pulumi.getter(name="flushMessages")
    def flush_messages(self) -> Optional[str]:
        """
        The number of messages accumulated on a topic partition before they are flushed to disk.
        """
        return pulumi.get(self, "flush_messages")

    @property
    @pulumi.getter(name="flushMs")
    def flush_ms(self) -> Optional[str]:
        """
        The maximum time, in ms, that a topic is kept in memory before being flushed to disk.
        """
        return pulumi.get(self, "flush_ms")

    @property
    @pulumi.getter(name="indexIntervalBytes")
    def index_interval_bytes(self) -> Optional[str]:
        """
        The interval, in bytes, in which entries are added to the offset index.
        """
        return pulumi.get(self, "index_interval_bytes")

    @property
    @pulumi.getter(name="maxCompactionLagMs")
    def max_compaction_lag_ms(self) -> Optional[str]:
        """
        The maximum time, in ms, that a particular message will remain uncompacted. This will not apply if the `compression_type` is set to "uncompressed" or it is set to `producer` and the producer is not using compression.
        """
        return pulumi.get(self, "max_compaction_lag_ms")

    @property
    @pulumi.getter(name="maxMessageBytes")
    def max_message_bytes(self) -> Optional[str]:
        """
        The maximum size, in bytes, of a message.
        """
        return pulumi.get(self, "max_message_bytes")

    @property
    @pulumi.getter(name="messageDownConversionEnable")
    def message_down_conversion_enable(self) -> Optional[bool]:
        """
        Determines whether down-conversion of message formats for consumers is enabled.
        """
        return pulumi.get(self, "message_down_conversion_enable")

    @property
    @pulumi.getter(name="messageFormatVersion")
    def message_format_version(self) -> Optional[str]:
        """
        The version of the inter-broker protocol that will be used. This may be one of "0.8.0", "0.8.1", "0.8.2", "0.9.0", "0.10.0", "0.10.0-IV0", "0.10.0-IV1", "0.10.1", "0.10.1-IV0", "0.10.1-IV1", "0.10.1-IV2", "0.10.2", "0.10.2-IV0", "0.11.0", "0.11.0-IV0", "0.11.0-IV1", "0.11.0-IV2", "1.0", "1.0-IV0", "1.1", "1.1-IV0", "2.0", "2.0-IV0", "2.0-IV1", "2.1", "2.1-IV0", "2.1-IV1", "2.1-IV2", "2.2", "2.2-IV0", "2.2-IV1", "2.3", "2.3-IV0", "2.3-IV1", "2.4", "2.4-IV0", "2.4-IV1", "2.5", "2.5-IV0", "2.6", "2.6-IV0", "2.7", "2.7-IV0", "2.7-IV1", "2.7-IV2", "2.8", "2.8-IV0", "2.8-IV1", "3.0", "3.0-IV0", "3.0-IV1", "3.1", "3.1-IV0", "3.2", "3.2-IV0", "3.3", "3.3-IV0", "3.3-IV1", "3.3-IV2", "3.3-IV3", "3.4", "3.4-IV0", "3.5", "3.5-IV0", "3.5-IV1", "3.5-IV2", "3.6", "3.6-IV0", "3.6-IV1", "3.6-IV2".
        """
        return pulumi.get(self, "message_format_version")

    @property
    @pulumi.getter(name="messageTimestampDifferenceMaxMs")
    def message_timestamp_difference_max_ms(self) -> Optional[str]:
        """
        The maximum difference, in ms, between the timestamp specific in a message and when the broker receives the message.
        """
        return pulumi.get(self, "message_timestamp_difference_max_ms")

    @property
    @pulumi.getter(name="messageTimestampType")
    def message_timestamp_type(self) -> Optional[str]:
        """
        Specifies which timestamp to use for the message. This may be one of "create_time" or "log_append_time".
        """
        return pulumi.get(self, "message_timestamp_type")

    @property
    @pulumi.getter(name="minCleanableDirtyRatio")
    def min_cleanable_dirty_ratio(self) -> Optional[float]:
        """
        A scale between 0.0 and 1.0 which controls the frequency of the compactor. Larger values mean more frequent compactions. This is often paired with `max_compaction_lag_ms` to control the compactor frequency.
        """
        return pulumi.get(self, "min_cleanable_dirty_ratio")

    @property
    @pulumi.getter(name="minCompactionLagMs")
    def min_compaction_lag_ms(self) -> Optional[str]:
        return pulumi.get(self, "min_compaction_lag_ms")

    @property
    @pulumi.getter(name="minInsyncReplicas")
    def min_insync_replicas(self) -> Optional[int]:
        """
        The number of replicas that must acknowledge a write before it is considered successful. -1 is a special setting to indicate that all nodes must ack a message before a write is considered successful. Default is 1, indicating at least 1 replica must acknowledge a write to be considered successful.
        """
        return pulumi.get(self, "min_insync_replicas")

    @property
    @pulumi.getter
    def preallocate(self) -> Optional[bool]:
        """
        Determines whether to preallocate a file on disk when creating a new log segment within a topic.
        """
        return pulumi.get(self, "preallocate")

    @property
    @pulumi.getter(name="retentionBytes")
    def retention_bytes(self) -> Optional[str]:
        """
        The maximum size, in bytes, of a topic before messages are deleted. -1 is a special setting indicating that this setting has no limit.
        """
        return pulumi.get(self, "retention_bytes")

    @property
    @pulumi.getter(name="retentionMs")
    def retention_ms(self) -> Optional[str]:
        """
        The maximum time, in ms, that a topic log file is retained before deleting it. -1 is a special setting indicating that this setting has no limit.
        """
        return pulumi.get(self, "retention_ms")

    @property
    @pulumi.getter(name="segmentBytes")
    def segment_bytes(self) -> Optional[str]:
        """
        The maximum size, in bytes, of a single topic log file.
        """
        return pulumi.get(self, "segment_bytes")

    @property
    @pulumi.getter(name="segmentIndexBytes")
    def segment_index_bytes(self) -> Optional[str]:
        """
        The maximum size, in bytes, of the offset index.
        """
        return pulumi.get(self, "segment_index_bytes")

    @property
    @pulumi.getter(name="segmentJitterMs")
    def segment_jitter_ms(self) -> Optional[str]:
        """
        The maximum time, in ms, subtracted from the scheduled segment disk flush time to avoid the thundering herd problem for segment flushing.
        """
        return pulumi.get(self, "segment_jitter_ms")

    @property
    @pulumi.getter(name="segmentMs")
    def segment_ms(self) -> Optional[str]:
        """
        The maximum time, in ms, before the topic log will flush to disk.
        """
        return pulumi.get(self, "segment_ms")


@pulumi.output_type
class DatabasePostgresqlConfigPgbouncer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autodbIdleTimeout":
            suggest = "autodb_idle_timeout"
        elif key == "autodbMaxDbConnections":
            suggest = "autodb_max_db_connections"
        elif key == "autodbPoolMode":
            suggest = "autodb_pool_mode"
        elif key == "autodbPoolSize":
            suggest = "autodb_pool_size"
        elif key == "ignoreStartupParameters":
            suggest = "ignore_startup_parameters"
        elif key == "minPoolSize":
            suggest = "min_pool_size"
        elif key == "serverIdleTimeout":
            suggest = "server_idle_timeout"
        elif key == "serverLifetime":
            suggest = "server_lifetime"
        elif key == "serverResetQueryAlways":
            suggest = "server_reset_query_always"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabasePostgresqlConfigPgbouncer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabasePostgresqlConfigPgbouncer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabasePostgresqlConfigPgbouncer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autodb_idle_timeout: Optional[int] = None,
                 autodb_max_db_connections: Optional[int] = None,
                 autodb_pool_mode: Optional[str] = None,
                 autodb_pool_size: Optional[int] = None,
                 ignore_startup_parameters: Optional[Sequence[str]] = None,
                 min_pool_size: Optional[int] = None,
                 server_idle_timeout: Optional[int] = None,
                 server_lifetime: Optional[int] = None,
                 server_reset_query_always: Optional[bool] = None):
        if autodb_idle_timeout is not None:
            pulumi.set(__self__, "autodb_idle_timeout", autodb_idle_timeout)
        if autodb_max_db_connections is not None:
            pulumi.set(__self__, "autodb_max_db_connections", autodb_max_db_connections)
        if autodb_pool_mode is not None:
            pulumi.set(__self__, "autodb_pool_mode", autodb_pool_mode)
        if autodb_pool_size is not None:
            pulumi.set(__self__, "autodb_pool_size", autodb_pool_size)
        if ignore_startup_parameters is not None:
            pulumi.set(__self__, "ignore_startup_parameters", ignore_startup_parameters)
        if min_pool_size is not None:
            pulumi.set(__self__, "min_pool_size", min_pool_size)
        if server_idle_timeout is not None:
            pulumi.set(__self__, "server_idle_timeout", server_idle_timeout)
        if server_lifetime is not None:
            pulumi.set(__self__, "server_lifetime", server_lifetime)
        if server_reset_query_always is not None:
            pulumi.set(__self__, "server_reset_query_always", server_reset_query_always)

    @property
    @pulumi.getter(name="autodbIdleTimeout")
    def autodb_idle_timeout(self) -> Optional[int]:
        return pulumi.get(self, "autodb_idle_timeout")

    @property
    @pulumi.getter(name="autodbMaxDbConnections")
    def autodb_max_db_connections(self) -> Optional[int]:
        return pulumi.get(self, "autodb_max_db_connections")

    @property
    @pulumi.getter(name="autodbPoolMode")
    def autodb_pool_mode(self) -> Optional[str]:
        return pulumi.get(self, "autodb_pool_mode")

    @property
    @pulumi.getter(name="autodbPoolSize")
    def autodb_pool_size(self) -> Optional[int]:
        return pulumi.get(self, "autodb_pool_size")

    @property
    @pulumi.getter(name="ignoreStartupParameters")
    def ignore_startup_parameters(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ignore_startup_parameters")

    @property
    @pulumi.getter(name="minPoolSize")
    def min_pool_size(self) -> Optional[int]:
        return pulumi.get(self, "min_pool_size")

    @property
    @pulumi.getter(name="serverIdleTimeout")
    def server_idle_timeout(self) -> Optional[int]:
        return pulumi.get(self, "server_idle_timeout")

    @property
    @pulumi.getter(name="serverLifetime")
    def server_lifetime(self) -> Optional[int]:
        return pulumi.get(self, "server_lifetime")

    @property
    @pulumi.getter(name="serverResetQueryAlways")
    def server_reset_query_always(self) -> Optional[bool]:
        return pulumi.get(self, "server_reset_query_always")


@pulumi.output_type
class DatabasePostgresqlConfigTimescaledb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBackgroundWorkers":
            suggest = "max_background_workers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabasePostgresqlConfigTimescaledb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabasePostgresqlConfigTimescaledb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabasePostgresqlConfigTimescaledb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_background_workers: Optional[int] = None):
        if max_background_workers is not None:
            pulumi.set(__self__, "max_background_workers", max_background_workers)

    @property
    @pulumi.getter(name="maxBackgroundWorkers")
    def max_background_workers(self) -> Optional[int]:
        return pulumi.get(self, "max_background_workers")


@pulumi.output_type
class DatabaseUserSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "opensearchAcls":
            suggest = "opensearch_acls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseUserSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseUserSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseUserSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acls: Optional[Sequence['outputs.DatabaseUserSettingAcl']] = None,
                 opensearch_acls: Optional[Sequence['outputs.DatabaseUserSettingOpensearchAcl']] = None):
        """
        :param Sequence['DatabaseUserSettingAclArgs'] acls: A set of ACLs (Access Control Lists) specifying permission on topics with a Kafka cluster. The properties of an individual ACL are described below:
               
               An individual ACL includes the following:
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if opensearch_acls is not None:
            pulumi.set(__self__, "opensearch_acls", opensearch_acls)

    @property
    @pulumi.getter
    def acls(self) -> Optional[Sequence['outputs.DatabaseUserSettingAcl']]:
        """
        A set of ACLs (Access Control Lists) specifying permission on topics with a Kafka cluster. The properties of an individual ACL are described below:

        An individual ACL includes the following:
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter(name="opensearchAcls")
    def opensearch_acls(self) -> Optional[Sequence['outputs.DatabaseUserSettingOpensearchAcl']]:
        return pulumi.get(self, "opensearch_acls")


@pulumi.output_type
class DatabaseUserSettingAcl(dict):
    def __init__(__self__, *,
                 permission: str,
                 topic: str,
                 id: Optional[str] = None):
        """
        :param str permission: The permission level applied to the ACL. This includes "admin", "consume", "produce", and "produceconsume". "admin" allows for producing and consuming as well as add/delete/update permission for topics. "consume" allows only for reading topic messages. "produce" allows only for writing topic messages. "produceconsume" allows for both reading and writing topic messages.
        :param str topic: A regex for matching the topic(s) that this ACL should apply to. The regex can assume one of 3 patterns: "*", "<prefix>*", or "<literal>". "*" is a special value indicating a wildcard that matches on all topics. "<prefix>*" defines a regex that matches all topics with the prefix. "<literal>" performs an exact match on a topic name and only applies to that topic.
        :param str id: An identifier for the ACL, this will be automatically assigned when you create an ACL entry
        """
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "topic", topic)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The permission level applied to the ACL. This includes "admin", "consume", "produce", and "produceconsume". "admin" allows for producing and consuming as well as add/delete/update permission for topics. "consume" allows only for reading topic messages. "produce" allows only for writing topic messages. "produceconsume" allows for both reading and writing topic messages.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        A regex for matching the topic(s) that this ACL should apply to. The regex can assume one of 3 patterns: "*", "<prefix>*", or "<literal>". "*" is a special value indicating a wildcard that matches on all topics. "<prefix>*" defines a regex that matches all topics with the prefix. "<literal>" performs an exact match on a topic name and only applies to that topic.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        An identifier for the ACL, this will be automatically assigned when you create an ACL entry
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class DatabaseUserSettingOpensearchAcl(dict):
    def __init__(__self__, *,
                 index: str,
                 permission: str):
        """
        :param str permission: The permission level applied to the ACL. This includes "admin", "consume", "produce", and "produceconsume". "admin" allows for producing and consuming as well as add/delete/update permission for topics. "consume" allows only for reading topic messages. "produce" allows only for writing topic messages. "produceconsume" allows for both reading and writing topic messages.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def index(self) -> str:
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The permission level applied to the ACL. This includes "admin", "consume", "produce", and "produceconsume". "admin" allows for producing and consuming as well as add/delete/update permission for topics. "consume" allows only for reading topic messages. "produce" allows only for writing topic messages. "produceconsume" allows for both reading and writing topic messages.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class DropletBackupPolicy(dict):
    def __init__(__self__, *,
                 hour: Optional[int] = None,
                 plan: Optional[str] = None,
                 weekday: Optional[str] = None):
        """
        :param int hour: The hour of the day that the backup window will start (`0`, `4`, `8`, `12`, `16`, `20`).
        :param str plan: The backup plan used for the Droplet. The plan can be either `daily` or `weekly`.
        :param str weekday: The day of the week on which the backup will occur (`SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, `SAT`).
        """
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if weekday is not None:
            pulumi.set(__self__, "weekday", weekday)

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        The hour of the day that the backup window will start (`0`, `4`, `8`, `12`, `16`, `20`).
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def plan(self) -> Optional[str]:
        """
        The backup plan used for the Droplet. The plan can be either `daily` or `weekly`.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def weekday(self) -> Optional[str]:
        """
        The day of the week on which the backup will occur (`SUN`, `MON`, `TUE`, `WED`, `THU`, `FRI`, `SAT`).
        """
        return pulumi.get(self, "weekday")


@pulumi.output_type
class FirewallInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portRange":
            suggest = "port_range"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceDropletIds":
            suggest = "source_droplet_ids"
        elif key == "sourceKubernetesIds":
            suggest = "source_kubernetes_ids"
        elif key == "sourceLoadBalancerUids":
            suggest = "source_load_balancer_uids"
        elif key == "sourceTags":
            suggest = "source_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: str,
                 port_range: Optional[str] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_droplet_ids: Optional[Sequence[int]] = None,
                 source_kubernetes_ids: Optional[Sequence[str]] = None,
                 source_load_balancer_uids: Optional[Sequence[str]] = None,
                 source_tags: Optional[Sequence[str]] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        :param Sequence[str] source_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
               inbound traffic will be accepted.
        :param Sequence[int] source_droplet_ids: An array containing the IDs of
               the Droplets from which the inbound traffic will be accepted.
        :param Sequence[str] source_kubernetes_ids: An array containing the IDs of
               the Kubernetes clusters from which the inbound traffic will be accepted.
        :param Sequence[str] source_load_balancer_uids: An array containing the IDs
               of the Load Balancers from which the inbound traffic will be accepted.
        :param Sequence[str] source_tags: An array containing the names of Tags
               corresponding to groups of Droplets from which the inbound traffic
               will be accepted.
        """
        pulumi.set(__self__, "protocol", protocol)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_droplet_ids is not None:
            pulumi.set(__self__, "source_droplet_ids", source_droplet_ids)
        if source_kubernetes_ids is not None:
            pulumi.set(__self__, "source_kubernetes_ids", source_kubernetes_ids)
        if source_load_balancer_uids is not None:
            pulumi.set(__self__, "source_load_balancer_uids", source_load_balancer_uids)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
        inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceDropletIds")
    def source_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_droplet_ids")

    @property
    @pulumi.getter(name="sourceKubernetesIds")
    def source_kubernetes_ids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs of
        the Kubernetes clusters from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_kubernetes_ids")

    @property
    @pulumi.getter(name="sourceLoadBalancerUids")
    def source_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_load_balancer_uids")

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[Sequence[str]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets from which the inbound traffic
        will be accepted.
        """
        return pulumi.get(self, "source_tags")


@pulumi.output_type
class FirewallOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationDropletIds":
            suggest = "destination_droplet_ids"
        elif key == "destinationKubernetesIds":
            suggest = "destination_kubernetes_ids"
        elif key == "destinationLoadBalancerUids":
            suggest = "destination_load_balancer_uids"
        elif key == "destinationTags":
            suggest = "destination_tags"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: str,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_droplet_ids: Optional[Sequence[int]] = None,
                 destination_kubernetes_ids: Optional[Sequence[str]] = None,
                 destination_load_balancer_uids: Optional[Sequence[str]] = None,
                 destination_tags: Optional[Sequence[str]] = None,
                 port_range: Optional[str] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param Sequence[str] destination_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
               outbound traffic will be allowed.
        :param Sequence[int] destination_droplet_ids: An array containing the IDs of
               the Droplets to which the outbound traffic will be allowed.
        :param Sequence[str] destination_kubernetes_ids: An array containing the IDs of
               the Kubernetes clusters to which the outbound traffic will be allowed.
        :param Sequence[str] destination_load_balancer_uids: An array containing the IDs
               of the Load Balancers to which the outbound traffic will be allowed.
        :param Sequence[str] destination_tags: An array containing the names of Tags
               corresponding to groups of Droplets to which the outbound traffic will
               be allowed.
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        """
        pulumi.set(__self__, "protocol", protocol)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_droplet_ids is not None:
            pulumi.set(__self__, "destination_droplet_ids", destination_droplet_ids)
        if destination_kubernetes_ids is not None:
            pulumi.set(__self__, "destination_kubernetes_ids", destination_kubernetes_ids)
        if destination_load_balancer_uids is not None:
            pulumi.set(__self__, "destination_load_balancer_uids", destination_load_balancer_uids)
        if destination_tags is not None:
            pulumi.set(__self__, "destination_tags", destination_tags)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
        outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationDropletIds")
    def destination_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_droplet_ids")

    @property
    @pulumi.getter(name="destinationKubernetesIds")
    def destination_kubernetes_ids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs of
        the Kubernetes clusters to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_kubernetes_ids")

    @property
    @pulumi.getter(name="destinationLoadBalancerUids")
    def destination_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_load_balancer_uids")

    @property
    @pulumi.getter(name="destinationTags")
    def destination_tags(self) -> Optional[Sequence[str]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets to which the outbound traffic will
        be allowed.
        """
        return pulumi.get(self, "destination_tags")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")


@pulumi.output_type
class FirewallPendingChange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropletId":
            suggest = "droplet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPendingChange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPendingChange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPendingChange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 droplet_id: Optional[int] = None,
                 removing: Optional[bool] = None,
                 status: Optional[str] = None):
        """
        :param str status: A status string indicating the current state of the Firewall.
               This can be "waiting", "succeeded", or "failed".
        """
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if removing is not None:
            pulumi.set(__self__, "removing", removing)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[int]:
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def removing(self) -> Optional[bool]:
        return pulumi.get(self, "removing")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A status string indicating the current state of the Firewall.
        This can be "waiting", "succeeded", or "failed".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class KubernetesClusterKubeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"
        elif key == "expiresAt":
            suggest = "expires_at"
        elif key == "rawConfig":
            suggest = "raw_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterKubeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterKubeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterKubeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 cluster_ca_certificate: Optional[str] = None,
                 expires_at: Optional[str] = None,
                 host: Optional[str] = None,
                 raw_config: Optional[str] = None,
                 token: Optional[str] = None):
        """
        :param str client_certificate: The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str client_key: The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str cluster_ca_certificate: The base64 encoded public certificate for the cluster's certificate authority.
        :param str expires_at: The date and time when the credentials will expire and need to be regenerated.
        :param str host: The URL of the API server on the Kubernetes master node.
        :param str raw_config: The full contents of the Kubernetes cluster's kubeconfig file.
        :param str token: The DigitalOcean API access token used by clients to access the cluster.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if raw_config is not None:
            pulumi.set(__self__, "raw_config", raw_config)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[str]:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[str]:
        """
        The date and time when the credentials will expire and need to be regenerated.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The URL of the API server on the Kubernetes master node.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="rawConfig")
    def raw_config(self) -> Optional[str]:
        """
        The full contents of the Kubernetes cluster's kubeconfig file.
        """
        return pulumi.get(self, "raw_config")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The DigitalOcean API access token used by clients to access the cluster.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class KubernetesClusterMaintenancePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterMaintenancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterMaintenancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterMaintenancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: Optional[str] = None,
                 duration: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        :param str day: The day of the maintenance window policy. May be one of "monday" through "sunday", or "any" to indicate an arbitrary week day.
        :param str duration: A string denoting the duration of the service window, e.g., "04:00".
        :param str start_time: The start time in UTC of the maintenance window policy in 24-hour clock format / HH:MM notation (e.g., 15:00).
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> Optional[str]:
        """
        The day of the maintenance window policy. May be one of "monday" through "sunday", or "any" to indicate an arbitrary week day.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        A string denoting the duration of the service window, e.g., "04:00".
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The start time in UTC of the maintenance window policy in 24-hour clock format / HH:MM notation (e.g., 15:00).
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class KubernetesClusterNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actualNodeCount":
            suggest = "actual_node_count"
        elif key == "autoScale":
            suggest = "auto_scale"
        elif key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"
        elif key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 size: str,
                 actual_node_count: Optional[int] = None,
                 auto_scale: Optional[bool] = None,
                 id: Optional[str] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 max_nodes: Optional[int] = None,
                 min_nodes: Optional[int] = None,
                 node_count: Optional[int] = None,
                 nodes: Optional[Sequence['outputs.KubernetesClusterNodePoolNode']] = None,
                 tags: Optional[Sequence[str]] = None,
                 taints: Optional[Sequence['outputs.KubernetesClusterNodePoolTaint']] = None):
        """
        :param str name: A name for the node pool.
        :param str size: The slug identifier for the type of Droplet to be used as workers in the node pool.
        :param int actual_node_count: A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        :param bool auto_scale: Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        :param str id: A unique ID that can be used to identify and reference the node.
        :param Mapping[str, str] labels: A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        :param int max_nodes: If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        :param int min_nodes: If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        :param int node_count: The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        :param Sequence['KubernetesClusterNodePoolNodeArgs'] nodes: A list of nodes in the pool. Each node exports the following attributes:
        :param Sequence[str] tags: A list of tag names applied to the node pool.
        :param Sequence['KubernetesClusterNodePoolTaintArgs'] taints: A block representing a taint applied to all nodes in the pool. Each taint exports the following attributes (taints must be unique by key and effect pair):
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if actual_node_count is not None:
            pulumi.set(__self__, "actual_node_count", actual_node_count)
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        The slug identifier for the type of Droplet to be used as workers in the node pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="actualNodeCount")
    def actual_node_count(self) -> Optional[int]:
        """
        A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        """
        return pulumi.get(self, "actual_node_count")

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[bool]:
        """
        Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        """
        return pulumi.get(self, "auto_scale")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[int]:
        """
        If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[int]:
        """
        If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.KubernetesClusterNodePoolNode']]:
        """
        A list of nodes in the pool. Each node exports the following attributes:
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        A list of tag names applied to the node pool.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.KubernetesClusterNodePoolTaint']]:
        """
        A block representing a taint applied to all nodes in the pool. Each taint exports the following attributes (taints must be unique by key and effect pair):
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class KubernetesClusterNodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "dropletId":
            suggest = "droplet_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterNodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterNodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterNodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 droplet_id: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 status: Optional[str] = None,
                 updated_at: Optional[str] = None):
        """
        :param str created_at: The date and time when the node was created.
        :param str droplet_id: The id of the node's droplet
        :param str id: A unique ID that can be used to identify and reference the node.
        :param str name: A name for the Kubernetes cluster.
        :param str status: A string indicating the current status of the individual node.
        :param str updated_at: The date and time when the node was last updated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[str]:
        """
        The id of the node's droplet
        """
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class KubernetesClusterNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param str key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param str value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class KubernetesNodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "dropletId":
            suggest = "droplet_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 droplet_id: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 status: Optional[str] = None,
                 updated_at: Optional[str] = None):
        """
        :param str created_at: The date and time when the node was created.
        :param str droplet_id: The id of the node's droplet
        :param str id: A unique ID that can be used to identify and reference the node.
        :param str name: A name for the node pool.
        :param str status: A string indicating the current status of the individual node.
        :param str updated_at: The date and time when the node was last updated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[str]:
        """
        The id of the node's droplet
        """
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class KubernetesNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param str key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param str value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadBalancerDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateName":
            suggest = "certificate_name"
        elif key == "isManaged":
            suggest = "is_managed"
        elif key == "sslValidationErrorReasons":
            suggest = "ssl_validation_error_reasons"
        elif key == "verificationErrorReasons":
            suggest = "verification_error_reasons"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 certificate_name: Optional[str] = None,
                 is_managed: Optional[bool] = None,
                 ssl_validation_error_reasons: Optional[Sequence[str]] = None,
                 verification_error_reasons: Optional[Sequence[str]] = None):
        """
        :param str name: The domain name to be used for ingressing traffic to a Global Load Balancer.
        :param str certificate_name: name of certificate required for TLS handshaking
        :param bool is_managed: Control flag to specify whether the domain is managed by DigitalOcean.
        :param Sequence[str] ssl_validation_error_reasons: list of domain SSL validation errors
        :param Sequence[str] verification_error_reasons: list of domain verification errors
        """
        pulumi.set(__self__, "name", name)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if is_managed is not None:
            pulumi.set(__self__, "is_managed", is_managed)
        if ssl_validation_error_reasons is not None:
            pulumi.set(__self__, "ssl_validation_error_reasons", ssl_validation_error_reasons)
        if verification_error_reasons is not None:
            pulumi.set(__self__, "verification_error_reasons", verification_error_reasons)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The domain name to be used for ingressing traffic to a Global Load Balancer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[str]:
        """
        name of certificate required for TLS handshaking
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> Optional[bool]:
        """
        Control flag to specify whether the domain is managed by DigitalOcean.
        """
        return pulumi.get(self, "is_managed")

    @property
    @pulumi.getter(name="sslValidationErrorReasons")
    def ssl_validation_error_reasons(self) -> Optional[Sequence[str]]:
        """
        list of domain SSL validation errors
        """
        return pulumi.get(self, "ssl_validation_error_reasons")

    @property
    @pulumi.getter(name="verificationErrorReasons")
    def verification_error_reasons(self) -> Optional[Sequence[str]]:
        """
        list of domain verification errors
        """
        return pulumi.get(self, "verification_error_reasons")


@pulumi.output_type
class LoadBalancerFirewall(dict):
    def __init__(__self__, *,
                 allows: Optional[Sequence[str]] = None,
                 denies: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] allows: A list of strings describing allow rules. Must be colon delimited strings of the form `{type}:{source}`
               * Ex. `deny = ["cidr:1.2.0.0/16", "ip:2.3.4.5"]` or `allow = ["ip:1.2.3.4", "cidr:2.3.4.0/24"]`
        :param Sequence[str] denies: A list of strings describing deny rules. Must be colon delimited strings of the form `{type}:{source}`
        """
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)

    @property
    @pulumi.getter
    def allows(self) -> Optional[Sequence[str]]:
        """
        A list of strings describing allow rules. Must be colon delimited strings of the form `{type}:{source}`
        * Ex. `deny = ["cidr:1.2.0.0/16", "ip:2.3.4.5"]` or `allow = ["ip:1.2.3.4", "cidr:2.3.4.0/24"]`
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter
    def denies(self) -> Optional[Sequence[str]]:
        """
        A list of strings describing deny rules. Must be colon delimited strings of the form `{type}:{source}`
        """
        return pulumi.get(self, "denies")


@pulumi.output_type
class LoadBalancerForwardingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPort":
            suggest = "entry_port"
        elif key == "entryProtocol":
            suggest = "entry_protocol"
        elif key == "targetPort":
            suggest = "target_port"
        elif key == "targetProtocol":
            suggest = "target_protocol"
        elif key == "certificateId":
            suggest = "certificate_id"
        elif key == "certificateName":
            suggest = "certificate_name"
        elif key == "tlsPassthrough":
            suggest = "tls_passthrough"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerForwardingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entry_port: int,
                 entry_protocol: str,
                 target_port: int,
                 target_protocol: str,
                 certificate_id: Optional[str] = None,
                 certificate_name: Optional[str] = None,
                 tls_passthrough: Optional[bool] = None):
        """
        :param int entry_port: An integer representing the port on which the Load Balancer instance will listen.
        :param str entry_protocol: The protocol used for traffic to the Load Balancer. The possible values are: `http`, `https`, `http2`, `http3`, `tcp`, or `udp`.
        :param int target_port: An integer representing the port on the backend Droplets to which the Load Balancer will send traffic.
        :param str target_protocol: The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http`, `https`, `http2`, `tcp`, or `udp`.
        :param str certificate_id: **Deprecated** The ID of the TLS certificate to be used for SSL termination.
        :param str certificate_name: The unique name of the TLS certificate to be used for SSL termination.
        :param bool tls_passthrough: A boolean value indicating whether SSL encrypted traffic will be passed through to the backend Droplets. The default value is `false`.
        """
        pulumi.set(__self__, "entry_port", entry_port)
        pulumi.set(__self__, "entry_protocol", entry_protocol)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if tls_passthrough is not None:
            pulumi.set(__self__, "tls_passthrough", tls_passthrough)

    @property
    @pulumi.getter(name="entryPort")
    def entry_port(self) -> int:
        """
        An integer representing the port on which the Load Balancer instance will listen.
        """
        return pulumi.get(self, "entry_port")

    @property
    @pulumi.getter(name="entryProtocol")
    def entry_protocol(self) -> str:
        """
        The protocol used for traffic to the Load Balancer. The possible values are: `http`, `https`, `http2`, `http3`, `tcp`, or `udp`.
        """
        return pulumi.get(self, "entry_protocol")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        """
        An integer representing the port on the backend Droplets to which the Load Balancer will send traffic.
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http`, `https`, `http2`, `tcp`, or `udp`.
        """
        return pulumi.get(self, "target_protocol")

    @property
    @pulumi.getter(name="certificateId")
    @_utilities.deprecated("""Certificate IDs may change, for example when a Let's Encrypt certificate is auto-renewed. Please specify 'certificate_name' instead.""")
    def certificate_id(self) -> Optional[str]:
        """
        **Deprecated** The ID of the TLS certificate to be used for SSL termination.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[str]:
        """
        The unique name of the TLS certificate to be used for SSL termination.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="tlsPassthrough")
    def tls_passthrough(self) -> Optional[bool]:
        """
        A boolean value indicating whether SSL encrypted traffic will be passed through to the backend Droplets. The default value is `false`.
        """
        return pulumi.get(self, "tls_passthrough")


@pulumi.output_type
class LoadBalancerGlbSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPort":
            suggest = "target_port"
        elif key == "targetProtocol":
            suggest = "target_protocol"
        elif key == "failoverThreshold":
            suggest = "failover_threshold"
        elif key == "regionPriorities":
            suggest = "region_priorities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerGlbSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerGlbSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerGlbSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_port: int,
                 target_protocol: str,
                 cdn: Optional['outputs.LoadBalancerGlbSettingsCdn'] = None,
                 failover_threshold: Optional[int] = None,
                 region_priorities: Optional[Mapping[str, int]] = None):
        """
        :param int target_port: An integer representing the port on the backend Droplets to which the Load Balancer will send traffic. The possible values are: `80` for `http` and `443` for `https`.
        :param str target_protocol: The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http` and `https`.
        :param 'LoadBalancerGlbSettingsCdnArgs' cdn: CDN configuration supporting the following:
        :param int failover_threshold: fail-over threshold
        :param Mapping[str, int] region_priorities: region priority map
        """
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if cdn is not None:
            pulumi.set(__self__, "cdn", cdn)
        if failover_threshold is not None:
            pulumi.set(__self__, "failover_threshold", failover_threshold)
        if region_priorities is not None:
            pulumi.set(__self__, "region_priorities", region_priorities)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        """
        An integer representing the port on the backend Droplets to which the Load Balancer will send traffic. The possible values are: `80` for `http` and `443` for `https`.
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http` and `https`.
        """
        return pulumi.get(self, "target_protocol")

    @property
    @pulumi.getter
    def cdn(self) -> Optional['outputs.LoadBalancerGlbSettingsCdn']:
        """
        CDN configuration supporting the following:
        """
        return pulumi.get(self, "cdn")

    @property
    @pulumi.getter(name="failoverThreshold")
    def failover_threshold(self) -> Optional[int]:
        """
        fail-over threshold
        """
        return pulumi.get(self, "failover_threshold")

    @property
    @pulumi.getter(name="regionPriorities")
    def region_priorities(self) -> Optional[Mapping[str, int]]:
        """
        region priority map
        """
        return pulumi.get(self, "region_priorities")


@pulumi.output_type
class LoadBalancerGlbSettingsCdn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerGlbSettingsCdn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerGlbSettingsCdn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerGlbSettingsCdn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        """
        :param bool is_enabled: Control flag to specify if caching is enabled.
        """
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Control flag to specify if caching is enabled.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class LoadBalancerHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkIntervalSeconds":
            suggest = "check_interval_seconds"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "responseTimeoutSeconds":
            suggest = "response_timeout_seconds"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 protocol: str,
                 check_interval_seconds: Optional[int] = None,
                 healthy_threshold: Optional[int] = None,
                 path: Optional[str] = None,
                 response_timeout_seconds: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        :param int port: An integer representing the port on the backend Droplets on which the health check will attempt a connection.
        :param str protocol: The protocol used for health checks sent to the backend Droplets. The possible values are `http`, `https` or `tcp`.
        :param int check_interval_seconds: The number of seconds between two consecutive health checks. If not specified, the default value is `10`.
        :param int healthy_threshold: The number of times a health check must pass for a backend Droplet to be marked "healthy" and be re-added to the pool. If not specified, the default value is `5`.
        :param str path: The path on the backend Droplets to which the Load Balancer instance will send a request.
        :param int response_timeout_seconds: The number of seconds the Load Balancer instance will wait for a response until marking a health check as failed. If not specified, the default value is `5`.
        :param int unhealthy_threshold: The number of times a health check must fail for a backend Droplet to be marked "unhealthy" and be removed from the pool. If not specified, the default value is `3`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if check_interval_seconds is not None:
            pulumi.set(__self__, "check_interval_seconds", check_interval_seconds)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response_timeout_seconds is not None:
            pulumi.set(__self__, "response_timeout_seconds", response_timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        An integer representing the port on the backend Droplets on which the health check will attempt a connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks sent to the backend Droplets. The possible values are `http`, `https` or `tcp`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="checkIntervalSeconds")
    def check_interval_seconds(self) -> Optional[int]:
        """
        The number of seconds between two consecutive health checks. If not specified, the default value is `10`.
        """
        return pulumi.get(self, "check_interval_seconds")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[int]:
        """
        The number of times a health check must pass for a backend Droplet to be marked "healthy" and be re-added to the pool. If not specified, the default value is `5`.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path on the backend Droplets to which the Load Balancer instance will send a request.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="responseTimeoutSeconds")
    def response_timeout_seconds(self) -> Optional[int]:
        """
        The number of seconds the Load Balancer instance will wait for a response until marking a health check as failed. If not specified, the default value is `5`.
        """
        return pulumi.get(self, "response_timeout_seconds")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The number of times a health check must fail for a backend Droplet to be marked "unhealthy" and be removed from the pool. If not specified, the default value is `3`.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class LoadBalancerStickySessions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"
        elif key == "cookieTtlSeconds":
            suggest = "cookie_ttl_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerStickySessions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerStickySessions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerStickySessions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_name: Optional[str] = None,
                 cookie_ttl_seconds: Optional[int] = None,
                 type: Optional[str] = None):
        """
        :param str cookie_name: The name to be used for the cookie sent to the client. This attribute is required when using `cookies` for the sticky sessions type.
        :param int cookie_ttl_seconds: The number of seconds until the cookie set by the Load Balancer expires. This attribute is required when using `cookies` for the sticky sessions type.
        :param str type: An attribute indicating how and if requests from a client will be persistently served by the same backend Droplet. The possible values are `cookies` or `none`. If not specified, the default value is `none`.
        """
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if cookie_ttl_seconds is not None:
            pulumi.set(__self__, "cookie_ttl_seconds", cookie_ttl_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[str]:
        """
        The name to be used for the cookie sent to the client. This attribute is required when using `cookies` for the sticky sessions type.
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="cookieTtlSeconds")
    def cookie_ttl_seconds(self) -> Optional[int]:
        """
        The number of seconds until the cookie set by the Load Balancer expires. This attribute is required when using `cookies` for the sticky sessions type.
        """
        return pulumi.get(self, "cookie_ttl_seconds")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        An attribute indicating how and if requests from a client will be persistently served by the same backend Droplet. The possible values are `cookies` or `none`. If not specified, the default value is `none`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitorAlertAlerts(dict):
    def __init__(__self__, *,
                 emails: Optional[Sequence[str]] = None,
                 slacks: Optional[Sequence['outputs.MonitorAlertAlertsSlack']] = None):
        """
        :param Sequence[str] emails: List of email addresses to sent notifications to
        """
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if slacks is not None:
            pulumi.set(__self__, "slacks", slacks)

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[str]]:
        """
        List of email addresses to sent notifications to
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter
    def slacks(self) -> Optional[Sequence['outputs.MonitorAlertAlertsSlack']]:
        return pulumi.get(self, "slacks")


@pulumi.output_type
class MonitorAlertAlertsSlack(dict):
    def __init__(__self__, *,
                 channel: str,
                 url: str):
        """
        :param str channel: The Slack channel to send alerts to
        :param str url: The webhook URL for Slack
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The Slack channel to send alerts to
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The webhook URL for Slack
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class SpacesBucketCorsConfigurationCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacesBucketCorsConfigurationCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacesBucketCorsConfigurationCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacesBucketCorsConfigurationCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: Set of HTTP methods that you allow the origin to execute. Valid values are GET, PUT, HEAD, POST, and DELETE.
        :param Sequence[str] allowed_origins: Set of origins you want customers to be able to access the bucket from.
        :param Sequence[str] allowed_headers: Set of Headers that are specified in the Access-Control-Request-Headers header.
        :param Sequence[str] expose_headers: Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript XMLHttpRequest object).
        :param str id: Unique identifier for the rule. The value cannot be longer than 255 characters.
        :param int max_age_seconds: Time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Set of HTTP methods that you allow the origin to execute. Valid values are GET, PUT, HEAD, POST, and DELETE.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Set of origins you want customers to be able to access the bucket from.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Set of Headers that are specified in the Access-Control-Request-Headers header.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript XMLHttpRequest object).
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. The value cannot be longer than 255 characters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class SpacesBucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacesBucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacesBucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacesBucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: A list of HTTP methods (e.g. `GET`) which are allowed from the specified origin.
        :param Sequence[str] allowed_origins: A list of hosts from which requests using the specified methods are allowed. A host may contain one wildcard (e.g. http://*.example.com).
        :param Sequence[str] allowed_headers: A list of headers that will be included in the CORS preflight request's `Access-Control-Request-Headers`. A header may contain one wildcard (e.g. `x-amz-*`).
        :param int max_age_seconds: The time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        A list of HTTP methods (e.g. `GET`) which are allowed from the specified origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        A list of hosts from which requests using the specified methods are allowed. A host may contain one wildcard (e.g. http://*.example.com).
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        A list of headers that will be included in the CORS preflight request's `Access-Control-Request-Headers`. A header may contain one wildcard (e.g. `x-amz-*`).
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        The time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class SpacesBucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"
        elif key == "noncurrentVersionExpiration":
            suggest = "noncurrent_version_expiration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacesBucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacesBucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacesBucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_incomplete_multipart_upload_days: Optional[int] = None,
                 expiration: Optional['outputs.SpacesBucketLifecycleRuleExpiration'] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expiration: Optional['outputs.SpacesBucketLifecycleRuleNoncurrentVersionExpiration'] = None,
                 prefix: Optional[str] = None):
        """
        :param bool enabled: Specifies lifecycle rule status.
        :param int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart
               upload when the multipart upload must be completed or else Spaces will abort the upload.
        :param 'SpacesBucketLifecycleRuleExpirationArgs' expiration: Specifies a time period after which applicable objects expire (documented below).
        :param str id: Unique identifier for the rule.
        :param 'SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs' noncurrent_version_expiration: Specifies when non-current object versions expire (documented below).
               
               At least one of `expiration` or `noncurrent_version_expiration` must be specified.
        :param str prefix: Object key prefix identifying one or more objects to which the rule applies.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[int]:
        """
        Specifies the number of days after initiating a multipart
        upload when the multipart upload must be completed or else Spaces will abort the upload.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.SpacesBucketLifecycleRuleExpiration']:
        """
        Specifies a time period after which applicable objects expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional['outputs.SpacesBucketLifecycleRuleNoncurrentVersionExpiration']:
        """
        Specifies when non-current object versions expire (documented below).

        At least one of `expiration` or `noncurrent_version_expiration` must be specified.
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class SpacesBucketLifecycleRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacesBucketLifecycleRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacesBucketLifecycleRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacesBucketLifecycleRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Specifies the date/time after which you want applicable objects to expire. The argument uses
               RFC3339 format, e.g. "2020-03-22T15:03:55Z" or parts thereof e.g. "2019-02-28".
        :param int days: Specifies the number of days after object creation when the applicable objects will expire.
        :param bool expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended
               bucket), setting this to true directs Spaces to delete expired object delete markers.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date/time after which you want applicable objects to expire. The argument uses
        RFC3339 format, e.g. "2020-03-22T15:03:55Z" or parts thereof e.g. "2019-02-28".
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the applicable objects will expire.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended
        bucket), setting this to true directs Spaces to delete expired object delete markers.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class SpacesBucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: Optional[int] = None):
        """
        :param int days: Specifies the number of days after which an object's non-current versions expire.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after which an object's non-current versions expire.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class SpacesBucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned
               state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned
        state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class UptimeAlertNotification(dict):
    def __init__(__self__, *,
                 emails: Optional[Sequence[str]] = None,
                 slacks: Optional[Sequence['outputs.UptimeAlertNotificationSlack']] = None):
        """
        :param Sequence[str] emails: List of email addresses to sent notifications to.
        """
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if slacks is not None:
            pulumi.set(__self__, "slacks", slacks)

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[str]]:
        """
        List of email addresses to sent notifications to.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter
    def slacks(self) -> Optional[Sequence['outputs.UptimeAlertNotificationSlack']]:
        return pulumi.get(self, "slacks")


@pulumi.output_type
class UptimeAlertNotificationSlack(dict):
    def __init__(__self__, *,
                 channel: str,
                 url: str):
        """
        :param str channel: The Slack channel to send alerts to.
        :param str url: The webhook URL for Slack.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The Slack channel to send alerts to.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The webhook URL for Slack.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetAppDedicatedIpResult(dict):
    def __init__(__self__, *,
                 id: str,
                 ip: str,
                 status: str):
        """
        :param str id: The ID of the dedicated egress IP.
        :param str ip: The IP address of the dedicated egress IP.
        :param str status: The status of the dedicated egress IP.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the dedicated egress IP.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The IP address of the dedicated egress IP.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the dedicated egress IP.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAppSpecResult(dict):
    def __init__(__self__, *,
                 domain: Sequence['outputs.GetAppSpecDomainResult'],
                 domains: Sequence[str],
                 features: Sequence[str],
                 ingress: 'outputs.GetAppSpecIngressResult',
                 name: str,
                 alerts: Optional[Sequence['outputs.GetAppSpecAlertResult']] = None,
                 databases: Optional[Sequence['outputs.GetAppSpecDatabaseResult']] = None,
                 egresses: Optional[Sequence['outputs.GetAppSpecEgressResult']] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecEnvResult']] = None,
                 functions: Optional[Sequence['outputs.GetAppSpecFunctionResult']] = None,
                 jobs: Optional[Sequence['outputs.GetAppSpecJobResult']] = None,
                 region: Optional[str] = None,
                 services: Optional[Sequence['outputs.GetAppSpecServiceResult']] = None,
                 static_sites: Optional[Sequence['outputs.GetAppSpecStaticSiteResult']] = None,
                 workers: Optional[Sequence['outputs.GetAppSpecWorkerResult']] = None):
        """
        :param Sequence[str] features: List of features which is applied to the app
        :param str name: The name of the component.
        :param Sequence['GetAppSpecAlertArgs'] alerts: Describes an alert policy for the component.
        :param Sequence['GetAppSpecEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param str region: The slug for the DigitalOcean data center region hosting the app
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "domains", domains)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "ingress", ingress)
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if egresses is not None:
            pulumi.set(__self__, "egresses", egresses)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_sites is not None:
            pulumi.set(__self__, "static_sites", static_sites)
        if workers is not None:
            pulumi.set(__self__, "workers", workers)

    @property
    @pulumi.getter
    def domain(self) -> Sequence['outputs.GetAppSpecDomainResult']:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute has been replaced by `domain` which supports additional functionality.""")
    def domains(self) -> Sequence[str]:
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def features(self) -> Sequence[str]:
        """
        List of features which is applied to the app
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def ingress(self) -> 'outputs.GetAppSpecIngressResult':
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.GetAppSpecAlertResult']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter
    def databases(self) -> Optional[Sequence['outputs.GetAppSpecDatabaseResult']]:
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def egresses(self) -> Optional[Sequence['outputs.GetAppSpecEgressResult']]:
        return pulumi.get(self, "egresses")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def functions(self) -> Optional[Sequence['outputs.GetAppSpecFunctionResult']]:
        return pulumi.get(self, "functions")

    @property
    @pulumi.getter
    def jobs(self) -> Optional[Sequence['outputs.GetAppSpecJobResult']]:
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The slug for the DigitalOcean data center region hosting the app
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.GetAppSpecServiceResult']]:
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="staticSites")
    def static_sites(self) -> Optional[Sequence['outputs.GetAppSpecStaticSiteResult']]:
        return pulumi.get(self, "static_sites")

    @property
    @pulumi.getter
    def workers(self) -> Optional[Sequence['outputs.GetAppSpecWorkerResult']]:
        return pulumi.get(self, "workers")


@pulumi.output_type
class GetAppSpecAlertResult(dict):
    def __init__(__self__, *,
                 rule: str,
                 disabled: Optional[bool] = None):
        """
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "rule", rule)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetAppSpecDatabaseResult(dict):
    def __init__(__self__, *,
                 cluster_name: Optional[str] = None,
                 db_name: Optional[str] = None,
                 db_user: Optional[str] = None,
                 engine: Optional[str] = None,
                 name: Optional[str] = None,
                 production: Optional[bool] = None,
                 version: Optional[str] = None):
        """
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str db_name: The name of the MySQL or PostgreSQL database to configure.
        :param str db_user: The name of the MySQL or PostgreSQL user to configure.
        :param str engine: The database engine to use (`MYSQL`, `PG`, `REDIS`, or `MONGODB`).
        :param str name: The name of the component.
        :param bool production: Whether this is a production or dev database.
        :param str version: The version of the database engine.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if production is not None:
            pulumi.set(__self__, "production", production)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL database to configure.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL user to configure.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        """
        The database engine to use (`MYSQL`, `PG`, `REDIS`, or `MONGODB`).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def production(self) -> Optional[bool]:
        """
        Whether this is a production or dev database.
        """
        return pulumi.get(self, "production")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAppSpecDomainResult(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 wildcard: bool,
                 zone: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param bool wildcard: Indicates whether the domain includes all sub-domains, in addition to the given domain.
        :param str zone: If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "wildcard", wildcard)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def wildcard(self) -> bool:
        """
        Indicates whether the domain includes all sub-domains, in addition to the given domain.
        """
        return pulumi.get(self, "wildcard")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetAppSpecEgressResult(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAppSpecEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The threshold for the type of the warning.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecFunctionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 routes: Sequence['outputs.GetAppSpecFunctionRouteResult'],
                 alerts: Optional[Sequence['outputs.GetAppSpecFunctionAlertResult']] = None,
                 cors: Optional['outputs.GetAppSpecFunctionCorsResult'] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecFunctionEnvResult']] = None,
                 git: Optional['outputs.GetAppSpecFunctionGitResult'] = None,
                 github: Optional['outputs.GetAppSpecFunctionGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecFunctionGitlabResult'] = None,
                 log_destinations: Optional[Sequence['outputs.GetAppSpecFunctionLogDestinationResult']] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param Sequence['GetAppSpecFunctionAlertArgs'] alerts: Describes an alert policy for the component.
        :param 'GetAppSpecFunctionCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param Sequence['GetAppSpecFunctionEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'GetAppSpecFunctionGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecFunctionGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecFunctionGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param Sequence['GetAppSpecFunctionLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routes", routes)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level routes are deprecated in favor of ingresses""")
    def routes(self) -> Sequence['outputs.GetAppSpecFunctionRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.GetAppSpecFunctionAlertResult']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level CORS rules are deprecated in favor of ingresses""")
    def cors(self) -> Optional['outputs.GetAppSpecFunctionCorsResult']:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecFunctionEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecFunctionGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecFunctionGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecFunctionGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.GetAppSpecFunctionLogDestinationResult']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecFunctionAlertResult(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetAppSpecFunctionCorsResult(dict):
    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.GetAppSpecFunctionCorsAllowOriginsResult'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        :param 'GetAppSpecFunctionCorsAllowOriginsArgs' allow_origins: The `Access-Control-Allow-Origin` can be
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.GetAppSpecFunctionCorsAllowOriginsResult']:
        """
        The `Access-Control-Allow-Origin` can be
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class GetAppSpecFunctionCorsAllowOriginsResult(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        :param str prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        :param str regex: The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAppSpecFunctionEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The threshold for the type of the warning.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecFunctionGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecFunctionGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecFunctionGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecFunctionLogDestinationResult(dict):
    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.GetAppSpecFunctionLogDestinationDatadogResult'] = None,
                 logtail: Optional['outputs.GetAppSpecFunctionLogDestinationLogtailResult'] = None,
                 open_search: Optional['outputs.GetAppSpecFunctionLogDestinationOpenSearchResult'] = None,
                 papertrail: Optional['outputs.GetAppSpecFunctionLogDestinationPapertrailResult'] = None):
        """
        :param str name: The name of the component.
        :param 'GetAppSpecFunctionLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'GetAppSpecFunctionLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'GetAppSpecFunctionLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'GetAppSpecFunctionLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.GetAppSpecFunctionLogDestinationDatadogResult']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.GetAppSpecFunctionLogDestinationLogtailResult']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.GetAppSpecFunctionLogDestinationOpenSearchResult']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.GetAppSpecFunctionLogDestinationPapertrailResult']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class GetAppSpecFunctionLogDestinationDatadogResult(dict):
    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetAppSpecFunctionLogDestinationLogtailResult(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetAppSpecFunctionLogDestinationOpenSearchResult(dict):
    def __init__(__self__, *,
                 basic_auth: 'outputs.GetAppSpecFunctionLogDestinationOpenSearchBasicAuthResult',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'GetAppSpecFunctionLogDestinationOpenSearchBasicAuthArgs' basic_auth: OpenSearch basic auth
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        :param str index_name: The index name to use for the logs. If not set, the default index name is `logs`.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.GetAppSpecFunctionLogDestinationOpenSearchBasicAuthResult':
        """
        OpenSearch basic auth
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        The index name to use for the logs. If not set, the default index name is `logs`.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class GetAppSpecFunctionLogDestinationOpenSearchBasicAuthResult(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        :param str user: Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetAppSpecFunctionLogDestinationPapertrailResult(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetAppSpecFunctionRouteResult(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None,
                 preserve_path_prefix: Optional[bool] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        :param bool preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[bool]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")


@pulumi.output_type
class GetAppSpecIngressResult(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.GetAppSpecIngressRuleResult']):
        """
        :param Sequence['GetAppSpecIngressRuleArgs'] rules: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAppSpecIngressRuleResult']:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetAppSpecIngressRuleResult(dict):
    def __init__(__self__, *,
                 component: 'outputs.GetAppSpecIngressRuleComponentResult',
                 cors: 'outputs.GetAppSpecIngressRuleCorsResult',
                 match: 'outputs.GetAppSpecIngressRuleMatchResult',
                 redirect: Optional['outputs.GetAppSpecIngressRuleRedirectResult'] = None):
        """
        :param 'GetAppSpecIngressRuleCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "cors", cors)
        pulumi.set(__self__, "match", match)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @property
    @pulumi.getter
    def component(self) -> 'outputs.GetAppSpecIngressRuleComponentResult':
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def cors(self) -> 'outputs.GetAppSpecIngressRuleCorsResult':
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.GetAppSpecIngressRuleMatchResult':
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.GetAppSpecIngressRuleRedirectResult']:
        return pulumi.get(self, "redirect")


@pulumi.output_type
class GetAppSpecIngressRuleComponentResult(dict):
    def __init__(__self__, *,
                 name: str,
                 preserve_path_prefix: bool,
                 rewrite: str):
        """
        :param str name: The name of the component.
        :param bool preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)
        pulumi.set(__self__, "rewrite", rewrite)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> bool:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")

    @property
    @pulumi.getter
    def rewrite(self) -> str:
        return pulumi.get(self, "rewrite")


@pulumi.output_type
class GetAppSpecIngressRuleCorsResult(dict):
    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.GetAppSpecIngressRuleCorsAllowOriginsResult'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        :param 'GetAppSpecIngressRuleCorsAllowOriginsArgs' allow_origins: The `Access-Control-Allow-Origin` can be
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.GetAppSpecIngressRuleCorsAllowOriginsResult']:
        """
        The `Access-Control-Allow-Origin` can be
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class GetAppSpecIngressRuleCorsAllowOriginsResult(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        :param str prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        :param str regex: The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAppSpecIngressRuleMatchResult(dict):
    def __init__(__self__, *,
                 path: 'outputs.GetAppSpecIngressRuleMatchPathResult'):
        """
        :param 'GetAppSpecIngressRuleMatchPathArgs' path: Paths must start with `/` and must be unique within the app.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> 'outputs.GetAppSpecIngressRuleMatchPathResult':
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetAppSpecIngressRuleMatchPathResult(dict):
    def __init__(__self__, *,
                 prefix: str):
        """
        :param str prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetAppSpecIngressRuleRedirectResult(dict):
    def __init__(__self__, *,
                 authority: Optional[str] = None,
                 port: Optional[int] = None,
                 redirect_code: Optional[int] = None,
                 scheme: Optional[str] = None,
                 uri: Optional[str] = None):
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if redirect_code is not None:
            pulumi.set(__self__, "redirect_code", redirect_code)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def authority(self) -> Optional[str]:
        return pulumi.get(self, "authority")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="redirectCode")
    def redirect_code(self) -> Optional[int]:
        return pulumi.get(self, "redirect_code")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[str]:
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetAppSpecJobResult(dict):
    def __init__(__self__, *,
                 name: str,
                 alerts: Optional[Sequence['outputs.GetAppSpecJobAlertResult']] = None,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecJobEnvResult']] = None,
                 git: Optional['outputs.GetAppSpecJobGitResult'] = None,
                 github: Optional['outputs.GetAppSpecJobGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecJobGitlabResult'] = None,
                 image: Optional['outputs.GetAppSpecJobImageResult'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 kind: Optional[str] = None,
                 log_destinations: Optional[Sequence['outputs.GetAppSpecJobLogDestinationResult']] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param Sequence['GetAppSpecJobAlertArgs'] alerts: Describes an alert policy for the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecJobEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'GetAppSpecJobGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecJobGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecJobGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecJobImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param str kind: The type of job and when it will be run during the deployment process. It may be one of:
               - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
               - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
               - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
               - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        :param Sequence['GetAppSpecJobLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.GetAppSpecJobAlertResult']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecJobEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecJobGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecJobGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecJobGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.GetAppSpecJobImageResult']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        The type of job and when it will be run during the deployment process. It may be one of:
        - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
        - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
        - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
        - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.GetAppSpecJobLogDestinationResult']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecJobAlertResult(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetAppSpecJobEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The threshold for the type of the warning.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecJobGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecJobGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecJobGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecJobImageResult(dict):
    def __init__(__self__, *,
                 deploy_on_pushes: Sequence['outputs.GetAppSpecJobImageDeployOnPushResult'],
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 registry_credentials: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param Sequence['GetAppSpecJobImageDeployOnPushArgs'] deploy_on_pushes: Whether to automatically deploy new commits made to the repo.
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str registry_credentials: Access credentials for third-party registries
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "deploy_on_pushes", deploy_on_pushes)
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if registry_credentials is not None:
            pulumi.set(__self__, "registry_credentials", registry_credentials)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="deployOnPushes")
    def deploy_on_pushes(self) -> Sequence['outputs.GetAppSpecJobImageDeployOnPushResult']:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_pushes")

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="registryCredentials")
    def registry_credentials(self) -> Optional[str]:
        """
        Access credentials for third-party registries
        """
        return pulumi.get(self, "registry_credentials")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetAppSpecJobImageDeployOnPushResult(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether to automatically deploy images pushed to DOCR.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether to automatically deploy images pushed to DOCR.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetAppSpecJobLogDestinationResult(dict):
    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.GetAppSpecJobLogDestinationDatadogResult'] = None,
                 logtail: Optional['outputs.GetAppSpecJobLogDestinationLogtailResult'] = None,
                 open_search: Optional['outputs.GetAppSpecJobLogDestinationOpenSearchResult'] = None,
                 papertrail: Optional['outputs.GetAppSpecJobLogDestinationPapertrailResult'] = None):
        """
        :param str name: The name of the component.
        :param 'GetAppSpecJobLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'GetAppSpecJobLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'GetAppSpecJobLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'GetAppSpecJobLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.GetAppSpecJobLogDestinationDatadogResult']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.GetAppSpecJobLogDestinationLogtailResult']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.GetAppSpecJobLogDestinationOpenSearchResult']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.GetAppSpecJobLogDestinationPapertrailResult']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class GetAppSpecJobLogDestinationDatadogResult(dict):
    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetAppSpecJobLogDestinationLogtailResult(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetAppSpecJobLogDestinationOpenSearchResult(dict):
    def __init__(__self__, *,
                 basic_auth: 'outputs.GetAppSpecJobLogDestinationOpenSearchBasicAuthResult',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'GetAppSpecJobLogDestinationOpenSearchBasicAuthArgs' basic_auth: OpenSearch basic auth
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        :param str index_name: The index name to use for the logs. If not set, the default index name is `logs`.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.GetAppSpecJobLogDestinationOpenSearchBasicAuthResult':
        """
        OpenSearch basic auth
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        The index name to use for the logs. If not set, the default index name is `logs`.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class GetAppSpecJobLogDestinationOpenSearchBasicAuthResult(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        :param str user: Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetAppSpecJobLogDestinationPapertrailResult(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetAppSpecServiceResult(dict):
    def __init__(__self__, *,
                 http_port: int,
                 internal_ports: Sequence[int],
                 name: str,
                 routes: Sequence['outputs.GetAppSpecServiceRouteResult'],
                 run_command: str,
                 alerts: Optional[Sequence['outputs.GetAppSpecServiceAlertResult']] = None,
                 autoscaling: Optional['outputs.GetAppSpecServiceAutoscalingResult'] = None,
                 build_command: Optional[str] = None,
                 cors: Optional['outputs.GetAppSpecServiceCorsResult'] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecServiceEnvResult']] = None,
                 git: Optional['outputs.GetAppSpecServiceGitResult'] = None,
                 github: Optional['outputs.GetAppSpecServiceGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecServiceGitlabResult'] = None,
                 health_check: Optional['outputs.GetAppSpecServiceHealthCheckResult'] = None,
                 image: Optional['outputs.GetAppSpecServiceImageResult'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 log_destinations: Optional[Sequence['outputs.GetAppSpecServiceLogDestinationResult']] = None,
                 source_dir: Optional[str] = None):
        """
        :param int http_port: The internal port on which this service's run command will listen.
        :param Sequence[int] internal_ports: A list of ports on which this service will listen for internal traffic.
        :param str name: The name of the component.
        :param str run_command: An optional run command to override the component's default.
        :param Sequence['GetAppSpecServiceAlertArgs'] alerts: Describes an alert policy for the component.
        :param 'GetAppSpecServiceAutoscalingArgs' autoscaling: Configuration for automatically scaling this component based on metrics.
        :param str build_command: An optional build command to run while building this component from source.
        :param 'GetAppSpecServiceCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecServiceEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'GetAppSpecServiceGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecServiceGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecServiceGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecServiceHealthCheckArgs' health_check: A health check to determine the availability of this component.
        :param 'GetAppSpecServiceImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param Sequence['GetAppSpecServiceLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "http_port", http_port)
        pulumi.set(__self__, "internal_ports", internal_ports)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routes", routes)
        pulumi.set(__self__, "run_command", run_command)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> int:
        """
        The internal port on which this service's run command will listen.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="internalPorts")
    def internal_ports(self) -> Sequence[int]:
        """
        A list of ports on which this service will listen for internal traffic.
        """
        return pulumi.get(self, "internal_ports")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level routes are deprecated in favor of ingresses""")
    def routes(self) -> Sequence['outputs.GetAppSpecServiceRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> str:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.GetAppSpecServiceAlertResult']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional['outputs.GetAppSpecServiceAutoscalingResult']:
        """
        Configuration for automatically scaling this component based on metrics.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level CORS rules are deprecated in favor of ingresses""")
    def cors(self) -> Optional['outputs.GetAppSpecServiceCorsResult']:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecServiceEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecServiceGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecServiceGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecServiceGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.GetAppSpecServiceHealthCheckResult']:
        """
        A health check to determine the availability of this component.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.GetAppSpecServiceImageResult']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.GetAppSpecServiceLogDestinationResult']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecServiceAlertResult(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetAppSpecServiceAutoscalingResult(dict):
    def __init__(__self__, *,
                 max_instance_count: int,
                 metrics: 'outputs.GetAppSpecServiceAutoscalingMetricsResult',
                 min_instance_count: int):
        """
        :param int max_instance_count: The maximum amount of instances for this component. Must be more than min_instance_count.
        :param 'GetAppSpecServiceAutoscalingMetricsArgs' metrics: The metrics that the component is scaled on.
        :param int min_instance_count: The minimum amount of instances for this component. Must be less than max_instance_count.
        """
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> int:
        """
        The maximum amount of instances for this component. Must be more than min_instance_count.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter
    def metrics(self) -> 'outputs.GetAppSpecServiceAutoscalingMetricsResult':
        """
        The metrics that the component is scaled on.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> int:
        """
        The minimum amount of instances for this component. Must be less than max_instance_count.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class GetAppSpecServiceAutoscalingMetricsResult(dict):
    def __init__(__self__, *,
                 cpu: Optional['outputs.GetAppSpecServiceAutoscalingMetricsCpuResult'] = None):
        """
        :param 'GetAppSpecServiceAutoscalingMetricsCpuArgs' cpu: Settings for scaling the component based on CPU utilization.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)

    @property
    @pulumi.getter
    def cpu(self) -> Optional['outputs.GetAppSpecServiceAutoscalingMetricsCpuResult']:
        """
        Settings for scaling the component based on CPU utilization.
        """
        return pulumi.get(self, "cpu")


@pulumi.output_type
class GetAppSpecServiceAutoscalingMetricsCpuResult(dict):
    def __init__(__self__, *,
                 percent: int):
        """
        :param int percent: The average target CPU utilization for the component.
        """
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        The average target CPU utilization for the component.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class GetAppSpecServiceCorsResult(dict):
    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.GetAppSpecServiceCorsAllowOriginsResult'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        :param 'GetAppSpecServiceCorsAllowOriginsArgs' allow_origins: The `Access-Control-Allow-Origin` can be
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.GetAppSpecServiceCorsAllowOriginsResult']:
        """
        The `Access-Control-Allow-Origin` can be
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class GetAppSpecServiceCorsAllowOriginsResult(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        :param str prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        :param str regex: The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAppSpecServiceEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The threshold for the type of the warning.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecServiceGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecServiceGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecServiceGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecServiceHealthCheckResult(dict):
    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_path: Optional[str] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 port: Optional[int] = None,
                 success_threshold: Optional[int] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: The number of failed health checks before considered unhealthy.
        :param str http_path: The route path used for the HTTP health check ping.
        :param int initial_delay_seconds: The number of seconds to wait before beginning health checks.
        :param int period_seconds: The number of seconds to wait between health checks.
        :param int port: The port on which the health check will be performed. If not set, the health check will be performed on the component's http_port.
        :param int success_threshold: The number of successful health checks before considered healthy.
        :param int timeout_seconds: The number of seconds after which the check times out.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failed health checks before considered unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[str]:
        """
        The route path used for the HTTP health check ping.
        """
        return pulumi.get(self, "http_path")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait before beginning health checks.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait between health checks.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port on which the health check will be performed. If not set, the health check will be performed on the component's http_port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful health checks before considered healthy.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        The number of seconds after which the check times out.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetAppSpecServiceImageResult(dict):
    def __init__(__self__, *,
                 deploy_on_pushes: Sequence['outputs.GetAppSpecServiceImageDeployOnPushResult'],
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 registry_credentials: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param Sequence['GetAppSpecServiceImageDeployOnPushArgs'] deploy_on_pushes: Whether to automatically deploy new commits made to the repo.
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str registry_credentials: Access credentials for third-party registries
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "deploy_on_pushes", deploy_on_pushes)
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if registry_credentials is not None:
            pulumi.set(__self__, "registry_credentials", registry_credentials)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="deployOnPushes")
    def deploy_on_pushes(self) -> Sequence['outputs.GetAppSpecServiceImageDeployOnPushResult']:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_pushes")

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="registryCredentials")
    def registry_credentials(self) -> Optional[str]:
        """
        Access credentials for third-party registries
        """
        return pulumi.get(self, "registry_credentials")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetAppSpecServiceImageDeployOnPushResult(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether to automatically deploy images pushed to DOCR.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether to automatically deploy images pushed to DOCR.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetAppSpecServiceLogDestinationResult(dict):
    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.GetAppSpecServiceLogDestinationDatadogResult'] = None,
                 logtail: Optional['outputs.GetAppSpecServiceLogDestinationLogtailResult'] = None,
                 open_search: Optional['outputs.GetAppSpecServiceLogDestinationOpenSearchResult'] = None,
                 papertrail: Optional['outputs.GetAppSpecServiceLogDestinationPapertrailResult'] = None):
        """
        :param str name: The name of the component.
        :param 'GetAppSpecServiceLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'GetAppSpecServiceLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'GetAppSpecServiceLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'GetAppSpecServiceLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.GetAppSpecServiceLogDestinationDatadogResult']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.GetAppSpecServiceLogDestinationLogtailResult']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.GetAppSpecServiceLogDestinationOpenSearchResult']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.GetAppSpecServiceLogDestinationPapertrailResult']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class GetAppSpecServiceLogDestinationDatadogResult(dict):
    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetAppSpecServiceLogDestinationLogtailResult(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetAppSpecServiceLogDestinationOpenSearchResult(dict):
    def __init__(__self__, *,
                 basic_auth: 'outputs.GetAppSpecServiceLogDestinationOpenSearchBasicAuthResult',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'GetAppSpecServiceLogDestinationOpenSearchBasicAuthArgs' basic_auth: OpenSearch basic auth
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        :param str index_name: The index name to use for the logs. If not set, the default index name is `logs`.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.GetAppSpecServiceLogDestinationOpenSearchBasicAuthResult':
        """
        OpenSearch basic auth
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        The index name to use for the logs. If not set, the default index name is `logs`.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class GetAppSpecServiceLogDestinationOpenSearchBasicAuthResult(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        :param str user: Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetAppSpecServiceLogDestinationPapertrailResult(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetAppSpecServiceRouteResult(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None,
                 preserve_path_prefix: Optional[bool] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        :param bool preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[bool]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")


@pulumi.output_type
class GetAppSpecStaticSiteResult(dict):
    def __init__(__self__, *,
                 name: str,
                 routes: Sequence['outputs.GetAppSpecStaticSiteRouteResult'],
                 build_command: Optional[str] = None,
                 catchall_document: Optional[str] = None,
                 cors: Optional['outputs.GetAppSpecStaticSiteCorsResult'] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecStaticSiteEnvResult']] = None,
                 error_document: Optional[str] = None,
                 git: Optional['outputs.GetAppSpecStaticSiteGitResult'] = None,
                 github: Optional['outputs.GetAppSpecStaticSiteGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecStaticSiteGitlabResult'] = None,
                 index_document: Optional[str] = None,
                 output_dir: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str catchall_document: The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        :param 'GetAppSpecStaticSiteCorsArgs' cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecStaticSiteEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param str error_document: The name of the error document to use when serving this static site.
        :param 'GetAppSpecStaticSiteGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecStaticSiteGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecStaticSiteGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param str index_document: The name of the index document to use when serving this static site.
        :param str output_dir: An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routes", routes)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if catchall_document is not None:
            pulumi.set(__self__, "catchall_document", catchall_document)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if output_dir is not None:
            pulumi.set(__self__, "output_dir", output_dir)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level routes are deprecated in favor of ingresses""")
    def routes(self) -> Sequence['outputs.GetAppSpecStaticSiteRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="catchallDocument")
    def catchall_document(self) -> Optional[str]:
        """
        The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        """
        return pulumi.get(self, "catchall_document")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Service level CORS rules are deprecated in favor of ingresses""")
    def cors(self) -> Optional['outputs.GetAppSpecStaticSiteCorsResult']:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecStaticSiteEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        The name of the error document to use when serving this static site.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecStaticSiteGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecStaticSiteGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecStaticSiteGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        The name of the index document to use when serving this static site.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="outputDir")
    def output_dir(self) -> Optional[str]:
        """
        An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        """
        return pulumi.get(self, "output_dir")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecStaticSiteCorsResult(dict):
    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional['outputs.GetAppSpecStaticSiteCorsAllowOriginsResult'] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[str] = None):
        """
        :param bool allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        :param Sequence[str] allow_headers: The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        :param Sequence[str] allow_methods: The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        :param 'GetAppSpecStaticSiteCorsAllowOriginsArgs' allow_origins: The `Access-Control-Allow-Origin` can be
        :param Sequence[str] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        :param str max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional['outputs.GetAppSpecStaticSiteCorsAllowOriginsResult']:
        """
        The `Access-Control-Allow-Origin` can be
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[str]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class GetAppSpecStaticSiteCorsAllowOriginsResult(dict):
    def __init__(__self__, *,
                 exact: Optional[str] = None,
                 prefix: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param str exact: The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        :param str prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        :param str regex: The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Prefix-based matching has been deprecated in favor of regex-based matching.""")
    def prefix(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAppSpecStaticSiteEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The threshold for the type of the warning.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecStaticSiteGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecStaticSiteGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecStaticSiteGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecStaticSiteRouteResult(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None,
                 preserve_path_prefix: Optional[bool] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        :param bool preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[bool]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")


@pulumi.output_type
class GetAppSpecWorkerResult(dict):
    def __init__(__self__, *,
                 name: str,
                 alerts: Optional[Sequence['outputs.GetAppSpecWorkerAlertResult']] = None,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecWorkerEnvResult']] = None,
                 git: Optional['outputs.GetAppSpecWorkerGitResult'] = None,
                 github: Optional['outputs.GetAppSpecWorkerGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecWorkerGitlabResult'] = None,
                 image: Optional['outputs.GetAppSpecWorkerImageResult'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 log_destinations: Optional[Sequence['outputs.GetAppSpecWorkerLogDestinationResult']] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param Sequence['GetAppSpecWorkerAlertArgs'] alerts: Describes an alert policy for the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecWorkerEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'GetAppSpecWorkerGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecWorkerGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecWorkerGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecWorkerImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param Sequence['GetAppSpecWorkerLogDestinationArgs'] log_destinations: Describes a log forwarding destination.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def alerts(self) -> Optional[Sequence['outputs.GetAppSpecWorkerAlertResult']]:
        """
        Describes an alert policy for the component.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecWorkerEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecWorkerGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecWorkerGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecWorkerGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.GetAppSpecWorkerImageResult']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[Sequence['outputs.GetAppSpecWorkerLogDestinationResult']]:
        """
        Describes a log forwarding destination.
        """
        return pulumi.get(self, "log_destinations")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecWorkerAlertResult(dict):
    def __init__(__self__, *,
                 operator: str,
                 rule: str,
                 value: float,
                 window: str,
                 disabled: Optional[bool] = None):
        """
        :param str operator: The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        :param str rule: The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        :param float value: The threshold for the type of the warning.
        :param str window: The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        :param bool disabled: Determines whether or not the alert is disabled (default: `false`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "window", window)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use. This is either of `GREATER_THAN` or `LESS_THAN`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        The type of the alert to configure. Component app alert policies can be: `CPU_UTILIZATION`, `MEM_UTILIZATION`, or `RESTART_COUNT`.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def window(self) -> str:
        """
        The time before alerts should be triggered. This is may be one of: `FIVE_MINUTES`, `TEN_MINUTES`, `THIRTY_MINUTES`, `ONE_HOUR`.
        """
        return pulumi.get(self, "window")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Determines whether or not the alert is disabled (default: `false`).
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetAppSpecWorkerEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The threshold for the type of the warning.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The threshold for the type of the warning.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecWorkerGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecWorkerGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecWorkerGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecWorkerImageResult(dict):
    def __init__(__self__, *,
                 deploy_on_pushes: Sequence['outputs.GetAppSpecWorkerImageDeployOnPushResult'],
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 registry_credentials: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param Sequence['GetAppSpecWorkerImageDeployOnPushArgs'] deploy_on_pushes: Whether to automatically deploy new commits made to the repo.
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str registry_credentials: Access credentials for third-party registries
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "deploy_on_pushes", deploy_on_pushes)
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if registry_credentials is not None:
            pulumi.set(__self__, "registry_credentials", registry_credentials)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="deployOnPushes")
    def deploy_on_pushes(self) -> Sequence['outputs.GetAppSpecWorkerImageDeployOnPushResult']:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_pushes")

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter(name="registryCredentials")
    def registry_credentials(self) -> Optional[str]:
        """
        Access credentials for third-party registries
        """
        return pulumi.get(self, "registry_credentials")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetAppSpecWorkerImageDeployOnPushResult(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether to automatically deploy images pushed to DOCR.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether to automatically deploy images pushed to DOCR.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetAppSpecWorkerLogDestinationResult(dict):
    def __init__(__self__, *,
                 name: str,
                 datadog: Optional['outputs.GetAppSpecWorkerLogDestinationDatadogResult'] = None,
                 logtail: Optional['outputs.GetAppSpecWorkerLogDestinationLogtailResult'] = None,
                 open_search: Optional['outputs.GetAppSpecWorkerLogDestinationOpenSearchResult'] = None,
                 papertrail: Optional['outputs.GetAppSpecWorkerLogDestinationPapertrailResult'] = None):
        """
        :param str name: The name of the component.
        :param 'GetAppSpecWorkerLogDestinationDatadogArgs' datadog: Datadog configuration.
        :param 'GetAppSpecWorkerLogDestinationLogtailArgs' logtail: Logtail configuration.
        :param 'GetAppSpecWorkerLogDestinationOpenSearchArgs' open_search: OpenSearch configuration.
        :param 'GetAppSpecWorkerLogDestinationPapertrailArgs' papertrail: Papertrail configuration.
        """
        pulumi.set(__self__, "name", name)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if logtail is not None:
            pulumi.set(__self__, "logtail", logtail)
        if open_search is not None:
            pulumi.set(__self__, "open_search", open_search)
        if papertrail is not None:
            pulumi.set(__self__, "papertrail", papertrail)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def datadog(self) -> Optional['outputs.GetAppSpecWorkerLogDestinationDatadogResult']:
        """
        Datadog configuration.
        """
        return pulumi.get(self, "datadog")

    @property
    @pulumi.getter
    def logtail(self) -> Optional['outputs.GetAppSpecWorkerLogDestinationLogtailResult']:
        """
        Logtail configuration.
        """
        return pulumi.get(self, "logtail")

    @property
    @pulumi.getter(name="openSearch")
    def open_search(self) -> Optional['outputs.GetAppSpecWorkerLogDestinationOpenSearchResult']:
        """
        OpenSearch configuration.
        """
        return pulumi.get(self, "open_search")

    @property
    @pulumi.getter
    def papertrail(self) -> Optional['outputs.GetAppSpecWorkerLogDestinationPapertrailResult']:
        """
        Papertrail configuration.
        """
        return pulumi.get(self, "papertrail")


@pulumi.output_type
class GetAppSpecWorkerLogDestinationDatadogResult(dict):
    def __init__(__self__, *,
                 api_key: str,
                 endpoint: Optional[str] = None):
        """
        :param str api_key: Datadog API key.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Datadog API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetAppSpecWorkerLogDestinationLogtailResult(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Logtail token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Logtail token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetAppSpecWorkerLogDestinationOpenSearchResult(dict):
    def __init__(__self__, *,
                 basic_auth: 'outputs.GetAppSpecWorkerLogDestinationOpenSearchBasicAuthResult',
                 cluster_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 index_name: Optional[str] = None):
        """
        :param 'GetAppSpecWorkerLogDestinationOpenSearchBasicAuthArgs' basic_auth: OpenSearch basic auth
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        :param str index_name: The index name to use for the logs. If not set, the default index name is `logs`.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> 'outputs.GetAppSpecWorkerLogDestinationOpenSearchBasicAuthResult':
        """
        OpenSearch basic auth
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[str]:
        """
        The index name to use for the logs. If not set, the default index name is `logs`.
        """
        return pulumi.get(self, "index_name")


@pulumi.output_type
class GetAppSpecWorkerLogDestinationOpenSearchBasicAuthResult(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str password: Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        :param str user: Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for user defined in User. Is required when endpoint is set. Cannot be set if using a DigitalOcean DBaaS OpenSearch cluster.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Username to authenticate with. Only required when endpoint is set. Defaults to doadmin when cluster_name is set.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetAppSpecWorkerLogDestinationPapertrailResult(dict):
    def __init__(__self__, *,
                 endpoint: str):
        """
        :param str endpoint: OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        OpenSearch API Endpoint. Only HTTPS is supported. Format: https://<host>:<port>.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class GetDatabaseClusterMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: str,
                 hour: str):
        """
        :param str day: The day of the week on which to apply maintenance updates.
        :param str hour: The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        The day of the week on which to apply maintenance updates.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> str:
        """
        The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        return pulumi.get(self, "hour")


@pulumi.output_type
class GetDatabaseUserSettingResult(dict):
    def __init__(__self__, *,
                 acls: Optional[Sequence['outputs.GetDatabaseUserSettingAclResult']] = None):
        if acls is not None:
            pulumi.set(__self__, "acls", acls)

    @property
    @pulumi.getter
    def acls(self) -> Optional[Sequence['outputs.GetDatabaseUserSettingAclResult']]:
        return pulumi.get(self, "acls")


@pulumi.output_type
class GetDatabaseUserSettingAclResult(dict):
    def __init__(__self__, *,
                 id: str,
                 permission: str,
                 topic: str):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def permission(self) -> str:
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def topic(self) -> str:
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 name: str,
                 ttl: int,
                 urn: str):
        """
        :param str name: (Required) The name of the domain.
        :param int ttl: The TTL of the domain.
        :param str urn: The uniform resource name of the domain
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Required) The name of the domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The TTL of the domain.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def urn(self) -> str:
        """
        The uniform resource name of the domain
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetDomainsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves domains
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves domains
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetDomainsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetDropletsDropletResult(dict):
    def __init__(__self__, *,
                 backups: bool,
                 created_at: str,
                 disk: int,
                 id: int,
                 image: str,
                 ipv4_address: str,
                 ipv4_address_private: str,
                 ipv6: bool,
                 ipv6_address: str,
                 ipv6_address_private: str,
                 locked: bool,
                 memory: int,
                 monitoring: bool,
                 name: str,
                 price_hourly: float,
                 price_monthly: float,
                 private_networking: bool,
                 region: str,
                 size: str,
                 status: str,
                 tags: Sequence[str],
                 urn: str,
                 vcpus: int,
                 volume_ids: Sequence[str],
                 vpc_uuid: str):
        """
        :param bool backups: Whether backups are enabled.
        :param str created_at: the creation date for the Droplet
        :param int disk: The size of the Droplet's disk in GB.
        :param int id: The ID of the Droplet.
        :param str image: The Droplet image ID or slug.
        :param str ipv4_address: The Droplet's public IPv4 address
        :param str ipv4_address_private: The Droplet's private IPv4 address
        :param bool ipv6: Whether IPv6 is enabled.
        :param str ipv6_address: The Droplet's public IPv6 address
        :param str ipv6_address_private: The Droplet's private IPv6 address
        :param bool locked: Whether the Droplet is locked.
        :param int memory: The amount of the Droplet's memory in MB.
        :param bool monitoring: Whether monitoring agent is installed.
        :param str name: name of the Droplet
        :param float price_hourly: Droplet hourly price.
        :param float price_monthly: Droplet monthly price.
        :param bool private_networking: Whether private networks are enabled.
        :param str region: The region the Droplet is running in.
        :param str size: The unique slug that identifies the type of Droplet.
        :param str status: The status of the Droplet.
        :param Sequence[str] tags: A list of the tags associated to the Droplet.
        :param str urn: The uniform resource name of the Droplet
        :param int vcpus: The number of the Droplet's virtual CPUs.
        :param Sequence[str] volume_ids: List of the IDs of each volumes attached to the Droplet.
        :param str vpc_uuid: The ID of the VPC where the Droplet is located.
        """
        pulumi.set(__self__, "backups", backups)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv4_address_private", ipv4_address_private)
        pulumi.set(__self__, "ipv6", ipv6)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_address_private", ipv6_address_private)
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "monitoring", monitoring)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "price_hourly", price_hourly)
        pulumi.set(__self__, "price_monthly", price_monthly)
        pulumi.set(__self__, "private_networking", private_networking)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)
        pulumi.set(__self__, "vcpus", vcpus)
        pulumi.set(__self__, "volume_ids", volume_ids)
        pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @property
    @pulumi.getter
    def backups(self) -> bool:
        """
        Whether backups are enabled.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        the creation date for the Droplet
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def disk(self) -> int:
        """
        The size of the Droplet's disk in GB.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the Droplet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The Droplet image ID or slug.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        The Droplet's public IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4AddressPrivate")
    def ipv4_address_private(self) -> str:
        """
        The Droplet's private IPv4 address
        """
        return pulumi.get(self, "ipv4_address_private")

    @property
    @pulumi.getter
    def ipv6(self) -> bool:
        """
        Whether IPv6 is enabled.
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        The Droplet's public IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6AddressPrivate")
    def ipv6_address_private(self) -> str:
        """
        The Droplet's private IPv6 address
        """
        return pulumi.get(self, "ipv6_address_private")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        Whether the Droplet is locked.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The amount of the Droplet's memory in MB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def monitoring(self) -> bool:
        """
        Whether monitoring agent is installed.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of the Droplet
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> float:
        """
        Droplet hourly price.
        """
        return pulumi.get(self, "price_hourly")

    @property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> float:
        """
        Droplet monthly price.
        """
        return pulumi.get(self, "price_monthly")

    @property
    @pulumi.getter(name="privateNetworking")
    def private_networking(self) -> bool:
        """
        Whether private networks are enabled.
        """
        return pulumi.get(self, "private_networking")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region the Droplet is running in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        The unique slug that identifies the type of Droplet.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Droplet.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A list of the tags associated to the Droplet.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> str:
        """
        The uniform resource name of the Droplet
        """
        return pulumi.get(self, "urn")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        The number of the Droplet's virtual CPUs.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Sequence[str]:
        """
        List of the IDs of each volumes attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> str:
        """
        The ID of the VPC where the Droplet is located.
        """
        return pulumi.get(self, "vpc_uuid")


@pulumi.output_type
class GetDropletsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
               `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
               `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
               `status`, `tags`, `urn`, `vcpus`, `volume_ids`, or `vpc_uuid`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves Droplets
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
        `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
        `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
        `status`, `tags`, `urn`, `vcpus`, `volume_ids`, or `vpc_uuid`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves Droplets
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetDropletsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
               `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
               `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
               `status`, `urn`, `vcpus`, or `vpc_uuid`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
        `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
        `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
        `status`, `urn`, `vcpus`, or `vpc_uuid`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetFirewallInboundRuleResult(dict):
    def __init__(__self__, *,
                 protocol: str,
                 port_range: Optional[str] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_droplet_ids: Optional[Sequence[int]] = None,
                 source_kubernetes_ids: Optional[Sequence[str]] = None,
                 source_load_balancer_uids: Optional[Sequence[str]] = None,
                 source_tags: Optional[Sequence[str]] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        :param Sequence[str] source_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
               inbound traffic will be accepted.
        :param Sequence[int] source_droplet_ids: An array containing the IDs of
               the Droplets from which the inbound traffic will be accepted.
        :param Sequence[str] source_load_balancer_uids: An array containing the IDs
               of the Load Balancers from which the inbound traffic will be accepted.
        :param Sequence[str] source_tags: A set of names of Tags corresponding to group of
               Droplets from which the inbound traffic will be accepted.
        """
        pulumi.set(__self__, "protocol", protocol)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_droplet_ids is not None:
            pulumi.set(__self__, "source_droplet_ids", source_droplet_ids)
        if source_kubernetes_ids is not None:
            pulumi.set(__self__, "source_kubernetes_ids", source_kubernetes_ids)
        if source_load_balancer_uids is not None:
            pulumi.set(__self__, "source_load_balancer_uids", source_load_balancer_uids)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
        inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceDropletIds")
    def source_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_droplet_ids")

    @property
    @pulumi.getter(name="sourceKubernetesIds")
    def source_kubernetes_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "source_kubernetes_ids")

    @property
    @pulumi.getter(name="sourceLoadBalancerUids")
    def source_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_load_balancer_uids")

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[Sequence[str]]:
        """
        A set of names of Tags corresponding to group of
        Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_tags")


@pulumi.output_type
class GetFirewallOutboundRuleResult(dict):
    def __init__(__self__, *,
                 protocol: str,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_droplet_ids: Optional[Sequence[int]] = None,
                 destination_kubernetes_ids: Optional[Sequence[str]] = None,
                 destination_load_balancer_uids: Optional[Sequence[str]] = None,
                 destination_tags: Optional[Sequence[str]] = None,
                 port_range: Optional[str] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param Sequence[str] destination_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
               outbound traffic will be allowed.
        :param Sequence[int] destination_droplet_ids: An array containing the IDs of
               the Droplets to which the outbound traffic will be allowed.
        :param Sequence[str] destination_load_balancer_uids: An array containing the IDs
               of the Load Balancers to which the outbound traffic will be allowed.
        :param Sequence[str] destination_tags: An array containing the names of Tags
               corresponding to groups of Droplets to which the outbound traffic will
               be allowed.
               traffic.
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        """
        pulumi.set(__self__, "protocol", protocol)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_droplet_ids is not None:
            pulumi.set(__self__, "destination_droplet_ids", destination_droplet_ids)
        if destination_kubernetes_ids is not None:
            pulumi.set(__self__, "destination_kubernetes_ids", destination_kubernetes_ids)
        if destination_load_balancer_uids is not None:
            pulumi.set(__self__, "destination_load_balancer_uids", destination_load_balancer_uids)
        if destination_tags is not None:
            pulumi.set(__self__, "destination_tags", destination_tags)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
        outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationDropletIds")
    def destination_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_droplet_ids")

    @property
    @pulumi.getter(name="destinationKubernetesIds")
    def destination_kubernetes_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "destination_kubernetes_ids")

    @property
    @pulumi.getter(name="destinationLoadBalancerUids")
    def destination_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_load_balancer_uids")

    @property
    @pulumi.getter(name="destinationTags")
    def destination_tags(self) -> Optional[Sequence[str]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets to which the outbound traffic will
        be allowed.
        traffic.
        """
        return pulumi.get(self, "destination_tags")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")


@pulumi.output_type
class GetFirewallPendingChangeResult(dict):
    def __init__(__self__, *,
                 droplet_id: Optional[int] = None,
                 removing: Optional[bool] = None,
                 status: Optional[str] = None):
        """
        :param str status: A status string indicating the current state of the Firewall.
               This can be "waiting", "succeeded", or "failed".
        """
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if removing is not None:
            pulumi.set(__self__, "removing", removing)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[int]:
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def removing(self) -> Optional[bool]:
        return pulumi.get(self, "removing")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A status string indicating the current state of the Firewall.
        This can be "waiting", "succeeded", or "failed".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetImagesFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the images by this key. This may be one of `distribution`, `error_message`,
               `id`, `image`, `min_disk_size`, `name`, `private`, `regions`, `size_gigabytes`, `slug`, `status`,
               `tags`, or `type`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves images
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the images by this key. This may be one of `distribution`, `error_message`,
        `id`, `image`, `min_disk_size`, `name`, `private`, `regions`, `size_gigabytes`, `slug`, `status`,
        `tags`, or `type`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves images
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 created: str,
                 description: str,
                 distribution: str,
                 error_message: str,
                 id: int,
                 image: str,
                 min_disk_size: int,
                 name: str,
                 private: bool,
                 regions: Sequence[str],
                 size_gigabytes: float,
                 slug: str,
                 status: str,
                 tags: Sequence[str],
                 type: str):
        """
        :param str created: When the image was created
        :param str description: a description of the image
        :param str distribution: The name of the distribution of the OS of the image.
        :param str error_message: Any applicable error message pertaining to the image
        :param int id: The ID of the image.
        :param str image: The id of the image (legacy parameter).
        :param int min_disk_size: The minimum 'disk' required for the image.
        :param str name: The name of the image.
        :param bool private: Is image a public image or not. Public images represent
               Linux distributions or One-Click Applications, while non-public images represent
               snapshots and backups and are only available within your account.
        :param Sequence[str] regions: A set of the regions that the image is available in.
        :param float size_gigabytes: The size of the image in GB.
        :param str slug: Unique text identifier of the image.
        :param str status: Current status of the image
        :param Sequence[str] tags: A set of tags applied to the image
        :param str type: Type of the image.
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "min_disk_size", min_disk_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private", private)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "size_gigabytes", size_gigabytes)
        pulumi.set(__self__, "slug", slug)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        When the image was created
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        a description of the image
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distribution(self) -> str:
        """
        The name of the distribution of the OS of the image.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Any applicable error message pertaining to the image
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the image.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The id of the image (legacy parameter).
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> int:
        """
        The minimum 'disk' required for the image.
        """
        return pulumi.get(self, "min_disk_size")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def private(self) -> bool:
        """
        Is image a public image or not. Public images represent
        Linux distributions or One-Click Applications, while non-public images represent
        snapshots and backups and are only available within your account.
        """
        return pulumi.get(self, "private")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        """
        A set of the regions that the image is available in.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="sizeGigabytes")
    def size_gigabytes(self) -> float:
        """
        The size of the image in GB.
        """
        return pulumi.get(self, "size_gigabytes")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        Unique text identifier of the image.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of the image
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of tags applied to the image
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the image.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetImagesSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the images by this key. This may be one of `distribution`, `error_message`, `id`,
               `image`, `min_disk_size`, `name`, `private`, `size_gigabytes`, `slug`, `status`, or `type`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the images by this key. This may be one of `distribution`, `error_message`, `id`,
        `image`, `min_disk_size`, `name`, `private`, `size_gigabytes`, `slug`, `status`, or `type`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetKubernetesClusterKubeConfigResult(dict):
    def __init__(__self__, *,
                 client_certificate: str,
                 client_key: str,
                 cluster_ca_certificate: str,
                 expires_at: str,
                 host: str,
                 raw_config: str,
                 token: str):
        """
        :param str client_certificate: The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str client_key: The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str cluster_ca_certificate: The base64 encoded public certificate for the cluster's certificate authority.
        :param str expires_at: The date and time when the credentials will expire and need to be regenerated.
        :param str host: The URL of the API server on the Kubernetes master node.
        :param str raw_config: The full contents of the Kubernetes cluster's kubeconfig file.
        :param str token: The DigitalOcean API access token used by clients to access the cluster.
        """
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "raw_config", raw_config)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> str:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        The date and time when the credentials will expire and need to be regenerated.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The URL of the API server on the Kubernetes master node.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="rawConfig")
    def raw_config(self) -> str:
        """
        The full contents of the Kubernetes cluster's kubeconfig file.
        """
        return pulumi.get(self, "raw_config")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The DigitalOcean API access token used by clients to access the cluster.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetKubernetesClusterMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 day: str,
                 duration: str,
                 start_time: str):
        """
        :param str day: The day for the service window of the Kubernetes cluster.
        :param str duration: The duration of the operation.
        :param str start_time: The start time of the upgrade operation.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        The day for the service window of the Kubernetes cluster.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The duration of the operation.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the upgrade operation.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetKubernetesClusterNodePoolResult(dict):
    def __init__(__self__, *,
                 actual_node_count: int,
                 auto_scale: bool,
                 id: str,
                 labels: Mapping[str, str],
                 max_nodes: int,
                 min_nodes: int,
                 name: str,
                 node_count: int,
                 nodes: Sequence['outputs.GetKubernetesClusterNodePoolNodeResult'],
                 size: str,
                 tags: Sequence[str],
                 taints: Sequence['outputs.GetKubernetesClusterNodePoolTaintResult']):
        """
        :param int actual_node_count: The actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        :param bool auto_scale: A boolean indicating whether auto-scaling is enabled on the node pool.
        :param str id: A unique ID that can be used to identify and reference the node.
        :param Mapping[str, str] labels: A map of key/value pairs applied to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        :param int max_nodes: If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        :param int min_nodes: If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        :param str name: The name of Kubernetes cluster.
        :param int node_count: The number of Droplet instances in the node pool.
        :param Sequence['GetKubernetesClusterNodePoolNodeArgs'] nodes: A list of nodes in the pool. Each node exports the following attributes:
        :param str size: The slug identifier for the type of Droplet used as workers in the node pool.
        :param Sequence[str] tags: A list of tag names applied to the node pool.
        :param Sequence['GetKubernetesClusterNodePoolTaintArgs'] taints: A list of taints applied to all nodes in the pool. Each taint exports the following attributes:
        """
        pulumi.set(__self__, "actual_node_count", actual_node_count)
        pulumi.set(__self__, "auto_scale", auto_scale)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="actualNodeCount")
    def actual_node_count(self) -> int:
        """
        The actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        """
        return pulumi.get(self, "actual_node_count")

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> bool:
        """
        A boolean indicating whether auto-scaling is enabled on the node pool.
        """
        return pulumi.get(self, "auto_scale")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A map of key/value pairs applied to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> int:
        """
        If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> int:
        """
        If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of Droplet instances in the node pool.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetKubernetesClusterNodePoolNodeResult']:
        """
        A list of nodes in the pool. Each node exports the following attributes:
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        The slug identifier for the type of Droplet used as workers in the node pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A list of tag names applied to the node pool.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetKubernetesClusterNodePoolTaintResult']:
        """
        A list of taints applied to all nodes in the pool. Each taint exports the following attributes:
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class GetKubernetesClusterNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 droplet_id: str,
                 id: str,
                 name: str,
                 status: str,
                 updated_at: str):
        """
        :param str created_at: The date and time when the node was created.
        :param str id: A unique ID that can be used to identify and reference the node.
        :param str name: The name of Kubernetes cluster.
        :param str status: A string indicating the current status of the individual node.
        :param str updated_at: The date and time when the node was last updated.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "droplet_id", droplet_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> str:
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetKubernetesClusterNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param str key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param str value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetLoadBalancerDomainResult(dict):
    def __init__(__self__, *,
                 certificate_id: str,
                 certificate_name: str,
                 is_managed: bool,
                 name: str,
                 ssl_validation_error_reasons: Sequence[str],
                 verification_error_reasons: Sequence[str]):
        """
        :param str certificate_id: certificate ID for TLS handshaking
        :param str certificate_name: name of certificate required for TLS handshaking
        :param bool is_managed: flag indicating if domain is managed by DigitalOcean
        :param str name: The name of load balancer.
        :param Sequence[str] ssl_validation_error_reasons: list of domain SSL validation errors
        :param Sequence[str] verification_error_reasons: list of domain verification errors
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "is_managed", is_managed)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ssl_validation_error_reasons", ssl_validation_error_reasons)
        pulumi.set(__self__, "verification_error_reasons", verification_error_reasons)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        """
        certificate ID for TLS handshaking
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> str:
        """
        name of certificate required for TLS handshaking
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> bool:
        """
        flag indicating if domain is managed by DigitalOcean
        """
        return pulumi.get(self, "is_managed")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of load balancer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sslValidationErrorReasons")
    def ssl_validation_error_reasons(self) -> Sequence[str]:
        """
        list of domain SSL validation errors
        """
        return pulumi.get(self, "ssl_validation_error_reasons")

    @property
    @pulumi.getter(name="verificationErrorReasons")
    def verification_error_reasons(self) -> Sequence[str]:
        """
        list of domain verification errors
        """
        return pulumi.get(self, "verification_error_reasons")


@pulumi.output_type
class GetLoadBalancerFirewallResult(dict):
    def __init__(__self__, *,
                 allows: Sequence[str],
                 denies: Sequence[str]):
        """
        :param Sequence[str] allows: the rules for ALLOWING traffic to the LB (strings in the form: 'ip:1.2.3.4' or 'cidr:1.2.0.0/16')
        :param Sequence[str] denies: the rules for DENYING traffic to the LB (strings in the form: 'ip:1.2.3.4' or 'cidr:1.2.0.0/16')
        """
        pulumi.set(__self__, "allows", allows)
        pulumi.set(__self__, "denies", denies)

    @property
    @pulumi.getter
    def allows(self) -> Sequence[str]:
        """
        the rules for ALLOWING traffic to the LB (strings in the form: 'ip:1.2.3.4' or 'cidr:1.2.0.0/16')
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter
    def denies(self) -> Sequence[str]:
        """
        the rules for DENYING traffic to the LB (strings in the form: 'ip:1.2.3.4' or 'cidr:1.2.0.0/16')
        """
        return pulumi.get(self, "denies")


@pulumi.output_type
class GetLoadBalancerForwardingRuleResult(dict):
    def __init__(__self__, *,
                 certificate_id: str,
                 certificate_name: str,
                 entry_port: int,
                 entry_protocol: str,
                 target_port: int,
                 target_protocol: str,
                 tls_passthrough: bool):
        """
        :param str certificate_id: the id of the tls certificate used for ssl termination if enabled
        :param str certificate_name: the name of the tls certificate used for ssl termination if enabled
        :param int entry_port: the port on which the load balancer instance will listen
        :param str entry_protocol: the protocol used for traffic to the load balancer
        :param int target_port: the port on the backend Droplets to which the load balancer will send traffic
        :param str target_protocol: the protocol used for traffic to the backend droplets
        :param bool tls_passthrough: whether ssl encrypted traffic will be passed through to the backend droplets
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "entry_port", entry_port)
        pulumi.set(__self__, "entry_protocol", entry_protocol)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "target_protocol", target_protocol)
        pulumi.set(__self__, "tls_passthrough", tls_passthrough)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        """
        the id of the tls certificate used for ssl termination if enabled
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> str:
        """
        the name of the tls certificate used for ssl termination if enabled
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="entryPort")
    def entry_port(self) -> int:
        """
        the port on which the load balancer instance will listen
        """
        return pulumi.get(self, "entry_port")

    @property
    @pulumi.getter(name="entryProtocol")
    def entry_protocol(self) -> str:
        """
        the protocol used for traffic to the load balancer
        """
        return pulumi.get(self, "entry_protocol")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        """
        the port on the backend Droplets to which the load balancer will send traffic
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        the protocol used for traffic to the backend droplets
        """
        return pulumi.get(self, "target_protocol")

    @property
    @pulumi.getter(name="tlsPassthrough")
    def tls_passthrough(self) -> bool:
        """
        whether ssl encrypted traffic will be passed through to the backend droplets
        """
        return pulumi.get(self, "tls_passthrough")


@pulumi.output_type
class GetLoadBalancerGlbSettingResult(dict):
    def __init__(__self__, *,
                 cdns: Sequence['outputs.GetLoadBalancerGlbSettingCdnResult'],
                 failover_threshold: int,
                 region_priorities: Mapping[str, int],
                 target_port: int,
                 target_protocol: str):
        """
        :param Sequence['GetLoadBalancerGlbSettingCdnArgs'] cdns: CDN specific configurations
        :param int failover_threshold: fail-over threshold
        :param Mapping[str, int] region_priorities: region priority map
        :param int target_port: target port rules
        :param str target_protocol: target protocol rules
        """
        pulumi.set(__self__, "cdns", cdns)
        pulumi.set(__self__, "failover_threshold", failover_threshold)
        pulumi.set(__self__, "region_priorities", region_priorities)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "target_protocol", target_protocol)

    @property
    @pulumi.getter
    def cdns(self) -> Sequence['outputs.GetLoadBalancerGlbSettingCdnResult']:
        """
        CDN specific configurations
        """
        return pulumi.get(self, "cdns")

    @property
    @pulumi.getter(name="failoverThreshold")
    def failover_threshold(self) -> int:
        """
        fail-over threshold
        """
        return pulumi.get(self, "failover_threshold")

    @property
    @pulumi.getter(name="regionPriorities")
    def region_priorities(self) -> Mapping[str, int]:
        """
        region priority map
        """
        return pulumi.get(self, "region_priorities")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        """
        target port rules
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        target protocol rules
        """
        return pulumi.get(self, "target_protocol")


@pulumi.output_type
class GetLoadBalancerGlbSettingCdnResult(dict):
    def __init__(__self__, *,
                 is_enabled: bool):
        """
        :param bool is_enabled: cache enable flag
        """
        pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        cache enable flag
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetLoadBalancerHealthcheckResult(dict):
    def __init__(__self__, *,
                 check_interval_seconds: int,
                 healthy_threshold: int,
                 path: str,
                 port: int,
                 protocol: str,
                 response_timeout_seconds: int,
                 unhealthy_threshold: int):
        """
        :param int check_interval_seconds: the number of seconds between between two consecutive health checks
        :param int healthy_threshold: the number of times a health check must pass for a backend droplet to be marked 'healthy' and be re-added to the pool
        :param str path: the path on the backend Droplets to which the Load Balancer will send a request
        :param int port: the port on the backend droplets on which the health check will attempt a connection
        :param str protocol: the protocol used for health checks sent to the backend droplets
        :param int response_timeout_seconds: the number of seconds to wait for a response until marking a health check as failed
        :param int unhealthy_threshold: The number of times a health check must fail for a backend droplet to be marked 'unhealthy' and be removed from the pool
        """
        pulumi.set(__self__, "check_interval_seconds", check_interval_seconds)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "response_timeout_seconds", response_timeout_seconds)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="checkIntervalSeconds")
    def check_interval_seconds(self) -> int:
        """
        the number of seconds between between two consecutive health checks
        """
        return pulumi.get(self, "check_interval_seconds")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        """
        the number of times a health check must pass for a backend droplet to be marked 'healthy' and be re-added to the pool
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        the path on the backend Droplets to which the Load Balancer will send a request
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        the port on the backend droplets on which the health check will attempt a connection
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        the protocol used for health checks sent to the backend droplets
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="responseTimeoutSeconds")
    def response_timeout_seconds(self) -> int:
        """
        the number of seconds to wait for a response until marking a health check as failed
        """
        return pulumi.get(self, "response_timeout_seconds")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> int:
        """
        The number of times a health check must fail for a backend droplet to be marked 'unhealthy' and be removed from the pool
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetLoadBalancerStickySessionResult(dict):
    def __init__(__self__, *,
                 cookie_name: str,
                 cookie_ttl_seconds: int,
                 type: str):
        """
        :param str cookie_name: the name of the cookie sent to the client
        :param int cookie_ttl_seconds: the number of seconds until the cookie set by the Load Balancer expires
        :param str type: how and if requests from a client will be persistently served by the same backend droplet
        """
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "cookie_ttl_seconds", cookie_ttl_seconds)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> str:
        """
        the name of the cookie sent to the client
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="cookieTtlSeconds")
    def cookie_ttl_seconds(self) -> int:
        """
        the number of seconds until the cookie set by the Load Balancer expires
        """
        return pulumi.get(self, "cookie_ttl_seconds")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        how and if requests from a client will be persistently served by the same backend droplet
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProjectsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the projects by this key. This may be one of `name`,
               `purpose`, `description`, `environment`, or `is_default`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves projects
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the projects by this key. This may be one of `name`,
        `purpose`, `description`, `environment`, or `is_default`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves projects
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 description: str,
                 environment: str,
                 id: str,
                 is_default: bool,
                 name: str,
                 owner_id: int,
                 owner_uuid: str,
                 purpose: str,
                 resources: Sequence[str],
                 updated_at: str):
        """
        :param str created_at: The date and time when the project was created, (ISO8601)
        :param str description: The description of the project
        :param str environment: The environment of the project's resources. The possible values are: `Development`, `Staging`, `Production`.
        :param str id: The ID of the project
        :param str name: The name of the project
        :param int owner_id: The ID of the project owner
        :param str owner_uuid: The unique universal identifier of the project owner
        :param str purpose: The purpose of the project (Default: "Web Application")
        :param Sequence[str] resources: A set of uniform resource names (URNs) for the resources associated with the project
        :param str updated_at: The date and time when the project was last updated, (ISO8601)
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "owner_uuid", owner_uuid)
        pulumi.set(__self__, "purpose", purpose)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date and time when the project was created, (ISO8601)
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the project
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> str:
        """
        The environment of the project's resources. The possible values are: `Development`, `Staging`, `Production`.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the project
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> int:
        """
        The ID of the project owner
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="ownerUuid")
    def owner_uuid(self) -> str:
        """
        The unique universal identifier of the project owner
        """
        return pulumi.get(self, "owner_uuid")

    @property
    @pulumi.getter
    def purpose(self) -> str:
        """
        The purpose of the project (Default: "Web Application")
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        A set of uniform resource names (URNs) for the resources associated with the project
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The date and time when the project was last updated, (ISO8601)
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetProjectsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the projects by this key. This may be one of `name`,
               `purpose`, `description`, or `environment`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the projects by this key. This may be one of `name`,
        `purpose`, `description`, or `environment`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetRecordsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
               `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves DNS records
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
        `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves DNS records
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetRecordsRecordResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 flags: int,
                 id: int,
                 name: str,
                 port: int,
                 priority: int,
                 tag: str,
                 ttl: int,
                 type: str,
                 value: str,
                 weight: int):
        """
        :param str domain: The domain name to search for DNS records
        :param int flags: An unsigned integer between 0-255 used for CAA records.
        :param int id: The ID of the record.
        :param str name: The name of the DNS record.
        :param int port: The port for SRV records.
        :param int priority: The priority for SRV and MX records.
        :param str tag: The parameter tag for CAA records.
        :param int ttl: This value is the time to live for the record, in seconds. This defines the time frame that clients can cache queried information before a refresh should be requested.
        :param str type: The type of the DNS record.
        :param str value: Variable data depending on record type. For example, the "data" value for an A record would be the IPv4 address to which the domain will be mapped. For a CAA record, it would contain the domain name of the CA being granted permission to issue certificates.
        :param int weight: The weight for SRV records.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name to search for DNS records
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def flags(self) -> int:
        """
        An unsigned integer between 0-255 used for CAA records.
        """
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the record.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the DNS record.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port for SRV records.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority for SRV and MX records.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        The parameter tag for CAA records.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        This value is the time to live for the record, in seconds. This defines the time frame that clients can cache queried information before a refresh should be requested.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DNS record.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Variable data depending on record type. For example, the "data" value for an A record would be the IPv4 address to which the domain will be mapped. For a CAA record, it would contain the domain name of the CA being granted permission to issue certificates.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight for SRV records.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetRecordsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
               `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
        `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetRegionsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the regions by this key. This may be one of `slug`,
               `name`, `available`, `features`, or `sizes`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves regions
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the regions by this key. This may be one of `slug`,
        `name`, `available`, `features`, or `sizes`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves regions
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetRegionsRegionResult(dict):
    def __init__(__self__, *,
                 available: bool,
                 features: Sequence[str],
                 name: str,
                 sizes: Sequence[str],
                 slug: str):
        """
        :param bool available: A boolean value that represents whether new Droplets can be created in this region.
        :param Sequence[str] features: A set of features available in this region.
        :param str name: The display name of the region.
        :param Sequence[str] sizes: A set of identifying slugs for the Droplet sizes available in this region.
        :param str slug: A human-readable string that is used as a unique identifier for each region.
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sizes", sizes)
        pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter
    def available(self) -> bool:
        """
        A boolean value that represents whether new Droplets can be created in this region.
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def features(self) -> Sequence[str]:
        """
        A set of features available in this region.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The display name of the region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sizes(self) -> Sequence[str]:
        """
        A set of identifying slugs for the Droplet sizes available in this region.
        """
        return pulumi.get(self, "sizes")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        A human-readable string that is used as a unique identifier for each region.
        """
        return pulumi.get(self, "slug")


@pulumi.output_type
class GetRegionsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the regions by this key. This may be one of `slug`,
               `name`, or `available`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the regions by this key. This may be one of `slug`,
        `name`, or `available`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSizesFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the sizes by this key. This may be one of `slug`,
               `regions`, `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`,
               `price_hourly`, or `available`.
        :param Sequence[str] values: Only retrieves sizes which keys has value that matches
               one of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the sizes by this key. This may be one of `slug`,
        `regions`, `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`,
        `price_hourly`, or `available`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Only retrieves sizes which keys has value that matches
        one of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetSizesSizeResult(dict):
    def __init__(__self__, *,
                 available: bool,
                 disk: int,
                 memory: int,
                 price_hourly: float,
                 price_monthly: float,
                 regions: Sequence[str],
                 slug: str,
                 transfer: float,
                 vcpus: int):
        """
        :param bool available: This represents whether new Droplets can be created with this size.
        :param int disk: The amount of disk space set aside for Droplets of this size. The value is measured in gigabytes.
        :param int memory: The amount of RAM allocated to Droplets created of this size. The value is measured in megabytes.
        :param float price_hourly: The hourly cost of Droplets created in this size as measured hourly. The value is measured in US dollars.
        :param float price_monthly: The monthly cost of Droplets created in this size if they are kept for an entire month. The value is measured in US dollars.
        :param Sequence[str] regions: List of region slugs where Droplets can be created in this size.
        :param str slug: A human-readable string that is used to uniquely identify each size.
        :param float transfer: The amount of transfer bandwidth that is available for Droplets created in this size. This only counts traffic on the public interface. The value is given in terabytes.
        :param int vcpus: The number of CPUs allocated to Droplets of this size.
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "price_hourly", price_hourly)
        pulumi.set(__self__, "price_monthly", price_monthly)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "slug", slug)
        pulumi.set(__self__, "transfer", transfer)
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter
    def available(self) -> bool:
        """
        This represents whether new Droplets can be created with this size.
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def disk(self) -> int:
        """
        The amount of disk space set aside for Droplets of this size. The value is measured in gigabytes.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The amount of RAM allocated to Droplets created of this size. The value is measured in megabytes.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> float:
        """
        The hourly cost of Droplets created in this size as measured hourly. The value is measured in US dollars.
        """
        return pulumi.get(self, "price_hourly")

    @property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> float:
        """
        The monthly cost of Droplets created in this size if they are kept for an entire month. The value is measured in US dollars.
        """
        return pulumi.get(self, "price_monthly")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        """
        List of region slugs where Droplets can be created in this size.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        A human-readable string that is used to uniquely identify each size.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def transfer(self) -> float:
        """
        The amount of transfer bandwidth that is available for Droplets created in this size. This only counts traffic on the public interface. The value is given in terabytes.
        """
        return pulumi.get(self, "transfer")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        The number of CPUs allocated to Droplets of this size.
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetSizesSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the sizes by this key. This may be one of `slug`,
               `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`, or `price_hourly`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the sizes by this key. This may be one of `slug`,
        `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`, or `price_hourly`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSpacesBucketsBucketResult(dict):
    def __init__(__self__, *,
                 bucket_domain_name: str,
                 endpoint: str,
                 name: str,
                 region: str,
                 urn: str):
        """
        :param str bucket_domain_name: The FQDN of the bucket (e.g. bucket-name.nyc3.digitaloceanspaces.com)
        :param str endpoint: The FQDN of the bucket without the bucket name (e.g. nyc3.digitaloceanspaces.com)
        :param str name: The name of the Spaces bucket
        :param str region: The slug of the region where the bucket is stored.
        :param str urn: The uniform resource name of the bucket
        """
        pulumi.set(__self__, "bucket_domain_name", bucket_domain_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> str:
        """
        The FQDN of the bucket (e.g. bucket-name.nyc3.digitaloceanspaces.com)
        """
        return pulumi.get(self, "bucket_domain_name")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The FQDN of the bucket without the bucket name (e.g. nyc3.digitaloceanspaces.com)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Spaces bucket
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The slug of the region where the bucket is stored.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def urn(self) -> str:
        """
        The uniform resource name of the bucket
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetSpacesBucketsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves Spaces buckets
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves Spaces buckets
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetSpacesBucketsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSshKeysFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        :param Sequence[str] values: A list of values to match against the key field. Only retrieves SSH keys where the key field matches one or more of the values provided here.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the key field. Only retrieves SSH keys where the key field matches one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetSshKeysSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSshKeysSshKeyResult(dict):
    def __init__(__self__, *,
                 fingerprint: str,
                 id: int,
                 name: str,
                 public_key: str):
        """
        :param str fingerprint: The fingerprint of the public key of the ssh key.
        :param int id: The ID of the ssh key.
        :param str name: The name of the ssh key.
        :param str public_key: The public key of the ssh key.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        The fingerprint of the public key of the ssh key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the ssh key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the ssh key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The public key of the ssh key.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetTagsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        :param Sequence[str] values: Only retrieves tags which keys has value that matches
               one of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Only retrieves tags which keys has value that matches
        one of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetTagsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetTagsTagResult(dict):
    def __init__(__self__, *,
                 databases_count: int,
                 droplets_count: int,
                 images_count: int,
                 name: str,
                 total_resource_count: int,
                 volume_snapshots_count: int,
                 volumes_count: int):
        """
        :param int databases_count: A count of the database clusters that the tag is applied to.
        :param int droplets_count: A count of the Droplets the tag is applied to.
        :param int images_count: A count of the images that the tag is applied to.
        :param str name: The name of the tag.
        :param int total_resource_count: A count of the total number of resources that the tag is applied to.
        :param int volume_snapshots_count: A count of the volume snapshots that the tag is applied to.
        :param int volumes_count: A count of the volumes that the tag is applied to.
        """
        pulumi.set(__self__, "databases_count", databases_count)
        pulumi.set(__self__, "droplets_count", droplets_count)
        pulumi.set(__self__, "images_count", images_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "total_resource_count", total_resource_count)
        pulumi.set(__self__, "volume_snapshots_count", volume_snapshots_count)
        pulumi.set(__self__, "volumes_count", volumes_count)

    @property
    @pulumi.getter(name="databasesCount")
    def databases_count(self) -> int:
        """
        A count of the database clusters that the tag is applied to.
        """
        return pulumi.get(self, "databases_count")

    @property
    @pulumi.getter(name="dropletsCount")
    def droplets_count(self) -> int:
        """
        A count of the Droplets the tag is applied to.
        """
        return pulumi.get(self, "droplets_count")

    @property
    @pulumi.getter(name="imagesCount")
    def images_count(self) -> int:
        """
        A count of the images that the tag is applied to.
        """
        return pulumi.get(self, "images_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="totalResourceCount")
    def total_resource_count(self) -> int:
        """
        A count of the total number of resources that the tag is applied to.
        """
        return pulumi.get(self, "total_resource_count")

    @property
    @pulumi.getter(name="volumeSnapshotsCount")
    def volume_snapshots_count(self) -> int:
        """
        A count of the volume snapshots that the tag is applied to.
        """
        return pulumi.get(self, "volume_snapshots_count")

    @property
    @pulumi.getter(name="volumesCount")
    def volumes_count(self) -> int:
        """
        A count of the volumes that the tag is applied to.
        """
        return pulumi.get(self, "volumes_count")


