from __future__ import annotations

import logging
from dataclasses import dataclass

from griptape_nodes.retained_mode.managers.fitness_problems.workflows.workflow_problem import WorkflowProblem

logger = logging.getLogger(__name__)


@dataclass
class MissingCreationDateProblem(WorkflowProblem):
    """Problem indicating workflow metadata is missing a creation date.

    This is one-time only - should only occur once per workflow.
    """

    default_date: str

    @classmethod
    def collate_problems_for_display(cls, instances: list[MissingCreationDateProblem]) -> str:
        """Display missing creation date problem."""
        if len(instances) > 1:
            logger.error(
                "MissingCreationDateProblem received %d instances but should only receive 1. This indicates a logic error.",
                len(instances),
            )

        problem = instances[0]
        return f"Missing creation date. Defaulting to {problem.default_date}. Will be replaced on next save."
