import argparse
from .watcher import start_watcher

def main():
    parser = argparse.ArgumentParser(
        description="watch a folder and update Rojo project JSON automatically"
    )
    parser.add_argument("--src", default="src", help="the folder to watch (default: src)")
    parser.add_argument("--project", default="default.project.json", help="Rojo project file path")
    args = parser.parse_args()

    start_watcher(args.src, args.project)

if __name__ == "__main__":
    main()