from typing import Final

from syndb_constants.table import SyndbTable, syndb_table_name_to_enum

ID_COLUMN_NAME: Final[str] = "cid"
DATASET_ID_COLUMN_NAME: Final[str] = "dataset_id"
PARENT_ID_COLUMN_NAME: Final[str] = "parent_id"
PARENT_ENUM_COLUMN_NAME: Final[str] = "parent_enum"

DB_TABLE_NAME_TO_SCHEMA: Final[dict[str, dict[str, str]]] = {
    "neuron": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "polarity": "ascii",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "s3_swb_location": "smallint",
    },
    "axon": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "terminal_count": "int",
        "mitochondria_count": "int",
        "total_mitochondria_volume": "double",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "s3_swb_location": "smallint",
        "parent_id": "uuid",
        "parent_enum": "int",
        "neuron_id": "uuid",
    },
    "pre_synaptic_terminal": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "vesicle_count": "int",
        "total_vesicle_volume": "double",
        "mitochondria_count": "int",
        "total_mitochondria_volume": "double",
        "forms_synapse_with": "uuid",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "parent_id": "uuid",
        "parent_enum": "int",
        "neuron_id": "uuid",
    },
    "synapse": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "connection_score": "double",
        "cleft_score": "int",
        "GABA": "double",
        "acetylcholine": "double",
        "glutamate": "double",
        "octopamine": "double",
        "serine": "double",
        "dopamine": "double",
        "cave_id": "int",
        "pre_id": "uuid",
        "post_id": "uuid",
    },
    "dendritic_spine": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "forms_synapse_with": "uuid",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "parent_id": "uuid",
        "parent_enum": "int",
        "neuron_id": "uuid",
    },
    "dendrite": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "dendritic_spine_count": "int",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "s3_swb_location": "smallint",
        "parent_id": "uuid",
        "parent_enum": "int",
        "neuron_id": "uuid",
    },
    "mitochondria": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "parent_id": "uuid",
        "parent_enum": "int",
        "neuron_id": "uuid",
    },
    "vesicle": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "neurotransmitter": "ascii",
        "distance_to_active_zone": "double",
        "minimum_normal_length": "int",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "parent_id": "uuid",
        "parent_enum": "int",
        "neuron_id": "uuid",
    },
    "endoplasmic_reticulum": {
        "dataset_id": "uuid",
        "cid": "uuid",
        "ribosome_count": "int",
        "voxel_volume": "double",
        "voxel_radius": "double",
        "s3_mesh_location": "smallint",
        "mesh_volume": "double",
        "mesh_surface_area": "double",
        "mesh_area_volume_ratio": "double",
        "mesh_sphericity": "double",
        "centroid_z": "double",
        "centroid_x": "double",
        "centroid_y": "double",
        "parent_id": "uuid",
        "parent_enum": "int",
        "neuron_id": "uuid",
    },
}

SYNDB_TABLE_TO_SCHEMA: Final[dict[SyndbTable, dict[str, str]]] = {
    syndb_table_name_to_enum[k]: v for k, v in DB_TABLE_NAME_TO_SCHEMA.items()
}
