# Generated by Django 4.0.10 on 2023-04-17 00:47

import multiselectfield.db.fields

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("eveuniverse", "0007_evetype_description"),
        ("authentication", "0020_userprofile_language_userprofile_night_mode"),
        ("auth", "0012_alter_user_first_name_max_length"),
        ("eveonline", "0017_alliance_and_corp_names_are_not_unique"),
        ("structures", "0002_remove_eveuniverse_relation_names"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="fuelalert",
            options={
                "verbose_name": "structure fuel alert",
                "verbose_name_plural": "structure fuel alerts",
            },
        ),
        migrations.AlterModelOptions(
            name="fuelalertconfig",
            options={
                "verbose_name": "structure fuel alert config",
                "verbose_name_plural": "structure fuel alert configs",
            },
        ),
        migrations.AlterModelOptions(
            name="generatednotification",
            options={
                "verbose_name": "generated notification",
                "verbose_name_plural": "generated  notifications",
            },
        ),
        migrations.AlterModelOptions(
            name="jumpfuelalert",
            options={
                "verbose_name": "jump fuel alert",
                "verbose_name_plural": "jump fuel alerts",
            },
        ),
        migrations.AlterModelOptions(
            name="jumpfuelalertconfig",
            options={
                "verbose_name": "jump fuel alert config",
                "verbose_name_plural": "jump fuel alert configs",
            },
        ),
        migrations.AlterModelOptions(
            name="notification",
            options={
                "verbose_name": "eve notification",
                "verbose_name_plural": "eve notifications",
            },
        ),
        migrations.AlterModelOptions(
            name="owner",
            options={"verbose_name": "owner", "verbose_name_plural": "owners"},
        ),
        migrations.AlterModelOptions(
            name="ownercharacter",
            options={
                "verbose_name": "owner character",
                "verbose_name_plural": "owner characters",
            },
        ),
        migrations.AlterModelOptions(
            name="structure",
            options={"verbose_name": "structure", "verbose_name_plural": "structures"},
        ),
        migrations.AlterModelOptions(
            name="structureitem",
            options={
                "verbose_name": "structure item",
                "verbose_name_plural": "structure items",
            },
        ),
        migrations.AlterModelOptions(
            name="structureservice",
            options={
                "verbose_name": "structure service",
                "verbose_name_plural": "structure services",
            },
        ),
        migrations.AlterModelOptions(
            name="structuretag",
            options={
                "ordering": ["order", "name"],
                "verbose_name": "structure tag",
                "verbose_name_plural": "structure tags",
            },
        ),
        migrations.AlterModelOptions(
            name="webhook",
            options={"verbose_name": "webhook", "verbose_name_plural": "webhooks"},
        ),
        migrations.AlterField(
            model_name="fuelalert",
            name="config",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="structure_fuel_alerts",
                to="structures.fuelalertconfig",
                verbose_name="configuration",
            ),
        ),
        migrations.AlterField(
            model_name="fuelalert",
            name="hours",
            field=models.PositiveIntegerField(
                db_index=True,
                help_text="number of hours before fuel expiration this alert was sent",
                verbose_name="hours",
            ),
        ),
        migrations.AlterField(
            model_name="fuelalert",
            name="structure",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="structure_fuel_alerts",
                to="structures.structure",
                verbose_name="structure",
            ),
        ),
        migrations.AlterField(
            model_name="fuelalertconfig",
            name="color",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (14242639, "danger"),
                    (6013150, "info"),
                    (6076508, "success"),
                    (15773006, "warning"),
                ],
                default=15773006,
                help_text="Context color of these notification on Discord",
                null=True,
                verbose_name="color",
            ),
        ),
        migrations.AlterField(
            model_name="fuelalertconfig",
            name="end",
            field=models.PositiveIntegerField(
                help_text="End of alerts in hours before fuel expires",
                verbose_name="end",
            ),
        ),
        migrations.AlterField(
            model_name="fuelalertconfig",
            name="is_enabled",
            field=models.BooleanField(
                default=True,
                help_text="Disabled configurations will not create any new alerts.",
                verbose_name="is_enabled",
            ),
        ),
        migrations.AlterField(
            model_name="fuelalertconfig",
            name="repeat",
            field=models.PositiveIntegerField(
                help_text="Notifications will be repeated every x hours. Set to 0 for no repeats",
                verbose_name="repeat",
            ),
        ),
        migrations.AlterField(
            model_name="fuelalertconfig",
            name="start",
            field=models.PositiveIntegerField(
                help_text="Start of alerts in hours before fuel expires",
                verbose_name="start",
            ),
        ),
        migrations.AlterField(
            model_name="generatednotification",
            name="details",
            field=models.JSONField(default=dict, verbose_name="details"),
        ),
        migrations.AlterField(
            model_name="generatednotification",
            name="is_sent",
            field=models.BooleanField(
                default=False,
                help_text="True when this notification has been forwarded to Discord",
                verbose_name="is sent",
            ),
        ),
        migrations.AlterField(
            model_name="generatednotification",
            name="is_timer_added",
            field=models.BooleanField(
                default=False,
                help_text="True when a timer has been added for this notification",
                null=True,
                verbose_name="is timer added",
            ),
        ),
        migrations.AlterField(
            model_name="generatednotification",
            name="last_updated",
            field=models.DateTimeField(auto_now=True, verbose_name="last_updated"),
        ),
        migrations.AlterField(
            model_name="generatednotification",
            name="owner",
            field=models.ForeignKey(
                help_text="Corporation that owns this notification",
                on_delete=django.db.models.deletion.CASCADE,
                to="structures.owner",
                verbose_name="owner",
            ),
        ),
        migrations.AlterField(
            model_name="generatednotification",
            name="structures",
            field=models.ManyToManyField(
                help_text="Structures this notification is about (if any)",
                to="structures.structure",
                verbose_name="structures",
            ),
        ),
        migrations.AlterField(
            model_name="generatednotification",
            name="timestamp",
            field=models.DateTimeField(auto_now_add=True, verbose_name="timestamp"),
        ),
        migrations.AlterField(
            model_name="jumpfuelalert",
            name="config",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="jump_fuel_alerts",
                to="structures.jumpfuelalertconfig",
                verbose_name="configuration",
            ),
        ),
        migrations.AlterField(
            model_name="jumpfuelalert",
            name="structure",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="jump_fuel_alerts",
                to="structures.structure",
                verbose_name="structure",
            ),
        ),
        migrations.AlterField(
            model_name="jumpfuelalertconfig",
            name="color",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (14242639, "danger"),
                    (6013150, "info"),
                    (6076508, "success"),
                    (15773006, "warning"),
                ],
                default=15773006,
                help_text="Context color of these notification on Discord",
                null=True,
                verbose_name="color",
            ),
        ),
        migrations.AlterField(
            model_name="jumpfuelalertconfig",
            name="is_enabled",
            field=models.BooleanField(
                default=True,
                help_text="Disabled configurations will not create any new alerts.",
                verbose_name="is_enabled",
            ),
        ),
        migrations.AlterField(
            model_name="jumpfuelalertconfig",
            name="threshold",
            field=models.PositiveIntegerField(
                help_text="Notifications will be sent once fuel level in units reaches this threshold",
                verbose_name="threshold",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="created",
            field=models.DateTimeField(
                default=None,
                help_text="Date when this notification was first received from ESI",
                null=True,
                verbose_name="created",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_read",
            field=models.BooleanField(
                default=None,
                help_text="True when this notification has read in the eve client",
                null=True,
                verbose_name="is read",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_sent",
            field=models.BooleanField(
                default=False,
                help_text="True when this notification has been forwarded to Discord",
                verbose_name="is sent",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_timer_added",
            field=models.BooleanField(
                default=False,
                help_text="True when a timer has been added for this notification",
                null=True,
                verbose_name="is timer added",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="last_updated",
            field=models.DateTimeField(
                help_text="Date when this notification has last been updated from ESI",
                verbose_name="last updated",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="owner",
            field=models.ForeignKey(
                help_text="Corporation that owns this notification",
                on_delete=django.db.models.deletion.CASCADE,
                to="structures.owner",
                verbose_name="owner",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="sender",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="eveuniverse.eveentity",
                verbose_name="sender",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="structures",
            field=models.ManyToManyField(
                help_text="Structures this notification is about (if any)",
                to="structures.structure",
                verbose_name="structures",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="text",
            field=models.TextField(
                blank=True,
                default=None,
                help_text="Notification details in YAML",
                null=True,
                verbose_name="text",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="timestamp",
            field=models.DateTimeField(db_index=True, verbose_name="timestamp"),
        ),
        migrations.AlterField(
            model_name="owner",
            name="are_pocos_public",
            field=models.BooleanField(
                default=False,
                help_text="whether pocos of this owner are shown on public POCO page",
                verbose_name="are pocos public",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="assets_last_update_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="when the last successful update happened",
                null=True,
                verbose_name="assets last update at",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="corporation",
            field=models.OneToOneField(
                help_text="Corporation owning structures",
                on_delete=django.db.models.deletion.CASCADE,
                primary_key=True,
                related_name="structure_owner",
                serialize=False,
                to="eveonline.evecorporationinfo",
                verbose_name="corporation",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="forwarding_last_update_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="when the last successful update happened",
                null=True,
                verbose_name="forwarding last update at",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="has_default_pings_enabled",
            field=models.BooleanField(
                default=True,
                help_text="to enable or disable pinging of notifications for this owner e.g. with @everyone and @here",
                verbose_name="has default pings enabled",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="is_active",
            field=models.BooleanField(
                default=True,
                help_text="whether this owner is currently included in the sync process",
                verbose_name="is active",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="is_alliance_main",
            field=models.BooleanField(
                default=False,
                help_text="whether alliance wide notifications are forwarded for this owner (e.g. sov notifications)",
                verbose_name="is alliance main",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="is_included_in_service_status",
            field=models.BooleanField(
                default=True,
                help_text="whether the sync status of this owner is included in the overall status of this services",
                verbose_name="is included in service status",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="is_up",
            field=models.BooleanField(
                default=None,
                editable=False,
                help_text="whether all services for this owner are currently up",
                null=True,
                verbose_name="is up",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="notifications_last_update_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="when the last successful update happened",
                null=True,
                verbose_name="notifications last update at",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="ping_groups",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Groups to be pinged for each notification. ",
                related_name="+",
                to="auth.group",
                verbose_name="ping groups",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="structures_last_update_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="when the last successful update happened",
                null=True,
                verbose_name="structures last update at",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="webhooks",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Notifications are sent to these webhooks.",
                related_name="owners",
                to="structures.webhook",
                verbose_name="webhooks",
            ),
        ),
        migrations.AlterField(
            model_name="ownercharacter",
            name="character_ownership",
            field=models.ForeignKey(
                help_text="character used for syncing",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="authentication.characterownership",
                verbose_name="character_ownership",
            ),
        ),
        migrations.AlterField(
            model_name="ownercharacter",
            name="error_count",
            field=models.PositiveIntegerField(
                default=0,
                editable=False,
                help_text="Count of ESI errors which happened with this character.",
                verbose_name="error count",
            ),
        ),
        migrations.AlterField(
            model_name="ownercharacter",
            name="notifications_last_used_at",
            field=models.DateTimeField(
                db_index=True,
                default=None,
                editable=False,
                help_text="when this character was last used for syncing notifications",
                null=True,
                verbose_name="notifications last used at",
            ),
        ),
        migrations.AlterField(
            model_name="ownercharacter",
            name="owner",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="characters",
                to="structures.owner",
                verbose_name="owner",
            ),
        ),
        migrations.AlterField(
            model_name="ownercharacter",
            name="structures_last_used_at",
            field=models.DateTimeField(
                db_index=True,
                default=None,
                editable=False,
                help_text="when this character was last used for syncing structures",
                null=True,
                verbose_name="structures last used at",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="created_at",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="date this structure was received from ESI for the first time",
                verbose_name="created at",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="eve_moon",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Moon next to this structure - if any",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="eveuniverse.evemoon",
                verbose_name="moon",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="eve_planet",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Planet next to this structure - if any",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="eveuniverse.eveplanet",
                verbose_name="planet",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="eve_solar_system",
            field=models.ForeignKey(
                help_text="Solar System the structure is located",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="eveuniverse.evesolarsystem",
                verbose_name="solar system",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="eve_type",
            field=models.ForeignKey(
                help_text="Type of the structure",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="eveuniverse.evetype",
                verbose_name="type",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="fuel_expires_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="Date on which the structure will run out of fuel",
                null=True,
                verbose_name="fuel expires at",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="has_core",
            field=models.BooleanField(
                blank=True,
                db_index=True,
                default=None,
                help_text="bool indicating if the structure has a quantum core",
                null=True,
                verbose_name="has core",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="has_fitting",
            field=models.BooleanField(
                blank=True,
                db_index=True,
                default=None,
                help_text="bool indicating if the structure has a fitting",
                null=True,
                verbose_name="has fitting",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="id",
            field=models.BigIntegerField(
                help_text="The Item ID of the structure",
                primary_key=True,
                serialize=False,
                verbose_name="id",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="last_online_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="date this structure had any of it's services online",
                null=True,
                verbose_name="last online at",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="last_updated_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="date this structure was last updated from the EVE server",
                null=True,
                verbose_name="last updated at",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="name",
            field=models.CharField(
                help_text="The full name of the structure",
                max_length=255,
                verbose_name="name",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="next_reinforce_apply",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="The requested change to reinforce_hour that will take effect at the time shown by next_reinforce_apply",
                null=True,
                verbose_name="next reinforce apply",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="next_reinforce_hour",
            field=models.PositiveIntegerField(
                blank=True,
                default=None,
                help_text="The requested change to reinforce_hour that will take effect at the time shown by next_reinforce_apply",
                null=True,
                validators=[django.core.validators.MaxValueValidator(23)],
                verbose_name="next reinforce hour",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="owner",
            field=models.ForeignKey(
                help_text="Corporation that owns the structure",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="structures",
                to="structures.owner",
                verbose_name="owner",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="position_x",
            field=models.FloatField(
                blank=True,
                default=None,
                help_text="x position in the solar system",
                null=True,
                verbose_name="position x",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="position_y",
            field=models.FloatField(
                blank=True,
                default=None,
                help_text="y position in the solar system",
                null=True,
                verbose_name="position y",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="position_z",
            field=models.FloatField(
                blank=True,
                default=None,
                help_text="z position in the solar system",
                null=True,
                verbose_name="position z",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="reinforce_hour",
            field=models.PositiveIntegerField(
                blank=True,
                default=None,
                help_text="The average hour of day that determines the time +/- some hours when the structure will randomly exit its reinforcement periods and become vulnerable to attack against its armor and/or hull. ",
                null=True,
                validators=[django.core.validators.MaxValueValidator(23)],
                verbose_name="reinforce hour",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="state",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (1, "anchor vulnerable"),
                    (2, "anchoring"),
                    (3, "armor reinforce"),
                    (4, "armor vulnerable"),
                    (5, "deploy vulnerable"),
                    (6, "fitting invulnerable"),
                    (7, "hull reinforce"),
                    (8, "hull vulnerable"),
                    (9, "online deprecated"),
                    (10, "onlining vulnerable"),
                    (11, "shield vulnerable"),
                    (12, "unanchored"),
                    (21, "offline"),
                    (22, "online"),
                    (23, "onlining"),
                    (24, "reinforced"),
                    (25, "unanchoring "),
                    (0, "N/A"),
                    (13, "unknown"),
                ],
                default=13,
                help_text="Current state of the structure",
                verbose_name="state",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="state_timer_end",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="Date at which the structure entered it's current state",
                null=True,
                verbose_name="state timer end",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="state_timer_start",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="Date at which the structure will move to it's next state",
                null=True,
                verbose_name="state timer start",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="tags",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="List of tags for this structure. ",
                related_name="structures",
                to="structures.structuretag",
                verbose_name="tags",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="unanchors_at",
            field=models.DateTimeField(
                blank=True,
                default=None,
                help_text="Date at which the structure will unanchor",
                null=True,
                verbose_name="unanchors at",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="webhooks",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Webhooks for sending notifications to. If any webhook is enabled, these will be used instead of the webhooks defined for the respective owner. If no webhook is enabled the owner's setting will be used. ",
                related_name="structures",
                to="structures.webhook",
                verbose_name="webhooks",
            ),
        ),
        migrations.AlterField(
            model_name="structureitem",
            name="eve_type",
            field=models.ForeignKey(
                help_text="type of the item",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="eveuniverse.evetype",
                verbose_name="type",
            ),
        ),
        migrations.AlterField(
            model_name="structureitem",
            name="id",
            field=models.BigIntegerField(
                help_text="The Eve item ID",
                primary_key=True,
                serialize=False,
                verbose_name="id",
            ),
        ),
        migrations.AlterField(
            model_name="structureitem",
            name="is_singleton",
            field=models.BooleanField(verbose_name="is singleton"),
        ),
        migrations.AlterField(
            model_name="structureitem",
            name="last_updated_at",
            field=models.DateTimeField(auto_now=True, verbose_name="last updated at"),
        ),
        migrations.AlterField(
            model_name="structureitem",
            name="location_flag",
            field=models.CharField(max_length=255, verbose_name="location flag"),
        ),
        migrations.AlterField(
            model_name="structureitem",
            name="quantity",
            field=models.IntegerField(verbose_name="quantity"),
        ),
        migrations.AlterField(
            model_name="structureitem",
            name="structure",
            field=models.ForeignKey(
                help_text="Structure this item is located in",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="items",
                to="structures.structure",
                verbose_name="structure",
            ),
        ),
        migrations.AlterField(
            model_name="structureservice",
            name="name",
            field=models.CharField(
                help_text="Name of the service", max_length=100, verbose_name="name"
            ),
        ),
        migrations.AlterField(
            model_name="structureservice",
            name="state",
            field=models.IntegerField(
                choices=[(1, "offline"), (2, "online")],
                help_text="Current state of this service",
                verbose_name="state",
            ),
        ),
        migrations.AlterField(
            model_name="structureservice",
            name="structure",
            field=models.ForeignKey(
                help_text="Structure this service is installed to",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="services",
                to="structures.structure",
                verbose_name="structure",
            ),
        ),
        migrations.AlterField(
            model_name="structuretag",
            name="description",
            field=models.TextField(
                blank=True,
                default=None,
                help_text="description for this tag",
                null=True,
                verbose_name="description",
            ),
        ),
        migrations.AlterField(
            model_name="structuretag",
            name="is_default",
            field=models.BooleanField(
                default=False,
                help_text="if true this custom tag will automatically be added to new structures",
                verbose_name="is default",
            ),
        ),
        migrations.AlterField(
            model_name="structuretag",
            name="is_user_managed",
            field=models.BooleanField(
                default=True,
                help_text="if False this tag is created and managed by the system and can not be modified by users",
                verbose_name="is user managed",
            ),
        ),
        migrations.AlterField(
            model_name="structuretag",
            name="name",
            field=models.CharField(
                help_text="name of the tag - must be unique",
                max_length=255,
                unique=True,
                verbose_name="name",
            ),
        ),
        migrations.AlterField(
            model_name="structuretag",
            name="order",
            field=models.PositiveIntegerField(
                blank=True,
                default=100,
                help_text="number defining the order tags are shown. custom tags can not have an order below 100",
                validators=[django.core.validators.MinValueValidator(100)],
                verbose_name="order",
            ),
        ),
        migrations.AlterField(
            model_name="structuretag",
            name="style",
            field=models.CharField(
                blank=True,
                choices=[
                    ("default", "grey"),
                    ("primary", "dark blue"),
                    ("success", "green"),
                    ("info", "light blue"),
                    ("warning", "orange"),
                    ("danger", "red"),
                ],
                default="default",
                help_text="color style of tag",
                max_length=16,
                verbose_name="style",
            ),
        ),
        migrations.AlterField(
            model_name="webhook",
            name="has_default_pings_enabled",
            field=models.BooleanField(
                default=True,
                help_text="To enable or disable pinging of notifications for this webhook e.g. with @everyone and @here",
                verbose_name="has default pings enabled",
            ),
        ),
        migrations.AlterField(
            model_name="webhook",
            name="is_default",
            field=models.BooleanField(
                default=False,
                help_text="Whether owners have this webhook automatically pre-set when created",
                verbose_name="is default",
            ),
        ),
        migrations.AlterField(
            model_name="webhook",
            name="notification_types",
            field=multiselectfield.db.fields.MultiSelectField(
                choices=[
                    ("StructureAnchoring", "Upwell structure anchoring"),
                    ("StructureOnline", "Upwell structure went online"),
                    (
                        "StructureServicesOffline",
                        "Upwell structure services went offline",
                    ),
                    ("StructureWentHighPower", "Upwell structure went high power"),
                    ("StructureWentLowPower", "Upwell structure went low power"),
                    ("StructureUnanchoring", "Upwell structure unanchoring"),
                    ("StructureFuelAlert", "Upwell structure fuel alert"),
                    ("StructureRefueledExtra", "Upwell structure refueled"),
                    ("StructureJumpFuelAlert", "Upwell structure jump fuel alert"),
                    ("StructureUnderAttack", "Upwell structure is under attack"),
                    ("StructureLostShields", "Upwell structure lost shields"),
                    ("StructureLostArmor", "Upwell structure lost armor"),
                    ("StructureDestroyed", "Upwell structure destroyed"),
                    (
                        "StructuresReinforcementChanged",
                        "Upwell structure reinforcement time changed",
                    ),
                    ("OwnershipTransferred", "Upwell structure ownership transferred"),
                    ("OrbitalAttacked", "Customs office attacked"),
                    ("OrbitalReinforced", "Customs office reinforced"),
                    ("TowerAlertMsg", "Starbase attacked"),
                    ("TowerResourceAlertMsg", "Starbase fuel alert"),
                    ("TowerRefueledExtra", "Starbase refueled (BETA)"),
                    ("TowerReinforcedExtra", "Starbase reinforced (BETA)"),
                    ("MoonminingExtractionStarted", "Moon mining extraction started"),
                    ("MoonminingLaserFired", "Moonmining laser fired"),
                    (
                        "MoonminingExtractionCancelled",
                        "Moon mining extraction cancelled",
                    ),
                    ("MoonminingExtractionFinished", "Moon mining extraction finished"),
                    (
                        "MoonminingAutomaticFracture",
                        "Moon mining automatic fracture triggered",
                    ),
                    ("SovStructureReinforced", "Sovereignty structure reinforced"),
                    ("SovStructureDestroyed", "Sovereignty structure destroyed"),
                    ("EntosisCaptureStarted", "Sovereignty entosis capture started"),
                    (
                        "SovCommandNodeEventStarted",
                        "Sovereignty command node event started",
                    ),
                    ("SovAllClaimAquiredMsg", "Sovereignty claim acknowledgment"),
                    ("SovAllClaimLostMsg", "Sovereignty lost"),
                    ("AllAnchoringMsg", "Structure anchoring in alliance space"),
                    ("WarDeclared", "War declared"),
                    ("AllyJoinedWarAggressorMsg", "War ally joined aggressor"),
                    ("AllyJoinedWarAllyMsg", "War ally joined ally"),
                    ("AllyJoinedWarDefenderMsg", "War ally joined defender"),
                    ("WarAdopted", "War adopted"),
                    ("WarInherited", "War inherited"),
                    ("CorpWarSurrenderMsg", "War party surrendered"),
                    ("WarRetractedByConcord", "War retracted by Concord"),
                    ("CorpBecameWarEligible", "War corporation became eligible"),
                    ("CorpNoLongerWarEligible", "War corporation no longer eligible"),
                    ("WarSurrenderOfferMsg", "War surrender offered"),
                    ("CorpAppNewMsg", "Character submitted application"),
                    ("CorpAppInvitedMsg", "Character invited to join corporation"),
                    ("CorpAppRejectCustomMsg", "Corp application rejected"),
                    ("CharAppWithdrawMsg", "Character withdrew application"),
                    ("CharAppAcceptMsg", "Character joins corporation"),
                    ("CharLeftCorpMsg", "Character leaves corporation"),
                    ("BillOutOfMoneyMsg", "Bill out of money"),
                    (
                        "InfrastructureHubBillAboutToExpire",
                        "I-HUB bill about to expire",
                    ),
                    ("IHubDestroyedByBillFailure", "I_HUB destroyed by bill failure"),
                ],
                default=[
                    "StructureAnchoring",
                    "StructureDestroyed",
                    "StructureFuelAlert",
                    "StructureLostArmor",
                    "StructureLostShields",
                    "StructureOnline",
                    "StructureServicesOffline",
                    "StructureUnderAttack",
                    "StructureWentHighPower",
                    "StructureWentLowPower",
                    "OrbitalAttacked",
                    "OrbitalReinforced",
                    "TowerAlertMsg",
                    "TowerResourceAlertMsg",
                    "SovStructureReinforced",
                    "SovStructureDestroyed",
                ],
                help_text="Select which type of notifications should be forwarded to this webhook",
                max_length=1123,
                verbose_name="notification types",
            ),
        ),
        migrations.AlterField(
            model_name="webhook",
            name="ping_groups",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Groups to be pinged for each notification - ",
                related_name="+",
                to="auth.group",
                verbose_name="ping groups",
            ),
        ),
        migrations.AddConstraint(
            model_name="starbasedetailfuel",
            constraint=models.UniqueConstraint(
                fields=("detail", "eve_type"), name="functional_pk_starbasedetailfuel"
            ),
        ),
    ]
