import re
from urllib.parse import urlparse

import typer


def is_valid_url(url: str):
    """
    Verify if the given string is a valid URL.
    Args:
        url (str): The URL string to verify.
    : Returns:
        bool: True if the URL is valid, False otherwise.
    """
    # Definizione di un'espressione regolare per verificare l'URL
    regex = re.compile(
        r'^(?:http|ftp)s?://' # Schema
        r'(?:(?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\.)+(?:[A-Z]{2,6}\.?|[A-Z0-9-]{2,}\.?)|' # Dominio
        r'localhost|' # o localhost
        r'\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}|' # o indirizzo IPv4
        r'\[?[A-F0-9]*:[A-F0-9:]+\]?)' # o indirizzo IPv6
        r'(?::\d+)?' # Porta opzionale
        r'(?:/?|[/?]\S+)$', re.IGNORECASE)

    # Verifica se l'URL corrisponde all'espressione regolare
    if re.match(regex, url) is not None:
        return True
    else:
        return False


def validate_url(url: str, error_msg: str = "The URL is not valid.") -> str:
    result = urlparse(url)
    if not (result.scheme and result.netloc):
        raise typer.BadParameter(error_msg)
    return url
