"""initial migration.

Represents the state of the database in version 0.0.56

Revision ID: 1736443094
Revises:
Create Date: 2025-01-09 18:18:14.276914

"""

from collections.abc import Sequence

import sqlalchemy as sa
import sqlalchemy_utils.types.password
from alembic import op

import canaille.backends.sql.utils

# revision identifiers, used by Alembic.
revision: str = "1736443094"
down_revision: str | None = None
branch_labels: str | Sequence[str] | None = ("default",)
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "client",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column(
            "created",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "last_modified",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("preconsent", sa.Boolean(), nullable=True),
        sa.Column("post_logout_redirect_uris", sa.JSON(), nullable=True),
        sa.Column("client_id", sa.String(), nullable=True),
        sa.Column("client_secret", sa.String(), nullable=True),
        sa.Column(
            "client_id_issued_at",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "client_secret_expires_at",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("client_name", sa.String(), nullable=True),
        sa.Column("contacts", sa.JSON(), nullable=True),
        sa.Column("client_uri", sa.String(), nullable=True),
        sa.Column("redirect_uris", sa.JSON(), nullable=True),
        sa.Column("logo_uri", sa.String(), nullable=True),
        sa.Column("grant_types", sa.JSON(), nullable=True),
        sa.Column("response_types", sa.JSON(), nullable=True),
        sa.Column("scope", sa.JSON(), nullable=True),
        sa.Column("tos_uri", sa.String(), nullable=True),
        sa.Column("policy_uri", sa.String(), nullable=True),
        sa.Column("jwks_uri", sa.String(), nullable=True),
        sa.Column("jwk", sa.String(), nullable=True),
        sa.Column("token_endpoint_auth_method", sa.String(), nullable=True),
        sa.Column("software_id", sa.String(), nullable=True),
        sa.Column("software_version", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "group",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column(
            "created",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "last_modified",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("display_name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "user",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column(
            "created",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "last_modified",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("user_name", sa.String(), nullable=False),
        sa.Column(
            "password",
            sqlalchemy_utils.types.password.PasswordType(max_length=4096),
            nullable=True,
        ),
        sa.Column("preferred_language", sa.String(), nullable=True),
        sa.Column("family_name", sa.String(), nullable=True),
        sa.Column("given_name", sa.String(), nullable=True),
        sa.Column("formatted_name", sa.String(), nullable=True),
        sa.Column("display_name", sa.String(), nullable=True),
        sa.Column("emails", sa.JSON(), nullable=True),
        sa.Column("phone_numbers", sa.JSON(), nullable=True),
        sa.Column("formatted_address", sa.String(), nullable=True),
        sa.Column("street", sa.String(), nullable=True),
        sa.Column("postal_code", sa.String(), nullable=True),
        sa.Column("locality", sa.String(), nullable=True),
        sa.Column("region", sa.String(), nullable=True),
        sa.Column("photo", sa.LargeBinary(), nullable=True),
        sa.Column("profile_url", sa.String(), nullable=True),
        sa.Column("employee_number", sa.String(), nullable=True),
        sa.Column("department", sa.String(), nullable=True),
        sa.Column("title", sa.String(), nullable=True),
        sa.Column("organization", sa.String(), nullable=True),
        sa.Column(
            "lock_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("user_name"),
    )
    op.create_table(
        "authorization_code",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column(
            "created",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "last_modified",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("authorization_code_id", sa.String(), nullable=True),
        sa.Column("code", sa.String(), nullable=True),
        sa.Column("client_id", sa.String(), nullable=False),
        sa.Column("subject_id", sa.String(), nullable=False),
        sa.Column("redirect_uri", sa.String(), nullable=True),
        sa.Column("response_type", sa.String(), nullable=True),
        sa.Column("scope", sa.JSON(), nullable=True),
        sa.Column("nonce", sa.String(), nullable=True),
        sa.Column(
            "issue_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("lifetime", sa.Integer(), nullable=True),
        sa.Column("challenge", sa.String(), nullable=True),
        sa.Column("challenge_method", sa.String(), nullable=True),
        sa.Column(
            "revokation_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["subject_id"],
            ["user.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "client_audience_association_table",
        sa.Column("audience_id", sa.String(), nullable=True),
        sa.Column("client_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["audience_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.PrimaryKeyConstraint("audience_id", "client_id"),
    )
    op.create_table(
        "consent",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column(
            "created",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "last_modified",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("consent_id", sa.String(), nullable=True),
        sa.Column("subject_id", sa.String(), nullable=False),
        sa.Column("client_id", sa.String(), nullable=False),
        sa.Column("scope", sa.JSON(), nullable=True),
        sa.Column(
            "issue_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "revokation_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["subject_id"],
            ["user.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "membership_association_table",
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("group_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["group_id"],
            ["group.id"],
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
        ),
        sa.PrimaryKeyConstraint("user_id", "group_id"),
    )
    op.create_table(
        "token",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column(
            "created",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column(
            "last_modified",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("token_id", sa.String(), nullable=True),
        sa.Column("access_token", sa.String(), nullable=True),
        sa.Column("client_id", sa.String(), nullable=False),
        sa.Column("subject_id", sa.String(), nullable=False),
        sa.Column("type", sa.String(), nullable=True),
        sa.Column("refresh_token", sa.String(), nullable=True),
        sa.Column("scope", sa.JSON(), nullable=True),
        sa.Column(
            "issue_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.Column("lifetime", sa.Integer(), nullable=True),
        sa.Column(
            "revokation_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["subject_id"],
            ["user.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "token_audience_association_table",
        sa.Column("token_id", sa.String(), nullable=True),
        sa.Column("client_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["token_id"],
            ["token.id"],
        ),
        sa.PrimaryKeyConstraint("token_id", "client_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("token_audience_association_table")
    op.drop_table("token")
    op.drop_table("membership_association_table")
    op.drop_table("consent")
    op.drop_table("client_audience_association_table")
    op.drop_table("authorization_code")
    op.drop_table("user")
    op.drop_table("group")
    op.drop_table("client")
    # ### end Alembic commands ###
