"""0.0.58.

Revision ID: 1736443538
Revises: 1736443094
Create Date: 2025-01-09 18:25:38.443578

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

import canaille.backends.sql.utils

# revision identifiers, used by Alembic.
revision: str = "1736443538"
down_revision: str | None = "1736443094"
branch_labels: str | Sequence[str] | None = ()
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("token") as batch_op:
        batch_op.alter_column("subject_id", existing_type=sa.VARCHAR(), nullable=True)

    op.add_column(
        "user",
        sa.Column(
            "password_last_update",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
    )
    op.add_column(
        "user", sa.Column("_password_failure_timestamps", sa.JSON(), nullable=True)
    )
    op.add_column(
        "user",
        sa.Column(
            "last_otp_login",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
    )
    op.add_column("user", sa.Column("secret_token", sa.String(), nullable=True))
    op.add_column("user", sa.Column("hotp_counter", sa.Integer(), nullable=True))
    op.add_column("user", sa.Column("one_time_password", sa.String(), nullable=True))
    op.add_column(
        "user",
        sa.Column(
            "one_time_password_emission_date",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
    )
    with op.batch_alter_table("user") as batch_op:
        batch_op.create_unique_constraint("uq_user_secret_token", ["secret_token"])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user") as batch_op:
        batch_op.drop_constraint("uq_user_secret_token", type_="unique")
    op.drop_column("user", "one_time_password_emission_date")
    op.drop_column("user", "one_time_password")
    op.drop_column("user", "hotp_counter")
    op.drop_column("user", "secret_token")
    op.drop_column("user", "last_otp_login")
    op.drop_column("user", "_password_failure_timestamps")
    op.drop_column("user", "password_last_update")
    with op.batch_alter_table("token") as batch_op:
        batch_op.alter_column("subject_id", existing_type=sa.VARCHAR(), nullable=False)
    # ### end Alembic commands ###
