"""Add login metadata to AuthorizationCode.

Revision ID: 1743675164
Revises: 1742298790
Create Date: 2025-04-03 12:12:44.237218

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

import canaille.backends.sql.utils

# revision identifiers, used by Alembic.
revision: str = "1743675164"
down_revision: str | None = "1742298790"
branch_labels: str | Sequence[str] | None = ()
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "authorization_code",
        sa.Column(
            "auth_time",
            canaille.backends.sql.utils.TZDateTime(timezone=True),
            nullable=True,
        ),
    )
    op.add_column("authorization_code", sa.Column("acr", sa.String(), nullable=True))
    op.add_column("authorization_code", sa.Column("amr", sa.JSON(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("authorization_code", "amr")
    op.drop_column("authorization_code", "acr")
    op.drop_column("authorization_code", "auth_time")
    # ### end Alembic commands ###
