"""add group owner foreign key.

Revision ID: 1761846138
Revises: 1760000353
Create Date: 2025-10-30 18:42:18.556666

"""

from collections.abc import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1761846138"
down_revision: str | None = "1760000353"
branch_labels: str | Sequence[str] | None = ()
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("group", schema=None) as batch_op:
        batch_op.create_foreign_key(
            batch_op.f("fk_group_owner_id_user"), "user", ["owner_id"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("group", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_group_owner_id_user"), type_="foreignkey"
        )

    # ### end Alembic commands ###
