"""add limits to string fields.

Revision ID: 1761851899
Revises: 1761846634
Create Date: 2025-10-30 20:18:19.821038

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1761851899"
down_revision: str | None = "1761846634"
branch_labels: str | Sequence[str] | None = ()
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("client", schema=None) as batch_op:
        batch_op.alter_column(
            "description",
            existing_type=sa.VARCHAR(),
            type_=sa.Text(),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "jwks", existing_type=sa.VARCHAR(), type_=sa.Text(), existing_nullable=True
        )

    with op.batch_alter_table("group", schema=None) as batch_op:
        batch_op.alter_column(
            "description",
            existing_type=sa.VARCHAR(),
            type_=sa.Text(),
            existing_nullable=True,
        )

    with op.batch_alter_table("token", schema=None) as batch_op:
        batch_op.alter_column(
            "access_token",
            existing_type=sa.VARCHAR(),
            type_=sa.Text(),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "refresh_token",
            existing_type=sa.VARCHAR(),
            type_=sa.Text(),
            existing_nullable=True,
        )

    with op.batch_alter_table("user", schema=None) as batch_op:
        batch_op.alter_column(
            "formatted_address",
            existing_type=sa.VARCHAR(),
            type_=sa.Text(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user", schema=None) as batch_op:
        batch_op.alter_column(
            "formatted_address",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(),
            existing_nullable=True,
        )

    with op.batch_alter_table("token", schema=None) as batch_op:
        batch_op.alter_column(
            "refresh_token",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "access_token",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(),
            existing_nullable=True,
        )

    with op.batch_alter_table("group", schema=None) as batch_op:
        batch_op.alter_column(
            "description",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(),
            existing_nullable=True,
        )

    with op.batch_alter_table("client", schema=None) as batch_op:
        batch_op.alter_column(
            "jwks", existing_type=sa.Text(), type_=sa.VARCHAR(), existing_nullable=True
        )
        batch_op.alter_column(
            "description",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###
