"""ondelete on foreign keys.

Revision ID: 1761862795
Revises: 1761860792
Create Date: 2025-10-30 23:19:55.541310

This migration adds ON DELETE policies to foreign keys for PostgreSQL compatibility.
SQLite does not benefit from this migration as it doesn't enforce foreign key constraints
without PRAGMA foreign_keys=ON.
"""

from collections.abc import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1761862795"
down_revision: str | None = "1761860792"
branch_labels: str | Sequence[str] | None = ()
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # Skip this migration for SQLite - it doesn't enforce FK constraints by default
    bind = op.get_bind()
    if bind.dialect.name == "sqlite":
        return
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("authorization_code", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_authorization_code_client_id_client"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_authorization_code_subject_id_user"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_authorization_code_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_authorization_code_subject_id_user"),
            "user",
            ["subject_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table(
        "client_audience_association_table", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_client_audience_association_table_client_id_client"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_client_audience_association_table_audience_id_client"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_client_audience_association_table_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_client_audience_association_table_audience_id_client"),
            "client",
            ["audience_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("consent", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_consent_client_id_client"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_consent_subject_id_user"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_consent_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_consent_subject_id_user"),
            "user",
            ["subject_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("group", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_group_owner_id_user"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_group_owner_id_user"),
            "user",
            ["owner_id"],
            ["id"],
            ondelete="SET NULL",
        )

    with op.batch_alter_table("membership_association_table", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_membership_association_table_group_id_group"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_membership_association_table_user_id_user"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_membership_association_table_group_id_group"),
            "group",
            ["group_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_membership_association_table_user_id_user"),
            "user",
            ["user_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("token", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_token_client_id_client"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_token_subject_id_user"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_subject_id_user"),
            "user",
            ["subject_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table(
        "token_audience_association_table", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_token_audience_association_table_token_id_token"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_token_audience_association_table_client_id_client"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_audience_association_table_token_id_token"),
            "token",
            ["token_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_audience_association_table_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
            ondelete="CASCADE",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # Skip this migration for SQLite - it doesn't enforce FK constraints by default
    bind = op.get_bind()
    if bind.dialect.name == "sqlite":
        return

    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "token_audience_association_table", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_token_audience_association_table_client_id_client"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_token_audience_association_table_token_id_token"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_audience_association_table_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_audience_association_table_token_id_token"),
            "token",
            ["token_id"],
            ["id"],
        )

    with op.batch_alter_table("token", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_token_subject_id_user"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_token_client_id_client"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_subject_id_user"), "user", ["subject_id"], ["id"]
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_token_client_id_client"), "client", ["client_id"], ["id"]
        )

    with op.batch_alter_table("membership_association_table", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_membership_association_table_user_id_user"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_membership_association_table_group_id_group"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_membership_association_table_user_id_user"),
            "user",
            ["user_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_membership_association_table_group_id_group"),
            "group",
            ["group_id"],
            ["id"],
        )

    with op.batch_alter_table("group", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_group_owner_id_user"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_group_owner_id_user"), "user", ["owner_id"], ["id"]
        )

    with op.batch_alter_table("consent", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_consent_subject_id_user"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_consent_client_id_client"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_consent_subject_id_user"), "user", ["subject_id"], ["id"]
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_consent_client_id_client"), "client", ["client_id"], ["id"]
        )

    with op.batch_alter_table(
        "client_audience_association_table", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_client_audience_association_table_audience_id_client"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_client_audience_association_table_client_id_client"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_client_audience_association_table_audience_id_client"),
            "client",
            ["audience_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_client_audience_association_table_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
        )

    with op.batch_alter_table("authorization_code", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_authorization_code_subject_id_user"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_authorization_code_client_id_client"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_authorization_code_subject_id_user"),
            "user",
            ["subject_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_authorization_code_client_id_client"),
            "client",
            ["client_id"],
            ["id"],
        )

    # ### end Alembic commands ###
