import json

from canaille.app import models
from canaille.commands import cli


def test_restore_stdin(cli_runner, backend):
    """Test the full database dump command."""
    payload = {
        "group": [
            {
                "created": "2025-01-01T12:00:00+00:00",
                "display_name": "foo",
                "id": "cef66b33-2762-423e-b0c3-2fb6ab13abfa",
                "last_modified": "2025-01-01T12:00:00+00:00",
                "members": [
                    "e52b36b5-6a94-4395-b3a8-0f72d9140bfa",
                ],
            },
        ],
        "user": [
            {
                "created": "2025-01-02T12:00:00+00:00",
                "display_name": "Johnny",
                "emails": [
                    "john@doe.test",
                ],
                "family_name": "Doe",
                "formatted_address": "1235, somewhere",
                "formatted_name": "John (johnny) Doe",
                "given_name": "John",
                "groups": ["cef66b33-2762-423e-b0c3-2fb6ab13abfa"],
                "id": "e52b36b5-6a94-4395-b3a8-0f72d9140bfa",
                "last_modified": "2025-01-02T12:00:00+00:00",
                "password": "$pbkdf2-sha512$25000$Nsa4VwoBgHBOKaUUImSMsQ$/Ynkpp1RQILSMBUfKxxMZpG/2oYcFNJxFGMZ0xoHSIbIGkkqeo.VgY71r3Gl8tepUJRmNnaW7if0C5pRHue/Zw",
                "phone_numbers": [
                    "555-000-000",
                ],
                "preferred_language": "en",
                "profile_url": "https://john.test",
                "user_name": "user",
            },
        ],
    }

    res = cli_runner.invoke(cli, ["restore"], input=json.dumps(payload))
    assert res.exit_code == 0, res.stdout

    user = backend.get(models.User, user_name="user")
    assert user.user_name == "user"
    assert user.family_name == "Doe"

    group = backend.get(models.Group, display_name="foo")
    assert group.display_name == "foo"

    assert user.groups == [group]
    assert group.members == [user]

    backend.delete(group)
    backend.delete(user)


def test_restore_stdin_no_input(cli_runner, backend):
    """Test the restore command without input."""
    res = cli_runner.invoke(cli, ["restore"], catch_exceptions=False)
    assert res.exit_code == 1, res.stdout


def test_restore_stdin_empty_input(cli_runner, backend):
    """Test the restore command with an empty input."""
    res = cli_runner.invoke(cli, ["restore"], input="")
    assert res.exit_code == 1, res.stdout


def test_restore_stdin_invalid_input(cli_runner, backend):
    """Test the restore command with an invalid input."""
    res = cli_runner.invoke(cli, ["restore"], input="invalid")
    assert res.exit_code == 1, res.stdout
