# Module: TFSimilarity.distances





Vectorized embedding pairwise distances computation functions



## Classes

- [`class ABC`](../TFSimilarity/distances/ABC.md): Helper class that provides a standard way to create an ABC using

- [`class CosineDistance`](../TFSimilarity/distances/CosineDistance.md): Compute pairwise cosine distances between embeddings.

- [`class Distance`](../TFSimilarity/distances/Distance.md): Note: don't forget to add your distance to the DISTANCES list

- [`class EuclideanDistance`](../TFSimilarity/distances/EuclideanDistance.md): Compute pairwise euclidean distances between embeddings.

- [`class FloatTensor`](../TFSimilarity/distances/FloatTensor.md): Float tensor 

- [`class InnerProductSimilarity`](../TFSimilarity/distances/InnerProductSimilarity.md): Compute the pairwise inner product between embeddings.

- [`class ManhattanDistance`](../TFSimilarity/distances/ManhattanDistance.md): Compute pairwise Manhattan distances between embeddings.

- [`class SquaredEuclideanDistance`](../TFSimilarity/distances/SquaredEuclideanDistance.md): Compute pairwise squared Euclidean distance.

## Functions

- [`distance_canonicalizer(...)`](../TFSimilarity/distances/distance_canonicalizer.md): Normalize user requested distance to its matching Distance object.





