# TFSimilarity.matchers.MatchNearest





Match metrics for labels at k=1.

Inherits From: [`ClassificationMatch`](../../TFSimilarity/indexer/ClassificationMatch.md), [`ABC`](../../TFSimilarity/distances/ABC.md)

```python
TFSimilarity.matchers.MatchNearest(
    name: str = nearest,
    **kwargs
) -> None
```



<!-- Placeholder for "Used in" -->


<!-- Tabular view -->
 <table class="responsive fixed orange">
<colgroup><col width="214px"><col></colgroup>
<tr><th colspan="2"><h2 class="add-link">Attributes</h2></th></tr>

<tr>
<td>
<b>count</b>
</td>
<td>
The total number of queries.
</td>
</tr><tr>
<td>
<b>fn</b>
</td>
<td>
The count of False negatives matches.

A False negative match is when the query label == the label generated
by a matcher and the distance to the query is greater than the distance
threshold.
</td>
</tr><tr>
<td>
<b>fp</b>
</td>
<td>
The count of False positive matches.

A False positive match is when the query label != the label generated
by a matcher and the distance to the query is less than the distance
threshold.
</td>
</tr><tr>
<td>
<b>tn</b>
</td>
<td>
The count of True negatives matches.

A True negative match is when the query label != the label generated
by a matcher and the distance to the query is greater than the distance
threshold.
</td>
</tr><tr>
<td>
<b>tp</b>
</td>
<td>
The count of True positive matches.

A True positive match is when the query label == the label generated by
a matcher and the distance to the query is less than the distance
threshold.
</td>
</tr>
</table>





<!-- Tabular view -->
 <table class="responsive fixed orange">
<colgroup><col width="214px"><col></colgroup>
<tr><th colspan="2"><h2 class="add-link">Attributes</h2></th></tr>

<tr>
<td>
<b>count</b>
</td>
<td>
The total number of queries.
</td>
</tr><tr>
<td>
<b>fn</b>
</td>
<td>
The count of False negatives matches.

A False negative match is when the query label == the label generated
by a matcher and the distance to the query is greater than the distance
threshold.
</td>
</tr><tr>
<td>
<b>fp</b>
</td>
<td>
The count of False positive matches.

A False positive match is when the query label != the label generated
by a matcher and the distance to the query is less than the distance
threshold.
</td>
</tr><tr>
<td>
<b>tn</b>
</td>
<td>
The count of True negatives matches.

A True negative match is when the query label != the label generated
by a matcher and the distance to the query is greater than the distance
threshold.
</td>
</tr><tr>
<td>
<b>tp</b>
</td>
<td>
The count of True positive matches.

A True positive match is when the query label == the label generated by
a matcher and the distance to the query is less than the distance
threshold.
</td>
</tr>
</table>



## Methods

<h3 id="compile">compile</h3>

<a target="_blank" href="https://github.com/tensorflow/similarity/blob/main/tensorflow_similarity/matchers/classification_match.py#L88-L93">View source</a>

```python
compile(
    distance_thresholds: <a href="../../TFSimilarity/distances/FloatTensor.md">TFSimilarity.distances.FloatTensor```
</a> = tf.constant([math.inf])
)
```


Configures the distance thresholds used during matching.


<h3 id="compute_match_indicators">compute_match_indicators</h3>

<a target="_blank" href="https://github.com/tensorflow/similarity/blob/main/tensorflow_similarity/matchers/match_nearest.py#L35-L80">View source</a>

```python
compute_match_indicators(
    query_labels: <a href="../../TFSimilarity/callbacks/IntTensor.md">TFSimilarity.callbacks.IntTensor```
</a>,
    lookup_labels: <a href="../../TFSimilarity/callbacks/IntTensor.md">TFSimilarity.callbacks.IntTensor```
</a>,
    lookup_distances: <a href="../../TFSimilarity/distances/FloatTensor.md">TFSimilarity.distances.FloatTensor```
</a>
) -> Tuple[BoolTensor, BoolTensor]
```


Compute the indicator tensor.


<!-- Tabular view -->
 <table class="responsive fixed orange">
<colgroup><col width="214px"><col></colgroup>
<tr><th colspan="2">Args</th></tr>

<tr>
<td>
<b>query_labels</b>
</td>
<td>
A 1D array of the labels associated with the queries.
</td>
</tr><tr>
<td>
<b>lookup_labels</b>
</td>
<td>
A 2D array where the jth row is the labels
associated with the set of k neighbors for the jth query.
</td>
</tr><tr>
<td>
<b>lookup_distances</b>
</td>
<td>
A 2D array where the jth row is the distances
between the jth query and the set of k neighbors.
</td>
</tr>
</table>



<!-- Tabular view -->
 <table class="responsive fixed orange">
<colgroup><col width="214px"><col></colgroup>
<tr><th colspan="2">Returns</th></tr>
<tr class="alt">
<td colspan="2">
A Tuple of BoolTensors:
label_match: A len(query_labels x 1 boolean tensor. True if
the match label == query label, False otherwise.

dist_mask: A len(query_labels) x len(distance_thresholds)
boolean tensor. True if the distance of the jth match <= the
kth distance threshold.
</td>
</tr>

</table>



<h3 id="get_config">get_config</h3>

<a target="_blank" href="https://github.com/tensorflow/similarity/blob/main/tensorflow_similarity/matchers/classification_match.py#L54-L58">View source</a>

```python
get_config()
```





<h3 id="match">match</h3>

<a target="_blank" href="https://github.com/tensorflow/similarity/blob/main/tensorflow_similarity/matchers/classification_match.py#L95-L119">View source</a>

```python
match(
    query_labels: <a href="../../TFSimilarity/callbacks/IntTensor.md">TFSimilarity.callbacks.IntTensor```
</a>,
    lookup_labels: <a href="../../TFSimilarity/callbacks/IntTensor.md">TFSimilarity.callbacks.IntTensor```
</a>,
    lookup_distances: <a href="../../TFSimilarity/distances/FloatTensor.md">TFSimilarity.distances.FloatTensor```
</a>
)
```


Compares the query_label against the match label associated with the
lookup labels.

Note: compile must be called before calling match.

<!-- Tabular view -->
 <table class="responsive fixed orange">
<colgroup><col width="214px"><col></colgroup>
<tr><th colspan="2">Args</th></tr>

<tr>
<td>
<b>query_labels</b>
</td>
<td>
A 1D array of the labels associated with the queries.
</td>
</tr><tr>
<td>
<b>lookup_labels</b>
</td>
<td>
A 2D array where the jth row is the labels
associated with the set of k neighbors for the jth query.
</td>
</tr><tr>
<td>
<b>lookup_distances</b>
</td>
<td>
A 2D array where the jth row is the distances
between the jth query and the set of k neighbors.
</td>
</tr>
</table>





