from typing import overload
import typing
import warnings

import QuantConnect.Algorithm.Framework.Alphas
import QuantConnect.Algorithm.Framework.Alphas.Serialization
import QuantConnect.Util
import System


class SerializedInsight(System.Object):
    """
    DTO used for serializing an insight that was just generated by an algorithm.
    This type does not contain any of the analysis dependent fields, such as scores
    and estimated value
    """

    @property
    def id(self) -> str:
        """See Insight.Id"""
        ...

    @property
    def group_id(self) -> str:
        """See Insight.GroupId"""
        ...

    @property
    def source_model(self) -> str:
        """See Insight.SourceModel"""
        ...

    @property
    def generated_time(self) -> float:
        """
        Pass-through for CreatedTime
        
        Deprecated as of 2020-01-23. Please use the `CreatedTime` property instead.
        """
        warnings.warn("Deprecated as of 2020-01-23. Please use the `CreatedTime` property instead.", DeprecationWarning)

    @property
    def created_time(self) -> float:
        """See Insight.GeneratedTimeUtc"""
        ...

    @property
    def close_time(self) -> float:
        """See Insight.CloseTimeUtc"""
        ...

    @property
    def symbol(self) -> str:
        """
        See Insight.Symbol
        The symbol's security identifier string
        """
        ...

    @property
    def ticker(self) -> str:
        """
        See Insight.Symbol
        The symbol's ticker at the generated time
        """
        ...

    @property
    def type(self) -> int:
        """
        See Insight.Type
        
        This property contains the int value of a member of the QuantConnect.Algorithm.Framework.Alphas.InsightType enum.
        """
        ...

    @property
    def reference_value(self) -> float:
        """See Insight.ReferenceValue"""
        ...

    @property
    def reference_value_final(self) -> float:
        """See Insight.ReferenceValueFinal"""
        ...

    @property
    def direction(self) -> int:
        """
        See Insight.Direction
        
        This property contains the int value of a member of the QuantConnect.Algorithm.Framework.Alphas.InsightDirection enum.
        """
        ...

    @property
    def period(self) -> float:
        """See Insight.Period"""
        ...

    @property
    def magnitude(self) -> typing.Optional[float]:
        """See Insight.Magnitude"""
        ...

    @property
    def confidence(self) -> typing.Optional[float]:
        """See Insight.Confidence"""
        ...

    @property
    def weight(self) -> typing.Optional[float]:
        """See Insight.Weight"""
        ...

    @property
    def score_is_final(self) -> bool:
        """See InsightScore.IsFinalScore"""
        ...

    @property
    def score_magnitude(self) -> float:
        """See InsightScore.Magnitude"""
        ...

    @property
    def score_direction(self) -> float:
        """See InsightScore.Direction"""
        ...

    @property
    def estimated_value(self) -> float:
        """See Insight.EstimatedValue"""
        ...

    @property
    def tag(self) -> str:
        """See Insight.Tag"""
        ...

    @property
    def old_created_time(self) -> float:
        """See Insight.GeneratedTimeUtc"""
        ...

    @property
    def old_close_time(self) -> float:
        """See Insight.CloseTimeUtc"""
        ...

    @overload
    def __init__(self) -> None:
        """Initializes a new default instance of the SerializedInsight class"""
        ...

    @overload
    def __init__(self, insight: QuantConnect.Algorithm.Framework.Alphas.Insight) -> None:
        """
        Initializes a new instance of the SerializedInsight  class by copying the specified insight
        
        :param insight: The insight to copy
        """
        ...


class InsightJsonConverter(QuantConnect.Util.TypeChangeJsonConverter[QuantConnect.Algorithm.Framework.Alphas.Insight, QuantConnect.Algorithm.Framework.Alphas.Serialization.SerializedInsight]):
    """Defines how insights should be serialized to json"""

    @overload
    def convert(self, value: QuantConnect.Algorithm.Framework.Alphas.Insight) -> QuantConnect.Algorithm.Framework.Alphas.Serialization.SerializedInsight:
        """
        Convert the input value to a value to be serialized
        
        This method is protected.
        
        :param value: The input value to be converted before serialization
        :returns: A new instance of TResult that is to be serialized.
        """
        ...

    @overload
    def convert(self, value: QuantConnect.Algorithm.Framework.Alphas.Serialization.SerializedInsight) -> QuantConnect.Algorithm.Framework.Alphas.Insight:
        """
        Converts the input value to be deserialized
        
        This method is protected.
        
        :param value: The deserialized value that needs to be converted to T
        :returns: The converted value.
        """
        ...


