from typing import overload
import typing

import QuantConnect.Orders
import QuantConnect.Orders.Serialization
import QuantConnect.Util
import System


class SerializedOrderEvent(System.Object):
    """Data transfer object used for serializing an OrderEvent that was just generated by an algorithm"""

    @property
    def id(self) -> str:
        """The unique order event id"""
        ...

    @property
    def algorithm_id(self) -> str:
        """Algorithm Id, BacktestId or DeployId"""
        ...

    @property
    def order_id(self) -> int:
        """Id of the order this event comes from."""
        ...

    @property
    def order_event_id(self) -> int:
        """The unique order event id for each order"""
        ...

    @property
    def symbol(self) -> str:
        """Easy access to the order symbol associated with this event."""
        ...

    @property
    def symbol_value(self) -> str:
        """The mapped symbol value"""
        ...

    @property
    def symbol_permtick(self) -> str:
        """The symbols permanent ticker. For equities, by convention this is the first ticker symbol for which the security traded"""
        ...

    @property
    def time(self) -> float:
        """The time of this event in unix timestamp"""
        ...

    @property
    def status(self) -> int:
        """
        Status message of the order.
        
        This property contains the int value of a member of the QuantConnect.Orders.OrderStatus enum.
        """
        ...

    @property
    def order_fee_amount(self) -> typing.Optional[float]:
        """The fee amount associated with the order"""
        ...

    @property
    def order_fee_currency(self) -> str:
        """The fee currency associated with the order"""
        ...

    @property
    def fill_price(self) -> float:
        """Fill price information about the order"""
        ...

    @property
    def fill_price_currency(self) -> str:
        """Currency for the fill price"""
        ...

    @property
    def fill_quantity(self) -> float:
        """Number of shares of the order that was filled in this event."""
        ...

    @property
    def direction(self) -> int:
        """
        Order direction.
        
        This property contains the int value of a member of the QuantConnect.Orders.OrderDirection enum.
        """
        ...

    @property
    def message(self) -> str:
        """Any message from the exchange."""
        ...

    @property
    def is_assignment(self) -> bool:
        """True if the order event is an assignment"""
        ...

    @property
    def quantity(self) -> float:
        """The current order quantity"""
        ...

    @property
    def stop_price(self) -> typing.Optional[float]:
        """The current stop price"""
        ...

    @property
    def limit_price(self) -> typing.Optional[float]:
        """The current limit price"""
        ...

    @property
    def is_in_the_money(self) -> bool:
        """True if the order event's option is In-The-Money (ITM)"""
        ...

    @overload
    def __init__(self) -> None:
        """Empty constructor required for JSON converter."""
        ...

    @overload
    def __init__(self, orderEvent: QuantConnect.Orders.OrderEvent, algorithmId: str) -> None:
        """Creates a new instances based on the provided order event and algorithm Id"""
        ...


class OrderEventJsonConverter(QuantConnect.Util.TypeChangeJsonConverter[QuantConnect.Orders.OrderEvent, QuantConnect.Orders.Serialization.SerializedOrderEvent]):
    """Defines how OrderEvents should be serialized to json"""

    @property
    def populate_properties(self) -> bool:
        """
        True will populate TResult object returned by Convert(SerializedOrderEvent) with json properties
        
        This property is protected.
        """
        ...

    def __init__(self, algorithmId: str = None) -> None:
        """
        Creates a new instance
        
        :param algorithmId: The associated algorithm id, required when serializing
        """
        ...

    @overload
    def convert(self, value: QuantConnect.Orders.OrderEvent) -> QuantConnect.Orders.Serialization.SerializedOrderEvent:
        """
        Convert the input value to a value to be serialzied
        
        This method is protected.
        
        :param value: The input value to be converted before serialziation
        :returns: A new instance of TResult that is to be serialzied.
        """
        ...

    @overload
    def convert(self, value: QuantConnect.Orders.Serialization.SerializedOrderEvent) -> QuantConnect.Orders.OrderEvent:
        """
        Converts the input value to be deserialized
        
        This method is protected.
        
        :param value: The deserialized value that needs to be converted to OrderEvent
        :returns: The converted value.
        """
        ...


