from typing import overload
import typing

import QuantConnect.Interfaces
import QuantConnect.Packets
import QuantConnect.Queues
import System


class JobQueue(System.Object, QuantConnect.Interfaces.IJobQueueHandler):
    """Implementation of local/desktop job request:"""

    @property
    def language(self) -> int:
        """
        This property is protected for testing purposes
        
        This property contains the int value of a member of the QuantConnect.Language enum.
        
        This property is protected.
        """
        ...

    def acknowledge_job(self, job: QuantConnect.Packets.AlgorithmNodePacket) -> None:
        """Desktop/Local acknowledge the task processed. Nothing to do."""
        ...

    @staticmethod
    def get_factory_from_data_queue_handler(data_queue_handler: str) -> QuantConnect.Interfaces.IBrokerageFactory:
        """
        Gets Brokerage Factory for provided IDQH
        
        :returns: An Instance of Brokerage Factory if possible, otherwise null.
        """
        ...

    def initialize(self, api: QuantConnect.Interfaces.IApi) -> None:
        """Initialize the job queue:"""
        ...

    def next_job(self, algorithm_path: typing.Optional[str]) -> typing.Union[QuantConnect.Packets.AlgorithmNodePacket, str]:
        """Desktop/Local Get Next Task - Get task from the Algorithm folder of VS Solution."""
        ...


