<a id="aea.package_manager.v0"></a>

# aea.package`_`manager.v0

Package manager V0

<a id="aea.package_manager.v0.PackageManagerV0"></a>

## PackageManagerV0 Objects

```python
class PackageManagerV0(BasePackageManager)
```

Package manager v0.

<a id="aea.package_manager.v0.PackageManagerV0.__init__"></a>

#### `__`init`__`

```python
def __init__(
        path: Path,
        packages: Optional[PackageIdToHashMapping] = None,
        config_loader: ConfigLoaderCallableType = load_configuration) -> None
```

Initialize object.

<a id="aea.package_manager.v0.PackageManagerV0.packages"></a>

#### packages

```python
@property
def packages() -> OrderedDictType[PackageId, str]
```

Returns mappings of package ids -> package hash

<a id="aea.package_manager.v0.PackageManagerV0.get_package_hash"></a>

#### get`_`package`_`hash

```python
def get_package_hash(package_id: PackageId) -> Optional[str]
```

Get package hash.

<a id="aea.package_manager.v0.PackageManagerV0.register"></a>

#### register

```python
def register(package_path: Path,
             package_type: Optional[PackageType] = None) -> "PackageManagerV0"
```

Add package to the index.

<a id="aea.package_manager.v0.PackageManagerV0.sync"></a>

#### sync

```python
def sync(dev: bool = False,
         third_party: bool = True,
         update_packages: bool = False,
         update_hashes: bool = False) -> "PackageManagerV0"
```

Sync local packages to the remote registry.

<a id="aea.package_manager.v0.PackageManagerV0.update_package_hashes"></a>

#### update`_`package`_`hashes

```python
def update_package_hashes(selector_prompt: Optional[Callable[[], str]] = None,
                          skip_missing: bool = False) -> "BasePackageManager"
```

Update packages.json file.

<a id="aea.package_manager.v0.PackageManagerV0.add_package"></a>

#### add`_`package

```python
def add_package(package_id: PackageId,
                with_dependencies: bool = False,
                allow_update: bool = False) -> "BasePackageManager"
```

Add package.

<a id="aea.package_manager.v0.PackageManagerV0.verify"></a>

#### verify

```python
def verify() -> int
```

Verify fingerprints and outer hash of all available packages.

<a id="aea.package_manager.v0.PackageManagerV0.json"></a>

#### json

```python
@property
def json() -> OrderedDictType
```

Json representation.

<a id="aea.package_manager.v0.PackageManagerV0.from_dir"></a>

#### from`_`dir

```python
@classmethod
def from_dir(
    cls,
    packages_dir: Path,
    config_loader: ConfigLoaderCallableType = load_configuration
) -> "PackageManagerV0"
```

Initialize from packages directory.

