<a id="aea.package_manager.v1"></a>

# aea.package`_`manager.v1

Package manager V1

<a id="aea.package_manager.v1.PackageManagerV1"></a>

## PackageManagerV1 Objects

```python
class PackageManagerV1(BasePackageManager)
```

Package manager V1

<a id="aea.package_manager.v1.PackageManagerV1.LocalPackageType"></a>

## LocalPackageType Objects

```python
class LocalPackageType(Enum)
```

Local package types.

<a id="aea.package_manager.v1.PackageManagerV1.__init__"></a>

#### `__`init`__`

```python
def __init__(path: Path,
             dev_packages: Optional[PackageIdToHashMapping] = None,
             third_party_packages: Optional[PackageIdToHashMapping] = None,
             config_loader: ConfigLoaderCallableType = load_configuration,
             logger: Optional[logging.Logger] = None) -> None
```

Initialize object.

<a id="aea.package_manager.v1.PackageManagerV1.dev_packages"></a>

#### dev`_`packages

```python
@property
def dev_packages() -> PackageIdToHashMapping
```

Returns mappings of package ids -> package hash

<a id="aea.package_manager.v1.PackageManagerV1.third_party_packages"></a>

#### third`_`party`_`packages

```python
@property
def third_party_packages() -> PackageIdToHashMapping
```

Returns mappings of package ids -> package hash

<a id="aea.package_manager.v1.PackageManagerV1.all_packages"></a>

#### all`_`packages

```python
@property
def all_packages() -> PackageIdToHashMapping
```

Return all packages.

<a id="aea.package_manager.v1.PackageManagerV1.get_package_hash"></a>

#### get`_`package`_`hash

```python
def get_package_hash(package_id: PackageId) -> Optional[str]
```

Get package hash.

<a id="aea.package_manager.v1.PackageManagerV1.is_third_party_package"></a>

#### is`_`third`_`party`_`package

```python
def is_third_party_package(package_id: PackageId) -> bool
```

Check if a package is third party package.

<a id="aea.package_manager.v1.PackageManagerV1.is_dev_package"></a>

#### is`_`dev`_`package

```python
def is_dev_package(package_id: PackageId) -> bool
```

Check if a package is third party package.

<a id="aea.package_manager.v1.PackageManagerV1.add_package"></a>

#### add`_`package

```python
def add_package(package_id: PackageId,
                with_dependencies: bool = False,
                allow_update: bool = False) -> "PackageManagerV1"
```

Add package.

<a id="aea.package_manager.v1.PackageManagerV1.register"></a>

#### register

```python
def register(package_path: Path,
             package_type: Optional[PackageType] = None) -> "PackageManagerV1"
```

Add package to the index.

<a id="aea.package_manager.v1.PackageManagerV1.sync"></a>

#### sync

```python
def sync(dev: bool = False,
         third_party: bool = True,
         update_packages: bool = False,
         update_hashes: bool = False,
         sources: Optional[List[str]] = None) -> "PackageManagerV1"
```

Sync local packages to the remote registry.

<a id="aea.package_manager.v1.PackageManagerV1.update_package_hashes"></a>

#### update`_`package`_`hashes

```python
def update_package_hashes(selector_prompt: Optional[Callable[[], str]] = None,
                          skip_missing: bool = False) -> "PackageManagerV1"
```

Update package.json file.

<a id="aea.package_manager.v1.PackageManagerV1.verify"></a>

#### verify

```python
def verify() -> int
```

Verify fingerprints and outer hash of all available packages.

<a id="aea.package_manager.v1.PackageManagerV1.json"></a>

#### json

```python
@property
def json() -> OrderedDictType
```

Json representation

<a id="aea.package_manager.v1.PackageManagerV1.from_json"></a>

#### from`_`json

```python
@classmethod
def from_json(
    cls,
    packages: Dict[str, Dict[str, str]],
    packages_dir: Optional[Path] = None,
    config_loader: ConfigLoaderCallableType = load_configuration
) -> "PackageManagerV1"
```

Initialize from json object

<a id="aea.package_manager.v1.PackageManagerV1.from_dir"></a>

#### from`_`dir

```python
@classmethod
def from_dir(
    cls,
    packages_dir: Path,
    config_loader: ConfigLoaderCallableType = load_configuration
) -> "PackageManagerV1"
```

Initialize from packages directory.

